/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionMode {
    private static final PairConsumer<ExecutionMode, String> NOOP_CONSUMER = (mode, s) -> {};
    private final boolean myCancelable;
    private final String myTitle;
    private final String myTitle2;
    private final boolean myRunWithModal;
    private final boolean myRunInBG;
    private final JComponent myProgressParentComponent;
    private BooleanSupplier myShouldCancelFun;
    private final Object CANCEL_FUN_LOCK = new Object();
    private final List<ProcessListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public ExecutionMode(boolean cancelable, @Nullable String title, @Nullable String title2, boolean runInBG, boolean runWithModal, JComponent progressParentComponent) {
        this.myCancelable = cancelable;
        this.myTitle = title;
        this.myTitle2 = title2;
        this.myRunInBG = runInBG;
        this.myRunWithModal = runWithModal;
        this.myProgressParentComponent = progressParentComponent;
    }

    public int getTimeout() {
        return -1;
    }

    public void onTimeout(@NotNull ProcessHandler processHandler2, @NotNull String commandLineString, @NotNull ProcessOutput outputCollected, @Nullable Throwable invocatorStack) {
        if (processHandler2 == null) {
            ExecutionMode.$$$reportNull$$$0(0);
        }
        if (commandLineString == null) {
            ExecutionMode.$$$reportNull$$$0(1);
        }
        if (outputCollected == null) {
            ExecutionMode.$$$reportNull$$$0(2);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2019.3")
    @NotNull
    public PairConsumer<ExecutionMode, String> getTimeoutCallback() {
        PairConsumer<ExecutionMode, String> pairConsumer = NOOP_CONSUMER;
        if (pairConsumer == null) {
            ExecutionMode.$$$reportNull$$$0(3);
        }
        return pairConsumer;
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    @Nullable
    public String getTitle2() {
        return this.myTitle2;
    }

    public boolean cancelable() {
        return this.myCancelable;
    }

    public boolean inBackGround() {
        return this.myRunInBG;
    }

    public boolean withModalProgress() {
        return this.myRunWithModal;
    }

    public JComponent getProgressParentComponent() {
        return this.myProgressParentComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public BooleanSupplier shouldCancelFun() {
        Object object = this.CANCEL_FUN_LOCK;
        synchronized (object) {
            return this.myShouldCancelFun;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShouldCancelFun(BooleanSupplier shouldCancelFun) {
        Object object = this.CANCEL_FUN_LOCK;
        synchronized (object) {
            this.myShouldCancelFun = shouldCancelFun;
        }
    }

    public void addProcessListener(@NotNull ProcessListener listener2) {
        if (listener2 == null) {
            ExecutionMode.$$$reportNull$$$0(4);
        }
        this.myListeners.add(listener2);
    }

    @NotNull
    public List<ProcessListener> getProcessListeners() {
        List<ProcessListener> list2 = this.myListeners;
        if (list2 == null) {
            ExecutionMode.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineString";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputCollected";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/ExecutionMode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/ExecutionMode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeoutCallback";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "onTimeout";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addProcessListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

