/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.hints.CollectorWithSettings;
import com.intellij.codeInsight.hints.HintUtils;
import com.intellij.codeInsight.hints.InlayHintsPass;
import com.intellij.codeInsight.hints.InlayHintsSettings;
import com.intellij.codeInsight.hints.InlayHintsUtilsKt;
import com.intellij.codeInsight.hints.ProviderWithSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u00012\u00020\u0002:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "()V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "intellij.platform.lang.impl"})
public final class InlayHintsPassFactory
implements TextEditorHighlightingPassFactory,
TextEditorHighlightingPassFactoryRegistrar {
    private static final Key<Long> INLAY_PSI_MODIFICATION_STAMP;
    public static final Companion Companion;

    @Override
    public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)registrar, (String)"registrar");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        return com.intellij.codeInsight.hints.InlayHintsPassFactory$Companion.createPass$default(Companion, file2, editor, false, 4, null);
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"inlay.hints.stamp");
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"Key.create<Long>(\"inlay.hints.stamp\")");
        INLAY_PSI_MODIFICATION_STAMP = key;
    }

    @JvmStatic
    public static final void restartDaemon() {
        Companion.restartDaemon();
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0010H\u0007R\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/codeInsight/hints/InlayHintsPassFactory$Companion;", "", "()V", "INLAY_PSI_MODIFICATION_STAMP", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "createPass", "Lcom/intellij/codeInsight/hints/InlayHintsPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "forceRefresh", "", "forceHintsUpdateOnNextPass", "", "restartDaemon", "intellij.platform.lang.impl"})
    public static final class Companion {
        public final void forceHintsUpdateOnNextPass() {
            EditorFactory editorFactory = EditorFactory.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)editorFactory, (String)"EditorFactory.getInstance()");
            for (Editor editor : editorFactory.getAllEditors()) {
                editor.putUserData(INLAY_PSI_MODIFICATION_STAMP, null);
            }
            this.restartDaemon();
        }

        @JvmStatic
        public final void restartDaemon() {
            ProjectManager projectManager = ProjectManager.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectManager, (String)"ProjectManager.getInstance()");
            Project[] projectArray = projectManager.getOpenProjects();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectArray, (String)"ProjectManager.getInstance().openProjects");
            Project[] $this$forEach$iv = projectArray;
            boolean $i$f$forEach = false;
            Project[] projectArray2 = $this$forEach$iv;
            int n = projectArray2.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile[] $this$forEach$iv2;
                FileEditorManager fileEditorManager;
                Project element$iv;
                Project project = element$iv = projectArray2[i];
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)PsiManager.getInstance((Project)project), (String)"PsiManager.getInstance(project)");
                DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)project);
                FileEditorManager fileEditorManager2 = fileEditorManager = FileEditorManager.getInstance((Project)project);
                Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager2, (String)"fileEditorManager");
                Intrinsics.checkExpressionValueIsNotNull((Object)fileEditorManager2.getSelectedFiles(), (String)"fileEditorManager.selectedFiles");
                boolean $i$f$forEach2 = false;
                VirtualFile[] virtualFileArray = $this$forEach$iv2;
                int n2 = virtualFileArray.length;
                for (int j = 0; j < n2; ++j) {
                    PsiFile psiFile;
                    PsiManager psiManager;
                    VirtualFile element$iv2;
                    VirtualFile file2 = element$iv2 = virtualFileArray[j];
                    boolean bl2 = false;
                    if (psiManager.findFile(file2) == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    PsiFile it = psiFile;
                    boolean bl5 = false;
                    daemonCodeAnalyzer.restart(it);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final InlayHintsPass createPass(@NotNull PsiFile file2, @NotNull Editor editor, boolean forceRefresh) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            if (editor.isOneLineMode()) {
                return null;
            }
            PsiManager psiManager = file2.getManager();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiManager, (String)"file.manager");
            PsiModificationTracker psiModificationTracker = psiManager.getModificationTracker();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiModificationTracker, (String)"file.manager.modificationTracker");
            long currentStamp = psiModificationTracker.getModificationCount();
            Long savedStamp = (Long)editor.getUserData(INLAY_PSI_MODIFICATION_STAMP);
            if (!forceRefresh && savedStamp != null && savedStamp == currentStamp) {
                return null;
            }
            InlayHintsSettings settings = (InlayHintsSettings)ServiceManager.getService(InlayHintsSettings.class);
            Language language = file2.getLanguage();
            Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"file.language");
            Language language2 = language;
            Project project = file2.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            Iterable $this$mapNotNull$iv = HintUtils.INSTANCE.getHintProvidersForLanguage(language2, project);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                CollectorWithSettings collectorWithSettings;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                ProviderWithSettings it = (ProviderWithSettings)element$iv$iv;
                boolean bl2 = false;
                if (InlayHintsUtilsKt.getCollectorWrapperFor(it, file2, editor, language2) == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                CollectorWithSettings it$iv$iv = collectorWithSettings;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List collectors = (List)destination$iv$iv;
            PsiElement psiElement = (PsiElement)file2;
            InlayHintsSettings inlayHintsSettings = settings;
            Intrinsics.checkExpressionValueIsNotNull((Object)inlayHintsSettings, (String)"settings");
            return new InlayHintsPass(psiElement, collectors, editor, inlayHintsSettings);
        }

        public static /* synthetic */ InlayHintsPass createPass$default(Companion companion, PsiFile psiFile, Editor editor, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.createPass(psiFile, editor, bl);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

