/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.HectorComponent;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.internal.statistic.service.fus.collectors.UIEventId;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ObjectUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import org.jetbrains.annotations.NotNull;

public class DaemonEditorPopup
extends PopupHandler {
    private final PsiFile myPsiFile;

    DaemonEditorPopup(PsiFile psiFile) {
        this.myPsiFile = psiFile;
    }

    public void invokePopup(final Component comp, final int x, final int y) {
        if (ApplicationManager.getApplication() == null) {
            return;
        }
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcuts = keymap.getShortcuts("GotoNextError");
        String shortcutText = shortcuts.length > 0 ? " (" + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + ")" : "";
        DefaultActionGroup gotoGroup = new DefaultActionGroup("'Next Error' Action" + shortcutText + " Goes Through", true);
        gotoGroup.add((AnAction)new ToggleAction(EditorBundle.message((String)"errors.panel.go.to.errors.first.radio", (Object[])new Object[0])){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                return DaemonCodeAnalyzerSettings.getInstance().isNextErrorActionGoesToErrorsFirst();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                DaemonCodeAnalyzerSettings.getInstance().setNextErrorActionGoesToErrorsFirst(state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonEditorPopup$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        gotoGroup.add((AnAction)new ToggleAction(EditorBundle.message((String)"errors.panel.go.to.next.error.warning.radio", (Object[])new Object[0])){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                return !DaemonCodeAnalyzerSettings.getInstance().isNextErrorActionGoesToErrorsFirst();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    2.$$$reportNull$$$0(1);
                }
                DaemonCodeAnalyzerSettings.getInstance().setNextErrorActionGoesToErrorsFirst(!state);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonEditorPopup$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        actionGroup.add((AnAction)gotoGroup);
        actionGroup.addSeparator();
        actionGroup.add(new AnAction(EditorBundle.message((String)"customize.highlighting.level.menu.item", (Object[])new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e) {
                PsiFile psiFile;
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                if ((psiFile = DaemonEditorPopup.this.myPsiFile) == null) {
                    return;
                }
                HectorComponent component = new HectorComponent((PsiFile)ObjectUtils.assertNotNull((Object)psiFile));
                Dimension dimension = component.getPreferredSize();
                Point point = new Point(x, y);
                component.showComponent(new RelativePoint(comp, new Point(point.x - dimension.width, point.y)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/codeInsight/daemon/impl/DaemonEditorPopup$3", "actionPerformed"));
            }
        });
        actionGroup.addSeparator();
        actionGroup.add((AnAction)new ToggleAction(IdeBundle.message((String)"checkbox.show.editor.preview.popup", (Object[])new Object[0])){

            public boolean isSelected(@NotNull AnActionEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                return UISettings.getInstance().getShowEditorToolTip();
            }

            public void setSelected(@NotNull AnActionEvent e, boolean state) {
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                UISettings.getInstance().setShowEditorToolTip(state);
                UISettings.getInstance().fireUISettingsChanged();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonEditorPopup$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSelected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "setSelected";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ActionPopupMenu editorPopup = actionManager.createActionPopupMenu("RightEditorGutterPopup", (ActionGroup)actionGroup);
        PsiFile file2 = this.myPsiFile;
        if (file2 != null && DaemonCodeAnalyzer.getInstance((Project)this.myPsiFile.getProject()).isHighlightingAvailable(file2)) {
            UIEventLogger.logUIEvent(UIEventId.DaemonEditorPopupInvoked);
            editorPopup.getComponent().show(comp, x, y);
        }
    }
}

