/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.Queryable;
import com.intellij.openapi.util.Comparing;
import com.intellij.reference.SoftReference;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.PlaceProvider;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.content.AlertIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TabInfo
implements Queryable,
PlaceProvider<String> {
    public static final String ACTION_GROUP = "actionGroup";
    public static final String ICON = "icon";
    public static final String TAB_COLOR = "color";
    public static final String COMPONENT = "component";
    public static final String TEXT = "text";
    public static final String TAB_ACTION_GROUP = "tabActionGroup";
    public static final String ALERT_ICON = "alertIcon";
    public static final String ALERT_STATUS = "alertStatus";
    public static final String HIDDEN = "hidden";
    public static final String ENABLED = "enabled";
    private JComponent myComponent;
    private JComponent myPreferredFocusableComponent;
    private ActionGroup myGroup;
    private final PropertyChangeSupport myChangeSupport = new PropertyChangeSupport(this);
    private Icon myIcon;
    private String myPlace;
    private Object myObject;
    private JComponent mySideComponent;
    private Reference<JComponent> myLastFocusOwner;
    private ActionGroup myTabLabelActions;
    private String myTabActionPlace;
    private AlertIcon myAlertIcon;
    private int myBlinkCount;
    private boolean myAlertRequested;
    private boolean myHidden;
    private JComponent myActionsContextComponent;
    private final SimpleColoredText myText = new SimpleColoredText();
    private String myTooltipText;
    private int myDefaultStyle = -1;
    private Color myDefaultForeground;
    private Color myDefaultWaveColor;
    private SimpleTextAttributes myDefaultAttributes;
    private static final AlertIcon DEFAULT_ALERT_ICON = new AlertIcon(AllIcons.Nodes.TabAlert);
    private boolean myEnabled = true;
    private Color myTabColor;
    private Queryable myQueryable;
    private DragOutDelegate myDragOutDelegate;
    private WeakReference<TabInfo> myPreviousSelection = new WeakReference<Object>(null);

    public TabInfo(JComponent component) {
        this.myComponent = component;
        this.myPreferredFocusableComponent = component;
    }

    public PropertyChangeSupport getChangeSupport() {
        return this.myChangeSupport;
    }

    @NotNull
    public TabInfo setText(@NotNull String text) {
        ArrayList attributes;
        if (text == null) {
            TabInfo.$$$reportNull$$$0(0);
        }
        TextAttributes textAttributes = (attributes = this.myText.getAttributes()).size() == 1 ? ((SimpleTextAttributes)attributes.get(0)).toTextAttributes() : null;
        TextAttributes defaultAttributes = this.getDefaultAttributes().toTextAttributes();
        if (!this.myText.toString().equals(text) || !Comparing.equal((Object)textAttributes, (Object)defaultAttributes)) {
            this.clearText(false);
            this.append(text, this.getDefaultAttributes());
        }
        TabInfo tabInfo = this;
        if (tabInfo == null) {
            TabInfo.$$$reportNull$$$0(1);
        }
        return tabInfo;
    }

    @NotNull
    private SimpleTextAttributes getDefaultAttributes() {
        SimpleTextAttributes attributes = this.myDefaultAttributes;
        if (attributes == null) {
            this.myDefaultAttributes = attributes = new SimpleTextAttributes(this.myDefaultStyle != -1 ? this.myDefaultStyle : 0, this.myDefaultForeground, this.myDefaultWaveColor);
        }
        SimpleTextAttributes simpleTextAttributes = attributes;
        if (simpleTextAttributes == null) {
            TabInfo.$$$reportNull$$$0(2);
        }
        return simpleTextAttributes;
    }

    public TabInfo clearText(boolean invalidate) {
        String old = this.myText.toString();
        this.myText.clear();
        if (invalidate) {
            this.myChangeSupport.firePropertyChange(TEXT, old, this.myText.toString());
        }
        return this;
    }

    public TabInfo append(@NotNull String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            TabInfo.$$$reportNull$$$0(3);
        }
        if (attributes == null) {
            TabInfo.$$$reportNull$$$0(4);
        }
        String old = this.myText.toString();
        this.myText.append(fragment, attributes);
        this.myChangeSupport.firePropertyChange(TEXT, old, this.myText.toString());
        return this;
    }

    @NotNull
    public TabInfo setIcon(Icon icon) {
        Icon old = this.myIcon;
        if (!IconDeferrer.getInstance().equalIcons(old, icon)) {
            this.myIcon = icon;
            this.myChangeSupport.firePropertyChange(ICON, old, icon);
        }
        TabInfo tabInfo = this;
        if (tabInfo == null) {
            TabInfo.$$$reportNull$$$0(5);
        }
        return tabInfo;
    }

    public TabInfo setComponent(Component c) {
        if (this.myComponent == c) {
            return this;
        }
        JComponent old = this.myComponent;
        this.myComponent = (JComponent)c;
        this.myChangeSupport.firePropertyChange(COMPONENT, old, this.myComponent);
        return this;
    }

    public ActionGroup getGroup() {
        return this.myGroup;
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    public String getText() {
        return this.myText.toString();
    }

    public SimpleColoredText getColoredText() {
        return this.myText;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    @Override
    public String getPlace() {
        return this.myPlace;
    }

    public TabInfo setSideComponent(JComponent comp) {
        this.mySideComponent = comp;
        return this;
    }

    public JComponent getSideComponent() {
        return this.mySideComponent;
    }

    public TabInfo setActions(ActionGroup group, String place) {
        ActionGroup old = this.myGroup;
        this.myGroup = group;
        this.myPlace = place;
        this.myChangeSupport.firePropertyChange(ACTION_GROUP, old, this.myGroup);
        return this;
    }

    public TabInfo setActionsContextComponent(JComponent c) {
        this.myActionsContextComponent = c;
        return this;
    }

    public JComponent getActionsContextComponent() {
        return this.myActionsContextComponent;
    }

    public TabInfo setObject(Object object) {
        this.myObject = object;
        return this;
    }

    public Object getObject() {
        return this.myObject;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myPreferredFocusableComponent != null ? this.myPreferredFocusableComponent : this.myComponent;
    }

    public TabInfo setPreferredFocusableComponent(JComponent component) {
        this.myPreferredFocusableComponent = component;
        return this;
    }

    public void setLastFocusOwner(JComponent owner) {
        this.myLastFocusOwner = owner == null ? null : new WeakReference<JComponent>(owner);
    }

    public ActionGroup getTabLabelActions() {
        return this.myTabLabelActions;
    }

    public String getTabActionPlace() {
        return this.myTabActionPlace;
    }

    public TabInfo setTabLabelActions(ActionGroup tabActions, @NotNull String place) {
        if (place == null) {
            TabInfo.$$$reportNull$$$0(6);
        }
        ActionGroup old = this.myTabLabelActions;
        this.myTabLabelActions = tabActions;
        this.myTabActionPlace = place;
        this.myChangeSupport.firePropertyChange(TAB_ACTION_GROUP, old, this.myTabLabelActions);
        return this;
    }

    @Nullable
    public JComponent getLastFocusOwner() {
        return (JComponent)SoftReference.dereference(this.myLastFocusOwner);
    }

    public TabInfo setAlertIcon(AlertIcon alertIcon) {
        AlertIcon old = this.myAlertIcon;
        this.myAlertIcon = alertIcon;
        this.myChangeSupport.firePropertyChange(ALERT_ICON, old, this.myAlertIcon);
        return this;
    }

    public void fireAlert() {
        this.myAlertRequested = true;
        this.myChangeSupport.firePropertyChange(ALERT_STATUS, null, (Object)true);
    }

    public void stopAlerting() {
        this.myAlertRequested = false;
        this.myChangeSupport.firePropertyChange(ALERT_STATUS, null, (Object)false);
    }

    public int getBlinkCount() {
        return this.myBlinkCount;
    }

    public void setBlinkCount(int blinkCount) {
        this.myBlinkCount = blinkCount;
    }

    public String toString() {
        return this.getText();
    }

    public AlertIcon getAlertIcon() {
        return this.myAlertIcon == null ? DEFAULT_ALERT_ICON : this.myAlertIcon;
    }

    public void resetAlertRequest() {
        this.myAlertRequested = false;
    }

    public boolean isAlertRequested() {
        return this.myAlertRequested;
    }

    public void setHidden(boolean hidden) {
        boolean old = this.myHidden;
        this.myHidden = hidden;
        this.myChangeSupport.firePropertyChange(HIDDEN, old, this.myHidden);
    }

    public boolean isHidden() {
        return this.myHidden;
    }

    public void setEnabled(boolean enabled) {
        boolean old = this.myEnabled;
        this.myEnabled = enabled;
        this.myChangeSupport.firePropertyChange(ENABLED, old, this.myEnabled);
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public TabInfo setDefaultStyle(@SimpleTextAttributes.StyleAttributeConstant int style) {
        this.myDefaultStyle = style;
        this.myDefaultAttributes = null;
        this.update();
        return this;
    }

    public TabInfo setDefaultForeground(Color fg) {
        this.myDefaultForeground = fg;
        this.myDefaultAttributes = null;
        this.update();
        return this;
    }

    public Color getDefaultForeground() {
        return this.myDefaultForeground;
    }

    public TabInfo setDefaultWaveColor(Color waveColor) {
        this.myDefaultWaveColor = waveColor;
        this.myDefaultAttributes = null;
        this.update();
        return this;
    }

    private void update() {
        this.setText(this.getText());
    }

    public void revalidate() {
        this.myDefaultAttributes = null;
        this.update();
    }

    @NotNull
    public TabInfo setTooltipText(String text) {
        String old = this.myTooltipText;
        if (!Comparing.equal((String)old, (String)text)) {
            this.myTooltipText = text;
            this.myChangeSupport.firePropertyChange(TEXT, old, this.myTooltipText);
        }
        TabInfo tabInfo = this;
        if (tabInfo == null) {
            TabInfo.$$$reportNull$$$0(7);
        }
        return tabInfo;
    }

    public String getTooltipText() {
        return this.myTooltipText;
    }

    @NotNull
    public TabInfo setTabColor(Color color) {
        Color old = this.myTabColor;
        if (!Comparing.equal((Object)color, (Object)old)) {
            this.myTabColor = color;
            this.myChangeSupport.firePropertyChange(TAB_COLOR, old, color);
        }
        TabInfo tabInfo = this;
        if (tabInfo == null) {
            TabInfo.$$$reportNull$$$0(8);
        }
        return tabInfo;
    }

    public Color getTabColor() {
        return this.myTabColor;
    }

    @NotNull
    public TabInfo setTestableUi(Queryable queryable) {
        this.myQueryable = queryable;
        TabInfo tabInfo = this;
        if (tabInfo == null) {
            TabInfo.$$$reportNull$$$0(9);
        }
        return tabInfo;
    }

    @Override
    public void putInfo(@NotNull Map<String, String> info) {
        if (info == null) {
            TabInfo.$$$reportNull$$$0(10);
        }
        if (this.myQueryable != null) {
            this.myQueryable.putInfo(info);
        }
    }

    @NotNull
    public TabInfo setDragOutDelegate(DragOutDelegate delegate) {
        this.myDragOutDelegate = delegate;
        TabInfo tabInfo = this;
        if (tabInfo == null) {
            TabInfo.$$$reportNull$$$0(11);
        }
        return tabInfo;
    }

    public boolean canBeDraggedOut() {
        return this.myDragOutDelegate != null;
    }

    public DragOutDelegate getDragOutDelegate() {
        return this.myDragOutDelegate;
    }

    public void setPreviousSelection(@Nullable TabInfo previousSelection) {
        this.myPreviousSelection = new WeakReference<TabInfo>(previousSelection);
    }

    @Nullable
    public TabInfo getPreviousSelection() {
        return (TabInfo)this.myPreviousSelection.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = TEXT;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tabs/TabInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tabs/TabInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "setText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultAttributes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "setIcon";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setTooltipText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "setTabColor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setTestableUi";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "setDragOutDelegate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setTabLabelActions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface DragOutDelegate {
        public void dragOutStarted(@NotNull MouseEvent var1, @NotNull TabInfo var2);

        public void processDragOut(@NotNull MouseEvent var1, @NotNull TabInfo var2);

        public void dragOutFinished(@NotNull MouseEvent var1, TabInfo var2);

        public void dragOutCancelled(TabInfo var1);
    }
}

