/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.hierarchy;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.hierarchy.OWLHierarchyManager;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.OWLPropertyHierarchyProvider;
import org.protege.editor.owl.ui.view.AbstractOWLEntityHierarchyViewComponent;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class OWLPropertyHierarchyViewComponent
extends AbstractOWLEntityHierarchyViewComponent<OWLEntity> {
    private OWLPropertyHierarchyProvider hierarchyProvider;

    @Override
    protected OWLObjectHierarchyProvider<OWLEntity> getHierarchyProvider() {
        if (this.hierarchyProvider == null) {
            OWLModelManager modelManager = this.getOWLModelManager();
            OWLHierarchyManager hierarchyManager = modelManager.getOWLHierarchyManager();
            this.hierarchyProvider = new OWLPropertyHierarchyProvider(modelManager.getOWLOntologyManager(), hierarchyManager.getOWLObjectPropertyHierarchyProvider(), hierarchyManager.getOWLDataPropertyHierarchyProvider(), hierarchyManager.getOWLAnnotationPropertyHierarchyProvider());
        }
        return this.hierarchyProvider;
    }

    @Override
    protected void performExtraInitialisation() throws Exception {
        this.getTree().setOWLObjectComparator((o1, o2) -> {
            if (o1 instanceof OWLObjectProperty) {
                if (!(o2 instanceof OWLObjectProperty)) {
                    return -1;
                }
            } else {
                if (o1 instanceof OWLDataProperty) {
                    if (o2 instanceof OWLObjectProperty) {
                        return 1;
                    }
                    return -1;
                }
                if (o2 instanceof OWLObjectProperty) {
                    return 1;
                }
                if (o2 instanceof OWLDataProperty) {
                    return 1;
                }
            }
            String s1 = this.getOWLModelManager().getRendering((OWLObject)o1);
            String s2 = this.getOWLModelManager().getRendering((OWLObject)o2);
            return s1.compareToIgnoreCase(s2);
        });
    }

    @Override
    protected OWLObject updateView() {
        return this.getTree().getSelectedOWLObject();
    }

    @Override
    public List<OWLEntity> find(String match) {
        return Collections.emptyList();
    }

    @Override
    protected Optional<OWLObjectHierarchyProvider<OWLEntity>> getInferredHierarchyProvider() {
        return Optional.empty();
    }
}

