"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var scale_band_1 = require("../../../utils/scales/scale_band");
var scale_continuous_1 = require("../../../utils/scales/scale_continuous");
var scales_1 = require("../../../utils/scales/scales");
/**
 * Count the max number of bars in cluster value.
 * Doesn't take in consideration areas, lines or points.
 * @param stacked all the stacked formatted dataseries
 * @param nonStacked all the non-stacked formatted dataseries
 */
function countBarsInCluster(stacked, nonStacked) {
    // along x axis, we count one "space" per bar series.
    // we ignore the points, areas, lines as they are
    // aligned with the x value and doesn't occupy space
    var nonStackedBarsInCluster = nonStacked.reduce(function (acc, ns) {
        return acc + ns.counts.barSeries;
    }, 0);
    // count stacked bars groups as 1 per group
    var stackedBarsInCluster = stacked.reduce(function (acc, ns) {
        return acc + (ns.counts.barSeries > 0 ? 1 : 0);
    }, 0);
    var totalBarsInCluster = nonStackedBarsInCluster + stackedBarsInCluster;
    return {
        nonStackedBarsInCluster: nonStackedBarsInCluster,
        stackedBarsInCluster: stackedBarsInCluster,
        totalBarsInCluster: totalBarsInCluster,
    };
}
exports.countBarsInCluster = countBarsInCluster;
function getBandScaleRange(isInverse, isSingleValueHistogram, minRange, maxRange, bandwidth) {
    var rangeEndOffset = isSingleValueHistogram ? 0 : bandwidth;
    var start = isInverse ? minRange - rangeEndOffset : minRange;
    var end = isInverse ? maxRange : maxRange - rangeEndOffset;
    return { start: start, end: end };
}
/**
 * Compute the x scale used to align geometries to the x axis.
 * @param xDomain the x domain
 * @param totalBarsInCluster the total number of grouped series
 * @param axisLength the length of the x axis
 */
function computeXScale(options) {
    var xDomain = options.xDomain, totalBarsInCluster = options.totalBarsInCluster, range = options.range, barsPadding = options.barsPadding, enableHistogramMode = options.enableHistogramMode, ticks = options.ticks;
    var scaleType = xDomain.scaleType, minInterval = xDomain.minInterval, domain = xDomain.domain, isBandScale = xDomain.isBandScale, timeZone = xDomain.timeZone;
    var rangeDiff = Math.abs(range[1] - range[0]);
    var isInverse = range[1] < range[0];
    if (scaleType === scales_1.ScaleType.Ordinal) {
        var dividend = totalBarsInCluster > 0 ? totalBarsInCluster : 1;
        var bandwidth = rangeDiff / (domain.length * dividend);
        return new scale_band_1.ScaleBand(domain, range, bandwidth, barsPadding);
    }
    else {
        if (isBandScale) {
            var _a = __read(domain, 2), domainMin = _a[0], domainMax = _a[1];
            var isSingleValueHistogram = !!enableHistogramMode && domainMax - domainMin === 0;
            var adjustedDomainMax = isSingleValueHistogram ? domainMin + minInterval : domainMax;
            var adjustedDomain = [domainMin, adjustedDomainMax];
            var intervalCount = (adjustedDomain[1] - adjustedDomain[0]) / minInterval;
            var intervalCountOffest = isSingleValueHistogram ? 0 : 1;
            var bandwidth = rangeDiff / (intervalCount + intervalCountOffest);
            var _b = getBandScaleRange(isInverse, isSingleValueHistogram, range[0], range[1], bandwidth), start = _b.start, end = _b.end;
            var scale = new scale_continuous_1.ScaleContinuous({
                type: scaleType,
                domain: adjustedDomain,
                range: [start, end],
            }, {
                bandwidth: bandwidth / totalBarsInCluster,
                minInterval: minInterval,
                timeZone: timeZone,
                totalBarsInCluster: totalBarsInCluster,
                barsPadding: barsPadding,
                ticks: ticks,
                isSingleValueHistogram: isSingleValueHistogram,
            });
            return scale;
        }
        else {
            return new scale_continuous_1.ScaleContinuous({ type: scaleType, domain: domain, range: range }, { bandwidth: 0, minInterval: minInterval, timeZone: timeZone, totalBarsInCluster: totalBarsInCluster, barsPadding: barsPadding, ticks: ticks });
        }
    }
}
exports.computeXScale = computeXScale;
/**
 * Compute the y scales, one per groupId for the y axis.
 * @param yDomains the y domains
 * @param axisLength the axisLength of the y axis
 */
function computeYScales(options) {
    var yScales = new Map();
    var yDomains = options.yDomains, range = options.range, ticks = options.ticks;
    yDomains.forEach(function (_a) {
        var type = _a.scaleType, domain = _a.domain, groupId = _a.groupId;
        var yScale = new scale_continuous_1.ScaleContinuous({
            type: type,
            domain: domain,
            range: range,
        }, {
            ticks: ticks,
        });
        yScales.set(groupId, yScale);
    });
    return yScales;
}
exports.computeYScales = computeYScales;
//# sourceMappingURL=scales.js.map