/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.orbspecific.jacorb.recoverycoordinators;

import com.arjuna.ats.internal.jts.ORBManager;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.iiop.IIOPProfile;
import org.omg.CORBA.portable.OutputStream;
import org.omg.ETF.Profile;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedProfile;
import org.omg.IOP.TaggedProfileHolder;

public class RecoverIOR {
    public static String newObjectKey(String ior, String Key2) {
        RecoverableParsedIOR pior = new RecoverableParsedIOR(ior);
        IOR new_ior = pior.newObjectKey(Key2);
        return RecoverIOR.iorToString(new_ior);
    }

    public static void printIORinfo(String ior) {
        RecoverableParsedIOR pior = new RecoverableParsedIOR(ior);
        pior.printInfo();
    }

    private static String iorToString(IOR ior) {
        try {
            CDROutputStream out = new CDROutputStream();
            out.write_boolean(false);
            IORHelper.write((OutputStream)out, (IOR)ior);
            byte[] bytes = out.getBufferCopy();
            StringBuffer sb = new StringBuffer("IOR:");
            for (int j = 0; j < bytes.length; ++j) {
                int b = bytes[j];
                if (b < 0) {
                    b += 256;
                }
                int n1 = (0xFF & b) / 16;
                int n2 = (0xFF & b) % 16;
                int c1 = n1 < 10 ? 48 + n1 : 97 + (n1 - 10);
                int c2 = n2 < 10 ? 48 + n2 : 97 + (n2 - 10);
                sb.append((char)c1);
                sb.append((char)c2);
            }
            return sb.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class RecoverableParsedIOR
    extends ParsedIOR {
        public RecoverableParsedIOR(String ior) {
            this((ORB)ORBManager.getORB().orb(), ior);
        }

        public RecoverableParsedIOR(ORB orb, String ior) {
            super(orb, ior);
        }

        public IOR newObjectKey(String objectId) {
            String the_object_key = new String(this.get_object_key());
            int position = the_object_key.indexOf("RecoveryManager");
            String new_object_key = the_object_key.substring(0, position).concat(objectId);
            IOR new_ior = new IOR();
            List profiles = this.getProfiles();
            new_ior.type_id = this.getTypeId();
            new_ior.profiles = new TaggedProfile[profiles.size()];
            for (int i = 0; i < profiles.size(); ++i) {
                IIOPProfile pb = (IIOPProfile)profiles.get(i);
                IIOPProfile new_pb = (IIOPProfile)pb.copy();
                new_pb.set_object_key(new_object_key.getBytes(StandardCharsets.UTF_8));
                new_ior.profiles[i] = new TaggedProfile();
                new_ior.profiles[i].tag = 0;
                TaggedProfileHolder holder = new TaggedProfileHolder(new_ior.profiles[i]);
                new_pb.marshal(holder, null);
                new_ior.profiles[i].profile_data = holder.value.profile_data;
            }
            return new_ior;
        }

        public IOR newIOR(String objectId) {
            String the_object_key = new String(this.get_object_key(), StandardCharsets.UTF_8);
            int position = the_object_key.indexOf("RecoveryManager");
            String new_object_key = the_object_key.substring(0, position).concat(objectId);
            IOR new_ior = ParsedIOR.createObjectIOR((Profile)this.getEffectiveProfile());
            return new_ior;
        }

        public void printInfo() {
            IIOPProfile profile = (IIOPProfile)this.getEffectiveProfile();
            System.out.println("\n Print some Information -------------");
            System.out.println("Object ID " + this.getIDString());
            System.out.println("Type Name " + this.getTypeId());
            System.out.println("Host Address " + profile.getAddress());
            System.out.println("Object Key " + new String(this.get_object_key()));
            System.out.println("\n\n");
        }
    }
}

