/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.protocol;

import java.util.ServiceLoader;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.message.impl.CoreMessagePersister;
import org.apache.activemq.artemis.core.persistence.Persister;
import org.apache.activemq.artemis.spi.core.protocol.ProtocolManagerFactory;
import org.jboss.logging.Logger;

public class MessagePersister
implements Persister<Message> {
    private static final Logger logger = Logger.getLogger(MessagePersister.class);
    private static final MessagePersister theInstance = new MessagePersister();
    private static final int MAX_PERSISTERS = 3;
    private static final Persister<Message>[] persisters = new Persister[3];

    public static void registerProtocol(ProtocolManagerFactory manager) {
        Persister<Message>[] messagePersisters = manager.getPersister();
        if (messagePersisters == null || messagePersisters.length == 0) {
            logger.debug((Object)("Cannot find persister for " + manager));
        } else {
            for (Persister<Message> p : messagePersisters) {
                MessagePersister.registerPersister(p);
            }
        }
    }

    public static void clearPersisters() {
        for (int i = 0; i < persisters.length; ++i) {
            MessagePersister.persisters[i] = null;
        }
    }

    public static Persister getPersister(byte id) {
        if (id == 0 || id > 3) {
            return null;
        }
        return persisters[id - 1];
    }

    public static void registerPersister(Persister<Message> persister) {
        if (persister != null) {
            assert (persister.getID() <= 3) : "You must update MessagePersister::MAX_PERSISTERS to a higher number";
            MessagePersister.persisters[persister.getID() - 1] = persister;
        }
    }

    public static MessagePersister getInstance() {
        return theInstance;
    }

    protected MessagePersister() {
    }

    public int getEncodeSize(Message record) {
        return 0;
    }

    public void encode(ActiveMQBuffer buffer, Message record) {
        buffer.writeByte(this.getID());
    }

    public Message decode(ActiveMQBuffer buffer, Message record) {
        byte protocol = buffer.readByte();
        Persister persister = MessagePersister.getPersister(protocol);
        if (persister == null) {
            throw new NullPointerException("couldn't find factory for type=" + protocol);
        }
        return (Message)persister.decode(buffer, (Object)record);
    }

    static {
        CoreMessagePersister persister = CoreMessagePersister.getInstance();
        MessagePersister.registerPersister((Persister<Message>)persister);
        ServiceLoader<ProtocolManagerFactory> protocols = ServiceLoader.load(ProtocolManagerFactory.class, MessagePersister.class.getClassLoader());
        for (ProtocolManagerFactory next : protocols) {
            MessagePersister.registerProtocol(next);
        }
    }
}

