/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.io.IOExtension;
import org.wildfly.extension.io.WorkerResourceDefinition;

public class IOSubsystemTransformers
implements ExtensionTransformerRegistration {
    static final ModelVersion VERSION_2_0 = ModelVersion.create((int)2, (int)0);
    static final ModelVersion VERSION_3_0 = ModelVersion.create((int)3, (int)0);

    public String getSubsystemName() {
        return "io";
    }

    public void registerTransformers(SubsystemTransformerRegistration registration) {
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)registration.getCurrentSubsystemVersion());
        this.buildTransformers_3_0(chainedBuilder.createBuilder(IOExtension.CURRENT_MODEL_VERSION, VERSION_3_0));
        this.buildTransformers_2_0(chainedBuilder.createBuilder(VERSION_3_0, VERSION_2_0));
        chainedBuilder.buildAndRegister(registration, (ModelVersion[][])new ModelVersion[][]{{VERSION_3_0, VERSION_2_0}});
    }

    private void buildTransformers_3_0(ResourceTransformationDescriptionBuilder builder) {
        ResourceTransformationDescriptionBuilder worker = builder.addChildResource(WorkerResourceDefinition.INSTANCE.getPathElement());
        ((AttributeTransformationDescriptionBuilder)worker.getAttributeBuilder().addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{WorkerResourceDefinition.WORKER_TASK_CORE_THREADS})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{WorkerResourceDefinition.WORKER_TASK_CORE_THREADS.getDefaultValue()}), new AttributeDefinition[]{WorkerResourceDefinition.WORKER_TASK_CORE_THREADS});
    }

    private void buildTransformers_2_0(ResourceTransformationDescriptionBuilder builder) {
        ResourceTransformationDescriptionBuilder worker = builder.addChildResource(WorkerResourceDefinition.INSTANCE.getPathElement());
        worker.rejectChildResource(PathElement.pathElement((String)"outbound-bind-address"));
        ((AttributeTransformationDescriptionBuilder)worker.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultValueAttributeConverter((AttributeDefinition)WorkerResourceDefinition.WORKER_TASK_KEEPALIVE), new AttributeDefinition[]{WorkerResourceDefinition.WORKER_TASK_KEEPALIVE})).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{WorkerResourceDefinition.STACK_SIZE, WorkerResourceDefinition.WORKER_IO_THREADS, WorkerResourceDefinition.WORKER_TASK_KEEPALIVE, WorkerResourceDefinition.WORKER_TASK_MAX_THREADS});
    }
}

