/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import org.apache.lucene.search.Query;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.engine.impl.LuceneHSQuery;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.spi.CustomTypeMetadata;
import org.hibernate.search.spi.IndexedTypeMap;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.SearchIntegrator;

public class LuceneQueryDescriptor
implements QueryDescriptor {
    private final Query luceneQuery;

    public LuceneQueryDescriptor(Query luceneQuery) {
        this.luceneQuery = luceneQuery;
    }

    @Override
    public HSQuery createHSQuery(SearchIntegrator integrator, IndexedTypeSet types) {
        ExtendedSearchIntegrator extendedIntegrator = integrator.unwrap(ExtendedSearchIntegrator.class);
        return new LuceneHSQuery(this.luceneQuery, extendedIntegrator, types);
    }

    @Override
    public HSQuery createHSQuery(SearchIntegrator integrator, IndexedTypeMap<CustomTypeMetadata> types) {
        ExtendedSearchIntegrator extendedIntegrator = integrator.unwrap(ExtendedSearchIntegrator.class);
        return new LuceneHSQuery(this.luceneQuery, extendedIntegrator, types);
    }

    public String toString() {
        return this.luceneQuery.toString();
    }
}

