/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.util;

import java.util.Set;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.remoting.transport.Transport;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.TopologyInfo;
import org.keycloak.models.KeycloakSession;

public class InfinispanUtil {
    public static final int MAXIMUM_REPLACE_RETRIES = 25;

    public static Set<RemoteStore> getRemoteStores(Cache ispnCache) {
        return ((PersistenceManager)ispnCache.getAdvancedCache().getComponentRegistry().getComponent(PersistenceManager.class)).getStores(RemoteStore.class);
    }

    public static RemoteCache getRemoteCache(Cache ispnCache) {
        Set<RemoteStore> remoteStores = InfinispanUtil.getRemoteStores(ispnCache);
        if (remoteStores.isEmpty()) {
            return null;
        }
        return remoteStores.iterator().next().getRemoteCache();
    }

    public static TopologyInfo getTopologyInfo(KeycloakSession session) {
        return ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getTopologyInfo();
    }

    public static boolean isCoordinator(Cache cache) {
        Transport transport = cache.getCacheManager().getTransport();
        return transport == null || transport.isCoordinator();
    }
}

