/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.model.keystore;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.picketlink.config.federation.AuthPropertyType;
import org.picketlink.config.federation.KeyProviderType;
import org.picketlink.identity.federation.core.impl.KeyStoreKeyManager;
import org.wildfly.extension.picketlink.federation.model.keystore.KeyStoreProviderResourceDefinition;
import org.wildfly.extension.picketlink.federation.service.FederationService;
import org.wildfly.extension.picketlink.federation.service.KeyStoreProviderService;

public class KeyStoreProviderAddHandler
extends AbstractAddStepHandler {
    public static final KeyStoreProviderAddHandler INSTANCE = new KeyStoreProviderAddHandler();

    private KeyStoreProviderAddHandler() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attributeDefinition : KeyStoreProviderResourceDefinition.INSTANCE.getAttributes()) {
            attributeDefinition.validateAndSet(operation, model);
        }
    }

    static void launchServices(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String federationAlias = pathAddress.subAddress(0, pathAddress.size() - 1).getLastElement().getValue();
        ModelNode relativeToNode = KeyStoreProviderResourceDefinition.RELATIVE_TO.resolveModelAttribute(context, model);
        String relativeTo = null;
        if (relativeToNode.isDefined()) {
            relativeTo = relativeToNode.asString();
        }
        String file = KeyStoreProviderResourceDefinition.FILE.resolveModelAttribute(context, model).asString();
        KeyStoreProviderService service = new KeyStoreProviderService(KeyStoreProviderAddHandler.toKeyProviderType(context, model), file, relativeTo);
        context.getServiceTarget().addService(KeyStoreProviderService.createServiceName(federationAlias), (Service)service).addDependency(FederationService.createServiceName(federationAlias), FederationService.class, service.getFederationService()).addDependency(PathManagerService.SERVICE_NAME, PathManager.class, service.getPathManager()).setInitialMode(ServiceController.Mode.PASSIVE).install();
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        KeyStoreProviderAddHandler.launchServices(context, operation, model);
    }

    static KeyProviderType toKeyProviderType(OperationContext context, ModelNode model) throws OperationFailedException {
        KeyProviderType keyProviderType = new KeyProviderType();
        keyProviderType.setClassName(KeyStoreKeyManager.class.getName());
        keyProviderType.setSigningAlias(KeyStoreProviderResourceDefinition.SIGN_KEY_ALIAS.resolveModelAttribute(context, model).asString());
        AuthPropertyType keyStorePass = new AuthPropertyType();
        keyStorePass.setKey("KeyStorePass");
        keyStorePass.setValue(KeyStoreProviderResourceDefinition.PASSWORD.resolveModelAttribute(context, model).asString());
        keyProviderType.add(keyStorePass);
        AuthPropertyType signingKeyPass = new AuthPropertyType();
        signingKeyPass.setKey("SigningKeyPass");
        signingKeyPass.setValue(KeyStoreProviderResourceDefinition.SIGN_KEY_PASSWORD.resolveModelAttribute(context, model).asString());
        keyProviderType.add(signingKeyPass);
        AuthPropertyType signingKeyAlias = new AuthPropertyType();
        signingKeyAlias.setKey("SigningKeyAlias");
        signingKeyAlias.setValue(KeyStoreProviderResourceDefinition.SIGN_KEY_ALIAS.resolveModelAttribute(context, model).asString());
        keyProviderType.add(signingKeyAlias);
        return keyProviderType;
    }
}

