/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.federation.metrics;

import org.jboss.security.audit.AuditEvent;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEvent;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEventType;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.wildfly.extension.picketlink.logging.PicketLinkLogger;

public class PicketLinkSubsystemMetrics
extends PicketLinkAuditHelper {
    private int createdAssertionsCount;
    private int responseToSPCount;
    private int errorResponseToSPCount;
    private int errorSignValidationCount;
    private int errorTrustedDomainCount;
    private int expiredAssertionsCount;
    private int loginInitCount;
    private int loginCompleteCount;
    private int requestFromIDPCount;
    private int responseFromIDPCount;
    private int requestToIDPCount;

    public PicketLinkSubsystemMetrics(String securityDomainName) throws ConfigurationException {
        super(securityDomainName);
    }

    public void audit(AuditEvent event) {
        PicketLinkAuditEvent picketLinkEvent = (PicketLinkAuditEvent)event;
        PicketLinkAuditEventType eventType = picketLinkEvent.getType();
        switch (eventType) {
            case CREATED_ASSERTION: {
                ++this.createdAssertionsCount;
                break;
            }
            case RESPONSE_TO_SP: {
                ++this.responseToSPCount;
                break;
            }
            case ERROR_RESPONSE_TO_SP: {
                ++this.errorResponseToSPCount;
                break;
            }
            case ERROR_SIG_VALIDATION: {
                ++this.errorSignValidationCount;
                break;
            }
            case ERROR_TRUSTED_DOMAIN: {
                ++this.errorTrustedDomainCount;
                break;
            }
            case EXPIRED_ASSERTION: {
                ++this.expiredAssertionsCount;
                break;
            }
            case LOGIN_INIT: {
                ++this.loginInitCount;
                break;
            }
            case LOGIN_COMPLETE: {
                ++this.loginCompleteCount;
                break;
            }
            case REQUEST_FROM_IDP: {
                ++this.requestFromIDPCount;
                break;
            }
            case REQUEST_TO_IDP: {
                ++this.requestToIDPCount;
                break;
            }
            case RESPONSE_FROM_IDP: {
                ++this.responseFromIDPCount;
                break;
            }
            default: {
                PicketLinkLogger.ROOT_LOGGER.federationIgnoringAuditEvent(eventType);
                return;
            }
        }
        super.audit((AuditEvent)picketLinkEvent);
    }

    public int getCreatedAssertionsCount() {
        return this.createdAssertionsCount;
    }

    public int getResponseToSPCount() {
        return this.responseToSPCount;
    }

    public int getErrorResponseToSPCount() {
        return this.errorResponseToSPCount;
    }

    public int getErrorSignValidationCount() {
        return this.errorSignValidationCount;
    }

    public int getErrorTrustedDomainCount() {
        return this.errorTrustedDomainCount;
    }

    public int getExpiredAssertionsCount() {
        return this.expiredAssertionsCount;
    }

    public int getLoginInitCount() {
        return this.loginInitCount;
    }

    public int getLoginCompleteCount() {
        return this.loginCompleteCount;
    }

    public int getRequestFromIDPCount() {
        return this.requestFromIDPCount;
    }

    public int getResponseFromIDPCount() {
        return this.responseFromIDPCount;
    }

    public int getRequestToIDPCount() {
        return this.requestToIDPCount;
    }
}

