/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.singleton;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.server.singleton.LocalSingletonServiceBuilder;
import org.wildfly.clustering.server.singleton.LocalSingletonServiceConfiguratorContext;
import org.wildfly.clustering.server.singleton.LocalSingletonServiceConfiguratorFactory;
import org.wildfly.clustering.server.singleton.LocalSingletonServiceConfiguratorFactoryContext;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.singleton.SingletonServiceBuilder;
import org.wildfly.clustering.singleton.SingletonServiceBuilderFactory;

public class LocalSingletonServiceBuilderFactory
extends LocalSingletonServiceConfiguratorFactory
implements SingletonServiceBuilderFactory {
    private final LegacyLocalSingletonServiceConfiguratorContext context;

    public LocalSingletonServiceBuilderFactory(LocalSingletonServiceConfiguratorFactoryContext context) {
        super(context);
        this.context = new LegacyLocalSingletonServiceConfiguratorContext(context);
    }

    public <T> SingletonServiceBuilder<T> createSingletonServiceBuilder(ServiceName name, Service<T> service) {
        return new LocalSingletonServiceBuilder<T>(name, service, this.context);
    }

    public <T> SingletonServiceBuilder<T> createSingletonServiceBuilder(ServiceName name, Service<T> primaryService, Service<T> backupService) {
        return this.createSingletonServiceBuilder(name, primaryService);
    }

    private class LegacyLocalSingletonServiceConfiguratorContext
    implements LocalSingletonServiceConfiguratorContext {
        private final LocalSingletonServiceConfiguratorFactoryContext context;

        LegacyLocalSingletonServiceConfiguratorContext(LocalSingletonServiceConfiguratorFactoryContext context) {
            this.context = context;
        }

        @Override
        public SupplierDependency<Group> getGroupDependency() {
            return new InjectedValueDependency(this.context.getGroupServiceName(), Group.class);
        }
    }
}

