/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.Date;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;

public class DefaultLogger
implements BuildLogger {
    public static final int LEFT_COLUMN_SIZE = 12;
    protected PrintStream out;
    protected PrintStream err;
    protected int msgOutputLevel = 0;
    private long startTime = System.currentTimeMillis();
    protected static final String lSep = StringUtils.LINE_SEP;
    protected boolean emacsMode = false;

    public void setMessageOutputLevel(int level) {
        this.msgOutputLevel = level;
    }

    public void setOutputPrintStream(PrintStream output) {
        this.out = new PrintStream(output, true);
    }

    public void setErrorPrintStream(PrintStream err) {
        this.err = new PrintStream(err, true);
    }

    public void setEmacsMode(boolean emacsMode) {
        this.emacsMode = emacsMode;
    }

    public void buildStarted(BuildEvent event) {
        this.startTime = System.currentTimeMillis();
    }

    static void throwableMessage(StringBuffer m, Throwable error, boolean verbose) {
        String msg2;
        String msg1;
        Throwable cause;
        while (error instanceof BuildException && (cause = error.getCause()) != null && (msg1 = error.toString()).endsWith(msg2 = cause.toString())) {
            m.append(msg1.substring(0, msg1.length() - msg2.length()));
            error = cause;
        }
        if (verbose || !(error instanceof BuildException)) {
            m.append(StringUtils.getStackTrace(error));
        } else {
            m.append(error).append(lSep);
        }
    }

    public void buildFinished(BuildEvent event) {
        Throwable error = event.getException();
        StringBuffer message = new StringBuffer();
        if (error == null) {
            message.append(StringUtils.LINE_SEP);
            message.append(this.getBuildSuccessfulMessage());
        } else {
            message.append(StringUtils.LINE_SEP);
            message.append(this.getBuildFailedMessage());
            message.append(StringUtils.LINE_SEP);
            DefaultLogger.throwableMessage(message, error, 3 <= this.msgOutputLevel);
        }
        message.append(StringUtils.LINE_SEP);
        message.append("Total time: ");
        message.append(DefaultLogger.formatTime(System.currentTimeMillis() - this.startTime));
        String msg = message.toString();
        if (error == null) {
            this.printMessage(msg, this.out, 3);
        } else {
            this.printMessage(msg, this.err, 0);
        }
        this.log(msg);
    }

    protected String getBuildFailedMessage() {
        return "BUILD FAILED";
    }

    protected String getBuildSuccessfulMessage() {
        return "BUILD SUCCESSFUL";
    }

    public void targetStarted(BuildEvent event) {
        if (2 <= this.msgOutputLevel && !event.getTarget().getName().equals("")) {
            String msg = String.format("%n%s:", event.getTarget().getName());
            this.printMessage(msg, this.out, event.getPriority());
            this.log(msg);
        }
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageLogged(BuildEvent event) {
        block13: {
            StringBuffer message;
            int priority;
            block12: {
                block14: {
                    priority = event.getPriority();
                    if (priority > this.msgOutputLevel) break block13;
                    message = new StringBuffer();
                    if (event.getTask() == null || this.emacsMode) break block14;
                    String name = event.getTask().getTaskName();
                    String label = "[" + name + "] ";
                    int size = 12 - label.length();
                    StringBuffer tmp = new StringBuffer();
                    for (int i = 0; i < size; ++i) {
                        tmp.append(" ");
                    }
                    tmp.append(label);
                    label = tmp.toString();
                    BufferedReader r = null;
                    try {
                        r = new BufferedReader(new StringReader(event.getMessage()));
                        String line = r.readLine();
                        boolean first = true;
                        do {
                            if (first) {
                                if (line == null) {
                                    message.append(label);
                                    break;
                                }
                            } else {
                                message.append(StringUtils.LINE_SEP);
                            }
                            first = false;
                            message.append(label).append(line);
                        } while ((line = r.readLine()) != null);
                    }
                    catch (IOException e) {
                        try {
                            message.append(label).append(event.getMessage());
                        }
                        catch (Throwable throwable) {
                            FileUtils.close(r);
                            throw throwable;
                        }
                        FileUtils.close(r);
                        break block12;
                    }
                    FileUtils.close(r);
                    break block12;
                }
                message.append(event.getMessage());
            }
            Throwable ex = event.getException();
            if (4 <= this.msgOutputLevel && ex != null) {
                message.append(String.format("%n%s: ", ex.getClass().getSimpleName())).append(StringUtils.getStackTrace(ex));
            }
            String msg = message.toString();
            if (priority != 0) {
                this.printMessage(msg, this.out, priority);
            } else {
                this.printMessage(msg, this.err, priority);
            }
            this.log(msg);
        }
    }

    protected static String formatTime(long millis) {
        return DateUtils.formatElapsedTime(millis);
    }

    protected void printMessage(String message, PrintStream stream, int priority) {
        stream.println(message);
    }

    protected void log(String message) {
    }

    protected String getTimestamp() {
        Date date = new Date(System.currentTimeMillis());
        DateFormat formatter = DateFormat.getDateTimeInstance(3, 3);
        String finishTime = formatter.format(date);
        return finishTime;
    }

    protected String extractProjectName(BuildEvent event) {
        Project project = event.getProject();
        return project != null ? project.getName() : null;
    }
}

