/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;

class BuildOperationParentTracker
implements BuildOperationListener {
    private final Map<OperationIdentifier, OperationIdentifier> parents = new ConcurrentHashMap<OperationIdentifier, OperationIdentifier>();

    BuildOperationParentTracker() {
    }

    @Nullable
    OperationIdentifier findClosestMatchingAncestor(OperationIdentifier id, Predicate<? super OperationIdentifier> predicate) {
        if (id == null || predicate.test((OperationIdentifier)id)) {
            return id;
        }
        return this.findClosestMatchingAncestor(this.parents.get(id), predicate);
    }

    @Nullable
    <T> T findClosestExistingAncestor(OperationIdentifier id, Function<? super OperationIdentifier, T> lookupFunction) {
        if (id == null) {
            return null;
        }
        T value = lookupFunction.apply((OperationIdentifier)id);
        if (value != null) {
            return value;
        }
        return this.findClosestExistingAncestor(this.parents.get(id), lookupFunction);
    }

    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        if (buildOperation.getParentId() != null) {
            this.parents.put(buildOperation.getId(), buildOperation.getParentId());
        }
    }

    public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent progressEvent) {
    }

    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
        this.parents.remove(buildOperation.getId());
    }
}

