/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.components.gradientslider;

import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Exceptions;

public abstract class MultiThumbSlider
extends JComponent {
    private static final long serialVersionUID = 1L;
    public static final String SELECTED_THUMB_PROPERTY = "selected thumb";
    public static final String INVERTED_PROPERTY = "inverted";
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String VALUES_PROPERTY = "values";
    public static final String ADJUST_PROPERTY = "adjusting";
    public static final String PAINT_TICKS_PROPERTY = "paint ticks";
    protected float[] thumbPositions = new float[0];
    Object[] values = new Object[0];
    boolean autoAdd = true;
    boolean adjusting = false;
    int orientation;
    boolean inverted = false;
    boolean paintTicks = false;
    boolean blocked = false;
    List changeListeners;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    public MultiThumbSlider(int orientation, float[] thumbPositions, Object[] values) {
        this.setOrientation(orientation);
        this.setValues(thumbPositions, values);
        this.setFocusable(true);
        this.updateUI();
    }

    public void addChangeListener(ChangeListener l) {
        if (this.changeListeners == null) {
            this.changeListeners = new Vector();
        }
        if (this.changeListeners.contains(l)) {
            return;
        }
        this.changeListeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.changeListeners == null) {
            return;
        }
        this.changeListeners.remove(l);
    }

    protected void fireChangeListeners() {
        if (this.changeListeners == null) {
            return;
        }
        for (int a = 0; a < this.changeListeners.size(); ++a) {
            try {
                ((ChangeListener)this.changeListeners.get(a)).stateChanged(new ChangeEvent(this));
                continue;
            }
            catch (Throwable t) {
                Exceptions.printStackTrace((Throwable)t);
            }
        }
    }

    @Override
    public void transferFocus() {
        this.transferFocus(true);
    }

    private void transferFocus(boolean forward) {
        int direction;
        int n = direction = forward ? 1 : -1;
        if (this.orientation == 1) {
            direction *= -1;
        }
        if (this.inverted) {
            direction *= -1;
        }
        int selectedThumb = this.getSelectedThumb();
        if (direction == 1) {
            if (selectedThumb != this.thumbPositions.length - 1) {
                this.setSelectedThumb(selectedThumb + 1);
                return;
            }
        } else if (selectedThumb != 0) {
            this.setSelectedThumb(selectedThumb - 1);
            return;
        }
        if (forward) {
            super.transferFocus();
        } else {
            super.transferFocusBackward();
        }
    }

    @Override
    public void transferFocusBackward() {
        this.transferFocus(false);
    }

    public abstract Object getValue(float var1);

    public void removeThumb(int thumbIndex) {
        if (thumbIndex <= 0 || thumbIndex > this.thumbPositions.length) {
            throw new IllegalArgumentException("There is not thumb at index " + thumbIndex + " to remove.");
        }
        float[] f = new float[this.thumbPositions.length - 1];
        Object[] c = new Object[this.values.length - 1];
        System.arraycopy(this.thumbPositions, 0, f, 0, thumbIndex);
        System.arraycopy(this.values, 0, c, 0, thumbIndex);
        System.arraycopy(this.thumbPositions, thumbIndex + 1, f, thumbIndex, f.length - thumbIndex);
        System.arraycopy(this.values, thumbIndex + 1, c, thumbIndex, f.length - thumbIndex);
        this.setValues(f, c);
    }

    public boolean doDoubleClick(int x, int y) {
        return false;
    }

    public boolean doPopup(int x, int y) {
        return false;
    }

    public boolean isPaintTicks() {
        return this.paintTicks;
    }

    public void setPaintTicks(boolean b) {
        if (b == this.paintTicks) {
            return;
        }
        this.paintTicks = b;
        this.firePropertyChange(PAINT_TICKS_PROPERTY, new Boolean(!b), new Boolean(b));
    }

    public boolean isBlocked() {
        return this.blocked;
    }

    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public int addThumb(float pos) {
        if (pos < 0.0f || pos > 1.0f) {
            throw new IllegalArgumentException("the new position (" + pos + ") must be between zero and one");
        }
        Object newValue = this.getValue(pos);
        float[] f = new float[this.thumbPositions.length + 1];
        Object[] c = new Object[this.values.length + 1];
        int newIndex = -1;
        if (pos < this.thumbPositions[0]) {
            System.arraycopy(this.thumbPositions, 0, f, 1, this.thumbPositions.length);
            System.arraycopy(this.values, 0, c, 1, this.values.length);
            newIndex = 0;
            f[0] = pos;
            c[0] = newValue;
        } else if (pos > this.thumbPositions[this.thumbPositions.length - 1]) {
            System.arraycopy(this.thumbPositions, 0, f, 0, this.thumbPositions.length);
            System.arraycopy(this.values, 0, c, 0, this.values.length);
            newIndex = f.length - 1;
            f[f.length - 1] = pos;
            c[c.length - 1] = newValue;
        } else {
            boolean addedYet = false;
            for (int a = 0; a < f.length; ++a) {
                if (!addedYet && this.thumbPositions[a] < pos) {
                    f[a] = this.thumbPositions[a];
                    c[a] = this.values[a];
                    continue;
                }
                if (!addedYet) {
                    c[a] = newValue;
                    f[a] = pos;
                    addedYet = true;
                    newIndex = a;
                    continue;
                }
                f[a] = this.thumbPositions[a - 1];
                c[a] = this.values[a - 1];
            }
        }
        this.setValues(f, c);
        return newIndex;
    }

    public void setValueIsAdjusting(boolean b) {
        if (b == this.adjusting) {
            return;
        }
        this.adjusting = b;
        this.firePropertyChange(ADJUST_PROPERTY, new Boolean(!b), new Boolean(b));
    }

    public boolean isValueAdjusting() {
        return this.adjusting;
    }

    public float[] getThumbPositions() {
        float[] f = new float[this.thumbPositions.length];
        System.arraycopy(this.thumbPositions, 0, f, 0, f.length);
        return f;
    }

    public Object[] getValues() {
        Object[] c = new Object[this.values.length];
        System.arraycopy(this.values, 0, c, 0, c.length);
        return c;
    }

    private static String toString(float[] f) {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        for (int a = 0; a < f.length; ++a) {
            sb.append(Float.toString(f[a]));
            if (a == f.length - 1) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    public void setValues(float[] thumbPositions, Object[] values) {
        int oldThumb;
        if (values.length != thumbPositions.length) {
            throw new IllegalArgumentException("there number of positions (" + thumbPositions.length + ") must equal the number of values (" + values.length + ")");
        }
        for (int a = 0; a < values.length; ++a) {
            if (values[a] == null) {
                throw new NullPointerException();
            }
            if (a > 0 && thumbPositions[a] < thumbPositions[a - 1]) {
                throw new IllegalArgumentException("the thumb positions must be ascending order (" + MultiThumbSlider.toString(thumbPositions) + ")");
            }
            if (!(thumbPositions[a] < 0.0f) && !(thumbPositions[a] > 1.0f)) continue;
            throw new IllegalArgumentException("illegal thumb value " + thumbPositions[a] + " (must be between zero and one)");
        }
        if (thumbPositions.length == this.thumbPositions.length) {
            int a;
            boolean equal = true;
            for (a = 0; a < thumbPositions.length && equal; ++a) {
                if (thumbPositions[a] == this.thumbPositions[a]) continue;
                equal = false;
            }
            for (a = 0; a < values.length && equal; ++a) {
                if (values[a].equals(this.values[a])) continue;
                equal = false;
            }
            if (equal) {
                return;
            }
        }
        this.thumbPositions = new float[thumbPositions.length];
        System.arraycopy(thumbPositions, 0, this.thumbPositions, 0, thumbPositions.length);
        this.values = new Object[values.length];
        System.arraycopy(values, 0, this.values, 0, values.length);
        int newThumb = oldThumb = this.getSelectedThumb();
        if (newThumb >= thumbPositions.length) {
            newThumb = thumbPositions.length - 1;
        }
        this.firePropertyChange(VALUES_PROPERTY, null, values);
        if (oldThumb != newThumb) {
            this.setSelectedThumb(newThumb);
        }
        this.fireChangeListeners();
    }

    public int getThumbCount() {
        return this.thumbPositions.length;
    }

    public void setSelectedThumb(int index) {
        this.putClientProperty(SELECTED_THUMB_PROPERTY, new Integer(index));
    }

    public int getSelectedThumb() {
        return this.getSelectedThumb(true);
    }

    public int getSelectedThumb(boolean ignoreIfUnfocused) {
        if (!this.hasFocus() && ignoreIfUnfocused) {
            return -1;
        }
        Integer i = (Integer)this.getClientProperty(SELECTED_THUMB_PROPERTY);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public void setAutoAdding(boolean b) {
        this.autoAdd = b;
    }

    public boolean isAutoAdding() {
        return this.autoAdd;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int i) {
        if (i != 0 && i != 1) {
            throw new IllegalArgumentException("the orientation must be HORIZONTAL or VERTICAL");
        }
        if (this.orientation == i) {
            return;
        }
        int oldValue = this.orientation;
        this.orientation = i;
        this.firePropertyChange(ORIENTATION_PROPERTY, new Integer(oldValue), new Integer(i));
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public void setInverted(boolean b) {
        if (this.inverted == b) {
            return;
        }
        this.inverted = b;
        this.firePropertyChange(INVERTED_PROPERTY, new Boolean(!b), new Boolean(b));
    }
}

