/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import javax.swing.JPanel;
import org.gephi.io.exporter.plugin.ExporterCSV;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.plugin.UIExporterCSVPanel;
import org.openide.util.NbBundle;

public class UIExporterCSV
implements ExporterUI {
    private UIExporterCSVPanel panel;
    private ExporterCSV exporterCSV;
    private ExporterCSVSettings settings = new ExporterCSVSettings();

    public void setup(Exporter exporter) {
        this.exporterCSV = (ExporterCSV)exporter;
        this.settings.load(this.exporterCSV);
        this.panel.setup(this.exporterCSV);
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporterCSV);
            this.settings.save(this.exporterCSV);
        }
        this.panel = null;
        this.exporterCSV = null;
    }

    public JPanel getPanel() {
        this.panel = new UIExporterCSVPanel();
        return this.panel;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof ExporterCSV;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterCSV.class, (String)"UIExporterCSV.name");
    }

    private static class ExporterCSVSettings {
        private boolean edgeWeight = true;
        private boolean writeZero = true;
        private boolean header = true;
        private boolean list = false;

        private ExporterCSVSettings() {
        }

        private void save(ExporterCSV exporterCSV) {
            this.edgeWeight = exporterCSV.isEdgeWeight();
            this.writeZero = exporterCSV.isWriteZero();
            this.header = exporterCSV.isHeader();
            this.list = exporterCSV.isList();
        }

        private void load(ExporterCSV exporterCSV) {
            exporterCSV.setEdgeWeight(this.edgeWeight);
            exporterCSV.setWriteZero(this.writeZero);
            exporterCSV.setHeader(this.header);
            exporterCSV.setList(this.list);
        }
    }
}

