/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.debug;

import java.io.File;
import java.util.Map;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.debug.core.ILaunch;

public class RustGDBLaunchWrapper
extends GdbLaunch {
    public RustGDBLaunchWrapper(ILaunch launch) {
        super(launch.getLaunchConfiguration(), launch.getLaunchMode(), launch.getSourceLocator());
    }

    public String[] getLaunchEnvironment() throws CoreException {
        String[] envVariables = super.getLaunchEnvironment();
        int length = envVariables.length;
        if (length > 0) {
            int i = 0;
            while (i < length) {
                if (envVariables[i].toUpperCase().startsWith("PATH=")) {
                    int n = i;
                    envVariables[n] = String.valueOf(envVariables[n]) + File.pathSeparator + RustGDBLaunchWrapper.getCargoBinLocation() + File.pathSeparator + RustGDBLaunchWrapper.getGDBLocation();
                    return envVariables;
                }
                ++i;
            }
        } else {
            Map<String, String> env = System.getenv();
            envVariables = new String[env.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : env.entrySet()) {
                envVariables[i] = String.valueOf(entry.getKey()) + "=" + entry.getValue();
                if (envVariables[i].toUpperCase().startsWith("PATH=")) {
                    int n = i;
                    envVariables[n] = String.valueOf(envVariables[n]) + File.pathSeparator + RustGDBLaunchWrapper.getCargoBinLocation() + File.pathSeparator + RustGDBLaunchWrapper.getGDBLocation();
                }
                ++i;
            }
        }
        return envVariables;
    }

    private static String getCargoBinLocation() {
        IPath location = Path.fromOSString((String)CorrosionPlugin.getDefault().getPreferenceStore().getString("corrosion.rustup_cargoPath"));
        String parentDirectory = location.toFile().getParent();
        return parentDirectory != null ? parentDirectory : "";
    }

    private static String getGDBLocation() {
        IPath location = Path.fromOSString((String)CorrosionPlugin.getOutputFromCommand(Platform.getOS().equals("win32") ? "where" : "which", "gdb"));
        String parentDirectory = location.toFile().getParent();
        return parentDirectory != null ? parentDirectory : "";
    }
}

