/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.utils;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataDomainContext;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.ITaglibDomainMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.TaglibDomainMetaDataQueryHelper;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.query.internal.MetaDataQueryContextFactory;
import org.eclipse.jst.jsf.common.ui.internal.logging.Logger;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.eclipse.jst.pagedesigner.editors.palette.IDropSourceData;
import org.eclipse.jst.pagedesigner.editors.palette.ITagDropSourceData;
import org.eclipse.jst.pagedesigner.itemcreation.CreationData;
import org.eclipse.jst.pagedesigner.itemcreation.ITagCreator;
import org.eclipse.jst.pagedesigner.itemcreation.internal.TagCreationFactory;
import org.eclipse.jst.pagedesigner.utils.StructuredModelUtil;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Element;

public class CommandUtil {
    private static final Logger _log = PDPlugin.getLogger(CommandUtil.class);

    public static Element executeInsertion(IDropSourceData dropSourceData, IDOMModel model, IDOMPosition domPosition, IAdaptable customizationData) {
        ITagCreator tagCreator;
        CreationData creationData;
        block7: {
            try {
                IMetaDataModelContext modelContext = CommandUtil.getMetadataModelContext(dropSourceData.getNamespace(), model);
                ITagDropSourceData tagDropSourceData = null;
                if (dropSourceData instanceof ITagDropSourceData) {
                    tagDropSourceData = (ITagDropSourceData)dropSourceData;
                } else if (customizationData != null) {
                    tagDropSourceData = (ITagDropSourceData)customizationData.getAdapter(ITagDropSourceData.class);
                }
                if (tagDropSourceData == null) {
                    PDPlugin.log("Could not down cast dropSourceData to tagDropSourceData", new Exception("for stack trace only"));
                }
                creationData = new CreationData(tagDropSourceData, model, domPosition, modelContext, customizationData);
                tagCreator = TagCreationFactory.getInstance().createTagCreator(creationData.getTagId());
                if (tagCreator != null) break block7;
                return null;
            }
            catch (Exception e) {
                _log.error("Problem creating tag " + dropSourceData.getId() + " at:" + domPosition + "\n", (Throwable)e);
                return null;
            }
        }
        return tagCreator.createTag(creationData);
    }

    public static ITaglibDomainMetaDataModelContext getMetadataContext(String uri, IDOMModel model) {
        IProject project = StructuredModelUtil.getProjectFor((IStructuredModel)model);
        ITaglibDomainMetaDataModelContext modelContext = TaglibDomainMetaDataQueryHelper.createMetaDataModelContext((IProject)project, (String)uri);
        return modelContext;
    }

    public static IMetaDataModelContext getMetadataModelContext(String uri, IDOMModel model) {
        IFile file = StructuredModelUtil.getFileFor((IStructuredModel)model);
        IMetaDataDomainContext modelContext = MetaDataQueryContextFactory.getInstance().createTaglibDomainModelContext(file);
        return new MetaDataModelContext(uri, modelContext);
    }
}

