/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.project;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.model.Resource;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MavenProjectUtils {
    private MavenProjectUtils() {
    }

    public static IPath getProjectRelativePath(IProject project, String resourceLocation) {
        if (resourceLocation == null) {
            return null;
        }
        IPath projectLocation = project.getLocation();
        IPath directory = Path.fromOSString((String)resourceLocation);
        if (projectLocation == null || !projectLocation.isPrefixOf(directory)) {
            return null;
        }
        return directory.removeFirstSegments(projectLocation.segmentCount()).makeRelative().setDevice(null);
    }

    public static IPath[] getResourceLocations(IProject project, List<Resource> resources) {
        LinkedHashSet<IPath> locations = new LinkedHashSet<IPath>();
        for (Resource resource : resources) {
            locations.add(MavenProjectUtils.getProjectRelativePath(project, resource.getDirectory()));
        }
        return locations.toArray(new IPath[locations.size()]);
    }

    public static IPath[] getSourceLocations(IProject project, List<String> roots) {
        LinkedHashSet<IPath> locations = new LinkedHashSet<IPath>();
        for (String root : roots) {
            IPath path = MavenProjectUtils.getProjectRelativePath(project, root);
            if (path == null) continue;
            locations.add(path);
        }
        return locations.toArray(new IPath[locations.size()]);
    }

    public static IPath getFullPath(IProject project, File file) {
        if (project == null || file == null) {
            return null;
        }
        IPath projectPath = project.getLocation();
        if (projectPath == null) {
            return null;
        }
        Path filePath = new Path(file.getAbsolutePath());
        if (!projectPath.isPrefixOf((IPath)filePath)) {
            return null;
        }
        IResource resource = project.findMember(filePath.removeFirstSegments(projectPath.segmentCount()));
        if (resource == null) {
            return null;
        }
        return resource.getFullPath();
    }
}

