/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.equinox.internal.security.storage.SlashEncode;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.internal.core.ParameterizedStringFilter;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;
import org.eclipse.oomph.setup.internal.core.StringFilter;
import org.eclipse.oomph.setup.internal.core.StringFilterDocumentation;
import org.eclipse.oomph.setup.util.StringExpander;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.StringUtil;

public class StringFilterRegistry {
    public static final StringFilterRegistry INSTANCE = new StringFilterRegistry();
    private static final Pattern CAMEL_PATTERN = Pattern.compile("(?:[^\\p{Alnum}]+|^)(\\p{Lower})?");
    private final Map<String, StringFilter> filters = new HashMap<String, StringFilter>();

    private StringFilterRegistry() {
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "file";
            }

            public String getDescription() {
                return "Converts a file: URI to an OS-specific file system path.";
            }

            public String filter(String value) {
                return URI.createURI((String)value).toFileString();
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "uri";
            }

            public String getDescription() {
                return "Converts a file system path to a file: URI.";
            }

            public String filter(String value) {
                return URI.createFileURI((String)value).toString();
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "uriLastSegment";
            }

            public String getDescription() {
                return "Extracts the last path segment from a hierarchical URI or the authority from an opaque URI.";
            }

            public String filter(String value) {
                URI uri = URI.createURI((String)value);
                if (!uri.isHierarchical()) {
                    uri = URI.createURI((String)uri.opaquePart());
                }
                return URI.decode((String)uri.lastSegment());
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "gitRepository";
            }

            public String getDescription() {
                return "Extracts the name of the repository from a Git URI (excluding a possible .git suffix).";
            }

            public String filter(String value) {
                String result;
                URI uri = URI.createURI((String)value);
                if (!uri.isHierarchical()) {
                    uri = URI.createURI((String)uri.opaquePart());
                }
                if ((result = URI.decode((String)uri.lastSegment())) != null && result.endsWith(".git")) {
                    result = result.substring(0, result.length() - 4);
                }
                return result;
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "username";
            }

            public String getDescription() {
                return "Escapes all \"at\" symbols (@) of a String value, so that the result can be used in URI that contain a username.";
            }

            public String filter(String value) {
                return URI.encodeSegment((String)value, (boolean)false).replace(":", "%3A").replace("@", "%40");
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "canonical";
            }

            public String getDescription() {
                return "Canonicalizes a file system path.";
            }

            public String filter(String value) {
                if (StringExpander.STRING_EXPANSION_PATTERN.matcher(value).find()) {
                    return value;
                }
                File file = new File(value).getAbsoluteFile();
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    return file.getAbsolutePath();
                }
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "preferenceNode";
            }

            public String getDescription() {
                return "Escapes all forward slashes (/) of a String value, so that the result can be used as a value in preference nodes.";
            }

            public String filter(String value) {
                return value.replaceAll("/", "\\\\2f");
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "length";
            }

            public String getDescription() {
                return "Converts a String to a String that contains the alpha-numerical representation of the length of the original String.";
            }

            public String filter(String value) {
                return Integer.toString(value.length());
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "trim";
            }

            public String getDescription() {
                return "Removes all whitespace from the beginning and the end of a String.";
            }

            public String filter(String value) {
                return value.trim();
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "trimLeft";
            }

            public String getDescription() {
                return "Removes all whitespace from the beginning of a String.";
            }

            public String filter(String value) {
                return StringUtil.trimLeft((String)value);
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "trimRight";
            }

            public String getDescription() {
                return "Removes all whitespace from the end of a String.";
            }

            public String filter(String value) {
                return StringUtil.trimRight((String)value);
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "trimTrailingSlashes";
            }

            public String getDescription() {
                return "Removes all slashes and backslashes from the end of a String.";
            }

            public String filter(String value) {
                return StringUtil.trimTrailingSlashes((String)value);
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "upper";
            }

            public String getDescription() {
                return "Converts all characters of a String value to upper-case.";
            }

            public String filter(String value) {
                return value.toUpperCase();
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "lower";
            }

            public String getDescription() {
                return "Converts all characters of a String value to lower-case.";
            }

            public String filter(String value) {
                return value.toLowerCase();
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "cap";
            }

            public String getDescription() {
                return "Capitalizes the first word of a String value.";
            }

            public String filter(String value) {
                return StringUtil.cap((String)value);
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "capAll";
            }

            public String getDescription() {
                return "Capitalizes all words of a String value.";
            }

            public String[] getDeprecations() {
                return new String[]{"allCap"};
            }

            public String filter(String value) {
                return StringUtil.capAll((String)value);
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "qualifiedName";
            }

            public String getDescription() {
                return "Converts a camel case String value name to a qualified name.";
            }

            public String filter(String value) {
                return value.trim().replaceAll("[^\\p{Alnum}]+", ".").toLowerCase();
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "camel";
            }

            public String getDescription() {
                return "Converts a qualified name to camel case notation.";
            }

            public String filter(String value) {
                Matcher matcher = CAMEL_PATTERN.matcher(value);
                StringBuffer result = new StringBuffer();
                while (matcher.find()) {
                    String group = matcher.group(1);
                    matcher.appendReplacement(result, group == null ? "" : group.toUpperCase());
                }
                matcher.appendTail(result);
                return result.toString();
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "property";
            }

            public String getDescription() {
                return "Escapes all double back slashes (\\\\) of a String value, so that the result can be used as a value in properties.";
            }

            public String filter(String value) {
                return value.replaceAll("\\\\", "\\\\\\\\");
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "path";
            }

            public String getDescription() {
                return "Extracts the path segments from a URI.";
            }

            public String filter(String value) {
                return value.replaceAll("\\\\", "/");
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "basePath";
            }

            public String getDescription() {
                return "Removes the last segment from a file system path.";
            }

            public String filter(String value) {
                int pos = (value = value.replaceAll("\\\\", "/")).lastIndexOf(47);
                if (pos == -1) {
                    return "";
                }
                return value.substring(0, pos);
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "lastSegment";
            }

            public String getDescription() {
                return "Extracts the last segment from a file system path.";
            }

            public String filter(String value) {
                int pos = Math.max(value.lastIndexOf(47), value.lastIndexOf(92));
                if (pos == -1) {
                    return value;
                }
                return value.substring(pos + 1);
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "fileExtension";
            }

            public String getDescription() {
                return "Extracts the file extension from a URI or a file system path.";
            }

            public String filter(String value) {
                int pos = value.lastIndexOf(46);
                if (pos == -1) {
                    return "";
                }
                return value.substring(pos + 1);
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "pathEncode";
            }

            public String getDescription() {
                return "Converts a file system path to a String value that can be used as a file name.";
            }

            public String filter(String value) {
                return IOUtil.encodeFileName((String)value);
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "urlEncode";
            }

            public String getDescription() {
                return "URL-encodes a String value.";
            }

            public String filter(String value) {
                try {
                    return URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return value;
                }
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "urlDecode";
            }

            public String getDescription() {
                return "Decodes a URL.";
            }

            public String filter(String value) {
                try {
                    return URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return value;
                }
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "slashEncode";
            }

            public String getDescription() {
                return "Encodes all slashes and backslashes of a String value.";
            }

            public String filter(String value) {
                try {
                    return SlashEncode.encode((String)value);
                }
                catch (Throwable throwable) {
                    return value;
                }
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "slashDecode";
            }

            public String getDescription() {
                return "Decodes a slashEncoded String value.";
            }

            public String filter(String value) {
                try {
                    return SlashEncode.decode((String)value);
                }
                catch (Throwable throwable) {
                    return value;
                }
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "propertyValue";
            }

            public String getDescription() {
                return "Interprets the String value as a preference property path and returns the value of that property.";
            }

            public String filter(String value) {
                PreferencesUtil.PreferenceProperty preferenceProperty = new PreferencesUtil.PreferenceProperty(value);
                String result = preferenceProperty.get(null);
                return result == null ? "" : result;
            }
        });
        this.registerFilter("base64", new ParameterizedStringFilter(){

            public String filter(String value) {
                return this.filter(value, null);
            }

            public String filter(String value, String argument) {
                try {
                    String xmlEncoding;
                    Charset charset = value.startsWith("<?xml") ? Charset.forName((xmlEncoding = URIConverter.ReadableInputStream.getEncoding((String)value)) == null ? "UTF-8" : xmlEncoding) : (argument != null ? Charset.forName(argument.toUpperCase()) : Charset.defaultCharset());
                    return XMLTypeFactory.eINSTANCE.convertBase64Binary(value.getBytes(charset));
                }
                catch (Exception exception) {
                    return value;
                }
            }
        });
        this.registerFilter(new DocumentedStringFilter(){

            public String getName() {
                return "not";
            }

            public String getDescription() {
                return "The boolean logical negation, i.e., 'false' if the value is 'true', and 'true' if the value is 'false' (or anything else).";
            }

            public String filter(String value) {
                return "true".equalsIgnoreCase(value) ? "false" : "true";
            }
        });
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        ArrayList<Map.Entry<String, StringFilter>> entries = new ArrayList<Map.Entry<String, StringFilter>>(StringFilterRegistry.INSTANCE.filters.entrySet());
        Collections.sort(entries, new Comparator<Map.Entry<String, StringFilter>>(){

            @Override
            public int compare(Map.Entry<String, StringFilter> e1, Map.Entry<String, StringFilter> e2) {
                return e1.getKey().compareTo(e2.getKey());
            }
        });
        System.out.println("{| class=\"wikitable\"");
        boolean first = true;
        for (Map.Entry entry : entries) {
            String description;
            String name;
            StringFilter filter = (StringFilter)entry.getValue();
            if (filter instanceof DocumentedStringFilter) {
                boolean deprecated;
                name = ((DocumentedStringFilter)filter).getName();
                description = ((DocumentedStringFilter)filter).getDescription();
                boolean bl = deprecated = !name.toLowerCase().equals(((String)entry.getKey()).toLowerCase());
                if (deprecated) {
                    continue;
                }
            } else {
                name = (String)entry.getKey();
                description = "";
            }
            if (first) {
                first = false;
            } else {
                System.out.println("|-");
            }
            System.out.println("| '''" + name + "''' || " + description);
        }
        System.out.println("|}");
    }

    public String filter(String value, String filterName) {
        StringFilter filter = this.filters.get(filterName.toLowerCase());
        if (filter == null) {
            int argumentIndex = filterName.indexOf(46);
            if (argumentIndex != -1 && (filter = this.filters.get(filterName.substring(0, argumentIndex).toLowerCase())) instanceof ParameterizedStringFilter) {
                ParameterizedStringFilter parameterizedStringFilter = (ParameterizedStringFilter)filter;
                return parameterizedStringFilter.filter(value, filterName.substring(argumentIndex + 1));
            }
            return value;
        }
        return filter.filter(value);
    }

    void initContributions() {
        if (SetupCorePlugin.INSTANCE.isOSGiRunning()) {
            try {
                IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
                IConfigurationElement[] iConfigurationElementArray = extensionRegistry.getConfigurationElementsFor("org.eclipse.oomph.setup.core.stringFilters");
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                    String filterName = configurationElement.getAttribute("name");
                    if (!this.filters.containsKey(filterName)) {
                        try {
                            StringFilter filter = (StringFilter)configurationElement.createExecutableExtension("class");
                            this.registerFilter(filterName, filter);
                        }
                        catch (Exception ex) {
                            SetupCorePlugin.INSTANCE.log(ex);
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                SetupCorePlugin.INSTANCE.log(ex);
            }
        }
    }

    private void registerFilter(String filterName, StringFilter filter) {
        this.filters.put(filterName.toLowerCase(), filter);
    }

    private void registerFilter(DocumentedStringFilter filter) {
        String name = filter.getName().toLowerCase();
        this.filters.put(name, filter);
        String[] deprecations = filter.getDeprecations();
        if (deprecations != null) {
            String[] stringArray = deprecations;
            int n = deprecations.length;
            int n2 = 0;
            while (n2 < n) {
                String deprecatedName = stringArray[n2];
                this.filters.put(deprecatedName.toLowerCase(), filter);
                ++n2;
            }
        }
    }

    public static abstract class DocumentedStringFilter
    implements StringFilter,
    StringFilterDocumentation {
        public String getDescription() {
            return null;
        }

        public String[] getDeprecations() {
            return null;
        }
    }
}

