/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

public class IndexDiffFilter
extends TreeFilter {
    private final int dirCache;
    private final int workingTree;
    private final boolean honorIgnores;
    private final Set<String> ignoredPaths = new HashSet<String>();
    private final LinkedList<String> untrackedParentFolders = new LinkedList();
    private final LinkedList<String> untrackedFolders = new LinkedList();

    public IndexDiffFilter(int dirCacheIndex, int workingTreeIndex) {
        this(dirCacheIndex, workingTreeIndex, true);
    }

    public IndexDiffFilter(int dirCacheIndex, int workingTreeIndex, boolean honorIgnores) {
        this.dirCache = dirCacheIndex;
        this.workingTree = workingTreeIndex;
        this.honorIgnores = honorIgnores;
    }

    @Override
    public boolean include(TreeWalk tw) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        int i;
        DirCacheEntry dce;
        int cnt = tw.getTreeCount();
        int wm = tw.getRawMode(this.workingTree);
        WorkingTreeIterator wi = this.workingTree(tw);
        String path = tw.getPathString();
        DirCacheIterator di = tw.getTree(this.dirCache, DirCacheIterator.class);
        if (di != null && (dce = di.getDirCacheEntry()) != null) {
            if (dce.isAssumeValid()) {
                return false;
            }
            if (dce.getStage() != 0) {
                return true;
            }
        }
        if (!tw.isPostOrderTraversal()) {
            if (!(!FileMode.TREE.equals(wm) || this.honorIgnores && wi.isEntryIgnored())) {
                this.copyUntrackedFolders(path);
                this.untrackedParentFolders.addFirst(path);
            }
            int i2 = 0;
            while (i2 < cnt) {
                int rmode = tw.getRawMode(i2);
                if (i2 != this.workingTree && rmode != 0 && FileMode.TREE.equals(rmode)) {
                    this.untrackedParentFolders.clear();
                    break;
                }
                ++i2;
            }
        }
        if (wm == 0) {
            return true;
        }
        int dm = tw.getRawMode(this.dirCache);
        if (dm == 0) {
            if (this.honorIgnores && wi.isEntryIgnored()) {
                this.ignoredPaths.add(wi.getEntryPathString());
                i = 0;
                while (i < cnt) {
                    if (i != this.dirCache && i != this.workingTree && tw.getRawMode(i) != 0) break;
                    ++i;
                }
                return i != cnt;
            }
            return true;
        }
        if (tw.isSubtree()) {
            return true;
        }
        i = 0;
        while (i < cnt) {
            if (!(i == this.dirCache || i == this.workingTree || tw.getRawMode(i) == dm && tw.idEqual(i, this.dirCache))) {
                return true;
            }
            ++i;
        }
        return wi.isModified(di == null ? null : di.getDirCacheEntry(), true, tw.getObjectReader());
    }

    private void copyUntrackedFolders(String currentPath) {
        String pathToBeSaved = null;
        while (!this.untrackedParentFolders.isEmpty() && !currentPath.startsWith(String.valueOf(this.untrackedParentFolders.getFirst()) + "/")) {
            pathToBeSaved = this.untrackedParentFolders.removeFirst();
        }
        if (pathToBeSaved != null) {
            while (!this.untrackedFolders.isEmpty() && this.untrackedFolders.getLast().startsWith(pathToBeSaved)) {
                this.untrackedFolders.removeLast();
            }
            this.untrackedFolders.addLast(pathToBeSaved);
        }
    }

    private WorkingTreeIterator workingTree(TreeWalk tw) {
        return tw.getTree(this.workingTree, WorkingTreeIterator.class);
    }

    @Override
    public boolean shouldBeRecursive() {
        return true;
    }

    @Override
    public TreeFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return "INDEX_DIFF_FILTER";
    }

    public Set<String> getIgnoredPaths() {
        return this.ignoredPaths;
    }

    public List<String> getUntrackedFolders() {
        LinkedList<String> ret = new LinkedList<String>(this.untrackedFolders);
        if (!this.untrackedParentFolders.isEmpty()) {
            String toBeAdded = this.untrackedParentFolders.getLast();
            while (!ret.isEmpty() && ret.getLast().startsWith(toBeAdded)) {
                ret.removeLast();
            }
            ret.addLast(toBeAdded);
        }
        return ret;
    }
}

