/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.ui.tools.maintenance;

import java.util.Collection;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerObject;
import org.jkiss.dbeaver.ext.mssql.model.SQLServerTableTrigger;
import org.jkiss.dbeaver.ext.mssql.ui.tools.maintenance.TableToolDialog;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.tools.IUserInterfaceTool;
import org.jkiss.utils.CommonUtils;

public class SQLServerToolTriggerToggle
implements IUserInterfaceTool {
    private static final Log log = Log.getLog(SQLServerToolTriggerToggle.class);
    private boolean isEnable;

    SQLServerToolTriggerToggle(boolean enable) {
        this.isEnable = enable;
    }

    public void execute(IWorkbenchWindow window, IWorkbenchPart activePart, Collection<DBSObject> objects) {
        List triggeList = CommonUtils.filterCollection(objects, SQLServerTableTrigger.class);
        if (!triggeList.isEmpty()) {
            SQLDialog dialog = new SQLDialog(activePart.getSite(), triggeList);
            dialog.open();
        }
    }

    class SQLDialog
    extends TableToolDialog {
        SQLDialog(IWorkbenchPartSite partSite, List<SQLServerTableTrigger> selectedTrigger) {
            super(partSite, String.valueOf(SQLServerToolTriggerToggle.this.isEnable ? "Enable" : "Disable") + " trigger", selectedTrigger);
        }

        protected void generateObjectCommand(List<String> lines, SQLServerObject object) {
            lines.add("ALTER TABLE " + ((SQLServerTableTrigger)object).getTable() + " " + (SQLServerToolTriggerToggle.this.isEnable ? "ENABLE" : "DISABLE") + " TRIGGER " + DBUtils.getQuotedIdentifier((DBSObject)object) + " ");
        }

        protected void createControls(Composite parent) {
            this.createObjectsSelector(parent);
        }

        protected boolean needsRefreshOnFinish() {
            return true;
        }
    }
}

