/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
import { Injectable } from '@angular/core';
import { BlockUIService, BLOCKUI_DEFAULT } from 'ng-block-ui';
export class BlockUIPreventNavigation {
    /**
     * @param {?} blockUIService
     */
    constructor(blockUIService) {
        this.blockUIService = blockUIService;
    }
    /**
     * @return {?}
     */
    canActivate() {
        return !this.blockUIService.isActive(BLOCKUI_DEFAULT);
    }
    /**
     * @return {?}
     */
    canActivateChild() {
        return !this.blockUIService.isActive(BLOCKUI_DEFAULT);
    }
}
BlockUIPreventNavigation.decorators = [
    { type: Injectable },
];
/** @nocollapse */
BlockUIPreventNavigation.ctorParameters = () => [
    { type: BlockUIService }
];
function BlockUIPreventNavigation_tsickle_Closure_declarations() {
    /** @type {?} */
    BlockUIPreventNavigation.prototype.blockUIService;
}

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmxvY2stdWktcHJldmVudC1uYXZpZ2F0aW9uLnNlcnZpY2UuanMiLCJzb3VyY2VSb290Ijoibmc6Ly9uZy1ibG9jay11aS9yb3V0ZXIvIiwic291cmNlcyI6WyJibG9jay11aS1wcmV2ZW50LW5hdmlnYXRpb24uc2VydmljZS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7O0FBQUEsT0FBTyxFQUFFLFVBQVUsRUFBRSxNQUFNLGVBQWUsQ0FBQztBQUczQyxPQUFPLEVBQUUsY0FBYyxFQUFFLGVBQWUsRUFBRSxNQUFNLGFBQWEsQ0FBQztBQUc5RCxNQUFNOzs7O0lBRUosWUFDVTtRQUFBLG1CQUFjLEdBQWQsY0FBYztLQUNwQjs7OztJQUVKLFdBQVc7UUFDVCxNQUFNLENBQUMsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLFFBQVEsQ0FBQyxlQUFlLENBQUMsQ0FBQztLQUN2RDs7OztJQUVELGdCQUFnQjtRQUNkLE1BQU0sQ0FBQyxDQUFDLElBQUksQ0FBQyxjQUFjLENBQUMsUUFBUSxDQUFDLGVBQWUsQ0FBQyxDQUFDO0tBQ3ZEOzs7WUFiRixVQUFVOzs7O1lBRkYsY0FBYyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEluamVjdGFibGUgfSBmcm9tICdAYW5ndWxhci9jb3JlJztcbmltcG9ydCB7IENhbkFjdGl2YXRlLCBDYW5BY3RpdmF0ZUNoaWxkIH0gZnJvbSAnQGFuZ3VsYXIvcm91dGVyJztcblxuaW1wb3J0IHsgQmxvY2tVSVNlcnZpY2UsIEJMT0NLVUlfREVGQVVMVCB9IGZyb20gJ25nLWJsb2NrLXVpJztcblxuQEluamVjdGFibGUoKVxuZXhwb3J0IGNsYXNzIEJsb2NrVUlQcmV2ZW50TmF2aWdhdGlvbiBpbXBsZW1lbnRzIENhbkFjdGl2YXRlLCBDYW5BY3RpdmF0ZUNoaWxkIHtcblxuICBjb25zdHJ1Y3RvcihcbiAgICBwcml2YXRlIGJsb2NrVUlTZXJ2aWNlOiBCbG9ja1VJU2VydmljZVxuICApIHt9XG5cbiAgY2FuQWN0aXZhdGUoKSB7XG4gICAgcmV0dXJuICF0aGlzLmJsb2NrVUlTZXJ2aWNlLmlzQWN0aXZlKEJMT0NLVUlfREVGQVVMVCk7XG4gIH1cblxuICBjYW5BY3RpdmF0ZUNoaWxkKCkge1xuICAgIHJldHVybiAhdGhpcy5ibG9ja1VJU2VydmljZS5pc0FjdGl2ZShCTE9DS1VJX0RFRkFVTFQpO1xuICB9XG59XG4iXX0=