"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Validates the indentaion rule
 * Checks indentation character and number
 */
var Indentation = /** @class */ (function () {
    function Indentation() {
    }
    Indentation.validate = function (lines, config) {
        var errors = [];
        var whitespaceRegex = config.char === 'space' ? /^ *$/ : /^\t*$/;
        var prevStartIdx = 0;
        lines.forEach(function (line, idx) {
            var tagIdx = line.search(/^\s*</);
            if (tagIdx !== -1) {
                var startIdx = line.search(/\S/);
                var diff = Math.abs(prevStartIdx - startIdx);
                var whitespaceStr = line.substring(0, startIdx);
                if ((diff !== config.number && diff !== 0) ||
                    !whitespaceRegex.test(whitespaceStr)) {
                    errors.push({
                        line: idx,
                        column: startIdx,
                        message: "File should use " + config.number + " " + config.char + " indentation"
                    });
                }
                prevStartIdx = startIdx;
            }
        });
        return errors;
    };
    return Indentation;
}());
exports.Indentation = Indentation;
