"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var linter_1 = require("./linter");
var commander = require("commander");
var fs = require("fs");
var logger_1 = require("./utils/logger");
var fileList;
var program = commander
    .version('1.0.0')
    .option('--config [filePath]', 'config file')
    .arguments('[fileList...]')
    .action(function (args) { return (fileList = args.length > 0 ? args : undefined); })
    .parse(process.argv);
var configFilePath = program.config;
if (!configFilePath) {
    onError('config file is required');
}
else {
    fs.readFile(configFilePath, function (fileError, data) {
        if (fileError) {
            onError("Error loading config file " + configFilePath);
        }
        else {
            var configJson = JSON.parse(data.toString());
            linter_1.Linter.lint(configJson, fileList)
                .then(function (numErrors) {
                if (numErrors === 0) {
                    process.exit(0);
                }
                else {
                    process.exit(1);
                }
            })
                .catch(function (lintError) {
                onError(lintError.toString());
            });
        }
    });
}
function onError(error) {
    logger_1.default.logHelp(error);
    process.exit(1);
}
