Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _url = require('url');

var _url2 = _interopRequireDefault(_url);

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _electron = require('electron');

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _packageCard = require('./package-card');

var _packageCard2 = _interopRequireDefault(_packageCard);

var _packageGrammarsView = require('./package-grammars-view');

var _packageGrammarsView2 = _interopRequireDefault(_packageGrammarsView);

var _packageKeymapView = require('./package-keymap-view');

var _packageKeymapView2 = _interopRequireDefault(_packageKeymapView);

var _packageReadmeView = require('./package-readme-view');

var _packageReadmeView2 = _interopRequireDefault(_packageReadmeView);

var _packageSnippetsView = require('./package-snippets-view');

var _packageSnippetsView2 = _interopRequireDefault(_packageSnippetsView);

var _settingsPanel = require('./settings-panel');

var _settingsPanel2 = _interopRequireDefault(_settingsPanel);

var NORMALIZE_PACKAGE_DATA_README_ERROR = 'ERROR: No README data found!';

var PackageDetailView = (function () {
  function PackageDetailView(pack, settingsView, packageManager, snippetsProvider) {
    var _this = this;

    _classCallCheck(this, PackageDetailView);

    this.pack = pack;
    this.settingsView = settingsView;
    this.packageManager = packageManager;
    this.snippetsProvider = snippetsProvider;
    this.disposables = new _atom.CompositeDisposable();
    _etch2['default'].initialize(this);
    this.loadPackage();

    this.disposables.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));

    var packageRepoClickHandler = function packageRepoClickHandler(event) {
      event.preventDefault();
      var repoUrl = _this.packageManager.getRepositoryUrl(_this.pack);
      if (typeof repoUrl === 'string') {
        if (_url2['default'].parse(repoUrl).pathname === '/atom/atom') {
          _electron.shell.openExternal(repoUrl + '/tree/master/packages/' + _this.pack.name);
        } else {
          _electron.shell.openExternal(repoUrl);
        }
      }
    };
    this.refs.packageRepo.addEventListener('click', packageRepoClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.packageRepo.removeEventListener('click', packageRepoClickHandler);
    }));

    var issueButtonClickHandler = function issueButtonClickHandler(event) {
      event.preventDefault();
      var bugUri = _this.packageManager.getRepositoryBugUri(_this.pack);
      if (bugUri) {
        _electron.shell.openExternal(bugUri);
      }
    };
    this.refs.issueButton.addEventListener('click', issueButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.issueButton.removeEventListener('click', issueButtonClickHandler);
    }));

    var changelogButtonClickHandler = function changelogButtonClickHandler(event) {
      event.preventDefault();
      if (_this.changelogPath) {
        _this.openMarkdownFile(_this.changelogPath);
      }
    };
    this.refs.changelogButton.addEventListener('click', changelogButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.changelogButton.removeEventListener('click', changelogButtonClickHandler);
    }));

    var licenseButtonClickHandler = function licenseButtonClickHandler(event) {
      event.preventDefault();
      if (_this.licensePath) {
        _this.openMarkdownFile(_this.licensePath);
      }
    };
    this.refs.licenseButton.addEventListener('click', licenseButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.licenseButton.removeEventListener('click', licenseButtonClickHandler);
    }));

    var openButtonClickHandler = function openButtonClickHandler(event) {
      event.preventDefault();
      if (_fsPlus2['default'].existsSync(_this.pack.path)) {
        atom.open({ pathsToOpen: [_this.pack.path] });
      }
    };
    this.refs.openButton.addEventListener('click', openButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.openButton.removeEventListener('click', openButtonClickHandler);
    }));

    var learnMoreButtonClickHandler = function learnMoreButtonClickHandler(event) {
      event.preventDefault();
      _electron.shell.openExternal('https://atom.io/packages/' + _this.pack.name);
    };
    this.refs.learnMoreButton.addEventListener('click', learnMoreButtonClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.learnMoreButton.removeEventListener('click', learnMoreButtonClickHandler);
    }));

    var breadcrumbClickHandler = function breadcrumbClickHandler(event) {
      event.preventDefault();
      _this.settingsView.showPanel(_this.breadcrumbBackPanel);
    };
    this.refs.breadcrumb.addEventListener('click', breadcrumbClickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.refs.breadcrumb.removeEventListener('click', breadcrumbClickHandler);
    }));
  }

  _createClass(PackageDetailView, [{
    key: 'completeInitialization',
    value: function completeInitialization() {
      if (this.refs.packageCard) {
        this.packageCard = this.refs.packageCard.packageCard;
      } else if (!this.packageCard) {
        // Had to load this from the network
        this.packageCard = new _packageCard2['default'](this.pack.metadata, this.settingsView, this.packageManager, { onSettingsView: true });
        this.refs.packageCardParent.replaceChild(this.packageCard.element, this.refs.loadingMessage);
      }

      this.refs.packageRepo.classList.remove('hidden');
      this.refs.startupTime.classList.remove('hidden');
      this.refs.buttons.classList.remove('hidden');
      this.activateConfig();
      this.populate();
      this.updateFileButtons();
      this.subscribeToPackageManager();
      this.renderReadme();
    }
  }, {
    key: 'loadPackage',
    value: function loadPackage() {
      var loadedPackage = atom.packages.getLoadedPackage(this.pack.name);
      if (loadedPackage) {
        this.pack = loadedPackage;
        this.completeInitialization();
      } else {
        // If the package metadata in `@pack` isn't complete, hit the network.
        if (!this.pack.metadata || !this.pack.metadata.owner) {
          this.fetchPackage();
        } else {
          this.completeInitialization();
        }
      }
    }
  }, {
    key: 'fetchPackage',
    value: function fetchPackage() {
      var _this2 = this;

      this.showLoadingMessage();
      this.packageManager.getClient()['package'](this.pack.name, function (err, packageData) {
        if (err || !packageData || !packageData.name) {
          _this2.hideLoadingMessage();
          _this2.showErrorMessage();
        } else {
          _this2.pack = packageData;
          // TODO: this should match Package.loadMetadata from core, but this is
          // an acceptable hacky workaround
          _this2.pack.metadata = _underscorePlus2['default'].extend(_this2.pack.metadata != null ? _this2.pack.metadata : {}, _this2.pack);
          _this2.completeInitialization();
        }
      });
    }
  }, {
    key: 'showLoadingMessage',
    value: function showLoadingMessage() {
      this.refs.loadingMessage.classList.remove('hidden');
    }
  }, {
    key: 'hideLoadingMessage',
    value: function hideLoadingMessage() {
      this.refs.loadingMessage.classList.add('hidden');
    }
  }, {
    key: 'showErrorMessage',
    value: function showErrorMessage() {
      this.refs.errorMessage.classList.remove('hidden');
    }
  }, {
    key: 'hideErrorMessage',
    value: function hideErrorMessage() {
      this.refs.errorMessage.classList.add('hidden');
    }
  }, {
    key: 'activateConfig',
    value: function activateConfig() {
      // Package.activateConfig() is part of the Private package API and should not be used outside of core.
      if (atom.packages.isPackageLoaded(this.pack.name) && !atom.packages.isPackageActive(this.pack.name)) {
        this.pack.activateConfig();
      }
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      if (this.settingsPanel) {
        this.settingsPanel.destroy();
        this.settingsPanel = null;
      }

      if (this.keymapView) {
        this.keymapView.destroy();
        this.keymapView = null;
      }

      if (this.grammarsView) {
        this.grammarsView.destroy();
        this.grammarsView = null;
      }

      if (this.snippetsView) {
        this.snippetsView.destroy();
        this.snippetsView = null;
      }

      if (this.readmeView) {
        this.readmeView.destroy();
        this.readmeView = null;
      }

      if (this.packageCard) {
        this.packageCard.destroy();
        this.packageCard = null;
      }

      this.disposables.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {}
  }, {
    key: 'beforeShow',
    value: function beforeShow(opts) {
      if (opts.back == null) {
        opts.back = 'Install';
      }

      this.breadcrumbBackPanel = opts.back;
      this.refs.breadcrumb.textContent = this.breadcrumbBackPanel;
    }
  }, {
    key: 'show',
    value: function show() {
      this.element.style.display = '';
    }
  }, {
    key: 'focus',
    value: function focus() {
      this.element.focus();
    }
  }, {
    key: 'render',
    value: function render() {
      var packageCardView = undefined;
      if (this.pack && this.pack.metadata && this.pack.metadata.owner) {
        packageCardView = _etch2['default'].dom(
          'div',
          { ref: 'packageCardParent', className: 'row' },
          _etch2['default'].dom(PackageCardComponent, {
            ref: 'packageCard',
            settingsView: this.settingsView,
            packageManager: this.packageManager,
            metadata: this.pack.metadata,
            options: { onSettingsView: true } })
        );
      } else {
        packageCardView = _etch2['default'].dom(
          'div',
          { ref: 'packageCardParent', className: 'row' },
          _etch2['default'].dom(
            'div',
            { ref: 'loadingMessage', className: 'alert alert-info icon icon-hourglass' },
            'Loading ' + this.pack.name + '…'
          ),
          _etch2['default'].dom(
            'div',
            { ref: 'errorMessage', className: 'alert alert-danger icon icon-hourglass hidden' },
            'Failed to load ',
            this.pack.name,
            ' - try again later.'
          )
        );
      }
      return _etch2['default'].dom(
        'div',
        { tabIndex: '0', className: 'package-detail' },
        _etch2['default'].dom(
          'ol',
          { ref: 'breadcrumbContainer', className: 'native-key-bindings breadcrumb', tabIndex: '-1' },
          _etch2['default'].dom(
            'li',
            null,
            _etch2['default'].dom('a', { ref: 'breadcrumb' })
          ),
          _etch2['default'].dom(
            'li',
            { className: 'active' },
            _etch2['default'].dom('a', { ref: 'title' })
          )
        ),
        _etch2['default'].dom(
          'div',
          { className: 'panels-item' },
          _etch2['default'].dom(
            'section',
            { className: 'section' },
            _etch2['default'].dom(
              'form',
              { className: 'section-container package-detail-view' },
              _etch2['default'].dom(
                'div',
                { className: 'container package-container' },
                packageCardView
              ),
              _etch2['default'].dom('p', { ref: 'packageRepo', className: 'link icon icon-repo repo-link hidden' }),
              _etch2['default'].dom('p', { ref: 'startupTime', className: 'text icon icon-dashboard hidden', tabIndex: '-1' }),
              _etch2['default'].dom(
                'div',
                { ref: 'buttons', className: 'btn-wrap-group hidden' },
                _etch2['default'].dom(
                  'button',
                  { ref: 'learnMoreButton', className: 'btn btn-default icon icon-link' },
                  'View on Atom.io'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'issueButton', className: 'btn btn-default icon icon-bug' },
                  'Report Issue'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'changelogButton', className: 'btn btn-default icon icon-squirrel' },
                  'CHANGELOG'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'licenseButton', className: 'btn btn-default icon icon-law' },
                  'LICENSE'
                ),
                _etch2['default'].dom(
                  'button',
                  { ref: 'openButton', className: 'btn btn-default icon icon-link-external' },
                  'View Code'
                )
              ),
              _etch2['default'].dom('div', { ref: 'errors' })
            )
          ),
          _etch2['default'].dom('div', { ref: 'sections' })
        )
      );
    }
  }, {
    key: 'populate',
    value: function populate() {
      this.refs.title.textContent = '' + _underscorePlus2['default'].undasherize(_underscorePlus2['default'].uncamelcase(this.pack.name));
      this.type = this.pack.metadata.theme ? 'theme' : 'package';

      var repoUrl = this.packageManager.getRepositoryUrl(this.pack);
      if (repoUrl) {
        var repoName = _url2['default'].parse(repoUrl).pathname;
        this.refs.packageRepo.textContent = repoName.substring(1);
        this.refs.packageRepo.style.display = '';
      } else {
        this.refs.packageRepo.style.display = 'none';
      }

      this.updateInstalledState();
    }
  }, {
    key: 'updateInstalledState',
    value: function updateInstalledState() {
      if (this.settingsPanel) {
        this.settingsPanel.destroy();
        this.settingsPanel = null;
      }

      if (this.keymapView) {
        this.keymapView.destroy();
        this.keymapView = null;
      }

      if (this.grammarsView) {
        this.grammarsView.destroy();
        this.grammarsView = null;
      }

      if (this.snippetsView) {
        this.snippetsView.destroy();
        this.snippetsView = null;
      }

      if (this.readmeView) {
        this.readmeView.destroy();
        this.readmeView = null;
      }

      this.updateFileButtons();
      this.activateConfig();
      this.refs.startupTime.style.display = 'none';

      if (atom.packages.isPackageLoaded(this.pack.name)) {
        if (!atom.packages.isPackageDisabled(this.pack.name)) {
          this.settingsPanel = new _settingsPanel2['default']({ namespace: this.pack.name, includeTitle: false });
          this.keymapView = new _packageKeymapView2['default'](this.pack);
          this.refs.sections.appendChild(this.settingsPanel.element);
          this.refs.sections.appendChild(this.keymapView.element);

          if (this.pack.path) {
            this.grammarsView = new _packageGrammarsView2['default'](this.pack.path);
            this.snippetsView = new _packageSnippetsView2['default'](this.pack, this.snippetsProvider);
            this.refs.sections.appendChild(this.grammarsView.element);
            this.refs.sections.appendChild(this.snippetsView.element);
          }

          this.refs.startupTime.innerHTML = 'This ' + this.type + ' added <span class=\'highlight\'>' + this.getStartupTime() + 'ms</span> to startup time.';
          this.refs.startupTime.style.display = '';
        }
      }

      var sourceIsAvailable = this.packageManager.isPackageInstalled(this.pack.name) && !atom.packages.isBundledPackage(this.pack.name);
      if (sourceIsAvailable) {
        this.refs.openButton.style.display = '';
      } else {
        this.refs.openButton.style.display = 'none';
      }

      this.renderReadme();
    }
  }, {
    key: 'renderReadme',
    value: function renderReadme() {
      var readme = undefined;
      if (this.pack.metadata.readme && this.pack.metadata.readme.trim() !== NORMALIZE_PACKAGE_DATA_README_ERROR) {
        readme = this.pack.metadata.readme;
      } else {
        readme = null;
      }

      if (this.readmePath && !readme) {
        readme = _fsPlus2['default'].readFileSync(this.readmePath, { encoding: 'utf8' });
      }

      var readmeSrc = undefined;

      if (this.pack.path) {
        // If package is installed, use installed path
        readmeSrc = this.pack.path;
      } else {
        // If package isn't installed, use url path
        var repoUrl = this.packageManager.getRepositoryUrl(this.pack);

        // Check if URL is undefined (i.e. package is unpublished)
        if (repoUrl) {
          readmeSrc = repoUrl + '/blob/master/';
        }
      }

      var readmeView = new _packageReadmeView2['default'](readme, readmeSrc);
      if (this.readmeView) {
        this.readmeView.element.parentElement.replaceChild(readmeView.element, this.readmeView.element);
        this.readmeView.destroy();
      } else {
        this.refs.sections.appendChild(readmeView.element);
      }
      this.readmeView = readmeView;
    }
  }, {
    key: 'subscribeToPackageManager',
    value: function subscribeToPackageManager() {
      var _this3 = this;

      this.disposables.add(this.packageManager.on('theme-installed package-installed', function (_ref) {
        var pack = _ref.pack;

        if (_this3.pack.name === pack.name) {
          _this3.loadPackage();
          _this3.updateInstalledState();
        }
      }));

      this.disposables.add(this.packageManager.on('theme-uninstalled package-uninstalled', function (_ref2) {
        var pack = _ref2.pack;

        if (_this3.pack.name === pack.name) {
          return _this3.updateInstalledState();
        }
      }));

      this.disposables.add(this.packageManager.on('theme-updated package-updated', function (_ref3) {
        var pack = _ref3.pack;

        if (_this3.pack.name === pack.name) {
          _this3.loadPackage();
          _this3.updateFileButtons();
          _this3.populate();
        }
      }));
    }
  }, {
    key: 'openMarkdownFile',
    value: function openMarkdownFile(path) {
      if (atom.packages.isPackageActive('markdown-preview')) {
        atom.workspace.open(encodeURI('markdown-preview://' + path));
      } else {
        atom.workspace.open(path);
      }
    }
  }, {
    key: 'updateFileButtons',
    value: function updateFileButtons() {
      this.changelogPath = null;
      this.licensePath = null;
      this.readmePath = null;

      var packagePath = this.pack.path != null ? this.pack.path : atom.packages.resolvePackagePath(this.pack.name);
      for (var child of _fsPlus2['default'].listSync(packagePath)) {
        switch (_path2['default'].basename(child, _path2['default'].extname(child)).toLowerCase()) {
          case 'changelog':
          case 'history':
            this.changelogPath = child;
            break;
          case 'license':
          case 'licence':
            this.licensePath = child;
            break;
          case 'readme':
            this.readmePath = child;
            break;
        }

        if (this.readmePath && this.changelogPath && this.licensePath) {
          break;
        }
      }

      if (this.changelogPath) {
        this.refs.changelogButton.style.display = '';
      } else {
        this.refs.changelogButton.style.display = 'none';
      }

      if (this.licensePath) {
        this.refs.licenseButton.style.display = '';
      } else {
        this.refs.licenseButton.style.display = 'none';
      }
    }
  }, {
    key: 'getStartupTime',
    value: function getStartupTime() {
      var loadTime = this.pack.loadTime != null ? this.pack.loadTime : 0;
      var activateTime = this.pack.activateTime != null ? this.pack.activateTime : 0;
      return loadTime + activateTime;
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return PackageDetailView;
})();

exports['default'] = PackageDetailView;

var PackageCardComponent = (function () {
  function PackageCardComponent(props) {
    _classCallCheck(this, PackageCardComponent);

    this.packageCard = new _packageCard2['default'](props.metadata, props.settingsView, props.packageManager, props.options);
    this.element = this.packageCard.element;
  }

  _createClass(PackageCardComponent, [{
    key: 'update',
    value: function update() {}
  }, {
    key: 'destroy',
    value: function destroy() {}
  }]);

  return PackageCardComponent;
})();

module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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