"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _whatTheDiff = require("what-the-diff");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _filter = require("../models/patch/filter");

var _patch = require("../models/patch");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; var ownKeys = Object.keys(source); if (typeof Object.getOwnPropertySymbols === 'function') { ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) { return Object.getOwnPropertyDescriptor(source, sym).enumerable; })); } ownKeys.forEach(function (key) { _defineProperty(target, key, source[key]); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class PullRequestPatchContainer extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {
      multiFilePatch: null,
      error: null,
      last: {
        url: null,
        patch: null,
        etag: null
      }
    });
  }

  componentDidMount() {
    this.mounted = true;
    this.fetchDiff(this.state.last);
  }

  componentDidUpdate(prevProps) {
    const explicitRefetch = this.props.refetch && !prevProps.refetch;
    const requestedURLChange = this.state.last.url !== this.getDiffURL();

    if (explicitRefetch || requestedURLChange) {
      const {
        last
      } = this.state;
      this.setState({
        multiFilePatch: null,
        error: null,
        last: {
          url: this.getDiffURL(),
          patch: null,
          etag: null
        }
      });
      this.fetchDiff(last);
    }
  }

  componentWillUnmount() {
    this.mounted = false;
  }

  render() {
    return this.props.children(this.state.error, this.state.multiFilePatch);
  } // Generate a v3 GitHub API REST URL for the pull request resource.
  // Example: https://api.github.com/repos/atom/github/pulls/1829


  getDiffURL() {
    return this.props.endpoint.getRestURI('repos', this.props.owner, this.props.repo, 'pulls', this.props.number);
  }

  buildPatch(rawDiff) {
    const {
      filtered,
      removed
    } = (0, _filter.filter)(rawDiff);
    const diffs = (0, _whatTheDiff.parse)(filtered).map(diff => {
      // diff coming from API will have the defaul git diff prefixes a/ and b/ and use *nix-style / path separators.
      // e.g. a/dir/file1.js and b/dir/file2.js
      // see https://git-scm.com/docs/git-diff#_generating_patches_with_p
      return _objectSpread({}, diff, {
        newPath: diff.newPath ? (0, _helpers.toNativePathSep)(diff.newPath.replace(/^[a|b]\//, '')) : diff.newPath,
        oldPath: diff.oldPath ? (0, _helpers.toNativePathSep)(diff.oldPath.replace(/^[a|b]\//, '')) : diff.oldPath
      });
    });
    const options = {
      preserveOriginal: true,
      removed
    };

    if (this.props.largeDiffThreshold) {
      options.largeDiffThreshold = this.props.largeDiffThreshold;
    }

    const mfp = (0, _patch.buildMultiFilePatch)(diffs, options);
    return mfp;
  }

  async fetchDiff(last) {
    const url = this.getDiffURL();
    let response;

    try {
      const headers = {
        Accept: 'application/vnd.github.v3.diff',
        Authorization: `bearer ${this.props.token}`
      };

      if (url === last.url && last.etag !== null) {
        headers['If-None-Match'] = last.etag;
      }

      response = await fetch(url, {
        headers
      });
    } catch (err) {
      return this.reportDiffError(`Network error encountered fetching the patch: ${err.message}.`, err);
    }

    if (response.status === 304) {
      // Not modified.
      if (!this.mounted) {
        return null;
      }

      return new Promise(resolve => this.setState({
        multiFilePatch: last.patch,
        error: null,
        last
      }));
    }

    if (!response.ok) {
      return this.reportDiffError(`Unable to fetch the diff for this pull request: ${response.statusText}.`);
    }

    try {
      const etag = response.headers.get('ETag');
      const rawDiff = await response.text();

      if (!this.mounted) {
        return null;
      }

      const multiFilePatch = this.buildPatch(rawDiff);
      return new Promise(resolve => this.setState({
        multiFilePatch,
        error: null,
        last: {
          url,
          patch: multiFilePatch,
          etag
        }
      }, resolve));
    } catch (err) {
      return this.reportDiffError('Unable to parse the diff for this pull request.', err);
    }
  }

  reportDiffError(message, error) {
    if (!this.mounted) {
      return null;
    }

    return new Promise(resolve => {
      if (error) {
        // eslint-disable-next-line no-console
        console.error(error);
      }

      if (!this.mounted) {
        resolve();
        return;
      }

      this.setState({
        error: message
      }, resolve);
    });
  }

}

exports["default"] = PullRequestPatchContainer;

_defineProperty(PullRequestPatchContainer, "propTypes", {
  // Pull request properties
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  number: _propTypes["default"].number.isRequired,
  // Connection properties
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Fetching and parsing
  refetch: _propTypes["default"].bool,
  largeDiffThreshold: _propTypes["default"].number,
  // Render prop. Called with (error or null, multiFilePatch or null)
  children: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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