/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import javax.lang.model.element.Modifier;

@BugPattern(name="UnsynchronizedOverridesSynchronized", summary="Unsynchronized method overrides a synchronized method.", severity=BugPattern.SeverityLevel.WARNING, tags={"FragileCode"}, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class UnsynchronizedOverridesSynchronized
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)methodTree);
        if (UnsynchronizedOverridesSynchronized.isSynchronized(methodSymbol)) {
            return Description.NO_MATCH;
        }
        for (Symbol.MethodSymbol s : ASTHelpers.findSuperMethods((Symbol.MethodSymbol)methodSymbol, (Types)state.getTypes())) {
            if (!UnsynchronizedOverridesSynchronized.isSynchronized(s) || ASTHelpers.isSameType((Type)s.owner.type, (Type)state.getTypeFromString("java.io.InputStream"), (VisitorState)state)) continue;
            if (UnsynchronizedOverridesSynchronized.ignore(methodTree, state)) {
                return Description.NO_MATCH;
            }
            return this.buildDescription(methodTree).addFix(SuggestedFixes.addModifiers((Tree)methodTree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.SYNCHRONIZED})).setMessage(String.format("Unsynchronized method %s overrides synchronized method in %s", methodSymbol.getSimpleName(), s.enclClass().getSimpleName())).build();
        }
        return Description.NO_MATCH;
    }

    private static boolean isSynchronized(Symbol.MethodSymbol sym) {
        return sym.getModifiers().contains((Object)Modifier.SYNCHRONIZED);
    }

    private static boolean ignore(final MethodTree method, final VisitorState state) {
        return (Boolean)MoreObjects.firstNonNull(new TreeScanner<Boolean, Void>(){

            @Override
            public Boolean visitBlock(BlockTree tree, Void unused) {
                switch (tree.getStatements().size()) {
                    case 0: {
                        return true;
                    }
                    case 1: {
                        return (Boolean)this.scan((Tree)Iterables.getOnlyElement(tree.getStatements()), null);
                    }
                }
                return false;
            }

            @Override
            public Boolean visitReturn(ReturnTree tree, Void unused) {
                return (Boolean)this.scan(tree.getExpression(), null);
            }

            @Override
            public Boolean visitExpressionStatement(ExpressionStatementTree tree, Void unused) {
                return (Boolean)this.scan(tree.getExpression(), null);
            }

            @Override
            public Boolean visitTypeCast(TypeCastTree tree, Void unused) {
                return (Boolean)this.scan(tree.getExpression(), null);
            }

            @Override
            public Boolean visitMethodInvocation(MethodInvocationTree node, Void aVoid) {
                ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)node);
                return receiver instanceof IdentifierTree && ((IdentifierTree)receiver).getName().contentEquals("super") && this.overrides(ASTHelpers.getSymbol((MethodTree)method), ASTHelpers.getSymbol((MethodInvocationTree)node));
            }

            private boolean overrides(Symbol.MethodSymbol sym, Symbol.MethodSymbol other) {
                return !sym.isStatic() && !other.isStatic() && ((sym.flags() | other.flags()) & 0x1000L) == 0L && sym.name.contentEquals(other.name) && sym.overrides(other, sym.owner.enclClass(), state.getTypes(), false);
            }
        }.scan(method.getBody(), null), (Object)false);
    }
}

