/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.Storage;
import org.hsqldb.persist.EventLogInterface;
import org.hsqldb.persist.RAFileHybrid;
import org.hsqldb.persist.RAFileInJar;
import org.hsqldb.persist.RAStorageWrapper;
import org.hsqldb.persist.RandomAccessInterface;

final class RAFile
implements RandomAccessInterface {
    static final int DATA_FILE_RAF = 0;
    static final int DATA_FILE_NIO = 1;
    static final int DATA_FILE_JAR = 2;
    static final int DATA_FILE_STORED = 3;
    static final int DATA_FILE_SINGLE = 4;
    static final int DATA_FILE_TEXT = 5;
    static final int bufferScale = 12;
    static final int bufferSize = 4096;
    static final long bufferMask = -4096L;
    final EventLogInterface logger;
    final RandomAccessFile file;
    final FileDescriptor fileDescriptor;
    private final boolean readOnly;
    final String fileName;
    final byte[] buffer;
    final HsqlByteArrayInputStream ba;
    final byte[] valueBuffer;
    final HsqlByteArrayOutputStream vbao;
    final HsqlByteArrayInputStream vbai;
    long bufferOffset;
    long fileLength;
    final boolean extendLength;
    long seekPosition;
    int cacheHit;

    static RandomAccessInterface newScaledRAFile(Database database, String string, boolean bl, int n) throws FileNotFoundException, IOException {
        if (n == 3) {
            try {
                Class<?> clazz;
                Object object;
                String string2 = database.getURLProperties().getProperty("storage_class_name");
                String string3 = database.getURLProperties().getProperty("storage_key");
                try {
                    object = Thread.currentThread().getContextClassLoader();
                    clazz = ((ClassLoader)object).loadClass(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = Class.forName(string2);
                }
                object = clazz.getConstructor(String.class, Boolean.class, Object.class);
                Object t = ((Constructor)object).newInstance(string, bl, string3);
                if (t instanceof RandomAccessInterface) {
                    return (RandomAccessInterface)t;
                }
                if (t instanceof Storage) {
                    return new RAStorageWrapper((Storage)t);
                }
                throw new IOException();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IOException();
            }
            catch (InstantiationException instantiationException) {
                throw new IOException();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IOException();
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new IOException();
            }
        }
        if (n == 2) {
            return new RAFileInJar(string);
        }
        if (n == 5) {
            return new RAFile(database.logger, string, bl, false, true);
        }
        if (n == 0) {
            return new RAFile(database.logger, string, bl, true, false);
        }
        File file = new File(string);
        long l = file.length();
        if (l > database.logger.propNioMaxSize) {
            return new RAFile(database.logger, string, bl, true, false);
        }
        return new RAFileHybrid(database, string, bl);
    }

    RAFile(EventLogInterface eventLogInterface, String string, boolean bl, boolean bl2, boolean bl3) throws FileNotFoundException, IOException {
        this.logger = eventLogInterface;
        this.fileName = string;
        this.readOnly = bl;
        this.extendLength = bl2;
        String string2 = bl ? "r" : (bl3 ? "rws" : "rw");
        this.file = new RandomAccessFile(string, string2);
        this.buffer = new byte[4096];
        this.ba = new HsqlByteArrayInputStream(this.buffer);
        this.valueBuffer = new byte[8];
        this.vbao = new HsqlByteArrayOutputStream(this.valueBuffer);
        this.vbai = new HsqlByteArrayInputStream(this.valueBuffer);
        this.fileDescriptor = this.file.getFD();
        this.fileLength = this.length();
        this.readIntoBuffer();
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }

    @Override
    public void seek(long l) throws IOException {
        if (this.readOnly && this.fileLength < l) {
            throw new IOException("read beyond end of file");
        }
        this.seekPosition = l;
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.seekPosition;
    }

    private void readIntoBuffer() throws IOException {
        long l = this.seekPosition & 0xFFFFFFFFFFFFF000L;
        long l2 = this.fileLength - l;
        if (l2 > (long)this.buffer.length) {
            l2 = this.buffer.length;
        }
        if (l2 < 0L) {
            throw new IOException("read beyond end of file");
        }
        try {
            this.file.seek(l);
            this.file.readFully(this.buffer, 0, (int)l2);
            this.bufferOffset = l;
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.logger.logWarningEvent("Read Error " + l + " " + l2, iOException);
            throw iOException;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            if (this.seekPosition >= this.fileLength) {
                return -1;
            }
            if (this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++this.cacheHit;
            }
            int n = this.buffer[(int)(this.seekPosition - this.bufferOffset)] & 0xFF;
            ++this.seekPosition;
            return n;
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.logger.logWarningEvent("read failed", iOException);
            throw iOException;
        }
    }

    @Override
    public long readLong() throws IOException {
        this.vbai.reset();
        this.read(this.valueBuffer, 0, 8);
        return this.vbai.readLong();
    }

    @Override
    public int readInt() throws IOException {
        this.vbai.reset();
        this.read(this.valueBuffer, 0, 4);
        return this.vbai.readInt();
    }

    @Override
    public void read(byte[] byArray, int n, int n2) throws IOException {
        try {
            if (this.seekPosition + (long)n2 > this.fileLength) {
                throw new EOFException();
            }
            if (n2 > this.buffer.length && (this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length)) {
                this.file.seek(this.seekPosition);
                this.file.readFully(byArray, n, n2);
                this.seekPosition += (long)n2;
                return;
            }
            if (this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++this.cacheHit;
            }
            this.ba.reset();
            if (this.seekPosition - this.bufferOffset != this.ba.skip(this.seekPosition - this.bufferOffset)) {
                throw new EOFException();
            }
            int n3 = this.ba.read(byArray, n, n2);
            this.seekPosition += (long)n3;
            if (n3 < n2) {
                this.file.seek(this.seekPosition);
                this.file.readFully(byArray, n + n3, n2 - n3);
                this.seekPosition += (long)(n2 - n3);
            }
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.logger.logWarningEvent("failed to read a byte array", iOException);
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.file.seek(this.seekPosition);
            if (this.seekPosition < this.bufferOffset + (long)this.buffer.length && this.seekPosition + (long)n2 > this.bufferOffset) {
                this.writeToBuffer(byArray, n, n2);
            }
            this.file.write(byArray, n, n2);
            this.seekPosition += (long)n2;
            if (!this.extendLength && this.fileLength < this.seekPosition) {
                this.fileLength = this.seekPosition;
            }
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.logger.logWarningEvent("failed to write a byte array", iOException);
            throw iOException;
        }
    }

    @Override
    public void writeInt(int n) throws IOException {
        this.vbao.reset();
        this.vbao.writeInt(n);
        this.write(this.valueBuffer, 0, 4);
    }

    @Override
    public void writeLong(long l) throws IOException {
        this.vbao.reset();
        this.vbao.writeLong(l);
        this.write(this.valueBuffer, 0, 8);
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean ensureLength(long l) {
        if (l <= this.fileLength) {
            return true;
        }
        try {
            this.extendLength(l);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public boolean setLength(long l) {
        try {
            this.file.setLength(l);
            this.file.seek(0L);
            this.fileLength = this.file.length();
            this.seekPosition = 0L;
            this.readIntoBuffer();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public void synch() {
        try {
            this.fileDescriptor.sync();
        }
        catch (Throwable throwable) {
            try {
                this.fileDescriptor.sync();
            }
            catch (Throwable throwable2) {
                this.logger.logSevereEvent("RA file sync error ", throwable2);
                throw Error.error(throwable, 452, null);
            }
        }
    }

    private int writeToBuffer(byte[] byArray, int n, int n2) throws IOException {
        int n3 = ArrayUtil.copyBytes(this.seekPosition - (long)n, byArray, n, n2, this.bufferOffset, this.buffer, this.buffer.length);
        return n3;
    }

    private long getExtendLength(long l) {
        if (!this.extendLength) {
            return l;
        }
        int n = l < 262144L ? 2 : (l < 0x100000L ? 6 : (l < 0x2000000L ? 8 : 12));
        l = ArrayUtil.getBinaryNormalisedCeiling(l, 12 + n);
        return l;
    }

    private void extendLength(long l) throws IOException {
        long l2 = this.getExtendLength(l);
        if (l2 > this.fileLength) {
            try {
                this.file.seek(l2 - 1L);
                this.file.write(0);
                this.fileLength = l2;
            }
            catch (IOException iOException) {
                this.logger.logWarningEvent("data file enlarge failed ", iOException);
                throw iOException;
            }
        }
    }

    private void resetPointer() {
        try {
            this.seekPosition = 0L;
            this.fileLength = this.length();
            this.readIntoBuffer();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

