/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.retained;

import com.sun.j3d.utils.scenegraph.io.NamedObjectException;
import com.sun.j3d.utils.scenegraph.io.ObjectNotLoadedException;
import com.sun.j3d.utils.scenegraph.io.SceneGraphObjectReferenceControl;
import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.RandomAccessFileControl;
import com.sun.j3d.utils.scenegraph.io.retained.SGIORuntimeException;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NodeComponentState;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.NullSceneGraphObjectState;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.SceneGraphObjectState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Stack;
import javax.media.j3d.Node;
import javax.media.j3d.NodeComponent;
import javax.media.j3d.SceneGraphObject;

public class SymbolTable
implements SceneGraphObjectReferenceControl {
    private int nodeID = 1;
    private HashMap j3dNodeIndex;
    private ArrayList nodeIDIndex;
    private HashMap danglingReferences;
    private Stack unsavedNodeComponentsStack;
    private LinkedList sharedNodes;
    private HashMap namedObjects;
    private ArrayList branchGraphs;
    private ArrayList branchGraphDependencies;
    private Controller control;
    private int currentBranchGraphID = -1;
    private int nextBranchGraphID = 0;

    public SymbolTable(Controller controller) {
        this.control = controller;
        this.j3dNodeIndex = new HashMap();
        this.danglingReferences = new HashMap();
        this.nodeIDIndex = new ArrayList();
        this.nodeIDIndex.add(null);
        this.sharedNodes = new LinkedList();
        this.namedObjects = new HashMap();
        this.branchGraphs = new ArrayList();
        this.branchGraphDependencies = new ArrayList();
        this.unsavedNodeComponentsStack = new Stack();
    }

    private void checkforDanglingReferences() {
        ListIterator listIterator = this.sharedNodes.listIterator();
        while (listIterator.hasNext()) {
            SymbolTableData symbolTableData = (SymbolTableData)listIterator.next();
            if (symbolTableData.branchGraphID != -3) continue;
            System.err.println("Warning : node " + symbolTableData.j3dNode + " is referenced but is not attached to a BranchGraph");
            System.err.println("Setting reference to null. This scene may not look correct when loaded");
        }
    }

    private void removeNullDependencies(HashSet hashSet) {
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            SymbolTableData symbolTableData = (SymbolTableData)iterator.next();
            if (symbolTableData.branchGraphID != -3) continue;
            iterator.remove();
        }
    }

    public void writeTable(DataOutput dataOutput) throws IOException {
        Object object;
        Object object2;
        int n;
        Object object3;
        this.checkforDanglingReferences();
        ListIterator listIterator = this.sharedNodes.listIterator();
        dataOutput.writeInt(this.sharedNodes.size());
        dataOutput.writeInt(this.nodeID);
        while (listIterator.hasNext()) {
            object3 = (SymbolTableData)listIterator.next();
            ((SymbolTableData)object3).writeObject(dataOutput);
        }
        object3 = this.getNames();
        dataOutput.writeInt(((String[])object3).length);
        for (n = 0; n < ((Object)object3).length; ++n) {
            dataOutput.writeUTF((String)object3[n]);
            object2 = (SceneGraphObject)this.namedObjects.get(object3[n]);
            object = this.getSymbol((SceneGraphObject)object2);
            if (object != null) {
                dataOutput.writeInt(((SymbolTableData)object).nodeID);
                continue;
            }
            dataOutput.writeInt(0);
        }
        dataOutput.writeInt(this.branchGraphs.size());
        for (n = 0; n < this.branchGraphs.size(); ++n) {
            ((SymbolTableData)this.branchGraphs.get(n)).writeObject(dataOutput);
        }
        for (n = 0; n < this.branchGraphDependencies.size(); ++n) {
            object2 = (HashSet)this.branchGraphDependencies.get(n);
            if (object2 == null) {
                dataOutput.writeInt(0);
                continue;
            }
            this.removeNullDependencies((HashSet)object2);
            dataOutput.writeInt(((HashSet)object2).size());
            object = ((HashSet)object2).iterator();
            while (object.hasNext()) {
                SymbolTableData symbolTableData = (SymbolTableData)object.next();
                dataOutput.writeInt(symbolTableData.nodeID);
            }
        }
    }

    public void readTable(DataInput dataInput, boolean bl) throws IOException {
        Object object;
        int n;
        int n2 = dataInput.readInt();
        this.nodeID = dataInput.readInt();
        this.nodeIDIndexEnsureCapacity(this.nodeID);
        for (n = 0; n < n2; ++n) {
            object = new SymbolTableData(0, null, null, -1);
            ((SymbolTableData)object).readObject(dataInput);
            if (bl) continue;
            this.sharedNodes.add(object);
            this.nodeIDIndex.set(((SymbolTableData)object).nodeID, object);
        }
        n2 = dataInput.readInt();
        for (n = 0; n < n2; ++n) {
            object = dataInput.readUTF();
            int n3 = dataInput.readInt();
            this.namedObjects.put(object, new Integer(n3));
        }
        n2 = dataInput.readInt();
        for (n = 0; n < n2; ++n) {
            this.branchGraphs.add(null);
        }
        for (n = 0; n < n2; ++n) {
            object = new SymbolTableData(0, null, null, -1);
            ((SymbolTableData)object).readObject(dataInput);
            Object object2 = this.getSymbol(((SymbolTableData)object).nodeID);
            if (object2 == null) {
                object2 = object;
                if (((SymbolTableData)object2).referenceCount > 1) {
                    this.sharedNodes.add(object2);
                }
                this.nodeIDIndex.set(((SymbolTableData)object2).nodeID, object2);
            }
            this.branchGraphs.set(n, object2);
        }
        for (n = 0; n < n2; ++n) {
            int n4 = dataInput.readInt();
            if (n4 == 0) {
                this.branchGraphDependencies.add(null);
                continue;
            }
            HashSet<SymbolTableData> hashSet = new HashSet<SymbolTableData>();
            this.branchGraphDependencies.add(hashSet);
            for (int i = 0; i < n4; ++i) {
                hashSet.add(this.getSymbol(dataInput.readInt()));
            }
        }
    }

    public void setBranchGraphRoot(SymbolTableData symbolTableData, long l) {
        if (symbolTableData.branchGraphID < 0) {
            symbolTableData.branchGraphID = this.nextBranchGraphID++;
        }
        this.currentBranchGraphID = symbolTableData.branchGraphID;
        for (int i = this.branchGraphs.size(); i < this.currentBranchGraphID + 1; ++i) {
            this.branchGraphs.add(null);
            this.branchGraphDependencies.add(null);
        }
        this.branchGraphs.set(this.currentBranchGraphID, symbolTableData);
        symbolTableData.branchGraphFilePointer = l;
    }

    public SymbolTableData getBranchGraphRoot(int n) {
        return (SymbolTableData)this.branchGraphs.get(n);
    }

    public void setBranchGraphID(SymbolTableData symbolTableData) {
        symbolTableData.branchGraphID = this.currentBranchGraphID;
    }

    public int[] getBranchGraphDependencies(int n) {
        HashSet hashSet = (HashSet)this.branchGraphDependencies.get(n);
        if (hashSet == null) {
            return new int[0];
        }
        int[] nArray = new int[hashSet.size()];
        Iterator iterator = hashSet.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            nArray[n2++] = ((SymbolTableData)iterator.next()).branchGraphID;
        }
        return nArray;
    }

    public boolean branchGraphHasDependencies(int n) {
        HashSet hashSet = (HashSet)this.branchGraphDependencies.get(n);
        return hashSet != null && hashSet.size() != 0;
    }

    public int getBranchGraphCount() {
        return this.branchGraphs.size();
    }

    public long getBranchGraphFilePosition(int n) {
        SymbolTableData symbolTableData = (SymbolTableData)this.branchGraphs.get(n);
        return symbolTableData.branchGraphFilePointer;
    }

    public SymbolTableData createSymbol(SceneGraphObject sceneGraphObject) {
        SymbolTableData symbolTableData = (SymbolTableData)this.j3dNodeIndex.get(sceneGraphObject);
        SymbolTableData symbolTableData2 = (SymbolTableData)this.danglingReferences.get(sceneGraphObject);
        if (symbolTableData2 != null) {
            symbolTableData = symbolTableData2;
            symbolTableData.branchGraphID = this.currentBranchGraphID;
            this.danglingReferences.remove(symbolTableData2);
        } else if (symbolTableData == null) {
            symbolTableData = new SymbolTableData(this.nodeID++, sceneGraphObject, null, this.currentBranchGraphID);
            this.j3dNodeIndex.put(sceneGraphObject, symbolTableData);
            this.nodeIDIndex.add(symbolTableData);
        } else if (symbolTableData.j3dNode instanceof Node) {
            throw new RuntimeException("Object already in Symbol table " + sceneGraphObject);
        }
        return symbolTableData;
    }

    public SymbolTableData createSymbol(SceneGraphObjectState sceneGraphObjectState, SceneGraphObject sceneGraphObject, int n) {
        SymbolTableData symbolTableData = (SymbolTableData)this.j3dNodeIndex.get(sceneGraphObject);
        if (symbolTableData == null) {
            this.nodeIDIndexEnsureCapacity(n);
            symbolTableData = (SymbolTableData)this.nodeIDIndex.get(n);
            if (symbolTableData == null) {
                symbolTableData = new SymbolTableData(n, sceneGraphObject, sceneGraphObjectState, -2);
                this.j3dNodeIndex.put(sceneGraphObject, symbolTableData);
                this.nodeIDIndex.set(symbolTableData.getNodeID(), symbolTableData);
            } else if (symbolTableData.getJ3dNode() == null) {
                symbolTableData.j3dNode = sceneGraphObject;
                symbolTableData.nodeState = sceneGraphObjectState;
                this.j3dNodeIndex.put(sceneGraphObject, symbolTableData);
            }
        } else {
            throw new SGIORuntimeException("Object already in Symbol table ");
        }
        return symbolTableData;
    }

    private void nodeIDIndexEnsureCapacity(int n) {
        this.nodeIDIndex.ensureCapacity(n);
        int n2 = n - this.nodeIDIndex.size();
        for (int i = 0; i <= n2; ++i) {
            this.nodeIDIndex.add(null);
        }
    }

    private SymbolTableData createDanglingSymbol(SceneGraphObject sceneGraphObject) {
        SymbolTableData symbolTableData = (SymbolTableData)this.j3dNodeIndex.get(sceneGraphObject);
        if (symbolTableData == null) {
            symbolTableData = new SymbolTableData(this.nodeID++, sceneGraphObject, null, -3);
            this.j3dNodeIndex.put(sceneGraphObject, symbolTableData);
            this.nodeIDIndex.add(symbolTableData);
            this.danglingReferences.put(sceneGraphObject, symbolTableData);
        } else if (symbolTableData.nodeState == null) {
            if (symbolTableData.referenceCount == 1) {
                this.sharedNodes.add(symbolTableData);
            }
            ++symbolTableData.referenceCount;
        } else {
            throw new SGIORuntimeException("Object already in Symbol table ");
        }
        return symbolTableData;
    }

    private SymbolTableData createNodeComponentSymbol(SceneGraphObject sceneGraphObject) {
        SymbolTableData symbolTableData = new SymbolTableData(this.nodeID++, sceneGraphObject, null, this.currentBranchGraphID);
        symbolTableData.isNodeComponent = true;
        this.j3dNodeIndex.put(sceneGraphObject, symbolTableData);
        this.nodeIDIndex.add(symbolTableData);
        ((LinkedList)this.unsavedNodeComponentsStack.peek()).add(symbolTableData);
        this.control.createState(symbolTableData);
        return symbolTableData;
    }

    public int getUnsavedNodeComponentsSize() {
        return ((LinkedList)this.unsavedNodeComponentsStack.peek()).size();
    }

    public ListIterator getUnsavedNodeComponents() {
        return ((LinkedList)this.unsavedNodeComponentsStack.peek()).listIterator(0);
    }

    public void startUnsavedNodeComponentFrame() {
        this.unsavedNodeComponentsStack.push(new LinkedList());
    }

    public void endUnsavedNodeComponentFrame() {
        this.unsavedNodeComponentsStack.pop();
        this.confirmInterGraphDependency();
    }

    private void confirmInterGraphDependency() {
        HashSet hashSet = (HashSet)this.branchGraphDependencies.get(this.currentBranchGraphID);
        if (hashSet == null) {
            return;
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            SymbolTableData symbolTableData = (SymbolTableData)iterator.next();
            if (symbolTableData.branchGraphID != this.currentBranchGraphID) continue;
            iterator.remove();
        }
    }

    private void addInterGraphDependency(SymbolTableData symbolTableData) {
        HashSet<SymbolTableData> hashSet = (HashSet<SymbolTableData>)this.branchGraphDependencies.get(this.currentBranchGraphID);
        if (hashSet == null) {
            hashSet = new HashSet<SymbolTableData>();
            this.branchGraphDependencies.set(this.currentBranchGraphID, hashSet);
        }
        hashSet.add(symbolTableData);
    }

    public void incNodeComponentRefCount(int n) {
        if (n == 0) {
            return;
        }
        SymbolTableData symbolTableData = this.getSymbol(n);
        ((NodeComponentState)symbolTableData.nodeState).addSubReference();
        if (symbolTableData.referenceCount == 1) {
            this.sharedNodes.add(symbolTableData);
        }
        ++symbolTableData.referenceCount;
    }

    @Override
    public int addReference(SceneGraphObject sceneGraphObject) {
        if (sceneGraphObject == null) {
            return 0;
        }
        SymbolTableData symbolTableData = this.getSymbol(sceneGraphObject);
        if (symbolTableData == null) {
            if (sceneGraphObject instanceof Node) {
                symbolTableData = this.createDanglingSymbol(sceneGraphObject);
                if (symbolTableData.branchGraphID != this.currentBranchGraphID) {
                    this.addInterGraphDependency(symbolTableData);
                    this.sharedNodes.add(symbolTableData);
                }
            } else {
                symbolTableData = this.createNodeComponentSymbol(sceneGraphObject);
            }
            return symbolTableData.nodeID;
        }
        return this.addReference(symbolTableData);
    }

    public int addReference(SymbolTableData symbolTableData) {
        if (symbolTableData != null) {
            if (symbolTableData.referenceCount == 1) {
                this.sharedNodes.add(symbolTableData);
            }
            ++symbolTableData.referenceCount;
            if (symbolTableData.j3dNode instanceof NodeComponent && symbolTableData.referenceCount > 1) {
                ((NodeComponentState)symbolTableData.nodeState).addSubReference();
            }
            if (symbolTableData.branchGraphID != this.currentBranchGraphID && symbolTableData.j3dNode instanceof Node) {
                this.addInterGraphDependency(symbolTableData);
            }
        } else {
            throw new SGIORuntimeException("Null Symbol");
        }
        return symbolTableData.nodeID;
    }

    public int addBranchGraphReference(SceneGraphObject sceneGraphObject, int n) {
        if (sceneGraphObject == null) {
            return 0;
        }
        SymbolTableData symbolTableData = this.getSymbol(sceneGraphObject);
        if (symbolTableData != null) {
            if (symbolTableData.referenceCount == 1) {
                this.sharedNodes.add(symbolTableData);
            }
            ++symbolTableData.referenceCount;
        } else {
            symbolTableData = new SymbolTableData(this.nodeID++, sceneGraphObject, null, -3);
            this.j3dNodeIndex.put(sceneGraphObject, symbolTableData);
            this.nodeIDIndex.add(symbolTableData);
            this.danglingReferences.put(sceneGraphObject, symbolTableData);
        }
        symbolTableData.branchGraphID = n;
        for (int i = this.branchGraphs.size(); i < n + 1; ++i) {
            this.branchGraphs.add(null);
            this.branchGraphDependencies.add(null);
        }
        this.branchGraphs.set(symbolTableData.branchGraphID, symbolTableData);
        return symbolTableData.nodeID;
    }

    public boolean isLoaded(int n) {
        SymbolTableData symbolTableData = this.getSymbol(n);
        if (symbolTableData == null) {
            return false;
        }
        return symbolTableData.j3dNode != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SceneGraphObject getJ3dNode(int n) {
        if (n == 0) {
            return null;
        }
        SymbolTableData symbolTableData = this.getSymbol(n);
        if (symbolTableData.branchGraphID == -3) {
            return null;
        }
        if (symbolTableData != null && symbolTableData.j3dNode == null) {
            if (symbolTableData.isNodeComponent && this.control instanceof RandomAccessFileControl) {
                try {
                    ((RandomAccessFileControl)this.control).loadNodeComponent(symbolTableData);
                }
                catch (IOException iOException) {
                    System.out.println("FAILED to seek and load NodeComponent");
                    return null;
                }
            } else {
                System.out.println("WARNING - Object has not been loaded " + n);
                System.out.println("Need to load branchgraph " + symbolTableData.branchGraphID);
                return null;
            }
        }
        if (symbolTableData == null) {
            throw new SGIORuntimeException("Missing Symbol " + n);
        }
        if (!symbolTableData.graphBuilt) {
            symbolTableData.graphBuilt = true;
            symbolTableData.nodeState.buildGraph();
        }
        return symbolTableData.j3dNode;
    }

    public SymbolTableData getSymbol(SceneGraphObject sceneGraphObject) {
        return (SymbolTableData)this.j3dNodeIndex.get(sceneGraphObject);
    }

    public SymbolTableData getSymbol(int n) {
        if (n == 0 || n > this.nodeIDIndex.size()) {
            return null;
        }
        return (SymbolTableData)this.nodeIDIndex.get(n);
    }

    public SymbolTableData getSharedGroup(int n) {
        SymbolTableData symbolTableData = this.getSymbol(n);
        if (symbolTableData.nodeState == null && this.control instanceof RandomAccessFileControl) {
            try {
                ((RandomAccessFileControl)this.control).loadSharedGroup(symbolTableData);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new SGIORuntimeException("Internal error in getSharedGroup");
            }
        }
        return symbolTableData;
    }

    public void setFilePosition(long l, SceneGraphObjectState sceneGraphObjectState) {
        if (sceneGraphObjectState instanceof NullSceneGraphObjectState) {
            return;
        }
        SymbolTableData symbolTableData = this.getSymbol(sceneGraphObjectState.getNodeID());
        symbolTableData.filePosition = l;
    }

    public void addNamedObject(String string, SceneGraphObject sceneGraphObject) {
        this.namedObjects.put(string, sceneGraphObject);
    }

    public void addNamedObjects(HashMap hashMap) {
        if (hashMap != null) {
            this.namedObjects.putAll(hashMap);
        }
    }

    public SceneGraphObject getNamedObject(String string) throws NamedObjectException, ObjectNotLoadedException {
        Object v = this.namedObjects.get(string);
        if (v == null) {
            throw new NamedObjectException("Unknown name :" + string);
        }
        if (v instanceof SceneGraphObject) {
            return (SceneGraphObject)v;
        }
        SymbolTableData symbolTableData = this.getSymbol((Integer)v);
        if (symbolTableData == null || symbolTableData.j3dNode == null) {
            throw new ObjectNotLoadedException(((Integer)v).toString());
        }
        return symbolTableData.j3dNode;
    }

    public String[] getNames() {
        return this.namedObjects.keySet().toArray(new String[0]);
    }

    public void getNamedObjectMap(HashMap hashMap) {
        hashMap.putAll(this.namedObjects);
    }

    public String toString() {
        Object object;
        int n;
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.nodeIDIndex.size(); ++i) {
            stringArray = (String[])this.nodeIDIndex.get(i);
            if (stringArray == null) continue;
            stringBuffer.append(stringArray.nodeID + " " + stringArray.referenceCount + " " + stringArray.filePosition + "  " + stringArray.branchGraphID + "  " + stringArray.nodeState + "\n");
        }
        stringBuffer.append("\nShared Objects\n");
        ListIterator listIterator = this.sharedNodes.listIterator();
        while (listIterator.hasNext()) {
            stringArray = (SymbolTableData)listIterator.next();
            stringBuffer.append(stringArray.nodeID + " " + stringArray.referenceCount + " " + stringArray.filePosition + "  " + stringArray.branchGraphID + "  " + stringArray.j3dNode + "\n");
        }
        stringBuffer.append("\nNamed Objects\n");
        stringArray = this.getNames();
        for (n = 0; n < stringArray.length; ++n) {
            stringBuffer.append(stringArray[n] + "  " + this.namedObjects.get(stringArray[n]));
        }
        stringBuffer.append("\nBranch Graphs\n");
        for (n = 0; n < this.branchGraphs.size(); ++n) {
            object = (SymbolTableData)this.branchGraphs.get(n);
            if (object == null) {
                System.out.println("Data is null " + n + "  " + this.branchGraphs.size());
            }
            stringBuffer.append(((SymbolTableData)object).nodeID + " " + ((SymbolTableData)object).referenceCount + " " + ((SymbolTableData)object).filePosition + "  " + ((SymbolTableData)object).branchGraphID + "  " + ((SymbolTableData)object).j3dNode + " " + ((SymbolTableData)object).nodeState + "\n");
        }
        stringBuffer.append("\nBranch Graph Dependencies\n");
        for (n = 0; n < this.branchGraphDependencies.size(); ++n) {
            stringBuffer.append("Graph " + n + " - ");
            object = (HashSet)this.branchGraphDependencies.get(n);
            if (object != null) {
                Iterator iterator = ((HashSet)object).iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(((SymbolTableData)iterator.next()).nodeID + " ");
                }
            }
            stringBuffer.append("\n");
        }
        stringBuffer.append("------------------");
        return stringBuffer.toString();
    }

    public void clear() {
        this.j3dNodeIndex.clear();
        this.nodeIDIndex.clear();
        while (!this.unsavedNodeComponentsStack.empty()) {
            this.unsavedNodeComponentsStack.pop();
        }
        this.danglingReferences.clear();
        this.sharedNodes.clear();
        this.namedObjects.clear();
        this.nodeID = 1;
    }

    public void clearUnshared() {
        Object object;
        String[] stringArray = this.getNames();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                SymbolTableData symbolTableData;
                object = this.namedObjects.get(stringArray[i]);
                if (!(object instanceof Integer) || (symbolTableData = this.getSymbol((Integer)object)) == null || symbolTableData.j3dNode == null) continue;
                this.namedObjects.put(stringArray[i], symbolTableData.j3dNode);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.j3dNodeIndex.clear();
        this.nodeIDIndex.clear();
        while (!this.unsavedNodeComponentsStack.empty()) {
            this.unsavedNodeComponentsStack.pop();
        }
        this.nodeIDIndexEnsureCapacity(this.nodeID);
        ListIterator listIterator = this.sharedNodes.listIterator();
        while (listIterator.hasNext()) {
            object = (SymbolTableData)listIterator.next();
            this.nodeIDIndex.set(((SymbolTableData)object).nodeID, object);
            this.j3dNodeIndex.put(((SymbolTableData)object).j3dNode, object);
        }
        for (SymbolTableData symbolTableData : this.danglingReferences.values()) {
            this.nodeIDIndex.set(symbolTableData.nodeID, symbolTableData);
            this.j3dNodeIndex.put(symbolTableData.j3dNode, symbolTableData);
        }
    }

    @Override
    public SceneGraphObject resolveReference(int n) {
        return this.getJ3dNode(n);
    }
}

