/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.forkjoin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import scala.concurrent.forkjoin.CountedCompleter;
import scala.concurrent.forkjoin.ForkJoinPool$DefaultForkJoinWorkerThreadFactory;
import scala.concurrent.forkjoin.ForkJoinPool$ForkJoinWorkerThreadFactory;
import scala.concurrent.forkjoin.ForkJoinPool$ManagedBlocker;
import scala.concurrent.forkjoin.ForkJoinPool$Submitter;
import scala.concurrent.forkjoin.ForkJoinPool$WorkQueue;
import scala.concurrent.forkjoin.ForkJoinTask;
import scala.concurrent.forkjoin.ForkJoinTask$AdaptedCallable;
import scala.concurrent.forkjoin.ForkJoinTask$AdaptedRunnable;
import scala.concurrent.forkjoin.ForkJoinTask$AdaptedRunnableAction;
import scala.concurrent.forkjoin.ForkJoinWorkerThread;
import sun.misc.Unsafe;

public class ForkJoinPool
extends AbstractExecutorService {
    private static ForkJoinPool$ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory;
    private static ThreadLocal submitters;
    private static final RuntimePermission modifyThreadPermission;
    static final ForkJoinPool common;
    private static int poolNumberSequence;
    private volatile long ctl;
    private volatile int plock;
    private int config;
    private ForkJoinPool$WorkQueue[] workQueues;
    private ForkJoinPool$ForkJoinWorkerThreadFactory factory;
    private Thread.UncaughtExceptionHandler ueh;
    private String workerNamePrefix;
    private static final Unsafe U;
    private static final long CTL;
    private static final long PARKBLOCKER;
    private static final int ABASE;
    private static final int ASHIFT;
    private static final long STEALCOUNT;
    private static final long PLOCK;
    private static final long INDEXSEED;
    private static final long QLOCK;

    private static void checkPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(modifyThreadPermission);
        }
    }

    private static final synchronized int nextPoolId() {
        return ++poolNumberSequence;
    }

    private int acquirePlock() {
        int n = 256;
        int n2 = 0;
        int n3;
        int n4;
        while (((n4 = this.plock) & 2) != 0 || !U.compareAndSwapInt(this, PLOCK, n4, n3 = n4 + 2)) {
            Object object;
            if (n2 == 0) {
                ForkJoinPool$WorkQueue forkJoinPool$WorkQueue;
                object = Thread.currentThread();
                if (object instanceof ForkJoinWorkerThread && (forkJoinPool$WorkQueue = ((ForkJoinWorkerThread)object).workQueue) != null) {
                    n2 = forkJoinPool$WorkQueue.seed;
                    continue;
                }
                ForkJoinPool$Submitter forkJoinPool$Submitter = (ForkJoinPool$Submitter)submitters.get();
                if (forkJoinPool$Submitter != null) {
                    n2 = forkJoinPool$Submitter.seed;
                    continue;
                }
                n2 = 1;
                continue;
            }
            if (n >= 0) {
                n2 ^= n2 << 1;
                n2 ^= n2 >>> 3;
                if ((n2 ^= n2 << 10) < 0) continue;
                --n;
                continue;
            }
            if (!U.compareAndSwapInt(this, PLOCK, n4, n4 | 1)) continue;
            object = this;
            synchronized (object) {
                if ((this.plock & 1) != 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        try {
                            Thread.currentThread().interrupt();
                        }
                        catch (SecurityException securityException) {}
                    }
                } else {
                    this.notifyAll();
                }
            }
        }
        return n3;
    }

    private void releasePlock(int n) {
        this.plock = n;
        ForkJoinPool forkJoinPool = this;
        synchronized (forkJoinPool) {
            this.notifyAll();
            return;
        }
    }

    private void tryAddWorker() {
        long l;
        int n;
        while ((n = (int)((l = this.ctl) >>> 32)) < 0 && (n & 0x8000) != 0 && (int)l == 0) {
            long l2 = (long)(n + 1 & 0xFFFF | n + 65536 & 0xFFFF0000) << 32;
            if (!U.compareAndSwapLong(this, CTL, l, l2)) continue;
            Throwable throwable = null;
            ForkJoinWorkerThread forkJoinWorkerThread = null;
            try {
                ForkJoinPool$ForkJoinWorkerThreadFactory forkJoinPool$ForkJoinWorkerThreadFactory = this.factory;
                if (forkJoinPool$ForkJoinWorkerThreadFactory != null && (forkJoinWorkerThread = forkJoinPool$ForkJoinWorkerThreadFactory.newThread(this)) != null) {
                    forkJoinWorkerThread.start();
                    return;
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            this.deregisterWorker(forkJoinWorkerThread, throwable);
            return;
        }
    }

    final ForkJoinPool$WorkQueue registerWorker(ForkJoinWorkerThread forkJoinWorkerThread) {
        forkJoinWorkerThread.setDaemon(true);
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = this.ueh;
        if (uncaughtExceptionHandler != null) {
            forkJoinWorkerThread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
        }
        while (!U.compareAndSwapInt(this, INDEXSEED, 0, 1640531527)) {
        }
        ForkJoinPool$WorkQueue forkJoinPool$WorkQueue = new ForkJoinPool$WorkQueue(this, forkJoinWorkerThread, this.config >>> 16, 1640531527);
        int n = this.plock;
        if ((n & 2) != 0 || !U.compareAndSwapInt(this, PLOCK, n, n += 2)) {
            n = this.acquirePlock();
        }
        int n2 = n & Integer.MIN_VALUE | n + 2 & Integer.MAX_VALUE;
        try {
            ForkJoinPool$WorkQueue[] forkJoinPool$WorkQueueArray = this.workQueues;
            if (this.workQueues != null) {
                int n3 = forkJoinPool$WorkQueueArray.length;
                int n4 = n3 - 1;
                int n5 = 0xC3910C8F & n4;
                if (forkJoinPool$WorkQueueArray[n5] != null) {
                    int n6;
                    int n7 = 0;
                    int n8 = n6 = n3 <= 4 ? 2 : (n3 >>> 1 & 0xFFFE) + 2;
                    while (forkJoinPool$WorkQueueArray[n5 = n5 + n6 & n4] != null) {
                        if (++n7 < n3) continue;
                        this.workQueues = forkJoinPool$WorkQueueArray = Arrays.copyOf(forkJoinPool$WorkQueueArray, n3 <<= 1);
                        n4 = n3 - 1;
                        n7 = 0;
                    }
                }
                forkJoinPool$WorkQueue.eventCount = forkJoinPool$WorkQueue.poolIndex = n5;
                forkJoinPool$WorkQueueArray[n5] = forkJoinPool$WorkQueue;
            }
        }
        finally {
            if (!U.compareAndSwapInt(this, PLOCK, n, n2)) {
                this.releasePlock(n2);
            }
        }
        forkJoinWorkerThread.setName(this.workerNamePrefix.concat(Integer.toString(forkJoinPool$WorkQueue.poolIndex)));
        return forkJoinPool$WorkQueue;
    }

    final void deregisterWorker(ForkJoinWorkerThread forkJoinWorkerThread, Throwable throwable) {
        long l;
        int n;
        int n2;
        ForkJoinPool$WorkQueue forkJoinPool$WorkQueue = null;
        if (forkJoinWorkerThread != null && (forkJoinPool$WorkQueue = forkJoinWorkerThread.workQueue) != null) {
            forkJoinPool$WorkQueue.qlock = -1;
            long l2 = forkJoinPool$WorkQueue.nsteals;
            while (!U.compareAndSwapLong(this, STEALCOUNT, 0L, l2)) {
            }
            int n3 = this.plock;
            if ((n3 & 2) != 0 || !U.compareAndSwapInt(this, PLOCK, n3, n3 += 2)) {
                n3 = this.acquirePlock();
            }
            n2 = n3 & Integer.MIN_VALUE | n3 + 2 & Integer.MAX_VALUE;
            try {
                n = forkJoinPool$WorkQueue.poolIndex;
                ForkJoinPool$WorkQueue[] forkJoinPool$WorkQueueArray = this.workQueues;
                if (this.workQueues != null && n >= 0 && n < forkJoinPool$WorkQueueArray.length && forkJoinPool$WorkQueueArray[n] == forkJoinPool$WorkQueue) {
                    forkJoinPool$WorkQueueArray[n] = null;
                }
            }
            finally {
                if (!U.compareAndSwapInt(this, PLOCK, n3, n2)) {
                    this.releasePlock(n2);
                }
            }
        }
        while (!U.compareAndSwapLong(this, CTL, l = this.ctl, l - 0x1000000000000L & 0xFFFF000000000000L | l - 0x100000000L & 0xFFFF00000000L | l & 0xFFFFFFFFL)) {
        }
        if (!this.tryTerminate(false, false) && forkJoinPool$WorkQueue != null && forkJoinPool$WorkQueue.array != null) {
            int n4;
            forkJoinPool$WorkQueue.cancelAll();
            while ((n2 = (int)((l = this.ctl) >>> 32)) < 0 && (n4 = (int)l) >= 0) {
                if (n4 > 0) {
                    ForkJoinPool$WorkQueue forkJoinPool$WorkQueue2;
                    ForkJoinPool$WorkQueue[] forkJoinPool$WorkQueueArray = this.workQueues;
                    if (this.workQueues == null || (n = n4 & 0xFFFF) >= forkJoinPool$WorkQueueArray.length || (forkJoinPool$WorkQueue2 = forkJoinPool$WorkQueueArray[n]) == null) break;
                    long l3 = (long)(forkJoinPool$WorkQueue2.nextWait & Integer.MAX_VALUE) | (long)(n2 + 65536) << 32;
                    if (forkJoinPool$WorkQueue2.eventCount != (n4 | Integer.MIN_VALUE)) break;
                    if (!U.compareAndSwapLong(this, CTL, l, l3)) continue;
                    forkJoinPool$WorkQueue2.eventCount = n4 + 65536 & Integer.MAX_VALUE;
                    Thread thread = forkJoinPool$WorkQueue2.parker;
                    if (thread == null) break;
                    U.unpark(thread);
                    break;
                }
                if ((short)n2 >= 0) break;
                this.tryAddWorker();
                break;
            }
        }
        if (throwable == null) {
            ForkJoinTask.helpExpungeStaleExceptions();
            return;
        }
        ForkJoinTask.rethrow(throwable);
    }

    final void externalPush(ForkJoinTask forkJoinTask) {
        ForkJoinPool$Submitter forkJoinPool$Submitter = (ForkJoinPool$Submitter)submitters.get();
        if (forkJoinPool$Submitter != null && this.plock > 0) {
            ForkJoinPool$WorkQueue forkJoinPool$WorkQueue;
            int n;
            ForkJoinPool$WorkQueue[] forkJoinPool$WorkQueueArray = this.workQueues;
            if (this.workQueues != null && (n = forkJoinPool$WorkQueueArray.length - 1) >= 0 && (forkJoinPool$WorkQueue = forkJoinPool$WorkQueueArray[n & forkJoinPool$Submitter.seed & 0x7E]) != null && U.compareAndSwapInt(forkJoinPool$WorkQueue, QLOCK, 0, 1)) {
                int n2;
                int n3;
                int n4 = forkJoinPool$WorkQueue.base;
                int n5 = forkJoinPool$WorkQueue.top;
                ForkJoinTask[] forkJoinTaskArray = forkJoinPool$WorkQueue.array;
                if (forkJoinPool$WorkQueue.array != null && (n3 = forkJoinTaskArray.length) > (n2 = n5 + 1 - n4)) {
                    int n6 = ((n3 - 1 & n5) << ASHIFT) + ABASE;
                    U.putOrderedObject(forkJoinTaskArray, n6, forkJoinTask);
                    forkJoinPool$WorkQueue.top = n5 + 1;
                    forkJoinPool$WorkQueue.qlock = 0;
                    if (n2 <= 2) {
                        this.signalWork(forkJoinPool$WorkQueue);
                    }
                    return;
                }
                forkJoinPool$WorkQueue.qlock = 0;
            }
        }
        ForkJoinTask forkJoinTask2 = forkJoinTask;
        ForkJoinPool forkJoinPool = this;
        int n = 0;
        ForkJoinPool$Submitter forkJoinPool$Submitter2 = (ForkJoinPool$Submitter)submitters.get();
        while (true) {
            int n7;
            int n8;
            int n9;
            int n10;
            ForkJoinPool$WorkQueue[] forkJoinPool$WorkQueueArray;
            int n11;
            block27: {
                block26: {
                    if (forkJoinPool$Submitter2 == null) {
                        n = 1640531527;
                        if (!U.compareAndSwapInt(forkJoinPool, INDEXSEED, 0, 1640531527)) continue;
                        forkJoinPool$Submitter2 = new ForkJoinPool$Submitter(1640531527);
                        submitters.set(forkJoinPool$Submitter2);
                        continue;
                    }
                    if (n == 0) {
                        n = forkJoinPool$Submitter2.seed;
                        n ^= n << 13;
                        n ^= n >>> 17;
                        forkJoinPool$Submitter2.seed = n ^ n << 5;
                        continue;
                    }
                    n11 = forkJoinPool.plock;
                    if (n11 < 0) {
                        throw new RejectedExecutionException();
                    }
                    if (n11 == 0) break block26;
                    forkJoinPool$WorkQueueArray = forkJoinPool.workQueues;
                    if (forkJoinPool.workQueues != null && (n10 = forkJoinPool$WorkQueueArray.length - 1) >= 0) break block27;
                }
                n8 = (n9 = forkJoinPool.config & 0xFFFF) > 1 ? n9 - 1 : 1;
                n8 = n8 | n8 >>> 1;
                n8 |= n8 >>> 2;
                n8 |= n8 >>> 4;
                n8 |= n8 >>> 8;
                n8 = (n8 | n8 >>> 16) + 1 << 1;
                forkJoinPool$WorkQueueArray = forkJoinPool.workQueues;
                ForkJoinPool$WorkQueue[] forkJoinPool$WorkQueueArray2 = forkJoinPool.workQueues == null || forkJoinPool$WorkQueueArray.length == 0 ? new ForkJoinPool$WorkQueue[n8] : null;
                n11 = forkJoinPool.plock;
                if ((n11 & 2) != 0 || !U.compareAndSwapInt(forkJoinPool, PLOCK, n11, n11 += 2)) {
                    n11 = forkJoinPool.acquirePlock();
                }
                forkJoinPool$WorkQueueArray = forkJoinPool.workQueues;
                if ((forkJoinPool.workQueues == null || forkJoinPool$WorkQueueArray.length == 0) && forkJoinPool$WorkQueueArray2 != null) {
                    forkJoinPool.workQueues = forkJoinPool$WorkQueueArray2;
                }
                if (U.compareAndSwapInt(forkJoinPool, PLOCK, n11, n7 = n11 & Integer.MIN_VALUE | n11 + 2 & Integer.MAX_VALUE)) continue;
                forkJoinPool.releasePlock(n7);
                continue;
            }
            int n12 = n & n10 & 0x7E;
            ForkJoinPool$WorkQueue forkJoinPool$WorkQueue = forkJoinPool$WorkQueueArray[n12];
            if (forkJoinPool$WorkQueue != null) {
                if (forkJoinPool$WorkQueue.qlock == 0 && U.compareAndSwapInt(forkJoinPool$WorkQueue, QLOCK, 0, 1)) {
                    ForkJoinTask[] forkJoinTaskArray = forkJoinPool$WorkQueue.array;
                    n8 = forkJoinPool$WorkQueue.top;
                    boolean bl = false;
                    try {
                        if (forkJoinTaskArray != null && forkJoinTaskArray.length > n8 + 1 - forkJoinPool$WorkQueue.base || (forkJoinTaskArray = forkJoinPool$WorkQueue.growArray()) != null) {
                            n7 = ((forkJoinTaskArray.length - 1 & n8) << ASHIFT) + ABASE;
                            U.putOrderedObject(forkJoinTaskArray, n7, forkJoinTask2);
                            forkJoinPool$WorkQueue.top = n8 + 1;
                            bl = true;
                        }
                    }
                    finally {
                        forkJoinPool$WorkQueue.qlock = 0;
                    }
                    if (bl) {
                        forkJoinPool.signalWork(forkJoinPool$WorkQueue);
                        return;
                    }
                }
                n = 0;
                continue;
            }
            if ((forkJoinPool.plock & 2) == 0) {
                forkJoinPool$WorkQueue = new ForkJoinPool$WorkQueue(forkJoinPool, null, -1, n);
                n11 = forkJoinPool.plock;
                if ((n11 & 2) != 0 || !U.compareAndSwapInt(forkJoinPool, PLOCK, n11, n11 += 2)) {
                    n11 = forkJoinPool.acquirePlock();
                }
                forkJoinPool$WorkQueueArray = forkJoinPool.workQueues;
                if (forkJoinPool.workQueues != null && n12 < forkJoinPool$WorkQueueArray.length && forkJoinPool$WorkQueueArray[n12] == null) {
                    forkJoinPool$WorkQueueArray[n12] = forkJoinPool$WorkQueue;
                }
                if (U.compareAndSwapInt(forkJoinPool, PLOCK, n11, n9 = n11 & Integer.MIN_VALUE | n11 + 2 & Integer.MAX_VALUE)) continue;
                forkJoinPool.releasePlock(n9);
                continue;
            }
            n = 0;
        }
    }

    final void incrementActiveCount() {
        long l;
        do {
            l = this.ctl;
        } while (!U.compareAndSwapLong(this, CTL, l, l + 0x1000000000000L));
    }

    final void signalWork(ForkJoinPool$WorkQueue forkJoinPool$WorkQueue) {
        long l;
        int n;
        int n2 = forkJoinPool$WorkQueue.poolIndex;
        while ((n = (int)((l = this.ctl) >>> 32)) < 0) {
            int n3 = (int)l;
            if (n3 > 0) {
                ForkJoinPool$WorkQueue forkJoinPool$WorkQueue2;
                int n4;
                ForkJoinPool$WorkQueue[] forkJoinPool$WorkQueueArray = this.workQueues;
                if (this.workQueues == null || forkJoinPool$WorkQueueArray.length <= (n4 = n3 & 0xFFFF) || (forkJoinPool$WorkQueue2 = forkJoinPool$WorkQueueArray[n4]) == null || forkJoinPool$WorkQueue2.eventCount != (n3 | Integer.MIN_VALUE)) break;
                long l2 = (long)(forkJoinPool$WorkQueue2.nextWait & Integer.MAX_VALUE) | (long)(n + 65536) << 32;
                if (U.compareAndSwapLong(this, CTL, l, l2)) {
                    forkJoinPool$WorkQueue2.hint = n2;
                    forkJoinPool$WorkQueue2.eventCount = n3 + 65536 & Integer.MAX_VALUE;
                    Thread thread = forkJoinPool$WorkQueue2.parker;
                    if (thread == null) break;
                    U.unpark(thread);
                    return;
                }
                if (forkJoinPool$WorkQueue.top - forkJoinPool$WorkQueue.base <= 0) break;
                continue;
            }
            if ((short)n >= 0) break;
            this.tryAddWorker();
            break;
        }
    }

    final void runWorker(ForkJoinPool$WorkQueue forkJoinPool$WorkQueue) {
        forkJoinPool$WorkQueue.growArray();
        do {
            ForkJoinTask forkJoinTask;
            block28: {
                ForkJoinPool$WorkQueue forkJoinPool$WorkQueue2 = forkJoinPool$WorkQueue;
                ForkJoinPool forkJoinPool = this;
                int n = forkJoinPool.plock;
                if (forkJoinPool$WorkQueue2 != null) {
                    int n2;
                    ForkJoinPool$WorkQueue[] forkJoinPool$WorkQueueArray = forkJoinPool.workQueues;
                    if (forkJoinPool.workQueues != null && (n2 = forkJoinPool$WorkQueueArray.length - 1) >= 0) {
                        int n3;
                        int n4 = forkJoinPool$WorkQueue2.eventCount;
                        int n5 = forkJoinPool$WorkQueue2.seed;
                        n5 ^= n5 << 13;
                        n5 ^= n5 >>> 17;
                        n5 ^= n5 << 5;
                        forkJoinPool$WorkQueue2.seed = n5;
                        forkJoinPool$WorkQueue2.hint = -1;
                        int n6 = (n2 + n2 + 1 | 0x1FF) & 0x1FFFF;
                        do {
                            ForkJoinPool$WorkQueue forkJoinPool$WorkQueue3;
                            if ((forkJoinPool$WorkQueue3 = forkJoinPool$WorkQueueArray[n5 + n6 & n2]) == null || (n3 = forkJoinPool$WorkQueue3.base) - forkJoinPool$WorkQueue3.top >= 0) continue;
                            ForkJoinTask[] forkJoinTaskArray = forkJoinPool$WorkQueue3.array;
                            if (forkJoinPool$WorkQueue3.array == null) continue;
                            int n7 = ((forkJoinTaskArray.length - 1 & n3) << ASHIFT) + ABASE;
                            ForkJoinTask forkJoinTask2 = (ForkJoinTask)U.getObjectVolatile(forkJoinTaskArray, n7);
                            if (forkJoinPool$WorkQueue3.base == n3 && n4 >= 0 && forkJoinTask2 != null && U.compareAndSwapObject(forkJoinTaskArray, n7, forkJoinTask2, null)) {
                                forkJoinPool$WorkQueue3.base = n3 + 1;
                                if (forkJoinPool$WorkQueue3.base - forkJoinPool$WorkQueue3.top < 0) {
                                    forkJoinPool.signalWork(forkJoinPool$WorkQueue3);
                                }
                                forkJoinTask = forkJoinTask2;
                                break block28;
                            }
                            if (n4 >= 0 && n6 >= n2 || (int)(forkJoinPool.ctl >> 48) > 0) continue;
                            forkJoinPool$WorkQueue2.hint = n5 + n6 & n2;
                            break;
                        } while (--n6 >= 0);
                        n3 = forkJoinPool$WorkQueue2.nsteals;
                        if (n3 != 0) {
                            if (U.compareAndSwapLong(forkJoinPool, STEALCOUNT, 0L, 0L + (long)n3)) {
                                forkJoinPool$WorkQueue2.nsteals = 0;
                            }
                        } else if (forkJoinPool.plock == n) {
                            long l = forkJoinPool.ctl;
                            int n8 = (int)l;
                            if (n8 < 0) {
                                forkJoinPool$WorkQueue2.qlock = -1;
                            } else {
                                int n9 = forkJoinPool$WorkQueue2.hint;
                                if (n9 < 0) {
                                    if (n4 >= 0) {
                                        long l2 = (long)n4 | l - 0x1000000000000L & 0xFFFFFFFF00000000L;
                                        forkJoinPool$WorkQueue2.nextWait = n8;
                                        forkJoinPool$WorkQueue2.eventCount = n4 | Integer.MIN_VALUE;
                                        if (forkJoinPool.ctl != l || !U.compareAndSwapLong(forkJoinPool, CTL, l, l2)) {
                                            forkJoinPool$WorkQueue2.eventCount = n4;
                                        } else if ((int)(l >> 48) == 1 - (forkJoinPool.config & 0xFFFF)) {
                                            long l3 = l;
                                            long l4 = l2;
                                            ForkJoinPool$WorkQueue forkJoinPool$WorkQueue4 = forkJoinPool$WorkQueue2;
                                            ForkJoinPool forkJoinPool2 = forkJoinPool;
                                            if (forkJoinPool$WorkQueue4 != null && forkJoinPool$WorkQueue4.eventCount < 0 && !forkJoinPool2.tryTerminate(false, false) && (int)l3 != 0 && forkJoinPool2.ctl == l4) {
                                                short s2 = -((short)(l4 >>> 32));
                                                long l5 = s2 < 0 ? 200000000L : (long)(s2 + 1) * 2000000000L;
                                                long l6 = System.nanoTime() + l5 - 2000000L;
                                                Thread thread = Thread.currentThread();
                                                while (forkJoinPool2.ctl == l4) {
                                                    Thread.interrupted();
                                                    U.putObject(thread, PARKBLOCKER, forkJoinPool2);
                                                    forkJoinPool$WorkQueue4.parker = thread;
                                                    if (forkJoinPool2.ctl == l4) {
                                                        U.park(false, l5);
                                                    }
                                                    forkJoinPool$WorkQueue4.parker = null;
                                                    U.putObject(thread, PARKBLOCKER, null);
                                                    if (forkJoinPool2.ctl == l4) {
                                                        if (l6 - System.nanoTime() > 0L || !U.compareAndSwapLong(forkJoinPool2, CTL, l4, l3)) continue;
                                                        forkJoinPool$WorkQueue4.eventCount = forkJoinPool$WorkQueue4.eventCount + 65536 | Integer.MAX_VALUE;
                                                        forkJoinPool$WorkQueue4.hint = -1;
                                                        forkJoinPool$WorkQueue4.qlock = -1;
                                                    }
                                                    break;
                                                }
                                            }
                                        }
                                    } else if (forkJoinPool$WorkQueue2.eventCount < 0 && forkJoinPool.ctl == l) {
                                        Thread thread = Thread.currentThread();
                                        Thread.interrupted();
                                        U.putObject(thread, PARKBLOCKER, forkJoinPool);
                                        forkJoinPool$WorkQueue2.parker = thread;
                                        if (forkJoinPool$WorkQueue2.eventCount < 0) {
                                            U.park(false, 0L);
                                        }
                                        forkJoinPool$WorkQueue2.parker = null;
                                        U.putObject(thread, PARKBLOCKER, null);
                                    }
                                }
                                if (n9 >= 0 || (n9 = forkJoinPool$WorkQueue2.hint) >= 0) {
                                    ForkJoinPool$WorkQueue forkJoinPool$WorkQueue5;
                                    forkJoinPool$WorkQueueArray = forkJoinPool.workQueues;
                                    if (forkJoinPool.workQueues != null && n9 < forkJoinPool$WorkQueueArray.length && (forkJoinPool$WorkQueue5 = forkJoinPool$WorkQueueArray[n9]) != null) {
                                        ForkJoinPool$WorkQueue forkJoinPool$WorkQueue6;
                                        int n10;
                                        int n11;
                                        int n12;
                                        int n13 = (forkJoinPool.config & 0xFFFF) - 1;
                                        while (((n12 = (forkJoinPool$WorkQueue2.eventCount < 0 ? 0 : -1) - forkJoinPool$WorkQueue5.base + forkJoinPool$WorkQueue5.top) > n13 || (n13 = n12) > 0) && (n11 = (int)((l = forkJoinPool.ctl) >>> 32)) < 0 && (n8 = (int)l) > 0 && n2 >= (n10 = n8 & 0xFFFF) && (forkJoinPool$WorkQueue6 = forkJoinPool$WorkQueueArray[n10]) != null) {
                                            long l7 = (long)(forkJoinPool$WorkQueue6.nextWait & Integer.MAX_VALUE) | (long)(n11 + 65536) << 32;
                                            if (forkJoinPool$WorkQueue6.eventCount != (n8 | Integer.MIN_VALUE) || !U.compareAndSwapLong(forkJoinPool, CTL, l, l7)) break;
                                            forkJoinPool$WorkQueue6.hint = n9;
                                            forkJoinPool$WorkQueue6.eventCount = n8 + 65536 & Integer.MAX_VALUE;
                                            Thread thread = forkJoinPool$WorkQueue6.parker;
                                            if (thread != null) {
                                                U.unpark(thread);
                                            }
                                            if (--n13 > 0) continue;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                forkJoinTask = null;
            }
            forkJoinPool$WorkQueue.runTask(forkJoinTask);
        } while (forkJoinPool$WorkQueue.qlock >= 0);
    }

    private void helpSignal(ForkJoinTask forkJoinTask, int n) {
        int n2;
        if (forkJoinTask != null && forkJoinTask.status >= 0 && (n2 = (int)(this.ctl >>> 32)) < 0 && n2 >> 16 < 0) {
            int n3;
            ForkJoinPool$WorkQueue[] forkJoinPool$WorkQueueArray = this.workQueues;
            if (this.workQueues != null && (n3 = forkJoinPool$WorkQueueArray.length - 1) >= 0) {
                int n4 = n;
                block0: for (int i = n3; i >= 0; --i) {
                    ForkJoinPool$WorkQueue forkJoinPool$WorkQueue = forkJoinPool$WorkQueueArray[n4++ & n3];
                    int n5 = n3;
                    while (forkJoinTask.status >= 0) {
                        ForkJoinPool$WorkQueue forkJoinPool$WorkQueue2;
                        int n6;
                        int n7;
                        int n8;
                        if (forkJoinPool$WorkQueue == null || (n8 = -forkJoinPool$WorkQueue.base + forkJoinPool$WorkQueue.top) <= n5 && (n5 = n8) <= 0) continue block0;
                        long l = this.ctl;
                        n2 = (int)(l >>> 32);
                        if (n2 >= 0 || (n7 = (int)l) <= 0 || n3 < (n6 = n7 & 0xFFFF) || (forkJoinPool$WorkQueue2 = forkJoinPool$WorkQueueArray[n6]) == null) break block0;
                        long l2 = (long)(forkJoinPool$WorkQueue2.nextWait & Integer.MAX_VALUE) | (long)(n2 + 65536) << 32;
                        if (forkJoinPool$WorkQueue2.eventCount != (n7 | Integer.MIN_VALUE)) break block0;
                        if (!U.compareAndSwapLong(this, CTL, l, l2)) continue;
                        forkJoinPool$WorkQueue2.eventCount = n7 + 65536 & Integer.MAX_VALUE;
                        Thread thread = forkJoinPool$WorkQueue2.parker;
                        if (thread != null) {
                            U.unpark(thread);
                        }
                        if (--n5 > 0) continue;
                        continue block0;
                    }
                    break block0;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private int tryHelpStealer(ForkJoinPool$WorkQueue var1_1, ForkJoinTask var2_2) {
        var3_3 = 0;
        var4_4 = 0;
        if (var1_1 != null && var2_2 != null) {
            block0: while (true) {
                var5_5 = var2_2;
                var6_6 = var1_1;
                while (true) {
                    block8: {
                        if ((var10_10 = var2_2.status) < 0) {
                            var3_3 = var10_10;
                            break block0;
                        }
                        var8_8 = this.workQueues;
                        if (this.workQueues == null || (var9_9 = var8_8.length - 1) <= 0) break block0;
                        var11_11 = (var6_6.hint | 1) & var9_9;
                        var7_7 = var8_8[var11_11];
                        if (var7_7 == null || var7_7.currentSteal != var5_5) {
                            var12_12 = var11_11;
                            do {
                                if (((var11_11 = var11_11 + 2 & var9_9) & 15) == 1 && (var5_5.status < 0 || var6_6.currentJoin != var5_5)) continue block0;
                                var7_7 = var8_8[var11_11];
                                if (var7_7 == null || var7_7.currentSteal != var5_5) continue;
                                var6_6.hint = var11_11;
                                break block8;
                            } while (var11_11 != var12_12);
                            break block0;
                        }
                    }
                    while (true) {
                        if (var5_5.status < 0) continue block0;
                        var13_14 = var7_7.base;
                        if (var13_14 - var7_7.top >= 0) break;
                        var12_13 = var7_7.array;
                        if (var7_7.array == null) break;
                        var14_15 = ((var12_13.length - 1 & var13_14) << ForkJoinPool.ASHIFT) + ForkJoinPool.ABASE;
                        var15_17 = (ForkJoinTask)ForkJoinPool.U.getObjectVolatile(var12_13, var14_15);
                        if (var5_5.status < 0 || var6_6.currentJoin != var5_5 || var7_7.currentSteal != var5_5) continue block0;
                        var3_3 = 1;
                        if (var15_17 != null && var7_7.base == var13_14 && ForkJoinPool.U.compareAndSwapObject(var12_13, var14_15, var15_17, null)) {
                            var7_7.base = var13_14 + 1;
                            var1_1.runSubtask(var15_17);
                            continue;
                        }
                        if (var7_7.base == var13_14 && ++var4_4 == 64) break block0;
                    }
                    var14_16 = var7_7.currentJoin;
                    if (var5_5.status >= 0 && var6_6.currentJoin == var5_5 && var7_7.currentSteal == var5_5) ** break;
                    continue block0;
                    if (var14_16 == null || ++var4_4 == 64) break block0;
                    var5_5 = var14_16;
                    var6_6 = var7_7;
                }
                break;
            }
        }
        return var3_3;
    }

    private int helpComplete(ForkJoinTask forkJoinTask, int n) {
        if (forkJoinTask != null) {
            int n2;
            ForkJoinPool$WorkQueue[] forkJoinPool$WorkQueueArray = this.workQueues;
            if (this.workQueues != null && (n2 = forkJoinPool$WorkQueueArray.length - 1) >= 0) {
                int n3 = 1;
                int n4 = 1;
                while (true) {
                    int n5;
                    if ((n5 = forkJoinTask.status) < 0) {
                        return n5;
                    }
                    ForkJoinPool$WorkQueue forkJoinPool$WorkQueue = forkJoinPool$WorkQueueArray[n3 & n2];
                    if (forkJoinPool$WorkQueue != null && forkJoinPool$WorkQueue.pollAndExecCC(forkJoinTask)) {
                        int n6;
                        n4 = n3;
                        if (n != -1 || (n6 = (int)(this.ctl >>> 32)) < 0 && n6 >> 16 < 0) continue;
                        break;
                    }
                    if ((n3 = n3 + 2 & n2) == n4) break;
                }
            }
        }
        return 0;
    }

    final boolean tryCompensate() {
        long l;
        int n;
        int n2 = this.config & 0xFFFF;
        ForkJoinPool$WorkQueue[] forkJoinPool$WorkQueueArray = this.workQueues;
        if (this.workQueues != null && (n = (int)(l = this.ctl)) >= 0) {
            ForkJoinPool$WorkQueue forkJoinPool$WorkQueue;
            int n3;
            if (n != 0 && (n3 = n & 0xFFFF) < forkJoinPool$WorkQueueArray.length && (forkJoinPool$WorkQueue = forkJoinPool$WorkQueueArray[n3]) != null && forkJoinPool$WorkQueue.eventCount == (n | Integer.MIN_VALUE)) {
                long l2 = (long)(forkJoinPool$WorkQueue.nextWait & Integer.MAX_VALUE) | l & 0xFFFFFFFF00000000L;
                if (U.compareAndSwapLong(this, CTL, l, l2)) {
                    forkJoinPool$WorkQueue.eventCount = n + 65536 & Integer.MAX_VALUE;
                    Thread thread = forkJoinPool$WorkQueue.parker;
                    if (thread != null) {
                        U.unpark(thread);
                    }
                    return true;
                }
            } else {
                long l3;
                short s2 = (short)(l >>> 32);
                if (s2 >= 0 && (int)(l >> 48) + n2 > 1) {
                    long l4 = l - 0x1000000000000L & 0xFFFF000000000000L | l & 0xFFFFFFFFFFFFL;
                    if (U.compareAndSwapLong(this, CTL, l, l4)) {
                        return true;
                    }
                } else if (s2 + n2 < Short.MAX_VALUE && U.compareAndSwapLong(this, CTL, l, l3 = l + 0x100000000L & 0xFFFF00000000L | l & 0xFFFF0000FFFFFFFFL)) {
                    Throwable throwable = null;
                    ForkJoinWorkerThread forkJoinWorkerThread = null;
                    try {
                        ForkJoinPool$ForkJoinWorkerThreadFactory forkJoinPool$ForkJoinWorkerThreadFactory = this.factory;
                        if (forkJoinPool$ForkJoinWorkerThreadFactory != null && (forkJoinWorkerThread = forkJoinPool$ForkJoinWorkerThreadFactory.newThread(this)) != null) {
                            forkJoinWorkerThread.start();
                            return true;
                        }
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                    this.deregisterWorker(forkJoinWorkerThread, throwable);
                }
            }
        }
        return false;
    }

    final int awaitJoin(ForkJoinPool$WorkQueue forkJoinPool$WorkQueue, ForkJoinTask forkJoinTask) {
        int n = 0;
        if (forkJoinPool$WorkQueue != null && forkJoinTask != null && (n = forkJoinTask.status) >= 0) {
            ForkJoinTask forkJoinTask2 = forkJoinPool$WorkQueue.currentJoin;
            forkJoinPool$WorkQueue.currentJoin = forkJoinTask;
            while ((n = forkJoinTask.status) >= 0 && !forkJoinPool$WorkQueue.isEmpty() && forkJoinPool$WorkQueue.tryRemoveAndExec(forkJoinTask)) {
            }
            if (n >= 0 && (n = forkJoinTask.status) >= 0) {
                this.helpSignal(forkJoinTask, forkJoinPool$WorkQueue.poolIndex);
                n = forkJoinTask.status;
                if (n >= 0 && forkJoinTask instanceof CountedCompleter) {
                    n = this.helpComplete(forkJoinTask, 0);
                }
            }
            while (n >= 0 && (n = forkJoinTask.status) >= 0) {
                long l;
                if (forkJoinPool$WorkQueue.isEmpty() && (n = this.tryHelpStealer(forkJoinPool$WorkQueue, forkJoinTask)) != 0 || (n = forkJoinTask.status) < 0) continue;
                this.helpSignal(forkJoinTask, forkJoinPool$WorkQueue.poolIndex);
                n = forkJoinTask.status;
                if (n < 0 || !this.tryCompensate()) continue;
                if (forkJoinTask.trySetSignal() && (n = forkJoinTask.status) >= 0) {
                    ForkJoinTask forkJoinTask3 = forkJoinTask;
                    synchronized (forkJoinTask3) {
                        if (forkJoinTask.status >= 0) {
                            try {
                                forkJoinTask.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        } else {
                            forkJoinTask.notifyAll();
                        }
                    }
                }
                do {
                    l = this.ctl;
                } while (!U.compareAndSwapLong(this, CTL, l, l + 0x1000000000000L));
            }
            forkJoinPool$WorkQueue.currentJoin = forkJoinTask2;
        }
        return n;
    }

    final void helpJoinOnce(ForkJoinPool$WorkQueue forkJoinPool$WorkQueue, ForkJoinTask forkJoinTask) {
        if (forkJoinPool$WorkQueue != null && forkJoinTask != null) {
            int n = 0;
            if (forkJoinTask.status >= 0) {
                ForkJoinTask forkJoinTask2 = forkJoinPool$WorkQueue.currentJoin;
                forkJoinPool$WorkQueue.currentJoin = forkJoinTask;
                while ((n = forkJoinTask.status) >= 0 && !forkJoinPool$WorkQueue.isEmpty() && forkJoinPool$WorkQueue.tryRemoveAndExec(forkJoinTask)) {
                }
                if (n >= 0 && (n = forkJoinTask.status) >= 0) {
                    this.helpSignal(forkJoinTask, forkJoinPool$WorkQueue.poolIndex);
                    n = forkJoinTask.status;
                    if (n >= 0 && forkJoinTask instanceof CountedCompleter) {
                        n = this.helpComplete(forkJoinTask, 0);
                    }
                }
                if (n >= 0 && forkJoinPool$WorkQueue.isEmpty()) {
                    while (forkJoinTask.status >= 0 && this.tryHelpStealer(forkJoinPool$WorkQueue, forkJoinTask) > 0) {
                    }
                }
                forkJoinPool$WorkQueue.currentJoin = forkJoinTask2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean tryTerminate(boolean var1_1, boolean var2_2) {
        if (this == ForkJoinPool.common) {
            return false;
        }
        var3_3 = this.plock;
        if (var3_3 >= 0) {
            if (!var2_2) {
                return false;
            }
            if ((var3_3 & 2) != 0 || !ForkJoinPool.U.compareAndSwapInt(this, ForkJoinPool.PLOCK, var3_3, var3_3 += 2)) {
                var3_3 = this.acquirePlock();
            }
            if (!ForkJoinPool.U.compareAndSwapInt(this, ForkJoinPool.PLOCK, var3_3, var4_4 = var3_3 + 2 & 0x7FFFFFFF | -2147483648)) {
                this.releasePlock(var4_4);
            }
        }
        block5: while (true) {
            if (((var4_5 = this.ctl) & 0x80000000L) != 0L) {
                if ((short)(var4_5 >>> 32) == -(this.config & 65535)) {
                    var6_6 = this;
                    synchronized (var6_6) {
                        this.notifyAll();
                    }
                }
                return true;
            }
            if (!var1_1) {
                if ((int)(var4_5 >> 48) != -(this.config & 65535)) {
                    return false;
                }
                var6_7 = this.workQueues;
                if (this.workQueues != null) {
                    for (var8_11 = 0; var8_11 < var6_7.length; ++var8_11) {
                        var7_9 = var6_7[var8_11];
                        if (var7_9 == null) continue;
                        if (!var7_9.isEmpty()) {
                            this.signalWork((ForkJoinPool$WorkQueue)var7_9);
                            return false;
                        }
                        if ((var8_11 & 1) == 0 || var7_9.eventCount < 0) continue;
                        return false;
                    }
                }
            }
            if (!ForkJoinPool.U.compareAndSwapLong(this, ForkJoinPool.CTL, var4_5, var4_5 | 0x80000000L)) continue;
            var6_8 = 0;
            while (true) {
                if (var6_8 < 3) ** break;
                continue block5;
                var7_9 = this.workQueues;
                if (this.workQueues != null) {
                    var10_15 = ((ForkJoinPool$WorkQueue[])var7_9).length;
                    for (var11_16 = 0; var11_16 < var10_15; ++var11_16) {
                        var8_12 = var7_9[var11_16];
                        if (var8_12 == null) continue;
                        var8_12.qlock = -1;
                        if (var6_8 <= 0) continue;
                        var8_12.cancelAll();
                        if (var6_8 <= 1 || (var9_14 = var8_12.owner) == null) continue;
                        if (!var9_14.isInterrupted()) {
                            try {
                                var9_14.interrupt();
                            }
                            catch (Throwable v0) {}
                        }
                        ForkJoinPool.U.unpark(var9_14);
                    }
                    while ((var12_17 = (int)(var13_18 = this.ctl) & 0x7FFFFFFF) != 0 && (var11_16 = var12_17 & 65535) < var10_15 && var11_16 >= 0 && (var8_13 = var7_9[var11_16]) != null) {
                        var16_20 = (long)(var8_13.nextWait & 0x7FFFFFFF) | var13_18 + 0x1000000000000L & -281474976710656L | var13_18 & 0xFFFF80000000L;
                        if (var8_13.eventCount != (var12_17 | -2147483648) || !ForkJoinPool.U.compareAndSwapLong(this, ForkJoinPool.CTL, var13_18, var16_20)) continue;
                        var8_13.eventCount = var12_17 + 65536 & 0x7FFFFFFF;
                        var8_13.qlock = -1;
                        var15_19 = var8_13.parker;
                        if (var15_19 == null) continue;
                        ForkJoinPool.U.unpark(var15_19);
                    }
                }
                ++var6_8;
            }
            break;
        }
    }

    static void externalHelpJoin(ForkJoinTask forkJoinTask) {
        ForkJoinPool forkJoinPool;
        ForkJoinPool$Submitter forkJoinPool$Submitter;
        if (forkJoinTask != null && (forkJoinPool$Submitter = (ForkJoinPool$Submitter)submitters.get()) != null && (forkJoinPool = common) != null) {
            ForkJoinPool$WorkQueue forkJoinPool$WorkQueue;
            int n;
            ForkJoinPool$WorkQueue[] forkJoinPool$WorkQueueArray = forkJoinPool.workQueues;
            if (forkJoinPool.workQueues != null && (n = forkJoinPool$WorkQueueArray.length - 1) >= 0 && (forkJoinPool$WorkQueue = forkJoinPool$WorkQueueArray[n & forkJoinPool$Submitter.seed & 0x7E]) != null) {
                ForkJoinTask[] forkJoinTaskArray = forkJoinPool$WorkQueue.array;
                if (forkJoinPool$WorkQueue.array != null) {
                    long l;
                    int n2 = forkJoinTaskArray.length - 1;
                    int n3 = forkJoinPool$WorkQueue.top;
                    if (n3 != forkJoinPool$WorkQueue.base && U.getObject(forkJoinTaskArray, l = (long)(((n2 & n3 - 1) << ASHIFT) + ABASE)) == forkJoinTask && U.compareAndSwapInt(forkJoinPool$WorkQueue, QLOCK, 0, 1)) {
                        if (forkJoinPool$WorkQueue.array == forkJoinTaskArray && forkJoinPool$WorkQueue.top == n3 && U.compareAndSwapObject(forkJoinTaskArray, l, forkJoinTask, null)) {
                            forkJoinPool$WorkQueue.top = n3 - 1;
                            forkJoinPool$WorkQueue.qlock = 0;
                            forkJoinTask.doExec();
                        } else {
                            forkJoinPool$WorkQueue.qlock = 0;
                        }
                    }
                    if (forkJoinTask.status >= 0) {
                        if (forkJoinTask instanceof CountedCompleter) {
                            block15: {
                                ForkJoinTask forkJoinTask2 = forkJoinTask;
                                ForkJoinPool$WorkQueue forkJoinPool$WorkQueue2 = forkJoinPool$WorkQueue;
                                ForkJoinPool forkJoinPool2 = forkJoinPool;
                                if (forkJoinPool$WorkQueue2 != null) {
                                    int n4;
                                    ForkJoinTask[] forkJoinTaskArray2 = forkJoinPool$WorkQueue2.array;
                                    if (forkJoinPool$WorkQueue2.array != null && (n4 = forkJoinTaskArray2.length - 1) >= 0 && forkJoinTask2 != null && forkJoinTask2.status >= 0) {
                                        ForkJoinTask forkJoinTask3;
                                        do {
                                            int n5;
                                            CountedCompleter countedCompleter;
                                            long l2;
                                            Object object;
                                            forkJoinTask3 = null;
                                            int n6 = forkJoinPool$WorkQueue2.top;
                                            if (n6 - forkJoinPool$WorkQueue2.base > 0 && (object = U.getObject(forkJoinTaskArray2, l2 = (long)(((n4 & n6 - 1) << ASHIFT) + ABASE))) != null && object instanceof CountedCompleter && (countedCompleter = (CountedCompleter)object) == forkJoinTask2 && U.compareAndSwapInt(forkJoinPool$WorkQueue2, QLOCK, 0, 1)) {
                                                if (forkJoinPool$WorkQueue2.array == forkJoinTaskArray2 && forkJoinPool$WorkQueue2.top == n6 && U.compareAndSwapObject(forkJoinTaskArray2, l2, countedCompleter, null)) {
                                                    forkJoinPool$WorkQueue2.top = n6 - 1;
                                                    forkJoinTask3 = countedCompleter;
                                                }
                                                forkJoinPool$WorkQueue2.qlock = 0;
                                            }
                                            if (forkJoinTask3 != null) {
                                                forkJoinTask3.doExec();
                                            }
                                            if (forkJoinTask2.status < 0 || (n5 = (int)(forkJoinPool2.ctl >>> 32)) >= 0 || n5 >> 16 >= 0) break block15;
                                        } while (forkJoinTask3 != null);
                                        forkJoinPool2.helpSignal(forkJoinTask2, forkJoinPool$WorkQueue2.poolIndex);
                                        if (forkJoinTask2.status >= 0) {
                                            forkJoinPool2.helpComplete(forkJoinTask2, -1);
                                            return;
                                        }
                                    }
                                }
                            }
                            return;
                        }
                        forkJoinPool.helpSignal(forkJoinTask, forkJoinPool$WorkQueue.poolIndex);
                    }
                }
            }
        }
    }

    public ForkJoinPool() {
        this(Math.min(Short.MAX_VALUE, Runtime.getRuntime().availableProcessors()), defaultForkJoinWorkerThreadFactory, null, false);
    }

    public ForkJoinPool(int n, ForkJoinPool$ForkJoinWorkerThreadFactory forkJoinPool$ForkJoinWorkerThreadFactory, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, boolean bl) {
        ForkJoinPool.checkPermission();
        if (forkJoinPool$ForkJoinWorkerThreadFactory == null) {
            throw new NullPointerException();
        }
        if (n <= 0 || n > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        this.factory = forkJoinPool$ForkJoinWorkerThreadFactory;
        this.ueh = uncaughtExceptionHandler;
        this.config = n | (bl ? 65536 : 0);
        long l = -n;
        this.ctl = l << 48 & 0xFFFF000000000000L | l << 32 & 0xFFFF00000000L;
        int n2 = ForkJoinPool.nextPoolId();
        StringBuilder stringBuilder = new StringBuilder("ForkJoinPool-");
        stringBuilder.append(Integer.toString(n2));
        stringBuilder.append("-worker-");
        this.workerNamePrefix = stringBuilder.toString();
    }

    private ForkJoinPool(int n, long l, ForkJoinPool$ForkJoinWorkerThreadFactory forkJoinPool$ForkJoinWorkerThreadFactory, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.config = n;
        this.ctl = l;
        this.factory = forkJoinPool$ForkJoinWorkerThreadFactory;
        this.ueh = uncaughtExceptionHandler;
        this.workerNamePrefix = "ForkJoinPool.commonPool-worker-";
    }

    public final void execute(ForkJoinTask forkJoinTask) {
        if (forkJoinTask == null) {
            throw new NullPointerException();
        }
        this.externalPush(forkJoinTask);
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable == null) {
            throw new NullPointerException();
        }
        ForkJoinTask forkJoinTask = runnable instanceof ForkJoinTask ? (ForkJoinTask)((Object)runnable) : new ForkJoinTask$AdaptedRunnableAction(runnable);
        this.externalPush(forkJoinTask);
    }

    private ForkJoinTask submit(Callable callable) {
        ForkJoinTask$AdaptedCallable forkJoinTask$AdaptedCallable = new ForkJoinTask$AdaptedCallable(callable);
        this.externalPush(forkJoinTask$AdaptedCallable);
        return forkJoinTask$AdaptedCallable;
    }

    private ForkJoinTask submit(Runnable runnable, Object object) {
        ForkJoinTask$AdaptedRunnable forkJoinTask$AdaptedRunnable = new ForkJoinTask$AdaptedRunnable(runnable, object);
        this.externalPush(forkJoinTask$AdaptedRunnable);
        return forkJoinTask$AdaptedRunnable;
    }

    public List invokeAll(Collection collection) {
        ArrayList<ForkJoinTask$AdaptedCallable> arrayList = new ArrayList<ForkJoinTask$AdaptedCallable>(collection.size());
        boolean bl = false;
        try {
            for (Callable callable : collection) {
                ForkJoinTask$AdaptedCallable forkJoinTask$AdaptedCallable = new ForkJoinTask$AdaptedCallable(callable);
                arrayList.add(forkJoinTask$AdaptedCallable);
                this.externalPush(forkJoinTask$AdaptedCallable);
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ((ForkJoinTask)arrayList.get(i)).quietlyJoin();
            }
            bl = true;
            ArrayList<ForkJoinTask$AdaptedCallable> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Throwable throwable) {
            if (!bl) {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    ((Future)arrayList.get(i)).cancel(false);
                }
            }
            throw throwable;
        }
    }

    public String toString() {
        int n;
        int n2;
        long l = 0L;
        long l2 = 0L;
        int n3 = 0;
        long l3 = 0L;
        long l4 = this.ctl;
        ForkJoinPool$WorkQueue[] forkJoinPool$WorkQueueArray = this.workQueues;
        if (this.workQueues != null) {
            for (n2 = 0; n2 < forkJoinPool$WorkQueueArray.length; ++n2) {
                ForkJoinPool$WorkQueue forkJoinPool$WorkQueue = forkJoinPool$WorkQueueArray[n2];
                if (forkJoinPool$WorkQueue == null) continue;
                n = forkJoinPool$WorkQueue.queueSize();
                if ((n2 & 1) == 0) {
                    l2 += (long)n;
                    continue;
                }
                l += (long)n;
                l3 += (long)forkJoinPool$WorkQueue.nsteals;
                if (!forkJoinPool$WorkQueue.isApparentlyUnblocked()) continue;
                ++n3;
            }
        }
        n2 = this.config & 0xFFFF;
        n = n2 + (short)(l4 >>> 32);
        int n4 = n2 + (int)(l4 >> 48);
        if (n4 < 0) {
            n4 = 0;
        }
        String string = (l4 & 0x80000000L) != 0L ? (n == 0 ? "Terminated" : "Terminating") : (this.plock < 0 ? "Shutting down" : "Running");
        return super.toString() + "[" + string + ", parallelism = " + n2 + ", size = " + n + ", active = " + n4 + ", running = " + n3 + ", steals = " + l3 + ", tasks = " + l + ", submissions = " + l2 + "]";
    }

    @Override
    public void shutdown() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(false, true);
    }

    public List shutdownNow() {
        ForkJoinPool.checkPermission();
        this.tryTerminate(true, true);
        return Collections.emptyList();
    }

    @Override
    public boolean isTerminated() {
        long l = this.ctl;
        return (l & 0x80000000L) != 0L && (short)(l >>> 32) == -(this.config & 0xFFFF);
    }

    @Override
    public boolean isShutdown() {
        return this.plock < 0;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this == common) {
            this.awaitQuiescence(l, timeUnit);
            return false;
        }
        long l2 = timeUnit.toNanos(l);
        if (this.isTerminated()) {
            return true;
        }
        long l3 = System.nanoTime();
        boolean bl = false;
        ForkJoinPool forkJoinPool = this;
        synchronized (forkJoinPool) {
            long l4 = l2;
            long l5 = 0L;
            while (!(bl = this.isTerminated() || l4 <= 0L || (l5 = timeUnit.toMillis(l4)) <= 0L)) {
                this.wait(l5);
                l4 = l2 - (System.nanoTime() - l3);
            }
        }
        return bl;
    }

    private boolean awaitQuiescence(long l, TimeUnit timeUnit) {
        long l2 = timeUnit.toNanos(l);
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread;
            if (forkJoinWorkerThread.pool == this) {
                ForkJoinPool$WorkQueue forkJoinPool$WorkQueue = forkJoinWorkerThread.workQueue;
                ForkJoinPool forkJoinPool = this;
                boolean bl = true;
                while (true) {
                    long l3;
                    ForkJoinPool$WorkQueue forkJoinPool$WorkQueue2;
                    ForkJoinTask forkJoinTask;
                    block18: {
                        int n;
                        if ((forkJoinTask = forkJoinPool$WorkQueue.nextLocalTask()) != null) {
                            if (forkJoinPool$WorkQueue.base - forkJoinPool$WorkQueue.top < 0) {
                                forkJoinPool.signalWork(forkJoinPool$WorkQueue);
                            }
                            forkJoinTask.doExec();
                            continue;
                        }
                        int n2 = forkJoinPool$WorkQueue.nextSeed();
                        ForkJoinPool forkJoinPool2 = forkJoinPool;
                        do {
                            int n3;
                            n = forkJoinPool2.plock;
                            ForkJoinPool$WorkQueue[] forkJoinPool$WorkQueueArray = forkJoinPool2.workQueues;
                            if (forkJoinPool2.workQueues == null || (n3 = forkJoinPool$WorkQueueArray.length - 1) < 0) continue;
                            for (int i = n3 + 1 << 2; i >= 0; --i) {
                                ForkJoinPool$WorkQueue forkJoinPool$WorkQueue3 = forkJoinPool$WorkQueueArray[(n2 + i << 1 | 1) & n3];
                                if (forkJoinPool$WorkQueue3 == null || forkJoinPool$WorkQueue3.base - forkJoinPool$WorkQueue3.top >= 0) continue;
                                forkJoinPool$WorkQueue2 = forkJoinPool$WorkQueue3;
                                break block18;
                            }
                        } while (forkJoinPool2.plock != n);
                        forkJoinPool$WorkQueue2 = null;
                    }
                    ForkJoinPool$WorkQueue forkJoinPool$WorkQueue4 = forkJoinPool$WorkQueue2;
                    if (forkJoinPool$WorkQueue2 != null) {
                        int n;
                        if (!bl) {
                            long l4;
                            bl = true;
                            do {
                                l4 = forkJoinPool.ctl;
                            } while (!U.compareAndSwapLong(forkJoinPool, CTL, l4, l4 + 0x1000000000000L));
                        }
                        if ((n = forkJoinPool$WorkQueue4.base) - forkJoinPool$WorkQueue4.top >= 0 || (forkJoinTask = forkJoinPool$WorkQueue4.pollAt(n)) == null) continue;
                        if (forkJoinPool$WorkQueue4.base - forkJoinPool$WorkQueue4.top < 0) {
                            forkJoinPool.signalWork(forkJoinPool$WorkQueue4);
                        }
                        forkJoinPool$WorkQueue.runSubtask(forkJoinTask);
                        continue;
                    }
                    if (bl) {
                        l3 = forkJoinPool.ctl;
                        long l5 = l3 - 0x1000000000000L;
                        if ((int)(l5 >> 48) + (forkJoinPool.config & 0xFFFF) == 0) break;
                        if (!U.compareAndSwapLong(forkJoinPool, CTL, l3, l5)) continue;
                        bl = false;
                        continue;
                    }
                    l3 = forkJoinPool.ctl;
                    if ((int)(l3 >> 48) + (forkJoinPool.config & 0xFFFF) == 0 && U.compareAndSwapLong(forkJoinPool, CTL, l3, l3 + 0x1000000000000L)) break;
                }
                return true;
            }
        }
        long l6 = System.nanoTime();
        int n = 0;
        boolean bl = true;
        block4: while (true) {
            int n4;
            ForkJoinPool forkJoinPool = this;
            if ((int)(forkJoinPool.ctl >> 48) + (forkJoinPool.config & 0xFFFF) == 0) break;
            ForkJoinPool$WorkQueue[] forkJoinPool$WorkQueueArray = this.workQueues;
            if (this.workQueues == null || (n4 = forkJoinPool$WorkQueueArray.length - 1) < 0) break;
            if (!bl) {
                if (System.nanoTime() - l6 > l2) {
                    return false;
                }
                Thread.yield();
            }
            bl = false;
            int n5 = n4 + 1 << 2;
            while (true) {
                int n6;
                ForkJoinPool$WorkQueue forkJoinPool$WorkQueue;
                if (n5 < 0) continue block4;
                if ((forkJoinPool$WorkQueue = forkJoinPool$WorkQueueArray[n++ & n4]) != null && (n6 = forkJoinPool$WorkQueue.base) - forkJoinPool$WorkQueue.top < 0) {
                    bl = true;
                    ForkJoinTask forkJoinTask = forkJoinPool$WorkQueue.pollAt(n6);
                    if (forkJoinTask == null) continue block4;
                    if (forkJoinPool$WorkQueue.base - forkJoinPool$WorkQueue.top < 0) {
                        this.signalWork(forkJoinPool$WorkQueue);
                    }
                    forkJoinTask.doExec();
                    continue block4;
                }
                --n5;
            }
            break;
        }
        return true;
    }

    public static void managedBlock(ForkJoinPool$ManagedBlocker forkJoinPool$ManagedBlocker) {
        Thread thread = Thread.currentThread();
        if (thread instanceof ForkJoinWorkerThread) {
            ForkJoinPool forkJoinPool = ((ForkJoinWorkerThread)thread).pool;
            while (!forkJoinPool$ManagedBlocker.isReleasable()) {
                int n;
                ForkJoinPool$WorkQueue[] forkJoinPool$WorkQueueArray = forkJoinPool.workQueues;
                if (forkJoinPool.workQueues != null && (n = forkJoinPool$WorkQueueArray.length - 1) >= 0) {
                    for (int i = 0; i <= n; ++i) {
                        if (forkJoinPool$ManagedBlocker.isReleasable()) {
                            return;
                        }
                        ForkJoinPool$WorkQueue forkJoinPool$WorkQueue = forkJoinPool$WorkQueueArray[i];
                        if (forkJoinPool$WorkQueue == null || forkJoinPool$WorkQueue.base - forkJoinPool$WorkQueue.top >= 0) continue;
                        forkJoinPool.signalWork(forkJoinPool$WorkQueue);
                        int n2 = (int)(forkJoinPool.ctl >>> 32);
                        if (n2 >= 0 || n2 >> 16 >= 0) break;
                    }
                }
                if (!forkJoinPool.tryCompensate()) continue;
                try {
                    if (!forkJoinPool$ManagedBlocker.isReleasable()) {
                        forkJoinPool$ManagedBlocker.block();
                    }
                    return;
                }
                finally {
                    forkJoinPool.incrementActiveCount();
                }
            }
            return;
        }
        if (!forkJoinPool$ManagedBlocker.isReleasable()) {
            forkJoinPool$ManagedBlocker.block();
        }
    }

    protected RunnableFuture newTaskFor(Runnable runnable, Object object) {
        return new ForkJoinTask$AdaptedRunnable(runnable, object);
    }

    protected RunnableFuture newTaskFor(Callable callable) {
        return new ForkJoinTask$AdaptedCallable(callable);
    }

    public /* synthetic */ Future submit(Runnable runnable) {
        Runnable runnable2 = runnable;
        ForkJoinPool forkJoinPool = this;
        if (runnable2 == null) {
            throw new NullPointerException();
        }
        ForkJoinTask forkJoinTask = runnable2 instanceof ForkJoinTask ? (ForkJoinTask)((Object)runnable2) : new ForkJoinTask$AdaptedRunnableAction(runnable2);
        forkJoinPool.externalPush(forkJoinTask);
        return forkJoinTask;
    }

    static /* synthetic */ Unsafe access$000() {
        return scala.concurrent.util.Unsafe.instance;
    }

    static {
        Object object;
        Object object2;
        Object object3;
        try {
            U = scala.concurrent.util.Unsafe.instance;
            object3 = ForkJoinPool.class;
            CTL = U.objectFieldOffset(((Class)object3).getDeclaredField("ctl"));
            STEALCOUNT = U.objectFieldOffset(((Class)object3).getDeclaredField("stealCount"));
            PLOCK = U.objectFieldOffset(((Class)object3).getDeclaredField("plock"));
            INDEXSEED = U.objectFieldOffset(((Class)object3).getDeclaredField("indexSeed"));
            Class<Thread> clazz = Thread.class;
            PARKBLOCKER = U.objectFieldOffset(clazz.getDeclaredField("parkBlocker"));
            object2 = ForkJoinPool$WorkQueue.class;
            QLOCK = U.objectFieldOffset(((Class)object2).getDeclaredField("qlock"));
            object = ForkJoinTask[].class;
            ABASE = U.arrayBaseOffset((Class<?>)object);
            int n = U.arrayIndexScale((Class<?>)object);
            if ((n & n - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            ASHIFT = 31 - Integer.numberOfLeadingZeros(n);
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
        submitters = new ThreadLocal();
        defaultForkJoinWorkerThreadFactory = new ForkJoinPool$DefaultForkJoinWorkerThreadFactory();
        object3 = defaultForkJoinWorkerThreadFactory;
        modifyThreadPermission = new RuntimePermission("modifyThread");
        int n = 0;
        object2 = null;
        try {
            object = System.getProperty("java.util.concurrent.ForkJoinPool.common.parallelism");
            String string = System.getProperty("java.util.concurrent.ForkJoinPool.common.exceptionHandler");
            String string2 = System.getProperty("java.util.concurrent.ForkJoinPool.common.threadFactory");
            if (string2 != null) {
                object3 = (ForkJoinPool$ForkJoinWorkerThreadFactory)ClassLoader.getSystemClassLoader().loadClass(string2).newInstance();
            }
            if (string != null) {
                object2 = (Thread.UncaughtExceptionHandler)ClassLoader.getSystemClassLoader().loadClass(string).newInstance();
            }
            if (object != null) {
                n = Integer.parseInt((String)object);
            }
        }
        catch (Exception exception) {}
        if (n <= 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        if (n > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        }
        long l = -n;
        long l2 = l << 48 & 0xFFFF000000000000L | l << 32 & 0xFFFF00000000L;
        common = new ForkJoinPool(n, l2, (ForkJoinPool$ForkJoinWorkerThreadFactory)object3, (Thread.UncaughtExceptionHandler)object2);
    }
}

