"""
Copyright (C) 2018 Torbjorn Sjostrand.
PYTHIA is licenced under the GNU GPL v2 or later, see COPYING for details.
Please respect the MCnet Guidelines, see GUIDELINES for details.

This module is a Python interface to PYTHIA 8, generated
automatically with SWIG. An attempt has been made to translate all
PYTHIA classes and functions as directly as possible. The following
features are included:

* All PYTHIA classes and functions are available. See main01.py for
  a direct Python translation of the C++ main01.cc example.
* Most of the plugin classes are also available in the
  interface. See main34.py for a direct Python translation of the C++
  main34.cc example which uses the LHAupMadgraph class from
  include/Pythia8Plugins/LHAMadgraph.h.
* When available, documentation through the built-in help function
  in Python is provided. Please note that this documentation is
  automatically generated, similar to the Doxygen
  documentation. Consequently, the inline Python documentation is not a
  replacement for this manual.
* All operators defined in C++, e.g. Vec4*double, as well as reverse
  operators, e.g. double*Vec4, are available.
* Classes with defined [] operators are iterable, using standard
  Python iteration, e.g. for prt in pythia.event.
* Classes with a << operator or a list function can be printed
  via the built-in print function in Python. Note this means that a
  string representation via str is also available for these classes in
  Python.
* Specific versions of templates needed by PYTHIA classes are
  available where the naming scheme is the template class name followed
  by its arguments (stripped of namespace specifiers); pointers to
  classes are prepended with Ptr. For example, vector<int> is available
  via the interface as VectorInt, map<string, Mode> as MapStringMode,
  and vector<ProcessContainer*> as VectorProcessContainerPtr.
* Derived classes in Python, for a subset of PYTHIA classes, can be
  passed back to PYTHIA. This is possible for all classes that can be
  passed to the Pythia class via the setXPtr functions and includes the
  following classes: BeamShape, DecayHandler, LHAup, MergingHooks, PDF,
  PhaseSpace, ResonanceWidths, RndmEngine, SigmaProcess, SpaceShower,
  TimeShower, and UserHooks. The protected functions and members of
  these classes are available through the Python interface. See
  main10.py for a direct Python translation of the C++ main10.cc example
  which uses a derived class from the UserHooks class to veto events.

This interface currently suffers from the following limitations:

* In the CoupSUSY class all public members that are 3-by-3 arrays
  cannot be accessed, these include LsddX, LsuuX, LsduX, LsudX, LsvvX,
  LsllX, LsvlX, LslvX, as well as the equivalent R versions of these
  members. Additionally, rvLLE, rvLQD, and rvUDD cannot be accessed.
* In the MergingHooks class, the protected methods orderHistories,
  allowCutonRecState, and doWeakClustering with bool return values have
  been renamed as getOrderHistories, getAllowCutonRecState, and
  getDoWeakClustering, respectively, in the Python interface.
* The public headerStream, initStream, and eventStream members of
  the Writer class, used for writing LHEF output, cannot be accessed
  from the Python interface.
* For derived Python classes of the PYTHIA class LHAup, the
  protected member osLHEF cannot be accessed.
* The wrapper generated by SWIG is large (10 MB), and consequently
  the compile time can be significant. The only way to reduce the size
  of the wrapper is to remove functionality from the interface.
* Creating a derived Python class from a PYTHIA class, as described
  above in the features, is only possible for a subset of PYTHIA
  classes. However, if this feature is needed for specific classes, they
  can be added in the future upon request. This feature is not enabled
  by default for all classes to reduce the generated wrapper size.
* Python interfaces have not been generated for plugins within
  include/Pythia8Plugins which have direct external dependencies. This
  means there are no Python interfaces for any of the classes or
  functions defined in EvtGen.h, FastJet3.h, HepMC2.h, or
  LHAFortran.h. However, interfaces are available for all remaining
  plugins, including both LHAMadgraph.h and PowhegProcs.h.
"""

# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.8
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.





from sys import version_info
if version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_pythia8', [dirname(__file__)])
        except ImportError:
            import _pythia8
            return _pythia8
        if fp is not None:
            try:
                _mod = imp.load_module('_pythia8', fp, pathname, description)
            finally:
                fp.close()
            return _mod
    _pythia8 = swig_import_helper()
    del swig_import_helper
else:
    import _pythia8
del version_info
try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.


def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr_nondynamic(self, class_type, name, static=1):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    if (not static):
        return object.__getattr__(self, name)
    else:
        raise AttributeError(name)

def _swig_getattr(self, class_type, name):
    return _swig_getattr_nondynamic(self, class_type, name, 0)


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except AttributeError:
    class _object:
        pass
    _newclass = 0


try:
    import weakref
    weakref_proxy = weakref.proxy
except Exception:
    weakref_proxy = lambda x: x


class SwigPyIterator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SwigPyIterator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SwigPyIterator, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pythia8.delete_SwigPyIterator
    __del__ = lambda self: None

    def value(self):
        return _pythia8.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _pythia8.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _pythia8.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _pythia8.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _pythia8.SwigPyIterator_equal(self, x)

    def copy(self):
        return _pythia8.SwigPyIterator_copy(self)

    def next(self):
        return _pythia8.SwigPyIterator_next(self)

    def __next__(self):
        return _pythia8.SwigPyIterator___next__(self)

    def previous(self):
        return _pythia8.SwigPyIterator_previous(self)

    def advance(self, n):
        return _pythia8.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _pythia8.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _pythia8.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _pythia8.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _pythia8.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _pythia8.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _pythia8.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self
SwigPyIterator_swigregister = _pythia8.SwigPyIterator_swigregister
SwigPyIterator_swigregister(SwigPyIterator)

class ios_base(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ios_base, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ios_base, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    erase_event = _pythia8.ios_base_erase_event
    imbue_event = _pythia8.ios_base_imbue_event
    copyfmt_event = _pythia8.ios_base_copyfmt_event

    def register_callback(self, __fn, __index):
        return _pythia8.ios_base_register_callback(self, __fn, __index)

    def flags(self, *args):
        return _pythia8.ios_base_flags(self, *args)

    def setf(self, *args):
        return _pythia8.ios_base_setf(self, *args)

    def unsetf(self, __mask):
        return _pythia8.ios_base_unsetf(self, __mask)

    def precision(self, *args):
        return _pythia8.ios_base_precision(self, *args)

    def width(self, *args):
        return _pythia8.ios_base_width(self, *args)
    __swig_getmethods__["sync_with_stdio"] = lambda x: _pythia8.ios_base_sync_with_stdio
    if _newclass:
        sync_with_stdio = staticmethod(_pythia8.ios_base_sync_with_stdio)

    def imbue(self, __loc):
        return _pythia8.ios_base_imbue(self, __loc)

    def getloc(self):
        return _pythia8.ios_base_getloc(self)
    __swig_getmethods__["xalloc"] = lambda x: _pythia8.ios_base_xalloc
    if _newclass:
        xalloc = staticmethod(_pythia8.ios_base_xalloc)

    def iword(self, __ix):
        return _pythia8.ios_base_iword(self, __ix)

    def pword(self, __ix):
        return _pythia8.ios_base_pword(self, __ix)
    __swig_destroy__ = _pythia8.delete_ios_base
    __del__ = lambda self: None
ios_base_swigregister = _pythia8.ios_base_swigregister
ios_base_swigregister(ios_base)
cvar = _pythia8.cvar
ios_base.boolalpha = _pythia8.cvar.ios_base_boolalpha
ios_base.dec = _pythia8.cvar.ios_base_dec
ios_base.fixed = _pythia8.cvar.ios_base_fixed
ios_base.hex = _pythia8.cvar.ios_base_hex
ios_base.internal = _pythia8.cvar.ios_base_internal
ios_base.left = _pythia8.cvar.ios_base_left
ios_base.oct = _pythia8.cvar.ios_base_oct
ios_base.right = _pythia8.cvar.ios_base_right
ios_base.scientific = _pythia8.cvar.ios_base_scientific
ios_base.showbase = _pythia8.cvar.ios_base_showbase
ios_base.showpoint = _pythia8.cvar.ios_base_showpoint
ios_base.showpos = _pythia8.cvar.ios_base_showpos
ios_base.skipws = _pythia8.cvar.ios_base_skipws
ios_base.unitbuf = _pythia8.cvar.ios_base_unitbuf
ios_base.uppercase = _pythia8.cvar.ios_base_uppercase
ios_base.adjustfield = _pythia8.cvar.ios_base_adjustfield
ios_base.basefield = _pythia8.cvar.ios_base_basefield
ios_base.floatfield = _pythia8.cvar.ios_base_floatfield
ios_base.badbit = _pythia8.cvar.ios_base_badbit
ios_base.eofbit = _pythia8.cvar.ios_base_eofbit
ios_base.failbit = _pythia8.cvar.ios_base_failbit
ios_base.goodbit = _pythia8.cvar.ios_base_goodbit
ios_base.app = _pythia8.cvar.ios_base_app
ios_base.ate = _pythia8.cvar.ios_base_ate
ios_base.binary = _pythia8.cvar.ios_base_binary
ios_base.ios_base_in = _pythia8.cvar.ios_base_ios_base_in
ios_base.out = _pythia8.cvar.ios_base_out
ios_base.trunc = _pythia8.cvar.ios_base_trunc
ios_base.beg = _pythia8.cvar.ios_base_beg
ios_base.cur = _pythia8.cvar.ios_base_cur
ios_base.end = _pythia8.cvar.ios_base_end

def ios_base_sync_with_stdio(__sync=True):
    return _pythia8.ios_base_sync_with_stdio(__sync)
ios_base_sync_with_stdio = _pythia8.ios_base_sync_with_stdio

def ios_base_xalloc():
    return _pythia8.ios_base_xalloc()
ios_base_xalloc = _pythia8.ios_base_xalloc

class ios(ios_base):
    __swig_setmethods__ = {}
    for _s in [ios_base]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ios, name, value)
    __swig_getmethods__ = {}
    for _s in [ios_base]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ios, name)
    __repr__ = _swig_repr

    def rdstate(self):
        return _pythia8.ios_rdstate(self)

    def clear(self, *args):
        return _pythia8.ios_clear(self, *args)

    def setstate(self, __state):
        return _pythia8.ios_setstate(self, __state)

    def good(self):
        return _pythia8.ios_good(self)

    def eof(self):
        return _pythia8.ios_eof(self)

    def fail(self):
        return _pythia8.ios_fail(self)

    def bad(self):
        return _pythia8.ios_bad(self)

    def exceptions(self, *args):
        return _pythia8.ios_exceptions(self, *args)

    def __init__(self, __sb):
        this = _pythia8.new_ios(__sb)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ios
    __del__ = lambda self: None

    def tie(self, *args):
        return _pythia8.ios_tie(self, *args)

    def rdbuf(self, *args):
        return _pythia8.ios_rdbuf(self, *args)

    def copyfmt(self, __rhs):
        return _pythia8.ios_copyfmt(self, __rhs)

    def fill(self, *args):
        return _pythia8.ios_fill(self, *args)

    def imbue(self, __loc):
        return _pythia8.ios_imbue(self, __loc)

    def narrow(self, __c, __dfault):
        return _pythia8.ios_narrow(self, __c, __dfault)

    def widen(self, __c):
        return _pythia8.ios_widen(self, __c)
ios_swigregister = _pythia8.ios_swigregister
ios_swigregister(ios)

class ostream(ios):
    __swig_setmethods__ = {}
    for _s in [ios]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ostream, name, value)
    __swig_getmethods__ = {}
    for _s in [ios]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ostream, name)
    __repr__ = _swig_repr

    def __init__(self, __sb):
        this = _pythia8.new_ostream(__sb)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ostream
    __del__ = lambda self: None

    def __lshift__(self, *args):
        return _pythia8.ostream___lshift__(self, *args)

    def put(self, __c):
        return _pythia8.ostream_put(self, __c)

    def write(self, __s, __n):
        return _pythia8.ostream_write(self, __s, __n)

    def flush(self):
        return _pythia8.ostream_flush(self)

    def tellp(self):
        return _pythia8.ostream_tellp(self)

    def seekp(self, *args):
        return _pythia8.ostream_seekp(self, *args)
ostream_swigregister = _pythia8.ostream_swigregister
ostream_swigregister(ostream)
cin = cvar.cin
cout = cvar.cout
cerr = cvar.cerr
clog = cvar.clog

class istream(ios):
    __swig_setmethods__ = {}
    for _s in [ios]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, istream, name, value)
    __swig_getmethods__ = {}
    for _s in [ios]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, istream, name)
    __repr__ = _swig_repr

    def __init__(self, __sb):
        this = _pythia8.new_istream(__sb)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_istream
    __del__ = lambda self: None

    def __rshift__(self, *args):
        return _pythia8.istream___rshift__(self, *args)

    def gcount(self):
        return _pythia8.istream_gcount(self)

    def get(self, *args):
        return _pythia8.istream_get(self, *args)

    def getline(self, *args):
        return _pythia8.istream_getline(self, *args)

    def ignore(self, *args):
        return _pythia8.istream_ignore(self, *args)

    def peek(self):
        return _pythia8.istream_peek(self)

    def read(self, __s, __n):
        return _pythia8.istream_read(self, __s, __n)

    def readsome(self, __s, __n):
        return _pythia8.istream_readsome(self, __s, __n)

    def putback(self, __c):
        return _pythia8.istream_putback(self, __c)

    def unget(self):
        return _pythia8.istream_unget(self)

    def sync(self):
        return _pythia8.istream_sync(self)

    def tellg(self):
        return _pythia8.istream_tellg(self)

    def seekg(self, *args):
        return _pythia8.istream_seekg(self, *args)
istream_swigregister = _pythia8.istream_swigregister
istream_swigregister(istream)

class iostream(istream, ostream):
    __swig_setmethods__ = {}
    for _s in [istream, ostream]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, iostream, name, value)
    __swig_getmethods__ = {}
    for _s in [istream, ostream]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, iostream, name)
    __repr__ = _swig_repr

    def __init__(self, __sb):
        this = _pythia8.new_iostream(__sb)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_iostream
    __del__ = lambda self: None
iostream_swigregister = _pythia8.iostream_swigregister
iostream_swigregister(iostream)


_pythia8.endl_cb_ptr_swigconstant(_pythia8)
endl_cb_ptr = _pythia8.endl_cb_ptr

def endl(arg1):
    return _pythia8.endl(arg1)
endl = _pythia8.endl

_pythia8.ends_cb_ptr_swigconstant(_pythia8)
ends_cb_ptr = _pythia8.ends_cb_ptr

def ends(arg1):
    return _pythia8.ends(arg1)
ends = _pythia8.ends

_pythia8.flush_cb_ptr_swigconstant(_pythia8)
flush_cb_ptr = _pythia8.flush_cb_ptr

def flush(arg1):
    return _pythia8.flush(arg1)
flush = _pythia8.flush
class streambuf(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, streambuf, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, streambuf, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _pythia8.delete_streambuf
    __del__ = lambda self: None

    def pubimbue(self, __loc):
        return _pythia8.streambuf_pubimbue(self, __loc)

    def getloc(self):
        return _pythia8.streambuf_getloc(self)

    def pubsetbuf(self, __s, __n):
        return _pythia8.streambuf_pubsetbuf(self, __s, __n)

    def pubseekoff(self, *args):
        return _pythia8.streambuf_pubseekoff(self, *args)

    def pubseekpos(self, *args):
        return _pythia8.streambuf_pubseekpos(self, *args)

    def pubsync(self):
        return _pythia8.streambuf_pubsync(self)

    def in_avail(self):
        return _pythia8.streambuf_in_avail(self)

    def snextc(self):
        return _pythia8.streambuf_snextc(self)

    def sbumpc(self):
        return _pythia8.streambuf_sbumpc(self)

    def sgetc(self):
        return _pythia8.streambuf_sgetc(self)

    def sgetn(self, __s, __n):
        return _pythia8.streambuf_sgetn(self, __s, __n)

    def sputbackc(self, __c):
        return _pythia8.streambuf_sputbackc(self, __c)

    def sungetc(self):
        return _pythia8.streambuf_sungetc(self)

    def sputc(self, __c):
        return _pythia8.streambuf_sputc(self, __c)

    def sputn(self, __s, __n):
        return _pythia8.streambuf_sputn(self, __s, __n)
streambuf_swigregister = _pythia8.streambuf_swigregister
streambuf_swigregister(streambuf)

class istringstream(istream):
    __swig_setmethods__ = {}
    for _s in [istream]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, istringstream, name, value)
    __swig_getmethods__ = {}
    for _s in [istream]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, istringstream, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _pythia8.new_istringstream(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_istringstream
    __del__ = lambda self: None

    def rdbuf(self):
        return _pythia8.istringstream_rdbuf(self)

    def str(self, *args):
        return _pythia8.istringstream_str(self, *args)
istringstream_swigregister = _pythia8.istringstream_swigregister
istringstream_swigregister(istringstream)

class ostringstream(ostream):
    __swig_setmethods__ = {}
    for _s in [ostream]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ostringstream, name, value)
    __swig_getmethods__ = {}
    for _s in [ostream]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ostringstream, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _pythia8.new_ostringstream(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ostringstream
    __del__ = lambda self: None

    def rdbuf(self):
        return _pythia8.ostringstream_rdbuf(self)

    def str(self):
        return _pythia8.ostringstream_str(self)
ostringstream_swigregister = _pythia8.ostringstream_swigregister
ostringstream_swigregister(ostringstream)

class stringstream(iostream):
    __swig_setmethods__ = {}
    for _s in [iostream]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, stringstream, name, value)
    __swig_getmethods__ = {}
    for _s in [iostream]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, stringstream, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _pythia8.new_stringstream(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_stringstream
    __del__ = lambda self: None

    def rdbuf(self):
        return _pythia8.stringstream_rdbuf(self)

    def str(self, *args):
        return _pythia8.stringstream_str(self, *args)
stringstream_swigregister = _pythia8.stringstream_swigregister
stringstream_swigregister(stringstream)

class PairIntInt(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PairIntInt, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PairIntInt, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _pythia8.new_PairIntInt(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["first"] = _pythia8.PairIntInt_first_set
    __swig_getmethods__["first"] = _pythia8.PairIntInt_first_get
    if _newclass:
        first = _swig_property(_pythia8.PairIntInt_first_get, _pythia8.PairIntInt_first_set)
    __swig_setmethods__["second"] = _pythia8.PairIntInt_second_set
    __swig_getmethods__["second"] = _pythia8.PairIntInt_second_get
    if _newclass:
        second = _swig_property(_pythia8.PairIntInt_second_get, _pythia8.PairIntInt_second_set)
    def __len__(self):
        return 2
    def __repr__(self):
        return str((self.first, self.second))
    def __getitem__(self, index): 
        if not (index % 2):
            return self.first
        else:
            return self.second
    def __setitem__(self, index, val):
        if not (index % 2):
            self.first = val
        else:
            self.second = val
    __swig_destroy__ = _pythia8.delete_PairIntInt
    __del__ = lambda self: None
PairIntInt_swigregister = _pythia8.PairIntInt_swigregister
PairIntInt_swigregister(PairIntInt)

class MapIntInt(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MapIntInt, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MapIntInt, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _pythia8.MapIntInt_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _pythia8.MapIntInt___nonzero__(self)

    def __bool__(self):
        return _pythia8.MapIntInt___bool__(self)

    def __len__(self):
        return _pythia8.MapIntInt___len__(self)
    def __iter__(self):
        return self.key_iterator()
    def iterkeys(self):
        return self.key_iterator()
    def itervalues(self):
        return self.value_iterator()
    def iteritems(self):
        return self.iterator()

    def __getitem__(self, key):
        return _pythia8.MapIntInt___getitem__(self, key)

    def __delitem__(self, key):
        return _pythia8.MapIntInt___delitem__(self, key)

    def has_key(self, key):
        return _pythia8.MapIntInt_has_key(self, key)

    def keys(self):
        return _pythia8.MapIntInt_keys(self)

    def values(self):
        return _pythia8.MapIntInt_values(self)

    def items(self):
        return _pythia8.MapIntInt_items(self)

    def __contains__(self, key):
        return _pythia8.MapIntInt___contains__(self, key)

    def key_iterator(self):
        return _pythia8.MapIntInt_key_iterator(self)

    def value_iterator(self):
        return _pythia8.MapIntInt_value_iterator(self)

    def __setitem__(self, *args):
        return _pythia8.MapIntInt___setitem__(self, *args)

    def asdict(self):
        return _pythia8.MapIntInt_asdict(self)

    def __init__(self, *args):
        this = _pythia8.new_MapIntInt(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def empty(self):
        return _pythia8.MapIntInt_empty(self)

    def size(self):
        return _pythia8.MapIntInt_size(self)

    def swap(self, v):
        return _pythia8.MapIntInt_swap(self, v)

    def begin(self):
        return _pythia8.MapIntInt_begin(self)

    def end(self):
        return _pythia8.MapIntInt_end(self)

    def rbegin(self):
        return _pythia8.MapIntInt_rbegin(self)

    def rend(self):
        return _pythia8.MapIntInt_rend(self)

    def clear(self):
        return _pythia8.MapIntInt_clear(self)

    def get_allocator(self):
        return _pythia8.MapIntInt_get_allocator(self)

    def count(self, x):
        return _pythia8.MapIntInt_count(self, x)

    def erase(self, *args):
        return _pythia8.MapIntInt_erase(self, *args)

    def find(self, x):
        return _pythia8.MapIntInt_find(self, x)

    def lower_bound(self, x):
        return _pythia8.MapIntInt_lower_bound(self, x)

    def upper_bound(self, x):
        return _pythia8.MapIntInt_upper_bound(self, x)
    __swig_destroy__ = _pythia8.delete_MapIntInt
    __del__ = lambda self: None
MapIntInt_swigregister = _pythia8.MapIntInt_swigregister
MapIntInt_swigregister(MapIntInt)

class MapStringString(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MapStringString, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MapStringString, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _pythia8.MapStringString_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _pythia8.MapStringString___nonzero__(self)

    def __bool__(self):
        return _pythia8.MapStringString___bool__(self)

    def __len__(self):
        return _pythia8.MapStringString___len__(self)
    def __iter__(self):
        return self.key_iterator()
    def iterkeys(self):
        return self.key_iterator()
    def itervalues(self):
        return self.value_iterator()
    def iteritems(self):
        return self.iterator()

    def __getitem__(self, key):
        return _pythia8.MapStringString___getitem__(self, key)

    def __delitem__(self, key):
        return _pythia8.MapStringString___delitem__(self, key)

    def has_key(self, key):
        return _pythia8.MapStringString_has_key(self, key)

    def keys(self):
        return _pythia8.MapStringString_keys(self)

    def values(self):
        return _pythia8.MapStringString_values(self)

    def items(self):
        return _pythia8.MapStringString_items(self)

    def __contains__(self, key):
        return _pythia8.MapStringString___contains__(self, key)

    def key_iterator(self):
        return _pythia8.MapStringString_key_iterator(self)

    def value_iterator(self):
        return _pythia8.MapStringString_value_iterator(self)

    def __setitem__(self, *args):
        return _pythia8.MapStringString___setitem__(self, *args)

    def asdict(self):
        return _pythia8.MapStringString_asdict(self)

    def __init__(self, *args):
        this = _pythia8.new_MapStringString(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def empty(self):
        return _pythia8.MapStringString_empty(self)

    def size(self):
        return _pythia8.MapStringString_size(self)

    def swap(self, v):
        return _pythia8.MapStringString_swap(self, v)

    def begin(self):
        return _pythia8.MapStringString_begin(self)

    def end(self):
        return _pythia8.MapStringString_end(self)

    def rbegin(self):
        return _pythia8.MapStringString_rbegin(self)

    def rend(self):
        return _pythia8.MapStringString_rend(self)

    def clear(self):
        return _pythia8.MapStringString_clear(self)

    def get_allocator(self):
        return _pythia8.MapStringString_get_allocator(self)

    def count(self, x):
        return _pythia8.MapStringString_count(self, x)

    def erase(self, *args):
        return _pythia8.MapStringString_erase(self, *args)

    def find(self, x):
        return _pythia8.MapStringString_find(self, x)

    def lower_bound(self, x):
        return _pythia8.MapStringString_lower_bound(self, x)

    def upper_bound(self, x):
        return _pythia8.MapStringString_upper_bound(self, x)
    __swig_destroy__ = _pythia8.delete_MapStringString
    __del__ = lambda self: None
MapStringString_swigregister = _pythia8.MapStringString_swigregister
MapStringString_swigregister(MapStringString)

class MapDoublePairIntInt(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MapDoublePairIntInt, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MapDoublePairIntInt, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _pythia8.MapDoublePairIntInt_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _pythia8.MapDoublePairIntInt___nonzero__(self)

    def __bool__(self):
        return _pythia8.MapDoublePairIntInt___bool__(self)

    def __len__(self):
        return _pythia8.MapDoublePairIntInt___len__(self)
    def __iter__(self):
        return self.key_iterator()
    def iterkeys(self):
        return self.key_iterator()
    def itervalues(self):
        return self.value_iterator()
    def iteritems(self):
        return self.iterator()

    def __getitem__(self, key):
        return _pythia8.MapDoublePairIntInt___getitem__(self, key)

    def __delitem__(self, key):
        return _pythia8.MapDoublePairIntInt___delitem__(self, key)

    def has_key(self, key):
        return _pythia8.MapDoublePairIntInt_has_key(self, key)

    def keys(self):
        return _pythia8.MapDoublePairIntInt_keys(self)

    def values(self):
        return _pythia8.MapDoublePairIntInt_values(self)

    def items(self):
        return _pythia8.MapDoublePairIntInt_items(self)

    def __contains__(self, key):
        return _pythia8.MapDoublePairIntInt___contains__(self, key)

    def key_iterator(self):
        return _pythia8.MapDoublePairIntInt_key_iterator(self)

    def value_iterator(self):
        return _pythia8.MapDoublePairIntInt_value_iterator(self)

    def __setitem__(self, *args):
        return _pythia8.MapDoublePairIntInt___setitem__(self, *args)

    def asdict(self):
        return _pythia8.MapDoublePairIntInt_asdict(self)

    def __init__(self, *args):
        this = _pythia8.new_MapDoublePairIntInt(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def empty(self):
        return _pythia8.MapDoublePairIntInt_empty(self)

    def size(self):
        return _pythia8.MapDoublePairIntInt_size(self)

    def swap(self, v):
        return _pythia8.MapDoublePairIntInt_swap(self, v)

    def begin(self):
        return _pythia8.MapDoublePairIntInt_begin(self)

    def end(self):
        return _pythia8.MapDoublePairIntInt_end(self)

    def rbegin(self):
        return _pythia8.MapDoublePairIntInt_rbegin(self)

    def rend(self):
        return _pythia8.MapDoublePairIntInt_rend(self)

    def clear(self):
        return _pythia8.MapDoublePairIntInt_clear(self)

    def get_allocator(self):
        return _pythia8.MapDoublePairIntInt_get_allocator(self)

    def count(self, x):
        return _pythia8.MapDoublePairIntInt_count(self, x)

    def erase(self, *args):
        return _pythia8.MapDoublePairIntInt_erase(self, *args)

    def find(self, x):
        return _pythia8.MapDoublePairIntInt_find(self, x)

    def lower_bound(self, x):
        return _pythia8.MapDoublePairIntInt_lower_bound(self, x)

    def upper_bound(self, x):
        return _pythia8.MapDoublePairIntInt_upper_bound(self, x)
    __swig_destroy__ = _pythia8.delete_MapDoublePairIntInt
    __del__ = lambda self: None
MapDoublePairIntInt_swigregister = _pythia8.MapDoublePairIntInt_swigregister
MapDoublePairIntInt_swigregister(MapDoublePairIntInt)

class VectorBool(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VectorBool, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VectorBool, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _pythia8.VectorBool_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _pythia8.VectorBool___nonzero__(self)

    def __bool__(self):
        return _pythia8.VectorBool___bool__(self)

    def __len__(self):
        return _pythia8.VectorBool___len__(self)

    def __getslice__(self, i, j):
        return _pythia8.VectorBool___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _pythia8.VectorBool___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _pythia8.VectorBool___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _pythia8.VectorBool___delitem__(self, *args)

    def __getitem__(self, *args):
        return _pythia8.VectorBool___getitem__(self, *args)

    def __setitem__(self, *args):
        return _pythia8.VectorBool___setitem__(self, *args)

    def pop(self):
        return _pythia8.VectorBool_pop(self)

    def append(self, x):
        return _pythia8.VectorBool_append(self, x)

    def empty(self):
        return _pythia8.VectorBool_empty(self)

    def size(self):
        return _pythia8.VectorBool_size(self)

    def swap(self, v):
        return _pythia8.VectorBool_swap(self, v)

    def begin(self):
        return _pythia8.VectorBool_begin(self)

    def end(self):
        return _pythia8.VectorBool_end(self)

    def rbegin(self):
        return _pythia8.VectorBool_rbegin(self)

    def rend(self):
        return _pythia8.VectorBool_rend(self)

    def clear(self):
        return _pythia8.VectorBool_clear(self)

    def get_allocator(self):
        return _pythia8.VectorBool_get_allocator(self)

    def pop_back(self):
        return _pythia8.VectorBool_pop_back(self)

    def erase(self, *args):
        return _pythia8.VectorBool_erase(self, *args)

    def __init__(self, *args):
        this = _pythia8.new_VectorBool(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def push_back(self, x):
        return _pythia8.VectorBool_push_back(self, x)

    def front(self):
        return _pythia8.VectorBool_front(self)

    def back(self):
        return _pythia8.VectorBool_back(self)

    def assign(self, n, x):
        return _pythia8.VectorBool_assign(self, n, x)

    def resize(self, *args):
        return _pythia8.VectorBool_resize(self, *args)

    def insert(self, *args):
        return _pythia8.VectorBool_insert(self, *args)

    def reserve(self, n):
        return _pythia8.VectorBool_reserve(self, n)

    def capacity(self):
        return _pythia8.VectorBool_capacity(self)
    __swig_destroy__ = _pythia8.delete_VectorBool
    __del__ = lambda self: None
VectorBool_swigregister = _pythia8.VectorBool_swigregister
VectorBool_swigregister(VectorBool)

class VectorComplex(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VectorComplex, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VectorComplex, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _pythia8.VectorComplex_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _pythia8.VectorComplex___nonzero__(self)

    def __bool__(self):
        return _pythia8.VectorComplex___bool__(self)

    def __len__(self):
        return _pythia8.VectorComplex___len__(self)

    def __getslice__(self, i, j):
        return _pythia8.VectorComplex___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _pythia8.VectorComplex___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _pythia8.VectorComplex___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _pythia8.VectorComplex___delitem__(self, *args)

    def __getitem__(self, *args):
        return _pythia8.VectorComplex___getitem__(self, *args)

    def __setitem__(self, *args):
        return _pythia8.VectorComplex___setitem__(self, *args)

    def pop(self):
        return _pythia8.VectorComplex_pop(self)

    def append(self, x):
        return _pythia8.VectorComplex_append(self, x)

    def empty(self):
        return _pythia8.VectorComplex_empty(self)

    def size(self):
        return _pythia8.VectorComplex_size(self)

    def swap(self, v):
        return _pythia8.VectorComplex_swap(self, v)

    def begin(self):
        return _pythia8.VectorComplex_begin(self)

    def end(self):
        return _pythia8.VectorComplex_end(self)

    def rbegin(self):
        return _pythia8.VectorComplex_rbegin(self)

    def rend(self):
        return _pythia8.VectorComplex_rend(self)

    def clear(self):
        return _pythia8.VectorComplex_clear(self)

    def get_allocator(self):
        return _pythia8.VectorComplex_get_allocator(self)

    def pop_back(self):
        return _pythia8.VectorComplex_pop_back(self)

    def erase(self, *args):
        return _pythia8.VectorComplex_erase(self, *args)

    def __init__(self, *args):
        this = _pythia8.new_VectorComplex(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def push_back(self, x):
        return _pythia8.VectorComplex_push_back(self, x)

    def front(self):
        return _pythia8.VectorComplex_front(self)

    def back(self):
        return _pythia8.VectorComplex_back(self)

    def assign(self, n, x):
        return _pythia8.VectorComplex_assign(self, n, x)

    def resize(self, *args):
        return _pythia8.VectorComplex_resize(self, *args)

    def insert(self, *args):
        return _pythia8.VectorComplex_insert(self, *args)

    def reserve(self, n):
        return _pythia8.VectorComplex_reserve(self, n)

    def capacity(self):
        return _pythia8.VectorComplex_capacity(self)
    __swig_destroy__ = _pythia8.delete_VectorComplex
    __del__ = lambda self: None
VectorComplex_swigregister = _pythia8.VectorComplex_swigregister
VectorComplex_swigregister(VectorComplex)

class VectorDouble(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VectorDouble, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VectorDouble, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _pythia8.VectorDouble_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _pythia8.VectorDouble___nonzero__(self)

    def __bool__(self):
        return _pythia8.VectorDouble___bool__(self)

    def __len__(self):
        return _pythia8.VectorDouble___len__(self)

    def __getslice__(self, i, j):
        return _pythia8.VectorDouble___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _pythia8.VectorDouble___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _pythia8.VectorDouble___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _pythia8.VectorDouble___delitem__(self, *args)

    def __getitem__(self, *args):
        return _pythia8.VectorDouble___getitem__(self, *args)

    def __setitem__(self, *args):
        return _pythia8.VectorDouble___setitem__(self, *args)

    def pop(self):
        return _pythia8.VectorDouble_pop(self)

    def append(self, x):
        return _pythia8.VectorDouble_append(self, x)

    def empty(self):
        return _pythia8.VectorDouble_empty(self)

    def size(self):
        return _pythia8.VectorDouble_size(self)

    def swap(self, v):
        return _pythia8.VectorDouble_swap(self, v)

    def begin(self):
        return _pythia8.VectorDouble_begin(self)

    def end(self):
        return _pythia8.VectorDouble_end(self)

    def rbegin(self):
        return _pythia8.VectorDouble_rbegin(self)

    def rend(self):
        return _pythia8.VectorDouble_rend(self)

    def clear(self):
        return _pythia8.VectorDouble_clear(self)

    def get_allocator(self):
        return _pythia8.VectorDouble_get_allocator(self)

    def pop_back(self):
        return _pythia8.VectorDouble_pop_back(self)

    def erase(self, *args):
        return _pythia8.VectorDouble_erase(self, *args)

    def __init__(self, *args):
        this = _pythia8.new_VectorDouble(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def push_back(self, x):
        return _pythia8.VectorDouble_push_back(self, x)

    def front(self):
        return _pythia8.VectorDouble_front(self)

    def back(self):
        return _pythia8.VectorDouble_back(self)

    def assign(self, n, x):
        return _pythia8.VectorDouble_assign(self, n, x)

    def resize(self, *args):
        return _pythia8.VectorDouble_resize(self, *args)

    def insert(self, *args):
        return _pythia8.VectorDouble_insert(self, *args)

    def reserve(self, n):
        return _pythia8.VectorDouble_reserve(self, n)

    def capacity(self):
        return _pythia8.VectorDouble_capacity(self)
    __swig_destroy__ = _pythia8.delete_VectorDouble
    __del__ = lambda self: None
VectorDouble_swigregister = _pythia8.VectorDouble_swigregister
VectorDouble_swigregister(VectorDouble)

class VectorInt(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VectorInt, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VectorInt, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _pythia8.VectorInt_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _pythia8.VectorInt___nonzero__(self)

    def __bool__(self):
        return _pythia8.VectorInt___bool__(self)

    def __len__(self):
        return _pythia8.VectorInt___len__(self)

    def __getslice__(self, i, j):
        return _pythia8.VectorInt___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _pythia8.VectorInt___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _pythia8.VectorInt___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _pythia8.VectorInt___delitem__(self, *args)

    def __getitem__(self, *args):
        return _pythia8.VectorInt___getitem__(self, *args)

    def __setitem__(self, *args):
        return _pythia8.VectorInt___setitem__(self, *args)

    def pop(self):
        return _pythia8.VectorInt_pop(self)

    def append(self, x):
        return _pythia8.VectorInt_append(self, x)

    def empty(self):
        return _pythia8.VectorInt_empty(self)

    def size(self):
        return _pythia8.VectorInt_size(self)

    def swap(self, v):
        return _pythia8.VectorInt_swap(self, v)

    def begin(self):
        return _pythia8.VectorInt_begin(self)

    def end(self):
        return _pythia8.VectorInt_end(self)

    def rbegin(self):
        return _pythia8.VectorInt_rbegin(self)

    def rend(self):
        return _pythia8.VectorInt_rend(self)

    def clear(self):
        return _pythia8.VectorInt_clear(self)

    def get_allocator(self):
        return _pythia8.VectorInt_get_allocator(self)

    def pop_back(self):
        return _pythia8.VectorInt_pop_back(self)

    def erase(self, *args):
        return _pythia8.VectorInt_erase(self, *args)

    def __init__(self, *args):
        this = _pythia8.new_VectorInt(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def push_back(self, x):
        return _pythia8.VectorInt_push_back(self, x)

    def front(self):
        return _pythia8.VectorInt_front(self)

    def back(self):
        return _pythia8.VectorInt_back(self)

    def assign(self, n, x):
        return _pythia8.VectorInt_assign(self, n, x)

    def resize(self, *args):
        return _pythia8.VectorInt_resize(self, *args)

    def insert(self, *args):
        return _pythia8.VectorInt_insert(self, *args)

    def reserve(self, n):
        return _pythia8.VectorInt_reserve(self, n)

    def capacity(self):
        return _pythia8.VectorInt_capacity(self)
    __swig_destroy__ = _pythia8.delete_VectorInt
    __del__ = lambda self: None
VectorInt_swigregister = _pythia8.VectorInt_swigregister
VectorInt_swigregister(VectorInt)

class VectorString(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VectorString, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VectorString, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _pythia8.VectorString_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _pythia8.VectorString___nonzero__(self)

    def __bool__(self):
        return _pythia8.VectorString___bool__(self)

    def __len__(self):
        return _pythia8.VectorString___len__(self)

    def __getslice__(self, i, j):
        return _pythia8.VectorString___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _pythia8.VectorString___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _pythia8.VectorString___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _pythia8.VectorString___delitem__(self, *args)

    def __getitem__(self, *args):
        return _pythia8.VectorString___getitem__(self, *args)

    def __setitem__(self, *args):
        return _pythia8.VectorString___setitem__(self, *args)

    def pop(self):
        return _pythia8.VectorString_pop(self)

    def append(self, x):
        return _pythia8.VectorString_append(self, x)

    def empty(self):
        return _pythia8.VectorString_empty(self)

    def size(self):
        return _pythia8.VectorString_size(self)

    def swap(self, v):
        return _pythia8.VectorString_swap(self, v)

    def begin(self):
        return _pythia8.VectorString_begin(self)

    def end(self):
        return _pythia8.VectorString_end(self)

    def rbegin(self):
        return _pythia8.VectorString_rbegin(self)

    def rend(self):
        return _pythia8.VectorString_rend(self)

    def clear(self):
        return _pythia8.VectorString_clear(self)

    def get_allocator(self):
        return _pythia8.VectorString_get_allocator(self)

    def pop_back(self):
        return _pythia8.VectorString_pop_back(self)

    def erase(self, *args):
        return _pythia8.VectorString_erase(self, *args)

    def __init__(self, *args):
        this = _pythia8.new_VectorString(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def push_back(self, x):
        return _pythia8.VectorString_push_back(self, x)

    def front(self):
        return _pythia8.VectorString_front(self)

    def back(self):
        return _pythia8.VectorString_back(self)

    def assign(self, n, x):
        return _pythia8.VectorString_assign(self, n, x)

    def resize(self, *args):
        return _pythia8.VectorString_resize(self, *args)

    def insert(self, *args):
        return _pythia8.VectorString_insert(self, *args)

    def reserve(self, n):
        return _pythia8.VectorString_reserve(self, n)

    def capacity(self):
        return _pythia8.VectorString_capacity(self)
    __swig_destroy__ = _pythia8.delete_VectorString
    __del__ = lambda self: None
VectorString_swigregister = _pythia8.VectorString_swigregister
VectorString_swigregister(VectorString)

class VectorPairIntInt(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VectorPairIntInt, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VectorPairIntInt, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _pythia8.VectorPairIntInt_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _pythia8.VectorPairIntInt___nonzero__(self)

    def __bool__(self):
        return _pythia8.VectorPairIntInt___bool__(self)

    def __len__(self):
        return _pythia8.VectorPairIntInt___len__(self)

    def __getslice__(self, i, j):
        return _pythia8.VectorPairIntInt___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _pythia8.VectorPairIntInt___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _pythia8.VectorPairIntInt___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _pythia8.VectorPairIntInt___delitem__(self, *args)

    def __getitem__(self, *args):
        return _pythia8.VectorPairIntInt___getitem__(self, *args)

    def __setitem__(self, *args):
        return _pythia8.VectorPairIntInt___setitem__(self, *args)

    def pop(self):
        return _pythia8.VectorPairIntInt_pop(self)

    def append(self, x):
        return _pythia8.VectorPairIntInt_append(self, x)

    def empty(self):
        return _pythia8.VectorPairIntInt_empty(self)

    def size(self):
        return _pythia8.VectorPairIntInt_size(self)

    def swap(self, v):
        return _pythia8.VectorPairIntInt_swap(self, v)

    def begin(self):
        return _pythia8.VectorPairIntInt_begin(self)

    def end(self):
        return _pythia8.VectorPairIntInt_end(self)

    def rbegin(self):
        return _pythia8.VectorPairIntInt_rbegin(self)

    def rend(self):
        return _pythia8.VectorPairIntInt_rend(self)

    def clear(self):
        return _pythia8.VectorPairIntInt_clear(self)

    def get_allocator(self):
        return _pythia8.VectorPairIntInt_get_allocator(self)

    def pop_back(self):
        return _pythia8.VectorPairIntInt_pop_back(self)

    def erase(self, *args):
        return _pythia8.VectorPairIntInt_erase(self, *args)

    def __init__(self, *args):
        this = _pythia8.new_VectorPairIntInt(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def push_back(self, x):
        return _pythia8.VectorPairIntInt_push_back(self, x)

    def front(self):
        return _pythia8.VectorPairIntInt_front(self)

    def back(self):
        return _pythia8.VectorPairIntInt_back(self)

    def assign(self, n, x):
        return _pythia8.VectorPairIntInt_assign(self, n, x)

    def resize(self, *args):
        return _pythia8.VectorPairIntInt_resize(self, *args)

    def insert(self, *args):
        return _pythia8.VectorPairIntInt_insert(self, *args)

    def reserve(self, n):
        return _pythia8.VectorPairIntInt_reserve(self, n)

    def capacity(self):
        return _pythia8.VectorPairIntInt_capacity(self)
    __swig_destroy__ = _pythia8.delete_VectorPairIntInt
    __del__ = lambda self: None
VectorPairIntInt_swigregister = _pythia8.VectorPairIntInt_swigregister
VectorPairIntInt_swigregister(VectorPairIntInt)

class VectorVectorInt(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VectorVectorInt, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VectorVectorInt, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _pythia8.VectorVectorInt_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _pythia8.VectorVectorInt___nonzero__(self)

    def __bool__(self):
        return _pythia8.VectorVectorInt___bool__(self)

    def __len__(self):
        return _pythia8.VectorVectorInt___len__(self)

    def __getslice__(self, i, j):
        return _pythia8.VectorVectorInt___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _pythia8.VectorVectorInt___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _pythia8.VectorVectorInt___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _pythia8.VectorVectorInt___delitem__(self, *args)

    def __getitem__(self, *args):
        return _pythia8.VectorVectorInt___getitem__(self, *args)

    def __setitem__(self, *args):
        return _pythia8.VectorVectorInt___setitem__(self, *args)

    def pop(self):
        return _pythia8.VectorVectorInt_pop(self)

    def append(self, x):
        return _pythia8.VectorVectorInt_append(self, x)

    def empty(self):
        return _pythia8.VectorVectorInt_empty(self)

    def size(self):
        return _pythia8.VectorVectorInt_size(self)

    def swap(self, v):
        return _pythia8.VectorVectorInt_swap(self, v)

    def begin(self):
        return _pythia8.VectorVectorInt_begin(self)

    def end(self):
        return _pythia8.VectorVectorInt_end(self)

    def rbegin(self):
        return _pythia8.VectorVectorInt_rbegin(self)

    def rend(self):
        return _pythia8.VectorVectorInt_rend(self)

    def clear(self):
        return _pythia8.VectorVectorInt_clear(self)

    def get_allocator(self):
        return _pythia8.VectorVectorInt_get_allocator(self)

    def pop_back(self):
        return _pythia8.VectorVectorInt_pop_back(self)

    def erase(self, *args):
        return _pythia8.VectorVectorInt_erase(self, *args)

    def __init__(self, *args):
        this = _pythia8.new_VectorVectorInt(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def push_back(self, x):
        return _pythia8.VectorVectorInt_push_back(self, x)

    def front(self):
        return _pythia8.VectorVectorInt_front(self)

    def back(self):
        return _pythia8.VectorVectorInt_back(self)

    def assign(self, n, x):
        return _pythia8.VectorVectorInt_assign(self, n, x)

    def resize(self, *args):
        return _pythia8.VectorVectorInt_resize(self, *args)

    def insert(self, *args):
        return _pythia8.VectorVectorInt_insert(self, *args)

    def reserve(self, n):
        return _pythia8.VectorVectorInt_reserve(self, n)

    def capacity(self):
        return _pythia8.VectorVectorInt_capacity(self)
    __swig_destroy__ = _pythia8.delete_VectorVectorInt
    __del__ = lambda self: None
VectorVectorInt_swigregister = _pythia8.VectorVectorInt_swigregister
VectorVectorInt_swigregister(VectorVectorInt)

class VectorVectorComplex(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, VectorVectorComplex, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, VectorVectorComplex, name)
    __repr__ = _swig_repr

    def iterator(self):
        return _pythia8.VectorVectorComplex_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _pythia8.VectorVectorComplex___nonzero__(self)

    def __bool__(self):
        return _pythia8.VectorVectorComplex___bool__(self)

    def __len__(self):
        return _pythia8.VectorVectorComplex___len__(self)

    def __getslice__(self, i, j):
        return _pythia8.VectorVectorComplex___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _pythia8.VectorVectorComplex___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _pythia8.VectorVectorComplex___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _pythia8.VectorVectorComplex___delitem__(self, *args)

    def __getitem__(self, *args):
        return _pythia8.VectorVectorComplex___getitem__(self, *args)

    def __setitem__(self, *args):
        return _pythia8.VectorVectorComplex___setitem__(self, *args)

    def pop(self):
        return _pythia8.VectorVectorComplex_pop(self)

    def append(self, x):
        return _pythia8.VectorVectorComplex_append(self, x)

    def empty(self):
        return _pythia8.VectorVectorComplex_empty(self)

    def size(self):
        return _pythia8.VectorVectorComplex_size(self)

    def swap(self, v):
        return _pythia8.VectorVectorComplex_swap(self, v)

    def begin(self):
        return _pythia8.VectorVectorComplex_begin(self)

    def end(self):
        return _pythia8.VectorVectorComplex_end(self)

    def rbegin(self):
        return _pythia8.VectorVectorComplex_rbegin(self)

    def rend(self):
        return _pythia8.VectorVectorComplex_rend(self)

    def clear(self):
        return _pythia8.VectorVectorComplex_clear(self)

    def get_allocator(self):
        return _pythia8.VectorVectorComplex_get_allocator(self)

    def pop_back(self):
        return _pythia8.VectorVectorComplex_pop_back(self)

    def erase(self, *args):
        return _pythia8.VectorVectorComplex_erase(self, *args)

    def __init__(self, *args):
        this = _pythia8.new_VectorVectorComplex(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def push_back(self, x):
        return _pythia8.VectorVectorComplex_push_back(self, x)

    def front(self):
        return _pythia8.VectorVectorComplex_front(self)

    def back(self):
        return _pythia8.VectorVectorComplex_back(self)

    def assign(self, n, x):
        return _pythia8.VectorVectorComplex_assign(self, n, x)

    def resize(self, *args):
        return _pythia8.VectorVectorComplex_resize(self, *args)

    def insert(self, *args):
        return _pythia8.VectorVectorComplex_insert(self, *args)

    def reserve(self, n):
        return _pythia8.VectorVectorComplex_reserve(self, n)

    def capacity(self):
        return _pythia8.VectorVectorComplex_capacity(self)
    __swig_destroy__ = _pythia8.delete_VectorVectorComplex
    __del__ = lambda self: None
VectorVectorComplex_swigregister = _pythia8.VectorVectorComplex_swigregister
VectorVectorComplex_swigregister(VectorVectorComplex)

class RndmEngine(_object):
    """
RndmEngine is the base class for external random number generators.
There is only one pure virtual method, that should do the generation.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, RndmEngine, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, RndmEngine, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _pythia8.delete_RndmEngine
    __del__ = lambda self: None

    def flat(self):
        """
A pure virtual method, wherein the derived class method
generates a random number uniformly distributed between 1 and 1.
"""
        return _pythia8.RndmEngine_flat(self)

    def __init__(self):
        if self.__class__ == RndmEngine:
            _self = None
        else:
            _self = self
        this = _pythia8.new_RndmEngine(_self, )
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    def __disown__(self):
        self.this.disown()
        _pythia8.disown_RndmEngine(self)
        return weakref_proxy(self)
RndmEngine_swigregister = _pythia8.RndmEngine_swigregister
RndmEngine_swigregister(RndmEngine)

class Rndm(_object):
    """
Rndm class.
This class handles random number generation according to the
Marsaglia-Zaman-Tsang algorithm.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Rndm, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Rndm, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_Rndm(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def rndmEnginePtr(self, rndmEngPtrIn):
        """
Possibility to pass in pointer for external random number generation.
"""
        return _pythia8.Rndm_rndmEnginePtr(self, rndmEngPtrIn)

    def init(self, seedIn=0):
        """
Initialize, normally at construction or in first call.
"""
        return _pythia8.Rndm_init(self, seedIn)

    def flat(self):
        """
"""
        return _pythia8.Rndm_flat(self)

    def exp(self):
        """
Generate random numbers according to exp(-x).
"""
        return _pythia8.Rndm_exp(self)

    def xexp(self):
        """
Generate random numbers according to x * exp(-x).
"""
        return _pythia8.Rndm_xexp(self)

    def gauss(self):
        """
Generate random numbers according to exp(-x^2/2).
"""
        return _pythia8.Rndm_gauss(self)

    def gauss2(self):
        """
Generate two random numbers according to exp(-x^2/2-y^2/2).
"""
        return _pythia8.Rndm_gauss2(self)

    def pick(self, prob):
        """
Pick one option among  vector of (positive) probabilities.
"""
        return _pythia8.Rndm_pick(self, prob)

    def dumpState(self, fileName):
        """
Save or read current state to or from a binary file.
"""
        return _pythia8.Rndm_dumpState(self, fileName)

    def readState(self, fileName):
        """
"""
        return _pythia8.Rndm_readState(self, fileName)
    __swig_destroy__ = _pythia8.delete_Rndm
    __del__ = lambda self: None
Rndm_swigregister = _pythia8.Rndm_swigregister
Rndm_swigregister(Rndm)

class Vec4(_object):
    """
Vec4 class.
This class implements four-vectors, in energy-momentum space.
(But can equally well be used to hold space-time four-vectors.)
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Vec4, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Vec4, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_Vec4(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def reset(self):
        """
Member functions for input.
"""
        return _pythia8.Vec4_reset(self)

    def p(self, *args):
        """
"""
        return _pythia8.Vec4_p(self, *args)

    def px(self, *args):
        """
Member functions for output.
"""
        return _pythia8.Vec4_px(self, *args)

    def py(self, *args):
        """
"""
        return _pythia8.Vec4_py(self, *args)

    def pz(self, *args):
        """
"""
        return _pythia8.Vec4_pz(self, *args)

    def e(self, *args):
        """
"""
        return _pythia8.Vec4_e(self, *args)

    def mCalc(self):
        """
"""
        return _pythia8.Vec4_mCalc(self)

    def m2Calc(self):
        """
"""
        return _pythia8.Vec4_m2Calc(self)

    def pT(self):
        """
"""
        return _pythia8.Vec4_pT(self)

    def pT2(self):
        """
"""
        return _pythia8.Vec4_pT2(self)

    def pAbs(self):
        """
"""
        return _pythia8.Vec4_pAbs(self)

    def pAbs2(self):
        """
"""
        return _pythia8.Vec4_pAbs2(self)

    def eT(self):
        """
"""
        return _pythia8.Vec4_eT(self)

    def eT2(self):
        """
"""
        return _pythia8.Vec4_eT2(self)

    def theta(self):
        """
theta is polar angle between v1 and v2.
"""
        return _pythia8.Vec4_theta(self)

    def phi(self):
        """
phi is azimuthal angle between v1 and v2 around n axis.
"""
        return _pythia8.Vec4_phi(self)

    def thetaXZ(self):
        """
"""
        return _pythia8.Vec4_thetaXZ(self)

    def pPos(self):
        """
"""
        return _pythia8.Vec4_pPos(self)

    def pNeg(self):
        """
"""
        return _pythia8.Vec4_pNeg(self)

    def rap(self):
        """
"""
        return _pythia8.Vec4_rap(self)

    def eta(self):
        """
"""
        return _pythia8.Vec4_eta(self)

    def rescale3(self, fac):
        """
Member functions that perform operations.
"""
        return _pythia8.Vec4_rescale3(self, fac)

    def rescale4(self, fac):
        """
"""
        return _pythia8.Vec4_rescale4(self, fac)

    def flip3(self):
        """
"""
        return _pythia8.Vec4_flip3(self)

    def flip4(self):
        """
"""
        return _pythia8.Vec4_flip4(self)

    def rot(self, thetaIn, phiIn):
        """
"""
        return _pythia8.Vec4_rot(self, thetaIn, phiIn)

    def rotaxis(self, *args):
        """
"""
        return _pythia8.Vec4_rotaxis(self, *args)

    def bst(self, *args):
        """
"""
        return _pythia8.Vec4_bst(self, *args)

    def bstback(self, *args):
        """
"""
        return _pythia8.Vec4_bstback(self, *args)

    def rotbst(self, M):
        """
"""
        return _pythia8.Vec4_rotbst(self, M)

    def __neg__(self):
        return _pythia8.Vec4___neg__(self)

    def __iadd__(self, v):
        return _pythia8.Vec4___iadd__(self, v)

    def __isub__(self, v):
        return _pythia8.Vec4___isub__(self, v)

    def __imul__(self, f):
        return _pythia8.Vec4___imul__(self, f)

    def __idiv__(self, f):
        return _pythia8.Vec4___idiv__(self, f)

    def __add__(self, v):
        return _pythia8.Vec4___add__(self, v)

    def __sub__(self, v):
        return _pythia8.Vec4___sub__(self, v)

    def __div__(self, f):
        return _pythia8.Vec4___div__(self, f)

    def __mul__(self, *args):
        return _pythia8.Vec4___mul__(self, *args)

    def __str__(self):
        return _pythia8.Vec4___str__(self)

    def __getitem__(self, i):
        return _pythia8.Vec4___getitem__(self, i)

    def __rmul__(self, f):
        return _pythia8.Vec4___rmul__(self, f)
    __swig_destroy__ = _pythia8.delete_Vec4
    __del__ = lambda self: None
Vec4_swigregister = _pythia8.Vec4_swigregister
Vec4_swigregister(Vec4)


def dot3(v1, v2):
    return _pythia8.dot3(v1, v2)
dot3 = _pythia8.dot3

def cross3(v1, v2):
    return _pythia8.cross3(v1, v2)
cross3 = _pythia8.cross3

def cross4(a, b, c):
    return _pythia8.cross4(a, b, c)
cross4 = _pythia8.cross4

def theta(v1, v2):
    return _pythia8.theta(v1, v2)
theta = _pythia8.theta

def costheta(v1, v2):
    return _pythia8.costheta(v1, v2)
costheta = _pythia8.costheta

def phi(*args):
    return _pythia8.phi(*args)
phi = _pythia8.phi

def cosphi(*args):
    return _pythia8.cosphi(*args)
cosphi = _pythia8.cosphi

def RRapPhi(v1, v2):
    return _pythia8.RRapPhi(v1, v2)
RRapPhi = _pythia8.RRapPhi

def REtaPhi(v1, v2):
    return _pythia8.REtaPhi(v1, v2)
REtaPhi = _pythia8.REtaPhi

def pShift(p1Move, p2Move, m1New, m2New):
    return _pythia8.pShift(p1Move, p2Move, m1New, m2New)
pShift = _pythia8.pShift

def getTwoPerpendicular(v1, v2):
    return _pythia8.getTwoPerpendicular(v1, v2)
getTwoPerpendicular = _pythia8.getTwoPerpendicular
class RotBstMatrix(_object):
    """
RotBstMatrix class.
This class implements 4 * 4 matrices that encode an arbitrary combination
of rotations and boosts, that can be applied to Vec4 four-vectors.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, RotBstMatrix, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, RotBstMatrix, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_RotBstMatrix(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def rot(self, *args):
        """
"""
        return _pythia8.RotBstMatrix_rot(self, *args)

    def bstback(self, arg2):
        """
"""
        return _pythia8.RotBstMatrix_bstback(self, arg2)

    def bst(self, *args):
        """
"""
        return _pythia8.RotBstMatrix_bst(self, *args)

    def toCMframe(self, arg2, arg3):
        """
"""
        return _pythia8.RotBstMatrix_toCMframe(self, arg2, arg3)

    def fromCMframe(self, arg2, arg3):
        """
"""
        return _pythia8.RotBstMatrix_fromCMframe(self, arg2, arg3)

    def rotbst(self, arg2):
        """
"""
        return _pythia8.RotBstMatrix_rotbst(self, arg2)

    def invert(self):
        """
"""
        return _pythia8.RotBstMatrix_invert(self)

    def inverse(self):
        """
"""
        return _pythia8.RotBstMatrix_inverse(self)

    def reset(self):
        """
"""
        return _pythia8.RotBstMatrix_reset(self)

    def value(self, i, j):
        """
Return value of matrix element.
"""
        return _pythia8.RotBstMatrix_value(self, i, j)

    def deviation(self):
        """
Crude estimate deviation from unit matrix.
"""
        return _pythia8.RotBstMatrix_deviation(self)

    def __mul__(self, *args):
        return _pythia8.RotBstMatrix___mul__(self, *args)

    def __str__(self):
        return _pythia8.RotBstMatrix___str__(self)
    __swig_destroy__ = _pythia8.delete_RotBstMatrix
    __del__ = lambda self: None
RotBstMatrix_swigregister = _pythia8.RotBstMatrix_swigregister
RotBstMatrix_swigregister(RotBstMatrix)


def toCMframe(*args):
    return _pythia8.toCMframe(*args)
toCMframe = _pythia8.toCMframe

def fromCMframe(*args):
    return _pythia8.fromCMframe(*args)
fromCMframe = _pythia8.fromCMframe
class Hist(_object):
    """
Hist class.
This class handles a single histogram at a time.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Hist, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Hist, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_Hist(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def book(self, *args):
        """
Book a histogram.
"""
        return _pythia8.Hist_book(self, *args)

    def title(self, *args):
        """
Set title of a histogram.
"""
        return _pythia8.Hist_title(self, *args)

    def null(self):
        """
Reset bin contents.
"""
        return _pythia8.Hist_null(self)

    def fill(self, x, w=1.):
        """
Fill bin with weight.
"""
        return _pythia8.Hist_fill(self, x, w)

    def table(self, *args):
        """
"""
        return _pythia8.Hist_table(self, *args)

    def rivetTable(self, *args):
        """
"""
        return _pythia8.Hist_rivetTable(self, *args)

    def pyplotTable(self, *args):
        """
"""
        return _pythia8.Hist_pyplotTable(self, *args)

    def getTitle(self):
        """
Return title and size of histogram. Also if logarithmic x scale.
"""
        return _pythia8.Hist_getTitle(self)

    def getBinNumber(self):
        """
"""
        return _pythia8.Hist_getBinNumber(self)

    def getLinX(self):
        """
"""
        return _pythia8.Hist_getLinX(self)

    def getBinContent(self, iBin):
        """
Return content of specific bin: 0 gives underflow and nBin+1 overflow.
"""
        return _pythia8.Hist_getBinContent(self, iBin)

    def getEntries(self):
        """
Return number of entries.
"""
        return _pythia8.Hist_getEntries(self)

    def sameSize(self, h):
        """
Check whether another histogram has same size and limits.
"""
        return _pythia8.Hist_sameSize(self, h)

    def takeLog(self, tenLog=True):
        """
Take logarithm (base 10 or e) of bin contents.
"""
        return _pythia8.Hist_takeLog(self, tenLog)

    def takeSqrt(self):
        """
Take square root of bin contents.
"""
        return _pythia8.Hist_takeSqrt(self)

    def smallestAbsValue(self):
        """
Find smallest nonzero absolute value of bin contents.
"""
        return _pythia8.Hist_smallestAbsValue(self)

    def __iadd__(self, *args):
        return _pythia8.Hist___iadd__(self, *args)

    def __isub__(self, *args):
        return _pythia8.Hist___isub__(self, *args)

    def __imul__(self, *args):
        return _pythia8.Hist___imul__(self, *args)

    def __idiv__(self, *args):
        return _pythia8.Hist___idiv__(self, *args)

    def __add__(self, *args):
        return _pythia8.Hist___add__(self, *args)

    def __sub__(self, *args):
        return _pythia8.Hist___sub__(self, *args)

    def __mul__(self, *args):
        return _pythia8.Hist___mul__(self, *args)

    def __div__(self, *args):
        return _pythia8.Hist___div__(self, *args)

    def __str__(self):
        return _pythia8.Hist___str__(self)

    def __radd__(self, f):
        return _pythia8.Hist___radd__(self, f)

    def __rsub__(self, f):
        return _pythia8.Hist___rsub__(self, f)

    def __rmul__(self, f):
        return _pythia8.Hist___rmul__(self, f)

    def __rdiv__(self, f):
        return _pythia8.Hist___rdiv__(self, f)
    __swig_destroy__ = _pythia8.delete_Hist
    __del__ = lambda self: None
Hist_swigregister = _pythia8.Hist_swigregister
Hist_swigregister(Hist)


def table(*args):
    return _pythia8.table(*args)
table = _pythia8.table

def __div__(f, h1):
    return _pythia8.__div__(f, h1)
__div__ = _pythia8.__div__
class HistPlot(_object):
    """
HistPlot class.
Writes a Python program that can generate PDF plots from Hist histograms.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, HistPlot, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, HistPlot, name)
    __repr__ = _swig_repr

    def __init__(self, pythonName):
        """
Constructor requires name of Python program (and adds .py).
"""
        this = _pythia8.new_HistPlot(pythonName)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_HistPlot
    __del__ = lambda self: None

    def frame(self, *args):
        """
"""
        return _pythia8.HistPlot_frame(self, *args)

    def add(self, *args):
        """
"""
        return _pythia8.HistPlot_add(self, *args)

    def plot(self, logY=False):
        """
Plot a frame given the information from the new and add calls.
"""
        return _pythia8.HistPlot_plot(self, logY)

    def plotFrame(self, *args):
        """
 Omnibus single call when only one histogram in the frame.
"""
        return _pythia8.HistPlot_plotFrame(self, *args)
HistPlot_swigregister = _pythia8.HistPlot_swigregister
HistPlot_swigregister(HistPlot)

class XMLTag(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, XMLTag, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, XMLTag, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _pythia8.delete_XMLTag
    __del__ = lambda self: None
    __swig_setmethods__["name"] = _pythia8.XMLTag_name_set
    __swig_getmethods__["name"] = _pythia8.XMLTag_name_get
    if _newclass:
        name = _swig_property(_pythia8.XMLTag_name_get, _pythia8.XMLTag_name_set)
    __swig_setmethods__["attr"] = _pythia8.XMLTag_attr_set
    __swig_getmethods__["attr"] = _pythia8.XMLTag_attr_get
    if _newclass:
        attr = _swig_property(_pythia8.XMLTag_attr_get, _pythia8.XMLTag_attr_set)
    __swig_setmethods__["tags"] = _pythia8.XMLTag_tags_set
    __swig_getmethods__["tags"] = _pythia8.XMLTag_tags_get
    if _newclass:
        tags = _swig_property(_pythia8.XMLTag_tags_get, _pythia8.XMLTag_tags_set)
    __swig_setmethods__["contents"] = _pythia8.XMLTag_contents_set
    __swig_getmethods__["contents"] = _pythia8.XMLTag_contents_get
    if _newclass:
        contents = _swig_property(_pythia8.XMLTag_contents_get, _pythia8.XMLTag_contents_set)

    def getattr(self, *args):
        return _pythia8.XMLTag_getattr(self, *args)
    __swig_getmethods__["findXMLTags"] = lambda x: _pythia8.XMLTag_findXMLTags
    if _newclass:
        findXMLTags = staticmethod(_pythia8.XMLTag_findXMLTags)

    def __str__(self):
        return _pythia8.XMLTag___str__(self)

    def __init__(self):
        this = _pythia8.new_XMLTag()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
XMLTag_swigregister = _pythia8.XMLTag_swigregister
XMLTag_swigregister(XMLTag)
XMLTag.end = _pythia8.cvar.XMLTag_end

def XMLTag_findXMLTags(str, leftover=None):
    return _pythia8.XMLTag_findXMLTags(str, leftover)
XMLTag_findXMLTags = _pythia8.XMLTag_findXMLTags

class LHAweights(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHAweights, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LHAweights, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _pythia8.new_LHAweights(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def clear(self):
        return _pythia8.LHAweights_clear(self)
    __swig_setmethods__["weights"] = _pythia8.LHAweights_weights_set
    __swig_getmethods__["weights"] = _pythia8.LHAweights_weights_get
    if _newclass:
        weights = _swig_property(_pythia8.LHAweights_weights_get, _pythia8.LHAweights_weights_set)
    __swig_setmethods__["attributes"] = _pythia8.LHAweights_attributes_set
    __swig_getmethods__["attributes"] = _pythia8.LHAweights_attributes_get
    if _newclass:
        attributes = _swig_property(_pythia8.LHAweights_attributes_get, _pythia8.LHAweights_attributes_set)
    __swig_setmethods__["contents"] = _pythia8.LHAweights_contents_set
    __swig_getmethods__["contents"] = _pythia8.LHAweights_contents_get
    if _newclass:
        contents = _swig_property(_pythia8.LHAweights_contents_get, _pythia8.LHAweights_contents_set)

    def size(self):
        return _pythia8.LHAweights_size(self)

    def __str__(self):
        return _pythia8.LHAweights___str__(self)
    __swig_destroy__ = _pythia8.delete_LHAweights
    __del__ = lambda self: None
LHAweights_swigregister = _pythia8.LHAweights_swigregister
LHAweights_swigregister(LHAweights)

class LHAscales(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHAscales, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LHAscales, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _pythia8.new_LHAscales(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def clear(self):
        return _pythia8.LHAscales_clear(self)
    __swig_setmethods__["muf"] = _pythia8.LHAscales_muf_set
    __swig_getmethods__["muf"] = _pythia8.LHAscales_muf_get
    if _newclass:
        muf = _swig_property(_pythia8.LHAscales_muf_get, _pythia8.LHAscales_muf_set)
    __swig_setmethods__["mur"] = _pythia8.LHAscales_mur_set
    __swig_getmethods__["mur"] = _pythia8.LHAscales_mur_get
    if _newclass:
        mur = _swig_property(_pythia8.LHAscales_mur_get, _pythia8.LHAscales_mur_set)
    __swig_setmethods__["mups"] = _pythia8.LHAscales_mups_set
    __swig_getmethods__["mups"] = _pythia8.LHAscales_mups_get
    if _newclass:
        mups = _swig_property(_pythia8.LHAscales_mups_get, _pythia8.LHAscales_mups_set)
    __swig_setmethods__["attributes"] = _pythia8.LHAscales_attributes_set
    __swig_getmethods__["attributes"] = _pythia8.LHAscales_attributes_get
    if _newclass:
        attributes = _swig_property(_pythia8.LHAscales_attributes_get, _pythia8.LHAscales_attributes_set)
    __swig_setmethods__["SCALUP"] = _pythia8.LHAscales_SCALUP_set
    __swig_getmethods__["SCALUP"] = _pythia8.LHAscales_SCALUP_get
    if _newclass:
        SCALUP = _swig_property(_pythia8.LHAscales_SCALUP_get, _pythia8.LHAscales_SCALUP_set)
    __swig_setmethods__["contents"] = _pythia8.LHAscales_contents_set
    __swig_getmethods__["contents"] = _pythia8.LHAscales_contents_get
    if _newclass:
        contents = _swig_property(_pythia8.LHAscales_contents_get, _pythia8.LHAscales_contents_set)

    def __str__(self):
        return _pythia8.LHAscales___str__(self)
    __swig_destroy__ = _pythia8.delete_LHAscales
    __del__ = lambda self: None
LHAscales_swigregister = _pythia8.LHAscales_swigregister
LHAscales_swigregister(LHAscales)

class LHAgenerator(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHAgenerator, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LHAgenerator, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _pythia8.new_LHAgenerator(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def clear(self):
        return _pythia8.LHAgenerator_clear(self)
    __swig_setmethods__["name"] = _pythia8.LHAgenerator_name_set
    __swig_getmethods__["name"] = _pythia8.LHAgenerator_name_get
    if _newclass:
        name = _swig_property(_pythia8.LHAgenerator_name_get, _pythia8.LHAgenerator_name_set)
    __swig_setmethods__["version"] = _pythia8.LHAgenerator_version_set
    __swig_getmethods__["version"] = _pythia8.LHAgenerator_version_get
    if _newclass:
        version = _swig_property(_pythia8.LHAgenerator_version_get, _pythia8.LHAgenerator_version_set)
    __swig_setmethods__["attributes"] = _pythia8.LHAgenerator_attributes_set
    __swig_getmethods__["attributes"] = _pythia8.LHAgenerator_attributes_get
    if _newclass:
        attributes = _swig_property(_pythia8.LHAgenerator_attributes_get, _pythia8.LHAgenerator_attributes_set)
    __swig_setmethods__["contents"] = _pythia8.LHAgenerator_contents_set
    __swig_getmethods__["contents"] = _pythia8.LHAgenerator_contents_get
    if _newclass:
        contents = _swig_property(_pythia8.LHAgenerator_contents_get, _pythia8.LHAgenerator_contents_set)

    def __str__(self):
        return _pythia8.LHAgenerator___str__(self)
    __swig_destroy__ = _pythia8.delete_LHAgenerator
    __del__ = lambda self: None
LHAgenerator_swigregister = _pythia8.LHAgenerator_swigregister
LHAgenerator_swigregister(LHAgenerator)

class LHAwgt(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHAwgt, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LHAwgt, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _pythia8.new_LHAwgt(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def clear(self):
        return _pythia8.LHAwgt_clear(self)
    __swig_setmethods__["id"] = _pythia8.LHAwgt_id_set
    __swig_getmethods__["id"] = _pythia8.LHAwgt_id_get
    if _newclass:
        id = _swig_property(_pythia8.LHAwgt_id_get, _pythia8.LHAwgt_id_set)
    __swig_setmethods__["attributes"] = _pythia8.LHAwgt_attributes_set
    __swig_getmethods__["attributes"] = _pythia8.LHAwgt_attributes_get
    if _newclass:
        attributes = _swig_property(_pythia8.LHAwgt_attributes_get, _pythia8.LHAwgt_attributes_set)
    __swig_setmethods__["contents"] = _pythia8.LHAwgt_contents_set
    __swig_getmethods__["contents"] = _pythia8.LHAwgt_contents_get
    if _newclass:
        contents = _swig_property(_pythia8.LHAwgt_contents_get, _pythia8.LHAwgt_contents_set)

    def __str__(self):
        return _pythia8.LHAwgt___str__(self)
    __swig_destroy__ = _pythia8.delete_LHAwgt
    __del__ = lambda self: None
LHAwgt_swigregister = _pythia8.LHAwgt_swigregister
LHAwgt_swigregister(LHAwgt)

class LHAweight(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHAweight, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LHAweight, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _pythia8.new_LHAweight(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def clear(self):
        return _pythia8.LHAweight_clear(self)
    __swig_setmethods__["id"] = _pythia8.LHAweight_id_set
    __swig_getmethods__["id"] = _pythia8.LHAweight_id_get
    if _newclass:
        id = _swig_property(_pythia8.LHAweight_id_get, _pythia8.LHAweight_id_set)
    __swig_setmethods__["attributes"] = _pythia8.LHAweight_attributes_set
    __swig_getmethods__["attributes"] = _pythia8.LHAweight_attributes_get
    if _newclass:
        attributes = _swig_property(_pythia8.LHAweight_attributes_get, _pythia8.LHAweight_attributes_set)
    __swig_setmethods__["contents"] = _pythia8.LHAweight_contents_set
    __swig_getmethods__["contents"] = _pythia8.LHAweight_contents_get
    if _newclass:
        contents = _swig_property(_pythia8.LHAweight_contents_get, _pythia8.LHAweight_contents_set)

    def __str__(self):
        return _pythia8.LHAweight___str__(self)
    __swig_destroy__ = _pythia8.delete_LHAweight
    __del__ = lambda self: None
LHAweight_swigregister = _pythia8.LHAweight_swigregister
LHAweight_swigregister(LHAweight)

class LHAweightgroup(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHAweightgroup, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LHAweightgroup, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _pythia8.new_LHAweightgroup(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def clear(self):
        return _pythia8.LHAweightgroup_clear(self)
    __swig_setmethods__["contents"] = _pythia8.LHAweightgroup_contents_set
    __swig_getmethods__["contents"] = _pythia8.LHAweightgroup_contents_get
    if _newclass:
        contents = _swig_property(_pythia8.LHAweightgroup_contents_get, _pythia8.LHAweightgroup_contents_set)
    __swig_setmethods__["name"] = _pythia8.LHAweightgroup_name_set
    __swig_getmethods__["name"] = _pythia8.LHAweightgroup_name_get
    if _newclass:
        name = _swig_property(_pythia8.LHAweightgroup_name_get, _pythia8.LHAweightgroup_name_set)
    __swig_setmethods__["weights"] = _pythia8.LHAweightgroup_weights_set
    __swig_getmethods__["weights"] = _pythia8.LHAweightgroup_weights_get
    if _newclass:
        weights = _swig_property(_pythia8.LHAweightgroup_weights_get, _pythia8.LHAweightgroup_weights_set)
    __swig_setmethods__["weightsKeys"] = _pythia8.LHAweightgroup_weightsKeys_set
    __swig_getmethods__["weightsKeys"] = _pythia8.LHAweightgroup_weightsKeys_get
    if _newclass:
        weightsKeys = _swig_property(_pythia8.LHAweightgroup_weightsKeys_get, _pythia8.LHAweightgroup_weightsKeys_set)
    __swig_setmethods__["attributes"] = _pythia8.LHAweightgroup_attributes_set
    __swig_getmethods__["attributes"] = _pythia8.LHAweightgroup_attributes_get
    if _newclass:
        attributes = _swig_property(_pythia8.LHAweightgroup_attributes_get, _pythia8.LHAweightgroup_attributes_set)

    def size(self):
        return _pythia8.LHAweightgroup_size(self)

    def __str__(self):
        return _pythia8.LHAweightgroup___str__(self)
    __swig_destroy__ = _pythia8.delete_LHAweightgroup
    __del__ = lambda self: None
LHAweightgroup_swigregister = _pythia8.LHAweightgroup_swigregister
LHAweightgroup_swigregister(LHAweightgroup)

class LHArwgt(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHArwgt, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LHArwgt, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _pythia8.new_LHArwgt(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def clear(self):
        return _pythia8.LHArwgt_clear(self)
    __swig_setmethods__["contents"] = _pythia8.LHArwgt_contents_set
    __swig_getmethods__["contents"] = _pythia8.LHArwgt_contents_get
    if _newclass:
        contents = _swig_property(_pythia8.LHArwgt_contents_get, _pythia8.LHArwgt_contents_set)
    __swig_setmethods__["wgts"] = _pythia8.LHArwgt_wgts_set
    __swig_getmethods__["wgts"] = _pythia8.LHArwgt_wgts_get
    if _newclass:
        wgts = _swig_property(_pythia8.LHArwgt_wgts_get, _pythia8.LHArwgt_wgts_set)
    __swig_setmethods__["wgtsKeys"] = _pythia8.LHArwgt_wgtsKeys_set
    __swig_getmethods__["wgtsKeys"] = _pythia8.LHArwgt_wgtsKeys_get
    if _newclass:
        wgtsKeys = _swig_property(_pythia8.LHArwgt_wgtsKeys_get, _pythia8.LHArwgt_wgtsKeys_set)
    __swig_setmethods__["attributes"] = _pythia8.LHArwgt_attributes_set
    __swig_getmethods__["attributes"] = _pythia8.LHArwgt_attributes_get
    if _newclass:
        attributes = _swig_property(_pythia8.LHArwgt_attributes_get, _pythia8.LHArwgt_attributes_set)

    def size(self):
        return _pythia8.LHArwgt_size(self)

    def __str__(self):
        return _pythia8.LHArwgt___str__(self)
    __swig_destroy__ = _pythia8.delete_LHArwgt
    __del__ = lambda self: None
LHArwgt_swigregister = _pythia8.LHArwgt_swigregister
LHArwgt_swigregister(LHArwgt)

class LHAinitrwgt(_object):
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHAinitrwgt, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LHAinitrwgt, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        this = _pythia8.new_LHAinitrwgt(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def clear(self):
        return _pythia8.LHAinitrwgt_clear(self)
    __swig_setmethods__["contents"] = _pythia8.LHAinitrwgt_contents_set
    __swig_getmethods__["contents"] = _pythia8.LHAinitrwgt_contents_get
    if _newclass:
        contents = _swig_property(_pythia8.LHAinitrwgt_contents_get, _pythia8.LHAinitrwgt_contents_set)
    __swig_setmethods__["weights"] = _pythia8.LHAinitrwgt_weights_set
    __swig_getmethods__["weights"] = _pythia8.LHAinitrwgt_weights_get
    if _newclass:
        weights = _swig_property(_pythia8.LHAinitrwgt_weights_get, _pythia8.LHAinitrwgt_weights_set)
    __swig_setmethods__["weightsKeys"] = _pythia8.LHAinitrwgt_weightsKeys_set
    __swig_getmethods__["weightsKeys"] = _pythia8.LHAinitrwgt_weightsKeys_get
    if _newclass:
        weightsKeys = _swig_property(_pythia8.LHAinitrwgt_weightsKeys_get, _pythia8.LHAinitrwgt_weightsKeys_set)
    __swig_setmethods__["weightgroups"] = _pythia8.LHAinitrwgt_weightgroups_set
    __swig_getmethods__["weightgroups"] = _pythia8.LHAinitrwgt_weightgroups_get
    if _newclass:
        weightgroups = _swig_property(_pythia8.LHAinitrwgt_weightgroups_get, _pythia8.LHAinitrwgt_weightgroups_set)
    __swig_setmethods__["weightgroupsKeys"] = _pythia8.LHAinitrwgt_weightgroupsKeys_set
    __swig_getmethods__["weightgroupsKeys"] = _pythia8.LHAinitrwgt_weightgroupsKeys_get
    if _newclass:
        weightgroupsKeys = _swig_property(_pythia8.LHAinitrwgt_weightgroupsKeys_get, _pythia8.LHAinitrwgt_weightgroupsKeys_set)
    __swig_setmethods__["attributes"] = _pythia8.LHAinitrwgt_attributes_set
    __swig_getmethods__["attributes"] = _pythia8.LHAinitrwgt_attributes_get
    if _newclass:
        attributes = _swig_property(_pythia8.LHAinitrwgt_attributes_get, _pythia8.LHAinitrwgt_attributes_set)

    def size(self):
        return _pythia8.LHAinitrwgt_size(self)

    def sizeWeightGroups(self):
        return _pythia8.LHAinitrwgt_sizeWeightGroups(self)

    def __str__(self):
        return _pythia8.LHAinitrwgt___str__(self)
    __swig_destroy__ = _pythia8.delete_LHAinitrwgt
    __del__ = lambda self: None
LHAinitrwgt_swigregister = _pythia8.LHAinitrwgt_swigregister
LHAinitrwgt_swigregister(LHAinitrwgt)

class HEPRUP(_object):
    """
The HEPRUP class is a simple container corresponding to the Les Houches
accord (<A HREF="http://arxiv.org/abs/hep-ph/0109068">hep-ph/0109068</A>)
common block with the same name. The members are named in the same
way as in the common block. However, fortran arrays are represented
by vectors, except for the arrays of length two which are
represented by pair objects.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, HEPRUP, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, HEPRUP, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Default constructor.
"""
        this = _pythia8.new_HEPRUP()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_HEPRUP
    __del__ = lambda self: None

    def resize(self, *args):
        """
Assuming the NPRUP variable, corresponding to the number of
sub-processes, is correctly set, resize the relevant vectors
accordingly.
"""
        return _pythia8.HEPRUP_resize(self, *args)

    def clear(self):
        """
Clear all members.
"""
        return _pythia8.HEPRUP_clear(self)
    __swig_setmethods__["IDBMUP"] = _pythia8.HEPRUP_IDBMUP_set
    __swig_getmethods__["IDBMUP"] = _pythia8.HEPRUP_IDBMUP_get
    if _newclass:
        IDBMUP = _swig_property(_pythia8.HEPRUP_IDBMUP_get, _pythia8.HEPRUP_IDBMUP_set)
    __swig_setmethods__["EBMUP"] = _pythia8.HEPRUP_EBMUP_set
    __swig_getmethods__["EBMUP"] = _pythia8.HEPRUP_EBMUP_get
    if _newclass:
        EBMUP = _swig_property(_pythia8.HEPRUP_EBMUP_get, _pythia8.HEPRUP_EBMUP_set)
    __swig_setmethods__["PDFGUP"] = _pythia8.HEPRUP_PDFGUP_set
    __swig_getmethods__["PDFGUP"] = _pythia8.HEPRUP_PDFGUP_get
    if _newclass:
        PDFGUP = _swig_property(_pythia8.HEPRUP_PDFGUP_get, _pythia8.HEPRUP_PDFGUP_set)
    __swig_setmethods__["PDFSUP"] = _pythia8.HEPRUP_PDFSUP_set
    __swig_getmethods__["PDFSUP"] = _pythia8.HEPRUP_PDFSUP_get
    if _newclass:
        PDFSUP = _swig_property(_pythia8.HEPRUP_PDFSUP_get, _pythia8.HEPRUP_PDFSUP_set)
    __swig_setmethods__["IDWTUP"] = _pythia8.HEPRUP_IDWTUP_set
    __swig_getmethods__["IDWTUP"] = _pythia8.HEPRUP_IDWTUP_get
    if _newclass:
        IDWTUP = _swig_property(_pythia8.HEPRUP_IDWTUP_get, _pythia8.HEPRUP_IDWTUP_set)
    __swig_setmethods__["NPRUP"] = _pythia8.HEPRUP_NPRUP_set
    __swig_getmethods__["NPRUP"] = _pythia8.HEPRUP_NPRUP_get
    if _newclass:
        NPRUP = _swig_property(_pythia8.HEPRUP_NPRUP_get, _pythia8.HEPRUP_NPRUP_set)
    __swig_setmethods__["XSECUP"] = _pythia8.HEPRUP_XSECUP_set
    __swig_getmethods__["XSECUP"] = _pythia8.HEPRUP_XSECUP_get
    if _newclass:
        XSECUP = _swig_property(_pythia8.HEPRUP_XSECUP_get, _pythia8.HEPRUP_XSECUP_set)
    __swig_setmethods__["XERRUP"] = _pythia8.HEPRUP_XERRUP_set
    __swig_getmethods__["XERRUP"] = _pythia8.HEPRUP_XERRUP_get
    if _newclass:
        XERRUP = _swig_property(_pythia8.HEPRUP_XERRUP_get, _pythia8.HEPRUP_XERRUP_set)
    __swig_setmethods__["XMAXUP"] = _pythia8.HEPRUP_XMAXUP_set
    __swig_getmethods__["XMAXUP"] = _pythia8.HEPRUP_XMAXUP_get
    if _newclass:
        XMAXUP = _swig_property(_pythia8.HEPRUP_XMAXUP_get, _pythia8.HEPRUP_XMAXUP_set)
    __swig_setmethods__["LPRUP"] = _pythia8.HEPRUP_LPRUP_set
    __swig_getmethods__["LPRUP"] = _pythia8.HEPRUP_LPRUP_get
    if _newclass:
        LPRUP = _swig_property(_pythia8.HEPRUP_LPRUP_get, _pythia8.HEPRUP_LPRUP_set)
    __swig_setmethods__["initrwgt"] = _pythia8.HEPRUP_initrwgt_set
    __swig_getmethods__["initrwgt"] = _pythia8.HEPRUP_initrwgt_get
    if _newclass:
        initrwgt = _swig_property(_pythia8.HEPRUP_initrwgt_get, _pythia8.HEPRUP_initrwgt_set)
    __swig_setmethods__["generators"] = _pythia8.HEPRUP_generators_set
    __swig_getmethods__["generators"] = _pythia8.HEPRUP_generators_get
    if _newclass:
        generators = _swig_property(_pythia8.HEPRUP_generators_get, _pythia8.HEPRUP_generators_set)
    __swig_setmethods__["weightgroups"] = _pythia8.HEPRUP_weightgroups_set
    __swig_getmethods__["weightgroups"] = _pythia8.HEPRUP_weightgroups_get
    if _newclass:
        weightgroups = _swig_property(_pythia8.HEPRUP_weightgroups_get, _pythia8.HEPRUP_weightgroups_set)
    __swig_setmethods__["weights"] = _pythia8.HEPRUP_weights_set
    __swig_getmethods__["weights"] = _pythia8.HEPRUP_weights_get
    if _newclass:
        weights = _swig_property(_pythia8.HEPRUP_weights_get, _pythia8.HEPRUP_weights_set)
HEPRUP_swigregister = _pythia8.HEPRUP_swigregister
HEPRUP_swigregister(HEPRUP)

class HEPEUP(_object):
    """
The HEPEUP class is a simple container corresponding to the Les Houches
accord (<A HREF="http://arxiv.org/abs/hep-ph/0109068">hep-ph/0109068</A>)
common block with the same name. The members are named in the same
way as in the common block. However, fortran arrays are represented
by vectors, except for the arrays of length two which are
represented by pair objects.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, HEPEUP, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, HEPEUP, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Copy constructor
"""
        this = _pythia8.new_HEPEUP(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def setEvent(self, x):
        """
"""
        return _pythia8.HEPEUP_setEvent(self, x)
    __swig_destroy__ = _pythia8.delete_HEPEUP
    __del__ = lambda self: None

    def reset(self):
        """
"""
        return _pythia8.HEPEUP_reset(self)

    def clear(self):
        """
Clear the HEPEUP object.
"""
        return _pythia8.HEPEUP_clear(self)

    def weight(self):
        """
Return the main weight for this event.
"""
        return _pythia8.HEPEUP_weight(self)

    def resize(self, *args):
        """
Assuming the NUP variable, corresponding to the number of
particles in the current event, is correctly set, resize the
relevant vectors accordingly.
"""
        return _pythia8.HEPEUP_resize(self, *args)
    __swig_setmethods__["NUP"] = _pythia8.HEPEUP_NUP_set
    __swig_getmethods__["NUP"] = _pythia8.HEPEUP_NUP_get
    if _newclass:
        NUP = _swig_property(_pythia8.HEPEUP_NUP_get, _pythia8.HEPEUP_NUP_set)
    __swig_setmethods__["IDPRUP"] = _pythia8.HEPEUP_IDPRUP_set
    __swig_getmethods__["IDPRUP"] = _pythia8.HEPEUP_IDPRUP_get
    if _newclass:
        IDPRUP = _swig_property(_pythia8.HEPEUP_IDPRUP_get, _pythia8.HEPEUP_IDPRUP_set)
    __swig_setmethods__["XWGTUP"] = _pythia8.HEPEUP_XWGTUP_set
    __swig_getmethods__["XWGTUP"] = _pythia8.HEPEUP_XWGTUP_get
    if _newclass:
        XWGTUP = _swig_property(_pythia8.HEPEUP_XWGTUP_get, _pythia8.HEPEUP_XWGTUP_set)
    __swig_setmethods__["XPDWUP"] = _pythia8.HEPEUP_XPDWUP_set
    __swig_getmethods__["XPDWUP"] = _pythia8.HEPEUP_XPDWUP_get
    if _newclass:
        XPDWUP = _swig_property(_pythia8.HEPEUP_XPDWUP_get, _pythia8.HEPEUP_XPDWUP_set)
    __swig_setmethods__["SCALUP"] = _pythia8.HEPEUP_SCALUP_set
    __swig_getmethods__["SCALUP"] = _pythia8.HEPEUP_SCALUP_get
    if _newclass:
        SCALUP = _swig_property(_pythia8.HEPEUP_SCALUP_get, _pythia8.HEPEUP_SCALUP_set)
    __swig_setmethods__["AQEDUP"] = _pythia8.HEPEUP_AQEDUP_set
    __swig_getmethods__["AQEDUP"] = _pythia8.HEPEUP_AQEDUP_get
    if _newclass:
        AQEDUP = _swig_property(_pythia8.HEPEUP_AQEDUP_get, _pythia8.HEPEUP_AQEDUP_set)
    __swig_setmethods__["AQCDUP"] = _pythia8.HEPEUP_AQCDUP_set
    __swig_getmethods__["AQCDUP"] = _pythia8.HEPEUP_AQCDUP_get
    if _newclass:
        AQCDUP = _swig_property(_pythia8.HEPEUP_AQCDUP_get, _pythia8.HEPEUP_AQCDUP_set)
    __swig_setmethods__["IDUP"] = _pythia8.HEPEUP_IDUP_set
    __swig_getmethods__["IDUP"] = _pythia8.HEPEUP_IDUP_get
    if _newclass:
        IDUP = _swig_property(_pythia8.HEPEUP_IDUP_get, _pythia8.HEPEUP_IDUP_set)
    __swig_setmethods__["ISTUP"] = _pythia8.HEPEUP_ISTUP_set
    __swig_getmethods__["ISTUP"] = _pythia8.HEPEUP_ISTUP_get
    if _newclass:
        ISTUP = _swig_property(_pythia8.HEPEUP_ISTUP_get, _pythia8.HEPEUP_ISTUP_set)
    __swig_setmethods__["MOTHUP"] = _pythia8.HEPEUP_MOTHUP_set
    __swig_getmethods__["MOTHUP"] = _pythia8.HEPEUP_MOTHUP_get
    if _newclass:
        MOTHUP = _swig_property(_pythia8.HEPEUP_MOTHUP_get, _pythia8.HEPEUP_MOTHUP_set)
    __swig_setmethods__["ICOLUP"] = _pythia8.HEPEUP_ICOLUP_set
    __swig_getmethods__["ICOLUP"] = _pythia8.HEPEUP_ICOLUP_get
    if _newclass:
        ICOLUP = _swig_property(_pythia8.HEPEUP_ICOLUP_get, _pythia8.HEPEUP_ICOLUP_set)
    __swig_setmethods__["PUP"] = _pythia8.HEPEUP_PUP_set
    __swig_getmethods__["PUP"] = _pythia8.HEPEUP_PUP_get
    if _newclass:
        PUP = _swig_property(_pythia8.HEPEUP_PUP_get, _pythia8.HEPEUP_PUP_set)
    __swig_setmethods__["VTIMUP"] = _pythia8.HEPEUP_VTIMUP_set
    __swig_getmethods__["VTIMUP"] = _pythia8.HEPEUP_VTIMUP_get
    if _newclass:
        VTIMUP = _swig_property(_pythia8.HEPEUP_VTIMUP_get, _pythia8.HEPEUP_VTIMUP_set)
    __swig_setmethods__["SPINUP"] = _pythia8.HEPEUP_SPINUP_set
    __swig_getmethods__["SPINUP"] = _pythia8.HEPEUP_SPINUP_get
    if _newclass:
        SPINUP = _swig_property(_pythia8.HEPEUP_SPINUP_get, _pythia8.HEPEUP_SPINUP_set)
    __swig_setmethods__["heprup"] = _pythia8.HEPEUP_heprup_set
    __swig_getmethods__["heprup"] = _pythia8.HEPEUP_heprup_get
    if _newclass:
        heprup = _swig_property(_pythia8.HEPEUP_heprup_get, _pythia8.HEPEUP_heprup_set)
    __swig_setmethods__["weights_detailed"] = _pythia8.HEPEUP_weights_detailed_set
    __swig_getmethods__["weights_detailed"] = _pythia8.HEPEUP_weights_detailed_get
    if _newclass:
        weights_detailed = _swig_property(_pythia8.HEPEUP_weights_detailed_get, _pythia8.HEPEUP_weights_detailed_set)
    __swig_setmethods__["weights_compressed"] = _pythia8.HEPEUP_weights_compressed_set
    __swig_getmethods__["weights_compressed"] = _pythia8.HEPEUP_weights_compressed_get
    if _newclass:
        weights_compressed = _swig_property(_pythia8.HEPEUP_weights_compressed_get, _pythia8.HEPEUP_weights_compressed_set)
    __swig_setmethods__["scalesSave"] = _pythia8.HEPEUP_scalesSave_set
    __swig_getmethods__["scalesSave"] = _pythia8.HEPEUP_scalesSave_get
    if _newclass:
        scalesSave = _swig_property(_pythia8.HEPEUP_scalesSave_get, _pythia8.HEPEUP_scalesSave_set)
    __swig_setmethods__["weightsSave"] = _pythia8.HEPEUP_weightsSave_set
    __swig_getmethods__["weightsSave"] = _pythia8.HEPEUP_weightsSave_get
    if _newclass:
        weightsSave = _swig_property(_pythia8.HEPEUP_weightsSave_get, _pythia8.HEPEUP_weightsSave_set)
    __swig_setmethods__["rwgtSave"] = _pythia8.HEPEUP_rwgtSave_set
    __swig_getmethods__["rwgtSave"] = _pythia8.HEPEUP_rwgtSave_get
    if _newclass:
        rwgtSave = _swig_property(_pythia8.HEPEUP_rwgtSave_get, _pythia8.HEPEUP_rwgtSave_set)
    __swig_setmethods__["attributes"] = _pythia8.HEPEUP_attributes_set
    __swig_getmethods__["attributes"] = _pythia8.HEPEUP_attributes_get
    if _newclass:
        attributes = _swig_property(_pythia8.HEPEUP_attributes_get, _pythia8.HEPEUP_attributes_set)
HEPEUP_swigregister = _pythia8.HEPEUP_swigregister
HEPEUP_swigregister(HEPEUP)

class Reader(_object):
    """
The Reader class is initialized with a stream from which to read a
version 1/3 Les Houches Accord event file. In the constructor of
the Reader object the optional header information is read and then
the mandatory init is read. After this the whole header block
including the enclosing lines with tags are available in the public
headerBlock member variable. Also the information from the init
block is available in the heprup member variable and any additional
comment lines are available in initComments. After each successful
call to the readEvent() function the standard Les Houches Accord
information about the event is available in the hepeup member
variable and any additional comments in the eventComments
variable. A typical reading sequence would look as follows:
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Reader, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Reader, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
The copy constructor should never be used.
"""
        this = _pythia8.new_Reader(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_Reader
    __del__ = lambda self: None

    def setup(self, filenameIn):
        """
(Re)initialize the Reader with a filename from which to read an event
file. After this, all information from the header and init block is
available.
filename: File name (not used as the input file stream is given)
isIn    : Name of the input file stream.
"""
        return _pythia8.Reader_setup(self, filenameIn)

    def readEvent(self, peup=None):
        """
Read an event from the file and store it in the hepeup
object. Optional comment lines are stored in the eventComments
member variable.
"""
        return _pythia8.Reader_readEvent(self, peup)

    def clearEvent(self):
        """
Reset values of all event-related members to their defaults.
"""
        return _pythia8.Reader_clearEvent(self)
    __swig_setmethods__["isGood"] = _pythia8.Reader_isGood_set
    __swig_getmethods__["isGood"] = _pythia8.Reader_isGood_get
    if _newclass:
        isGood = _swig_property(_pythia8.Reader_isGood_get, _pythia8.Reader_isGood_set)
    __swig_setmethods__["version"] = _pythia8.Reader_version_set
    __swig_getmethods__["version"] = _pythia8.Reader_version_get
    if _newclass:
        version = _swig_property(_pythia8.Reader_version_get, _pythia8.Reader_version_set)
    __swig_setmethods__["outsideBlock"] = _pythia8.Reader_outsideBlock_set
    __swig_getmethods__["outsideBlock"] = _pythia8.Reader_outsideBlock_get
    if _newclass:
        outsideBlock = _swig_property(_pythia8.Reader_outsideBlock_get, _pythia8.Reader_outsideBlock_set)
    __swig_setmethods__["headerBlock"] = _pythia8.Reader_headerBlock_set
    __swig_getmethods__["headerBlock"] = _pythia8.Reader_headerBlock_get
    if _newclass:
        headerBlock = _swig_property(_pythia8.Reader_headerBlock_get, _pythia8.Reader_headerBlock_set)
    __swig_setmethods__["headerComments"] = _pythia8.Reader_headerComments_set
    __swig_getmethods__["headerComments"] = _pythia8.Reader_headerComments_get
    if _newclass:
        headerComments = _swig_property(_pythia8.Reader_headerComments_get, _pythia8.Reader_headerComments_set)
    __swig_setmethods__["heprup"] = _pythia8.Reader_heprup_set
    __swig_getmethods__["heprup"] = _pythia8.Reader_heprup_get
    if _newclass:
        heprup = _swig_property(_pythia8.Reader_heprup_get, _pythia8.Reader_heprup_set)
    __swig_setmethods__["initComments"] = _pythia8.Reader_initComments_set
    __swig_getmethods__["initComments"] = _pythia8.Reader_initComments_get
    if _newclass:
        initComments = _swig_property(_pythia8.Reader_initComments_get, _pythia8.Reader_initComments_set)
    __swig_setmethods__["hepeup"] = _pythia8.Reader_hepeup_set
    __swig_getmethods__["hepeup"] = _pythia8.Reader_hepeup_get
    if _newclass:
        hepeup = _swig_property(_pythia8.Reader_hepeup_get, _pythia8.Reader_hepeup_set)
    __swig_setmethods__["eventComments"] = _pythia8.Reader_eventComments_set
    __swig_getmethods__["eventComments"] = _pythia8.Reader_eventComments_get
    if _newclass:
        eventComments = _swig_property(_pythia8.Reader_eventComments_get, _pythia8.Reader_eventComments_set)
    __swig_setmethods__["weights_detailed_vec"] = _pythia8.Reader_weights_detailed_vec_set
    __swig_getmethods__["weights_detailed_vec"] = _pythia8.Reader_weights_detailed_vec_get
    if _newclass:
        weights_detailed_vec = _swig_property(_pythia8.Reader_weights_detailed_vec_get, _pythia8.Reader_weights_detailed_vec_set)
Reader_swigregister = _pythia8.Reader_swigregister
Reader_swigregister(Reader)

class Writer(_object):
    """
The Writer class is initialized with a stream to which to write a
version 1.0 or 3.0 Les Houches Accord event file. In the init() function of
the Writer object the main XML tag, header and init blocks are written,
with the corresponding end tag is written by list_end_tag().
After a Writer object (in the following called "writer") has been created,
it is possible to assign version (3 by default) information by
  writer.version = <value>;
The header block (called "someHeaderString" below) is assigned by
  writer.headerBlock() << someHeaderString;
and the init block comments (called "someInitString" below) are assigned via
  writer.initComments() << someInitString;
The standard init information (including amendments for LHEF 3.0) can
be assigned by the heprup member variable:
  writer.heprup = heprup;
where heprup is an object of type HEPRUP. All of the above information
will be writen by calling the init() function.
Before each event is written out with the writeEvent() function,
the standard event information can be assigned to the hepeup
variable by
  writer.hepeup = hepeup;
where hepeup is of type HEPEUP. Event comments (called
"someCommentString" below) can be assigned through
  writer.eventComments() << someCommentString;
All of this event information is written by the writeEvent() function.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Writer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Writer, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
The copy constructor should never be used.
"""
        this = _pythia8.new_Writer(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_Writer
    __del__ = lambda self: None

    def headerBlock(self):
        """
Add header lines consisting of XML code with this stream.
"""
        return _pythia8.Writer_headerBlock(self)

    def initComments(self):
        """
Add comment lines to the init block with this stream.
"""
        return _pythia8.Writer_initComments(self)

    def eventComments(self):
        """
Add comment lines to the next event to be written out with this stream.
"""
        return _pythia8.Writer_eventComments(self)

    def init(self):
        """
Write out an optional header block followed by the standard init
block information together with any comment lines.
"""
        return _pythia8.Writer_init(self)

    def writeEvent(self, peup=None, pDigits=15):
        """
Write out the event stored in hepeup, followed by optional
comment lines.
"""
        return _pythia8.Writer_writeEvent(self, peup, pDigits)

    def getEventString(self, peup=None):
        """
Write out an event as a string.
"""
        return _pythia8.Writer_getEventString(self, peup)
    __swig_setmethods__["heprup"] = _pythia8.Writer_heprup_set
    __swig_getmethods__["heprup"] = _pythia8.Writer_heprup_get
    if _newclass:
        heprup = _swig_property(_pythia8.Writer_heprup_get, _pythia8.Writer_heprup_set)
    __swig_setmethods__["hepeup"] = _pythia8.Writer_hepeup_set
    __swig_getmethods__["hepeup"] = _pythia8.Writer_hepeup_get
    if _newclass:
        hepeup = _swig_property(_pythia8.Writer_hepeup_get, _pythia8.Writer_hepeup_set)
    __swig_setmethods__["version"] = _pythia8.Writer_version_set
    __swig_getmethods__["version"] = _pythia8.Writer_version_get
    if _newclass:
        version = _swig_property(_pythia8.Writer_version_get, _pythia8.Writer_version_set)
Writer_swigregister = _pythia8.Writer_swigregister
Writer_swigregister(Writer)

class PartonSystem(_object):
    """
Pointer to MergingHooks object for user interaction with the merging.
Parameters to specify trial shower usage.
Parameters to store to veto trial showers.
Parameters to specify merging usage.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PartonSystem, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PartonSystem, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructors.
"""
        this = _pythia8.new_PartonSystem()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["hard"] = _pythia8.PartonSystem_hard_set
    __swig_getmethods__["hard"] = _pythia8.PartonSystem_hard_get
    if _newclass:
        hard = _swig_property(_pythia8.PartonSystem_hard_get, _pythia8.PartonSystem_hard_set)
    __swig_setmethods__["iInA"] = _pythia8.PartonSystem_iInA_set
    __swig_getmethods__["iInA"] = _pythia8.PartonSystem_iInA_get
    if _newclass:
        iInA = _swig_property(_pythia8.PartonSystem_iInA_get, _pythia8.PartonSystem_iInA_set)
    __swig_setmethods__["iInB"] = _pythia8.PartonSystem_iInB_set
    __swig_getmethods__["iInB"] = _pythia8.PartonSystem_iInB_get
    if _newclass:
        iInB = _swig_property(_pythia8.PartonSystem_iInB_get, _pythia8.PartonSystem_iInB_set)
    __swig_setmethods__["iInRes"] = _pythia8.PartonSystem_iInRes_set
    __swig_getmethods__["iInRes"] = _pythia8.PartonSystem_iInRes_get
    if _newclass:
        iInRes = _swig_property(_pythia8.PartonSystem_iInRes_get, _pythia8.PartonSystem_iInRes_set)
    __swig_setmethods__["iOut"] = _pythia8.PartonSystem_iOut_set
    __swig_getmethods__["iOut"] = _pythia8.PartonSystem_iOut_get
    if _newclass:
        iOut = _swig_property(_pythia8.PartonSystem_iOut_get, _pythia8.PartonSystem_iOut_set)
    __swig_setmethods__["sHat"] = _pythia8.PartonSystem_sHat_set
    __swig_getmethods__["sHat"] = _pythia8.PartonSystem_sHat_get
    if _newclass:
        sHat = _swig_property(_pythia8.PartonSystem_sHat_get, _pythia8.PartonSystem_sHat_set)
    __swig_setmethods__["pTHat"] = _pythia8.PartonSystem_pTHat_set
    __swig_getmethods__["pTHat"] = _pythia8.PartonSystem_pTHat_get
    if _newclass:
        pTHat = _swig_property(_pythia8.PartonSystem_pTHat_get, _pythia8.PartonSystem_pTHat_set)
    __swig_destroy__ = _pythia8.delete_PartonSystem
    __del__ = lambda self: None
PartonSystem_swigregister = _pythia8.PartonSystem_swigregister
PartonSystem_swigregister(PartonSystem)

class PartonSystems(_object):
    """
Stored quantities.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PartonSystems, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PartonSystems, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_PartonSystems()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def clear(self):
        """
Reset system list to empty.
"""
        return _pythia8.PartonSystems_clear(self)

    def addSys(self):
        """
Add new subsystem to list; return its index. Number of subsystems.
"""
        return _pythia8.PartonSystems_addSys(self)

    def sizeSys(self):
        """
"""
        return _pythia8.PartonSystems_sizeSys(self)

    def setHard(self, iSys, hard):
        """
Set, add or replace info to one system.
"""
        return _pythia8.PartonSystems_setHard(self, iSys, hard)

    def setInA(self, iSys, iPos):
        """
"""
        return _pythia8.PartonSystems_setInA(self, iSys, iPos)

    def setInB(self, iSys, iPos):
        """
"""
        return _pythia8.PartonSystems_setInB(self, iSys, iPos)

    def setInRes(self, iSys, iPos):
        """
"""
        return _pythia8.PartonSystems_setInRes(self, iSys, iPos)

    def addOut(self, iSys, iPos):
        """
"""
        return _pythia8.PartonSystems_addOut(self, iSys, iPos)

    def popBackOut(self, iSys):
        """
"""
        return _pythia8.PartonSystems_popBackOut(self, iSys)

    def setOut(self, iSys, iMem, iPos):
        """
"""
        return _pythia8.PartonSystems_setOut(self, iSys, iMem, iPos)

    def replace(self, iSys, iPosOld, iPosNew):
        """
"""
        return _pythia8.PartonSystems_replace(self, iSys, iPosOld, iPosNew)

    def setSHat(self, iSys, sHatIn):
        """
"""
        return _pythia8.PartonSystems_setSHat(self, iSys, sHatIn)

    def setPTHat(self, iSys, pTHatIn):
        """
"""
        return _pythia8.PartonSystems_setPTHat(self, iSys, pTHatIn)

    def setSizeSys(self, iSize):
        """
"""
        return _pythia8.PartonSystems_setSizeSys(self, iSize)

    def hasInAB(self, iSys):
        """
Get info on one system.
"""
        return _pythia8.PartonSystems_hasInAB(self, iSys)

    def hasInRes(self, iSys):
        """
"""
        return _pythia8.PartonSystems_hasInRes(self, iSys)

    def getHard(self, iSys):
        """
"""
        return _pythia8.PartonSystems_getHard(self, iSys)

    def getInA(self, iSys):
        """
"""
        return _pythia8.PartonSystems_getInA(self, iSys)

    def getInB(self, iSys):
        """
"""
        return _pythia8.PartonSystems_getInB(self, iSys)

    def getInRes(self, iSys):
        """
"""
        return _pythia8.PartonSystems_getInRes(self, iSys)

    def sizeOut(self, iSys):
        """
"""
        return _pythia8.PartonSystems_sizeOut(self, iSys)

    def getOut(self, iSys, iMem):
        """
"""
        return _pythia8.PartonSystems_getOut(self, iSys, iMem)

    def sizeAll(self, iSys):
        """
"""
        return _pythia8.PartonSystems_sizeAll(self, iSys)

    def getAll(self, iSys, iMem):
        """
"""
        return _pythia8.PartonSystems_getAll(self, iSys, iMem)

    def getSHat(self, iSys):
        """
"""
        return _pythia8.PartonSystems_getSHat(self, iSys)

    def getPTHat(self, iSys):
        """
"""
        return _pythia8.PartonSystems_getPTHat(self, iSys)

    def getSystemOf(self, iPos, alsoIn=False):
        """
Find system of given outgoing parton, optionally also incoming one.
"""
        return _pythia8.PartonSystems_getSystemOf(self, iPos, alsoIn)

    def getIndexOfOut(self, iSys, iPos):
        """
Find iOut index of given system and event record index
"""
        return _pythia8.PartonSystems_getIndexOfOut(self, iSys, iPos)

    def popBack(self):
        """
Remove the last system.
"""
        return _pythia8.PartonSystems_popBack(self)

    def __str__(self):
        return _pythia8.PartonSystems___str__(self)
    __swig_destroy__ = _pythia8.delete_PartonSystems
    __del__ = lambda self: None
PartonSystems_swigregister = _pythia8.PartonSystems_swigregister
PartonSystems_swigregister(PartonSystems)

class ProgressLog(_object):
    """
ProgressLog is a simple helper class to monitor the progress of a run.
When used in the main event loop, it will with suitably (logarithmically)
spaced intervals, print out one line with information about the number
of events generated, two estimates (based on instantaneous and average
CPU consumption) of when the run will be completed, the host on which
the program is run and its process number.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProgressLog, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ProgressLog, name)
    __repr__ = _swig_repr

    def __init__(self, NIn, maxsec=1200):
        """
Create an object for monitoring the progress of a run with NIn iterations.
"""
        this = _pythia8.new_ProgressLog(NIn, maxsec)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def __call__(self, *args):
        return _pythia8.ProgressLog___call__(self, *args)

    def tick(self, i, n):
        """
Intermittently write out a line of progress information giving
the current iteration and the total number of iterations.
"""
        return _pythia8.ProgressLog_tick(self, i, n)

    def fclock(self):
        """
"""
        return _pythia8.ProgressLog_fclock(self)

    def statusTime(self, i, n):
        """
Check if this is a good time to print out a status line.
"""
        return _pythia8.ProgressLog_statusTime(self, i, n)

    def init(self, n):
        """
Initialise the basic engine.
"""
        return _pythia8.ProgressLog_init(self, n)
    __swig_destroy__ = _pythia8.delete_ProgressLog
    __del__ = lambda self: None
ProgressLog_swigregister = _pythia8.ProgressLog_swigregister
ProgressLog_swigregister(ProgressLog)

class SimpleWeakShowerMEs(_object):
    """
The SimpleWeakShowerMEs provides ME's needed for W/Z emission in ISR or FSR.
The 2 -> 2 MEs contain the correct kinematics, but for some of
the 2 -> 3 MEs some couplings have been switched off.
This class is used for ME corrections in the weak shower and for merging
whenever weak reclusterings are allowed.
Also be aware that no phase-space factors are included.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SimpleWeakShowerMEs, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SimpleWeakShowerMEs, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_SimpleWeakShowerMEs()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def getMEqg2qg(self, sH, tH, uH):
        """
Calculate the 2 to 2 ME qg -> qg, up to a known overall factor.
"""
        return _pythia8.SimpleWeakShowerMEs_getMEqg2qg(self, sH, tH, uH)

    def getMEqq2qq(self, sH, tH, uH, sameID):
        """
Calculate the 2 to 2 ME qq -> qq, up to a known overall factor.
"""
        return _pythia8.SimpleWeakShowerMEs_getMEqq2qq(self, sH, tH, uH, sameID)

    def getMEgg2gg(self, sH, tH, uH):
        """
Calculate the 2 to 2 ME gg -> gg, up to a known overall factor.
"""
        return _pythia8.SimpleWeakShowerMEs_getMEgg2gg(self, sH, tH, uH)

    def getMEgg2qqbar(self, sH, tH, uH):
        """
Calculate the 2 to 2 ME gg -> qqbar, up to a known overall factor.
"""
        return _pythia8.SimpleWeakShowerMEs_getMEgg2qqbar(self, sH, tH, uH)

    def getMEqqbar2gg(self, sH, tH, uH):
        """
Calculate the 2 to 2 ME qqbar -> gg, up to a known overall factor.
"""
        return _pythia8.SimpleWeakShowerMEs_getMEqqbar2gg(self, sH, tH, uH)

    def getMEqqbar2qqbar(self, sH, tH, uH, sameID):
        """
Calculate the 2 to 2 ME qqbar -> qqbar, up to a known overall factor.
"""
        return _pythia8.SimpleWeakShowerMEs_getMEqqbar2qqbar(self, sH, tH, uH, sameID)

    def getMEqg2qgZ(self, p1, p2, p3, p4, p5):
        """
Calculate the 2 to 3 ME uG -> uGZ, up to a known overall factor.
"""
        return _pythia8.SimpleWeakShowerMEs_getMEqg2qgZ(self, p1, p2, p3, p4, p5)

    def getMEqq2qqZ(self, p1, p2, p3, p4, p5):
        """
Calculate the 2 to 3 ME ud -> udZ, up to a known overall factor,
and with the coupling between Z and d set to zero.
"""
        return _pythia8.SimpleWeakShowerMEs_getMEqq2qqZ(self, p1, p2, p3, p4, p5)
    __swig_destroy__ = _pythia8.delete_SimpleWeakShowerMEs
    __del__ = lambda self: None
SimpleWeakShowerMEs_swigregister = _pythia8.SimpleWeakShowerMEs_swigregister
SimpleWeakShowerMEs_swigregister(SimpleWeakShowerMEs)

class DummyForStreams(_object):
    """
Dummy to avoid harmless compiler warning that Streams.o has no symbols.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DummyForStreams, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DummyForStreams, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
"""
        this = _pythia8.new_DummyForStreams()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def xtox(self, x):
        """
"""
        return _pythia8.DummyForStreams_xtox(self, x)
    __swig_destroy__ = _pythia8.delete_DummyForStreams
    __del__ = lambda self: None
DummyForStreams_swigregister = _pythia8.DummyForStreams_swigregister
DummyForStreams_swigregister(DummyForStreams)

class LHgenericBlock(_object):
    """
Derived class for generic blocks containing vectors of strings.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHgenericBlock, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LHgenericBlock, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
"""
        this = _pythia8.new_LHgenericBlock()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_LHgenericBlock
    __del__ = lambda self: None
LHgenericBlock_swigregister = _pythia8.LHgenericBlock_swigregister
LHgenericBlock_swigregister(LHgenericBlock)

class LHdecayChannel(_object):
    """
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHdecayChannel, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LHdecayChannel, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_LHdecayChannel(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def setChannel(self, *args):
        """
Functions to set decay channel information
"""
        return _pythia8.LHdecayChannel_setChannel(self, *args)

    def setBrat(self, bratIn):
        """
"""
        return _pythia8.LHdecayChannel_setBrat(self, bratIn)

    def setIdDa(self, idDaIn):
        """
"""
        return _pythia8.LHdecayChannel_setIdDa(self, idDaIn)

    def getBrat(self):
        """
Functions to get decay channel information
"""
        return _pythia8.LHdecayChannel_getBrat(self)

    def getNDa(self):
        """
"""
        return _pythia8.LHdecayChannel_getNDa(self)

    def getIdDa(self):
        """
"""
        return _pythia8.LHdecayChannel_getIdDa(self)

    def getComment(self):
        """
"""
        return _pythia8.LHdecayChannel_getComment(self)
    __swig_destroy__ = _pythia8.delete_LHdecayChannel
    __del__ = lambda self: None
LHdecayChannel_swigregister = _pythia8.LHdecayChannel_swigregister
LHdecayChannel_swigregister(LHdecayChannel)

class LHdecayTable(_object):
    """
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHdecayTable, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LHdecayTable, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_LHdecayTable(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def getId(self):
        """
Functions to get PDG code (id) and width
"""
        return _pythia8.LHdecayTable_getId(self)

    def getWidth(self):
        """
"""
        return _pythia8.LHdecayTable_getWidth(self)

    def setId(self, idIn):
        """
Functions to set PDG code (id) and width
"""
        return _pythia8.LHdecayTable_setId(self, idIn)

    def setWidth(self, widthIn):
        """
"""
        return _pythia8.LHdecayTable_setWidth(self, widthIn)

    def reset(self, widthIn=0.0):
        """
Function to reset size and width (width -> 0 by default)
"""
        return _pythia8.LHdecayTable_reset(self, widthIn)

    def addChannel(self, *args):
        """
"""
        return _pythia8.LHdecayTable_addChannel(self, *args)

    def size(self):
        """
Function to return number of decay channels
"""
        return _pythia8.LHdecayTable_size(self)

    def getBrat(self, iChannel):
        """
Function to return a branching ratio
"""
        return _pythia8.LHdecayTable_getBrat(self, iChannel)

    def getIdDa(self, iChannel):
        """
Function to return daughter PDG codes
"""
        return _pythia8.LHdecayTable_getIdDa(self, iChannel)

    def getChannel(self, iChannel):
        """
Function to return a decay channel
"""
        return _pythia8.LHdecayTable_getChannel(self, iChannel)
    __swig_destroy__ = _pythia8.delete_LHdecayTable
    __del__ = lambda self: None
LHdecayTable_swigregister = _pythia8.LHdecayTable_swigregister
LHdecayTable_swigregister(LHdecayTable)

class SusyLesHouches(_object):
    """
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SusyLesHouches, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SusyLesHouches, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_SusyLesHouches(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def readFile(self, *args):
        """
"""
        return _pythia8.SusyLesHouches_readFile(self, *args)

    def listHeader(self):
        return _pythia8.SusyLesHouches_listHeader(self)

    def listFooter(self):
        return _pythia8.SusyLesHouches_listFooter(self)

    def listSpectrum(self, ifail=0):
        return _pythia8.SusyLesHouches_listSpectrum(self, ifail)

    def checkSpectrum(self):
        """
print Header
print Footer
print Spectrum
Check spectrum and decays
"""
        return _pythia8.SusyLesHouches_checkSpectrum(self)
    __swig_setmethods__["slhaFile"] = _pythia8.SusyLesHouches_slhaFile_set
    __swig_getmethods__["slhaFile"] = _pythia8.SusyLesHouches_slhaFile_get
    if _newclass:
        slhaFile = _swig_property(_pythia8.SusyLesHouches_slhaFile_get, _pythia8.SusyLesHouches_slhaFile_set)
    __swig_setmethods__["modsel"] = _pythia8.SusyLesHouches_modsel_set
    __swig_getmethods__["modsel"] = _pythia8.SusyLesHouches_modsel_get
    if _newclass:
        modsel = _swig_property(_pythia8.SusyLesHouches_modsel_get, _pythia8.SusyLesHouches_modsel_set)
    __swig_setmethods__["modsel21"] = _pythia8.SusyLesHouches_modsel21_set
    __swig_getmethods__["modsel21"] = _pythia8.SusyLesHouches_modsel21_get
    if _newclass:
        modsel21 = _swig_property(_pythia8.SusyLesHouches_modsel21_get, _pythia8.SusyLesHouches_modsel21_set)
    __swig_setmethods__["modsel12"] = _pythia8.SusyLesHouches_modsel12_set
    __swig_getmethods__["modsel12"] = _pythia8.SusyLesHouches_modsel12_get
    if _newclass:
        modsel12 = _swig_property(_pythia8.SusyLesHouches_modsel12_get, _pythia8.SusyLesHouches_modsel12_set)
    __swig_setmethods__["minpar"] = _pythia8.SusyLesHouches_minpar_set
    __swig_getmethods__["minpar"] = _pythia8.SusyLesHouches_minpar_get
    if _newclass:
        minpar = _swig_property(_pythia8.SusyLesHouches_minpar_get, _pythia8.SusyLesHouches_minpar_set)
    __swig_setmethods__["extpar"] = _pythia8.SusyLesHouches_extpar_set
    __swig_getmethods__["extpar"] = _pythia8.SusyLesHouches_extpar_get
    if _newclass:
        extpar = _swig_property(_pythia8.SusyLesHouches_extpar_get, _pythia8.SusyLesHouches_extpar_set)
    __swig_setmethods__["sminputs"] = _pythia8.SusyLesHouches_sminputs_set
    __swig_getmethods__["sminputs"] = _pythia8.SusyLesHouches_sminputs_get
    if _newclass:
        sminputs = _swig_property(_pythia8.SusyLesHouches_sminputs_get, _pythia8.SusyLesHouches_sminputs_set)
    __swig_setmethods__["spinfo"] = _pythia8.SusyLesHouches_spinfo_set
    __swig_getmethods__["spinfo"] = _pythia8.SusyLesHouches_spinfo_get
    if _newclass:
        spinfo = _swig_property(_pythia8.SusyLesHouches_spinfo_get, _pythia8.SusyLesHouches_spinfo_set)
    __swig_setmethods__["spinfo3"] = _pythia8.SusyLesHouches_spinfo3_set
    __swig_getmethods__["spinfo3"] = _pythia8.SusyLesHouches_spinfo3_get
    if _newclass:
        spinfo3 = _swig_property(_pythia8.SusyLesHouches_spinfo3_get, _pythia8.SusyLesHouches_spinfo3_set)
    __swig_setmethods__["spinfo4"] = _pythia8.SusyLesHouches_spinfo4_set
    __swig_getmethods__["spinfo4"] = _pythia8.SusyLesHouches_spinfo4_get
    if _newclass:
        spinfo4 = _swig_property(_pythia8.SusyLesHouches_spinfo4_get, _pythia8.SusyLesHouches_spinfo4_set)
    __swig_setmethods__["dcinfo"] = _pythia8.SusyLesHouches_dcinfo_set
    __swig_getmethods__["dcinfo"] = _pythia8.SusyLesHouches_dcinfo_get
    if _newclass:
        dcinfo = _swig_property(_pythia8.SusyLesHouches_dcinfo_get, _pythia8.SusyLesHouches_dcinfo_set)
    __swig_setmethods__["dcinfo3"] = _pythia8.SusyLesHouches_dcinfo3_set
    __swig_getmethods__["dcinfo3"] = _pythia8.SusyLesHouches_dcinfo3_get
    if _newclass:
        dcinfo3 = _swig_property(_pythia8.SusyLesHouches_dcinfo3_get, _pythia8.SusyLesHouches_dcinfo3_set)
    __swig_setmethods__["dcinfo4"] = _pythia8.SusyLesHouches_dcinfo4_set
    __swig_getmethods__["dcinfo4"] = _pythia8.SusyLesHouches_dcinfo4_get
    if _newclass:
        dcinfo4 = _swig_property(_pythia8.SusyLesHouches_dcinfo4_get, _pythia8.SusyLesHouches_dcinfo4_set)
    __swig_setmethods__["mass"] = _pythia8.SusyLesHouches_mass_set
    __swig_getmethods__["mass"] = _pythia8.SusyLesHouches_mass_get
    if _newclass:
        mass = _swig_property(_pythia8.SusyLesHouches_mass_get, _pythia8.SusyLesHouches_mass_set)
    __swig_setmethods__["nmix"] = _pythia8.SusyLesHouches_nmix_set
    __swig_getmethods__["nmix"] = _pythia8.SusyLesHouches_nmix_get
    if _newclass:
        nmix = _swig_property(_pythia8.SusyLesHouches_nmix_get, _pythia8.SusyLesHouches_nmix_set)
    __swig_setmethods__["umix"] = _pythia8.SusyLesHouches_umix_set
    __swig_getmethods__["umix"] = _pythia8.SusyLesHouches_umix_get
    if _newclass:
        umix = _swig_property(_pythia8.SusyLesHouches_umix_get, _pythia8.SusyLesHouches_umix_set)
    __swig_setmethods__["vmix"] = _pythia8.SusyLesHouches_vmix_set
    __swig_getmethods__["vmix"] = _pythia8.SusyLesHouches_vmix_get
    if _newclass:
        vmix = _swig_property(_pythia8.SusyLesHouches_vmix_get, _pythia8.SusyLesHouches_vmix_set)
    __swig_setmethods__["stopmix"] = _pythia8.SusyLesHouches_stopmix_set
    __swig_getmethods__["stopmix"] = _pythia8.SusyLesHouches_stopmix_get
    if _newclass:
        stopmix = _swig_property(_pythia8.SusyLesHouches_stopmix_get, _pythia8.SusyLesHouches_stopmix_set)
    __swig_setmethods__["sbotmix"] = _pythia8.SusyLesHouches_sbotmix_set
    __swig_getmethods__["sbotmix"] = _pythia8.SusyLesHouches_sbotmix_get
    if _newclass:
        sbotmix = _swig_property(_pythia8.SusyLesHouches_sbotmix_get, _pythia8.SusyLesHouches_sbotmix_set)
    __swig_setmethods__["staumix"] = _pythia8.SusyLesHouches_staumix_set
    __swig_getmethods__["staumix"] = _pythia8.SusyLesHouches_staumix_get
    if _newclass:
        staumix = _swig_property(_pythia8.SusyLesHouches_staumix_get, _pythia8.SusyLesHouches_staumix_set)
    __swig_setmethods__["alpha"] = _pythia8.SusyLesHouches_alpha_set
    __swig_getmethods__["alpha"] = _pythia8.SusyLesHouches_alpha_get
    if _newclass:
        alpha = _swig_property(_pythia8.SusyLesHouches_alpha_get, _pythia8.SusyLesHouches_alpha_set)
    __swig_setmethods__["hmix"] = _pythia8.SusyLesHouches_hmix_set
    __swig_getmethods__["hmix"] = _pythia8.SusyLesHouches_hmix_get
    if _newclass:
        hmix = _swig_property(_pythia8.SusyLesHouches_hmix_get, _pythia8.SusyLesHouches_hmix_set)
    __swig_setmethods__["gauge"] = _pythia8.SusyLesHouches_gauge_set
    __swig_getmethods__["gauge"] = _pythia8.SusyLesHouches_gauge_get
    if _newclass:
        gauge = _swig_property(_pythia8.SusyLesHouches_gauge_get, _pythia8.SusyLesHouches_gauge_set)
    __swig_setmethods__["msoft"] = _pythia8.SusyLesHouches_msoft_set
    __swig_getmethods__["msoft"] = _pythia8.SusyLesHouches_msoft_get
    if _newclass:
        msoft = _swig_property(_pythia8.SusyLesHouches_msoft_get, _pythia8.SusyLesHouches_msoft_set)
    __swig_setmethods__["au"] = _pythia8.SusyLesHouches_au_set
    __swig_getmethods__["au"] = _pythia8.SusyLesHouches_au_get
    if _newclass:
        au = _swig_property(_pythia8.SusyLesHouches_au_get, _pythia8.SusyLesHouches_au_set)
    __swig_setmethods__["ad"] = _pythia8.SusyLesHouches_ad_set
    __swig_getmethods__["ad"] = _pythia8.SusyLesHouches_ad_get
    if _newclass:
        ad = _swig_property(_pythia8.SusyLesHouches_ad_get, _pythia8.SusyLesHouches_ad_set)
    __swig_setmethods__["ae"] = _pythia8.SusyLesHouches_ae_set
    __swig_getmethods__["ae"] = _pythia8.SusyLesHouches_ae_get
    if _newclass:
        ae = _swig_property(_pythia8.SusyLesHouches_ae_get, _pythia8.SusyLesHouches_ae_set)
    __swig_setmethods__["yu"] = _pythia8.SusyLesHouches_yu_set
    __swig_getmethods__["yu"] = _pythia8.SusyLesHouches_yu_get
    if _newclass:
        yu = _swig_property(_pythia8.SusyLesHouches_yu_get, _pythia8.SusyLesHouches_yu_set)
    __swig_setmethods__["yd"] = _pythia8.SusyLesHouches_yd_set
    __swig_getmethods__["yd"] = _pythia8.SusyLesHouches_yd_get
    if _newclass:
        yd = _swig_property(_pythia8.SusyLesHouches_yd_get, _pythia8.SusyLesHouches_yd_set)
    __swig_setmethods__["ye"] = _pythia8.SusyLesHouches_ye_set
    __swig_getmethods__["ye"] = _pythia8.SusyLesHouches_ye_get
    if _newclass:
        ye = _swig_property(_pythia8.SusyLesHouches_ye_get, _pythia8.SusyLesHouches_ye_set)
    __swig_setmethods__["decays"] = _pythia8.SusyLesHouches_decays_set
    __swig_getmethods__["decays"] = _pythia8.SusyLesHouches_decays_get
    if _newclass:
        decays = _swig_property(_pythia8.SusyLesHouches_decays_get, _pythia8.SusyLesHouches_decays_set)
    __swig_setmethods__["decayIndices"] = _pythia8.SusyLesHouches_decayIndices_set
    __swig_getmethods__["decayIndices"] = _pythia8.SusyLesHouches_decayIndices_get
    if _newclass:
        decayIndices = _swig_property(_pythia8.SusyLesHouches_decayIndices_get, _pythia8.SusyLesHouches_decayIndices_set)
    __swig_setmethods__["qnumbers"] = _pythia8.SusyLesHouches_qnumbers_set
    __swig_getmethods__["qnumbers"] = _pythia8.SusyLesHouches_qnumbers_get
    if _newclass:
        qnumbers = _swig_property(_pythia8.SusyLesHouches_qnumbers_get, _pythia8.SusyLesHouches_qnumbers_set)
    __swig_setmethods__["qnumbersName"] = _pythia8.SusyLesHouches_qnumbersName_set
    __swig_getmethods__["qnumbersName"] = _pythia8.SusyLesHouches_qnumbersName_get
    if _newclass:
        qnumbersName = _swig_property(_pythia8.SusyLesHouches_qnumbersName_get, _pythia8.SusyLesHouches_qnumbersName_set)
    __swig_setmethods__["qnumbersAntiName"] = _pythia8.SusyLesHouches_qnumbersAntiName_set
    __swig_getmethods__["qnumbersAntiName"] = _pythia8.SusyLesHouches_qnumbersAntiName_get
    if _newclass:
        qnumbersAntiName = _swig_property(_pythia8.SusyLesHouches_qnumbersAntiName_get, _pythia8.SusyLesHouches_qnumbersAntiName_set)
    __swig_setmethods__["qextpar"] = _pythia8.SusyLesHouches_qextpar_set
    __swig_getmethods__["qextpar"] = _pythia8.SusyLesHouches_qextpar_get
    if _newclass:
        qextpar = _swig_property(_pythia8.SusyLesHouches_qextpar_get, _pythia8.SusyLesHouches_qextpar_set)
    __swig_setmethods__["vckmin"] = _pythia8.SusyLesHouches_vckmin_set
    __swig_getmethods__["vckmin"] = _pythia8.SusyLesHouches_vckmin_get
    if _newclass:
        vckmin = _swig_property(_pythia8.SusyLesHouches_vckmin_get, _pythia8.SusyLesHouches_vckmin_set)
    __swig_setmethods__["upmnsin"] = _pythia8.SusyLesHouches_upmnsin_set
    __swig_getmethods__["upmnsin"] = _pythia8.SusyLesHouches_upmnsin_get
    if _newclass:
        upmnsin = _swig_property(_pythia8.SusyLesHouches_upmnsin_get, _pythia8.SusyLesHouches_upmnsin_set)
    __swig_setmethods__["msq2in"] = _pythia8.SusyLesHouches_msq2in_set
    __swig_getmethods__["msq2in"] = _pythia8.SusyLesHouches_msq2in_get
    if _newclass:
        msq2in = _swig_property(_pythia8.SusyLesHouches_msq2in_get, _pythia8.SusyLesHouches_msq2in_set)
    __swig_setmethods__["msu2in"] = _pythia8.SusyLesHouches_msu2in_set
    __swig_getmethods__["msu2in"] = _pythia8.SusyLesHouches_msu2in_get
    if _newclass:
        msu2in = _swig_property(_pythia8.SusyLesHouches_msu2in_get, _pythia8.SusyLesHouches_msu2in_set)
    __swig_setmethods__["msd2in"] = _pythia8.SusyLesHouches_msd2in_set
    __swig_getmethods__["msd2in"] = _pythia8.SusyLesHouches_msd2in_get
    if _newclass:
        msd2in = _swig_property(_pythia8.SusyLesHouches_msd2in_get, _pythia8.SusyLesHouches_msd2in_set)
    __swig_setmethods__["msl2in"] = _pythia8.SusyLesHouches_msl2in_set
    __swig_getmethods__["msl2in"] = _pythia8.SusyLesHouches_msl2in_get
    if _newclass:
        msl2in = _swig_property(_pythia8.SusyLesHouches_msl2in_get, _pythia8.SusyLesHouches_msl2in_set)
    __swig_setmethods__["mse2in"] = _pythia8.SusyLesHouches_mse2in_set
    __swig_getmethods__["mse2in"] = _pythia8.SusyLesHouches_mse2in_get
    if _newclass:
        mse2in = _swig_property(_pythia8.SusyLesHouches_mse2in_get, _pythia8.SusyLesHouches_mse2in_set)
    __swig_setmethods__["tuin"] = _pythia8.SusyLesHouches_tuin_set
    __swig_getmethods__["tuin"] = _pythia8.SusyLesHouches_tuin_get
    if _newclass:
        tuin = _swig_property(_pythia8.SusyLesHouches_tuin_get, _pythia8.SusyLesHouches_tuin_set)
    __swig_setmethods__["tdin"] = _pythia8.SusyLesHouches_tdin_set
    __swig_getmethods__["tdin"] = _pythia8.SusyLesHouches_tdin_get
    if _newclass:
        tdin = _swig_property(_pythia8.SusyLesHouches_tdin_get, _pythia8.SusyLesHouches_tdin_set)
    __swig_setmethods__["tein"] = _pythia8.SusyLesHouches_tein_set
    __swig_getmethods__["tein"] = _pythia8.SusyLesHouches_tein_get
    if _newclass:
        tein = _swig_property(_pythia8.SusyLesHouches_tein_get, _pythia8.SusyLesHouches_tein_set)
    __swig_setmethods__["vckm"] = _pythia8.SusyLesHouches_vckm_set
    __swig_getmethods__["vckm"] = _pythia8.SusyLesHouches_vckm_get
    if _newclass:
        vckm = _swig_property(_pythia8.SusyLesHouches_vckm_get, _pythia8.SusyLesHouches_vckm_set)
    __swig_setmethods__["upmns"] = _pythia8.SusyLesHouches_upmns_set
    __swig_getmethods__["upmns"] = _pythia8.SusyLesHouches_upmns_get
    if _newclass:
        upmns = _swig_property(_pythia8.SusyLesHouches_upmns_get, _pythia8.SusyLesHouches_upmns_set)
    __swig_setmethods__["msq2"] = _pythia8.SusyLesHouches_msq2_set
    __swig_getmethods__["msq2"] = _pythia8.SusyLesHouches_msq2_get
    if _newclass:
        msq2 = _swig_property(_pythia8.SusyLesHouches_msq2_get, _pythia8.SusyLesHouches_msq2_set)
    __swig_setmethods__["msu2"] = _pythia8.SusyLesHouches_msu2_set
    __swig_getmethods__["msu2"] = _pythia8.SusyLesHouches_msu2_get
    if _newclass:
        msu2 = _swig_property(_pythia8.SusyLesHouches_msu2_get, _pythia8.SusyLesHouches_msu2_set)
    __swig_setmethods__["msd2"] = _pythia8.SusyLesHouches_msd2_set
    __swig_getmethods__["msd2"] = _pythia8.SusyLesHouches_msd2_get
    if _newclass:
        msd2 = _swig_property(_pythia8.SusyLesHouches_msd2_get, _pythia8.SusyLesHouches_msd2_set)
    __swig_setmethods__["msl2"] = _pythia8.SusyLesHouches_msl2_set
    __swig_getmethods__["msl2"] = _pythia8.SusyLesHouches_msl2_get
    if _newclass:
        msl2 = _swig_property(_pythia8.SusyLesHouches_msl2_get, _pythia8.SusyLesHouches_msl2_set)
    __swig_setmethods__["mse2"] = _pythia8.SusyLesHouches_mse2_set
    __swig_getmethods__["mse2"] = _pythia8.SusyLesHouches_mse2_get
    if _newclass:
        mse2 = _swig_property(_pythia8.SusyLesHouches_mse2_get, _pythia8.SusyLesHouches_mse2_set)
    __swig_setmethods__["tu"] = _pythia8.SusyLesHouches_tu_set
    __swig_getmethods__["tu"] = _pythia8.SusyLesHouches_tu_get
    if _newclass:
        tu = _swig_property(_pythia8.SusyLesHouches_tu_get, _pythia8.SusyLesHouches_tu_set)
    __swig_setmethods__["td"] = _pythia8.SusyLesHouches_td_set
    __swig_getmethods__["td"] = _pythia8.SusyLesHouches_td_get
    if _newclass:
        td = _swig_property(_pythia8.SusyLesHouches_td_get, _pythia8.SusyLesHouches_td_set)
    __swig_setmethods__["te"] = _pythia8.SusyLesHouches_te_set
    __swig_getmethods__["te"] = _pythia8.SusyLesHouches_te_get
    if _newclass:
        te = _swig_property(_pythia8.SusyLesHouches_te_get, _pythia8.SusyLesHouches_te_set)
    __swig_setmethods__["usqmix"] = _pythia8.SusyLesHouches_usqmix_set
    __swig_getmethods__["usqmix"] = _pythia8.SusyLesHouches_usqmix_get
    if _newclass:
        usqmix = _swig_property(_pythia8.SusyLesHouches_usqmix_get, _pythia8.SusyLesHouches_usqmix_set)
    __swig_setmethods__["dsqmix"] = _pythia8.SusyLesHouches_dsqmix_set
    __swig_getmethods__["dsqmix"] = _pythia8.SusyLesHouches_dsqmix_get
    if _newclass:
        dsqmix = _swig_property(_pythia8.SusyLesHouches_dsqmix_get, _pythia8.SusyLesHouches_dsqmix_set)
    __swig_setmethods__["selmix"] = _pythia8.SusyLesHouches_selmix_set
    __swig_getmethods__["selmix"] = _pythia8.SusyLesHouches_selmix_get
    if _newclass:
        selmix = _swig_property(_pythia8.SusyLesHouches_selmix_get, _pythia8.SusyLesHouches_selmix_set)
    __swig_setmethods__["snumix"] = _pythia8.SusyLesHouches_snumix_set
    __swig_getmethods__["snumix"] = _pythia8.SusyLesHouches_snumix_get
    if _newclass:
        snumix = _swig_property(_pythia8.SusyLesHouches_snumix_get, _pythia8.SusyLesHouches_snumix_set)
    __swig_setmethods__["snsmix"] = _pythia8.SusyLesHouches_snsmix_set
    __swig_getmethods__["snsmix"] = _pythia8.SusyLesHouches_snsmix_get
    if _newclass:
        snsmix = _swig_property(_pythia8.SusyLesHouches_snsmix_get, _pythia8.SusyLesHouches_snsmix_set)
    __swig_setmethods__["snamix"] = _pythia8.SusyLesHouches_snamix_set
    __swig_getmethods__["snamix"] = _pythia8.SusyLesHouches_snamix_get
    if _newclass:
        snamix = _swig_property(_pythia8.SusyLesHouches_snamix_get, _pythia8.SusyLesHouches_snamix_set)
    __swig_setmethods__["rvlamllein"] = _pythia8.SusyLesHouches_rvlamllein_set
    __swig_getmethods__["rvlamllein"] = _pythia8.SusyLesHouches_rvlamllein_get
    if _newclass:
        rvlamllein = _swig_property(_pythia8.SusyLesHouches_rvlamllein_get, _pythia8.SusyLesHouches_rvlamllein_set)
    __swig_setmethods__["rvlamlqdin"] = _pythia8.SusyLesHouches_rvlamlqdin_set
    __swig_getmethods__["rvlamlqdin"] = _pythia8.SusyLesHouches_rvlamlqdin_get
    if _newclass:
        rvlamlqdin = _swig_property(_pythia8.SusyLesHouches_rvlamlqdin_get, _pythia8.SusyLesHouches_rvlamlqdin_set)
    __swig_setmethods__["rvlamuddin"] = _pythia8.SusyLesHouches_rvlamuddin_set
    __swig_getmethods__["rvlamuddin"] = _pythia8.SusyLesHouches_rvlamuddin_get
    if _newclass:
        rvlamuddin = _swig_property(_pythia8.SusyLesHouches_rvlamuddin_get, _pythia8.SusyLesHouches_rvlamuddin_set)
    __swig_setmethods__["rvtllein"] = _pythia8.SusyLesHouches_rvtllein_set
    __swig_getmethods__["rvtllein"] = _pythia8.SusyLesHouches_rvtllein_get
    if _newclass:
        rvtllein = _swig_property(_pythia8.SusyLesHouches_rvtllein_get, _pythia8.SusyLesHouches_rvtllein_set)
    __swig_setmethods__["rvtlqdin"] = _pythia8.SusyLesHouches_rvtlqdin_set
    __swig_getmethods__["rvtlqdin"] = _pythia8.SusyLesHouches_rvtlqdin_get
    if _newclass:
        rvtlqdin = _swig_property(_pythia8.SusyLesHouches_rvtlqdin_get, _pythia8.SusyLesHouches_rvtlqdin_set)
    __swig_setmethods__["rvtuddin"] = _pythia8.SusyLesHouches_rvtuddin_set
    __swig_getmethods__["rvtuddin"] = _pythia8.SusyLesHouches_rvtuddin_get
    if _newclass:
        rvtuddin = _swig_property(_pythia8.SusyLesHouches_rvtuddin_get, _pythia8.SusyLesHouches_rvtuddin_set)
    __swig_setmethods__["rvkappain"] = _pythia8.SusyLesHouches_rvkappain_set
    __swig_getmethods__["rvkappain"] = _pythia8.SusyLesHouches_rvkappain_get
    if _newclass:
        rvkappain = _swig_property(_pythia8.SusyLesHouches_rvkappain_get, _pythia8.SusyLesHouches_rvkappain_set)
    __swig_setmethods__["rvdin"] = _pythia8.SusyLesHouches_rvdin_set
    __swig_getmethods__["rvdin"] = _pythia8.SusyLesHouches_rvdin_get
    if _newclass:
        rvdin = _swig_property(_pythia8.SusyLesHouches_rvdin_get, _pythia8.SusyLesHouches_rvdin_set)
    __swig_setmethods__["rvm2lh1in"] = _pythia8.SusyLesHouches_rvm2lh1in_set
    __swig_getmethods__["rvm2lh1in"] = _pythia8.SusyLesHouches_rvm2lh1in_get
    if _newclass:
        rvm2lh1in = _swig_property(_pythia8.SusyLesHouches_rvm2lh1in_get, _pythia8.SusyLesHouches_rvm2lh1in_set)
    __swig_setmethods__["rvsnvevin"] = _pythia8.SusyLesHouches_rvsnvevin_set
    __swig_getmethods__["rvsnvevin"] = _pythia8.SusyLesHouches_rvsnvevin_get
    if _newclass:
        rvsnvevin = _swig_property(_pythia8.SusyLesHouches_rvsnvevin_get, _pythia8.SusyLesHouches_rvsnvevin_set)
    __swig_setmethods__["rvlamlle"] = _pythia8.SusyLesHouches_rvlamlle_set
    __swig_getmethods__["rvlamlle"] = _pythia8.SusyLesHouches_rvlamlle_get
    if _newclass:
        rvlamlle = _swig_property(_pythia8.SusyLesHouches_rvlamlle_get, _pythia8.SusyLesHouches_rvlamlle_set)
    __swig_setmethods__["rvlamlqd"] = _pythia8.SusyLesHouches_rvlamlqd_set
    __swig_getmethods__["rvlamlqd"] = _pythia8.SusyLesHouches_rvlamlqd_get
    if _newclass:
        rvlamlqd = _swig_property(_pythia8.SusyLesHouches_rvlamlqd_get, _pythia8.SusyLesHouches_rvlamlqd_set)
    __swig_setmethods__["rvlamudd"] = _pythia8.SusyLesHouches_rvlamudd_set
    __swig_getmethods__["rvlamudd"] = _pythia8.SusyLesHouches_rvlamudd_get
    if _newclass:
        rvlamudd = _swig_property(_pythia8.SusyLesHouches_rvlamudd_get, _pythia8.SusyLesHouches_rvlamudd_set)
    __swig_setmethods__["rvtlle"] = _pythia8.SusyLesHouches_rvtlle_set
    __swig_getmethods__["rvtlle"] = _pythia8.SusyLesHouches_rvtlle_get
    if _newclass:
        rvtlle = _swig_property(_pythia8.SusyLesHouches_rvtlle_get, _pythia8.SusyLesHouches_rvtlle_set)
    __swig_setmethods__["rvtlqd"] = _pythia8.SusyLesHouches_rvtlqd_set
    __swig_getmethods__["rvtlqd"] = _pythia8.SusyLesHouches_rvtlqd_get
    if _newclass:
        rvtlqd = _swig_property(_pythia8.SusyLesHouches_rvtlqd_get, _pythia8.SusyLesHouches_rvtlqd_set)
    __swig_setmethods__["rvtudd"] = _pythia8.SusyLesHouches_rvtudd_set
    __swig_getmethods__["rvtudd"] = _pythia8.SusyLesHouches_rvtudd_get
    if _newclass:
        rvtudd = _swig_property(_pythia8.SusyLesHouches_rvtudd_get, _pythia8.SusyLesHouches_rvtudd_set)
    __swig_setmethods__["rvkappa"] = _pythia8.SusyLesHouches_rvkappa_set
    __swig_getmethods__["rvkappa"] = _pythia8.SusyLesHouches_rvkappa_get
    if _newclass:
        rvkappa = _swig_property(_pythia8.SusyLesHouches_rvkappa_get, _pythia8.SusyLesHouches_rvkappa_set)
    __swig_setmethods__["rvd"] = _pythia8.SusyLesHouches_rvd_set
    __swig_getmethods__["rvd"] = _pythia8.SusyLesHouches_rvd_get
    if _newclass:
        rvd = _swig_property(_pythia8.SusyLesHouches_rvd_get, _pythia8.SusyLesHouches_rvd_set)
    __swig_setmethods__["rvm2lh1"] = _pythia8.SusyLesHouches_rvm2lh1_set
    __swig_getmethods__["rvm2lh1"] = _pythia8.SusyLesHouches_rvm2lh1_get
    if _newclass:
        rvm2lh1 = _swig_property(_pythia8.SusyLesHouches_rvm2lh1_get, _pythia8.SusyLesHouches_rvm2lh1_set)
    __swig_setmethods__["rvsnvev"] = _pythia8.SusyLesHouches_rvsnvev_set
    __swig_getmethods__["rvsnvev"] = _pythia8.SusyLesHouches_rvsnvev_get
    if _newclass:
        rvsnvev = _swig_property(_pythia8.SusyLesHouches_rvsnvev_get, _pythia8.SusyLesHouches_rvsnvev_set)
    __swig_setmethods__["rvnmix"] = _pythia8.SusyLesHouches_rvnmix_set
    __swig_getmethods__["rvnmix"] = _pythia8.SusyLesHouches_rvnmix_get
    if _newclass:
        rvnmix = _swig_property(_pythia8.SusyLesHouches_rvnmix_get, _pythia8.SusyLesHouches_rvnmix_set)
    __swig_setmethods__["rvumix"] = _pythia8.SusyLesHouches_rvumix_set
    __swig_getmethods__["rvumix"] = _pythia8.SusyLesHouches_rvumix_get
    if _newclass:
        rvumix = _swig_property(_pythia8.SusyLesHouches_rvumix_get, _pythia8.SusyLesHouches_rvumix_set)
    __swig_setmethods__["rvvmix"] = _pythia8.SusyLesHouches_rvvmix_set
    __swig_getmethods__["rvvmix"] = _pythia8.SusyLesHouches_rvvmix_get
    if _newclass:
        rvvmix = _swig_property(_pythia8.SusyLesHouches_rvvmix_get, _pythia8.SusyLesHouches_rvvmix_set)
    __swig_setmethods__["rvhmix"] = _pythia8.SusyLesHouches_rvhmix_set
    __swig_getmethods__["rvhmix"] = _pythia8.SusyLesHouches_rvhmix_get
    if _newclass:
        rvhmix = _swig_property(_pythia8.SusyLesHouches_rvhmix_get, _pythia8.SusyLesHouches_rvhmix_set)
    __swig_setmethods__["rvamix"] = _pythia8.SusyLesHouches_rvamix_set
    __swig_getmethods__["rvamix"] = _pythia8.SusyLesHouches_rvamix_get
    if _newclass:
        rvamix = _swig_property(_pythia8.SusyLesHouches_rvamix_get, _pythia8.SusyLesHouches_rvamix_set)
    __swig_setmethods__["rvlmix"] = _pythia8.SusyLesHouches_rvlmix_set
    __swig_getmethods__["rvlmix"] = _pythia8.SusyLesHouches_rvlmix_get
    if _newclass:
        rvlmix = _swig_property(_pythia8.SusyLesHouches_rvlmix_get, _pythia8.SusyLesHouches_rvlmix_set)
    __swig_setmethods__["imminpar"] = _pythia8.SusyLesHouches_imminpar_set
    __swig_getmethods__["imminpar"] = _pythia8.SusyLesHouches_imminpar_get
    if _newclass:
        imminpar = _swig_property(_pythia8.SusyLesHouches_imminpar_get, _pythia8.SusyLesHouches_imminpar_set)
    __swig_setmethods__["imextpar"] = _pythia8.SusyLesHouches_imextpar_set
    __swig_getmethods__["imextpar"] = _pythia8.SusyLesHouches_imextpar_get
    if _newclass:
        imextpar = _swig_property(_pythia8.SusyLesHouches_imextpar_get, _pythia8.SusyLesHouches_imextpar_set)
    __swig_setmethods__["cvhmix"] = _pythia8.SusyLesHouches_cvhmix_set
    __swig_getmethods__["cvhmix"] = _pythia8.SusyLesHouches_cvhmix_get
    if _newclass:
        cvhmix = _swig_property(_pythia8.SusyLesHouches_cvhmix_get, _pythia8.SusyLesHouches_cvhmix_set)
    __swig_setmethods__["imcvhmix"] = _pythia8.SusyLesHouches_imcvhmix_set
    __swig_getmethods__["imcvhmix"] = _pythia8.SusyLesHouches_imcvhmix_get
    if _newclass:
        imcvhmix = _swig_property(_pythia8.SusyLesHouches_imcvhmix_get, _pythia8.SusyLesHouches_imcvhmix_set)
    __swig_setmethods__["imau"] = _pythia8.SusyLesHouches_imau_set
    __swig_getmethods__["imau"] = _pythia8.SusyLesHouches_imau_get
    if _newclass:
        imau = _swig_property(_pythia8.SusyLesHouches_imau_get, _pythia8.SusyLesHouches_imau_set)
    __swig_setmethods__["imad"] = _pythia8.SusyLesHouches_imad_set
    __swig_getmethods__["imad"] = _pythia8.SusyLesHouches_imad_get
    if _newclass:
        imad = _swig_property(_pythia8.SusyLesHouches_imad_get, _pythia8.SusyLesHouches_imad_set)
    __swig_setmethods__["imae"] = _pythia8.SusyLesHouches_imae_set
    __swig_getmethods__["imae"] = _pythia8.SusyLesHouches_imae_get
    if _newclass:
        imae = _swig_property(_pythia8.SusyLesHouches_imae_get, _pythia8.SusyLesHouches_imae_set)
    __swig_setmethods__["imhmix"] = _pythia8.SusyLesHouches_imhmix_set
    __swig_getmethods__["imhmix"] = _pythia8.SusyLesHouches_imhmix_get
    if _newclass:
        imhmix = _swig_property(_pythia8.SusyLesHouches_imhmix_get, _pythia8.SusyLesHouches_imhmix_set)
    __swig_setmethods__["immsoft"] = _pythia8.SusyLesHouches_immsoft_set
    __swig_getmethods__["immsoft"] = _pythia8.SusyLesHouches_immsoft_get
    if _newclass:
        immsoft = _swig_property(_pythia8.SusyLesHouches_immsoft_get, _pythia8.SusyLesHouches_immsoft_set)
    __swig_setmethods__["immsq2in"] = _pythia8.SusyLesHouches_immsq2in_set
    __swig_getmethods__["immsq2in"] = _pythia8.SusyLesHouches_immsq2in_get
    if _newclass:
        immsq2in = _swig_property(_pythia8.SusyLesHouches_immsq2in_get, _pythia8.SusyLesHouches_immsq2in_set)
    __swig_setmethods__["immsu2in"] = _pythia8.SusyLesHouches_immsu2in_set
    __swig_getmethods__["immsu2in"] = _pythia8.SusyLesHouches_immsu2in_get
    if _newclass:
        immsu2in = _swig_property(_pythia8.SusyLesHouches_immsu2in_get, _pythia8.SusyLesHouches_immsu2in_set)
    __swig_setmethods__["immsd2in"] = _pythia8.SusyLesHouches_immsd2in_set
    __swig_getmethods__["immsd2in"] = _pythia8.SusyLesHouches_immsd2in_get
    if _newclass:
        immsd2in = _swig_property(_pythia8.SusyLesHouches_immsd2in_get, _pythia8.SusyLesHouches_immsd2in_set)
    __swig_setmethods__["immsl2in"] = _pythia8.SusyLesHouches_immsl2in_set
    __swig_getmethods__["immsl2in"] = _pythia8.SusyLesHouches_immsl2in_get
    if _newclass:
        immsl2in = _swig_property(_pythia8.SusyLesHouches_immsl2in_get, _pythia8.SusyLesHouches_immsl2in_set)
    __swig_setmethods__["immse2in"] = _pythia8.SusyLesHouches_immse2in_set
    __swig_getmethods__["immse2in"] = _pythia8.SusyLesHouches_immse2in_get
    if _newclass:
        immse2in = _swig_property(_pythia8.SusyLesHouches_immse2in_get, _pythia8.SusyLesHouches_immse2in_set)
    __swig_setmethods__["imtuin"] = _pythia8.SusyLesHouches_imtuin_set
    __swig_getmethods__["imtuin"] = _pythia8.SusyLesHouches_imtuin_get
    if _newclass:
        imtuin = _swig_property(_pythia8.SusyLesHouches_imtuin_get, _pythia8.SusyLesHouches_imtuin_set)
    __swig_setmethods__["imtdin"] = _pythia8.SusyLesHouches_imtdin_set
    __swig_getmethods__["imtdin"] = _pythia8.SusyLesHouches_imtdin_get
    if _newclass:
        imtdin = _swig_property(_pythia8.SusyLesHouches_imtdin_get, _pythia8.SusyLesHouches_imtdin_set)
    __swig_setmethods__["imtein"] = _pythia8.SusyLesHouches_imtein_set
    __swig_getmethods__["imtein"] = _pythia8.SusyLesHouches_imtein_get
    if _newclass:
        imtein = _swig_property(_pythia8.SusyLesHouches_imtein_get, _pythia8.SusyLesHouches_imtein_set)
    __swig_setmethods__["imvckm"] = _pythia8.SusyLesHouches_imvckm_set
    __swig_getmethods__["imvckm"] = _pythia8.SusyLesHouches_imvckm_get
    if _newclass:
        imvckm = _swig_property(_pythia8.SusyLesHouches_imvckm_get, _pythia8.SusyLesHouches_imvckm_set)
    __swig_setmethods__["imupmns"] = _pythia8.SusyLesHouches_imupmns_set
    __swig_getmethods__["imupmns"] = _pythia8.SusyLesHouches_imupmns_get
    if _newclass:
        imupmns = _swig_property(_pythia8.SusyLesHouches_imupmns_get, _pythia8.SusyLesHouches_imupmns_set)
    __swig_setmethods__["immsq2"] = _pythia8.SusyLesHouches_immsq2_set
    __swig_getmethods__["immsq2"] = _pythia8.SusyLesHouches_immsq2_get
    if _newclass:
        immsq2 = _swig_property(_pythia8.SusyLesHouches_immsq2_get, _pythia8.SusyLesHouches_immsq2_set)
    __swig_setmethods__["immsu2"] = _pythia8.SusyLesHouches_immsu2_set
    __swig_getmethods__["immsu2"] = _pythia8.SusyLesHouches_immsu2_get
    if _newclass:
        immsu2 = _swig_property(_pythia8.SusyLesHouches_immsu2_get, _pythia8.SusyLesHouches_immsu2_set)
    __swig_setmethods__["immsd2"] = _pythia8.SusyLesHouches_immsd2_set
    __swig_getmethods__["immsd2"] = _pythia8.SusyLesHouches_immsd2_get
    if _newclass:
        immsd2 = _swig_property(_pythia8.SusyLesHouches_immsd2_get, _pythia8.SusyLesHouches_immsd2_set)
    __swig_setmethods__["immsl2"] = _pythia8.SusyLesHouches_immsl2_set
    __swig_getmethods__["immsl2"] = _pythia8.SusyLesHouches_immsl2_get
    if _newclass:
        immsl2 = _swig_property(_pythia8.SusyLesHouches_immsl2_get, _pythia8.SusyLesHouches_immsl2_set)
    __swig_setmethods__["immse2"] = _pythia8.SusyLesHouches_immse2_set
    __swig_getmethods__["immse2"] = _pythia8.SusyLesHouches_immse2_get
    if _newclass:
        immse2 = _swig_property(_pythia8.SusyLesHouches_immse2_get, _pythia8.SusyLesHouches_immse2_set)
    __swig_setmethods__["imtu"] = _pythia8.SusyLesHouches_imtu_set
    __swig_getmethods__["imtu"] = _pythia8.SusyLesHouches_imtu_get
    if _newclass:
        imtu = _swig_property(_pythia8.SusyLesHouches_imtu_get, _pythia8.SusyLesHouches_imtu_set)
    __swig_setmethods__["imtd"] = _pythia8.SusyLesHouches_imtd_set
    __swig_getmethods__["imtd"] = _pythia8.SusyLesHouches_imtd_get
    if _newclass:
        imtd = _swig_property(_pythia8.SusyLesHouches_imtd_get, _pythia8.SusyLesHouches_imtd_set)
    __swig_setmethods__["imte"] = _pythia8.SusyLesHouches_imte_set
    __swig_getmethods__["imte"] = _pythia8.SusyLesHouches_imte_get
    if _newclass:
        imte = _swig_property(_pythia8.SusyLesHouches_imte_get, _pythia8.SusyLesHouches_imte_set)
    __swig_setmethods__["imusqmix"] = _pythia8.SusyLesHouches_imusqmix_set
    __swig_getmethods__["imusqmix"] = _pythia8.SusyLesHouches_imusqmix_get
    if _newclass:
        imusqmix = _swig_property(_pythia8.SusyLesHouches_imusqmix_get, _pythia8.SusyLesHouches_imusqmix_set)
    __swig_setmethods__["imdsqmix"] = _pythia8.SusyLesHouches_imdsqmix_set
    __swig_getmethods__["imdsqmix"] = _pythia8.SusyLesHouches_imdsqmix_get
    if _newclass:
        imdsqmix = _swig_property(_pythia8.SusyLesHouches_imdsqmix_get, _pythia8.SusyLesHouches_imdsqmix_set)
    __swig_setmethods__["imselmix"] = _pythia8.SusyLesHouches_imselmix_set
    __swig_getmethods__["imselmix"] = _pythia8.SusyLesHouches_imselmix_get
    if _newclass:
        imselmix = _swig_property(_pythia8.SusyLesHouches_imselmix_get, _pythia8.SusyLesHouches_imselmix_set)
    __swig_setmethods__["imsnumix"] = _pythia8.SusyLesHouches_imsnumix_set
    __swig_getmethods__["imsnumix"] = _pythia8.SusyLesHouches_imsnumix_get
    if _newclass:
        imsnumix = _swig_property(_pythia8.SusyLesHouches_imsnumix_get, _pythia8.SusyLesHouches_imsnumix_set)
    __swig_setmethods__["imnmix"] = _pythia8.SusyLesHouches_imnmix_set
    __swig_getmethods__["imnmix"] = _pythia8.SusyLesHouches_imnmix_get
    if _newclass:
        imnmix = _swig_property(_pythia8.SusyLesHouches_imnmix_get, _pythia8.SusyLesHouches_imnmix_set)
    __swig_setmethods__["imumix"] = _pythia8.SusyLesHouches_imumix_set
    __swig_getmethods__["imumix"] = _pythia8.SusyLesHouches_imumix_get
    if _newclass:
        imumix = _swig_property(_pythia8.SusyLesHouches_imumix_get, _pythia8.SusyLesHouches_imumix_set)
    __swig_setmethods__["imvmix"] = _pythia8.SusyLesHouches_imvmix_set
    __swig_getmethods__["imvmix"] = _pythia8.SusyLesHouches_imvmix_get
    if _newclass:
        imvmix = _swig_property(_pythia8.SusyLesHouches_imvmix_get, _pythia8.SusyLesHouches_imvmix_set)
    __swig_setmethods__["nmssmrun"] = _pythia8.SusyLesHouches_nmssmrun_set
    __swig_getmethods__["nmssmrun"] = _pythia8.SusyLesHouches_nmssmrun_get
    if _newclass:
        nmssmrun = _swig_property(_pythia8.SusyLesHouches_nmssmrun_get, _pythia8.SusyLesHouches_nmssmrun_set)
    __swig_setmethods__["nmhmix"] = _pythia8.SusyLesHouches_nmhmix_set
    __swig_getmethods__["nmhmix"] = _pythia8.SusyLesHouches_nmhmix_get
    if _newclass:
        nmhmix = _swig_property(_pythia8.SusyLesHouches_nmhmix_get, _pythia8.SusyLesHouches_nmhmix_set)
    __swig_setmethods__["nmamix"] = _pythia8.SusyLesHouches_nmamix_set
    __swig_getmethods__["nmamix"] = _pythia8.SusyLesHouches_nmamix_get
    if _newclass:
        nmamix = _swig_property(_pythia8.SusyLesHouches_nmamix_get, _pythia8.SusyLesHouches_nmamix_set)
    __swig_setmethods__["nmnmix"] = _pythia8.SusyLesHouches_nmnmix_set
    __swig_getmethods__["nmnmix"] = _pythia8.SusyLesHouches_nmnmix_get
    if _newclass:
        nmnmix = _swig_property(_pythia8.SusyLesHouches_nmnmix_get, _pythia8.SusyLesHouches_nmnmix_set)
    __swig_setmethods__["imnmnmix"] = _pythia8.SusyLesHouches_imnmnmix_set
    __swig_getmethods__["imnmnmix"] = _pythia8.SusyLesHouches_imnmnmix_get
    if _newclass:
        imnmnmix = _swig_property(_pythia8.SusyLesHouches_imnmnmix_get, _pythia8.SusyLesHouches_imnmnmix_set)
    __swig_setmethods__["genericBlocks"] = _pythia8.SusyLesHouches_genericBlocks_set
    __swig_getmethods__["genericBlocks"] = _pythia8.SusyLesHouches_genericBlocks_get
    if _newclass:
        genericBlocks = _swig_property(_pythia8.SusyLesHouches_genericBlocks_get, _pythia8.SusyLesHouches_genericBlocks_set)

    def verbose(self, *args):
        return _pythia8.SusyLesHouches_verbose(self, *args)

    def message(self, arg2, arg3, arg4, line=0):
        return _pythia8.SusyLesHouches_message(self, arg2, arg3, arg4, line)
    __swig_destroy__ = _pythia8.delete_SusyLesHouches
    __del__ = lambda self: None
SusyLesHouches_swigregister = _pythia8.SusyLesHouches_swigregister
SusyLesHouches_swigregister(SusyLesHouches)

class Info(_object):
    """
The Info class contains a mixed bag of information on the event
generation activity, especially on the current subprocess properties,
and on the number of errors encountered. This is used by the
generation machinery, but can also be read by the user.
Note: some methods that maybe should not be accessible to the user
are still public, to work also for user-written FSR/ISR classes.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Info, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Info, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Info()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_Info
    __del__ = lambda self: None

    def idA(self):
        """
Beam particles (in rest frame). CM energy of event.
"""
        return _pythia8.Info_idA(self)

    def idB(self):
        """
"""
        return _pythia8.Info_idB(self)

    def pzA(self):
        """
"""
        return _pythia8.Info_pzA(self)

    def pzB(self):
        """
"""
        return _pythia8.Info_pzB(self)

    def eA(self):
        """
"""
        return _pythia8.Info_eA(self)

    def eB(self):
        """
"""
        return _pythia8.Info_eB(self)

    def mA(self):
        """
"""
        return _pythia8.Info_mA(self)

    def mB(self):
        """
"""
        return _pythia8.Info_mB(self)

    def eCM(self):
        """
"""
        return _pythia8.Info_eCM(self)

    def s(self):
        """
"""
        return _pythia8.Info_s(self)

    def tooLowPTmin(self):
        """
Warnings from initialization.
"""
        return _pythia8.Info_tooLowPTmin(self)

    def name(self):
        """
Process name and code, and the number of final-state particles.
"""
        return _pythia8.Info_name(self)

    def code(self):
        """
"""
        return _pythia8.Info_code(self)

    def nFinal(self):
        """
"""
        return _pythia8.Info_nFinal(self)

    def isResolved(self):
        """
Are beam particles resolved, with pdf's? Are they diffractive?
"""
        return _pythia8.Info_isResolved(self)

    def isDiffractiveA(self):
        """
"""
        return _pythia8.Info_isDiffractiveA(self)

    def isDiffractiveB(self):
        """
"""
        return _pythia8.Info_isDiffractiveB(self)

    def isDiffractiveC(self):
        """
"""
        return _pythia8.Info_isDiffractiveC(self)

    def isNonDiffractive(self):
        """
"""
        return _pythia8.Info_isNonDiffractive(self)

    def isElastic(self):
        """
"""
        return _pythia8.Info_isElastic(self)

    def isMinBias(self):
        """
Retained for backwards compatibility.
"""
        return _pythia8.Info_isMinBias(self)

    def isLHA(self):
        """
Information for Les Houches Accord and reading files.
"""
        return _pythia8.Info_isLHA(self)

    def atEndOfFile(self):
        """
"""
        return _pythia8.Info_atEndOfFile(self)

    def hasSub(self, i=0):
        """
For nondiffractive and Les Houches Accord identify hardest subprocess.
"""
        return _pythia8.Info_hasSub(self, i)

    def nameSub(self, i=0):
        """
"""
        return _pythia8.Info_nameSub(self, i)

    def codeSub(self, i=0):
        """
"""
        return _pythia8.Info_codeSub(self, i)

    def nFinalSub(self, i=0):
        """
"""
        return _pythia8.Info_nFinalSub(self, i)

    def id1(self, i=0):
        """
Incoming parton flavours and x values.
"""
        return _pythia8.Info_id1(self, i)

    def id2(self, i=0):
        """
"""
        return _pythia8.Info_id2(self, i)

    def x1(self, i=0):
        """
"""
        return _pythia8.Info_x1(self, i)

    def x2(self, i=0):
        """
"""
        return _pythia8.Info_x2(self, i)

    def y(self, i=0):
        """
"""
        return _pythia8.Info_y(self, i)

    def tau(self, i=0):
        """
"""
        return _pythia8.Info_tau(self, i)

    def id1pdf(self, i=0):
        """
Hard process flavours, x values, parton densities, couplings, Q2 scales.
"""
        return _pythia8.Info_id1pdf(self, i)

    def id2pdf(self, i=0):
        """
"""
        return _pythia8.Info_id2pdf(self, i)

    def x1pdf(self, i=0):
        """
"""
        return _pythia8.Info_x1pdf(self, i)

    def x2pdf(self, i=0):
        """
"""
        return _pythia8.Info_x2pdf(self, i)

    def pdf1(self, i=0):
        """
"""
        return _pythia8.Info_pdf1(self, i)

    def pdf2(self, i=0):
        """
"""
        return _pythia8.Info_pdf2(self, i)

    def QFac(self, i=0):
        """
"""
        return _pythia8.Info_QFac(self, i)

    def Q2Fac(self, i=0):
        """
"""
        return _pythia8.Info_Q2Fac(self, i)

    def isValence1(self):
        """
"""
        return _pythia8.Info_isValence1(self)

    def isValence2(self):
        """
"""
        return _pythia8.Info_isValence2(self)

    def alphaS(self, i=0):
        """
"""
        return _pythia8.Info_alphaS(self, i)

    def alphaEM(self, i=0):
        """
"""
        return _pythia8.Info_alphaEM(self, i)

    def QRen(self, i=0):
        """
"""
        return _pythia8.Info_QRen(self, i)

    def Q2Ren(self, i=0):
        """
"""
        return _pythia8.Info_Q2Ren(self, i)

    def scalup(self, i=0):
        """
"""
        return _pythia8.Info_scalup(self, i)

    def xGammaA(self):
        """
Kinematics of photons from lepton beams.
"""
        return _pythia8.Info_xGammaA(self)

    def xGammaB(self):
        """
"""
        return _pythia8.Info_xGammaB(self)

    def Q2GammaA(self):
        """
"""
        return _pythia8.Info_Q2GammaA(self)

    def Q2GammaB(self):
        """
"""
        return _pythia8.Info_Q2GammaB(self)

    def eCMsub(self):
        """
"""
        return _pythia8.Info_eCMsub(self)

    def thetaScatLepA(self):
        """
"""
        return _pythia8.Info_thetaScatLepA(self)

    def thetaScatLepB(self):
        """
"""
        return _pythia8.Info_thetaScatLepB(self)

    def sHatNew(self):
        """
"""
        return _pythia8.Info_sHatNew(self)

    def photonMode(self):
        """
"""
        return _pythia8.Info_photonMode(self)

    def isVMDstateA(self):
        """
Information on VMD state inside a photon.
"""
        return _pythia8.Info_isVMDstateA(self)

    def isVMDstateB(self):
        """
"""
        return _pythia8.Info_isVMDstateB(self)

    def idVMDA(self):
        """
"""
        return _pythia8.Info_idVMDA(self)

    def idVMDB(self):
        """
"""
        return _pythia8.Info_idVMDB(self)

    def mVMDA(self):
        """
"""
        return _pythia8.Info_mVMDA(self)

    def mVMDB(self):
        """
"""
        return _pythia8.Info_mVMDB(self)

    def scaleVMDA(self):
        """
"""
        return _pythia8.Info_scaleVMDA(self)

    def scaleVMDB(self):
        """
"""
        return _pythia8.Info_scaleVMDB(self)

    def mHat(self, i=0):
        """
Mandelstam variables (notation as if subcollision).
"""
        return _pythia8.Info_mHat(self, i)

    def sHat(self, i=0):
        """
"""
        return _pythia8.Info_sHat(self, i)

    def tHat(self, i=0):
        """
"""
        return _pythia8.Info_tHat(self, i)

    def uHat(self, i=0):
        """
"""
        return _pythia8.Info_uHat(self, i)

    def pTHat(self, i=0):
        """
"""
        return _pythia8.Info_pTHat(self, i)

    def pT2Hat(self, i=0):
        """
"""
        return _pythia8.Info_pT2Hat(self, i)

    def m3Hat(self, i=0):
        """
"""
        return _pythia8.Info_m3Hat(self, i)

    def m4Hat(self, i=0):
        """
"""
        return _pythia8.Info_m4Hat(self, i)

    def thetaHat(self, i=0):
        """
"""
        return _pythia8.Info_thetaHat(self, i)

    def phiHat(self, i=0):
        """
"""
        return _pythia8.Info_phiHat(self, i)

    def weight(self, i=0):
        """
Weight of current event; normally 1, but used for Les Houches events
or when reweighting phase space selection. Conversion from mb to pb
for LHA strategy +-4. Uncertainty variations can be accessed by
providing an index >= 1 (0 = no variations). Also cumulative sum.
"""
        return _pythia8.Info_weight(self, i)

    def weightSum(self):
        """
"""
        return _pythia8.Info_weightSum(self)

    def lhaStrategy(self):
        """
"""
        return _pythia8.Info_lhaStrategy(self)

    def nWeights(self):
        """
Further access to uncertainty weights: number and labels
"""
        return _pythia8.Info_nWeights(self)

    def weightLabel(self, iWeight):
        """
"""
        return _pythia8.Info_weightLabel(self, iWeight)

    def initUncertainties(self, arg2, arg3=False):
        """
"""
        return _pythia8.Info_initUncertainties(self, arg2, arg3)

    def nVariationGroups(self):
        """
"""
        return _pythia8.Info_nVariationGroups(self)

    def getGroupName(self, iGN):
        """
"""
        return _pythia8.Info_getGroupName(self, iGN)

    def getGroupWeight(self, iGW):
        """
"""
        return _pythia8.Info_getGroupWeight(self, iGW)

    def getInitialName(self, iG):
        """
"""
        return _pythia8.Info_getInitialName(self, iG)
    __swig_setmethods__["varPDFplus"] = _pythia8.Info_varPDFplus_set
    __swig_getmethods__["varPDFplus"] = _pythia8.Info_varPDFplus_get
    if _newclass:
        varPDFplus = _swig_property(_pythia8.Info_varPDFplus_get, _pythia8.Info_varPDFplus_set)
    __swig_setmethods__["varPDFminus"] = _pythia8.Info_varPDFminus_set
    __swig_getmethods__["varPDFminus"] = _pythia8.Info_varPDFminus_get
    if _newclass:
        varPDFminus = _swig_property(_pythia8.Info_varPDFminus_get, _pythia8.Info_varPDFminus_set)
    __swig_setmethods__["varPDFmember"] = _pythia8.Info_varPDFmember_set
    __swig_getmethods__["varPDFmember"] = _pythia8.Info_varPDFmember_get
    if _newclass:
        varPDFmember = _swig_property(_pythia8.Info_varPDFmember_get, _pythia8.Info_varPDFmember_set)

    def nISR(self):
        """
Variations that must be known by TimeShower and Spaceshower
Number of times other steps have been carried out.
"""
        return _pythia8.Info_nISR(self)

    def nFSRinProc(self):
        """
"""
        return _pythia8.Info_nFSRinProc(self)

    def nFSRinRes(self):
        """
"""
        return _pythia8.Info_nFSRinRes(self)

    def pTmaxMPI(self):
        """
Maximum pT scales for MPI, ISR and FSR (in hard process).
"""
        return _pythia8.Info_pTmaxMPI(self)

    def pTmaxISR(self):
        """
"""
        return _pythia8.Info_pTmaxISR(self)

    def pTmaxFSR(self):
        """
"""
        return _pythia8.Info_pTmaxFSR(self)

    def pTnow(self):
        """
Current evolution scale (for UserHooks).
"""
        return _pythia8.Info_pTnow(self)

    def a0MPI(self):
        """
Impact parameter picture, global information
"""
        return _pythia8.Info_a0MPI(self)

    def bMPI(self):
        """
Impact parameter picture, as set by hardest interaction.
"""
        return _pythia8.Info_bMPI(self)

    def enhanceMPI(self):
        """
"""
        return _pythia8.Info_enhanceMPI(self)

    def enhanceMPIavg(self):
        """
"""
        return _pythia8.Info_enhanceMPIavg(self)

    def eMPI(self, i):
        """
"""
        return _pythia8.Info_eMPI(self, i)

    def bMPIold(self):
        """
"""
        return _pythia8.Info_bMPIold(self)

    def enhanceMPIold(self):
        """
"""
        return _pythia8.Info_enhanceMPIold(self)

    def enhanceMPIoldavg(self):
        """
"""
        return _pythia8.Info_enhanceMPIoldavg(self)

    def nMPI(self):
        """
Number of multiparton interactions, with code and pT for them.
"""
        return _pythia8.Info_nMPI(self)

    def codeMPI(self, i):
        """
"""
        return _pythia8.Info_codeMPI(self, i)

    def pTMPI(self, i):
        """
"""
        return _pythia8.Info_pTMPI(self, i)

    def iAMPI(self, i):
        """
"""
        return _pythia8.Info_iAMPI(self, i)

    def iBMPI(self, i):
        """
"""
        return _pythia8.Info_iBMPI(self, i)

    def codesHard(self):
        """
Cross section estimate, optionally process by process.
"""
        return _pythia8.Info_codesHard(self)

    def nameProc(self, i=0):
        """
"""
        return _pythia8.Info_nameProc(self, i)

    def nTried(self, i=0):
        """
"""
        return _pythia8.Info_nTried(self, i)

    def nSelected(self, i=0):
        """
"""
        return _pythia8.Info_nSelected(self, i)

    def nAccepted(self, i=0):
        """
"""
        return _pythia8.Info_nAccepted(self, i)

    def sigmaGen(self, i=0):
        """
"""
        return _pythia8.Info_sigmaGen(self, i)

    def sigmaErr(self, i=0):
        """
"""
        return _pythia8.Info_sigmaErr(self, i)

    def getCounter(self, i):
        """
Counters for number of loops in various places.
"""
        return _pythia8.Info_getCounter(self, i)

    def setCounter(self, i, value=0):
        """
Set or increase the value stored in a counter.
"""
        return _pythia8.Info_setCounter(self, i, value)

    def addCounter(self, i, value=1):
        """
"""
        return _pythia8.Info_addCounter(self, i, value)

    def errorReset(self):
        """
Reset to empty map of error messages.
"""
        return _pythia8.Info_errorReset(self)

    def errorMsg(self, *args):
        """
Print a message the first few times. Insert in database.
"""
        return _pythia8.Info_errorMsg(self, *args)

    def errorTotalNumber(self):
        """
Provide total number of errors/aborts/warnings experienced to date.
"""
        return _pythia8.Info_errorTotalNumber(self)

    def errorStatistics(self):
        """
Print statistics on errors/aborts/warnings.
"""
        return _pythia8.Info_errorStatistics(self)

    def setTooLowPTmin(self, lowPTminIn):
        """
Set initialization warning flag when too low pTmin in ISR/FSR/MPI.
"""
        return _pythia8.Info_setTooLowPTmin(self, lowPTminIn)

    def setValence(self, isVal1In, isVal2In):
        """
Set info on valence character of hard collision partons.
"""
        return _pythia8.Info_setValence(self, isVal1In, isVal2In)

    def hasHistory(self, *args):
        """
"""
        return _pythia8.Info_hasHistory(self, *args)

    def zNowISR(self, *args):
        """
"""
        return _pythia8.Info_zNowISR(self, *args)

    def pT2NowISR(self, *args):
        """
"""
        return _pythia8.Info_pT2NowISR(self, *args)

    def updateWeight(self, weightIn, i=0):
        """
Update a particular event weight, first entry by default.
"""
        return _pythia8.Info_updateWeight(self, weightIn, i)

    def getWeightCKKWL(self):
        """
Return CKKW-L weight.
"""
        return _pythia8.Info_getWeightCKKWL(self)

    def setWeightCKKWL(self, weightIn):
        """
Set CKKW-L weight.
"""
        return _pythia8.Info_setWeightCKKWL(self, weightIn)

    def mergingWeight(self):
        """
Return merging weight.
"""
        return _pythia8.Info_mergingWeight(self)

    def mergingWeightNLO(self):
        """
Return the complete NLO weight.
"""
        return _pythia8.Info_mergingWeightNLO(self)

    def getWeightFIRST(self):
        """
Return the O(\alpha_s)-term of the CKKW-L weight.
"""
        return _pythia8.Info_getWeightFIRST(self)

    def setWeightFIRST(self, weightIn):
        """
Set the O(\alpha_s)-term of the CKKW-L weight.
"""
        return _pythia8.Info_setWeightFIRST(self, weightIn)

    def header(self, key):
        """
Return an LHEF header
"""
        return _pythia8.Info_header(self, key)

    def headerKeys(self):
        """
Return a list of all header key names
"""
        return _pythia8.Info_headerKeys(self)

    def nProcessesLHEF(self):
        """
Return the number of processes in the LHEF.
"""
        return _pythia8.Info_nProcessesLHEF(self)

    def sigmaLHEF(self, iProcess):
        """
Return the cross section information read from LHEF.
"""
        return _pythia8.Info_sigmaLHEF(self, iProcess)
    __swig_setmethods__["LHEFversionSave"] = _pythia8.Info_LHEFversionSave_set
    __swig_getmethods__["LHEFversionSave"] = _pythia8.Info_LHEFversionSave_get
    if _newclass:
        LHEFversionSave = _swig_property(_pythia8.Info_LHEFversionSave_get, _pythia8.Info_LHEFversionSave_set)
    __swig_setmethods__["sigmaLHEFSave"] = _pythia8.Info_sigmaLHEFSave_set
    __swig_getmethods__["sigmaLHEFSave"] = _pythia8.Info_sigmaLHEFSave_get
    if _newclass:
        sigmaLHEFSave = _swig_property(_pythia8.Info_sigmaLHEFSave_get, _pythia8.Info_sigmaLHEFSave_set)
    __swig_setmethods__["initrwgt"] = _pythia8.Info_initrwgt_set
    __swig_getmethods__["initrwgt"] = _pythia8.Info_initrwgt_get
    if _newclass:
        initrwgt = _swig_property(_pythia8.Info_initrwgt_get, _pythia8.Info_initrwgt_set)
    __swig_setmethods__["generators"] = _pythia8.Info_generators_set
    __swig_getmethods__["generators"] = _pythia8.Info_generators_get
    if _newclass:
        generators = _swig_property(_pythia8.Info_generators_get, _pythia8.Info_generators_set)
    __swig_setmethods__["weightgroups"] = _pythia8.Info_weightgroups_set
    __swig_getmethods__["weightgroups"] = _pythia8.Info_weightgroups_get
    if _newclass:
        weightgroups = _swig_property(_pythia8.Info_weightgroups_get, _pythia8.Info_weightgroups_set)
    __swig_setmethods__["init_weights"] = _pythia8.Info_init_weights_set
    __swig_getmethods__["init_weights"] = _pythia8.Info_init_weights_get
    if _newclass:
        init_weights = _swig_property(_pythia8.Info_init_weights_get, _pythia8.Info_init_weights_set)
    __swig_setmethods__["hasOwnEventAttributes"] = _pythia8.Info_hasOwnEventAttributes_set
    __swig_getmethods__["hasOwnEventAttributes"] = _pythia8.Info_hasOwnEventAttributes_get
    if _newclass:
        hasOwnEventAttributes = _swig_property(_pythia8.Info_hasOwnEventAttributes_get, _pythia8.Info_hasOwnEventAttributes_set)
    __swig_setmethods__["eventAttributes"] = _pythia8.Info_eventAttributes_set
    __swig_getmethods__["eventAttributes"] = _pythia8.Info_eventAttributes_get
    if _newclass:
        eventAttributes = _swig_property(_pythia8.Info_eventAttributes_get, _pythia8.Info_eventAttributes_set)
    __swig_setmethods__["weights_detailed"] = _pythia8.Info_weights_detailed_set
    __swig_getmethods__["weights_detailed"] = _pythia8.Info_weights_detailed_get
    if _newclass:
        weights_detailed = _swig_property(_pythia8.Info_weights_detailed_get, _pythia8.Info_weights_detailed_set)
    __swig_setmethods__["weights_compressed"] = _pythia8.Info_weights_compressed_set
    __swig_getmethods__["weights_compressed"] = _pythia8.Info_weights_compressed_get
    if _newclass:
        weights_compressed = _swig_property(_pythia8.Info_weights_compressed_get, _pythia8.Info_weights_compressed_set)
    __swig_setmethods__["scales"] = _pythia8.Info_scales_set
    __swig_getmethods__["scales"] = _pythia8.Info_scales_get
    if _newclass:
        scales = _swig_property(_pythia8.Info_scales_get, _pythia8.Info_scales_set)
    __swig_setmethods__["weights"] = _pythia8.Info_weights_set
    __swig_getmethods__["weights"] = _pythia8.Info_weights_get
    if _newclass:
        weights = _swig_property(_pythia8.Info_weights_get, _pythia8.Info_weights_set)
    __swig_setmethods__["rwgt"] = _pythia8.Info_rwgt_set
    __swig_getmethods__["rwgt"] = _pythia8.Info_rwgt_get
    if _newclass:
        rwgt = _swig_property(_pythia8.Info_rwgt_get, _pythia8.Info_rwgt_set)
    __swig_setmethods__["eventWeightLHEF"] = _pythia8.Info_eventWeightLHEF_set
    __swig_getmethods__["eventWeightLHEF"] = _pythia8.Info_eventWeightLHEF_get
    if _newclass:
        eventWeightLHEF = _swig_property(_pythia8.Info_eventWeightLHEF_get, _pythia8.Info_eventWeightLHEF_set)

    def setLHEF3InitInfo(self, *args):
        """
"""
        return _pythia8.Info_setLHEF3InitInfo(self, *args)

    def setLHEF3EventInfo(self, *args):
        """
"""
        return _pythia8.Info_setLHEF3EventInfo(self, *args)

    def getEventAttribute(self, key, doRemoveWhitespace=False):
        """
Retrieve events tag information.
"""
        return _pythia8.Info_getEventAttribute(self, key, doRemoveWhitespace)

    def setEventAttribute(self, key, value, doOverwrite=True):
        """
Externally set event tag auxiliary information.
"""
        return _pythia8.Info_setEventAttribute(self, key, value, doOverwrite)

    def LHEFversion(self):
        """
Retrieve LHEF version
"""
        return _pythia8.Info_LHEFversion(self)

    def getInitrwgtSize(self):
        """
Retrieve initrwgt tag information.
"""
        return _pythia8.Info_getInitrwgtSize(self)

    def getGeneratorSize(self):
        """
Retrieve generator tag information.
"""
        return _pythia8.Info_getGeneratorSize(self)

    def getGeneratorValue(self, n=0):
        """
"""
        return _pythia8.Info_getGeneratorValue(self, n)

    def getGeneratorAttribute(self, n, key, doRemoveWhitespace=False):
        """
"""
        return _pythia8.Info_getGeneratorAttribute(self, n, key, doRemoveWhitespace)

    def getWeightsDetailedSize(self):
        """
Retrieve rwgt tag information.
"""
        return _pythia8.Info_getWeightsDetailedSize(self)

    def getWeightsDetailedValue(self, n):
        """
"""
        return _pythia8.Info_getWeightsDetailedValue(self, n)

    def getWeightsDetailedAttribute(self, n, key, doRemoveWhitespace=False):
        """
"""
        return _pythia8.Info_getWeightsDetailedAttribute(self, n, key, doRemoveWhitespace)

    def getWeightsCompressedSize(self):
        """
Retrieve weights tag information.
"""
        return _pythia8.Info_getWeightsCompressedSize(self)

    def getWeightsCompressedValue(self, n):
        """
"""
        return _pythia8.Info_getWeightsCompressedValue(self, n)

    def getWeightsCompressedAttribute(self, key, doRemoveWhitespace=False):
        """
"""
        return _pythia8.Info_getWeightsCompressedAttribute(self, key, doRemoveWhitespace)

    def getScalesValue(self, doRemoveWhitespace=False):
        """
Retrieve scales tag information.
"""
        return _pythia8.Info_getScalesValue(self, doRemoveWhitespace)

    def getScalesAttribute(self, key):
        """
"""
        return _pythia8.Info_getScalesAttribute(self, key)

    def getHeaderBlock(self):
        """
Retrieve complete header block and event comments
Retrieve scales tag information.
"""
        return _pythia8.Info_getHeaderBlock(self)

    def getEventComments(self):
        """
"""
        return _pythia8.Info_getEventComments(self)

    def setHeader(self, key, val):
        """
Set LHEF headers
"""
        return _pythia8.Info_setHeader(self, key, val)

    def setAbortPartonLevel(self, abortIn):
        """
Set abort in parton level.
"""
        return _pythia8.Info_setAbortPartonLevel(self, abortIn)

    def getAbortPartonLevel(self):
        """
"""
        return _pythia8.Info_getAbortPartonLevel(self)

    def hasUnresolvedBeams(self):
        """
Get information on hard diffractive events.
"""
        return _pythia8.Info_hasUnresolvedBeams(self)

    def hasPomPsystem(self):
        """
"""
        return _pythia8.Info_hasPomPsystem(self)

    def isHardDiffractive(self):
        """
"""
        return _pythia8.Info_isHardDiffractive(self)

    def isHardDiffractiveA(self):
        """
"""
        return _pythia8.Info_isHardDiffractiveA(self)

    def isHardDiffractiveB(self):
        """
"""
        return _pythia8.Info_isHardDiffractiveB(self)

    def xPomeronA(self):
        """
"""
        return _pythia8.Info_xPomeronA(self)

    def xPomeronB(self):
        """
"""
        return _pythia8.Info_xPomeronB(self)

    def tPomeronA(self):
        """
"""
        return _pythia8.Info_tPomeronA(self)

    def tPomeronB(self):
        """
"""
        return _pythia8.Info_tPomeronB(self)

    def getWeakModes(self):
        """
History information needed to setup the weak shower for 2 -> n.
"""
        return _pythia8.Info_getWeakModes(self)

    def getWeakDipoles(self):
        """
"""
        return _pythia8.Info_getWeakDipoles(self)

    def getWeakMomenta(self):
        """
"""
        return _pythia8.Info_getWeakMomenta(self)

    def getWeak2to2lines(self):
        """
"""
        return _pythia8.Info_getWeak2to2lines(self)

    def setWeakModes(self, weakModesIn):
        """
"""
        return _pythia8.Info_setWeakModes(self, weakModesIn)

    def setWeakDipoles(self, weakDipolesIn):
        """
"""
        return _pythia8.Info_setWeakDipoles(self, weakDipolesIn)

    def setWeakMomenta(self, weakMomentaIn):
        """
"""
        return _pythia8.Info_setWeakMomenta(self, weakMomentaIn)

    def setWeak2to2lines(self, weak2to2linesIn):
        """
"""
        return _pythia8.Info_setWeak2to2lines(self, weak2to2linesIn)
    __swig_setmethods__["hiinfo"] = _pythia8.Info_hiinfo_set
    __swig_getmethods__["hiinfo"] = _pythia8.Info_hiinfo_get
    if _newclass:
        hiinfo = _swig_property(_pythia8.Info_hiinfo_get, _pythia8.Info_hiinfo_set)

    def __str__(self):
        return _pythia8.Info___str__(self)
Info_swigregister = _pythia8.Info_swigregister
Info_swigregister(Info)

class Flag(_object):
    """
Class for bool flags.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Flag, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Flag, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor
"""
        this = _pythia8.new_Flag(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["name"] = _pythia8.Flag_name_set
    __swig_getmethods__["name"] = _pythia8.Flag_name_get
    if _newclass:
        name = _swig_property(_pythia8.Flag_name_get, _pythia8.Flag_name_set)
    __swig_setmethods__["valNow"] = _pythia8.Flag_valNow_set
    __swig_getmethods__["valNow"] = _pythia8.Flag_valNow_get
    if _newclass:
        valNow = _swig_property(_pythia8.Flag_valNow_get, _pythia8.Flag_valNow_set)
    __swig_setmethods__["valDefault"] = _pythia8.Flag_valDefault_set
    __swig_getmethods__["valDefault"] = _pythia8.Flag_valDefault_get
    if _newclass:
        valDefault = _swig_property(_pythia8.Flag_valDefault_get, _pythia8.Flag_valDefault_set)
    __swig_destroy__ = _pythia8.delete_Flag
    __del__ = lambda self: None
Flag_swigregister = _pythia8.Flag_swigregister
Flag_swigregister(Flag)

class Mode(_object):
    """
Class for integer modes.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Mode, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Mode, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor
"""
        this = _pythia8.new_Mode(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["name"] = _pythia8.Mode_name_set
    __swig_getmethods__["name"] = _pythia8.Mode_name_get
    if _newclass:
        name = _swig_property(_pythia8.Mode_name_get, _pythia8.Mode_name_set)
    __swig_setmethods__["valNow"] = _pythia8.Mode_valNow_set
    __swig_getmethods__["valNow"] = _pythia8.Mode_valNow_get
    if _newclass:
        valNow = _swig_property(_pythia8.Mode_valNow_get, _pythia8.Mode_valNow_set)
    __swig_setmethods__["valDefault"] = _pythia8.Mode_valDefault_set
    __swig_getmethods__["valDefault"] = _pythia8.Mode_valDefault_get
    if _newclass:
        valDefault = _swig_property(_pythia8.Mode_valDefault_get, _pythia8.Mode_valDefault_set)
    __swig_setmethods__["hasMin"] = _pythia8.Mode_hasMin_set
    __swig_getmethods__["hasMin"] = _pythia8.Mode_hasMin_get
    if _newclass:
        hasMin = _swig_property(_pythia8.Mode_hasMin_get, _pythia8.Mode_hasMin_set)
    __swig_setmethods__["hasMax"] = _pythia8.Mode_hasMax_set
    __swig_getmethods__["hasMax"] = _pythia8.Mode_hasMax_get
    if _newclass:
        hasMax = _swig_property(_pythia8.Mode_hasMax_get, _pythia8.Mode_hasMax_set)
    __swig_setmethods__["valMin"] = _pythia8.Mode_valMin_set
    __swig_getmethods__["valMin"] = _pythia8.Mode_valMin_get
    if _newclass:
        valMin = _swig_property(_pythia8.Mode_valMin_get, _pythia8.Mode_valMin_set)
    __swig_setmethods__["valMax"] = _pythia8.Mode_valMax_set
    __swig_getmethods__["valMax"] = _pythia8.Mode_valMax_get
    if _newclass:
        valMax = _swig_property(_pythia8.Mode_valMax_get, _pythia8.Mode_valMax_set)
    __swig_setmethods__["optOnly"] = _pythia8.Mode_optOnly_set
    __swig_getmethods__["optOnly"] = _pythia8.Mode_optOnly_get
    if _newclass:
        optOnly = _swig_property(_pythia8.Mode_optOnly_get, _pythia8.Mode_optOnly_set)
    __swig_destroy__ = _pythia8.delete_Mode
    __del__ = lambda self: None
Mode_swigregister = _pythia8.Mode_swigregister
Mode_swigregister(Mode)

class Parm(_object):
    """
Class for double parms (where parm is shorthand for parameter).
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Parm, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Parm, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor
"""
        this = _pythia8.new_Parm(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["name"] = _pythia8.Parm_name_set
    __swig_getmethods__["name"] = _pythia8.Parm_name_get
    if _newclass:
        name = _swig_property(_pythia8.Parm_name_get, _pythia8.Parm_name_set)
    __swig_setmethods__["valNow"] = _pythia8.Parm_valNow_set
    __swig_getmethods__["valNow"] = _pythia8.Parm_valNow_get
    if _newclass:
        valNow = _swig_property(_pythia8.Parm_valNow_get, _pythia8.Parm_valNow_set)
    __swig_setmethods__["valDefault"] = _pythia8.Parm_valDefault_set
    __swig_getmethods__["valDefault"] = _pythia8.Parm_valDefault_get
    if _newclass:
        valDefault = _swig_property(_pythia8.Parm_valDefault_get, _pythia8.Parm_valDefault_set)
    __swig_setmethods__["hasMin"] = _pythia8.Parm_hasMin_set
    __swig_getmethods__["hasMin"] = _pythia8.Parm_hasMin_get
    if _newclass:
        hasMin = _swig_property(_pythia8.Parm_hasMin_get, _pythia8.Parm_hasMin_set)
    __swig_setmethods__["hasMax"] = _pythia8.Parm_hasMax_set
    __swig_getmethods__["hasMax"] = _pythia8.Parm_hasMax_get
    if _newclass:
        hasMax = _swig_property(_pythia8.Parm_hasMax_get, _pythia8.Parm_hasMax_set)
    __swig_setmethods__["valMin"] = _pythia8.Parm_valMin_set
    __swig_getmethods__["valMin"] = _pythia8.Parm_valMin_get
    if _newclass:
        valMin = _swig_property(_pythia8.Parm_valMin_get, _pythia8.Parm_valMin_set)
    __swig_setmethods__["valMax"] = _pythia8.Parm_valMax_set
    __swig_getmethods__["valMax"] = _pythia8.Parm_valMax_get
    if _newclass:
        valMax = _swig_property(_pythia8.Parm_valMax_get, _pythia8.Parm_valMax_set)
    __swig_destroy__ = _pythia8.delete_Parm
    __del__ = lambda self: None
Parm_swigregister = _pythia8.Parm_swigregister
Parm_swigregister(Parm)

class Word(_object):
    """
Class for string words.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Word, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Word, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor
"""
        this = _pythia8.new_Word(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["name"] = _pythia8.Word_name_set
    __swig_getmethods__["name"] = _pythia8.Word_name_get
    if _newclass:
        name = _swig_property(_pythia8.Word_name_get, _pythia8.Word_name_set)
    __swig_setmethods__["valNow"] = _pythia8.Word_valNow_set
    __swig_getmethods__["valNow"] = _pythia8.Word_valNow_get
    if _newclass:
        valNow = _swig_property(_pythia8.Word_valNow_get, _pythia8.Word_valNow_set)
    __swig_setmethods__["valDefault"] = _pythia8.Word_valDefault_set
    __swig_getmethods__["valDefault"] = _pythia8.Word_valDefault_get
    if _newclass:
        valDefault = _swig_property(_pythia8.Word_valDefault_get, _pythia8.Word_valDefault_set)
    __swig_destroy__ = _pythia8.delete_Word
    __del__ = lambda self: None
Word_swigregister = _pythia8.Word_swigregister
Word_swigregister(Word)

class FVec(_object):
    """
Class for vector of bool flags.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FVec, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FVec, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor
"""
        this = _pythia8.new_FVec(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["name"] = _pythia8.FVec_name_set
    __swig_getmethods__["name"] = _pythia8.FVec_name_get
    if _newclass:
        name = _swig_property(_pythia8.FVec_name_get, _pythia8.FVec_name_set)
    __swig_setmethods__["valNow"] = _pythia8.FVec_valNow_set
    __swig_getmethods__["valNow"] = _pythia8.FVec_valNow_get
    if _newclass:
        valNow = _swig_property(_pythia8.FVec_valNow_get, _pythia8.FVec_valNow_set)
    __swig_setmethods__["valDefault"] = _pythia8.FVec_valDefault_set
    __swig_getmethods__["valDefault"] = _pythia8.FVec_valDefault_get
    if _newclass:
        valDefault = _swig_property(_pythia8.FVec_valDefault_get, _pythia8.FVec_valDefault_set)
    __swig_destroy__ = _pythia8.delete_FVec
    __del__ = lambda self: None
FVec_swigregister = _pythia8.FVec_swigregister
FVec_swigregister(FVec)

class MVec(_object):
    """
Class for vector of integers.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MVec, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MVec, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor
"""
        this = _pythia8.new_MVec(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["name"] = _pythia8.MVec_name_set
    __swig_getmethods__["name"] = _pythia8.MVec_name_get
    if _newclass:
        name = _swig_property(_pythia8.MVec_name_get, _pythia8.MVec_name_set)
    __swig_setmethods__["valNow"] = _pythia8.MVec_valNow_set
    __swig_getmethods__["valNow"] = _pythia8.MVec_valNow_get
    if _newclass:
        valNow = _swig_property(_pythia8.MVec_valNow_get, _pythia8.MVec_valNow_set)
    __swig_setmethods__["valDefault"] = _pythia8.MVec_valDefault_set
    __swig_getmethods__["valDefault"] = _pythia8.MVec_valDefault_get
    if _newclass:
        valDefault = _swig_property(_pythia8.MVec_valDefault_get, _pythia8.MVec_valDefault_set)
    __swig_setmethods__["hasMin"] = _pythia8.MVec_hasMin_set
    __swig_getmethods__["hasMin"] = _pythia8.MVec_hasMin_get
    if _newclass:
        hasMin = _swig_property(_pythia8.MVec_hasMin_get, _pythia8.MVec_hasMin_set)
    __swig_setmethods__["hasMax"] = _pythia8.MVec_hasMax_set
    __swig_getmethods__["hasMax"] = _pythia8.MVec_hasMax_get
    if _newclass:
        hasMax = _swig_property(_pythia8.MVec_hasMax_get, _pythia8.MVec_hasMax_set)
    __swig_setmethods__["valMin"] = _pythia8.MVec_valMin_set
    __swig_getmethods__["valMin"] = _pythia8.MVec_valMin_get
    if _newclass:
        valMin = _swig_property(_pythia8.MVec_valMin_get, _pythia8.MVec_valMin_set)
    __swig_setmethods__["valMax"] = _pythia8.MVec_valMax_set
    __swig_getmethods__["valMax"] = _pythia8.MVec_valMax_get
    if _newclass:
        valMax = _swig_property(_pythia8.MVec_valMax_get, _pythia8.MVec_valMax_set)
    __swig_destroy__ = _pythia8.delete_MVec
    __del__ = lambda self: None
MVec_swigregister = _pythia8.MVec_swigregister
MVec_swigregister(MVec)

class PVec(_object):
    """
Class for vector of doubles.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PVec, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PVec, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor
"""
        this = _pythia8.new_PVec(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["name"] = _pythia8.PVec_name_set
    __swig_getmethods__["name"] = _pythia8.PVec_name_get
    if _newclass:
        name = _swig_property(_pythia8.PVec_name_get, _pythia8.PVec_name_set)
    __swig_setmethods__["valNow"] = _pythia8.PVec_valNow_set
    __swig_getmethods__["valNow"] = _pythia8.PVec_valNow_get
    if _newclass:
        valNow = _swig_property(_pythia8.PVec_valNow_get, _pythia8.PVec_valNow_set)
    __swig_setmethods__["valDefault"] = _pythia8.PVec_valDefault_set
    __swig_getmethods__["valDefault"] = _pythia8.PVec_valDefault_get
    if _newclass:
        valDefault = _swig_property(_pythia8.PVec_valDefault_get, _pythia8.PVec_valDefault_set)
    __swig_setmethods__["hasMin"] = _pythia8.PVec_hasMin_set
    __swig_getmethods__["hasMin"] = _pythia8.PVec_hasMin_get
    if _newclass:
        hasMin = _swig_property(_pythia8.PVec_hasMin_get, _pythia8.PVec_hasMin_set)
    __swig_setmethods__["hasMax"] = _pythia8.PVec_hasMax_set
    __swig_getmethods__["hasMax"] = _pythia8.PVec_hasMax_get
    if _newclass:
        hasMax = _swig_property(_pythia8.PVec_hasMax_get, _pythia8.PVec_hasMax_set)
    __swig_setmethods__["valMin"] = _pythia8.PVec_valMin_set
    __swig_getmethods__["valMin"] = _pythia8.PVec_valMin_get
    if _newclass:
        valMin = _swig_property(_pythia8.PVec_valMin_get, _pythia8.PVec_valMin_set)
    __swig_setmethods__["valMax"] = _pythia8.PVec_valMax_set
    __swig_getmethods__["valMax"] = _pythia8.PVec_valMax_get
    if _newclass:
        valMax = _swig_property(_pythia8.PVec_valMax_get, _pythia8.PVec_valMax_set)
    __swig_destroy__ = _pythia8.delete_PVec
    __del__ = lambda self: None
PVec_swigregister = _pythia8.PVec_swigregister
PVec_swigregister(PVec)

class WVec(_object):
    """
Class for vector of strings.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, WVec, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, WVec, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor
"""
        this = _pythia8.new_WVec(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["name"] = _pythia8.WVec_name_set
    __swig_getmethods__["name"] = _pythia8.WVec_name_get
    if _newclass:
        name = _swig_property(_pythia8.WVec_name_get, _pythia8.WVec_name_set)
    __swig_setmethods__["valNow"] = _pythia8.WVec_valNow_set
    __swig_getmethods__["valNow"] = _pythia8.WVec_valNow_get
    if _newclass:
        valNow = _swig_property(_pythia8.WVec_valNow_get, _pythia8.WVec_valNow_set)
    __swig_setmethods__["valDefault"] = _pythia8.WVec_valDefault_set
    __swig_getmethods__["valDefault"] = _pythia8.WVec_valDefault_get
    if _newclass:
        valDefault = _swig_property(_pythia8.WVec_valDefault_get, _pythia8.WVec_valDefault_set)
    __swig_destroy__ = _pythia8.delete_WVec
    __del__ = lambda self: None
WVec_swigregister = _pythia8.WVec_swigregister
WVec_swigregister(WVec)

class Settings(_object):
    """
This class holds info on flags (bool), modes (int), parms (double),
words (string), fvecs (vector of bool), mvecs (vector of int),
pvecs (vector of double) and wvecs (vector of string).
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Settings, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Settings, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Settings()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initPtr(self, infoPtrIn):
        """
Initialize Info pointer.
"""
        return _pythia8.Settings_initPtr(self, infoPtrIn)

    def init(self, *args):
        """
Read in database from stream.
"""
        return _pythia8.Settings_init(self, *args)

    def reInit(self, *args):
        """
Overwrite existing database by reading from specific file.
"""
        return _pythia8.Settings_reInit(self, *args)

    def readString(self, line, warn=True):
        """
Read in one update from a single line.
"""
        return _pythia8.Settings_readString(self, line, warn)

    def writeFile(self, *args):
        """
"""
        return _pythia8.Settings_writeFile(self, *args)

    def writeFileXML(self, *args):
        """
"""
        return _pythia8.Settings_writeFileXML(self, *args)

    def listAll(self):
        """
Print out table of database, either all or only changed ones,
or ones containing a given string.
"""
        return _pythia8.Settings_listAll(self)

    def listChanged(self):
        """
"""
        return _pythia8.Settings_listChanged(self)

    def output(self, keyIn, fullLine=True):
        """
Give back current value(s) as a string, whatever the type.
"""
        return _pythia8.Settings_output(self, keyIn, fullLine)

    def getReadHistory(self, subrun=-999):
        """
Retrieve readString history (e.g., for inspection). Everything
(subrun=-999), up to first subrun (=-1), or subrun-specific (>=0).
"""
        return _pythia8.Settings_getReadHistory(self, subrun)

    def resetAll(self):
        """
Reset all values to their defaults.
"""
        return _pythia8.Settings_resetAll(self)

    def isFlag(self, keyIn):
        """
Query existence of an entry.
"""
        return _pythia8.Settings_isFlag(self, keyIn)

    def isMode(self, keyIn):
        """
"""
        return _pythia8.Settings_isMode(self, keyIn)

    def isParm(self, keyIn):
        """
"""
        return _pythia8.Settings_isParm(self, keyIn)

    def isWord(self, keyIn):
        """
"""
        return _pythia8.Settings_isWord(self, keyIn)

    def isFVec(self, keyIn):
        """
"""
        return _pythia8.Settings_isFVec(self, keyIn)

    def isMVec(self, keyIn):
        """
"""
        return _pythia8.Settings_isMVec(self, keyIn)

    def isPVec(self, keyIn):
        """
"""
        return _pythia8.Settings_isPVec(self, keyIn)

    def isWVec(self, keyIn):
        """
"""
        return _pythia8.Settings_isWVec(self, keyIn)

    def addFlag(self, keyIn, defaultIn):
        """
Add new entry.
"""
        return _pythia8.Settings_addFlag(self, keyIn, defaultIn)

    def addMode(self, keyIn, defaultIn, hasMinIn, hasMaxIn, minIn, maxIn, optOnlyIn=False):
        """
"""
        return _pythia8.Settings_addMode(self, keyIn, defaultIn, hasMinIn, hasMaxIn, minIn, maxIn, optOnlyIn)

    def addParm(self, keyIn, defaultIn, hasMinIn, hasMaxIn, minIn, maxIn):
        """
"""
        return _pythia8.Settings_addParm(self, keyIn, defaultIn, hasMinIn, hasMaxIn, minIn, maxIn)

    def addWord(self, keyIn, defaultIn):
        """
"""
        return _pythia8.Settings_addWord(self, keyIn, defaultIn)

    def addFVec(self, keyIn, defaultIn):
        """
"""
        return _pythia8.Settings_addFVec(self, keyIn, defaultIn)

    def addMVec(self, keyIn, defaultIn, hasMinIn, hasMaxIn, minIn, maxIn):
        """
"""
        return _pythia8.Settings_addMVec(self, keyIn, defaultIn, hasMinIn, hasMaxIn, minIn, maxIn)

    def addPVec(self, keyIn, defaultIn, hasMinIn, hasMaxIn, minIn, maxIn):
        """
"""
        return _pythia8.Settings_addPVec(self, keyIn, defaultIn, hasMinIn, hasMaxIn, minIn, maxIn)

    def addWVec(self, keyIn, defaultIn):
        """
"""
        return _pythia8.Settings_addWVec(self, keyIn, defaultIn)

    def flagDefault(self, keyIn):
        """
Give back default value, with check that key exists.
"""
        return _pythia8.Settings_flagDefault(self, keyIn)

    def modeDefault(self, keyIn):
        """
"""
        return _pythia8.Settings_modeDefault(self, keyIn)

    def parmDefault(self, keyIn):
        """
"""
        return _pythia8.Settings_parmDefault(self, keyIn)

    def wordDefault(self, keyIn):
        """
"""
        return _pythia8.Settings_wordDefault(self, keyIn)

    def fvecDefault(self, keyIn):
        """
"""
        return _pythia8.Settings_fvecDefault(self, keyIn)

    def mvecDefault(self, keyIn):
        """
"""
        return _pythia8.Settings_mvecDefault(self, keyIn)

    def pvecDefault(self, keyIn):
        """
"""
        return _pythia8.Settings_pvecDefault(self, keyIn)

    def wvecDefault(self, keyIn):
        """
"""
        return _pythia8.Settings_wvecDefault(self, keyIn)

    def getFlagMap(self, match):
        """
Give back a map of all entries whose names match the string "match".
"""
        return _pythia8.Settings_getFlagMap(self, match)

    def getModeMap(self, match):
        """
"""
        return _pythia8.Settings_getModeMap(self, match)

    def getParmMap(self, match):
        """
"""
        return _pythia8.Settings_getParmMap(self, match)

    def getWordMap(self, match):
        """
"""
        return _pythia8.Settings_getWordMap(self, match)

    def getFVecMap(self, match):
        """
"""
        return _pythia8.Settings_getFVecMap(self, match)

    def getMVecMap(self, match):
        """
"""
        return _pythia8.Settings_getMVecMap(self, match)

    def getPVecMap(self, match):
        """
"""
        return _pythia8.Settings_getPVecMap(self, match)

    def getWVecMap(self, match):
        """
"""
        return _pythia8.Settings_getWVecMap(self, match)

    def flag(self, *args):
        """
Change current value, respecting limits.
"""
        return _pythia8.Settings_flag(self, *args)

    def mode(self, *args):
        """
"""
        return _pythia8.Settings_mode(self, *args)

    def parm(self, *args):
        """
"""
        return _pythia8.Settings_parm(self, *args)

    def word(self, *args):
        """
"""
        return _pythia8.Settings_word(self, *args)

    def fvec(self, *args):
        """
"""
        return _pythia8.Settings_fvec(self, *args)

    def mvec(self, *args):
        """
"""
        return _pythia8.Settings_mvec(self, *args)

    def pvec(self, *args):
        """
"""
        return _pythia8.Settings_pvec(self, *args)

    def wvec(self, *args):
        """
"""
        return _pythia8.Settings_wvec(self, *args)

    def forceMode(self, keyIn, nowIn):
        """
Methods kept for backwards compatability with 8.223 and earlier.
(To be removed in next major release.)
"""
        return _pythia8.Settings_forceMode(self, keyIn, nowIn)

    def forceParm(self, keyIn, nowIn):
        """
"""
        return _pythia8.Settings_forceParm(self, keyIn, nowIn)

    def forceMVec(self, keyIn, nowIn):
        """
"""
        return _pythia8.Settings_forceMVec(self, keyIn, nowIn)

    def forcePVec(self, keyIn, nowIn):
        """
"""
        return _pythia8.Settings_forcePVec(self, keyIn, nowIn)

    def resetFlag(self, keyIn):
        """
Restore current value to default.
"""
        return _pythia8.Settings_resetFlag(self, keyIn)

    def resetMode(self, keyIn):
        """
"""
        return _pythia8.Settings_resetMode(self, keyIn)

    def resetParm(self, keyIn):
        """
"""
        return _pythia8.Settings_resetParm(self, keyIn)

    def resetWord(self, keyIn):
        """
"""
        return _pythia8.Settings_resetWord(self, keyIn)

    def resetFVec(self, keyIn):
        """
"""
        return _pythia8.Settings_resetFVec(self, keyIn)

    def resetMVec(self, keyIn):
        """
"""
        return _pythia8.Settings_resetMVec(self, keyIn)

    def resetPVec(self, keyIn):
        """
"""
        return _pythia8.Settings_resetPVec(self, keyIn)

    def resetWVec(self, keyIn):
        """
"""
        return _pythia8.Settings_resetWVec(self, keyIn)

    def getIsInit(self):
        """
Check initialisation status.
"""
        return _pythia8.Settings_getIsInit(self)

    def readingFailed(self):
        """
Keep track whether any readings have failed, invalidating run setup.
"""
        return _pythia8.Settings_readingFailed(self)

    def unfinishedInput(self):
        """
Check whether input openend with { not yet closed with }.
"""
        return _pythia8.Settings_unfinishedInput(self)

    def onlySoftQCD(self):
        """
Check whether any other processes than SoftQCD are switched on.
"""
        return _pythia8.Settings_onlySoftQCD(self)
    __swig_destroy__ = _pythia8.delete_Settings
    __del__ = lambda self: None
Settings_swigregister = _pythia8.Settings_swigregister
Settings_swigregister(Settings)

class AlphaStrong(_object):
    """
The AlphaStrong class calculates the alpha_strong value at an arbitrary
scale, given the value at m_Z, to zeroth, first or second order.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, AlphaStrong, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, AlphaStrong, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructors.
"""
        this = _pythia8.new_AlphaStrong()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_AlphaStrong
    __del__ = lambda self: None

    def init(self, valueIn=0.12, orderIn=1, nfmaxIn=6, useCMWIn=False):
        """
Initialization for given value at M_Z and given order.
"""
        return _pythia8.AlphaStrong_init(self, valueIn, orderIn, nfmaxIn, useCMWIn)

    def setThresholds(self, mcIn, mbIn, mtIn):
        """
Set flavour threshold values: m_c, m_b, m_t.
"""
        return _pythia8.AlphaStrong_setThresholds(self, mcIn, mbIn, mtIn)

    def alphaS(self, scale2):
        """
alpha_S value and Lambda values.
"""
        return _pythia8.AlphaStrong_alphaS(self, scale2)

    def alphaS1Ord(self, scale2):
        """
"""
        return _pythia8.AlphaStrong_alphaS1Ord(self, scale2)

    def alphaS2OrdCorr(self, scale2):
        """
"""
        return _pythia8.AlphaStrong_alphaS2OrdCorr(self, scale2)

    def Lambda3(self):
        """
"""
        return _pythia8.AlphaStrong_Lambda3(self)

    def Lambda4(self):
        """
"""
        return _pythia8.AlphaStrong_Lambda4(self)

    def Lambda5(self):
        """
"""
        return _pythia8.AlphaStrong_Lambda5(self)

    def Lambda6(self):
        """
"""
        return _pythia8.AlphaStrong_Lambda6(self)

    def muThres(self, idQ):
        """
Info: tell which scales we use for flavour thresholds.
"""
        return _pythia8.AlphaStrong_muThres(self, idQ)

    def muThres2(self, idQ):
        """
"""
        return _pythia8.AlphaStrong_muThres2(self, idQ)

    def facCMW(self, nFin):
        """
Return the CMW factor (for nF between 3 and 6).
"""
        return _pythia8.AlphaStrong_facCMW(self, nFin)
AlphaStrong_swigregister = _pythia8.AlphaStrong_swigregister
AlphaStrong_swigregister(AlphaStrong)

class AlphaEM(_object):
    """
The AlphaEM class calculates the alpha_electromagnetic value at an
arbitrary scale, given the value at 0 and m_Z, to zeroth or first order.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, AlphaEM, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, AlphaEM, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructors.
"""
        this = _pythia8.new_AlphaEM()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, orderIn, settingsPtr):
        """
Initialization for a given order.
"""
        return _pythia8.AlphaEM_init(self, orderIn, settingsPtr)

    def alphaEM(self, scale2):
        """
alpha_EM value.
"""
        return _pythia8.AlphaEM_alphaEM(self, scale2)
    __swig_destroy__ = _pythia8.delete_AlphaEM
    __del__ = lambda self: None
AlphaEM_swigregister = _pythia8.AlphaEM_swigregister
AlphaEM_swigregister(AlphaEM)

class CoupSM(_object):
    """
The CoupSM class stores and returns electroweak couplings,
including Cabibbo-Kobayashi-Maskawa mass mixing matrix elements.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CoupSM, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CoupSM, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_CoupSM()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, settings, rndmPtrIn):
        """
Initialize, normally from Pythia::init().
"""
        return _pythia8.CoupSM_init(self, settings, rndmPtrIn)

    def alphaS(self, scale2):
        """
alpha_S value and Lambda values.
"""
        return _pythia8.CoupSM_alphaS(self, scale2)

    def alphaS1Ord(self, scale2):
        """
"""
        return _pythia8.CoupSM_alphaS1Ord(self, scale2)

    def alphaS2OrdCorr(self, scale2):
        """
"""
        return _pythia8.CoupSM_alphaS2OrdCorr(self, scale2)

    def Lambda3(self):
        """
"""
        return _pythia8.CoupSM_Lambda3(self)

    def Lambda4(self):
        """
"""
        return _pythia8.CoupSM_Lambda4(self)

    def Lambda5(self):
        """
"""
        return _pythia8.CoupSM_Lambda5(self)

    def alphaEM(self, scale2):
        """
Return alpha_EM value.
"""
        return _pythia8.CoupSM_alphaEM(self, scale2)

    def sin2thetaW(self):
        """
Return electroweak mixing angle and Fermi constant.
"""
        return _pythia8.CoupSM_sin2thetaW(self)

    def cos2thetaW(self):
        """
"""
        return _pythia8.CoupSM_cos2thetaW(self)

    def sin2thetaWbar(self):
        """
"""
        return _pythia8.CoupSM_sin2thetaWbar(self)

    def GF(self):
        """
"""
        return _pythia8.CoupSM_GF(self)

    def ef(self, idAbs):
        """
Return electroweak couplings of quarks and leptons.
"""
        return _pythia8.CoupSM_ef(self, idAbs)

    def vf(self, idAbs):
        """
"""
        return _pythia8.CoupSM_vf(self, idAbs)

    def af(self, idAbs):
        """
"""
        return _pythia8.CoupSM_af(self, idAbs)

    def t3f(self, idAbs):
        """
"""
        return _pythia8.CoupSM_t3f(self, idAbs)

    def lf(self, idAbs):
        """
"""
        return _pythia8.CoupSM_lf(self, idAbs)

    def rf(self, idAbs):
        """
"""
        return _pythia8.CoupSM_rf(self, idAbs)

    def ef2(self, idAbs):
        """
Return some squared couplings and other combinations.
"""
        return _pythia8.CoupSM_ef2(self, idAbs)

    def vf2(self, idAbs):
        """
"""
        return _pythia8.CoupSM_vf2(self, idAbs)

    def af2(self, idAbs):
        """
"""
        return _pythia8.CoupSM_af2(self, idAbs)

    def efvf(self, idAbs):
        """
"""
        return _pythia8.CoupSM_efvf(self, idAbs)

    def vf2af2(self, idAbs):
        """
"""
        return _pythia8.CoupSM_vf2af2(self, idAbs)

    def VCKMgen(self, genU, genD):
        """
Return CKM value or square:
first index 1/2/3/4 = u/c/t/t', second 1/2/3/4 = d/s/b/b'.
"""
        return _pythia8.CoupSM_VCKMgen(self, genU, genD)

    def V2CKMgen(self, genU, genD):
        """
"""
        return _pythia8.CoupSM_V2CKMgen(self, genU, genD)

    def VCKMid(self, id1, id2):
        """
Return CKM value or square for incoming flavours (sign irrelevant).
"""
        return _pythia8.CoupSM_VCKMid(self, id1, id2)

    def V2CKMid(self, id1, id2):
        """
"""
        return _pythia8.CoupSM_V2CKMid(self, id1, id2)

    def V2CKMsum(self, id):
        """
Return CKM sum of squares for given inflavour, or random outflavour.
"""
        return _pythia8.CoupSM_V2CKMsum(self, id)

    def V2CKMpick(self, id):
        """
"""
        return _pythia8.CoupSM_V2CKMpick(self, id)
    __swig_destroy__ = _pythia8.delete_CoupSM
    __del__ = lambda self: None
CoupSM_swigregister = _pythia8.CoupSM_swigregister
CoupSM_swigregister(CoupSM)

class Couplings(CoupSM):
    """
Generic couplings class
"""
    __swig_setmethods__ = {}
    for _s in [CoupSM]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Couplings, name, value)
    __swig_getmethods__ = {}
    for _s in [CoupSM]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Couplings, name)
    __repr__ = _swig_repr

    def __init__(self, isSUSYin=False):
        """
"""
        this = _pythia8.new_Couplings(isSUSYin)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["isSUSY"] = _pythia8.Couplings_isSUSY_set
    __swig_getmethods__["isSUSY"] = _pythia8.Couplings_isSUSY_get
    if _newclass:
        isSUSY = _swig_property(_pythia8.Couplings_isSUSY_get, _pythia8.Couplings_isSUSY_set)
    __swig_destroy__ = _pythia8.delete_Couplings
    __del__ = lambda self: None
Couplings_swigregister = _pythia8.Couplings_swigregister
Couplings_swigregister(Couplings)

class CoupSUSY(Couplings):
    """
CoupSUSY
Auxiliary class to compute and store various SM and SUSY couplings.
"""
    __swig_setmethods__ = {}
    for _s in [Couplings]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CoupSUSY, name, value)
    __swig_getmethods__ = {}
    for _s in [Couplings]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CoupSUSY, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor
"""
        this = _pythia8.new_CoupSUSY()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initSUSY(self, slhaPtrIn, infoPtrIn, particleDataPtrIn, settingsPtrIn):
        """
Initialize
"""
        return _pythia8.CoupSUSY_initSUSY(self, slhaPtrIn, infoPtrIn, particleDataPtrIn, settingsPtrIn)
    __swig_setmethods__["isInit"] = _pythia8.CoupSUSY_isInit_set
    __swig_getmethods__["isInit"] = _pythia8.CoupSUSY_isInit_get
    if _newclass:
        isInit = _swig_property(_pythia8.CoupSUSY_isInit_get, _pythia8.CoupSUSY_isInit_set)
    __swig_setmethods__["isNMSSM"] = _pythia8.CoupSUSY_isNMSSM_set
    __swig_getmethods__["isNMSSM"] = _pythia8.CoupSUSY_isNMSSM_get
    if _newclass:
        isNMSSM = _swig_property(_pythia8.CoupSUSY_isNMSSM_get, _pythia8.CoupSUSY_isNMSSM_set)
    __swig_setmethods__["isLLE"] = _pythia8.CoupSUSY_isLLE_set
    __swig_getmethods__["isLLE"] = _pythia8.CoupSUSY_isLLE_get
    if _newclass:
        isLLE = _swig_property(_pythia8.CoupSUSY_isLLE_get, _pythia8.CoupSUSY_isLLE_set)
    __swig_setmethods__["isLQD"] = _pythia8.CoupSUSY_isLQD_set
    __swig_getmethods__["isLQD"] = _pythia8.CoupSUSY_isLQD_get
    if _newclass:
        isLQD = _swig_property(_pythia8.CoupSUSY_isLQD_get, _pythia8.CoupSUSY_isLQD_set)
    __swig_setmethods__["isUDD"] = _pythia8.CoupSUSY_isUDD_set
    __swig_getmethods__["isUDD"] = _pythia8.CoupSUSY_isUDD_get
    if _newclass:
        isUDD = _swig_property(_pythia8.CoupSUSY_isUDD_get, _pythia8.CoupSUSY_isUDD_set)
    __swig_setmethods__["mWpole"] = _pythia8.CoupSUSY_mWpole_set
    __swig_getmethods__["mWpole"] = _pythia8.CoupSUSY_mWpole_get
    if _newclass:
        mWpole = _swig_property(_pythia8.CoupSUSY_mWpole_get, _pythia8.CoupSUSY_mWpole_set)
    __swig_setmethods__["wWpole"] = _pythia8.CoupSUSY_wWpole_set
    __swig_getmethods__["wWpole"] = _pythia8.CoupSUSY_wWpole_get
    if _newclass:
        wWpole = _swig_property(_pythia8.CoupSUSY_wWpole_get, _pythia8.CoupSUSY_wWpole_set)
    __swig_setmethods__["mZpole"] = _pythia8.CoupSUSY_mZpole_set
    __swig_getmethods__["mZpole"] = _pythia8.CoupSUSY_mZpole_get
    if _newclass:
        mZpole = _swig_property(_pythia8.CoupSUSY_mZpole_get, _pythia8.CoupSUSY_mZpole_set)
    __swig_setmethods__["wZpole"] = _pythia8.CoupSUSY_wZpole_set
    __swig_getmethods__["wZpole"] = _pythia8.CoupSUSY_wZpole_get
    if _newclass:
        wZpole = _swig_property(_pythia8.CoupSUSY_wZpole_get, _pythia8.CoupSUSY_wZpole_set)
    __swig_setmethods__["mW"] = _pythia8.CoupSUSY_mW_set
    __swig_getmethods__["mW"] = _pythia8.CoupSUSY_mW_get
    if _newclass:
        mW = _swig_property(_pythia8.CoupSUSY_mW_get, _pythia8.CoupSUSY_mW_set)
    __swig_setmethods__["mZ"] = _pythia8.CoupSUSY_mZ_set
    __swig_getmethods__["mZ"] = _pythia8.CoupSUSY_mZ_get
    if _newclass:
        mZ = _swig_property(_pythia8.CoupSUSY_mZ_get, _pythia8.CoupSUSY_mZ_set)
    __swig_setmethods__["sin2W"] = _pythia8.CoupSUSY_sin2W_set
    __swig_getmethods__["sin2W"] = _pythia8.CoupSUSY_sin2W_get
    if _newclass:
        sin2W = _swig_property(_pythia8.CoupSUSY_sin2W_get, _pythia8.CoupSUSY_sin2W_set)
    __swig_setmethods__["sinW"] = _pythia8.CoupSUSY_sinW_set
    __swig_getmethods__["sinW"] = _pythia8.CoupSUSY_sinW_get
    if _newclass:
        sinW = _swig_property(_pythia8.CoupSUSY_sinW_get, _pythia8.CoupSUSY_sinW_set)
    __swig_setmethods__["cosW"] = _pythia8.CoupSUSY_cosW_set
    __swig_getmethods__["cosW"] = _pythia8.CoupSUSY_cosW_get
    if _newclass:
        cosW = _swig_property(_pythia8.CoupSUSY_cosW_get, _pythia8.CoupSUSY_cosW_set)
    __swig_setmethods__["tanb"] = _pythia8.CoupSUSY_tanb_set
    __swig_getmethods__["tanb"] = _pythia8.CoupSUSY_tanb_get
    if _newclass:
        tanb = _swig_property(_pythia8.CoupSUSY_tanb_get, _pythia8.CoupSUSY_tanb_set)
    __swig_setmethods__["cosb"] = _pythia8.CoupSUSY_cosb_set
    __swig_getmethods__["cosb"] = _pythia8.CoupSUSY_cosb_get
    if _newclass:
        cosb = _swig_property(_pythia8.CoupSUSY_cosb_get, _pythia8.CoupSUSY_cosb_set)
    __swig_setmethods__["sinb"] = _pythia8.CoupSUSY_sinb_set
    __swig_getmethods__["sinb"] = _pythia8.CoupSUSY_sinb_get
    if _newclass:
        sinb = _swig_property(_pythia8.CoupSUSY_sinb_get, _pythia8.CoupSUSY_sinb_set)
    __swig_setmethods__["muHiggs"] = _pythia8.CoupSUSY_muHiggs_set
    __swig_getmethods__["muHiggs"] = _pythia8.CoupSUSY_muHiggs_get
    if _newclass:
        muHiggs = _swig_property(_pythia8.CoupSUSY_muHiggs_get, _pythia8.CoupSUSY_muHiggs_set)
    __swig_setmethods__["alphaHiggs"] = _pythia8.CoupSUSY_alphaHiggs_set
    __swig_getmethods__["alphaHiggs"] = _pythia8.CoupSUSY_alphaHiggs_get
    if _newclass:
        alphaHiggs = _swig_property(_pythia8.CoupSUSY_alphaHiggs_get, _pythia8.CoupSUSY_alphaHiggs_set)
    __swig_setmethods__["mAHiggs"] = _pythia8.CoupSUSY_mAHiggs_set
    __swig_getmethods__["mAHiggs"] = _pythia8.CoupSUSY_mAHiggs_get
    if _newclass:
        mAHiggs = _swig_property(_pythia8.CoupSUSY_mAHiggs_get, _pythia8.CoupSUSY_mAHiggs_set)
    __swig_setmethods__["LsddG"] = _pythia8.CoupSUSY_LsddG_set
    __swig_getmethods__["LsddG"] = _pythia8.CoupSUSY_LsddG_get
    if _newclass:
        LsddG = _swig_property(_pythia8.CoupSUSY_LsddG_get, _pythia8.CoupSUSY_LsddG_set)
    __swig_setmethods__["RsddG"] = _pythia8.CoupSUSY_RsddG_set
    __swig_getmethods__["RsddG"] = _pythia8.CoupSUSY_RsddG_get
    if _newclass:
        RsddG = _swig_property(_pythia8.CoupSUSY_RsddG_get, _pythia8.CoupSUSY_RsddG_set)
    __swig_setmethods__["LsuuG"] = _pythia8.CoupSUSY_LsuuG_set
    __swig_getmethods__["LsuuG"] = _pythia8.CoupSUSY_LsuuG_get
    if _newclass:
        LsuuG = _swig_property(_pythia8.CoupSUSY_LsuuG_get, _pythia8.CoupSUSY_LsuuG_set)
    __swig_setmethods__["RsuuG"] = _pythia8.CoupSUSY_RsuuG_set
    __swig_getmethods__["RsuuG"] = _pythia8.CoupSUSY_RsuuG_get
    if _newclass:
        RsuuG = _swig_property(_pythia8.CoupSUSY_RsuuG_get, _pythia8.CoupSUSY_RsuuG_set)

    def getLsqqG(self, iGenSq, idQ):
        """
Status flag. Flags for NMSSM and RPV couplings.
Z and W pole masses and widths
Running masses and weak mixing angle
(default to pole values if no running available)
Tanbeta
~qq~g couplings
Assume generation index for Squark. Translate if PDG code instead.
"""
        return _pythia8.CoupSUSY_getLsqqG(self, iGenSq, idQ)

    def getRsqqG(self, iGenSq, idQ):
        """
"""
        return _pythia8.CoupSUSY_getRsqqG(self, iGenSq, idQ)
    __swig_setmethods__["OLpp"] = _pythia8.CoupSUSY_OLpp_set
    __swig_getmethods__["OLpp"] = _pythia8.CoupSUSY_OLpp_get
    if _newclass:
        OLpp = _swig_property(_pythia8.CoupSUSY_OLpp_get, _pythia8.CoupSUSY_OLpp_set)
    __swig_setmethods__["ORpp"] = _pythia8.CoupSUSY_ORpp_set
    __swig_getmethods__["ORpp"] = _pythia8.CoupSUSY_ORpp_get
    if _newclass:
        ORpp = _swig_property(_pythia8.CoupSUSY_ORpp_get, _pythia8.CoupSUSY_ORpp_set)
    __swig_setmethods__["OLp"] = _pythia8.CoupSUSY_OLp_set
    __swig_getmethods__["OLp"] = _pythia8.CoupSUSY_OLp_get
    if _newclass:
        OLp = _swig_property(_pythia8.CoupSUSY_OLp_get, _pythia8.CoupSUSY_OLp_set)
    __swig_setmethods__["ORp"] = _pythia8.CoupSUSY_ORp_set
    __swig_getmethods__["ORp"] = _pythia8.CoupSUSY_ORp_get
    if _newclass:
        ORp = _swig_property(_pythia8.CoupSUSY_ORp_get, _pythia8.CoupSUSY_ORp_set)
    __swig_setmethods__["OL"] = _pythia8.CoupSUSY_OL_set
    __swig_getmethods__["OL"] = _pythia8.CoupSUSY_OL_get
    if _newclass:
        OL = _swig_property(_pythia8.CoupSUSY_OL_get, _pythia8.CoupSUSY_OL_set)
    __swig_setmethods__["OR"] = _pythia8.CoupSUSY_OR_set
    __swig_getmethods__["OR"] = _pythia8.CoupSUSY_OR_get
    if _newclass:
        OR = _swig_property(_pythia8.CoupSUSY_OR_get, _pythia8.CoupSUSY_OR_set)
    __swig_setmethods__["LqqZ"] = _pythia8.CoupSUSY_LqqZ_set
    __swig_getmethods__["LqqZ"] = _pythia8.CoupSUSY_LqqZ_get
    if _newclass:
        LqqZ = _swig_property(_pythia8.CoupSUSY_LqqZ_get, _pythia8.CoupSUSY_LqqZ_set)
    __swig_setmethods__["RqqZ"] = _pythia8.CoupSUSY_RqqZ_set
    __swig_getmethods__["RqqZ"] = _pythia8.CoupSUSY_RqqZ_get
    if _newclass:
        RqqZ = _swig_property(_pythia8.CoupSUSY_RqqZ_get, _pythia8.CoupSUSY_RqqZ_set)
    __swig_setmethods__["LsdsdZ"] = _pythia8.CoupSUSY_LsdsdZ_set
    __swig_getmethods__["LsdsdZ"] = _pythia8.CoupSUSY_LsdsdZ_get
    if _newclass:
        LsdsdZ = _swig_property(_pythia8.CoupSUSY_LsdsdZ_get, _pythia8.CoupSUSY_LsdsdZ_set)
    __swig_setmethods__["RsdsdZ"] = _pythia8.CoupSUSY_RsdsdZ_set
    __swig_getmethods__["RsdsdZ"] = _pythia8.CoupSUSY_RsdsdZ_get
    if _newclass:
        RsdsdZ = _swig_property(_pythia8.CoupSUSY_RsdsdZ_get, _pythia8.CoupSUSY_RsdsdZ_set)
    __swig_setmethods__["LsusuZ"] = _pythia8.CoupSUSY_LsusuZ_set
    __swig_getmethods__["LsusuZ"] = _pythia8.CoupSUSY_LsusuZ_get
    if _newclass:
        LsusuZ = _swig_property(_pythia8.CoupSUSY_LsusuZ_get, _pythia8.CoupSUSY_LsusuZ_set)
    __swig_setmethods__["RsusuZ"] = _pythia8.CoupSUSY_RsusuZ_set
    __swig_getmethods__["RsusuZ"] = _pythia8.CoupSUSY_RsusuZ_get
    if _newclass:
        RsusuZ = _swig_property(_pythia8.CoupSUSY_RsusuZ_get, _pythia8.CoupSUSY_RsusuZ_set)

    def getLsqsqZ(self, idSq1, idSq2):
        """
~chi0~chi0Z couplings
~chi+~chi-Z couplings
~chi0~chi+W couplings
qqZ couplings
~q~qZ couplings
"""
        return _pythia8.CoupSUSY_getLsqsqZ(self, idSq1, idSq2)

    def getRsqsqZ(self, idSq1, idSq2):
        """
"""
        return _pythia8.CoupSUSY_getRsqsqZ(self, idSq1, idSq2)
    __swig_setmethods__["LudW"] = _pythia8.CoupSUSY_LudW_set
    __swig_getmethods__["LudW"] = _pythia8.CoupSUSY_LudW_get
    if _newclass:
        LudW = _swig_property(_pythia8.CoupSUSY_LudW_get, _pythia8.CoupSUSY_LudW_set)
    __swig_setmethods__["RudW"] = _pythia8.CoupSUSY_RudW_set
    __swig_getmethods__["RudW"] = _pythia8.CoupSUSY_RudW_get
    if _newclass:
        RudW = _swig_property(_pythia8.CoupSUSY_RudW_get, _pythia8.CoupSUSY_RudW_set)
    __swig_setmethods__["LsusdW"] = _pythia8.CoupSUSY_LsusdW_set
    __swig_getmethods__["LsusdW"] = _pythia8.CoupSUSY_LsusdW_get
    if _newclass:
        LsusdW = _swig_property(_pythia8.CoupSUSY_LsusdW_get, _pythia8.CoupSUSY_LsusdW_set)
    __swig_setmethods__["RsusdW"] = _pythia8.CoupSUSY_RsusdW_set
    __swig_getmethods__["RsusdW"] = _pythia8.CoupSUSY_RsusdW_get
    if _newclass:
        RsusdW = _swig_property(_pythia8.CoupSUSY_RsusdW_get, _pythia8.CoupSUSY_RsusdW_set)

    def getLsqqX(self, iSq, idQ, iNeut):
        """
udW couplings
~u~dW couplings
~qq~chi0 couplings
"""
        return _pythia8.CoupSUSY_getLsqqX(self, iSq, idQ, iNeut)

    def getRsqqX(self, iSq, idQ, iNeut):
        """
"""
        return _pythia8.CoupSUSY_getRsqqX(self, iSq, idQ, iNeut)
    __swig_setmethods__["LllZ"] = _pythia8.CoupSUSY_LllZ_set
    __swig_getmethods__["LllZ"] = _pythia8.CoupSUSY_LllZ_get
    if _newclass:
        LllZ = _swig_property(_pythia8.CoupSUSY_LllZ_get, _pythia8.CoupSUSY_LllZ_set)
    __swig_setmethods__["RllZ"] = _pythia8.CoupSUSY_RllZ_set
    __swig_getmethods__["RllZ"] = _pythia8.CoupSUSY_RllZ_get
    if _newclass:
        RllZ = _swig_property(_pythia8.CoupSUSY_RllZ_get, _pythia8.CoupSUSY_RllZ_set)
    __swig_setmethods__["LlvW"] = _pythia8.CoupSUSY_LlvW_set
    __swig_getmethods__["LlvW"] = _pythia8.CoupSUSY_LlvW_get
    if _newclass:
        LlvW = _swig_property(_pythia8.CoupSUSY_LlvW_get, _pythia8.CoupSUSY_LlvW_set)
    __swig_setmethods__["RlvW"] = _pythia8.CoupSUSY_RlvW_set
    __swig_getmethods__["RlvW"] = _pythia8.CoupSUSY_RlvW_get
    if _newclass:
        RlvW = _swig_property(_pythia8.CoupSUSY_RlvW_get, _pythia8.CoupSUSY_RlvW_set)
    __swig_setmethods__["LslslZ"] = _pythia8.CoupSUSY_LslslZ_set
    __swig_getmethods__["LslslZ"] = _pythia8.CoupSUSY_LslslZ_get
    if _newclass:
        LslslZ = _swig_property(_pythia8.CoupSUSY_LslslZ_get, _pythia8.CoupSUSY_LslslZ_set)
    __swig_setmethods__["RslslZ"] = _pythia8.CoupSUSY_RslslZ_set
    __swig_getmethods__["RslslZ"] = _pythia8.CoupSUSY_RslslZ_get
    if _newclass:
        RslslZ = _swig_property(_pythia8.CoupSUSY_RslslZ_get, _pythia8.CoupSUSY_RslslZ_set)
    __swig_setmethods__["LsvsvZ"] = _pythia8.CoupSUSY_LsvsvZ_set
    __swig_getmethods__["LsvsvZ"] = _pythia8.CoupSUSY_LsvsvZ_get
    if _newclass:
        LsvsvZ = _swig_property(_pythia8.CoupSUSY_LsvsvZ_get, _pythia8.CoupSUSY_LsvsvZ_set)
    __swig_setmethods__["RsvsvZ"] = _pythia8.CoupSUSY_RsvsvZ_set
    __swig_getmethods__["RsvsvZ"] = _pythia8.CoupSUSY_RsvsvZ_get
    if _newclass:
        RsvsvZ = _swig_property(_pythia8.CoupSUSY_RsvsvZ_get, _pythia8.CoupSUSY_RsvsvZ_set)
    __swig_setmethods__["LslsvW"] = _pythia8.CoupSUSY_LslsvW_set
    __swig_getmethods__["LslsvW"] = _pythia8.CoupSUSY_LslsvW_get
    if _newclass:
        LslsvW = _swig_property(_pythia8.CoupSUSY_LslsvW_get, _pythia8.CoupSUSY_LslsvW_set)
    __swig_setmethods__["RslsvW"] = _pythia8.CoupSUSY_RslsvW_set
    __swig_getmethods__["RslsvW"] = _pythia8.CoupSUSY_RslsvW_get
    if _newclass:
        RslsvW = _swig_property(_pythia8.CoupSUSY_RslsvW_get, _pythia8.CoupSUSY_RslsvW_set)
    __swig_setmethods__["Rusq"] = _pythia8.CoupSUSY_Rusq_set
    __swig_getmethods__["Rusq"] = _pythia8.CoupSUSY_Rusq_get
    if _newclass:
        Rusq = _swig_property(_pythia8.CoupSUSY_Rusq_get, _pythia8.CoupSUSY_Rusq_set)
    __swig_setmethods__["Rdsq"] = _pythia8.CoupSUSY_Rdsq_set
    __swig_getmethods__["Rdsq"] = _pythia8.CoupSUSY_Rdsq_get
    if _newclass:
        Rdsq = _swig_property(_pythia8.CoupSUSY_Rdsq_get, _pythia8.CoupSUSY_Rdsq_set)
    __swig_setmethods__["Rsl"] = _pythia8.CoupSUSY_Rsl_set
    __swig_getmethods__["Rsl"] = _pythia8.CoupSUSY_Rsl_get
    if _newclass:
        Rsl = _swig_property(_pythia8.CoupSUSY_Rsl_get, _pythia8.CoupSUSY_Rsl_set)
    __swig_setmethods__["Rsv"] = _pythia8.CoupSUSY_Rsv_set
    __swig_getmethods__["Rsv"] = _pythia8.CoupSUSY_Rsv_get
    if _newclass:
        Rsv = _swig_property(_pythia8.CoupSUSY_Rsv_get, _pythia8.CoupSUSY_Rsv_set)

    def idNeut(self, idChi):
        """
~du~chi+ couplings
~ud~chi+ couplings
~l~lZ couplings
~l~vW couplings
~ll~chi0 couplings
~vl~chi+ couplings
~lv~chi+ couplings
RPV couplings
Return neutralino, chargino, sup, sdown and slepton flavour codes.
"""
        return _pythia8.CoupSUSY_idNeut(self, idChi)

    def idChar(self, idChi):
        """
"""
        return _pythia8.CoupSUSY_idChar(self, idChi)

    def idSup(self, iSup):
        """
"""
        return _pythia8.CoupSUSY_idSup(self, iSup)

    def idSdown(self, iSdown):
        """
"""
        return _pythia8.CoupSUSY_idSdown(self, iSdown)

    def idSlep(self, iSlep):
        """
"""
        return _pythia8.CoupSUSY_idSlep(self, iSlep)

    def typeNeut(self, idPDG):
        """
"""
        return _pythia8.CoupSUSY_typeNeut(self, idPDG)

    def typeChar(self, idPDG):
        """
"""
        return _pythia8.CoupSUSY_typeChar(self, idPDG)
    __swig_setmethods__["slhaPtr"] = _pythia8.CoupSUSY_slhaPtr_set
    __swig_getmethods__["slhaPtr"] = _pythia8.CoupSUSY_slhaPtr_get
    if _newclass:
        slhaPtr = _swig_property(_pythia8.CoupSUSY_slhaPtr_get, _pythia8.CoupSUSY_slhaPtr_set)
    __swig_destroy__ = _pythia8.delete_CoupSUSY
    __del__ = lambda self: None
CoupSUSY_swigregister = _pythia8.CoupSUSY_swigregister
CoupSUSY_swigregister(CoupSUSY)

class BeamShape(_object):
    """
Base class to set beam momentum and interaction spot spread.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BeamShape, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BeamShape, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        if self.__class__ == BeamShape:
            _self = None
        else:
            _self = self
        this = _pythia8.new_BeamShape(_self, )
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_BeamShape
    __del__ = lambda self: None

    def init(self, settings, rndmPtrIn):
        """
Initialize beam parameters.
"""
        return _pythia8.BeamShape_init(self, settings, rndmPtrIn)

    def pick(self):
        """
Set the two beam momentum deviations and the beam vertex.
"""
        return _pythia8.BeamShape_pick(self)

    def deltaPA(self):
        """
Methods to read out the choice made with the above method.
"""
        return _pythia8.BeamShape_deltaPA(self)

    def deltaPB(self):
        """
"""
        return _pythia8.BeamShape_deltaPB(self)

    def vertex(self):
        """
"""
        return _pythia8.BeamShape_vertex(self)
    __swig_setmethods__["deltaPxA"] = _pythia8.BeamShape_deltaPxA_set
    __swig_getmethods__["deltaPxA"] = _pythia8.BeamShape_deltaPxA_get
    if _newclass:
        deltaPxA = _swig_property(_pythia8.BeamShape_deltaPxA_get, _pythia8.BeamShape_deltaPxA_set)
    __swig_setmethods__["deltaPyA"] = _pythia8.BeamShape_deltaPyA_set
    __swig_getmethods__["deltaPyA"] = _pythia8.BeamShape_deltaPyA_get
    if _newclass:
        deltaPyA = _swig_property(_pythia8.BeamShape_deltaPyA_get, _pythia8.BeamShape_deltaPyA_set)
    __swig_setmethods__["deltaPzA"] = _pythia8.BeamShape_deltaPzA_set
    __swig_getmethods__["deltaPzA"] = _pythia8.BeamShape_deltaPzA_get
    if _newclass:
        deltaPzA = _swig_property(_pythia8.BeamShape_deltaPzA_get, _pythia8.BeamShape_deltaPzA_set)
    __swig_setmethods__["deltaPxB"] = _pythia8.BeamShape_deltaPxB_set
    __swig_getmethods__["deltaPxB"] = _pythia8.BeamShape_deltaPxB_get
    if _newclass:
        deltaPxB = _swig_property(_pythia8.BeamShape_deltaPxB_get, _pythia8.BeamShape_deltaPxB_set)
    __swig_setmethods__["deltaPyB"] = _pythia8.BeamShape_deltaPyB_set
    __swig_getmethods__["deltaPyB"] = _pythia8.BeamShape_deltaPyB_get
    if _newclass:
        deltaPyB = _swig_property(_pythia8.BeamShape_deltaPyB_get, _pythia8.BeamShape_deltaPyB_set)
    __swig_setmethods__["deltaPzB"] = _pythia8.BeamShape_deltaPzB_set
    __swig_getmethods__["deltaPzB"] = _pythia8.BeamShape_deltaPzB_get
    if _newclass:
        deltaPzB = _swig_property(_pythia8.BeamShape_deltaPzB_get, _pythia8.BeamShape_deltaPzB_set)
    __swig_setmethods__["vertexX"] = _pythia8.BeamShape_vertexX_set
    __swig_getmethods__["vertexX"] = _pythia8.BeamShape_vertexX_get
    if _newclass:
        vertexX = _swig_property(_pythia8.BeamShape_vertexX_get, _pythia8.BeamShape_vertexX_set)
    __swig_setmethods__["vertexY"] = _pythia8.BeamShape_vertexY_set
    __swig_getmethods__["vertexY"] = _pythia8.BeamShape_vertexY_get
    if _newclass:
        vertexY = _swig_property(_pythia8.BeamShape_vertexY_get, _pythia8.BeamShape_vertexY_set)
    __swig_setmethods__["vertexZ"] = _pythia8.BeamShape_vertexZ_set
    __swig_getmethods__["vertexZ"] = _pythia8.BeamShape_vertexZ_get
    if _newclass:
        vertexZ = _swig_property(_pythia8.BeamShape_vertexZ_get, _pythia8.BeamShape_vertexZ_set)
    __swig_setmethods__["vertexT"] = _pythia8.BeamShape_vertexT_set
    __swig_getmethods__["vertexT"] = _pythia8.BeamShape_vertexT_get
    if _newclass:
        vertexT = _swig_property(_pythia8.BeamShape_vertexT_get, _pythia8.BeamShape_vertexT_set)
    __swig_setmethods__["allowMomentumSpread"] = _pythia8.BeamShape_allowMomentumSpread_set
    __swig_getmethods__["allowMomentumSpread"] = _pythia8.BeamShape_allowMomentumSpread_get
    if _newclass:
        allowMomentumSpread = _swig_property(_pythia8.BeamShape_allowMomentumSpread_get, _pythia8.BeamShape_allowMomentumSpread_set)
    __swig_setmethods__["allowVertexSpread"] = _pythia8.BeamShape_allowVertexSpread_set
    __swig_getmethods__["allowVertexSpread"] = _pythia8.BeamShape_allowVertexSpread_get
    if _newclass:
        allowVertexSpread = _swig_property(_pythia8.BeamShape_allowVertexSpread_get, _pythia8.BeamShape_allowVertexSpread_set)
    __swig_setmethods__["sigmaPxA"] = _pythia8.BeamShape_sigmaPxA_set
    __swig_getmethods__["sigmaPxA"] = _pythia8.BeamShape_sigmaPxA_get
    if _newclass:
        sigmaPxA = _swig_property(_pythia8.BeamShape_sigmaPxA_get, _pythia8.BeamShape_sigmaPxA_set)
    __swig_setmethods__["sigmaPyA"] = _pythia8.BeamShape_sigmaPyA_set
    __swig_getmethods__["sigmaPyA"] = _pythia8.BeamShape_sigmaPyA_get
    if _newclass:
        sigmaPyA = _swig_property(_pythia8.BeamShape_sigmaPyA_get, _pythia8.BeamShape_sigmaPyA_set)
    __swig_setmethods__["sigmaPzA"] = _pythia8.BeamShape_sigmaPzA_set
    __swig_getmethods__["sigmaPzA"] = _pythia8.BeamShape_sigmaPzA_get
    if _newclass:
        sigmaPzA = _swig_property(_pythia8.BeamShape_sigmaPzA_get, _pythia8.BeamShape_sigmaPzA_set)
    __swig_setmethods__["maxDevA"] = _pythia8.BeamShape_maxDevA_set
    __swig_getmethods__["maxDevA"] = _pythia8.BeamShape_maxDevA_get
    if _newclass:
        maxDevA = _swig_property(_pythia8.BeamShape_maxDevA_get, _pythia8.BeamShape_maxDevA_set)
    __swig_setmethods__["sigmaPxB"] = _pythia8.BeamShape_sigmaPxB_set
    __swig_getmethods__["sigmaPxB"] = _pythia8.BeamShape_sigmaPxB_get
    if _newclass:
        sigmaPxB = _swig_property(_pythia8.BeamShape_sigmaPxB_get, _pythia8.BeamShape_sigmaPxB_set)
    __swig_setmethods__["sigmaPyB"] = _pythia8.BeamShape_sigmaPyB_set
    __swig_getmethods__["sigmaPyB"] = _pythia8.BeamShape_sigmaPyB_get
    if _newclass:
        sigmaPyB = _swig_property(_pythia8.BeamShape_sigmaPyB_get, _pythia8.BeamShape_sigmaPyB_set)
    __swig_setmethods__["sigmaPzB"] = _pythia8.BeamShape_sigmaPzB_set
    __swig_getmethods__["sigmaPzB"] = _pythia8.BeamShape_sigmaPzB_get
    if _newclass:
        sigmaPzB = _swig_property(_pythia8.BeamShape_sigmaPzB_get, _pythia8.BeamShape_sigmaPzB_set)
    __swig_setmethods__["maxDevB"] = _pythia8.BeamShape_maxDevB_set
    __swig_getmethods__["maxDevB"] = _pythia8.BeamShape_maxDevB_get
    if _newclass:
        maxDevB = _swig_property(_pythia8.BeamShape_maxDevB_get, _pythia8.BeamShape_maxDevB_set)
    __swig_setmethods__["sigmaVertexX"] = _pythia8.BeamShape_sigmaVertexX_set
    __swig_getmethods__["sigmaVertexX"] = _pythia8.BeamShape_sigmaVertexX_get
    if _newclass:
        sigmaVertexX = _swig_property(_pythia8.BeamShape_sigmaVertexX_get, _pythia8.BeamShape_sigmaVertexX_set)
    __swig_setmethods__["sigmaVertexY"] = _pythia8.BeamShape_sigmaVertexY_set
    __swig_getmethods__["sigmaVertexY"] = _pythia8.BeamShape_sigmaVertexY_get
    if _newclass:
        sigmaVertexY = _swig_property(_pythia8.BeamShape_sigmaVertexY_get, _pythia8.BeamShape_sigmaVertexY_set)
    __swig_setmethods__["sigmaVertexZ"] = _pythia8.BeamShape_sigmaVertexZ_set
    __swig_getmethods__["sigmaVertexZ"] = _pythia8.BeamShape_sigmaVertexZ_get
    if _newclass:
        sigmaVertexZ = _swig_property(_pythia8.BeamShape_sigmaVertexZ_get, _pythia8.BeamShape_sigmaVertexZ_set)
    __swig_setmethods__["maxDevVertex"] = _pythia8.BeamShape_maxDevVertex_set
    __swig_getmethods__["maxDevVertex"] = _pythia8.BeamShape_maxDevVertex_get
    if _newclass:
        maxDevVertex = _swig_property(_pythia8.BeamShape_maxDevVertex_get, _pythia8.BeamShape_maxDevVertex_set)
    __swig_setmethods__["sigmaTime"] = _pythia8.BeamShape_sigmaTime_set
    __swig_getmethods__["sigmaTime"] = _pythia8.BeamShape_sigmaTime_get
    if _newclass:
        sigmaTime = _swig_property(_pythia8.BeamShape_sigmaTime_get, _pythia8.BeamShape_sigmaTime_set)
    __swig_setmethods__["maxDevTime"] = _pythia8.BeamShape_maxDevTime_set
    __swig_getmethods__["maxDevTime"] = _pythia8.BeamShape_maxDevTime_get
    if _newclass:
        maxDevTime = _swig_property(_pythia8.BeamShape_maxDevTime_get, _pythia8.BeamShape_maxDevTime_set)
    __swig_setmethods__["offsetX"] = _pythia8.BeamShape_offsetX_set
    __swig_getmethods__["offsetX"] = _pythia8.BeamShape_offsetX_get
    if _newclass:
        offsetX = _swig_property(_pythia8.BeamShape_offsetX_get, _pythia8.BeamShape_offsetX_set)
    __swig_setmethods__["offsetY"] = _pythia8.BeamShape_offsetY_set
    __swig_getmethods__["offsetY"] = _pythia8.BeamShape_offsetY_get
    if _newclass:
        offsetY = _swig_property(_pythia8.BeamShape_offsetY_get, _pythia8.BeamShape_offsetY_set)
    __swig_setmethods__["offsetZ"] = _pythia8.BeamShape_offsetZ_set
    __swig_getmethods__["offsetZ"] = _pythia8.BeamShape_offsetZ_get
    if _newclass:
        offsetZ = _swig_property(_pythia8.BeamShape_offsetZ_get, _pythia8.BeamShape_offsetZ_set)
    __swig_setmethods__["offsetT"] = _pythia8.BeamShape_offsetT_set
    __swig_getmethods__["offsetT"] = _pythia8.BeamShape_offsetT_get
    if _newclass:
        offsetT = _swig_property(_pythia8.BeamShape_offsetT_get, _pythia8.BeamShape_offsetT_set)
    __swig_setmethods__["rndmPtr"] = _pythia8.BeamShape_rndmPtr_set
    __swig_getmethods__["rndmPtr"] = _pythia8.BeamShape_rndmPtr_get
    if _newclass:
        rndmPtr = _swig_property(_pythia8.BeamShape_rndmPtr_get, _pythia8.BeamShape_rndmPtr_set)
    def __disown__(self):
        self.this.disown()
        _pythia8.disown_BeamShape(self)
        return weakref_proxy(self)
BeamShape_swigregister = _pythia8.BeamShape_swigregister
BeamShape_swigregister(BeamShape)

class DecayChannel(_object):
    """
This class holds info on a single decay channel.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DecayChannel, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DecayChannel, name)
    __repr__ = _swig_repr

    def __init__(self, onModeIn=0, bRatioIn=0., meModeIn=0, prod0=0, prod1=0, prod2=0, prod3=0, prod4=0, prod5=0, prod6=0, prod7=0):
        """
Constructor.
"""
        this = _pythia8.new_DecayChannel(onModeIn, bRatioIn, meModeIn, prod0, prod1, prod2, prod3, prod4, prod5, prod6, prod7)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def rescaleBR(self, fac):
        """
"""
        return _pythia8.DecayChannel_rescaleBR(self, fac)

    def setHasChanged(self, hasChangedIn):
        """
"""
        return _pythia8.DecayChannel_setHasChanged(self, hasChangedIn)

    def onMode(self, *args):
        """
Member functions for output.
"""
        return _pythia8.DecayChannel_onMode(self, *args)

    def bRatio(self, *args):
        """
"""
        return _pythia8.DecayChannel_bRatio(self, *args)

    def meMode(self, *args):
        """
"""
        return _pythia8.DecayChannel_meMode(self, *args)

    def multiplicity(self, *args):
        """
"""
        return _pythia8.DecayChannel_multiplicity(self, *args)

    def product(self, *args):
        """
"""
        return _pythia8.DecayChannel_product(self, *args)

    def hasChanged(self):
        """
"""
        return _pythia8.DecayChannel_hasChanged(self)

    def contains(self, *args):
        """
"""
        return _pythia8.DecayChannel_contains(self, *args)

    def currentBR(self, *args):
        """
"""
        return _pythia8.DecayChannel_currentBR(self, *args)

    def onShellWidth(self, *args):
        """
"""
        return _pythia8.DecayChannel_onShellWidth(self, *args)

    def onShellWidthFactor(self, factor):
        """
"""
        return _pythia8.DecayChannel_onShellWidthFactor(self, factor)

    def openSec(self, *args):
        """
"""
        return _pythia8.DecayChannel_openSec(self, *args)
    __swig_destroy__ = _pythia8.delete_DecayChannel
    __del__ = lambda self: None
DecayChannel_swigregister = _pythia8.DecayChannel_swigregister
DecayChannel_swigregister(DecayChannel)

class ParticleDataEntry(_object):
    """
This class holds info on a single particle species.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ParticleDataEntry, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ParticleDataEntry, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_ParticleDataEntry(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ParticleDataEntry
    __del__ = lambda self: None

    def setDefaults(self):
        """
"""
        return _pythia8.ParticleDataEntry_setDefaults(self)

    def initPtr(self, particleDataPtrIn):
        """
Store pointer to whole particle data table/database.
"""
        return _pythia8.ParticleDataEntry_initPtr(self, particleDataPtrIn)

    def setAll(self, nameIn, antiNameIn, spinTypeIn=0, chargeTypeIn=0, colTypeIn=0, m0In=0., mWidthIn=0., mMinIn=0., mMaxIn=0., tau0In=0.):
        """
Reset all the properties of an existing particle.
"""
        return _pythia8.ParticleDataEntry_setAll(self, nameIn, antiNameIn, spinTypeIn, chargeTypeIn, colTypeIn, m0In, mWidthIn, mMinIn, mMaxIn, tau0In)

    def setName(self, nameIn):
        """
Change current values one at a time (or set if not set before).
(Must use set here since else name+signature clash with get methods.)
"""
        return _pythia8.ParticleDataEntry_setName(self, nameIn)

    def setAntiName(self, antiNameIn):
        """
"""
        return _pythia8.ParticleDataEntry_setAntiName(self, antiNameIn)

    def setNames(self, nameIn, antiNameIn):
        """
"""
        return _pythia8.ParticleDataEntry_setNames(self, nameIn, antiNameIn)

    def setSpinType(self, spinTypeIn):
        """
"""
        return _pythia8.ParticleDataEntry_setSpinType(self, spinTypeIn)

    def setChargeType(self, chargeTypeIn):
        """
"""
        return _pythia8.ParticleDataEntry_setChargeType(self, chargeTypeIn)

    def setColType(self, colTypeIn):
        """
"""
        return _pythia8.ParticleDataEntry_setColType(self, colTypeIn)

    def setM0(self, m0In):
        """
"""
        return _pythia8.ParticleDataEntry_setM0(self, m0In)

    def setMWidth(self, mWidthIn, countAsChanged=True):
        """
"""
        return _pythia8.ParticleDataEntry_setMWidth(self, mWidthIn, countAsChanged)

    def setMMin(self, mMinIn):
        """
"""
        return _pythia8.ParticleDataEntry_setMMin(self, mMinIn)

    def setMMax(self, mMaxIn):
        """
"""
        return _pythia8.ParticleDataEntry_setMMax(self, mMaxIn)

    def setMMinNoChange(self, mMinIn):
        """
Special options specifically when cutting wings of Breit-Wigners.
"""
        return _pythia8.ParticleDataEntry_setMMinNoChange(self, mMinIn)

    def setMMaxNoChange(self, mMaxIn):
        """
"""
        return _pythia8.ParticleDataEntry_setMMaxNoChange(self, mMaxIn)

    def setTau0(self, tau0In, countAsChanged=True):
        """
"""
        return _pythia8.ParticleDataEntry_setTau0(self, tau0In, countAsChanged)

    def setIsResonance(self, isResonanceIn):
        """
"""
        return _pythia8.ParticleDataEntry_setIsResonance(self, isResonanceIn)

    def setMayDecay(self, mayDecayIn, countAsChanged=True):
        """
"""
        return _pythia8.ParticleDataEntry_setMayDecay(self, mayDecayIn, countAsChanged)

    def setDoExternalDecay(self, doExternalDecayIn):
        """
"""
        return _pythia8.ParticleDataEntry_setDoExternalDecay(self, doExternalDecayIn)

    def setIsVisible(self, isVisibleIn):
        """
"""
        return _pythia8.ParticleDataEntry_setIsVisible(self, isVisibleIn)

    def setDoForceWidth(self, doForceWidthIn):
        """
"""
        return _pythia8.ParticleDataEntry_setDoForceWidth(self, doForceWidthIn)

    def setHasChanged(self, hasChangedIn):
        """
"""
        return _pythia8.ParticleDataEntry_setHasChanged(self, hasChangedIn)

    def id(self):
        """
Give back current values.
"""
        return _pythia8.ParticleDataEntry_id(self)

    def hasAnti(self):
        """
"""
        return _pythia8.ParticleDataEntry_hasAnti(self)

    def name(self, idIn=1):
        """
"""
        return _pythia8.ParticleDataEntry_name(self, idIn)

    def spinType(self):
        """
"""
        return _pythia8.ParticleDataEntry_spinType(self)

    def chargeType(self, idIn=1):
        """
"""
        return _pythia8.ParticleDataEntry_chargeType(self, idIn)

    def charge(self, idIn=1):
        """
"""
        return _pythia8.ParticleDataEntry_charge(self, idIn)

    def colType(self, idIn=1):
        """
"""
        return _pythia8.ParticleDataEntry_colType(self, idIn)

    def m0(self):
        """
"""
        return _pythia8.ParticleDataEntry_m0(self)

    def mWidth(self):
        """
"""
        return _pythia8.ParticleDataEntry_mWidth(self)

    def mMin(self):
        """
"""
        return _pythia8.ParticleDataEntry_mMin(self)

    def mMax(self):
        """
"""
        return _pythia8.ParticleDataEntry_mMax(self)

    def m0Min(self):
        """
"""
        return _pythia8.ParticleDataEntry_m0Min(self)

    def m0Max(self):
        """
"""
        return _pythia8.ParticleDataEntry_m0Max(self)

    def tau0(self):
        """
"""
        return _pythia8.ParticleDataEntry_tau0(self)

    def isResonance(self):
        """
"""
        return _pythia8.ParticleDataEntry_isResonance(self)

    def mayDecay(self):
        """
"""
        return _pythia8.ParticleDataEntry_mayDecay(self)

    def doExternalDecay(self):
        """
"""
        return _pythia8.ParticleDataEntry_doExternalDecay(self)

    def isVisible(self):
        """
"""
        return _pythia8.ParticleDataEntry_isVisible(self)

    def doForceWidth(self):
        """
"""
        return _pythia8.ParticleDataEntry_doForceWidth(self)

    def hasChanged(self):
        """
"""
        return _pythia8.ParticleDataEntry_hasChanged(self)

    def hasChangedMMin(self):
        """
"""
        return _pythia8.ParticleDataEntry_hasChangedMMin(self)

    def hasChangedMMax(self):
        """
"""
        return _pythia8.ParticleDataEntry_hasChangedMMax(self)

    def initBWmass(self):
        """
Set and give back several mass-related quantities.
"""
        return _pythia8.ParticleDataEntry_initBWmass(self)

    def constituentMass(self):
        """
"""
        return _pythia8.ParticleDataEntry_constituentMass(self)

    def mSel(self):
        """
"""
        return _pythia8.ParticleDataEntry_mSel(self)

    def mRun(self, mH):
        """
"""
        return _pythia8.ParticleDataEntry_mRun(self, mH)

    def useBreitWigner(self):
        """
Give back other quantities.
"""
        return _pythia8.ParticleDataEntry_useBreitWigner(self)

    def canDecay(self):
        """
"""
        return _pythia8.ParticleDataEntry_canDecay(self)

    def isLepton(self):
        """
"""
        return _pythia8.ParticleDataEntry_isLepton(self)

    def isQuark(self):
        """
"""
        return _pythia8.ParticleDataEntry_isQuark(self)

    def isGluon(self):
        """
"""
        return _pythia8.ParticleDataEntry_isGluon(self)

    def isDiquark(self):
        """
"""
        return _pythia8.ParticleDataEntry_isDiquark(self)

    def isParton(self):
        """
"""
        return _pythia8.ParticleDataEntry_isParton(self)

    def isHadron(self):
        """
"""
        return _pythia8.ParticleDataEntry_isHadron(self)

    def isMeson(self):
        """
"""
        return _pythia8.ParticleDataEntry_isMeson(self)

    def isBaryon(self):
        """
"""
        return _pythia8.ParticleDataEntry_isBaryon(self)

    def isOnium(self):
        """
"""
        return _pythia8.ParticleDataEntry_isOnium(self)

    def isOctetHadron(self):
        """
Intermediate octet ccbar or bbar states in colour-octet model.
"""
        return _pythia8.ParticleDataEntry_isOctetHadron(self)

    def heaviestQuark(self, idIn=1):
        """
"""
        return _pythia8.ParticleDataEntry_heaviestQuark(self, idIn)

    def baryonNumberType(self, idIn=1):
        """
"""
        return _pythia8.ParticleDataEntry_baryonNumberType(self, idIn)

    def nQuarksInCode(self, idQIn):
        """
"""
        return _pythia8.ParticleDataEntry_nQuarksInCode(self, idQIn)

    def clearChannels(self):
        """
Reset to empty decay table.
"""
        return _pythia8.ParticleDataEntry_clearChannels(self)

    def addChannel(self, onMode=0, bRatio=0., meMode=0, prod0=0, prod1=0, prod2=0, prod3=0, prod4=0, prod5=0, prod6=0, prod7=0):
        """
Add a decay channel to the decay table.
"""
        return _pythia8.ParticleDataEntry_addChannel(self, onMode, bRatio, meMode, prod0, prod1, prod2, prod3, prod4, prod5, prod6, prod7)

    def sizeChannels(self):
        """
Decay table size.
"""
        return _pythia8.ParticleDataEntry_sizeChannels(self)

    def channel(self, *args):
        """
"""
        return _pythia8.ParticleDataEntry_channel(self, *args)

    def rescaleBR(self, newSumBR=1.):
        """
Rescale sum of branching ratios to unity.
"""
        return _pythia8.ParticleDataEntry_rescaleBR(self, newSumBR)

    def preparePick(self, idSgn, mHat=0., idInFlav=0):
        """
Random choice of decay channel according to branching ratios.
"""
        return _pythia8.ParticleDataEntry_preparePick(self, idSgn, mHat, idInFlav)

    def pickChannel(self):
        """
"""
        return _pythia8.ParticleDataEntry_pickChannel(self)

    def setResonancePtr(self, resonancePtrIn):
        """
Access methods stored in ResonanceWidths.
"""
        return _pythia8.ParticleDataEntry_setResonancePtr(self, resonancePtrIn)

    def getResonancePtr(self):
        """
"""
        return _pythia8.ParticleDataEntry_getResonancePtr(self)

    def resInit(self, infoPtrIn, settingsPtrIn, particleDataPtrIn, couplingsPtrIn):
        """
"""
        return _pythia8.ParticleDataEntry_resInit(self, infoPtrIn, settingsPtrIn, particleDataPtrIn, couplingsPtrIn)

    def resWidth(self, idSgn, mHat, idIn=0, openOnly=False, setBR=False):
        """
"""
        return _pythia8.ParticleDataEntry_resWidth(self, idSgn, mHat, idIn, openOnly, setBR)

    def resWidthOpen(self, idSgn, mHat, idIn=0):
        """
"""
        return _pythia8.ParticleDataEntry_resWidthOpen(self, idSgn, mHat, idIn)

    def resWidthStore(self, idSgn, mHat, idIn=0):
        """
"""
        return _pythia8.ParticleDataEntry_resWidthStore(self, idSgn, mHat, idIn)

    def resOpenFrac(self, idSgn):
        """
"""
        return _pythia8.ParticleDataEntry_resOpenFrac(self, idSgn)

    def resWidthRescaleFactor(self):
        """
"""
        return _pythia8.ParticleDataEntry_resWidthRescaleFactor(self)

    def resWidthChan(self, mHat, idAbs1=0, idAbs2=0):
        """
"""
        return _pythia8.ParticleDataEntry_resWidthChan(self, mHat, idAbs1, idAbs2)
ParticleDataEntry_swigregister = _pythia8.ParticleDataEntry_swigregister
ParticleDataEntry_swigregister(ParticleDataEntry)

class ParticleData(_object):
    """
This class holds a map of all ParticleDataEntries.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ParticleData, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ParticleData, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_ParticleData()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initPtr(self, infoPtrIn, settingsPtrIn, rndmPtrIn, couplingsPtrIn):
        """
Initialize pointers.
"""
        return _pythia8.ParticleData_initPtr(self, infoPtrIn, settingsPtrIn, rndmPtrIn, couplingsPtrIn)

    def init(self, *args):
        """
Read in database from an istream.
"""
        return _pythia8.ParticleData_init(self, *args)

    def reInit(self, startFile, xmlFormat=True):
        """
Overwrite existing database by reading from specific file.
"""
        return _pythia8.ParticleData_reInit(self, startFile, xmlFormat)

    def initWidths(self, resonancePtrs):
        """
Initialize pointers, normal Breit-Wigners and special resonances.
"""
        return _pythia8.ParticleData_initWidths(self, resonancePtrs)

    def listXML(self, outFile):
        """
"""
        return _pythia8.ParticleData_listXML(self, outFile)

    def readXML(self, *args):
        """
"""
        return _pythia8.ParticleData_readXML(self, *args)

    def copyXML(self, particleDataIn):
        """
Copy and process XML information from another particleData object.
"""
        return _pythia8.ParticleData_copyXML(self, particleDataIn)

    def loadXML(self, *args):
        """
"""
        return _pythia8.ParticleData_loadXML(self, *args)

    def processXML(self, reset=True):
        """
"""
        return _pythia8.ParticleData_processXML(self, reset)

    def readFF(self, *args):
        """
"""
        return _pythia8.ParticleData_readFF(self, *args)

    def listFF(self, outFile):
        """
"""
        return _pythia8.ParticleData_listFF(self, outFile)

    def readString(self, lineIn, warn=True):
        """
Read in one update from a single line.
"""
        return _pythia8.ParticleData_readString(self, lineIn, warn)

    def readingFailed(self):
        """
Keep track whether any readings have failed, invalidating run setup.
"""
        return _pythia8.ParticleData_readingFailed(self)

    def listAll(self):
        """
Print out table of whole database, or of only part of it.
"""
        return _pythia8.ParticleData_listAll(self)

    def listChanged(self, changedRes=False):
        """
"""
        return _pythia8.ParticleData_listChanged(self, changedRes)

    def getReadHistory(self, subrun=-999):
        """
Retrieve readString history (e.g., for inspection). Everything
(subrun=-999), up to first subrun (=-1), or subrun-specific (>=0).
"""
        return _pythia8.ParticleData_getReadHistory(self, subrun)

    def checkTable(self, verbosity=1):
        """
Check that table makes sense, especially for decays.
"""
        return _pythia8.ParticleData_checkTable(self, verbosity)

    def addParticle(self, *args):
        """
"""
        return _pythia8.ParticleData_addParticle(self, *args)

    def setAll(self, idIn, nameIn, antiNameIn, spinTypeIn=0, chargeTypeIn=0, colTypeIn=0, m0In=0., mWidthIn=0., mMinIn=0., mMaxIn=0., tau0In=0.):
        """
Reset all the properties of an entry in one go.
"""
        return _pythia8.ParticleData_setAll(self, idIn, nameIn, antiNameIn, spinTypeIn, chargeTypeIn, colTypeIn, m0In, mWidthIn, mMinIn, mMaxIn, tau0In)

    def isParticle(self, idIn):
        """
Query existence of an entry.
"""
        return _pythia8.ParticleData_isParticle(self, idIn)

    def findParticle(self, *args):
        """
"""
        return _pythia8.ParticleData_findParticle(self, *args)

    def nextId(self, idIn):
        """
Return the id of the sequentially next particle stored in table.
"""
        return _pythia8.ParticleData_nextId(self, idIn)

    def antiName(self, idIn, antiNameIn):
        """
"""
        return _pythia8.ParticleData_antiName(self, idIn, antiNameIn)

    def names(self, idIn, nameIn, antiNameIn):
        """
"""
        return _pythia8.ParticleData_names(self, idIn, nameIn, antiNameIn)

    def hasAnti(self, idIn):
        """
Give back current values.
"""
        return _pythia8.ParticleData_hasAnti(self, idIn)

    def name(self, *args):
        """
"""
        return _pythia8.ParticleData_name(self, *args)

    def spinType(self, *args):
        """
"""
        return _pythia8.ParticleData_spinType(self, *args)

    def chargeType(self, *args):
        """
"""
        return _pythia8.ParticleData_chargeType(self, *args)

    def charge(self, idIn):
        """
"""
        return _pythia8.ParticleData_charge(self, idIn)

    def colType(self, *args):
        """
"""
        return _pythia8.ParticleData_colType(self, *args)

    def m0(self, *args):
        """
"""
        return _pythia8.ParticleData_m0(self, *args)

    def mWidth(self, *args):
        """
"""
        return _pythia8.ParticleData_mWidth(self, *args)

    def mMin(self, *args):
        """
"""
        return _pythia8.ParticleData_mMin(self, *args)

    def m0Min(self, idIn):
        """
"""
        return _pythia8.ParticleData_m0Min(self, idIn)

    def mMax(self, *args):
        """
"""
        return _pythia8.ParticleData_mMax(self, *args)

    def m0Max(self, idIn):
        """
"""
        return _pythia8.ParticleData_m0Max(self, idIn)

    def tau0(self, *args):
        """
"""
        return _pythia8.ParticleData_tau0(self, *args)

    def isResonance(self, *args):
        """
"""
        return _pythia8.ParticleData_isResonance(self, *args)

    def mayDecay(self, *args):
        """
"""
        return _pythia8.ParticleData_mayDecay(self, *args)

    def doExternalDecay(self, *args):
        """
"""
        return _pythia8.ParticleData_doExternalDecay(self, *args)

    def isVisible(self, *args):
        """
"""
        return _pythia8.ParticleData_isVisible(self, *args)

    def doForceWidth(self, *args):
        """
"""
        return _pythia8.ParticleData_doForceWidth(self, *args)

    def hasChanged(self, *args):
        """
"""
        return _pythia8.ParticleData_hasChanged(self, *args)

    def hasChangedMMin(self, idIn):
        """
"""
        return _pythia8.ParticleData_hasChangedMMin(self, idIn)

    def hasChangedMMax(self, idIn):
        """
"""
        return _pythia8.ParticleData_hasChangedMMax(self, idIn)

    def useBreitWigner(self, idIn):
        """
Give back special mass-related quantities.
"""
        return _pythia8.ParticleData_useBreitWigner(self, idIn)

    def constituentMass(self, idIn):
        """
"""
        return _pythia8.ParticleData_constituentMass(self, idIn)

    def mSel(self, idIn):
        """
"""
        return _pythia8.ParticleData_mSel(self, idIn)

    def mRun(self, idIn, mH):
        """
"""
        return _pythia8.ParticleData_mRun(self, idIn, mH)

    def canDecay(self, idIn):
        """
Give back other quantities.
"""
        return _pythia8.ParticleData_canDecay(self, idIn)

    def isLepton(self, idIn):
        """
"""
        return _pythia8.ParticleData_isLepton(self, idIn)

    def isQuark(self, idIn):
        """
"""
        return _pythia8.ParticleData_isQuark(self, idIn)

    def isGluon(self, idIn):
        """
"""
        return _pythia8.ParticleData_isGluon(self, idIn)

    def isDiquark(self, idIn):
        """
"""
        return _pythia8.ParticleData_isDiquark(self, idIn)

    def isParton(self, idIn):
        """
"""
        return _pythia8.ParticleData_isParton(self, idIn)

    def isHadron(self, idIn):
        """
"""
        return _pythia8.ParticleData_isHadron(self, idIn)

    def isMeson(self, idIn):
        """
"""
        return _pythia8.ParticleData_isMeson(self, idIn)

    def isBaryon(self, idIn):
        """
"""
        return _pythia8.ParticleData_isBaryon(self, idIn)

    def isOnium(self, idIn):
        """
"""
        return _pythia8.ParticleData_isOnium(self, idIn)

    def isOctetHadron(self, idIn):
        """
"""
        return _pythia8.ParticleData_isOctetHadron(self, idIn)

    def heaviestQuark(self, idIn):
        """
"""
        return _pythia8.ParticleData_heaviestQuark(self, idIn)

    def baryonNumberType(self, idIn):
        """
"""
        return _pythia8.ParticleData_baryonNumberType(self, idIn)

    def nQuarksInCode(self, idIn, idQIn):
        """
"""
        return _pythia8.ParticleData_nQuarksInCode(self, idIn, idQIn)

    def rescaleBR(self, idIn, newSumBR=1.):
        """
Change branching ratios.
"""
        return _pythia8.ParticleData_rescaleBR(self, idIn, newSumBR)

    def setResonancePtr(self, idIn, resonancePtrIn):
        """
Access methods stored in ResonanceWidths.
"""
        return _pythia8.ParticleData_setResonancePtr(self, idIn, resonancePtrIn)

    def resInit(self, idIn):
        """
"""
        return _pythia8.ParticleData_resInit(self, idIn)

    def resWidth(self, idIn, mHat, idInFlav=0, openOnly=False, setBR=False):
        """
"""
        return _pythia8.ParticleData_resWidth(self, idIn, mHat, idInFlav, openOnly, setBR)

    def resWidthOpen(self, idIn, mHat, idInFlav=0):
        """
"""
        return _pythia8.ParticleData_resWidthOpen(self, idIn, mHat, idInFlav)

    def resWidthStore(self, idIn, mHat, idInFlav=0):
        """
"""
        return _pythia8.ParticleData_resWidthStore(self, idIn, mHat, idInFlav)

    def resOpenFrac(self, id1In, id2In=0, id3In=0):
        """
"""
        return _pythia8.ParticleData_resOpenFrac(self, id1In, id2In, id3In)

    def resWidthRescaleFactor(self, idIn):
        """
"""
        return _pythia8.ParticleData_resWidthRescaleFactor(self, idIn)

    def resWidthChan(self, idIn, mHat, idAbs1=0, idAbs2=0):
        """
"""
        return _pythia8.ParticleData_resWidthChan(self, idIn, mHat, idAbs1, idAbs2)

    def particleDataEntryPtr(self, idIn):
        """
Return pointer to entry.
"""
        return _pythia8.ParticleData_particleDataEntryPtr(self, idIn)

    def getIsInit(self):
        """
Check initialisation status.
"""
        return _pythia8.ParticleData_getIsInit(self)

    def __str__(self):
        return _pythia8.ParticleData___str__(self)
    __swig_destroy__ = _pythia8.delete_ParticleData
    __del__ = lambda self: None
ParticleData_swigregister = _pythia8.ParticleData_swigregister
ParticleData_swigregister(ParticleData)

class PDF(_object):
    """
Base class for parton distribution functions.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PDF, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PDF, name)
    __repr__ = _swig_repr

    def __init__(self, idBeamIn=2212):
        """
Constructor.
"""
        if self.__class__ == PDF:
            _self = None
        else:
            _self = self
        this = _pythia8.new_PDF(_self, idBeamIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_PDF
    __del__ = lambda self: None

    def isSetup(self):
        """
Confirm that PDF has been set up (important for LHAPDF and H1 Pomeron).
"""
        return _pythia8.PDF_isSetup(self)

    def newValenceContent(self, idVal1In, idVal2In):
        """
Dynamic choice of meson valence flavours for pi0, K0S, K0L, Pomeron.
"""
        return _pythia8.PDF_newValenceContent(self, idVal1In, idVal2In)

    def setExtrapolate(self, arg0):
        """
Allow extrapolation beyond boundaries. This is optional.
"""
        return _pythia8.PDF_setExtrapolate(self, arg0)

    def xf(self, id, x, Q2):
        """
Read out parton density.
"""
        return _pythia8.PDF_xf(self, id, x, Q2)

    def xfVal(self, id, x, Q2):
        """
Read out valence and sea part of parton densities.
"""
        return _pythia8.PDF_xfVal(self, id, x, Q2)

    def xfSea(self, id, x, Q2):
        """
"""
        return _pythia8.PDF_xfSea(self, id, x, Q2)

    def insideBounds(self, arg0, arg1):
        """
Check whether x and Q2 values fall inside the fit bounds (LHAPDF6 only).
"""
        return _pythia8.PDF_insideBounds(self, arg0, arg1)

    def alphaS(self, arg0):
        """
Access the running alpha_s of a PDF set (LHAPDF6 only).
"""
        return _pythia8.PDF_alphaS(self, arg0)

    def mQuarkPDF(self, arg0):
        """
Return quark masses used in the PDF fit (LHAPDF6 only).
"""
        return _pythia8.PDF_mQuarkPDF(self, arg0)

    def nMembers(self):
        """
Return number of members of this PDF family (LHAPDF6 only).
"""
        return _pythia8.PDF_nMembers(self)

    def calcPDFEnvelope(self, *args):
        """
"""
        return _pythia8.PDF_calcPDFEnvelope(self, *args)

    def getPDFEnvelope(self):
        """
"""
        return _pythia8.PDF_getPDFEnvelope(self)

    def gammaPDFxDependence(self, arg0, arg1):
        """
Approximate photon PDFs by decoupling the scale and x-dependence.
"""
        return _pythia8.PDF_gammaPDFxDependence(self, arg0, arg1)

    def gammaPDFRefScale(self, arg0):
        """
Provide the reference scale for logarithmic Q^2 evolution for photons.
"""
        return _pythia8.PDF_gammaPDFRefScale(self, arg0)

    def sampleGammaValFlavor(self, arg0):
        """
Sample the valence content for photons.
"""
        return _pythia8.PDF_sampleGammaValFlavor(self, arg0)

    def xfIntegratedTotal(self, arg0):
        """
The total x-integrated PDFs. Relevant for MPIs with photon beams.
"""
        return _pythia8.PDF_xfIntegratedTotal(self, arg0)

    def xGamma(self):
        """
Return the sampled value for x_gamma.
"""
        return _pythia8.PDF_xGamma(self)

    def xPom(self, arg0=-1.0):
        """
Keep track of pomeron momentum fraction.
"""
        return _pythia8.PDF_xPom(self, arg0)

    def xfFlux(self, arg0, arg1, arg2):
        """
Return accurate and approximated photon fluxes and PDFs.
"""
        return _pythia8.PDF_xfFlux(self, arg0, arg1, arg2)

    def xfApprox(self, arg0, arg1, arg2):
        """
"""
        return _pythia8.PDF_xfApprox(self, arg0, arg1, arg2)

    def xfGamma(self, arg0, arg1, arg2):
        """
"""
        return _pythia8.PDF_xfGamma(self, arg0, arg1, arg2)

    def intFluxApprox(self):
        """
"""
        return _pythia8.PDF_intFluxApprox(self)

    def getXmin(self):
        """
Return the kinematical limits and sample Q2 and x.
"""
        return _pythia8.PDF_getXmin(self)

    def getXhadr(self):
        """
"""
        return _pythia8.PDF_getXhadr(self)

    def sampleXgamma(self, arg0):
        """
"""
        return _pythia8.PDF_sampleXgamma(self, arg0)

    def sampleQ2gamma(self, arg0):
        """
"""
        return _pythia8.PDF_sampleQ2gamma(self, arg0)

    def xfMax(self, id, x, Q2):
        """
Normal PDFs unless gamma inside lepton -> an overestimate for sampling.
"""
        return _pythia8.PDF_xfMax(self, id, x, Q2)

    def xfSame(self, id, x, Q2):
        """
Normal PDFs unless gamma inside lepton -> Do not sample x_gamma.
"""
        return _pythia8.PDF_xfSame(self, id, x, Q2)

    def setVMDscale(self, arg0=1.):
        """
Allow for new scaling factor for VMD PDFs.
"""
        return _pythia8.PDF_setVMDscale(self, arg0)
    __swig_setmethods__["idBeam"] = _pythia8.PDF_idBeam_set
    __swig_getmethods__["idBeam"] = _pythia8.PDF_idBeam_get
    if _newclass:
        idBeam = _swig_property(_pythia8.PDF_idBeam_get, _pythia8.PDF_idBeam_set)
    __swig_setmethods__["idBeamAbs"] = _pythia8.PDF_idBeamAbs_set
    __swig_getmethods__["idBeamAbs"] = _pythia8.PDF_idBeamAbs_get
    if _newclass:
        idBeamAbs = _swig_property(_pythia8.PDF_idBeamAbs_get, _pythia8.PDF_idBeamAbs_set)
    __swig_setmethods__["idSav"] = _pythia8.PDF_idSav_set
    __swig_getmethods__["idSav"] = _pythia8.PDF_idSav_get
    if _newclass:
        idSav = _swig_property(_pythia8.PDF_idSav_get, _pythia8.PDF_idSav_set)
    __swig_setmethods__["idVal1"] = _pythia8.PDF_idVal1_set
    __swig_getmethods__["idVal1"] = _pythia8.PDF_idVal1_get
    if _newclass:
        idVal1 = _swig_property(_pythia8.PDF_idVal1_get, _pythia8.PDF_idVal1_set)
    __swig_setmethods__["idVal2"] = _pythia8.PDF_idVal2_set
    __swig_getmethods__["idVal2"] = _pythia8.PDF_idVal2_get
    if _newclass:
        idVal2 = _swig_property(_pythia8.PDF_idVal2_get, _pythia8.PDF_idVal2_set)
    __swig_setmethods__["xSav"] = _pythia8.PDF_xSav_set
    __swig_getmethods__["xSav"] = _pythia8.PDF_xSav_get
    if _newclass:
        xSav = _swig_property(_pythia8.PDF_xSav_get, _pythia8.PDF_xSav_set)
    __swig_setmethods__["Q2Sav"] = _pythia8.PDF_Q2Sav_set
    __swig_getmethods__["Q2Sav"] = _pythia8.PDF_Q2Sav_get
    if _newclass:
        Q2Sav = _swig_property(_pythia8.PDF_Q2Sav_get, _pythia8.PDF_Q2Sav_set)
    __swig_setmethods__["xu"] = _pythia8.PDF_xu_set
    __swig_getmethods__["xu"] = _pythia8.PDF_xu_get
    if _newclass:
        xu = _swig_property(_pythia8.PDF_xu_get, _pythia8.PDF_xu_set)
    __swig_setmethods__["xd"] = _pythia8.PDF_xd_set
    __swig_getmethods__["xd"] = _pythia8.PDF_xd_get
    if _newclass:
        xd = _swig_property(_pythia8.PDF_xd_get, _pythia8.PDF_xd_set)
    __swig_setmethods__["xs"] = _pythia8.PDF_xs_set
    __swig_getmethods__["xs"] = _pythia8.PDF_xs_get
    if _newclass:
        xs = _swig_property(_pythia8.PDF_xs_get, _pythia8.PDF_xs_set)
    __swig_setmethods__["xubar"] = _pythia8.PDF_xubar_set
    __swig_getmethods__["xubar"] = _pythia8.PDF_xubar_get
    if _newclass:
        xubar = _swig_property(_pythia8.PDF_xubar_get, _pythia8.PDF_xubar_set)
    __swig_setmethods__["xdbar"] = _pythia8.PDF_xdbar_set
    __swig_getmethods__["xdbar"] = _pythia8.PDF_xdbar_get
    if _newclass:
        xdbar = _swig_property(_pythia8.PDF_xdbar_get, _pythia8.PDF_xdbar_set)
    __swig_setmethods__["xsbar"] = _pythia8.PDF_xsbar_set
    __swig_getmethods__["xsbar"] = _pythia8.PDF_xsbar_get
    if _newclass:
        xsbar = _swig_property(_pythia8.PDF_xsbar_get, _pythia8.PDF_xsbar_set)
    __swig_setmethods__["xc"] = _pythia8.PDF_xc_set
    __swig_getmethods__["xc"] = _pythia8.PDF_xc_get
    if _newclass:
        xc = _swig_property(_pythia8.PDF_xc_get, _pythia8.PDF_xc_set)
    __swig_setmethods__["xb"] = _pythia8.PDF_xb_set
    __swig_getmethods__["xb"] = _pythia8.PDF_xb_get
    if _newclass:
        xb = _swig_property(_pythia8.PDF_xb_get, _pythia8.PDF_xb_set)
    __swig_setmethods__["xg"] = _pythia8.PDF_xg_set
    __swig_getmethods__["xg"] = _pythia8.PDF_xg_get
    if _newclass:
        xg = _swig_property(_pythia8.PDF_xg_get, _pythia8.PDF_xg_set)
    __swig_setmethods__["xlepton"] = _pythia8.PDF_xlepton_set
    __swig_getmethods__["xlepton"] = _pythia8.PDF_xlepton_get
    if _newclass:
        xlepton = _swig_property(_pythia8.PDF_xlepton_get, _pythia8.PDF_xlepton_set)
    __swig_setmethods__["xgamma"] = _pythia8.PDF_xgamma_set
    __swig_getmethods__["xgamma"] = _pythia8.PDF_xgamma_get
    if _newclass:
        xgamma = _swig_property(_pythia8.PDF_xgamma_get, _pythia8.PDF_xgamma_set)
    __swig_setmethods__["xuVal"] = _pythia8.PDF_xuVal_set
    __swig_getmethods__["xuVal"] = _pythia8.PDF_xuVal_get
    if _newclass:
        xuVal = _swig_property(_pythia8.PDF_xuVal_get, _pythia8.PDF_xuVal_set)
    __swig_setmethods__["xuSea"] = _pythia8.PDF_xuSea_set
    __swig_getmethods__["xuSea"] = _pythia8.PDF_xuSea_get
    if _newclass:
        xuSea = _swig_property(_pythia8.PDF_xuSea_get, _pythia8.PDF_xuSea_set)
    __swig_setmethods__["xdVal"] = _pythia8.PDF_xdVal_set
    __swig_getmethods__["xdVal"] = _pythia8.PDF_xdVal_get
    if _newclass:
        xdVal = _swig_property(_pythia8.PDF_xdVal_get, _pythia8.PDF_xdVal_set)
    __swig_setmethods__["xdSea"] = _pythia8.PDF_xdSea_set
    __swig_getmethods__["xdSea"] = _pythia8.PDF_xdSea_get
    if _newclass:
        xdSea = _swig_property(_pythia8.PDF_xdSea_get, _pythia8.PDF_xdSea_set)
    __swig_setmethods__["isSet"] = _pythia8.PDF_isSet_set
    __swig_getmethods__["isSet"] = _pythia8.PDF_isSet_get
    if _newclass:
        isSet = _swig_property(_pythia8.PDF_isSet_get, _pythia8.PDF_isSet_set)
    __swig_setmethods__["isInit"] = _pythia8.PDF_isInit_set
    __swig_getmethods__["isInit"] = _pythia8.PDF_isInit_get
    if _newclass:
        isInit = _swig_property(_pythia8.PDF_isInit_get, _pythia8.PDF_isInit_set)
    __swig_setmethods__["xsVal"] = _pythia8.PDF_xsVal_set
    __swig_getmethods__["xsVal"] = _pythia8.PDF_xsVal_get
    if _newclass:
        xsVal = _swig_property(_pythia8.PDF_xsVal_get, _pythia8.PDF_xsVal_set)
    __swig_setmethods__["xcVal"] = _pythia8.PDF_xcVal_set
    __swig_getmethods__["xcVal"] = _pythia8.PDF_xcVal_get
    if _newclass:
        xcVal = _swig_property(_pythia8.PDF_xcVal_get, _pythia8.PDF_xcVal_set)
    __swig_setmethods__["xbVal"] = _pythia8.PDF_xbVal_set
    __swig_getmethods__["xbVal"] = _pythia8.PDF_xbVal_get
    if _newclass:
        xbVal = _swig_property(_pythia8.PDF_xbVal_get, _pythia8.PDF_xbVal_set)
    __swig_setmethods__["xsSea"] = _pythia8.PDF_xsSea_set
    __swig_getmethods__["xsSea"] = _pythia8.PDF_xsSea_get
    if _newclass:
        xsSea = _swig_property(_pythia8.PDF_xsSea_get, _pythia8.PDF_xsSea_set)
    __swig_setmethods__["xcSea"] = _pythia8.PDF_xcSea_set
    __swig_getmethods__["xcSea"] = _pythia8.PDF_xcSea_get
    if _newclass:
        xcSea = _swig_property(_pythia8.PDF_xcSea_get, _pythia8.PDF_xcSea_set)
    __swig_setmethods__["xbSea"] = _pythia8.PDF_xbSea_set
    __swig_getmethods__["xbSea"] = _pythia8.PDF_xbSea_get
    if _newclass:
        xbSea = _swig_property(_pythia8.PDF_xbSea_get, _pythia8.PDF_xbSea_set)
    __swig_setmethods__["hasGammaInLepton"] = _pythia8.PDF_hasGammaInLepton_set
    __swig_getmethods__["hasGammaInLepton"] = _pythia8.PDF_hasGammaInLepton_get
    if _newclass:
        hasGammaInLepton = _swig_property(_pythia8.PDF_hasGammaInLepton_get, _pythia8.PDF_hasGammaInLepton_set)

    def setValenceContent(self):
        """
"""
        return _pythia8.PDF_setValenceContent(self)

    def xfUpdate(self, id, x, Q2):
        return _pythia8.PDF_xfUpdate(self, id, x, Q2)

    def printErr(self, errMsg, infoPtr=None):
        return _pythia8.PDF_printErr(self, errMsg, infoPtr)
    def __disown__(self):
        self.this.disown()
        _pythia8.disown_PDF(self)
        return weakref_proxy(self)
PDF_swigregister = _pythia8.PDF_swigregister
PDF_swigregister(PDF)

class GRV94L(PDF):
    """
Gives the GRV 94L (leading order) parton distribution function set
in parametrized form. Authors: M. Glueck, E. Reya and A. Vogt.
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GRV94L, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GRV94L, name)
    __repr__ = _swig_repr

    def __init__(self, idBeamIn=2212):
        """
Constructor.
"""
        this = _pythia8.new_GRV94L(idBeamIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_GRV94L
    __del__ = lambda self: None
GRV94L_swigregister = _pythia8.GRV94L_swigregister
GRV94L_swigregister(GRV94L)

class CTEQ5L(PDF):
    """
Gives the CTEQ 5L (leading order) parton distribution function set
in parametrized form. Parametrization by J. Pumplin. Authors: CTEQ.
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CTEQ5L, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CTEQ5L, name)
    __repr__ = _swig_repr

    def __init__(self, idBeamIn=2212):
        """
Constructor.
"""
        this = _pythia8.new_CTEQ5L(idBeamIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_CTEQ5L
    __del__ = lambda self: None
CTEQ5L_swigregister = _pythia8.CTEQ5L_swigregister
CTEQ5L_swigregister(CTEQ5L)

class MSTWpdf(PDF):
    """
The MSTWpdf class.
MRST LO*(*) and MSTW 2008 PDF's, specifically the LO one.
Original C++ version by Jeppe Andersen.
Modified by Graeme Watt <watt(at)hep.ucl.ac.uk>.
Sets available:
iFit = 1 : MRST LO*  (2007).
iFit = 2 : MRST LO** (2008).
iFit = 3 : MSTW 2008 LO, central member.
iFit = 4 : MSTW 2008 NLO, central member. (Warning!)
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, MSTWpdf, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, MSTWpdf, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor with a stream.
"""
        this = _pythia8.new_MSTWpdf(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_MSTWpdf
    __del__ = lambda self: None
MSTWpdf_swigregister = _pythia8.MSTWpdf_swigregister
MSTWpdf_swigregister(MSTWpdf)

class CTEQ6pdf(PDF):
    """
The CTEQ6pdf class.
Proton sets available:
iFit = 1 : CTEQ6L
iFit = 2 : CTEQ6L1
iFit = 3 : CTEQ66.00 (NLO, central member)
iFit = 4 : CT09MC1
iFit = 5 : CT09MC2
iFit = 6 : CT09MCS
Pomeron sets available (uses same .pds file format as CTEQ6pdf) :
iFit = 11: ACTWB14
iFit = 12: ACTWD14
iFit = 13: ACTWSG14
iFit = 14: ACTWD19
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CTEQ6pdf, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CTEQ6pdf, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor with a stream.
"""
        this = _pythia8.new_CTEQ6pdf(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def setExtrapolate(self, doExtraPolIn):
        """
Allow extrapolation beyond boundaries. This is optional.
"""
        return _pythia8.CTEQ6pdf_setExtrapolate(self, doExtraPolIn)
    __swig_destroy__ = _pythia8.delete_CTEQ6pdf
    __del__ = lambda self: None
CTEQ6pdf_swigregister = _pythia8.CTEQ6pdf_swigregister
CTEQ6pdf_swigregister(CTEQ6pdf)

class ProtonPoint(PDF):
    """
SA Unresolved proton: equivalent photon spectrum from
V.M. Budnev, I.F. Ginzburg, G.V. Meledin and V.G. Serbo,
Phys. Rept. 15 (1974/1975) 181.
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ProtonPoint, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ProtonPoint, name)
    __repr__ = _swig_repr

    def __init__(self, idBeamIn=2212, infoPtrIn=None):
        """
Constructor.
"""
        this = _pythia8.new_ProtonPoint(idBeamIn, infoPtrIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ProtonPoint
    __del__ = lambda self: None
ProtonPoint_swigregister = _pythia8.ProtonPoint_swigregister
ProtonPoint_swigregister(ProtonPoint)

class GRVpiL(PDF):
    """
Gives the GRV 1992 pi+ (leading order) parton distribution function set
in parametrized form. Authors: Glueck, Reya and Vogt.
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GRVpiL, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GRVpiL, name)
    __repr__ = _swig_repr

    def __init__(self, idBeamIn=211, rescaleIn=1.):
        """
Constructor.
"""
        this = _pythia8.new_GRVpiL(idBeamIn, rescaleIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def setVMDscale(self, rescaleIn=1.):
        """
Allow for new rescaling factor of the PDF for VMD beams.
"""
        return _pythia8.GRVpiL_setVMDscale(self, rescaleIn)
    __swig_destroy__ = _pythia8.delete_GRVpiL
    __del__ = lambda self: None
GRVpiL_swigregister = _pythia8.GRVpiL_swigregister
GRVpiL_swigregister(GRVpiL)

class PomFix(PDF):
    """
Gives generic Q2-independent Pomeron PDF.
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PomFix, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PomFix, name)
    __repr__ = _swig_repr

    def __init__(self, idBeamIn=990, PomGluonAIn=0., PomGluonBIn=0., PomQuarkAIn=0., PomQuarkBIn=0., PomQuarkFracIn=0., PomStrangeSuppIn=0.):
        """
Constructor.
"""
        this = _pythia8.new_PomFix(idBeamIn, PomGluonAIn, PomGluonBIn, PomQuarkAIn, PomQuarkBIn, PomQuarkFracIn, PomStrangeSuppIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_PomFix
    __del__ = lambda self: None
PomFix_swigregister = _pythia8.PomFix_swigregister
PomFix_swigregister(PomFix)

class PomH1FitAB(PDF):
    """
The H1 2006 Fit A and Fit B Pomeron parametrization.
H1 Collaboration, A. Aktas et al., "Measurement and QCD Analysis of
the Diffractive Deep-Inelastic Scattering Cross Section at HERA",
DESY-06-049, Eur. Phys. J. C48 (2006) 715. e-Print: hep-ex/0606004.
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PomH1FitAB, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PomH1FitAB, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor with a stream.
"""
        this = _pythia8.new_PomH1FitAB(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def setExtrapolate(self, doExtraPolIn):
        """
Allow extrapolation beyond boundaries. This is optional.
"""
        return _pythia8.PomH1FitAB_setExtrapolate(self, doExtraPolIn)
    __swig_destroy__ = _pythia8.delete_PomH1FitAB
    __del__ = lambda self: None
PomH1FitAB_swigregister = _pythia8.PomH1FitAB_swigregister
PomH1FitAB_swigregister(PomH1FitAB)

class PomH1Jets(PDF):
    """
The H1 2007 Jets Pomeron parametrization..
H1 Collaboration, A. Aktas et al., "Dijet Cross Sections and Parton
Densities in Diffractive DIS at HERA", DESY-07-115, Aug 2007. 33pp.
Published in JHEP 0710:042,2007. e-Print: arXiv:0708.3217 [hep-ex]
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PomH1Jets, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PomH1Jets, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor with a stream.
"""
        this = _pythia8.new_PomH1Jets(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def setExtrapolate(self, doExtraPolIn):
        """
Allow extrapolation beyond boundaries. This is optional.
"""
        return _pythia8.PomH1Jets_setExtrapolate(self, doExtraPolIn)
    __swig_destroy__ = _pythia8.delete_PomH1Jets
    __del__ = lambda self: None
PomH1Jets_swigregister = _pythia8.PomH1Jets_swigregister
PomH1Jets_swigregister(PomH1Jets)

class PomHISASD(PDF):
    """
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PomHISASD, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PomHISASD, name)
    __repr__ = _swig_repr

    def __init__(self, idBeamIn, ppdf, settings, infoPtrIn=None):
        """
Basic constructor
"""
        this = _pythia8.new_PomHISASD(idBeamIn, ppdf, settings, infoPtrIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_PomHISASD
    __del__ = lambda self: None

    def xPom(self, xpom=-1.0):
        """
(re-)Set the x_pomeron value.
"""
        return _pythia8.PomHISASD_xPom(self, xpom)
PomHISASD_swigregister = _pythia8.PomHISASD_swigregister
PomHISASD_swigregister(PomHISASD)

class Lepton(PDF):
    """
Gives electron (or muon, or tau) parton distribution.
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Lepton, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Lepton, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor with further info.
"""
        this = _pythia8.new_Lepton(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sampleQ2gamma(self, Q2min):
        """
Sample the Q2 value.
"""
        return _pythia8.Lepton_sampleQ2gamma(self, Q2min)
    __swig_destroy__ = _pythia8.delete_Lepton
    __del__ = lambda self: None
Lepton_swigregister = _pythia8.Lepton_swigregister
Lepton_swigregister(Lepton)

class LeptonPoint(PDF):
    """
Gives electron (or other lepton) parton distribution when unresolved.
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LeptonPoint, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LeptonPoint, name)
    __repr__ = _swig_repr

    def __init__(self, idBeamIn=11):
        """
Constructor.
"""
        this = _pythia8.new_LeptonPoint(idBeamIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_LeptonPoint
    __del__ = lambda self: None
LeptonPoint_swigregister = _pythia8.LeptonPoint_swigregister
LeptonPoint_swigregister(LeptonPoint)

class NeutrinoPoint(PDF):
    """
Gives neutrino parton distribution when unresolved (only choice for now).
Note factor of 2 since only lefthanded implies no spin averaging.
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NeutrinoPoint, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NeutrinoPoint, name)
    __repr__ = _swig_repr

    def __init__(self, idBeamIn=12):
        """
Constructor.
"""
        this = _pythia8.new_NeutrinoPoint(idBeamIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_NeutrinoPoint
    __del__ = lambda self: None
NeutrinoPoint_swigregister = _pythia8.NeutrinoPoint_swigregister
NeutrinoPoint_swigregister(NeutrinoPoint)

class NNPDF(PDF):
    """
The NNPDF class.
Sets available:
Leading order QCD+QED Proton PDF sets
iFit = 1 : NNPDF2.3 QCD+QED LO, alphas(MZ) = 0.130
iFit = 2 : NNPDF2.3 QCD+QED LO, alphas(MZ) = 0.119
(Next-to-)Next-to-Leading order QCD+QED Proton PDF sets
iFit = 3 : NNPDF2.3 QCD+QED NLO, alphas(MZ) = 0.119
iFit = 4 : NNPDF2.3 QCD+QED NNLO, alphas(MZ) = 0.119
Code provided by Juan Rojo and Stefano Carrazza.
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, NNPDF, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, NNPDF, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor with a stream.
"""
        this = _pythia8.new_NNPDF(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_NNPDF
    __del__ = lambda self: None
NNPDF_swigregister = _pythia8.NNPDF_swigregister
NNPDF_swigregister(NNPDF)

class LHAPDF(PDF):
    """
LHAPDF plugin interface class.
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHAPDF, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LHAPDF, name)
    __repr__ = _swig_repr

    def __init__(self, idIn, pSet, infoPtrIn):
        """
Constructor and destructor.
"""
        this = _pythia8.new_LHAPDF(idIn, pSet, infoPtrIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_LHAPDF
    __del__ = lambda self: None

    def isSetup(self):
        """
Confirm that PDF has been set up.
"""
        return _pythia8.LHAPDF_isSetup(self)

    def newValenceContent(self, idVal1In, idVal2In):
        """
Dynamic choice of meson valence flavours for pi0, K0S, K0L, Pomeron.
"""
        return _pythia8.LHAPDF_newValenceContent(self, idVal1In, idVal2In)

    def setExtrapolate(self, extrapolate):
        """
Allow extrapolation beyond boundaries.
"""
        return _pythia8.LHAPDF_setExtrapolate(self, extrapolate)

    def xf(self, id, x, Q2):
        """
Read out parton density
"""
        return _pythia8.LHAPDF_xf(self, id, x, Q2)

    def xfVal(self, id, x, Q2):
        """
Read out valence and sea part of parton densities.
"""
        return _pythia8.LHAPDF_xfVal(self, id, x, Q2)

    def xfSea(self, id, x, Q2):
        """
"""
        return _pythia8.LHAPDF_xfSea(self, id, x, Q2)

    def insideBounds(self, x, Q2):
        """
Check whether x and Q2 values fall inside the fit bounds (LHAPDF6 only).
"""
        return _pythia8.LHAPDF_insideBounds(self, x, Q2)

    def alphaS(self, Q2):
        """
Access the running alpha_s of a PDF set (LHAPDF6 only).
"""
        return _pythia8.LHAPDF_alphaS(self, Q2)

    def mQuarkPDF(self, idIn):
        """
Return quark masses used in the PDF fit (LHAPDF6 only).
"""
        return _pythia8.LHAPDF_mQuarkPDF(self, idIn)

    def nMembers(self):
        """
Return quark masses used in the PDF fit (LHAPDF6 only).
"""
        return _pythia8.LHAPDF_nMembers(self)

    def calcPDFEnvelope(self, *args):
        """
"""
        return _pythia8.LHAPDF_calcPDFEnvelope(self, *args)

    def getPDFEnvelope(self):
        """
"""
        return _pythia8.LHAPDF_getPDFEnvelope(self)
LHAPDF_swigregister = _pythia8.LHAPDF_swigregister
LHAPDF_swigregister(LHAPDF)

class CJKL(PDF):
    """
Gives the CJKL leading order parton distribution function set
in parametrized form for the real photons. Authors: F.Cornet, P.Jankowski,
M.Krawczyk and A.Lorca, Phys. Rev. D68: 014010, 2003.
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, CJKL, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, CJKL, name)
    __repr__ = _swig_repr

    def __init__(self, idBeamIn=22, rndmPtrIn=None):
        """
Constructor. Needs the randon number generator to sample valence content.
"""
        this = _pythia8.new_CJKL(idBeamIn, rndmPtrIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def gammaPDFxDependence(self, id, arg3):
        """
Functions to approximate pdfs for ISR.
"""
        return _pythia8.CJKL_gammaPDFxDependence(self, id, arg3)

    def gammaPDFRefScale(self, arg2):
        """
"""
        return _pythia8.CJKL_gammaPDFRefScale(self, arg2)

    def sampleGammaValFlavor(self, Q2):
        """
Set the valence content for photons.
"""
        return _pythia8.CJKL_sampleGammaValFlavor(self, Q2)

    def xfIntegratedTotal(self, Q2):
        """
The total x-integrated PDFs. Relevant for MPIs with photon beams.
"""
        return _pythia8.CJKL_xfIntegratedTotal(self, Q2)
    __swig_destroy__ = _pythia8.delete_CJKL
    __del__ = lambda self: None
CJKL_swigregister = _pythia8.CJKL_swigregister
CJKL_swigregister(CJKL)

class LHAGrid1(PDF):
    """
The LHAGrid1 can be used to read files in the LHAPDF6 lhagrid1 format,
assuming that the same x grid is used for all Q subgrids.
Results are not identical with LHAPDF6, owing to different interpolation.
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHAGrid1, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LHAGrid1, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor with a stream.
"""
        this = _pythia8.new_LHAGrid1(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_LHAGrid1
    __del__ = lambda self: None

    def setExtrapolate(self, doExtraPolIn):
        """
Allow extrapolation beyond boundaries. This is optional.
"""
        return _pythia8.LHAGrid1_setExtrapolate(self, doExtraPolIn)
LHAGrid1_swigregister = _pythia8.LHAGrid1_swigregister
LHAGrid1_swigregister(LHAGrid1)

class Lepton2gamma(PDF):
    """
Convolution with photon flux from leptons and photon PDFs.
Photon flux from equivalent photon approximation (EPA).
Contains a pointer to a photon PDF set and samples the
convolution integral event-by-event basis.
Includes also a overestimate for the PDF set in order to set up
the phase-space sampling correctly.
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Lepton2gamma, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Lepton2gamma, name)
    __repr__ = _swig_repr

    def __init__(self, idBeamIn, m2leptonIn, Q2maxGamma, gammaPDFPtrIn, infoPtrIn, rndmPtrIn):
        """
Constructor.
"""
        this = _pythia8.new_Lepton2gamma(idBeamIn, m2leptonIn, Q2maxGamma, gammaPDFPtrIn, infoPtrIn, rndmPtrIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def xfUpdate(self, id, x, Q2):
        """
Overload the member function definitions where relevant.
"""
        return _pythia8.Lepton2gamma_xfUpdate(self, id, x, Q2)

    def xGamma(self):
        """
"""
        return _pythia8.Lepton2gamma_xGamma(self)

    def xfMax(self, id, x, Q2):
        """
"""
        return _pythia8.Lepton2gamma_xfMax(self, id, x, Q2)

    def xfSame(self, id, x, Q2):
        """
"""
        return _pythia8.Lepton2gamma_xfSame(self, id, x, Q2)

    def sampleQ2gamma(self, Q2min):
        """
Sample the Q2 value.
"""
        return _pythia8.Lepton2gamma_sampleQ2gamma(self, Q2min)
    __swig_destroy__ = _pythia8.delete_Lepton2gamma
    __del__ = lambda self: None
Lepton2gamma_swigregister = _pythia8.Lepton2gamma_swigregister
Lepton2gamma_swigregister(Lepton2gamma)

class GammaPoint(PDF):
    """
Gives electron (or other lepton) parton distribution when unresolved.
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, GammaPoint, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, GammaPoint, name)
    __repr__ = _swig_repr

    def __init__(self, idBeamIn=22):
        """
Constructor.
"""
        this = _pythia8.new_GammaPoint(idBeamIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_GammaPoint
    __del__ = lambda self: None
GammaPoint_swigregister = _pythia8.GammaPoint_swigregister
GammaPoint_swigregister(GammaPoint)

class EPAexternal(PDF):
    """
Equivalent photon approximation for sampling with external photon flux.
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EPAexternal, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EPAexternal, name)
    __repr__ = _swig_repr

    def __init__(self, idBeamIn, m2In, gammaFluxPtrIn, gammaPDFPtrIn, settingsPtrIn, infoPtrIn, rndmPtrIn):
        """
Constructor.
"""
        this = _pythia8.new_EPAexternal(idBeamIn, m2In, gammaFluxPtrIn, gammaPDFPtrIn, settingsPtrIn, infoPtrIn, rndmPtrIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def xfUpdate(self, arg2, x, Q2):
        """
Update PDFs.
"""
        return _pythia8.EPAexternal_xfUpdate(self, arg2, x, Q2)

    def xfFlux(self, id, x, Q2=1.):
        """
External flux and photon PDFs, and approximated flux for sampling.
"""
        return _pythia8.EPAexternal_xfFlux(self, id, x, Q2)

    def xfGamma(self, id, x, Q2):
        """
"""
        return _pythia8.EPAexternal_xfGamma(self, id, x, Q2)

    def xfApprox(self, id, x, Q2):
        """
"""
        return _pythia8.EPAexternal_xfApprox(self, id, x, Q2)

    def intFluxApprox(self):
        """
"""
        return _pythia8.EPAexternal_intFluxApprox(self)

    def getXmin(self):
        """
Kinematics.
"""
        return _pythia8.EPAexternal_getXmin(self)

    def getXhadr(self):
        """
"""
        return _pythia8.EPAexternal_getXhadr(self)

    def sampleXgamma(self, xMinIn):
        """
Sampling of the x and Q2 according to differential flux.
"""
        return _pythia8.EPAexternal_sampleXgamma(self, xMinIn)

    def sampleQ2gamma(self, arg2):
        """
"""
        return _pythia8.EPAexternal_sampleQ2gamma(self, arg2)
    __swig_destroy__ = _pythia8.delete_EPAexternal
    __del__ = lambda self: None
EPAexternal_swigregister = _pythia8.EPAexternal_swigregister
EPAexternal_swigregister(EPAexternal)

class nPDF(PDF):
    """
A derived class for nuclear PDFs. Needs a pointer for (free) proton PDFs.
"""
    __swig_setmethods__ = {}
    for _s in [PDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, nPDF, name, value)
    __swig_getmethods__ = {}
    for _s in [PDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, nPDF, name)

    def __init__(self, *args, **kwargs):
        """
Constructor.
"""
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def xfUpdate(self, id, x, Q2):
        """
Update parton densities.
"""
        return _pythia8.nPDF_xfUpdate(self, id, x, Q2)

    def rUpdate(self, arg2, arg3, arg4):
        """
Update nuclear modifications.
"""
        return _pythia8.nPDF_rUpdate(self, arg2, arg3, arg4)

    def initNPDF(self, protonPDFPtrIn=None):
        """
Initialize the nPDF-related members.
"""
        return _pythia8.nPDF_initNPDF(self, protonPDFPtrIn)

    def getA(self):
        """
Return the number of protons and nucleons.
"""
        return _pythia8.nPDF_getA(self)

    def getZ(self):
        """
"""
        return _pythia8.nPDF_getZ(self)

    def setMode(self, zaIn):
        """
Set (and reset) the ratio of protons to nucleons to study nuclear
modifications of protons (= 1.0) and neutrons (= 0.0). By default Z/A.
"""
        return _pythia8.nPDF_setMode(self, zaIn)

    def resetMode(self):
        """
"""
        return _pythia8.nPDF_resetMode(self)
    __swig_destroy__ = _pythia8.delete_nPDF
    __del__ = lambda self: None
nPDF_swigregister = _pythia8.nPDF_swigregister
nPDF_swigregister(nPDF)

class Isospin(nPDF):
    """
Isospin modification with nuclear beam, i.e. no other modifications
but correct number of protons and neutrons.
"""
    __swig_setmethods__ = {}
    for _s in [nPDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Isospin, name, value)
    __swig_getmethods__ = {}
    for _s in [nPDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Isospin, name)
    __repr__ = _swig_repr

    def __init__(self, idBeamIn=2212, protonPDFPtrIn=None):
        """
Constructor.
"""
        this = _pythia8.new_Isospin(idBeamIn, protonPDFPtrIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def rUpdate(self, arg2, arg3, arg4):
        """
Only the Isospin effect so no need to do anything here.
"""
        return _pythia8.Isospin_rUpdate(self, arg2, arg3, arg4)
    __swig_destroy__ = _pythia8.delete_Isospin
    __del__ = lambda self: None
Isospin_swigregister = _pythia8.Isospin_swigregister
Isospin_swigregister(Isospin)

class EPS09(nPDF):
    """
Nuclear modifications from EPS09 fit.
"""
    __swig_setmethods__ = {}
    for _s in [nPDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EPS09, name, value)
    __swig_getmethods__ = {}
    for _s in [nPDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EPS09, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor.
"""
        this = _pythia8.new_EPS09(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def rUpdate(self, id, x, Q2):
        """
Update parton densities.
"""
        return _pythia8.EPS09_rUpdate(self, id, x, Q2)

    def setErrorSet(self, iSetIn):
        """
Use other than central set to study uncertainties.
"""
        return _pythia8.EPS09_setErrorSet(self, iSetIn)
    __swig_destroy__ = _pythia8.delete_EPS09
    __del__ = lambda self: None
EPS09_swigregister = _pythia8.EPS09_swigregister
EPS09_swigregister(EPS09)

class EPPS16(nPDF):
    """
Nuclear modifications from EPPS16 fit.
"""
    __swig_setmethods__ = {}
    for _s in [nPDF]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, EPPS16, name, value)
    __swig_getmethods__ = {}
    for _s in [nPDF]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, EPPS16, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor.
"""
        this = _pythia8.new_EPPS16(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def rUpdate(self, id, x, Q2):
        """
Update parton densities.
"""
        return _pythia8.EPPS16_rUpdate(self, id, x, Q2)

    def setErrorSet(self, iSetIn):
        """
Use other than central set to study uncertainties.
"""
        return _pythia8.EPPS16_setErrorSet(self, iSetIn)
    __swig_destroy__ = _pythia8.delete_EPPS16
    __del__ = lambda self: None
EPPS16_swigregister = _pythia8.EPPS16_swigregister
EPPS16_swigregister(EPPS16)

class ResonanceWidths(_object):
    """
The ResonanceWidths is the base class. Also used for generic resonaces.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceWidths, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceWidths, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _pythia8.delete_ResonanceWidths
    __del__ = lambda self: None

    def initBasic(self, idResIn, isGenericIn=False):
        """
Set up standard properties.
"""
        return _pythia8.ResonanceWidths_initBasic(self, idResIn, isGenericIn)

    def init(self, infoPtrIn, settingsPtrIn, particleDataPtrIn, couplingsPtrIn):
        """
Calculate and store partial and total widths at the nominal mass.
"""
        return _pythia8.ResonanceWidths_init(self, infoPtrIn, settingsPtrIn, particleDataPtrIn, couplingsPtrIn)

    def id(self):
        """
Return identity of particle species.
"""
        return _pythia8.ResonanceWidths_id(self)

    def width(self, idSgn, mHatIn, idInFlavIn=0, openOnly=False, setBR=False, idOutFlav1=0, idOutFlav2=0):
        """
"""
        return _pythia8.ResonanceWidths_width(self, idSgn, mHatIn, idInFlavIn, openOnly, setBR, idOutFlav1, idOutFlav2)

    def widthOpen(self, idSgn, mHatIn, idIn=0):
        """
Special case to calculate open final-state width.
"""
        return _pythia8.ResonanceWidths_widthOpen(self, idSgn, mHatIn, idIn)

    def widthStore(self, idSgn, mHatIn, idIn=0):
        """
Special case to store open final-state widths for channel selection.
"""
        return _pythia8.ResonanceWidths_widthStore(self, idSgn, mHatIn, idIn)

    def openFrac(self, idSgn):
        """
Return fraction of width open for particle and antiparticle.
"""
        return _pythia8.ResonanceWidths_openFrac(self, idSgn)

    def widthRescaleFactor(self):
        """
Return forced rescaling factor of resonance width.
"""
        return _pythia8.ResonanceWidths_widthRescaleFactor(self)

    def widthChan(self, mHatIn, idOutFlav1, idOutFlav2):
        """
Special case to calculate one final-state width.
Currently only used for Higgs -> qqbar, g g or gamma gamma.
"""
        return _pythia8.ResonanceWidths_widthChan(self, mHatIn, idOutFlav1, idOutFlav2)

    def __init__(self):
        """
Constructor.
"""
        if self.__class__ == ResonanceWidths:
            _self = None
        else:
            _self = self
        this = _pythia8.new_ResonanceWidths(_self, )
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["idRes"] = _pythia8.ResonanceWidths_idRes_set
    __swig_getmethods__["idRes"] = _pythia8.ResonanceWidths_idRes_get
    if _newclass:
        idRes = _swig_property(_pythia8.ResonanceWidths_idRes_get, _pythia8.ResonanceWidths_idRes_set)
    __swig_setmethods__["hasAntiRes"] = _pythia8.ResonanceWidths_hasAntiRes_set
    __swig_getmethods__["hasAntiRes"] = _pythia8.ResonanceWidths_hasAntiRes_get
    if _newclass:
        hasAntiRes = _swig_property(_pythia8.ResonanceWidths_hasAntiRes_get, _pythia8.ResonanceWidths_hasAntiRes_set)
    __swig_setmethods__["doForceWidth"] = _pythia8.ResonanceWidths_doForceWidth_set
    __swig_getmethods__["doForceWidth"] = _pythia8.ResonanceWidths_doForceWidth_get
    if _newclass:
        doForceWidth = _swig_property(_pythia8.ResonanceWidths_doForceWidth_get, _pythia8.ResonanceWidths_doForceWidth_set)
    __swig_setmethods__["isGeneric"] = _pythia8.ResonanceWidths_isGeneric_set
    __swig_getmethods__["isGeneric"] = _pythia8.ResonanceWidths_isGeneric_get
    if _newclass:
        isGeneric = _swig_property(_pythia8.ResonanceWidths_isGeneric_get, _pythia8.ResonanceWidths_isGeneric_set)
    __swig_setmethods__["allowCalcWidth"] = _pythia8.ResonanceWidths_allowCalcWidth_set
    __swig_getmethods__["allowCalcWidth"] = _pythia8.ResonanceWidths_allowCalcWidth_get
    if _newclass:
        allowCalcWidth = _swig_property(_pythia8.ResonanceWidths_allowCalcWidth_get, _pythia8.ResonanceWidths_allowCalcWidth_set)
    __swig_setmethods__["minWidth"] = _pythia8.ResonanceWidths_minWidth_set
    __swig_getmethods__["minWidth"] = _pythia8.ResonanceWidths_minWidth_get
    if _newclass:
        minWidth = _swig_property(_pythia8.ResonanceWidths_minWidth_get, _pythia8.ResonanceWidths_minWidth_set)
    __swig_setmethods__["minThreshold"] = _pythia8.ResonanceWidths_minThreshold_set
    __swig_getmethods__["minThreshold"] = _pythia8.ResonanceWidths_minThreshold_get
    if _newclass:
        minThreshold = _swig_property(_pythia8.ResonanceWidths_minThreshold_get, _pythia8.ResonanceWidths_minThreshold_set)
    __swig_setmethods__["mRes"] = _pythia8.ResonanceWidths_mRes_set
    __swig_getmethods__["mRes"] = _pythia8.ResonanceWidths_mRes_get
    if _newclass:
        mRes = _swig_property(_pythia8.ResonanceWidths_mRes_get, _pythia8.ResonanceWidths_mRes_set)
    __swig_setmethods__["GammaRes"] = _pythia8.ResonanceWidths_GammaRes_set
    __swig_getmethods__["GammaRes"] = _pythia8.ResonanceWidths_GammaRes_get
    if _newclass:
        GammaRes = _swig_property(_pythia8.ResonanceWidths_GammaRes_get, _pythia8.ResonanceWidths_GammaRes_set)
    __swig_setmethods__["m2Res"] = _pythia8.ResonanceWidths_m2Res_set
    __swig_getmethods__["m2Res"] = _pythia8.ResonanceWidths_m2Res_get
    if _newclass:
        m2Res = _swig_property(_pythia8.ResonanceWidths_m2Res_get, _pythia8.ResonanceWidths_m2Res_set)
    __swig_setmethods__["GamMRat"] = _pythia8.ResonanceWidths_GamMRat_set
    __swig_getmethods__["GamMRat"] = _pythia8.ResonanceWidths_GamMRat_get
    if _newclass:
        GamMRat = _swig_property(_pythia8.ResonanceWidths_GamMRat_get, _pythia8.ResonanceWidths_GamMRat_set)
    __swig_setmethods__["openPos"] = _pythia8.ResonanceWidths_openPos_set
    __swig_getmethods__["openPos"] = _pythia8.ResonanceWidths_openPos_get
    if _newclass:
        openPos = _swig_property(_pythia8.ResonanceWidths_openPos_get, _pythia8.ResonanceWidths_openPos_set)
    __swig_setmethods__["openNeg"] = _pythia8.ResonanceWidths_openNeg_set
    __swig_getmethods__["openNeg"] = _pythia8.ResonanceWidths_openNeg_get
    if _newclass:
        openNeg = _swig_property(_pythia8.ResonanceWidths_openNeg_get, _pythia8.ResonanceWidths_openNeg_set)
    __swig_setmethods__["forceFactor"] = _pythia8.ResonanceWidths_forceFactor_set
    __swig_getmethods__["forceFactor"] = _pythia8.ResonanceWidths_forceFactor_get
    if _newclass:
        forceFactor = _swig_property(_pythia8.ResonanceWidths_forceFactor_get, _pythia8.ResonanceWidths_forceFactor_set)
    __swig_setmethods__["iChannel"] = _pythia8.ResonanceWidths_iChannel_set
    __swig_getmethods__["iChannel"] = _pythia8.ResonanceWidths_iChannel_get
    if _newclass:
        iChannel = _swig_property(_pythia8.ResonanceWidths_iChannel_get, _pythia8.ResonanceWidths_iChannel_set)
    __swig_setmethods__["onMode"] = _pythia8.ResonanceWidths_onMode_set
    __swig_getmethods__["onMode"] = _pythia8.ResonanceWidths_onMode_get
    if _newclass:
        onMode = _swig_property(_pythia8.ResonanceWidths_onMode_get, _pythia8.ResonanceWidths_onMode_set)
    __swig_setmethods__["meMode"] = _pythia8.ResonanceWidths_meMode_set
    __swig_getmethods__["meMode"] = _pythia8.ResonanceWidths_meMode_get
    if _newclass:
        meMode = _swig_property(_pythia8.ResonanceWidths_meMode_get, _pythia8.ResonanceWidths_meMode_set)
    __swig_setmethods__["mult"] = _pythia8.ResonanceWidths_mult_set
    __swig_getmethods__["mult"] = _pythia8.ResonanceWidths_mult_get
    if _newclass:
        mult = _swig_property(_pythia8.ResonanceWidths_mult_get, _pythia8.ResonanceWidths_mult_set)
    __swig_setmethods__["id1"] = _pythia8.ResonanceWidths_id1_set
    __swig_getmethods__["id1"] = _pythia8.ResonanceWidths_id1_get
    if _newclass:
        id1 = _swig_property(_pythia8.ResonanceWidths_id1_get, _pythia8.ResonanceWidths_id1_set)
    __swig_setmethods__["id2"] = _pythia8.ResonanceWidths_id2_set
    __swig_getmethods__["id2"] = _pythia8.ResonanceWidths_id2_get
    if _newclass:
        id2 = _swig_property(_pythia8.ResonanceWidths_id2_get, _pythia8.ResonanceWidths_id2_set)
    __swig_setmethods__["id3"] = _pythia8.ResonanceWidths_id3_set
    __swig_getmethods__["id3"] = _pythia8.ResonanceWidths_id3_get
    if _newclass:
        id3 = _swig_property(_pythia8.ResonanceWidths_id3_get, _pythia8.ResonanceWidths_id3_set)
    __swig_setmethods__["id1Abs"] = _pythia8.ResonanceWidths_id1Abs_set
    __swig_getmethods__["id1Abs"] = _pythia8.ResonanceWidths_id1Abs_get
    if _newclass:
        id1Abs = _swig_property(_pythia8.ResonanceWidths_id1Abs_get, _pythia8.ResonanceWidths_id1Abs_set)
    __swig_setmethods__["id2Abs"] = _pythia8.ResonanceWidths_id2Abs_set
    __swig_getmethods__["id2Abs"] = _pythia8.ResonanceWidths_id2Abs_get
    if _newclass:
        id2Abs = _swig_property(_pythia8.ResonanceWidths_id2Abs_get, _pythia8.ResonanceWidths_id2Abs_set)
    __swig_setmethods__["id3Abs"] = _pythia8.ResonanceWidths_id3Abs_set
    __swig_getmethods__["id3Abs"] = _pythia8.ResonanceWidths_id3Abs_get
    if _newclass:
        id3Abs = _swig_property(_pythia8.ResonanceWidths_id3Abs_get, _pythia8.ResonanceWidths_id3Abs_set)
    __swig_setmethods__["idInFlav"] = _pythia8.ResonanceWidths_idInFlav_set
    __swig_getmethods__["idInFlav"] = _pythia8.ResonanceWidths_idInFlav_get
    if _newclass:
        idInFlav = _swig_property(_pythia8.ResonanceWidths_idInFlav_get, _pythia8.ResonanceWidths_idInFlav_set)
    __swig_setmethods__["widNow"] = _pythia8.ResonanceWidths_widNow_set
    __swig_getmethods__["widNow"] = _pythia8.ResonanceWidths_widNow_get
    if _newclass:
        widNow = _swig_property(_pythia8.ResonanceWidths_widNow_get, _pythia8.ResonanceWidths_widNow_set)
    __swig_setmethods__["mHat"] = _pythia8.ResonanceWidths_mHat_set
    __swig_getmethods__["mHat"] = _pythia8.ResonanceWidths_mHat_get
    if _newclass:
        mHat = _swig_property(_pythia8.ResonanceWidths_mHat_get, _pythia8.ResonanceWidths_mHat_set)
    __swig_setmethods__["mf1"] = _pythia8.ResonanceWidths_mf1_set
    __swig_getmethods__["mf1"] = _pythia8.ResonanceWidths_mf1_get
    if _newclass:
        mf1 = _swig_property(_pythia8.ResonanceWidths_mf1_get, _pythia8.ResonanceWidths_mf1_set)
    __swig_setmethods__["mf2"] = _pythia8.ResonanceWidths_mf2_set
    __swig_getmethods__["mf2"] = _pythia8.ResonanceWidths_mf2_get
    if _newclass:
        mf2 = _swig_property(_pythia8.ResonanceWidths_mf2_get, _pythia8.ResonanceWidths_mf2_set)
    __swig_setmethods__["mf3"] = _pythia8.ResonanceWidths_mf3_set
    __swig_getmethods__["mf3"] = _pythia8.ResonanceWidths_mf3_get
    if _newclass:
        mf3 = _swig_property(_pythia8.ResonanceWidths_mf3_get, _pythia8.ResonanceWidths_mf3_set)
    __swig_setmethods__["mr1"] = _pythia8.ResonanceWidths_mr1_set
    __swig_getmethods__["mr1"] = _pythia8.ResonanceWidths_mr1_get
    if _newclass:
        mr1 = _swig_property(_pythia8.ResonanceWidths_mr1_get, _pythia8.ResonanceWidths_mr1_set)
    __swig_setmethods__["mr2"] = _pythia8.ResonanceWidths_mr2_set
    __swig_getmethods__["mr2"] = _pythia8.ResonanceWidths_mr2_get
    if _newclass:
        mr2 = _swig_property(_pythia8.ResonanceWidths_mr2_get, _pythia8.ResonanceWidths_mr2_set)
    __swig_setmethods__["mr3"] = _pythia8.ResonanceWidths_mr3_set
    __swig_getmethods__["mr3"] = _pythia8.ResonanceWidths_mr3_get
    if _newclass:
        mr3 = _swig_property(_pythia8.ResonanceWidths_mr3_get, _pythia8.ResonanceWidths_mr3_set)
    __swig_setmethods__["ps"] = _pythia8.ResonanceWidths_ps_set
    __swig_getmethods__["ps"] = _pythia8.ResonanceWidths_ps_get
    if _newclass:
        ps = _swig_property(_pythia8.ResonanceWidths_ps_get, _pythia8.ResonanceWidths_ps_set)
    __swig_setmethods__["kinFac"] = _pythia8.ResonanceWidths_kinFac_set
    __swig_getmethods__["kinFac"] = _pythia8.ResonanceWidths_kinFac_get
    if _newclass:
        kinFac = _swig_property(_pythia8.ResonanceWidths_kinFac_get, _pythia8.ResonanceWidths_kinFac_set)
    __swig_setmethods__["alpEM"] = _pythia8.ResonanceWidths_alpEM_set
    __swig_getmethods__["alpEM"] = _pythia8.ResonanceWidths_alpEM_get
    if _newclass:
        alpEM = _swig_property(_pythia8.ResonanceWidths_alpEM_get, _pythia8.ResonanceWidths_alpEM_set)
    __swig_setmethods__["alpS"] = _pythia8.ResonanceWidths_alpS_set
    __swig_getmethods__["alpS"] = _pythia8.ResonanceWidths_alpS_get
    if _newclass:
        alpS = _swig_property(_pythia8.ResonanceWidths_alpS_get, _pythia8.ResonanceWidths_alpS_set)
    __swig_setmethods__["colQ"] = _pythia8.ResonanceWidths_colQ_set
    __swig_getmethods__["colQ"] = _pythia8.ResonanceWidths_colQ_get
    if _newclass:
        colQ = _swig_property(_pythia8.ResonanceWidths_colQ_get, _pythia8.ResonanceWidths_colQ_set)
    __swig_setmethods__["preFac"] = _pythia8.ResonanceWidths_preFac_set
    __swig_getmethods__["preFac"] = _pythia8.ResonanceWidths_preFac_get
    if _newclass:
        preFac = _swig_property(_pythia8.ResonanceWidths_preFac_get, _pythia8.ResonanceWidths_preFac_set)
    __swig_setmethods__["particlePtr"] = _pythia8.ResonanceWidths_particlePtr_set
    __swig_getmethods__["particlePtr"] = _pythia8.ResonanceWidths_particlePtr_get
    if _newclass:
        particlePtr = _swig_property(_pythia8.ResonanceWidths_particlePtr_get, _pythia8.ResonanceWidths_particlePtr_set)
    __swig_setmethods__["infoPtr"] = _pythia8.ResonanceWidths_infoPtr_set
    __swig_getmethods__["infoPtr"] = _pythia8.ResonanceWidths_infoPtr_get
    if _newclass:
        infoPtr = _swig_property(_pythia8.ResonanceWidths_infoPtr_get, _pythia8.ResonanceWidths_infoPtr_set)
    __swig_setmethods__["settingsPtr"] = _pythia8.ResonanceWidths_settingsPtr_set
    __swig_getmethods__["settingsPtr"] = _pythia8.ResonanceWidths_settingsPtr_get
    if _newclass:
        settingsPtr = _swig_property(_pythia8.ResonanceWidths_settingsPtr_get, _pythia8.ResonanceWidths_settingsPtr_set)
    __swig_setmethods__["particleDataPtr"] = _pythia8.ResonanceWidths_particleDataPtr_set
    __swig_getmethods__["particleDataPtr"] = _pythia8.ResonanceWidths_particleDataPtr_get
    if _newclass:
        particleDataPtr = _swig_property(_pythia8.ResonanceWidths_particleDataPtr_get, _pythia8.ResonanceWidths_particleDataPtr_set)
    __swig_setmethods__["couplingsPtr"] = _pythia8.ResonanceWidths_couplingsPtr_set
    __swig_getmethods__["couplingsPtr"] = _pythia8.ResonanceWidths_couplingsPtr_get
    if _newclass:
        couplingsPtr = _swig_property(_pythia8.ResonanceWidths_couplingsPtr_get, _pythia8.ResonanceWidths_couplingsPtr_set)

    def initConstants(self):
        """
Constants: could only be changed in the code itself.
Particle properties always present.
Properties for currently studied decay channel(s).
Pointer to properties of the particle species.
Pointer to various information on the generation.
Pointer to the settings database.
Pointer to the particle data table.
Pointers to Standard Model and SUSY couplings.
Initialize constants.
"""
        return _pythia8.ResonanceWidths_initConstants(self)

    def initBSM(self):
        """
Virtual methods to handle model-specific (non-SM) part of initialization
for use by derived classes that implement additional models (eg SUSY).
"""
        return _pythia8.ResonanceWidths_initBSM(self)

    def allowCalc(self):
        """
"""
        return _pythia8.ResonanceWidths_allowCalc(self)

    def calcPreFac(self, arg0=False):
        """
Calculate various common prefactors for the current mass.
Optional argument calledFromInit only used for Z0.
"""
        return _pythia8.ResonanceWidths_calcPreFac(self, arg0)

    def calcWidth(self, arg0=False):
        """
Calculate width for currently considered channel.
Optional argument calledFromInit only used for Z0.
"""
        return _pythia8.ResonanceWidths_calcWidth(self, arg0)

    def numInt1BW(self, mHatIn, m1, Gamma1, mMin1, m2, psMode=1):
        """
Simple routines for matrix-element integration over Breit-Wigners.
"""
        return _pythia8.ResonanceWidths_numInt1BW(self, mHatIn, m1, Gamma1, mMin1, m2, psMode)

    def numInt2BW(self, mHatIn, m1, Gamma1, mMin1, m2, Gamma2, mMin2, psMode=1):
        """
"""
        return _pythia8.ResonanceWidths_numInt2BW(self, mHatIn, m1, Gamma1, mMin1, m2, Gamma2, mMin2, psMode)
    def __disown__(self):
        self.this.disown()
        _pythia8.disown_ResonanceWidths(self)
        return weakref_proxy(self)
ResonanceWidths_swigregister = _pythia8.ResonanceWidths_swigregister
ResonanceWidths_swigregister(ResonanceWidths)
ResonanceWidths.NPOINT = _pythia8.cvar.ResonanceWidths_NPOINT
ResonanceWidths.MASSMIN = _pythia8.cvar.ResonanceWidths_MASSMIN
ResonanceWidths.MASSMARGIN = _pythia8.cvar.ResonanceWidths_MASSMARGIN

class ResonanceGeneric(ResonanceWidths):
    """
The ResonanceGeneric class handles a generic resonance.
Only needs a constructor and allowCalc = false; for the rest uses
defaults in base class.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceGeneric, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceGeneric, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceGeneric(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def allowCalc(self):
        """
By default, assume no dedicated code exists to compute width.
"""
        return _pythia8.ResonanceGeneric_allowCalc(self)
    __swig_destroy__ = _pythia8.delete_ResonanceGeneric
    __del__ = lambda self: None
ResonanceGeneric_swigregister = _pythia8.ResonanceGeneric_swigregister
ResonanceGeneric_swigregister(ResonanceGeneric)

class ResonanceGmZ(ResonanceWidths):
    """
The ResonanceGmZ class handles the gamma*/Z0 resonance.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceGmZ, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceGmZ, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceGmZ(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceGmZ
    __del__ = lambda self: None
ResonanceGmZ_swigregister = _pythia8.ResonanceGmZ_swigregister
ResonanceGmZ_swigregister(ResonanceGmZ)

class ResonanceW(ResonanceWidths):
    """
The ResonanceW class handles the W+- resonance.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceW, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceW, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceW(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceW
    __del__ = lambda self: None
ResonanceW_swigregister = _pythia8.ResonanceW_swigregister
ResonanceW_swigregister(ResonanceW)

class ResonanceTop(ResonanceWidths):
    """
The ResonanceTop class handles the top/antitop resonance.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceTop, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceTop, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceTop(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceTop
    __del__ = lambda self: None
ResonanceTop_swigregister = _pythia8.ResonanceTop_swigregister
ResonanceTop_swigregister(ResonanceTop)

class ResonanceFour(ResonanceWidths):
    """
The ResonanceFour class handles fourth-generation resonances.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceFour, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceFour, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceFour(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceFour
    __del__ = lambda self: None
ResonanceFour_swigregister = _pythia8.ResonanceFour_swigregister
ResonanceFour_swigregister(ResonanceFour)

class ResonanceH(ResonanceWidths):
    """
The ResonanceH class handles the SM and BSM Higgs resonance.
higgsType = 0 : SM H; = 1: h^0/H_1; = 2 : H^0/H_2; = 3 : A^0/A_3.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceH, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceH, name)
    __repr__ = _swig_repr

    def __init__(self, higgsTypeIn, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceH(higgsTypeIn, idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceH
    __del__ = lambda self: None
ResonanceH_swigregister = _pythia8.ResonanceH_swigregister
ResonanceH_swigregister(ResonanceH)

class ResonanceHchg(ResonanceWidths):
    """
The ResonanceHchg class handles the H+- resonance.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceHchg, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceHchg, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceHchg(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceHchg
    __del__ = lambda self: None
ResonanceHchg_swigregister = _pythia8.ResonanceHchg_swigregister
ResonanceHchg_swigregister(ResonanceHchg)

class ResonanceZprime(ResonanceWidths):
    """
The ResonanceZprime class handles the gamma*/Z0 /Z'^0 resonance.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceZprime, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceZprime, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceZprime(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceZprime
    __del__ = lambda self: None
ResonanceZprime_swigregister = _pythia8.ResonanceZprime_swigregister
ResonanceZprime_swigregister(ResonanceZprime)

class ResonanceWprime(ResonanceWidths):
    """
The ResonanceWprime class handles the W'+- resonance.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceWprime, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceWprime, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceWprime(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceWprime
    __del__ = lambda self: None
ResonanceWprime_swigregister = _pythia8.ResonanceWprime_swigregister
ResonanceWprime_swigregister(ResonanceWprime)

class ResonanceRhorizontal(ResonanceWidths):
    """
The ResonanceRhorizontal class handles the R^0 resonance.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceRhorizontal, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceRhorizontal, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceRhorizontal(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceRhorizontal
    __del__ = lambda self: None
ResonanceRhorizontal_swigregister = _pythia8.ResonanceRhorizontal_swigregister
ResonanceRhorizontal_swigregister(ResonanceRhorizontal)

class ResonanceExcited(ResonanceWidths):
    """
The ResonanceExcited class handles excited-fermion resonances.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceExcited, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceExcited, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceExcited(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceExcited
    __del__ = lambda self: None
ResonanceExcited_swigregister = _pythia8.ResonanceExcited_swigregister
ResonanceExcited_swigregister(ResonanceExcited)

class ResonanceGraviton(ResonanceWidths):
    """
The ResonanceGraviton class handles the excited Graviton resonance.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceGraviton, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceGraviton, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceGraviton(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceGraviton
    __del__ = lambda self: None
ResonanceGraviton_swigregister = _pythia8.ResonanceGraviton_swigregister
ResonanceGraviton_swigregister(ResonanceGraviton)

class ResonanceKKgluon(ResonanceWidths):
    """
The ResonanceKKgluon class handles the g^*/KK-gluon^* resonance.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceKKgluon, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceKKgluon, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceKKgluon(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceKKgluon
    __del__ = lambda self: None
ResonanceKKgluon_swigregister = _pythia8.ResonanceKKgluon_swigregister
ResonanceKKgluon_swigregister(ResonanceKKgluon)

class ResonanceLeptoquark(ResonanceWidths):
    """
The ResonanceLeptoquark class handles the LQ/LQbar resonance.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceLeptoquark, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceLeptoquark, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceLeptoquark(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceLeptoquark
    __del__ = lambda self: None
ResonanceLeptoquark_swigregister = _pythia8.ResonanceLeptoquark_swigregister
ResonanceLeptoquark_swigregister(ResonanceLeptoquark)

class ResonanceNuRight(ResonanceWidths):
    """
The ResonanceNuRight class handles righthanded Majorana neutrinos.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceNuRight, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceNuRight, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceNuRight(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceNuRight
    __del__ = lambda self: None
ResonanceNuRight_swigregister = _pythia8.ResonanceNuRight_swigregister
ResonanceNuRight_swigregister(ResonanceNuRight)

class ResonanceZRight(ResonanceWidths):
    """
The ResonanceZRight class handles the Z_R^0 resonance.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceZRight, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceZRight, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceZRight(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceZRight
    __del__ = lambda self: None
ResonanceZRight_swigregister = _pythia8.ResonanceZRight_swigregister
ResonanceZRight_swigregister(ResonanceZRight)

class ResonanceWRight(ResonanceWidths):
    """
The ResonanceWRight class handles the W_R+- resonance.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceWRight, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceWRight, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceWRight(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceWRight
    __del__ = lambda self: None
ResonanceWRight_swigregister = _pythia8.ResonanceWRight_swigregister
ResonanceWRight_swigregister(ResonanceWRight)

class ResonanceHchgchgLeft(ResonanceWidths):
    """
The ResonanceHchgchgLeft class handles the H++/H-- (left) resonance.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceHchgchgLeft, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceHchgchgLeft, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceHchgchgLeft(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceHchgchgLeft
    __del__ = lambda self: None
ResonanceHchgchgLeft_swigregister = _pythia8.ResonanceHchgchgLeft_swigregister
ResonanceHchgchgLeft_swigregister(ResonanceHchgchgLeft)

class ResonanceHchgchgRight(ResonanceWidths):
    """
The ResonanceHchgchgRight class handles the H++/H-- (right) resonance.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceHchgchgRight, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceHchgchgRight, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceHchgchgRight(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceHchgchgRight
    __del__ = lambda self: None
ResonanceHchgchgRight_swigregister = _pythia8.ResonanceHchgchgRight_swigregister
ResonanceHchgchgRight_swigregister(ResonanceHchgchgRight)

class SigmaTotAux(_object):
    """
The SigmaTotAux is base class for the different parametrizations
made accessible via SigmaTotal. Many variables are public, since
they can only be accessed via the SigmaTotal methods anyway.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SigmaTotAux, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SigmaTotAux, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_SigmaTotAux()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_SigmaTotAux
    __del__ = lambda self: None

    def init(self, arg2, arg3, arg4, arg5):
        """
Store pointers and initialize data members.
"""
        return _pythia8.SigmaTotAux_init(self, arg2, arg3, arg4, arg5)

    def calcTotEl(self, arg2, arg3, arg4, arg5, arg6):
        """
Calculate integrated total/elastic cross sections.
Usage: calcTotEl( idAin, idBin, sIn, mAin, mBin).
"""
        return _pythia8.SigmaTotAux_calcTotEl(self, arg2, arg3, arg4, arg5, arg6)
    __swig_setmethods__["isExpEl"] = _pythia8.SigmaTotAux_isExpEl_set
    __swig_getmethods__["isExpEl"] = _pythia8.SigmaTotAux_isExpEl_get
    if _newclass:
        isExpEl = _swig_property(_pythia8.SigmaTotAux_isExpEl_get, _pythia8.SigmaTotAux_isExpEl_set)
    __swig_setmethods__["hasCou"] = _pythia8.SigmaTotAux_hasCou_set
    __swig_getmethods__["hasCou"] = _pythia8.SigmaTotAux_hasCou_get
    if _newclass:
        hasCou = _swig_property(_pythia8.SigmaTotAux_hasCou_get, _pythia8.SigmaTotAux_hasCou_set)
    __swig_setmethods__["sigTot"] = _pythia8.SigmaTotAux_sigTot_set
    __swig_getmethods__["sigTot"] = _pythia8.SigmaTotAux_sigTot_get
    if _newclass:
        sigTot = _swig_property(_pythia8.SigmaTotAux_sigTot_get, _pythia8.SigmaTotAux_sigTot_set)
    __swig_setmethods__["rhoOwn"] = _pythia8.SigmaTotAux_rhoOwn_set
    __swig_getmethods__["rhoOwn"] = _pythia8.SigmaTotAux_rhoOwn_get
    if _newclass:
        rhoOwn = _swig_property(_pythia8.SigmaTotAux_rhoOwn_get, _pythia8.SigmaTotAux_rhoOwn_set)
    __swig_setmethods__["sigEl"] = _pythia8.SigmaTotAux_sigEl_set
    __swig_getmethods__["sigEl"] = _pythia8.SigmaTotAux_sigEl_get
    if _newclass:
        sigEl = _swig_property(_pythia8.SigmaTotAux_sigEl_get, _pythia8.SigmaTotAux_sigEl_set)
    __swig_setmethods__["bEl"] = _pythia8.SigmaTotAux_bEl_set
    __swig_getmethods__["bEl"] = _pythia8.SigmaTotAux_bEl_get
    if _newclass:
        bEl = _swig_property(_pythia8.SigmaTotAux_bEl_get, _pythia8.SigmaTotAux_bEl_set)
    __swig_setmethods__["sigTotCou"] = _pythia8.SigmaTotAux_sigTotCou_set
    __swig_getmethods__["sigTotCou"] = _pythia8.SigmaTotAux_sigTotCou_get
    if _newclass:
        sigTotCou = _swig_property(_pythia8.SigmaTotAux_sigTotCou_get, _pythia8.SigmaTotAux_sigTotCou_set)
    __swig_setmethods__["sigElCou"] = _pythia8.SigmaTotAux_sigElCou_set
    __swig_getmethods__["sigElCou"] = _pythia8.SigmaTotAux_sigElCou_get
    if _newclass:
        sigElCou = _swig_property(_pythia8.SigmaTotAux_sigElCou_get, _pythia8.SigmaTotAux_sigElCou_set)

    def dsigmaEl(self, arg2, arg3=False, arg4=True):
        """
Store total and elastic cross section properties.
Differential elastic cross section, d(sigma_el) / dt.
"""
        return _pythia8.SigmaTotAux_dsigmaEl(self, arg2, arg3, arg4)

    def calcDiff(self, arg2, arg3, arg4, arg5, arg6):
        """
Calculate integrated diffractive cross sections.
Usage: calcDiff(  idAin, idBin, sIn, mAin, mBin).
"""
        return _pythia8.SigmaTotAux_calcDiff(self, arg2, arg3, arg4, arg5, arg6)
    __swig_setmethods__["sigXB"] = _pythia8.SigmaTotAux_sigXB_set
    __swig_getmethods__["sigXB"] = _pythia8.SigmaTotAux_sigXB_get
    if _newclass:
        sigXB = _swig_property(_pythia8.SigmaTotAux_sigXB_get, _pythia8.SigmaTotAux_sigXB_set)
    __swig_setmethods__["sigAX"] = _pythia8.SigmaTotAux_sigAX_set
    __swig_getmethods__["sigAX"] = _pythia8.SigmaTotAux_sigAX_get
    if _newclass:
        sigAX = _swig_property(_pythia8.SigmaTotAux_sigAX_get, _pythia8.SigmaTotAux_sigAX_set)
    __swig_setmethods__["sigXX"] = _pythia8.SigmaTotAux_sigXX_set
    __swig_getmethods__["sigXX"] = _pythia8.SigmaTotAux_sigXX_get
    if _newclass:
        sigXX = _swig_property(_pythia8.SigmaTotAux_sigXX_get, _pythia8.SigmaTotAux_sigXX_set)
    __swig_setmethods__["sigAXB"] = _pythia8.SigmaTotAux_sigAXB_set
    __swig_getmethods__["sigAXB"] = _pythia8.SigmaTotAux_sigAXB_get
    if _newclass:
        sigAXB = _swig_property(_pythia8.SigmaTotAux_sigAXB_get, _pythia8.SigmaTotAux_sigAXB_set)

    def dsigmaSD(self, arg2, arg3, arg4=True, arg5=0):
        """
Store diffractive cross sections.
Differential single diffractive cross section,
xi * d(sigma_SD) / (dxi dt).
"""
        return _pythia8.SigmaTotAux_dsigmaSD(self, arg2, arg3, arg4, arg5)

    def splitDiff(self):
        """
Possibility to separate xi and t choices for diffraction.
"""
        return _pythia8.SigmaTotAux_splitDiff(self)

    def dsigmaDD(self, arg2, arg3, arg4, arg5=0):
        """
Differential double diffractive cross section,
xi1 * xi2 * d(sigma_DD) / (dxi1 dxi2 dt).
"""
        return _pythia8.SigmaTotAux_dsigmaDD(self, arg2, arg3, arg4, arg5)

    def dsigmaCD(self, arg2, arg3, arg4, arg5, arg6):
        """
Differential central diffractive cross section,
xi1 * xi2 * d(sigma_CD) / (dxi1 dxi2 dt1 dt2).
"""
        return _pythia8.SigmaTotAux_dsigmaCD(self, arg2, arg3, arg4, arg5, arg6)

    def mMinCD(self):
        """
Minimal central diffractive mass.
"""
        return _pythia8.SigmaTotAux_mMinCD(self)

    def tRange(self, sIn, s1In, s2In, s3In, s4In):
        """
"""
        return _pythia8.SigmaTotAux_tRange(self, sIn, s1In, s2In, s3In, s4In)

    def tInRange(self, tIn, sIn, s1In, s2In, s3In, s4In):
        """
"""
        return _pythia8.SigmaTotAux_tInRange(self, tIn, sIn, s1In, s2In, s3In, s4In)

    def pFormFac(self, tIn):
        """
Commonly used proton form factor.
"""
        return _pythia8.SigmaTotAux_pFormFac(self, tIn)
SigmaTotAux_swigregister = _pythia8.SigmaTotAux_swigregister
SigmaTotAux_swigregister(SigmaTotAux)

class SigmaTotal(_object):
    """
The SigmaTotal class contains parametrizations of total, elastic and
diffractive cross sections, and of the respective slope parameter.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SigmaTotal, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SigmaTotal, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_SigmaTotal()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_SigmaTotal
    __del__ = lambda self: None

    def init(self, infoPtrIn, settings, particleDataPtrIn, rndmPtrIn):
        """
Store pointers and initialize data members.
"""
        return _pythia8.SigmaTotal_init(self, infoPtrIn, settings, particleDataPtrIn, rndmPtrIn)

    def calc(self, idA, idB, eCM):
        """
Calculate, or recalculate for new beams or new energy.
"""
        return _pythia8.SigmaTotal_calc(self, idA, idB, eCM)

    def hasSigmaTot(self):
        """
Confirm that initialization worked.
"""
        return _pythia8.SigmaTotal_hasSigmaTot(self)

    def sigmaTot(self):
        """
Total and integrated elastic cross sections.
"""
        return _pythia8.SigmaTotal_sigmaTot(self)

    def rho(self):
        """
"""
        return _pythia8.SigmaTotal_rho(self)

    def sigmaEl(self):
        """
"""
        return _pythia8.SigmaTotal_sigmaEl(self)

    def bElIsExp(self):
        """
"""
        return _pythia8.SigmaTotal_bElIsExp(self)

    def bSlopeEl(self):
        """
"""
        return _pythia8.SigmaTotal_bSlopeEl(self)

    def hasCoulomb(self):
        """
"""
        return _pythia8.SigmaTotal_hasCoulomb(self)

    def calcTotEl(self, idAin, idBin, sIn, mAin, mBin):
        """
Total elastic cross section.
"""
        return _pythia8.SigmaTotal_calcTotEl(self, idAin, idBin, sIn, mAin, mBin)

    def dsigmaEl(self, t, useCoulomb=False, onlyPomerons=False):
        """
Differential elastic cross section.
"""
        return _pythia8.SigmaTotal_dsigmaEl(self, t, useCoulomb, onlyPomerons)

    def sigmaXB(self):
        """
Integrated diffractive cross sections.
"""
        return _pythia8.SigmaTotal_sigmaXB(self)

    def sigmaAX(self):
        """
"""
        return _pythia8.SigmaTotal_sigmaAX(self)

    def sigmaXX(self):
        """
"""
        return _pythia8.SigmaTotal_sigmaXX(self)

    def sigmaAXB(self):
        """
"""
        return _pythia8.SigmaTotal_sigmaAXB(self)

    def sigmaND(self):
        """
"""
        return _pythia8.SigmaTotal_sigmaND(self)

    def dsigmaSD(self, xi, t, isXB=True, step=0):
        """
Differential single diffractive cross section.
"""
        return _pythia8.SigmaTotal_dsigmaSD(self, xi, t, isXB, step)

    def splitDiff(self):
        """
Possibility to separate xi and t choices for diffraction.
"""
        return _pythia8.SigmaTotal_splitDiff(self)

    def dsigmaDD(self, xi1, xi2, t, step=0):
        """
Differential double diffractive cross section.
"""
        return _pythia8.SigmaTotal_dsigmaDD(self, xi1, xi2, t, step)

    def dsigmaCD(self, xi1, xi2, t1, t2, step=0):
        """
Differential central diffractive cross section.
"""
        return _pythia8.SigmaTotal_dsigmaCD(self, xi1, xi2, t1, t2, step)

    def mMinCD(self):
        """
Minimal central diffractive mass.
"""
        return _pythia8.SigmaTotal_mMinCD(self)

    def chooseVMDstates(self, idA, idB, eCM, processCode):
        """
Sample the VMD states for resolved photons.
"""
        return _pythia8.SigmaTotal_chooseVMDstates(self, idA, idB, eCM, processCode)

    def tRange(self, sIn, s1In, s2In, s3In, s4In):
        """
Standard methods to find t range of a 2 -> 2 process
and to check whether a given t value is in that range.
"""
        return _pythia8.SigmaTotal_tRange(self, sIn, s1In, s2In, s3In, s4In)

    def tInRange(self, tIn, sIn, s1In, s2In, s3In, s4In):
        """
"""
        return _pythia8.SigmaTotal_tInRange(self, tIn, sIn, s1In, s2In, s3In, s4In)
SigmaTotal_swigregister = _pythia8.SigmaTotal_swigregister
SigmaTotal_swigregister(SigmaTotal)

class SigmaTotOwn(SigmaTotAux):
    """
The SigmaTotOwn class parametrizes total, elastic and diffractive
cross sections by user settings.
"""
    __swig_setmethods__ = {}
    for _s in [SigmaTotAux]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SigmaTotOwn, name, value)
    __swig_getmethods__ = {}
    for _s in [SigmaTotAux]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SigmaTotOwn, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_SigmaTotOwn()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, arg2, settings, particleDataPtrIn, arg5):
        """
Store pointers and initialize data members.
"""
        return _pythia8.SigmaTotOwn_init(self, arg2, settings, particleDataPtrIn, arg5)

    def calcTotEl(self, idAin, idBin, arg4, arg5, arg6):
        """
Calculate integrated total/elastic cross sections.
"""
        return _pythia8.SigmaTotOwn_calcTotEl(self, idAin, idBin, arg4, arg5, arg6)

    def dsigmaEl(self, t, useCoulomb=False, arg4=True):
        """
Differential elastic cross section.
"""
        return _pythia8.SigmaTotOwn_dsigmaEl(self, t, useCoulomb, arg4)

    def calcDiff(self, arg2, arg3, sIn, arg5, arg6):
        """
Calculate integrated diffractive cross sections.
"""
        return _pythia8.SigmaTotOwn_calcDiff(self, arg2, arg3, sIn, arg5, arg6)

    def dsigmaSD(self, xi, t, arg4=True, arg5=0):
        """
Differential single diffractive cross section.
"""
        return _pythia8.SigmaTotOwn_dsigmaSD(self, xi, t, arg4, arg5)

    def dsigmaDD(self, xi1, xi2, t, arg5=0):
        """
Differential double diffractive cross section.
"""
        return _pythia8.SigmaTotOwn_dsigmaDD(self, xi1, xi2, t, arg5)

    def dsigmaCD(self, xi1, xi2, t1, t2, arg6=0):
        """
Differential central diffractive cross section.
"""
        return _pythia8.SigmaTotOwn_dsigmaCD(self, xi1, xi2, t1, t2, arg6)

    def mMinCD(self):
        """
Minimal central diffractive mass.
"""
        return _pythia8.SigmaTotOwn_mMinCD(self)
    __swig_destroy__ = _pythia8.delete_SigmaTotOwn
    __del__ = lambda self: None
SigmaTotOwn_swigregister = _pythia8.SigmaTotOwn_swigregister
SigmaTotOwn_swigregister(SigmaTotOwn)

class SigmaSaSDL(SigmaTotAux):
    """
The SigmaSaSDL class parametrizes total, elastic and diffractive
cross sections according to Schuler and Sjostrand, starting from
Donnachie and Landshoff.
"""
    __swig_setmethods__ = {}
    for _s in [SigmaTotAux]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SigmaSaSDL, name, value)
    __swig_getmethods__ = {}
    for _s in [SigmaTotAux]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SigmaSaSDL, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_SigmaSaSDL()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, infoPtrIn, settings, particleDataPtrIn, arg5):
        """
Store pointers and initialize data members.
"""
        return _pythia8.SigmaSaSDL_init(self, infoPtrIn, settings, particleDataPtrIn, arg5)

    def calcTotEl(self, idAin, idBin, sIn, mAin, mBin):
        """
Calculate integrated total/elastic cross sections.
"""
        return _pythia8.SigmaSaSDL_calcTotEl(self, idAin, idBin, sIn, mAin, mBin)

    def dsigmaEl(self, t, useCoulomb=False, arg4=True):
        """
Differential elastic cross section.
"""
        return _pythia8.SigmaSaSDL_dsigmaEl(self, t, useCoulomb, arg4)

    def calcDiff(self, idAin, idBin, sIn, mAin, mBin):
        """
Calculate integrated diffractive cross sections.
"""
        return _pythia8.SigmaSaSDL_calcDiff(self, idAin, idBin, sIn, mAin, mBin)

    def dsigmaSD(self, xi, t, isXB, arg5=0):
        """
Differential single diffractive cross section.
"""
        return _pythia8.SigmaSaSDL_dsigmaSD(self, xi, t, isXB, arg5)

    def dsigmaDD(self, xi1, xi2, t, arg5=0):
        """
Differential double diffractive cross section.
"""
        return _pythia8.SigmaSaSDL_dsigmaDD(self, xi1, xi2, t, arg5)

    def dsigmaCD(self, xi1, xi2, t1, t2, arg6=0):
        """
Differential central diffractive cross section.
"""
        return _pythia8.SigmaSaSDL_dsigmaCD(self, xi1, xi2, t1, t2, arg6)

    def mMinCD(self):
        """
Minimal central diffractive mass.
"""
        return _pythia8.SigmaSaSDL_mMinCD(self)
    __swig_destroy__ = _pythia8.delete_SigmaSaSDL
    __del__ = lambda self: None
SigmaSaSDL_swigregister = _pythia8.SigmaSaSDL_swigregister
SigmaSaSDL_swigregister(SigmaSaSDL)

class SigmaMBR(SigmaTotAux):
    """
The SigmaMBR class parametrizes total and elastic cross sections
according to the Minimum Bias Rockefeller (MBR) model.
"""
    __swig_setmethods__ = {}
    for _s in [SigmaTotAux]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SigmaMBR, name, value)
    __swig_getmethods__ = {}
    for _s in [SigmaTotAux]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SigmaMBR, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_SigmaMBR()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, arg2, settings, particleDataPtrIn, arg5):
        """
Initialize data members.
"""
        return _pythia8.SigmaMBR_init(self, arg2, settings, particleDataPtrIn, arg5)

    def calcTotEl(self, idAin, idBin, sIn, arg5, arg6):
        """
Calculate integrated total/elastic cross sections.
"""
        return _pythia8.SigmaMBR_calcTotEl(self, idAin, idBin, sIn, arg5, arg6)

    def dsigmaEl(self, t, useCoulomb=False, arg4=True):
        """
Differential elastic cross section.
"""
        return _pythia8.SigmaMBR_dsigmaEl(self, t, useCoulomb, arg4)

    def calcDiff(self, arg2, arg3, sIn, arg5, arg6):
        """
Calculate integrated diffractive cross sections.
"""
        return _pythia8.SigmaMBR_calcDiff(self, arg2, arg3, sIn, arg5, arg6)

    def splitDiff(self):
        """
In MBR choice of xi and t values are separated.
"""
        return _pythia8.SigmaMBR_splitDiff(self)

    def dsigmaSD(self, xi, t, arg4=True, step=0):
        """
Differential single diffractive cross section.
"""
        return _pythia8.SigmaMBR_dsigmaSD(self, xi, t, arg4, step)

    def dsigmaDD(self, xi1, xi2, t, step=0):
        """
Differential double diffractive cross section.
"""
        return _pythia8.SigmaMBR_dsigmaDD(self, xi1, xi2, t, step)

    def dsigmaCD(self, xi1, xi2, t1, t2, step=0):
        """
Differential central diffractive cross section.
"""
        return _pythia8.SigmaMBR_dsigmaCD(self, xi1, xi2, t1, t2, step)

    def mMinCD(self):
        """
Minimal central diffractive mass.
"""
        return _pythia8.SigmaMBR_mMinCD(self)
    __swig_destroy__ = _pythia8.delete_SigmaMBR
    __del__ = lambda self: None
SigmaMBR_swigregister = _pythia8.SigmaMBR_swigregister
SigmaMBR_swigregister(SigmaMBR)

class SigmaABMST(SigmaTotAux):
    """
The SigmaABMST class parametrizes total and elastic cross sections
according to Appleby, Barlow, Molson, Serluca and Toader (ABMST).
"""
    __swig_setmethods__ = {}
    for _s in [SigmaTotAux]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SigmaABMST, name, value)
    __swig_getmethods__ = {}
    for _s in [SigmaTotAux]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SigmaABMST, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_SigmaABMST()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, arg2, settings, arg4, rndmPtrIn):
        """
Initialize data members.
"""
        return _pythia8.SigmaABMST_init(self, arg2, settings, arg4, rndmPtrIn)

    def calcTotEl(self, idAin, idBin, sIn, arg5, arg6):
        """
Calculate integrated total/elastic cross sections.
"""
        return _pythia8.SigmaABMST_calcTotEl(self, idAin, idBin, sIn, arg5, arg6)

    def dsigmaEl(self, t, useCoulomb=False, onlyPomerons=False):
        """
Differential elastic cross section.
"""
        return _pythia8.SigmaABMST_dsigmaEl(self, t, useCoulomb, onlyPomerons)

    def calcDiff(self, idAin, idBin, sIn, arg5, arg6):
        """
Calculate integrated diffractive cross sections.
"""
        return _pythia8.SigmaABMST_calcDiff(self, idAin, idBin, sIn, arg5, arg6)

    def dsigmaSD(self, xi, t, arg4=True, arg5=0):
        """
Differential single diffractive cross section.
"""
        return _pythia8.SigmaABMST_dsigmaSD(self, xi, t, arg4, arg5)

    def dsigmaDD(self, xi1, xi2, t, arg5=0):
        """
Differential double diffractive cross section.
"""
        return _pythia8.SigmaABMST_dsigmaDD(self, xi1, xi2, t, arg5)

    def dsigmaCD(self, xi1, xi2, t1, t2, arg6=0):
        """
Differential central diffractive cross section.
"""
        return _pythia8.SigmaABMST_dsigmaCD(self, xi1, xi2, t1, t2, arg6)

    def mMinCD(self):
        """
Minimal central diffractive mass.
"""
        return _pythia8.SigmaABMST_mMinCD(self)
    __swig_destroy__ = _pythia8.delete_SigmaABMST
    __del__ = lambda self: None
SigmaABMST_swigregister = _pythia8.SigmaABMST_swigregister
SigmaABMST_swigregister(SigmaABMST)

class SigmaRPP(SigmaTotAux):
    """
The SigmaRPP class parametrizes total and elastic cross sections
according to the fit in Review of Particle Physics 2014.
"""
    __swig_setmethods__ = {}
    for _s in [SigmaTotAux]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SigmaRPP, name, value)
    __swig_getmethods__ = {}
    for _s in [SigmaTotAux]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SigmaRPP, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_SigmaRPP()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, arg2, settings, arg4, arg5):
        """
Initialize data members.
"""
        return _pythia8.SigmaRPP_init(self, arg2, settings, arg4, arg5)

    def calcTotEl(self, idAin, idBin, sIn, arg5, arg6):
        """
Calculate integrated total/elastic cross sections.
"""
        return _pythia8.SigmaRPP_calcTotEl(self, idAin, idBin, sIn, arg5, arg6)

    def dsigmaEl(self, t, useCoulomb=False, arg4=True):
        """
Differential elastic cross section.
"""
        return _pythia8.SigmaRPP_dsigmaEl(self, t, useCoulomb, arg4)
    __swig_destroy__ = _pythia8.delete_SigmaRPP
    __del__ = lambda self: None
SigmaRPP_swigregister = _pythia8.SigmaRPP_swigregister
SigmaRPP_swigregister(SigmaRPP)

class SLHAinterface(_object):
    """
The SLHAinterface class handles communication between Pythia and
SusyLesHouches.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SLHAinterface, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SLHAinterface, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_SLHAinterface()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def setPtr(self, infoPtrIn):
        """
Set pointers
"""
        return _pythia8.SLHAinterface_setPtr(self, infoPtrIn)

    def init(self, settings, rndmPtr, couplingsPtrIn, particleDataPtr, useSHLAcouplings, ParticleDataBuffer):
        """
Initialize and switch to SUSY couplings if reading SLHA spectrum
"""
        return _pythia8.SLHAinterface_init(self, settings, rndmPtr, couplingsPtrIn, particleDataPtr, useSHLAcouplings, ParticleDataBuffer)

    def initSLHA(self, settings, particleDataPtr):
        """
Initialize SUSY Les Houches Accord data.
"""
        return _pythia8.SLHAinterface_initSLHA(self, settings, particleDataPtr)

    def pythia2slha(self, particleDataPtr):
        """
Initialize SLHA blocks SMINPUTS and MASS from PYTHIA SM parameter values.
E.g., to make sure that there are no important unfilled entries
"""
        return _pythia8.SLHAinterface_pythia2slha(self, particleDataPtr)
    __swig_setmethods__["slha"] = _pythia8.SLHAinterface_slha_set
    __swig_getmethods__["slha"] = _pythia8.SLHAinterface_slha_get
    if _newclass:
        slha = _swig_property(_pythia8.SLHAinterface_slha_get, _pythia8.SLHAinterface_slha_set)
    __swig_setmethods__["coupSUSY"] = _pythia8.SLHAinterface_coupSUSY_set
    __swig_getmethods__["coupSUSY"] = _pythia8.SLHAinterface_coupSUSY_get
    if _newclass:
        coupSUSY = _swig_property(_pythia8.SLHAinterface_coupSUSY_get, _pythia8.SLHAinterface_coupSUSY_set)
    __swig_setmethods__["couplingsPtr"] = _pythia8.SLHAinterface_couplingsPtr_set
    __swig_getmethods__["couplingsPtr"] = _pythia8.SLHAinterface_couplingsPtr_get
    if _newclass:
        couplingsPtr = _swig_property(_pythia8.SLHAinterface_couplingsPtr_get, _pythia8.SLHAinterface_couplingsPtr_set)
    __swig_setmethods__["infoPtr"] = _pythia8.SLHAinterface_infoPtr_set
    __swig_getmethods__["infoPtr"] = _pythia8.SLHAinterface_infoPtr_get
    if _newclass:
        infoPtr = _swig_property(_pythia8.SLHAinterface_infoPtr_get, _pythia8.SLHAinterface_infoPtr_set)
    __swig_setmethods__["settingsPtr"] = _pythia8.SLHAinterface_settingsPtr_set
    __swig_getmethods__["settingsPtr"] = _pythia8.SLHAinterface_settingsPtr_get
    if _newclass:
        settingsPtr = _swig_property(_pythia8.SLHAinterface_settingsPtr_get, _pythia8.SLHAinterface_settingsPtr_set)
    __swig_setmethods__["meMode"] = _pythia8.SLHAinterface_meMode_set
    __swig_getmethods__["meMode"] = _pythia8.SLHAinterface_meMode_get
    if _newclass:
        meMode = _swig_property(_pythia8.SLHAinterface_meMode_get, _pythia8.SLHAinterface_meMode_set)
    __swig_destroy__ = _pythia8.delete_SLHAinterface
    __del__ = lambda self: None
SLHAinterface_swigregister = _pythia8.SLHAinterface_swigregister
SLHAinterface_swigregister(SLHAinterface)

class WidthFunction(_object):
    """
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, WidthFunction, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, WidthFunction, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor and destructor.
"""
        this = _pythia8.new_WidthFunction()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_WidthFunction
    __del__ = lambda self: None

    def setPointers(self, particleDataPtrIn, coupSUSYPtrIn, infoPtrIn):
        """
Public methods.
"""
        return _pythia8.WidthFunction_setPointers(self, particleDataPtrIn, coupSUSYPtrIn, infoPtrIn)

    def getWidth(self, arg2, arg3):
        """
"""
        return _pythia8.WidthFunction_getWidth(self, arg2, arg3)

    def f(self, xIn):
        """
Wrappers to simplify using FunctionEncapsulator's integrator.
"""
        return _pythia8.WidthFunction_f(self, xIn)
WidthFunction_swigregister = _pythia8.WidthFunction_swigregister
WidthFunction_swigregister(WidthFunction)

class StauWidths(WidthFunction):
    """
Class StauWidths.
"""
    __swig_setmethods__ = {}
    for _s in [WidthFunction]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, StauWidths, name, value)
    __swig_getmethods__ = {}
    for _s in [WidthFunction]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, StauWidths, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_StauWidths()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_StauWidths
    __del__ = lambda self: None

    def getWidth(self, idResIn, idIn):
        """
Public method.
"""
        return _pythia8.StauWidths_getWidth(self, idResIn, idIn)
StauWidths_swigregister = _pythia8.StauWidths_swigregister
StauWidths_swigregister(StauWidths)

class Particle(_object):
    """
Particle class.
This class holds info on a particle in general.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Particle, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Particle, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_Particle(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_Particle
    __del__ = lambda self: None

    def setEvtPtr(self, evtPtrIn):
        """
Member functions to set the Event and ParticleDataEntry pointers.
"""
        return _pythia8.Particle_setEvtPtr(self, evtPtrIn)

    def setPDEPtr(self, pdePtrIn=None):
        """
"""
        return _pythia8.Particle_setPDEPtr(self, pdePtrIn)

    def statusPos(self):
        """
"""
        return _pythia8.Particle_statusPos(self)

    def statusNeg(self):
        """
"""
        return _pythia8.Particle_statusNeg(self)

    def statusCode(self, statusIn):
        """
"""
        return _pythia8.Particle_statusCode(self, statusIn)

    def mothers(self, mother1In=0, mother2In=0):
        """
"""
        return _pythia8.Particle_mothers(self, mother1In, mother2In)

    def daughters(self, daughter1In=0, daughter2In=0):
        """
"""
        return _pythia8.Particle_daughters(self, daughter1In, daughter2In)

    def cols(self, colIn=0, acolIn=0):
        """
"""
        return _pythia8.Particle_cols(self, colIn, acolIn)

    def vProdAdd(self, vProdIn):
        """
"""
        return _pythia8.Particle_vProdAdd(self, vProdIn)

    def id(self, *args):
        """
Member functions for output.
"""
        return _pythia8.Particle_id(self, *args)

    def status(self, *args):
        """
"""
        return _pythia8.Particle_status(self, *args)

    def mother1(self, *args):
        """
"""
        return _pythia8.Particle_mother1(self, *args)

    def mother2(self, *args):
        """
"""
        return _pythia8.Particle_mother2(self, *args)

    def daughter1(self, *args):
        """
"""
        return _pythia8.Particle_daughter1(self, *args)

    def daughter2(self, *args):
        """
"""
        return _pythia8.Particle_daughter2(self, *args)

    def col(self, *args):
        """
"""
        return _pythia8.Particle_col(self, *args)

    def acol(self, *args):
        """
"""
        return _pythia8.Particle_acol(self, *args)

    def p(self, *args):
        """
"""
        return _pythia8.Particle_p(self, *args)

    def px(self, *args):
        """
"""
        return _pythia8.Particle_px(self, *args)

    def py(self, *args):
        """
"""
        return _pythia8.Particle_py(self, *args)

    def pz(self, *args):
        """
"""
        return _pythia8.Particle_pz(self, *args)

    def e(self, *args):
        """
"""
        return _pythia8.Particle_e(self, *args)

    def m(self, *args):
        """
"""
        return _pythia8.Particle_m(self, *args)

    def scale(self, *args):
        """
"""
        return _pythia8.Particle_scale(self, *args)

    def pol(self, *args):
        """
"""
        return _pythia8.Particle_pol(self, *args)

    def hasVertex(self):
        """
"""
        return _pythia8.Particle_hasVertex(self)

    def vProd(self, *args):
        """
"""
        return _pythia8.Particle_vProd(self, *args)

    def xProd(self, *args):
        """
"""
        return _pythia8.Particle_xProd(self, *args)

    def yProd(self, *args):
        """
"""
        return _pythia8.Particle_yProd(self, *args)

    def zProd(self, *args):
        """
"""
        return _pythia8.Particle_zProd(self, *args)

    def tProd(self, *args):
        """
"""
        return _pythia8.Particle_tProd(self, *args)

    def tau(self, *args):
        """
"""
        return _pythia8.Particle_tau(self, *args)

    def idAbs(self):
        """
Member functions for output; derived int and bool quantities.
"""
        return _pythia8.Particle_idAbs(self)

    def statusAbs(self):
        """
"""
        return _pythia8.Particle_statusAbs(self)

    def isFinal(self):
        """
"""
        return _pythia8.Particle_isFinal(self)

    def intPol(self):
        """
"""
        return _pythia8.Particle_intPol(self)

    def isRescatteredIncoming(self):
        """
"""
        return _pythia8.Particle_isRescatteredIncoming(self)

    def m2(self):
        """
Member functions for output; derived double quantities.
"""
        return _pythia8.Particle_m2(self)

    def mCalc(self):
        """
"""
        return _pythia8.Particle_mCalc(self)

    def m2Calc(self):
        """
"""
        return _pythia8.Particle_m2Calc(self)

    def eCalc(self):
        """
"""
        return _pythia8.Particle_eCalc(self)

    def pT(self):
        """
"""
        return _pythia8.Particle_pT(self)

    def pT2(self):
        """
"""
        return _pythia8.Particle_pT2(self)

    def mT(self):
        """
"""
        return _pythia8.Particle_mT(self)

    def mT2(self):
        """
"""
        return _pythia8.Particle_mT2(self)

    def pAbs(self):
        """
"""
        return _pythia8.Particle_pAbs(self)

    def pAbs2(self):
        """
"""
        return _pythia8.Particle_pAbs2(self)

    def eT(self):
        """
"""
        return _pythia8.Particle_eT(self)

    def eT2(self):
        """
"""
        return _pythia8.Particle_eT2(self)

    def theta(self):
        """
"""
        return _pythia8.Particle_theta(self)

    def phi(self):
        """
"""
        return _pythia8.Particle_phi(self)

    def thetaXZ(self):
        """
"""
        return _pythia8.Particle_thetaXZ(self)

    def pPos(self):
        """
"""
        return _pythia8.Particle_pPos(self)

    def pNeg(self):
        """
"""
        return _pythia8.Particle_pNeg(self)

    def eta(self):
        """
"""
        return _pythia8.Particle_eta(self)

    def y(self, *args):
        """
"""
        return _pythia8.Particle_y(self, *args)

    def vDec(self):
        """
"""
        return _pythia8.Particle_vDec(self)

    def xDec(self):
        """
"""
        return _pythia8.Particle_xDec(self)

    def yDec(self):
        """
"""
        return _pythia8.Particle_yDec(self)

    def zDec(self):
        """
"""
        return _pythia8.Particle_zDec(self)

    def tDec(self):
        """
"""
        return _pythia8.Particle_tDec(self)

    def index(self):
        """
Methods that can refer back to the event the particle belongs to.
"""
        return _pythia8.Particle_index(self)

    def iTopCopy(self):
        """
"""
        return _pythia8.Particle_iTopCopy(self)

    def iBotCopy(self):
        """
"""
        return _pythia8.Particle_iBotCopy(self)

    def iTopCopyId(self, simplify=False):
        """
"""
        return _pythia8.Particle_iTopCopyId(self, simplify)

    def iBotCopyId(self, simplify=False):
        """
"""
        return _pythia8.Particle_iBotCopyId(self, simplify)

    def motherList(self):
        """
"""
        return _pythia8.Particle_motherList(self)

    def daughterList(self):
        """
"""
        return _pythia8.Particle_daughterList(self)

    def daughterListRecursive(self):
        """
"""
        return _pythia8.Particle_daughterListRecursive(self)

    def sisterList(self, traceTopBot=False):
        """
"""
        return _pythia8.Particle_sisterList(self, traceTopBot)

    def isAncestor(self, iAncestor):
        """
"""
        return _pythia8.Particle_isAncestor(self, iAncestor)

    def statusHepMC(self):
        """
"""
        return _pythia8.Particle_statusHepMC(self)

    def isFinalPartonLevel(self):
        """
"""
        return _pythia8.Particle_isFinalPartonLevel(self)

    def undoDecay(self):
        """
"""
        return _pythia8.Particle_undoDecay(self)

    def name(self):
        """
Further output, based on a pointer to a ParticleDataEntry object.
"""
        return _pythia8.Particle_name(self)

    def nameWithStatus(self, maxLen=20):
        """
"""
        return _pythia8.Particle_nameWithStatus(self, maxLen)

    def spinType(self):
        """
"""
        return _pythia8.Particle_spinType(self)

    def chargeType(self):
        """
"""
        return _pythia8.Particle_chargeType(self)

    def charge(self):
        """
"""
        return _pythia8.Particle_charge(self)

    def isCharged(self):
        """
"""
        return _pythia8.Particle_isCharged(self)

    def isNeutral(self):
        """
"""
        return _pythia8.Particle_isNeutral(self)

    def colType(self):
        """
"""
        return _pythia8.Particle_colType(self)

    def m0(self):
        """
"""
        return _pythia8.Particle_m0(self)

    def mWidth(self):
        """
"""
        return _pythia8.Particle_mWidth(self)

    def mMin(self):
        """
"""
        return _pythia8.Particle_mMin(self)

    def mMax(self):
        """
"""
        return _pythia8.Particle_mMax(self)

    def mSel(self):
        """
"""
        return _pythia8.Particle_mSel(self)

    def constituentMass(self):
        """
"""
        return _pythia8.Particle_constituentMass(self)

    def tau0(self):
        """
"""
        return _pythia8.Particle_tau0(self)

    def mayDecay(self):
        """
"""
        return _pythia8.Particle_mayDecay(self)

    def canDecay(self):
        """
"""
        return _pythia8.Particle_canDecay(self)

    def doExternalDecay(self):
        """
"""
        return _pythia8.Particle_doExternalDecay(self)

    def isResonance(self):
        """
"""
        return _pythia8.Particle_isResonance(self)

    def isVisible(self):
        """
"""
        return _pythia8.Particle_isVisible(self)

    def isLepton(self):
        """
"""
        return _pythia8.Particle_isLepton(self)

    def isQuark(self):
        """
"""
        return _pythia8.Particle_isQuark(self)

    def isGluon(self):
        """
"""
        return _pythia8.Particle_isGluon(self)

    def isDiquark(self):
        """
"""
        return _pythia8.Particle_isDiquark(self)

    def isParton(self):
        """
"""
        return _pythia8.Particle_isParton(self)

    def isHadron(self):
        """
"""
        return _pythia8.Particle_isHadron(self)

    def particleDataEntry(self):
        """
"""
        return _pythia8.Particle_particleDataEntry(self)

    def rescale3(self, fac):
        """
Member functions that perform operations.
"""
        return _pythia8.Particle_rescale3(self, fac)

    def rescale4(self, fac):
        """
"""
        return _pythia8.Particle_rescale4(self, fac)

    def rescale5(self, fac):
        """
"""
        return _pythia8.Particle_rescale5(self, fac)

    def rot(self, thetaIn, phiIn):
        """
"""
        return _pythia8.Particle_rot(self, thetaIn, phiIn)

    def bst(self, *args):
        """
"""
        return _pythia8.Particle_bst(self, *args)

    def bstback(self, *args):
        """
"""
        return _pythia8.Particle_bstback(self, *args)

    def rotbst(self, M, boostVertex=True):
        """
"""
        return _pythia8.Particle_rotbst(self, M, boostVertex)

    def offsetHistory(self, minMother, addMother, minDaughter, addDaughter):
        """
"""
        return _pythia8.Particle_offsetHistory(self, minMother, addMother, minDaughter, addDaughter)

    def offsetCol(self, addCol):
        """
"""
        return _pythia8.Particle_offsetCol(self, addCol)
Particle_swigregister = _pythia8.Particle_swigregister
Particle_swigregister(Particle)


def m(*args):
    return _pythia8.m(*args)
m = _pythia8.m
class Junction(_object):
    """
The junction class stores what kind of junction it is, the colour indices
of the legs at the junction and as far out as legs have been traced,
and the status codes assigned for fragmentation of each leg.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Junction, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Junction, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_Junction(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def cols(self, j, colIn, endColIn):
        """
"""
        return _pythia8.Junction_cols(self, j, colIn, endColIn)

    def remains(self, *args):
        """
Read out value.
"""
        return _pythia8.Junction_remains(self, *args)

    def kind(self):
        """
"""
        return _pythia8.Junction_kind(self)

    def col(self, *args):
        """
"""
        return _pythia8.Junction_col(self, *args)

    def endCol(self, *args):
        """
"""
        return _pythia8.Junction_endCol(self, *args)

    def status(self, *args):
        """
"""
        return _pythia8.Junction_status(self, *args)
    __swig_destroy__ = _pythia8.delete_Junction
    __del__ = lambda self: None
Junction_swigregister = _pythia8.Junction_swigregister
Junction_swigregister(Junction)

class Event(_object):
    """
The Event class holds all info on the generated event.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Event, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Event, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_Event(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, *args):
        """
Initialize header for event listing, particle data table, and colour.
"""
        return _pythia8.Event_init(self, *args)

    def clear(self):
        """
Clear event record.
"""
        return _pythia8.Event_clear(self)

    def free(self):
        """
"""
        return _pythia8.Event_free(self)

    def reset(self):
        """
Clear event record, and set first particle empty.
"""
        return _pythia8.Event_reset(self)

    def front(self):
        """
Implement standard references to elements in the particle array.
"""
        return _pythia8.Event_front(self)

    def at(self, i):
        """
"""
        return _pythia8.Event_at(self, i)

    def back(self):
        """
"""
        return _pythia8.Event_back(self)

    def size(self):
        """
Event record size.
"""
        return _pythia8.Event_size(self)

    def append(self, *args):
        """
"""
        return _pythia8.Event_append(self, *args)

    def setEvtPtr(self, iSet=-1):
        """
Set pointer to the event for a particle, by default latest one.
"""
        return _pythia8.Event_setEvtPtr(self, iSet)

    def copy(self, iCopy, newStatus=0):
        """
Add a copy of an existing particle at the end of the event record.
"""
        return _pythia8.Event_copy(self, iCopy, newStatus)

    def popBack(self, nRemove=1):
        """
Remove last n entries.
"""
        return _pythia8.Event_popBack(self, nRemove)

    def remove(self, iFirst, iLast, shiftHistory=True):
        """
Remove entries from iFirst to iLast, including endpoints, anf fix history.
(To the extent possible; history pointers in removed range are zeroed.)
"""
        return _pythia8.Event_remove(self, iFirst, iLast, shiftHistory)

    def restorePtrs(self):
        """
Restore all ParticleDataEntry* pointers in the Particle vector.
Useful when a persistent copy of the event record is read back in.
"""
        return _pythia8.Event_restorePtrs(self)

    def saveSize(self):
        """
Save or restore the size of the event record (throwing at the end).
"""
        return _pythia8.Event_saveSize(self)

    def restoreSize(self):
        """
"""
        return _pythia8.Event_restoreSize(self)

    def savedSizeValue(self):
        """
"""
        return _pythia8.Event_savedSizeValue(self)

    def initColTag(self, colTag=0):
        """
Initialize and access colour tag information.
"""
        return _pythia8.Event_initColTag(self, colTag)

    def lastColTag(self):
        """
"""
        return _pythia8.Event_lastColTag(self)

    def nextColTag(self):
        """
"""
        return _pythia8.Event_nextColTag(self)

    def scale(self, *args):
        """
"""
        return _pythia8.Event_scale(self, *args)

    def scaleSecond(self, *args):
        """
"""
        return _pythia8.Event_scaleSecond(self, *args)

    def daughterList(self, i):
        """
Find complete list of daughters.
Note: temporarily retained for CMS compatibility. Do not use!
"""
        return _pythia8.Event_daughterList(self, i)

    def nFinal(self, chargedOnly=False):
        """
Return number of final-state particles, optionally charged only.
"""
        return _pythia8.Event_nFinal(self, chargedOnly)

    def dyAbs(self, i1, i2):
        """
Find separation in y, eta, phi or R between two particles.
"""
        return _pythia8.Event_dyAbs(self, i1, i2)

    def detaAbs(self, i1, i2):
        """
"""
        return _pythia8.Event_detaAbs(self, i1, i2)

    def dphiAbs(self, i1, i2):
        """
"""
        return _pythia8.Event_dphiAbs(self, i1, i2)

    def RRapPhi(self, i1, i2):
        """
"""
        return _pythia8.Event_RRapPhi(self, i1, i2)

    def REtaPhi(self, i1, i2):
        """
"""
        return _pythia8.Event_REtaPhi(self, i1, i2)

    def rot(self, theta, phi):
        """
Member functions for rotations and boosts of an event.
"""
        return _pythia8.Event_rot(self, theta, phi)

    def bst(self, *args):
        """
"""
        return _pythia8.Event_bst(self, *args)

    def rotbst(self, M, boostVertices=True):
        """
"""
        return _pythia8.Event_rotbst(self, M, boostVertices)

    def clearJunctions(self):
        """
Clear the list of junctions.
"""
        return _pythia8.Event_clearJunctions(self)

    def appendJunction(self, *args):
        """
"""
        return _pythia8.Event_appendJunction(self, *args)

    def sizeJunction(self):
        """
"""
        return _pythia8.Event_sizeJunction(self)

    def remainsJunction(self, *args):
        """
"""
        return _pythia8.Event_remainsJunction(self, *args)

    def kindJunction(self, i):
        """
"""
        return _pythia8.Event_kindJunction(self, i)

    def colJunction(self, *args):
        """
"""
        return _pythia8.Event_colJunction(self, *args)

    def endColJunction(self, *args):
        """
"""
        return _pythia8.Event_endColJunction(self, *args)

    def statusJunction(self, *args):
        """
"""
        return _pythia8.Event_statusJunction(self, *args)

    def getJunction(self, *args):
        """
"""
        return _pythia8.Event_getJunction(self, *args)

    def eraseJunction(self, i):
        """
"""
        return _pythia8.Event_eraseJunction(self, i)

    def saveJunctionSize(self):
        """
Save or restore the size of the junction list (throwing at the end).
"""
        return _pythia8.Event_saveJunctionSize(self)

    def restoreJunctionSize(self):
        """
"""
        return _pythia8.Event_restoreJunctionSize(self)

    def listJunctions(self):
        """
List any junctions in the event; for debug mainly.
"""
        return _pythia8.Event_listJunctions(self)

    def savePartonLevelSize(self):
        """
Save event record size at Parton Level, i.e. before hadronization.
"""
        return _pythia8.Event_savePartonLevelSize(self)

    def __iadd__(self, addEvent):
        return _pythia8.Event___iadd__(self, addEvent)

    def __str__(self):
        return _pythia8.Event___str__(self)

    def __getitem__(self, i):
        return _pythia8.Event___getitem__(self, i)
    __swig_destroy__ = _pythia8.delete_Event
    __del__ = lambda self: None
Event_swigregister = _pythia8.Event_swigregister
Event_swigregister(Event)

class FlavContainer(_object):
    """
The FlavContainer class is a simple container for flavour,
including the extra properties needed for popcorn baryon handling.
id = current flavour.
rank = current rank; 0 for endpoint flavour and then increase by 1.
nPop = number of popcorn mesons yet to be produced (1 or 0).
idPop = (absolute sign of) popcorn quark, shared between B and Bbar.
idVtx = (absolute sign of) vertex (= non-shared) quark in diquark.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FlavContainer, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FlavContainer, name)
    __repr__ = _swig_repr

    def __init__(self, idIn=0, rankIn=0, nPopIn=0, idPopIn=0, idVtxIn=0):
        """
Constructor.
"""
        this = _pythia8.new_FlavContainer(idIn, rankIn, nPopIn, idPopIn, idVtxIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def copy(self, flav):
        """
Read in a container into another, without/with id sign flip.
"""
        return _pythia8.FlavContainer_copy(self, flav)

    def anti(self, *args):
        """
"""
        return _pythia8.FlavContainer_anti(self, *args)

    def isDiquark(self):
        """
Check whether is diquark.
"""
        return _pythia8.FlavContainer_isDiquark(self)
    __swig_setmethods__["id"] = _pythia8.FlavContainer_id_set
    __swig_getmethods__["id"] = _pythia8.FlavContainer_id_get
    if _newclass:
        id = _swig_property(_pythia8.FlavContainer_id_get, _pythia8.FlavContainer_id_set)
    __swig_setmethods__["rank"] = _pythia8.FlavContainer_rank_set
    __swig_getmethods__["rank"] = _pythia8.FlavContainer_rank_get
    if _newclass:
        rank = _swig_property(_pythia8.FlavContainer_rank_get, _pythia8.FlavContainer_rank_set)
    __swig_setmethods__["nPop"] = _pythia8.FlavContainer_nPop_set
    __swig_getmethods__["nPop"] = _pythia8.FlavContainer_nPop_get
    if _newclass:
        nPop = _swig_property(_pythia8.FlavContainer_nPop_get, _pythia8.FlavContainer_nPop_set)
    __swig_setmethods__["idPop"] = _pythia8.FlavContainer_idPop_set
    __swig_getmethods__["idPop"] = _pythia8.FlavContainer_idPop_get
    if _newclass:
        idPop = _swig_property(_pythia8.FlavContainer_idPop_get, _pythia8.FlavContainer_idPop_set)
    __swig_setmethods__["idVtx"] = _pythia8.FlavContainer_idVtx_set
    __swig_getmethods__["idVtx"] = _pythia8.FlavContainer_idVtx_get
    if _newclass:
        idVtx = _swig_property(_pythia8.FlavContainer_idVtx_get, _pythia8.FlavContainer_idVtx_set)
    __swig_destroy__ = _pythia8.delete_FlavContainer
    __del__ = lambda self: None
FlavContainer_swigregister = _pythia8.FlavContainer_swigregister
FlavContainer_swigregister(FlavContainer)

class StringFlav(_object):
    """
The StringFlav class is used to select quark and hadron flavours.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, StringFlav, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, StringFlav, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_StringFlav()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_StringFlav
    __del__ = lambda self: None

    def init(self, settings, particleDataPtrIn, rndmPtrIn, infoPtrIn):
        """
Initialize data members.
"""
        return _pythia8.StringFlav_init(self, settings, particleDataPtrIn, rndmPtrIn, infoPtrIn)

    def pickLightQ(self):
        """
Pick a light d, u or s quark according to fixed ratios.
"""
        return _pythia8.StringFlav_pickLightQ(self)

    def pick(self, flavOld, pT=-1.0, nNSP=0.0):
        """
Pick a new flavour (including diquarks) given an incoming one,
either by old standard Gaussian or new alternative exponential.
"""
        return _pythia8.StringFlav_pick(self, flavOld, pT, nNSP)

    def pickGauss(self, flavOld):
        """
"""
        return _pythia8.StringFlav_pickGauss(self, flavOld)

    def pickThermal(self, flavOld, pT, nNSP):
        """
"""
        return _pythia8.StringFlav_pickThermal(self, flavOld, pT, nNSP)

    def combine(self, flav1, flav2):
        """
"""
        return _pythia8.StringFlav_combine(self, flav1, flav2)

    def combineId(self, id1, id2, keepTrying=True):
        """
Ditto, simplified input argument for simple configurations.
"""
        return _pythia8.StringFlav_combineId(self, id1, id2, keepTrying)

    def getHadronIDwin(self):
        """
Return chosen hadron in case of thermal model.
"""
        return _pythia8.StringFlav_getHadronIDwin(self)

    def combineLastThermal(self, flav1, flav2, pT, nNSP):
        """
"""
        return _pythia8.StringFlav_combineLastThermal(self, flav1, flav2, pT, nNSP)

    def getHadronID(self, flav1, flav2, pT=-1.0, nNSP=0, finalTwo=False):
        """
General function, decides whether to just return the hadron id
if thermal model was use or whether to combine the two flavours.
"""
        return _pythia8.StringFlav_getHadronID(self, flav1, flav2, pT, nNSP, finalTwo)

    def getHadronMassWin(self, idHad):
        """
Return hadron mass. Used one if present, pick otherwise.
"""
        return _pythia8.StringFlav_getHadronMassWin(self, idHad)

    def assignPopQ(self, flav):
        """
Assign popcorn quark inside an original (= rank 0) diquark.
"""
        return _pythia8.StringFlav_assignPopQ(self, flav)

    def makeDiquark(self, id1, id2, idHad=0):
        """
Combine two quarks to produce a diquark.
"""
        return _pythia8.StringFlav_makeDiquark(self, id1, id2, idHad)

    def addQuarkDiquark(self, quarkCombis, qID, diqID, hadronID):
        """
Check if quark-diquark combination should be added. If so add.
"""
        return _pythia8.StringFlav_addQuarkDiquark(self, quarkCombis, qID, diqID, hadronID)

    def getMesonSpinCounter(self, hadronID):
        """
Get spin counter for mesons.
"""
        return _pythia8.StringFlav_getMesonSpinCounter(self, hadronID)
StringFlav_swigregister = _pythia8.StringFlav_swigregister
StringFlav_swigregister(StringFlav)

class LundFFRaw(_object):
    """
Auxiliary class to encapsulate (unnormalised) Lund FF.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LundFFRaw, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LundFFRaw, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor and destructor.
"""
        this = _pythia8.new_LundFFRaw()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_LundFFRaw
    __del__ = lambda self: None

    def f(self, args):
        """
f(z) = (1-z)^a / z^c * Exp ( - b * mT2 / z).
"""
        return _pythia8.LundFFRaw_f(self, args)
LundFFRaw_swigregister = _pythia8.LundFFRaw_swigregister
LundFFRaw_swigregister(LundFFRaw)

class LundFFAvg(_object):
    """
Auxiliary class to encapsulate average, <z>, of Lund FF.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LundFFAvg, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LundFFAvg, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor and destructor.
"""
        this = _pythia8.new_LundFFAvg()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_LundFFAvg
    __del__ = lambda self: None

    def f(self, argsIn):
        """
<z> = integral( z * f(z) dz ) / integral( f(z) dz ),
argsIn[] : a, b, c, mT2, and optionally integrator tolerance parameter.
"""
        return _pythia8.LundFFAvg_f(self, argsIn)
LundFFAvg_swigregister = _pythia8.LundFFAvg_swigregister
LundFFAvg_swigregister(LundFFAvg)

class StringZ(_object):
    """
The StringZ class is used to sample the fragmentation function f(z).
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, StringZ, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, StringZ, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_StringZ()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_StringZ
    __del__ = lambda self: None

    def init(self, settings, particleData, rndmPtrIn, infoPtrIn):
        """
Initialize data members.
"""
        return _pythia8.StringZ_init(self, settings, particleData, rndmPtrIn, infoPtrIn)

    def zFrag(self, idOld, idNew=0, mT2=1.):
        """
Fragmentation function: top-level to determine parameters.
"""
        return _pythia8.StringZ_zFrag(self, idOld, idNew, mT2)

    def stopMass(self):
        """
Parameters for stopping in the middle; overloaded for Hidden Valley.
"""
        return _pythia8.StringZ_stopMass(self)

    def stopNewFlav(self):
        """
"""
        return _pythia8.StringZ_stopNewFlav(self)

    def stopSmear(self):
        """
"""
        return _pythia8.StringZ_stopSmear(self)

    def aAreaLund(self):
        """
a and b fragmentation parameters needed in some operations.
"""
        return _pythia8.StringZ_aAreaLund(self)

    def bAreaLund(self):
        """
"""
        return _pythia8.StringZ_bAreaLund(self)

    def deriveBLund(self, settings, particleData):
        """
Method to derive bLund from <z> (for fixed a and reference mT2).
"""
        return _pythia8.StringZ_deriveBLund(self, settings, particleData)
StringZ_swigregister = _pythia8.StringZ_swigregister
StringZ_swigregister(StringZ)

class StringPT(_object):
    """
The StringPT class is used to select select transverse momenta.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, StringPT, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, StringPT, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_StringPT()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_StringPT
    __del__ = lambda self: None

    def init(self, settings, particleDataPtr, rndmPtrIn, infoPtrIn):
        """
Initialize data members.
"""
        return _pythia8.StringPT_init(self, settings, particleDataPtr, rndmPtrIn, infoPtrIn)

    def pxy(self, idIn, nNSP=0.0):
        """
General function, return px and py as a pair in the same call
in either model.
"""
        return _pythia8.StringPT_pxy(self, idIn, nNSP)

    def pxyGauss(self, idIn=0, nNSP=0.0):
        """
"""
        return _pythia8.StringPT_pxyGauss(self, idIn, nNSP)

    def pxyThermal(self, idIn, nNSP=0.0):
        """
"""
        return _pythia8.StringPT_pxyThermal(self, idIn, nNSP)

    def suppressPT2(self, pT2):
        """
Gaussian suppression of given pT2; used in MiniStringFragmentation.
"""
        return _pythia8.StringPT_suppressPT2(self, pT2)
StringPT_swigregister = _pythia8.StringPT_swigregister
StringPT_swigregister(StringPT)

class ColSinglet(_object):
    """
The ColSinglet class contains info on an individual singlet.
Only to be used inside ColConfig, so no private members.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ColSinglet, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ColSinglet, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_ColSinglet(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def size(self):
        """
Size of iParton array.
"""
        return _pythia8.ColSinglet_size(self)
    __swig_setmethods__["iParton"] = _pythia8.ColSinglet_iParton_set
    __swig_getmethods__["iParton"] = _pythia8.ColSinglet_iParton_get
    if _newclass:
        iParton = _swig_property(_pythia8.ColSinglet_iParton_get, _pythia8.ColSinglet_iParton_set)
    __swig_setmethods__["pSum"] = _pythia8.ColSinglet_pSum_set
    __swig_getmethods__["pSum"] = _pythia8.ColSinglet_pSum_get
    if _newclass:
        pSum = _swig_property(_pythia8.ColSinglet_pSum_get, _pythia8.ColSinglet_pSum_set)
    __swig_setmethods__["mass"] = _pythia8.ColSinglet_mass_set
    __swig_getmethods__["mass"] = _pythia8.ColSinglet_mass_get
    if _newclass:
        mass = _swig_property(_pythia8.ColSinglet_mass_get, _pythia8.ColSinglet_mass_set)
    __swig_setmethods__["massExcess"] = _pythia8.ColSinglet_massExcess_set
    __swig_getmethods__["massExcess"] = _pythia8.ColSinglet_massExcess_get
    if _newclass:
        massExcess = _swig_property(_pythia8.ColSinglet_massExcess_get, _pythia8.ColSinglet_massExcess_set)
    __swig_setmethods__["hasJunction"] = _pythia8.ColSinglet_hasJunction_set
    __swig_getmethods__["hasJunction"] = _pythia8.ColSinglet_hasJunction_get
    if _newclass:
        hasJunction = _swig_property(_pythia8.ColSinglet_hasJunction_get, _pythia8.ColSinglet_hasJunction_set)
    __swig_setmethods__["isClosed"] = _pythia8.ColSinglet_isClosed_set
    __swig_getmethods__["isClosed"] = _pythia8.ColSinglet_isClosed_get
    if _newclass:
        isClosed = _swig_property(_pythia8.ColSinglet_isClosed_get, _pythia8.ColSinglet_isClosed_set)
    __swig_setmethods__["isCollected"] = _pythia8.ColSinglet_isCollected_set
    __swig_getmethods__["isCollected"] = _pythia8.ColSinglet_isCollected_get
    if _newclass:
        isCollected = _swig_property(_pythia8.ColSinglet_isCollected_get, _pythia8.ColSinglet_isCollected_set)
    __swig_destroy__ = _pythia8.delete_ColSinglet
    __del__ = lambda self: None
ColSinglet_swigregister = _pythia8.ColSinglet_swigregister
ColSinglet_swigregister(ColSinglet)

class ColConfig(_object):
    """
The ColConfig class describes the colour configuration of the whole event.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ColConfig, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ColConfig, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_ColConfig()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, infoPtrIn, settings, flavSelPtrIn):
        """
Initialize and save pointers.
"""
        return _pythia8.ColConfig_init(self, infoPtrIn, settings, flavSelPtrIn)

    def size(self):
        """
Number of colour singlets.
"""
        return _pythia8.ColConfig_size(self)

    def clear(self):
        """
Clear contents.
"""
        return _pythia8.ColConfig_clear(self)

    def insert(self, iPartonIn, event):
        """
Insert a new colour singlet system in ascending mass order.
Calculate its properties. Join nearby partons.
"""
        return _pythia8.ColConfig_insert(self, iPartonIn, event)

    def simpleInsert(self, iPartonIn, event):
        """
Insert a new qqbar colour singlet system in ascending mass order.
Calculate its properties.
"""
        return _pythia8.ColConfig_simpleInsert(self, iPartonIn, event)

    def erase(self, iSub):
        """
Erase a colour singlet system. (Rare operation.)
"""
        return _pythia8.ColConfig_erase(self, iSub)

    def collect(self, iSub, event, skipTrivial=True):
        """
Collect all partons of singlet to be consecutively ordered.
"""
        return _pythia8.ColConfig_collect(self, iSub, event, skipTrivial)

    def findSinglet(self, i):
        """
Find to which singlet system a particle belongs.
"""
        return _pythia8.ColConfig_findSinglet(self, i)
    __swig_setmethods__["rapPairs"] = _pythia8.ColConfig_rapPairs_set
    __swig_getmethods__["rapPairs"] = _pythia8.ColConfig_rapPairs_get
    if _newclass:
        rapPairs = _swig_property(_pythia8.ColConfig_rapPairs_get, _pythia8.ColConfig_rapPairs_set)

    def __str__(self):
        return _pythia8.ColConfig___str__(self)

    def __getitem__(self, i):
        return _pythia8.ColConfig___getitem__(self, i)
    __swig_destroy__ = _pythia8.delete_ColConfig
    __del__ = lambda self: None
ColConfig_swigregister = _pythia8.ColConfig_swigregister
ColConfig_swigregister(ColConfig)

class StringRegion(_object):
    """
The StringRegion class contains the information related to
one string section in the evolution of a multiparton system.
Only to be used inside StringFragmentation and MiniStringFragmentation,
so no private members.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, StringRegion, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, StringRegion, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_StringRegion()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["isSetUp"] = _pythia8.StringRegion_isSetUp_set
    __swig_getmethods__["isSetUp"] = _pythia8.StringRegion_isSetUp_get
    if _newclass:
        isSetUp = _swig_property(_pythia8.StringRegion_isSetUp_get, _pythia8.StringRegion_isSetUp_set)
    __swig_setmethods__["isEmpty"] = _pythia8.StringRegion_isEmpty_set
    __swig_getmethods__["isEmpty"] = _pythia8.StringRegion_isEmpty_get
    if _newclass:
        isEmpty = _swig_property(_pythia8.StringRegion_isEmpty_get, _pythia8.StringRegion_isEmpty_set)
    __swig_setmethods__["pPos"] = _pythia8.StringRegion_pPos_set
    __swig_getmethods__["pPos"] = _pythia8.StringRegion_pPos_get
    if _newclass:
        pPos = _swig_property(_pythia8.StringRegion_pPos_get, _pythia8.StringRegion_pPos_set)
    __swig_setmethods__["pNeg"] = _pythia8.StringRegion_pNeg_set
    __swig_getmethods__["pNeg"] = _pythia8.StringRegion_pNeg_get
    if _newclass:
        pNeg = _swig_property(_pythia8.StringRegion_pNeg_get, _pythia8.StringRegion_pNeg_set)
    __swig_setmethods__["eX"] = _pythia8.StringRegion_eX_set
    __swig_getmethods__["eX"] = _pythia8.StringRegion_eX_get
    if _newclass:
        eX = _swig_property(_pythia8.StringRegion_eX_get, _pythia8.StringRegion_eX_set)
    __swig_setmethods__["eY"] = _pythia8.StringRegion_eY_set
    __swig_getmethods__["eY"] = _pythia8.StringRegion_eY_get
    if _newclass:
        eY = _swig_property(_pythia8.StringRegion_eY_get, _pythia8.StringRegion_eY_set)
    __swig_setmethods__["pPosMass"] = _pythia8.StringRegion_pPosMass_set
    __swig_getmethods__["pPosMass"] = _pythia8.StringRegion_pPosMass_get
    if _newclass:
        pPosMass = _swig_property(_pythia8.StringRegion_pPosMass_get, _pythia8.StringRegion_pPosMass_set)
    __swig_setmethods__["pNegMass"] = _pythia8.StringRegion_pNegMass_set
    __swig_getmethods__["pNegMass"] = _pythia8.StringRegion_pNegMass_get
    if _newclass:
        pNegMass = _swig_property(_pythia8.StringRegion_pNegMass_get, _pythia8.StringRegion_pNegMass_set)
    __swig_setmethods__["massOffset"] = _pythia8.StringRegion_massOffset_set
    __swig_getmethods__["massOffset"] = _pythia8.StringRegion_massOffset_get
    if _newclass:
        massOffset = _swig_property(_pythia8.StringRegion_massOffset_get, _pythia8.StringRegion_massOffset_set)
    __swig_setmethods__["w2"] = _pythia8.StringRegion_w2_set
    __swig_getmethods__["w2"] = _pythia8.StringRegion_w2_get
    if _newclass:
        w2 = _swig_property(_pythia8.StringRegion_w2_get, _pythia8.StringRegion_w2_set)
    __swig_setmethods__["xPosProj"] = _pythia8.StringRegion_xPosProj_set
    __swig_getmethods__["xPosProj"] = _pythia8.StringRegion_xPosProj_get
    if _newclass:
        xPosProj = _swig_property(_pythia8.StringRegion_xPosProj_get, _pythia8.StringRegion_xPosProj_set)
    __swig_setmethods__["xNegProj"] = _pythia8.StringRegion_xNegProj_set
    __swig_getmethods__["xNegProj"] = _pythia8.StringRegion_xNegProj_get
    if _newclass:
        xNegProj = _swig_property(_pythia8.StringRegion_xNegProj_get, _pythia8.StringRegion_xNegProj_set)
    __swig_setmethods__["pxProj"] = _pythia8.StringRegion_pxProj_set
    __swig_getmethods__["pxProj"] = _pythia8.StringRegion_pxProj_get
    if _newclass:
        pxProj = _swig_property(_pythia8.StringRegion_pxProj_get, _pythia8.StringRegion_pxProj_set)
    __swig_setmethods__["pyProj"] = _pythia8.StringRegion_pyProj_set
    __swig_getmethods__["pyProj"] = _pythia8.StringRegion_pyProj_get
    if _newclass:
        pyProj = _swig_property(_pythia8.StringRegion_pyProj_get, _pythia8.StringRegion_pyProj_set)
    __swig_setmethods__["colPos"] = _pythia8.StringRegion_colPos_set
    __swig_getmethods__["colPos"] = _pythia8.StringRegion_colPos_get
    if _newclass:
        colPos = _swig_property(_pythia8.StringRegion_colPos_get, _pythia8.StringRegion_colPos_set)
    __swig_setmethods__["colNeg"] = _pythia8.StringRegion_colNeg_set
    __swig_getmethods__["colNeg"] = _pythia8.StringRegion_colNeg_get
    if _newclass:
        colNeg = _swig_property(_pythia8.StringRegion_colNeg_get, _pythia8.StringRegion_colNeg_set)

    def gluonOffset(self, iSys, event, iPos, iNeg):
        """
Constants: could only be changed in the code itself.
Data members.
Calculate offset of the region from parton list. Special junction case.
"""
        return _pythia8.StringRegion_gluonOffset(self, iSys, event, iPos, iNeg)

    def gluonOffsetJRF(self, iSys, event, iPos, iNeg, MtoJRF):
        """
"""
        return _pythia8.StringRegion_gluonOffsetJRF(self, iSys, event, iPos, iNeg, MtoJRF)

    def massiveOffset(self, iPos, iNeg, iMax, id1, id2, mc, mb):
        """
If massive case, the offset of the initial regions is calculated.
"""
        return _pythia8.StringRegion_massiveOffset(self, iPos, iNeg, iMax, id1, id2, mc, mb)

    def setUp(self, p1, p2, col1, col2, isMassless=False):
        """
Set up four-vectors for longitudinal and transverse directions.
"""
        return _pythia8.StringRegion_setUp(self, p1, p2, col1, col2, isMassless)

    def pHad(self, xPosIn, xNegIn, pxIn, pyIn):
        """
Construct a four-momentum from (x+, x-, px, py).
"""
        return _pythia8.StringRegion_pHad(self, xPosIn, xNegIn, pxIn, pyIn)

    def project(self, *args):
        """
"""
        return _pythia8.StringRegion_project(self, *args)

    def xPos(self):
        """
"""
        return _pythia8.StringRegion_xPos(self)

    def xNeg(self):
        """
"""
        return _pythia8.StringRegion_xNeg(self)

    def px(self):
        """
"""
        return _pythia8.StringRegion_px(self)

    def py(self):
        """
"""
        return _pythia8.StringRegion_py(self)
    __swig_destroy__ = _pythia8.delete_StringRegion
    __del__ = lambda self: None
StringRegion_swigregister = _pythia8.StringRegion_swigregister
StringRegion_swigregister(StringRegion)
StringRegion.MJOIN = _pythia8.cvar.StringRegion_MJOIN
StringRegion.TINY = _pythia8.cvar.StringRegion_TINY

class StringSystem(_object):
    """
The StringSystem class contains the complete set of all string regions.
Only to be used inside StringFragmentation, so no private members.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, StringSystem, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, StringSystem, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_StringSystem()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def setUp(self, iSys, event):
        """
Set up system from parton list.
"""
        return _pythia8.StringSystem_setUp(self, iSys, event)

    def iReg(self, iPos, iNeg):
        """
Calculate string region from (iPos, iNeg) pair.
"""
        return _pythia8.StringSystem_iReg(self, iPos, iNeg)

    def region(self, iPos, iNeg):
        """
Reference to string region specified by (iPos, iNeg) pair.
"""
        return _pythia8.StringSystem_region(self, iPos, iNeg)

    def regionLowPos(self, iPos):
        """
Reference to low string region specified either by iPos or iNeg.
"""
        return _pythia8.StringSystem_regionLowPos(self, iPos)

    def regionLowNeg(self, iNeg):
        """
"""
        return _pythia8.StringSystem_regionLowNeg(self, iNeg)
    __swig_setmethods__["system"] = _pythia8.StringSystem_system_set
    __swig_getmethods__["system"] = _pythia8.StringSystem_system_get
    if _newclass:
        system = _swig_property(_pythia8.StringSystem_system_get, _pythia8.StringSystem_system_set)
    __swig_setmethods__["sizePartons"] = _pythia8.StringSystem_sizePartons_set
    __swig_getmethods__["sizePartons"] = _pythia8.StringSystem_sizePartons_get
    if _newclass:
        sizePartons = _swig_property(_pythia8.StringSystem_sizePartons_get, _pythia8.StringSystem_sizePartons_set)
    __swig_setmethods__["sizeStrings"] = _pythia8.StringSystem_sizeStrings_set
    __swig_getmethods__["sizeStrings"] = _pythia8.StringSystem_sizeStrings_get
    if _newclass:
        sizeStrings = _swig_property(_pythia8.StringSystem_sizeStrings_get, _pythia8.StringSystem_sizeStrings_set)
    __swig_setmethods__["sizeRegions"] = _pythia8.StringSystem_sizeRegions_set
    __swig_getmethods__["sizeRegions"] = _pythia8.StringSystem_sizeRegions_get
    if _newclass:
        sizeRegions = _swig_property(_pythia8.StringSystem_sizeRegions_get, _pythia8.StringSystem_sizeRegions_set)
    __swig_setmethods__["indxReg"] = _pythia8.StringSystem_indxReg_set
    __swig_getmethods__["indxReg"] = _pythia8.StringSystem_indxReg_get
    if _newclass:
        indxReg = _swig_property(_pythia8.StringSystem_indxReg_get, _pythia8.StringSystem_indxReg_set)
    __swig_setmethods__["iMax"] = _pythia8.StringSystem_iMax_set
    __swig_getmethods__["iMax"] = _pythia8.StringSystem_iMax_get
    if _newclass:
        iMax = _swig_property(_pythia8.StringSystem_iMax_get, _pythia8.StringSystem_iMax_set)
    __swig_setmethods__["mJoin"] = _pythia8.StringSystem_mJoin_set
    __swig_getmethods__["mJoin"] = _pythia8.StringSystem_mJoin_get
    if _newclass:
        mJoin = _swig_property(_pythia8.StringSystem_mJoin_get, _pythia8.StringSystem_mJoin_set)
    __swig_setmethods__["m2Join"] = _pythia8.StringSystem_m2Join_set
    __swig_getmethods__["m2Join"] = _pythia8.StringSystem_m2Join_get
    if _newclass:
        m2Join = _swig_property(_pythia8.StringSystem_m2Join_get, _pythia8.StringSystem_m2Join_set)
    __swig_destroy__ = _pythia8.delete_StringSystem
    __del__ = lambda self: None
StringSystem_swigregister = _pythia8.StringSystem_swigregister
StringSystem_swigregister(StringSystem)

class StringVertex(_object):
    """
The StringVertex class contains the space-time vertex location information
stored during the fragmentation process. No private members.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, StringVertex, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, StringVertex, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_StringVertex(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["fromPos"] = _pythia8.StringVertex_fromPos_set
    __swig_getmethods__["fromPos"] = _pythia8.StringVertex_fromPos_get
    if _newclass:
        fromPos = _swig_property(_pythia8.StringVertex_fromPos_get, _pythia8.StringVertex_fromPos_set)
    __swig_setmethods__["iRegPos"] = _pythia8.StringVertex_iRegPos_set
    __swig_getmethods__["iRegPos"] = _pythia8.StringVertex_iRegPos_get
    if _newclass:
        iRegPos = _swig_property(_pythia8.StringVertex_iRegPos_get, _pythia8.StringVertex_iRegPos_set)
    __swig_setmethods__["iRegNeg"] = _pythia8.StringVertex_iRegNeg_set
    __swig_getmethods__["iRegNeg"] = _pythia8.StringVertex_iRegNeg_get
    if _newclass:
        iRegNeg = _swig_property(_pythia8.StringVertex_iRegNeg_get, _pythia8.StringVertex_iRegNeg_set)
    __swig_setmethods__["xRegPos"] = _pythia8.StringVertex_xRegPos_set
    __swig_getmethods__["xRegPos"] = _pythia8.StringVertex_xRegPos_get
    if _newclass:
        xRegPos = _swig_property(_pythia8.StringVertex_xRegPos_get, _pythia8.StringVertex_xRegPos_set)
    __swig_setmethods__["xRegNeg"] = _pythia8.StringVertex_xRegNeg_set
    __swig_getmethods__["xRegNeg"] = _pythia8.StringVertex_xRegNeg_get
    if _newclass:
        xRegNeg = _swig_property(_pythia8.StringVertex_xRegNeg_get, _pythia8.StringVertex_xRegNeg_set)
    __swig_destroy__ = _pythia8.delete_StringVertex
    __del__ = lambda self: None
StringVertex_swigregister = _pythia8.StringVertex_swigregister
StringVertex_swigregister(StringVertex)

class SigmaPartialWave(_object):
    """
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SigmaPartialWave, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SigmaPartialWave, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor
"""
        this = _pythia8.new_SigmaPartialWave()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, arg2, arg3, arg4, arg5, arg6, arg7):
        """
Initialisation
"""
        return _pythia8.SigmaPartialWave_init(self, arg2, arg3, arg4, arg5, arg6, arg7)

    def readFile(self, arg2, arg3):
        """
Read data file
"""
        return _pythia8.SigmaPartialWave_readFile(self, arg2, arg3)

    def setSubprocess(self, *args):
        """
"""
        return _pythia8.SigmaPartialWave_setSubprocess(self, *args)

    def sigmaEl(self, Wcm):
        """
Return sigma total/elastic, dSigma/dCos(theta)
"""
        return _pythia8.SigmaPartialWave_sigmaEl(self, Wcm)

    def sigmaTot(self, Wcm):
        """
"""
        return _pythia8.SigmaPartialWave_sigmaTot(self, Wcm)

    def dSigma(self, Wcm, cTheta):
        """
"""
        return _pythia8.SigmaPartialWave_dSigma(self, Wcm, cTheta)

    def pickCosTheta(self, arg2):
        """
Return a cos(theta) value
"""
        return _pythia8.SigmaPartialWave_pickCosTheta(self, arg2)

    def getSigmaElMax(self):
        """
Return maximum sigma elastic
"""
        return _pythia8.SigmaPartialWave_getSigmaElMax(self)
    __swig_destroy__ = _pythia8.delete_SigmaPartialWave
    __del__ = lambda self: None
SigmaPartialWave_swigregister = _pythia8.SigmaPartialWave_swigregister
SigmaPartialWave_swigregister(SigmaPartialWave)

class HadronScatterPair(_object):
    """
HadronScatterPair class
  Simple class to hold details of a pair of hadrons which will scatter.
  Stores indices in event record and the measure used for ordering
Store a pair of indices
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, HadronScatterPair, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, HadronScatterPair, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_HadronScatterPair(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def __lt__(self, arg2):
        return _pythia8.HadronScatterPair___lt__(self, arg2)
    __swig_setmethods__["i1"] = _pythia8.HadronScatterPair_i1_set
    __swig_getmethods__["i1"] = _pythia8.HadronScatterPair_i1_get
    if _newclass:
        i1 = _swig_property(_pythia8.HadronScatterPair_i1_get, _pythia8.HadronScatterPair_i1_set)
    __swig_setmethods__["yt1"] = _pythia8.HadronScatterPair_yt1_set
    __swig_getmethods__["yt1"] = _pythia8.HadronScatterPair_yt1_get
    if _newclass:
        yt1 = _swig_property(_pythia8.HadronScatterPair_yt1_get, _pythia8.HadronScatterPair_yt1_set)
    __swig_setmethods__["pt1"] = _pythia8.HadronScatterPair_pt1_set
    __swig_getmethods__["pt1"] = _pythia8.HadronScatterPair_pt1_get
    if _newclass:
        pt1 = _swig_property(_pythia8.HadronScatterPair_pt1_get, _pythia8.HadronScatterPair_pt1_set)
    __swig_setmethods__["i2"] = _pythia8.HadronScatterPair_i2_set
    __swig_getmethods__["i2"] = _pythia8.HadronScatterPair_i2_get
    if _newclass:
        i2 = _swig_property(_pythia8.HadronScatterPair_i2_get, _pythia8.HadronScatterPair_i2_set)
    __swig_setmethods__["yt2"] = _pythia8.HadronScatterPair_yt2_set
    __swig_getmethods__["yt2"] = _pythia8.HadronScatterPair_yt2_get
    if _newclass:
        yt2 = _swig_property(_pythia8.HadronScatterPair_yt2_get, _pythia8.HadronScatterPair_yt2_set)
    __swig_setmethods__["pt2"] = _pythia8.HadronScatterPair_pt2_set
    __swig_getmethods__["pt2"] = _pythia8.HadronScatterPair_pt2_get
    if _newclass:
        pt2 = _swig_property(_pythia8.HadronScatterPair_pt2_get, _pythia8.HadronScatterPair_pt2_set)
    __swig_setmethods__["measure"] = _pythia8.HadronScatterPair_measure_set
    __swig_getmethods__["measure"] = _pythia8.HadronScatterPair_measure_get
    if _newclass:
        measure = _swig_property(_pythia8.HadronScatterPair_measure_get, _pythia8.HadronScatterPair_measure_set)
    __swig_destroy__ = _pythia8.delete_HadronScatterPair
    __del__ = lambda self: None
HadronScatterPair_swigregister = _pythia8.HadronScatterPair_swigregister
HadronScatterPair_swigregister(HadronScatterPair)

class HadronScatter(_object):
    """
HadronScatter class
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, HadronScatter, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, HadronScatter, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_HadronScatter()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, infoPtrIn, settings, rndmPtrIn, particleDataPtr):
        """
Initialisation
"""
        return _pythia8.HadronScatter_init(self, infoPtrIn, settings, rndmPtrIn, particleDataPtr)

    def scatter(self, arg2):
        """
Perform all hadron scatterings - new version. Collective flow.
"""
        return _pythia8.HadronScatter_scatter(self, arg2)

    def scatterOld(self, arg2):
        """
Perform all hadron scatterings - old version.
"""
        return _pythia8.HadronScatter_scatterOld(self, arg2)
    __swig_destroy__ = _pythia8.delete_HadronScatter
    __del__ = lambda self: None
HadronScatter_swigregister = _pythia8.HadronScatter_swigregister
HadronScatter_swigregister(HadronScatter)

class Wave4(_object):
    """
The Wave4 class provides a class for complex four-vector wave functions.
The Wave4 class can be multiplied with the GammaMatrix class to allow
for the writing of helicity matrix elements.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Wave4, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Wave4, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_Wave4(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_Wave4
    __del__ = lambda self: None

    def __call__(self, i):
        return _pythia8.Wave4___call__(self, i)

    def __add__(self, w):
        return _pythia8.Wave4___add__(self, w)

    def __sub__(self, w):
        return _pythia8.Wave4___sub__(self, w)

    def __neg__(self):
        return _pythia8.Wave4___neg__(self)

    def __div__(self, *args):
        return _pythia8.Wave4___div__(self, *args)

    def __str__(self):
        return _pythia8.Wave4___str__(self)

    def __rmul__(self, *args):
        return _pythia8.Wave4___rmul__(self, *args)

    def __mul__(self, *args):
        return _pythia8.Wave4___mul__(self, *args)
Wave4_swigregister = _pythia8.Wave4_swigregister
Wave4_swigregister(Wave4)


def conj(w):
    return _pythia8.conj(w)
conj = _pythia8.conj

def epsilon(w1, w2, w3):
    return _pythia8.epsilon(w1, w2, w3)
epsilon = _pythia8.epsilon

def m2(*args):
    return _pythia8.m2(*args)
m2 = _pythia8.m2
class GammaMatrix(_object):
    """
The GammaMatrix class is a special sparse matrix class used to write
helicity matrix elements in conjuction with the Wave4 class. Note that
only left to right multplication of Wave4 vectors with the GammaMatrix
class is allowed. Additionally, subtracting a scalar from a GammaMatrix
(or subtracting a GammaMatrix from a scalar) subtracts the scalar from
with the (1 - gamma^5) structure of matrix elements in mind.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GammaMatrix, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GammaMatrix, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_GammaMatrix(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_GammaMatrix
    __del__ = lambda self: None

    def __call__(self, I, J):
        return _pythia8.GammaMatrix___call__(self, I, J)

    def __mul__(self, s):
        return _pythia8.GammaMatrix___mul__(self, s)

    def __sub__(self, s):
        return _pythia8.GammaMatrix___sub__(self, s)

    def __add__(self, s):
        return _pythia8.GammaMatrix___add__(self, s)

    def __str__(self):
        return _pythia8.GammaMatrix___str__(self)

    def __rmul__(self, s):
        return _pythia8.GammaMatrix___rmul__(self, s)

    def __rsub__(self, s):
        return _pythia8.GammaMatrix___rsub__(self, s)

    def __radd__(self, s):
        return _pythia8.GammaMatrix___radd__(self, s)
GammaMatrix_swigregister = _pythia8.GammaMatrix_swigregister
GammaMatrix_swigregister(GammaMatrix)


def __mul__(*args):
    return _pythia8.__mul__(*args)
__mul__ = _pythia8.__mul__

def __sub__(*args):
    return _pythia8.__sub__(*args)
__sub__ = _pythia8.__sub__

def __add__(*args):
    return _pythia8.__add__(*args)
__add__ = _pythia8.__add__

def __lshift__(*args):
    return _pythia8.__lshift__(*args)
__lshift__ = _pythia8.__lshift__
class HelicityParticle(Particle):
    """
Helicity particle class containing helicity information, derived from
particle base class.
"""
    __swig_setmethods__ = {}
    for _s in [Particle]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HelicityParticle, name, value)
    __swig_getmethods__ = {}
    for _s in [Particle]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HelicityParticle, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_HelicityParticle(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def wave(self, h):
        """
Methods.
"""
        return _pythia8.HelicityParticle_wave(self, h)

    def waveBar(self, h):
        """
"""
        return _pythia8.HelicityParticle_waveBar(self, h)

    def normalize(self, m):
        """
"""
        return _pythia8.HelicityParticle_normalize(self, m)

    def spinStates(self):
        """
"""
        return _pythia8.HelicityParticle_spinStates(self)

    def m(self, *args):
        """
"""
        return _pythia8.HelicityParticle_m(self, *args)

    def index(self, *args):
        """
"""
        return _pythia8.HelicityParticle_index(self, *args)
    __swig_setmethods__["direction"] = _pythia8.HelicityParticle_direction_set
    __swig_getmethods__["direction"] = _pythia8.HelicityParticle_direction_get
    if _newclass:
        direction = _swig_property(_pythia8.HelicityParticle_direction_get, _pythia8.HelicityParticle_direction_set)
    __swig_setmethods__["rho"] = _pythia8.HelicityParticle_rho_set
    __swig_getmethods__["rho"] = _pythia8.HelicityParticle_rho_get
    if _newclass:
        rho = _swig_property(_pythia8.HelicityParticle_rho_get, _pythia8.HelicityParticle_rho_set)
    __swig_setmethods__["D"] = _pythia8.HelicityParticle_D_set
    __swig_getmethods__["D"] = _pythia8.HelicityParticle_D_get
    if _newclass:
        D = _swig_property(_pythia8.HelicityParticle_D_get, _pythia8.HelicityParticle_D_set)
    __swig_destroy__ = _pythia8.delete_HelicityParticle
    __del__ = lambda self: None
HelicityParticle_swigregister = _pythia8.HelicityParticle_swigregister
HelicityParticle_swigregister(HelicityParticle)

class HelicityMatrixElement(_object):
    """
The helicity matrix element class.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, HelicityMatrixElement, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, HelicityMatrixElement, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor and destructor.
"""
        this = _pythia8.new_HelicityMatrixElement()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_HelicityMatrixElement
    __del__ = lambda self: None

    def initPointers(self, arg2, arg3, arg4=None):
        """
Initialize the physics matrices and pointers.
"""
        return _pythia8.HelicityMatrixElement_initPointers(self, arg2, arg3, arg4)

    def initChannel(self, arg2):
        """
Initialize the channel.
"""
        return _pythia8.HelicityMatrixElement_initChannel(self, arg2)

    def decayWeight(self, arg2):
        """
Recursive sub-method to calculate the matrix element weight for a decay.
"""
        return _pythia8.HelicityMatrixElement_decayWeight(self, arg2)

    def decayWeightMax(self, arg2):
        """
Calculate the maximum matrix element decay weight.
"""
        return _pythia8.HelicityMatrixElement_decayWeightMax(self, arg2)

    def calculateME(self, arg2):
        """
Calculate the helicity matrix element.
"""
        return _pythia8.HelicityMatrixElement_calculateME(self, arg2)

    def calculateD(self, arg2):
        """
Recursive sub-method to calculate the decay matrix for a particle.
"""
        return _pythia8.HelicityMatrixElement_calculateD(self, arg2)

    def calculateRho(self, arg2, arg3):
        """
Pointer to particle data.
Pointer to Standard Model constants.
Pointer to Settings.
Recursive sub-method to calculate the density matrix for a particle.
"""
        return _pythia8.HelicityMatrixElement_calculateRho(self, arg2, arg3)

    def setFermionLine(self, arg2, arg3, arg4):
        """
Set a fermion line.
"""
        return _pythia8.HelicityMatrixElement_setFermionLine(self, arg2, arg3, arg4)

    def breitWigner(self, s, M, G):
        """
Calculate Breit-Wigner's with running widths and fixed.
"""
        return _pythia8.HelicityMatrixElement_breitWigner(self, s, M, G)

    def sBreitWigner(self, m0, m1, s, M, G):
        """
"""
        return _pythia8.HelicityMatrixElement_sBreitWigner(self, m0, m1, s, M, G)

    def pBreitWigner(self, m0, m1, s, M, G):
        """
"""
        return _pythia8.HelicityMatrixElement_pBreitWigner(self, m0, m1, s, M, G)

    def dBreitWigner(self, m0, m1, s, M, G):
        """
"""
        return _pythia8.HelicityMatrixElement_dBreitWigner(self, m0, m1, s, M, G)
HelicityMatrixElement_swigregister = _pythia8.HelicityMatrixElement_swigregister
HelicityMatrixElement_swigregister(HelicityMatrixElement)

class HMETwoFermions2W2TwoFermions(HelicityMatrixElement):
    """
Helicity matrix element for the hard process of two fermions -> W/W' ->
two fermions.
"""
    __swig_setmethods__ = {}
    for _s in [HelicityMatrixElement]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMETwoFermions2W2TwoFermions, name, value)
    __swig_getmethods__ = {}
    for _s in [HelicityMatrixElement]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMETwoFermions2W2TwoFermions, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
"""
        this = _pythia8.new_HMETwoFermions2W2TwoFermions()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initConstants(self):
        """
"""
        return _pythia8.HMETwoFermions2W2TwoFermions_initConstants(self)

    def initWaves(self, arg2):
        """
"""
        return _pythia8.HMETwoFermions2W2TwoFermions_initWaves(self, arg2)

    def calculateME(self, arg2):
        """
"""
        return _pythia8.HMETwoFermions2W2TwoFermions_calculateME(self, arg2)
    __swig_destroy__ = _pythia8.delete_HMETwoFermions2W2TwoFermions
    __del__ = lambda self: None
HMETwoFermions2W2TwoFermions_swigregister = _pythia8.HMETwoFermions2W2TwoFermions_swigregister
HMETwoFermions2W2TwoFermions_swigregister(HMETwoFermions2W2TwoFermions)

class HMETwoFermions2GammaZ2TwoFermions(HelicityMatrixElement):
    """
Helicity matrix element for the hard process of two fermions ->
photon/Z/Z' -> two fermions.
"""
    __swig_setmethods__ = {}
    for _s in [HelicityMatrixElement]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMETwoFermions2GammaZ2TwoFermions, name, value)
    __swig_getmethods__ = {}
    for _s in [HelicityMatrixElement]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMETwoFermions2GammaZ2TwoFermions, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
"""
        this = _pythia8.new_HMETwoFermions2GammaZ2TwoFermions()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initConstants(self):
        """
"""
        return _pythia8.HMETwoFermions2GammaZ2TwoFermions_initConstants(self)

    def initWaves(self, arg2):
        """
"""
        return _pythia8.HMETwoFermions2GammaZ2TwoFermions_initWaves(self, arg2)

    def calculateME(self, arg2):
        """
"""
        return _pythia8.HMETwoFermions2GammaZ2TwoFermions_calculateME(self, arg2)
    __swig_destroy__ = _pythia8.delete_HMETwoFermions2GammaZ2TwoFermions
    __del__ = lambda self: None
HMETwoFermions2GammaZ2TwoFermions_swigregister = _pythia8.HMETwoFermions2GammaZ2TwoFermions_swigregister
HMETwoFermions2GammaZ2TwoFermions_swigregister(HMETwoFermions2GammaZ2TwoFermions)

class HMEX2TwoFermions(HelicityMatrixElement):
    """
Helicity matrix element for the hard process of X -> two fermions.
"""
    __swig_setmethods__ = {}
    for _s in [HelicityMatrixElement]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMEX2TwoFermions, name, value)
    __swig_getmethods__ = {}
    for _s in [HelicityMatrixElement]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMEX2TwoFermions, name)
    __repr__ = _swig_repr

    def initWaves(self, arg2):
        """
"""
        return _pythia8.HMEX2TwoFermions_initWaves(self, arg2)

    def __init__(self):
        this = _pythia8.new_HMEX2TwoFermions()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_HMEX2TwoFermions
    __del__ = lambda self: None
HMEX2TwoFermions_swigregister = _pythia8.HMEX2TwoFermions_swigregister
HMEX2TwoFermions_swigregister(HMEX2TwoFermions)

class HMEW2TwoFermions(HMEX2TwoFermions):
    """
Helicity matrix element for the hard process of W/W' -> two fermions.
"""
    __swig_setmethods__ = {}
    for _s in [HMEX2TwoFermions]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMEW2TwoFermions, name, value)
    __swig_getmethods__ = {}
    for _s in [HMEX2TwoFermions]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMEW2TwoFermions, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
"""
        this = _pythia8.new_HMEW2TwoFermions()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initConstants(self):
        """
"""
        return _pythia8.HMEW2TwoFermions_initConstants(self)

    def calculateME(self, arg2):
        """
"""
        return _pythia8.HMEW2TwoFermions_calculateME(self, arg2)
    __swig_destroy__ = _pythia8.delete_HMEW2TwoFermions
    __del__ = lambda self: None
HMEW2TwoFermions_swigregister = _pythia8.HMEW2TwoFermions_swigregister
HMEW2TwoFermions_swigregister(HMEW2TwoFermions)

class HMEGamma2TwoFermions(HMEX2TwoFermions):
    """
Helicity matrix element for the hard process of photon -> two fermions.
"""
    __swig_setmethods__ = {}
    for _s in [HMEX2TwoFermions]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMEGamma2TwoFermions, name, value)
    __swig_getmethods__ = {}
    for _s in [HMEX2TwoFermions]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMEGamma2TwoFermions, name)
    __repr__ = _swig_repr

    def calculateME(self, arg2):
        """
"""
        return _pythia8.HMEGamma2TwoFermions_calculateME(self, arg2)

    def __init__(self):
        this = _pythia8.new_HMEGamma2TwoFermions()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_HMEGamma2TwoFermions
    __del__ = lambda self: None
HMEGamma2TwoFermions_swigregister = _pythia8.HMEGamma2TwoFermions_swigregister
HMEGamma2TwoFermions_swigregister(HMEGamma2TwoFermions)

class HMEZ2TwoFermions(HMEX2TwoFermions):
    """
Helicity matrix element for the hard process of Z/Z' -> two fermions.
"""
    __swig_setmethods__ = {}
    for _s in [HMEX2TwoFermions]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMEZ2TwoFermions, name, value)
    __swig_getmethods__ = {}
    for _s in [HMEX2TwoFermions]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMEZ2TwoFermions, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
"""
        this = _pythia8.new_HMEZ2TwoFermions()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initConstants(self):
        """
"""
        return _pythia8.HMEZ2TwoFermions_initConstants(self)

    def calculateME(self, arg2):
        """
"""
        return _pythia8.HMEZ2TwoFermions_calculateME(self, arg2)
    __swig_destroy__ = _pythia8.delete_HMEZ2TwoFermions
    __del__ = lambda self: None
HMEZ2TwoFermions_swigregister = _pythia8.HMEZ2TwoFermions_swigregister
HMEZ2TwoFermions_swigregister(HMEZ2TwoFermions)

class HMEHiggs2TwoFermions(HelicityMatrixElement):
    """
Helicity matrix element for the decay of a Higgs ->  two fermions.
Because the Higgs is spin zero the Higgs production mechanism is not
needed for calculating helicity density matrices. However, the CP mixing
is needed.
"""
    __swig_setmethods__ = {}
    for _s in [HelicityMatrixElement]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMEHiggs2TwoFermions, name, value)
    __swig_getmethods__ = {}
    for _s in [HelicityMatrixElement]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMEHiggs2TwoFermions, name)
    __repr__ = _swig_repr

    def initConstants(self):
        """
"""
        return _pythia8.HMEHiggs2TwoFermions_initConstants(self)

    def initWaves(self, arg2):
        """
"""
        return _pythia8.HMEHiggs2TwoFermions_initWaves(self, arg2)

    def calculateME(self, arg2):
        """
"""
        return _pythia8.HMEHiggs2TwoFermions_calculateME(self, arg2)

    def __init__(self):
        this = _pythia8.new_HMEHiggs2TwoFermions()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_HMEHiggs2TwoFermions
    __del__ = lambda self: None
HMEHiggs2TwoFermions_swigregister = _pythia8.HMEHiggs2TwoFermions_swigregister
HMEHiggs2TwoFermions_swigregister(HMEHiggs2TwoFermions)

class HMETauDecay(HelicityMatrixElement):
    """
Base class for all tau decay helicity matrix elements.
"""
    __swig_setmethods__ = {}
    for _s in [HelicityMatrixElement]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMETauDecay, name, value)
    __swig_getmethods__ = {}
    for _s in [HelicityMatrixElement]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMETauDecay, name)
    __repr__ = _swig_repr

    def initWaves(self, arg2):
        """
"""
        return _pythia8.HMETauDecay_initWaves(self, arg2)

    def calculateME(self, arg2):
        """
"""
        return _pythia8.HMETauDecay_calculateME(self, arg2)

    def decayWeightMax(self, arg2):
        """
"""
        return _pythia8.HMETauDecay_decayWeightMax(self, arg2)

    def __init__(self):
        this = _pythia8.new_HMETauDecay()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_HMETauDecay
    __del__ = lambda self: None
HMETauDecay_swigregister = _pythia8.HMETauDecay_swigregister
HMETauDecay_swigregister(HMETauDecay)

class HMETau2Meson(HMETauDecay):
    """
Helicity matrix element for a tau decaying into a single scalar meson.
"""
    __swig_setmethods__ = {}
    for _s in [HMETauDecay]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMETau2Meson, name, value)
    __swig_getmethods__ = {}
    for _s in [HMETauDecay]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMETau2Meson, name)
    __repr__ = _swig_repr

    def initConstants(self):
        """
"""
        return _pythia8.HMETau2Meson_initConstants(self)

    def initHadronicCurrent(self, arg2):
        """
"""
        return _pythia8.HMETau2Meson_initHadronicCurrent(self, arg2)

    def __init__(self):
        this = _pythia8.new_HMETau2Meson()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_HMETau2Meson
    __del__ = lambda self: None
HMETau2Meson_swigregister = _pythia8.HMETau2Meson_swigregister
HMETau2Meson_swigregister(HMETau2Meson)

class HMETau2TwoLeptons(HMETauDecay):
    """
Helicity matrix element for a tau decaying into two leptons.
"""
    __swig_setmethods__ = {}
    for _s in [HMETauDecay]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMETau2TwoLeptons, name, value)
    __swig_getmethods__ = {}
    for _s in [HMETauDecay]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMETau2TwoLeptons, name)
    __repr__ = _swig_repr

    def initConstants(self):
        """
"""
        return _pythia8.HMETau2TwoLeptons_initConstants(self)

    def initWaves(self, arg2):
        """
"""
        return _pythia8.HMETau2TwoLeptons_initWaves(self, arg2)

    def calculateME(self, arg2):
        """
"""
        return _pythia8.HMETau2TwoLeptons_calculateME(self, arg2)

    def __init__(self):
        this = _pythia8.new_HMETau2TwoLeptons()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_HMETau2TwoLeptons
    __del__ = lambda self: None
HMETau2TwoLeptons_swigregister = _pythia8.HMETau2TwoLeptons_swigregister
HMETau2TwoLeptons_swigregister(HMETau2TwoLeptons)

class HMETau2TwoMesonsViaVector(HMETauDecay):
    """
Helicity matrix element for a tau decaying into two mesons through a
vector meson resonance.
"""
    __swig_setmethods__ = {}
    for _s in [HMETauDecay]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMETau2TwoMesonsViaVector, name, value)
    __swig_getmethods__ = {}
    for _s in [HMETauDecay]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMETau2TwoMesonsViaVector, name)
    __repr__ = _swig_repr

    def initConstants(self):
        """
"""
        return _pythia8.HMETau2TwoMesonsViaVector_initConstants(self)

    def initHadronicCurrent(self, arg2):
        """
"""
        return _pythia8.HMETau2TwoMesonsViaVector_initHadronicCurrent(self, arg2)

    def __init__(self):
        this = _pythia8.new_HMETau2TwoMesonsViaVector()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_HMETau2TwoMesonsViaVector
    __del__ = lambda self: None
HMETau2TwoMesonsViaVector_swigregister = _pythia8.HMETau2TwoMesonsViaVector_swigregister
HMETau2TwoMesonsViaVector_swigregister(HMETau2TwoMesonsViaVector)

class HMETau2TwoMesonsViaVectorScalar(HMETauDecay):
    """
Helicity matrix element for a tau decay into two mesons through a vector
or scalar meson resonance.
"""
    __swig_setmethods__ = {}
    for _s in [HMETauDecay]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMETau2TwoMesonsViaVectorScalar, name, value)
    __swig_getmethods__ = {}
    for _s in [HMETauDecay]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMETau2TwoMesonsViaVectorScalar, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
"""
        this = _pythia8.new_HMETau2TwoMesonsViaVectorScalar()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initConstants(self):
        """
"""
        return _pythia8.HMETau2TwoMesonsViaVectorScalar_initConstants(self)

    def initHadronicCurrent(self, arg2):
        """
"""
        return _pythia8.HMETau2TwoMesonsViaVectorScalar_initHadronicCurrent(self, arg2)
    __swig_destroy__ = _pythia8.delete_HMETau2TwoMesonsViaVectorScalar
    __del__ = lambda self: None
HMETau2TwoMesonsViaVectorScalar_swigregister = _pythia8.HMETau2TwoMesonsViaVectorScalar_swigregister
HMETau2TwoMesonsViaVectorScalar_swigregister(HMETau2TwoMesonsViaVectorScalar)

class HMETau2ThreeMesons(HMETauDecay):
    """
Helicity matrix element for a tau decay into three mesons (base class).
"""
    __swig_setmethods__ = {}
    for _s in [HMETauDecay]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMETau2ThreeMesons, name, value)
    __swig_getmethods__ = {}
    for _s in [HMETauDecay]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMETau2ThreeMesons, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
"""
        this = _pythia8.new_HMETau2ThreeMesons()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initConstants(self):
        """
"""
        return _pythia8.HMETau2ThreeMesons_initConstants(self)

    def initHadronicCurrent(self, arg2):
        """
"""
        return _pythia8.HMETau2ThreeMesons_initHadronicCurrent(self, arg2)
    __swig_destroy__ = _pythia8.delete_HMETau2ThreeMesons
    __del__ = lambda self: None
HMETau2ThreeMesons_swigregister = _pythia8.HMETau2ThreeMesons_swigregister
HMETau2ThreeMesons_swigregister(HMETau2ThreeMesons)

class HMETau2ThreePions(HMETau2ThreeMesons):
    """
Helicity matrix element for a tau decay into three pions.
"""
    __swig_setmethods__ = {}
    for _s in [HMETau2ThreeMesons]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMETau2ThreePions, name, value)
    __swig_getmethods__ = {}
    for _s in [HMETau2ThreeMesons]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMETau2ThreePions, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
"""
        this = _pythia8.new_HMETau2ThreePions()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_HMETau2ThreePions
    __del__ = lambda self: None
HMETau2ThreePions_swigregister = _pythia8.HMETau2ThreePions_swigregister
HMETau2ThreePions_swigregister(HMETau2ThreePions)

class HMETau2ThreeMesonsWithKaons(HMETau2ThreeMesons):
    """
Helicity matrix element for a tau decay into three mesons with kaons.
"""
    __swig_setmethods__ = {}
    for _s in [HMETau2ThreeMesons]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMETau2ThreeMesonsWithKaons, name, value)
    __swig_getmethods__ = {}
    for _s in [HMETau2ThreeMesons]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMETau2ThreeMesonsWithKaons, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
"""
        this = _pythia8.new_HMETau2ThreeMesonsWithKaons()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_HMETau2ThreeMesonsWithKaons
    __del__ = lambda self: None
HMETau2ThreeMesonsWithKaons_swigregister = _pythia8.HMETau2ThreeMesonsWithKaons_swigregister
HMETau2ThreeMesonsWithKaons_swigregister(HMETau2ThreeMesonsWithKaons)

class HMETau2ThreeMesonsGeneric(HMETau2ThreeMesons):
    """
Helicity matrix element for a tau decay into generic three mesons.
"""
    __swig_setmethods__ = {}
    for _s in [HMETau2ThreeMesons]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMETau2ThreeMesonsGeneric, name, value)
    __swig_getmethods__ = {}
    for _s in [HMETau2ThreeMesons]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMETau2ThreeMesonsGeneric, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
"""
        this = _pythia8.new_HMETau2ThreeMesonsGeneric()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_HMETau2ThreeMesonsGeneric
    __del__ = lambda self: None
HMETau2ThreeMesonsGeneric_swigregister = _pythia8.HMETau2ThreeMesonsGeneric_swigregister
HMETau2ThreeMesonsGeneric_swigregister(HMETau2ThreeMesonsGeneric)

class HMETau2TwoPionsGamma(HMETauDecay):
    """
Helicity matrix element for a tau decay into two pions and a photon.
"""
    __swig_setmethods__ = {}
    for _s in [HMETauDecay]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMETau2TwoPionsGamma, name, value)
    __swig_getmethods__ = {}
    for _s in [HMETauDecay]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMETau2TwoPionsGamma, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
"""
        this = _pythia8.new_HMETau2TwoPionsGamma()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initConstants(self):
        """
"""
        return _pythia8.HMETau2TwoPionsGamma_initConstants(self)

    def initWaves(self, arg2):
        """
"""
        return _pythia8.HMETau2TwoPionsGamma_initWaves(self, arg2)

    def calculateME(self, arg2):
        """
"""
        return _pythia8.HMETau2TwoPionsGamma_calculateME(self, arg2)
    __swig_destroy__ = _pythia8.delete_HMETau2TwoPionsGamma
    __del__ = lambda self: None
HMETau2TwoPionsGamma_swigregister = _pythia8.HMETau2TwoPionsGamma_swigregister
HMETau2TwoPionsGamma_swigregister(HMETau2TwoPionsGamma)

class HMETau2FourPions(HMETauDecay):
    """
Helicity matrix element for a tau decay into four pions.
"""
    __swig_setmethods__ = {}
    for _s in [HMETauDecay]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMETau2FourPions, name, value)
    __swig_getmethods__ = {}
    for _s in [HMETauDecay]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMETau2FourPions, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
"""
        this = _pythia8.new_HMETau2FourPions()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initConstants(self):
        """
"""
        return _pythia8.HMETau2FourPions_initConstants(self)

    def initHadronicCurrent(self, p):
        """
"""
        return _pythia8.HMETau2FourPions_initHadronicCurrent(self, p)
    __swig_destroy__ = _pythia8.delete_HMETau2FourPions
    __del__ = lambda self: None
HMETau2FourPions_swigregister = _pythia8.HMETau2FourPions_swigregister
HMETau2FourPions_swigregister(HMETau2FourPions)

class HMETau2FivePions(HMETauDecay):
    """
Helicity matrix element for a tau decaying into five pions.
"""
    __swig_setmethods__ = {}
    for _s in [HMETauDecay]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMETau2FivePions, name, value)
    __swig_getmethods__ = {}
    for _s in [HMETauDecay]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMETau2FivePions, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
"""
        this = _pythia8.new_HMETau2FivePions()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initConstants(self):
        """
"""
        return _pythia8.HMETau2FivePions_initConstants(self)

    def initHadronicCurrent(self, arg2):
        """
"""
        return _pythia8.HMETau2FivePions_initHadronicCurrent(self, arg2)
    __swig_destroy__ = _pythia8.delete_HMETau2FivePions
    __del__ = lambda self: None
HMETau2FivePions_swigregister = _pythia8.HMETau2FivePions_swigregister
HMETau2FivePions_swigregister(HMETau2FivePions)

class HMETau2PhaseSpace(HMETauDecay):
    """
Helicity matrix element for a tau decay into flat phase space.
"""
    __swig_setmethods__ = {}
    for _s in [HMETauDecay]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, HMETau2PhaseSpace, name, value)
    __swig_getmethods__ = {}
    for _s in [HMETauDecay]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, HMETau2PhaseSpace, name)
    __repr__ = _swig_repr

    def initWaves(self, arg2):
        """
"""
        return _pythia8.HMETau2PhaseSpace_initWaves(self, arg2)

    def calculateME(self, arg2):
        """
"""
        return _pythia8.HMETau2PhaseSpace_calculateME(self, arg2)

    def calculateD(self, arg2):
        """
"""
        return _pythia8.HMETau2PhaseSpace_calculateD(self, arg2)

    def calculateRho(self, arg2, arg3):
        """
"""
        return _pythia8.HMETau2PhaseSpace_calculateRho(self, arg2, arg3)

    def decayWeight(self, arg2):
        """
"""
        return _pythia8.HMETau2PhaseSpace_decayWeight(self, arg2)

    def decayWeightMax(self, arg2):
        """
"""
        return _pythia8.HMETau2PhaseSpace_decayWeightMax(self, arg2)

    def __init__(self):
        this = _pythia8.new_HMETau2PhaseSpace()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_HMETau2PhaseSpace
    __del__ = lambda self: None
HMETau2PhaseSpace_swigregister = _pythia8.HMETau2PhaseSpace_swigregister
HMETau2PhaseSpace_swigregister(HMETau2PhaseSpace)

class LHAProcess(_object):
    """
A class for the processes stored in LHAup.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHAProcess, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LHAProcess, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_LHAProcess(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["idProc"] = _pythia8.LHAProcess_idProc_set
    __swig_getmethods__["idProc"] = _pythia8.LHAProcess_idProc_get
    if _newclass:
        idProc = _swig_property(_pythia8.LHAProcess_idProc_get, _pythia8.LHAProcess_idProc_set)
    __swig_setmethods__["xSecProc"] = _pythia8.LHAProcess_xSecProc_set
    __swig_getmethods__["xSecProc"] = _pythia8.LHAProcess_xSecProc_get
    if _newclass:
        xSecProc = _swig_property(_pythia8.LHAProcess_xSecProc_get, _pythia8.LHAProcess_xSecProc_set)
    __swig_setmethods__["xErrProc"] = _pythia8.LHAProcess_xErrProc_set
    __swig_getmethods__["xErrProc"] = _pythia8.LHAProcess_xErrProc_get
    if _newclass:
        xErrProc = _swig_property(_pythia8.LHAProcess_xErrProc_get, _pythia8.LHAProcess_xErrProc_set)
    __swig_setmethods__["xMaxProc"] = _pythia8.LHAProcess_xMaxProc_set
    __swig_getmethods__["xMaxProc"] = _pythia8.LHAProcess_xMaxProc_get
    if _newclass:
        xMaxProc = _swig_property(_pythia8.LHAProcess_xMaxProc_get, _pythia8.LHAProcess_xMaxProc_set)
    __swig_destroy__ = _pythia8.delete_LHAProcess
    __del__ = lambda self: None
LHAProcess_swigregister = _pythia8.LHAProcess_swigregister
LHAProcess_swigregister(LHAProcess)

class LHAParticle(_object):
    """
A class for the particles stored in LHAup.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHAParticle, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LHAParticle, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_LHAParticle(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["idPart"] = _pythia8.LHAParticle_idPart_set
    __swig_getmethods__["idPart"] = _pythia8.LHAParticle_idPart_get
    if _newclass:
        idPart = _swig_property(_pythia8.LHAParticle_idPart_get, _pythia8.LHAParticle_idPart_set)
    __swig_setmethods__["statusPart"] = _pythia8.LHAParticle_statusPart_set
    __swig_getmethods__["statusPart"] = _pythia8.LHAParticle_statusPart_get
    if _newclass:
        statusPart = _swig_property(_pythia8.LHAParticle_statusPart_get, _pythia8.LHAParticle_statusPart_set)
    __swig_setmethods__["mother1Part"] = _pythia8.LHAParticle_mother1Part_set
    __swig_getmethods__["mother1Part"] = _pythia8.LHAParticle_mother1Part_get
    if _newclass:
        mother1Part = _swig_property(_pythia8.LHAParticle_mother1Part_get, _pythia8.LHAParticle_mother1Part_set)
    __swig_setmethods__["mother2Part"] = _pythia8.LHAParticle_mother2Part_set
    __swig_getmethods__["mother2Part"] = _pythia8.LHAParticle_mother2Part_get
    if _newclass:
        mother2Part = _swig_property(_pythia8.LHAParticle_mother2Part_get, _pythia8.LHAParticle_mother2Part_set)
    __swig_setmethods__["col1Part"] = _pythia8.LHAParticle_col1Part_set
    __swig_getmethods__["col1Part"] = _pythia8.LHAParticle_col1Part_get
    if _newclass:
        col1Part = _swig_property(_pythia8.LHAParticle_col1Part_get, _pythia8.LHAParticle_col1Part_set)
    __swig_setmethods__["col2Part"] = _pythia8.LHAParticle_col2Part_set
    __swig_getmethods__["col2Part"] = _pythia8.LHAParticle_col2Part_get
    if _newclass:
        col2Part = _swig_property(_pythia8.LHAParticle_col2Part_get, _pythia8.LHAParticle_col2Part_set)
    __swig_setmethods__["pxPart"] = _pythia8.LHAParticle_pxPart_set
    __swig_getmethods__["pxPart"] = _pythia8.LHAParticle_pxPart_get
    if _newclass:
        pxPart = _swig_property(_pythia8.LHAParticle_pxPart_get, _pythia8.LHAParticle_pxPart_set)
    __swig_setmethods__["pyPart"] = _pythia8.LHAParticle_pyPart_set
    __swig_getmethods__["pyPart"] = _pythia8.LHAParticle_pyPart_get
    if _newclass:
        pyPart = _swig_property(_pythia8.LHAParticle_pyPart_get, _pythia8.LHAParticle_pyPart_set)
    __swig_setmethods__["pzPart"] = _pythia8.LHAParticle_pzPart_set
    __swig_getmethods__["pzPart"] = _pythia8.LHAParticle_pzPart_get
    if _newclass:
        pzPart = _swig_property(_pythia8.LHAParticle_pzPart_get, _pythia8.LHAParticle_pzPart_set)
    __swig_setmethods__["ePart"] = _pythia8.LHAParticle_ePart_set
    __swig_getmethods__["ePart"] = _pythia8.LHAParticle_ePart_get
    if _newclass:
        ePart = _swig_property(_pythia8.LHAParticle_ePart_get, _pythia8.LHAParticle_ePart_set)
    __swig_setmethods__["mPart"] = _pythia8.LHAParticle_mPart_set
    __swig_getmethods__["mPart"] = _pythia8.LHAParticle_mPart_get
    if _newclass:
        mPart = _swig_property(_pythia8.LHAParticle_mPart_get, _pythia8.LHAParticle_mPart_set)
    __swig_setmethods__["tauPart"] = _pythia8.LHAParticle_tauPart_set
    __swig_getmethods__["tauPart"] = _pythia8.LHAParticle_tauPart_get
    if _newclass:
        tauPart = _swig_property(_pythia8.LHAParticle_tauPart_get, _pythia8.LHAParticle_tauPart_set)
    __swig_setmethods__["spinPart"] = _pythia8.LHAParticle_spinPart_set
    __swig_getmethods__["spinPart"] = _pythia8.LHAParticle_spinPart_get
    if _newclass:
        spinPart = _swig_property(_pythia8.LHAParticle_spinPart_get, _pythia8.LHAParticle_spinPart_set)
    __swig_setmethods__["scalePart"] = _pythia8.LHAParticle_scalePart_set
    __swig_getmethods__["scalePart"] = _pythia8.LHAParticle_scalePart_get
    if _newclass:
        scalePart = _swig_property(_pythia8.LHAParticle_scalePart_get, _pythia8.LHAParticle_scalePart_set)
    __swig_destroy__ = _pythia8.delete_LHAParticle
    __del__ = lambda self: None
LHAParticle_swigregister = _pythia8.LHAParticle_swigregister
LHAParticle_swigregister(LHAParticle)

class LHAup(_object):
    """
LHAup is base class for initialization and event information
from an external parton-level generator.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHAup, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, LHAup, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _pythia8.delete_LHAup
    __del__ = lambda self: None

    def setPtr(self, infoPtrIn):
        """
Set info pointer.
"""
        return _pythia8.LHAup_setPtr(self, infoPtrIn)

    def newEventFile(self, arg0):
        """
Method to be used for LHAupLHEF derived class.
"""
        return _pythia8.LHAup_newEventFile(self, arg0)

    def fileFound(self):
        """
"""
        return _pythia8.LHAup_fileFound(self)

    def useExternal(self):
        """
"""
        return _pythia8.LHAup_useExternal(self)

    def setInit(self):
        """
A pure virtual method setInit, wherein all initialization information
is supposed to be set in the derived class. Can do this by reading a
file or some other way, as desired. Returns false if it did not work.
"""
        return _pythia8.LHAup_setInit(self)

    def idBeamA(self):
        """
Give back info on beams.
"""
        return _pythia8.LHAup_idBeamA(self)

    def idBeamB(self):
        """
"""
        return _pythia8.LHAup_idBeamB(self)

    def eBeamA(self):
        """
"""
        return _pythia8.LHAup_eBeamA(self)

    def eBeamB(self):
        """
"""
        return _pythia8.LHAup_eBeamB(self)

    def pdfGroupBeamA(self):
        """
"""
        return _pythia8.LHAup_pdfGroupBeamA(self)

    def pdfGroupBeamB(self):
        """
"""
        return _pythia8.LHAup_pdfGroupBeamB(self)

    def pdfSetBeamA(self):
        """
"""
        return _pythia8.LHAup_pdfSetBeamA(self)

    def pdfSetBeamB(self):
        """
"""
        return _pythia8.LHAup_pdfSetBeamB(self)

    def strategy(self):
        """
Give back weight strategy.
"""
        return _pythia8.LHAup_strategy(self)

    def sizeProc(self):
        """
Give back info on processes.
"""
        return _pythia8.LHAup_sizeProc(self)

    def xSec(self, proc):
        """
"""
        return _pythia8.LHAup_xSec(self, proc)

    def xErr(self, proc):
        """
"""
        return _pythia8.LHAup_xErr(self, proc)

    def xMax(self, proc):
        """
"""
        return _pythia8.LHAup_xMax(self, proc)

    def xSecSum(self):
        """
"""
        return _pythia8.LHAup_xSecSum(self)

    def xErrSum(self):
        """
"""
        return _pythia8.LHAup_xErrSum(self)

    def listInit(self):
        """
Print the initialization info; useful to check that setting it worked.
"""
        return _pythia8.LHAup_listInit(self)

    def setEvent(self, idProcIn=0):
        """
A pure virtual method setEvent, wherein information on the next event
is supposed to be set in the derived class.
Strategies +-1 and +-2: idProcIn is the process type, selected by PYTHIA.
Strategies +-3 and +-4: idProcIn is dummy; process choice is made locally.
The method can find the next event by a runtime interface to another
program, or by reading a file, as desired.
The method should return false if it did not work.
"""
        return _pythia8.LHAup_setEvent(self, idProcIn)

    def idProcess(self, *args):
        """
Give back process number, weight, scale, alpha_em, alpha_s.
"""
        return _pythia8.LHAup_idProcess(self, *args)

    def weight(self):
        """
"""
        return _pythia8.LHAup_weight(self)

    def alphaQED(self):
        """
"""
        return _pythia8.LHAup_alphaQED(self)

    def alphaQCD(self):
        """
"""
        return _pythia8.LHAup_alphaQCD(self)

    def sizePart(self):
        """
Give back info on separate particle.
"""
        return _pythia8.LHAup_sizePart(self)

    def id(self, part):
        """
"""
        return _pythia8.LHAup_id(self, part)

    def status(self, part):
        """
"""
        return _pythia8.LHAup_status(self, part)

    def mother1(self, part):
        """
"""
        return _pythia8.LHAup_mother1(self, part)

    def mother2(self, part):
        """
"""
        return _pythia8.LHAup_mother2(self, part)

    def col1(self, part):
        """
"""
        return _pythia8.LHAup_col1(self, part)

    def col2(self, part):
        """
"""
        return _pythia8.LHAup_col2(self, part)

    def px(self, part):
        """
"""
        return _pythia8.LHAup_px(self, part)

    def py(self, part):
        """
"""
        return _pythia8.LHAup_py(self, part)

    def pz(self, part):
        """
"""
        return _pythia8.LHAup_pz(self, part)

    def e(self, part):
        """
"""
        return _pythia8.LHAup_e(self, part)

    def m(self, part):
        """
"""
        return _pythia8.LHAup_m(self, part)

    def tau(self, part):
        """
"""
        return _pythia8.LHAup_tau(self, part)

    def spin(self, part):
        """
"""
        return _pythia8.LHAup_spin(self, part)

    def scale(self, *args):
        """
"""
        return _pythia8.LHAup_scale(self, *args)

    def id1(self):
        """
Give back info on flavour and x values of hard-process initiators.
"""
        return _pythia8.LHAup_id1(self)

    def id2(self):
        """
"""
        return _pythia8.LHAup_id2(self)

    def x1(self):
        """
"""
        return _pythia8.LHAup_x1(self)

    def x2(self):
        """
"""
        return _pythia8.LHAup_x2(self)

    def pdfIsSet(self):
        """
Optional: give back info on parton density values of event.
"""
        return _pythia8.LHAup_pdfIsSet(self)

    def id1pdf(self):
        """
"""
        return _pythia8.LHAup_id1pdf(self)

    def id2pdf(self):
        """
"""
        return _pythia8.LHAup_id2pdf(self)

    def x1pdf(self):
        """
"""
        return _pythia8.LHAup_x1pdf(self)

    def x2pdf(self):
        """
"""
        return _pythia8.LHAup_x2pdf(self)

    def scalePDF(self):
        """
"""
        return _pythia8.LHAup_scalePDF(self)

    def pdf1(self):
        """
"""
        return _pythia8.LHAup_pdf1(self)

    def pdf2(self):
        """
"""
        return _pythia8.LHAup_pdf2(self)

    def scaleShowersIsSet(self):
        """
Optional: give back info on parton shower scales.
"""
        return _pythia8.LHAup_scaleShowersIsSet(self)

    def scaleShowers(self, i):
        """
"""
        return _pythia8.LHAup_scaleShowers(self, i)

    def listEvent(self):
        """
Print the info; useful to check that reading an event worked.
"""
        return _pythia8.LHAup_listEvent(self)

    def skipEvent(self, nSkip):
        """
Skip ahead a number of events, which are not considered further.
Mainly intended for debug when using the LHAupLHEF class.
"""
        return _pythia8.LHAup_skipEvent(self, nSkip)

    def openLHEF(self, fileNameIn):
        """
Four routines to write a Les Houches Event file in steps.
"""
        return _pythia8.LHAup_openLHEF(self, fileNameIn)

    def closeLHEF(self, updateInit=False):
        """
"""
        return _pythia8.LHAup_closeLHEF(self, updateInit)

    def initLHEF(self):
        """
"""
        return _pythia8.LHAup_initLHEF(self)

    def eventLHEF(self, verbose=True):
        """
"""
        return _pythia8.LHAup_eventLHEF(self, verbose)

    def getFileName(self):
        """
Get access to the Les Houches Event file name.
"""
        return _pythia8.LHAup_getFileName(self)

    def __init__(self, strategyIn=3):
        """
Constructor. Sets default to be that events come with unit weight.
"""
        if self.__class__ == LHAup:
            _self = None
        else:
            _self = self
        this = _pythia8.new_LHAup(_self, strategyIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["infoPtr"] = _pythia8.LHAup_infoPtr_set
    __swig_getmethods__["infoPtr"] = _pythia8.LHAup_infoPtr_get
    if _newclass:
        infoPtr = _swig_property(_pythia8.LHAup_infoPtr_get, _pythia8.LHAup_infoPtr_set)

    def setBeamA(self, idIn, eIn, pdfGroupIn=0, pdfSetIn=0):
        """
Allow conversion from mb to pb.
Pointer to various information on the generation.
Input beam info.
"""
        return _pythia8.LHAup_setBeamA(self, idIn, eIn, pdfGroupIn, pdfSetIn)

    def setBeamB(self, idIn, eIn, pdfGroupIn=0, pdfSetIn=0):
        """
"""
        return _pythia8.LHAup_setBeamB(self, idIn, eIn, pdfGroupIn, pdfSetIn)

    def setStrategy(self, strategyIn):
        """
Input process weight strategy.
"""
        return _pythia8.LHAup_setStrategy(self, strategyIn)

    def addProcess(self, idProcIn, xSecIn=1., xErrIn=0., xMaxIn=1.):
        """
Input process info.
"""
        return _pythia8.LHAup_addProcess(self, idProcIn, xSecIn, xErrIn, xMaxIn)

    def setXSec(self, iP, xSecIn):
        """
Possibility to update some cross section info at end of run.
"""
        return _pythia8.LHAup_setXSec(self, iP, xSecIn)

    def setXErr(self, iP, xErrIn):
        """
"""
        return _pythia8.LHAup_setXErr(self, iP, xErrIn)

    def setXMax(self, iP, xMaxIn):
        """
"""
        return _pythia8.LHAup_setXMax(self, iP, xMaxIn)

    def setProcess(self, idProcIn=0, weightIn=1., scaleIn=0., alphaQEDIn=0.0073, alphaQCDIn=0.12):
        """
Input info on the selected process.
"""
        return _pythia8.LHAup_setProcess(self, idProcIn, weightIn, scaleIn, alphaQEDIn, alphaQCDIn)

    def addParticle(self, *args):
        """
"""
        return _pythia8.LHAup_addParticle(self, *args)

    def setIdX(self, id1In, id2In, x1In, x2In):
        """
Input info on flavour and x values of hard-process initiators.
"""
        return _pythia8.LHAup_setIdX(self, id1In, id2In, x1In, x2In)

    def setPdf(self, id1pdfIn, id2pdfIn, x1pdfIn, x2pdfIn, scalePDFIn, pdf1In, pdf2In, pdfIsSetIn):
        """
Optionally input info on parton density values of event.
"""
        return _pythia8.LHAup_setPdf(self, id1pdfIn, id2pdfIn, x1pdfIn, x2pdfIn, scalePDFIn, pdf1In, pdf2In, pdfIsSetIn)

    def setScaleShowers(self, scaleIn1, scaleIn2=0.):
        """
Optionally input info on parton shower starting scale; two for DPS.
"""
        return _pythia8.LHAup_setScaleShowers(self, scaleIn1, scaleIn2)

    def setInitLHEF(self, arg2, readHeaders=False):
        """
Three routines for LHEF files, but put here for flexibility.
"""
        return _pythia8.LHAup_setInitLHEF(self, arg2, readHeaders)

    def setNewEventLHEF(self, arg2):
        """
"""
        return _pythia8.LHAup_setNewEventLHEF(self, arg2)

    def setOldEventLHEF(self):
        """
"""
        return _pythia8.LHAup_setOldEventLHEF(self)

    def openFile(self, fn, ifs):
        """
Helper routines to open and close a file handling GZIPSUPPORT:
  ifstream ifs;
  istream *is = openFile("myFile.txt", ifs);
  -- Process file using is --
  closeFile(is, ifs);
"""
        return _pythia8.LHAup_openFile(self, fn, ifs)

    def closeFile(self, arg2, ifs):
        """
"""
        return _pythia8.LHAup_closeFile(self, arg2, ifs)

    def setInfoHeader(self, key, val):
        """
LHAup is a friend class to infoPtr, but derived classes
are not. This wrapper function can be used by derived classes
to set headers in the Info class.
"""
        return _pythia8.LHAup_setInfoHeader(self, key, val)
    __swig_setmethods__["nupSave"] = _pythia8.LHAup_nupSave_set
    __swig_getmethods__["nupSave"] = _pythia8.LHAup_nupSave_get
    if _newclass:
        nupSave = _swig_property(_pythia8.LHAup_nupSave_get, _pythia8.LHAup_nupSave_set)
    __swig_setmethods__["idprupSave"] = _pythia8.LHAup_idprupSave_set
    __swig_getmethods__["idprupSave"] = _pythia8.LHAup_idprupSave_get
    if _newclass:
        idprupSave = _swig_property(_pythia8.LHAup_idprupSave_get, _pythia8.LHAup_idprupSave_set)
    __swig_setmethods__["xwgtupSave"] = _pythia8.LHAup_xwgtupSave_set
    __swig_getmethods__["xwgtupSave"] = _pythia8.LHAup_xwgtupSave_get
    if _newclass:
        xwgtupSave = _swig_property(_pythia8.LHAup_xwgtupSave_get, _pythia8.LHAup_xwgtupSave_set)
    __swig_setmethods__["scalupSave"] = _pythia8.LHAup_scalupSave_set
    __swig_getmethods__["scalupSave"] = _pythia8.LHAup_scalupSave_get
    if _newclass:
        scalupSave = _swig_property(_pythia8.LHAup_scalupSave_get, _pythia8.LHAup_scalupSave_set)
    __swig_setmethods__["aqedupSave"] = _pythia8.LHAup_aqedupSave_set
    __swig_getmethods__["aqedupSave"] = _pythia8.LHAup_aqedupSave_get
    if _newclass:
        aqedupSave = _swig_property(_pythia8.LHAup_aqedupSave_get, _pythia8.LHAup_aqedupSave_set)
    __swig_setmethods__["aqcdupSave"] = _pythia8.LHAup_aqcdupSave_set
    __swig_getmethods__["aqcdupSave"] = _pythia8.LHAup_aqcdupSave_get
    if _newclass:
        aqcdupSave = _swig_property(_pythia8.LHAup_aqcdupSave_get, _pythia8.LHAup_aqcdupSave_set)
    __swig_setmethods__["xSecSumSave"] = _pythia8.LHAup_xSecSumSave_set
    __swig_getmethods__["xSecSumSave"] = _pythia8.LHAup_xSecSumSave_get
    if _newclass:
        xSecSumSave = _swig_property(_pythia8.LHAup_xSecSumSave_get, _pythia8.LHAup_xSecSumSave_set)
    __swig_setmethods__["xErrSumSave"] = _pythia8.LHAup_xErrSumSave_set
    __swig_getmethods__["xErrSumSave"] = _pythia8.LHAup_xErrSumSave_get
    if _newclass:
        xErrSumSave = _swig_property(_pythia8.LHAup_xErrSumSave_get, _pythia8.LHAup_xErrSumSave_set)
    __swig_setmethods__["particlesSave"] = _pythia8.LHAup_particlesSave_set
    __swig_getmethods__["particlesSave"] = _pythia8.LHAup_particlesSave_get
    if _newclass:
        particlesSave = _swig_property(_pythia8.LHAup_particlesSave_get, _pythia8.LHAup_particlesSave_set)
    __swig_setmethods__["getPDFSave"] = _pythia8.LHAup_getPDFSave_set
    __swig_getmethods__["getPDFSave"] = _pythia8.LHAup_getPDFSave_get
    if _newclass:
        getPDFSave = _swig_property(_pythia8.LHAup_getPDFSave_get, _pythia8.LHAup_getPDFSave_set)
    __swig_setmethods__["getScale"] = _pythia8.LHAup_getScale_set
    __swig_getmethods__["getScale"] = _pythia8.LHAup_getScale_get
    if _newclass:
        getScale = _swig_property(_pythia8.LHAup_getScale_get, _pythia8.LHAup_getScale_set)
    __swig_setmethods__["getScaleShowers"] = _pythia8.LHAup_getScaleShowers_set
    __swig_getmethods__["getScaleShowers"] = _pythia8.LHAup_getScaleShowers_get
    if _newclass:
        getScaleShowers = _swig_property(_pythia8.LHAup_getScaleShowers_get, _pythia8.LHAup_getScaleShowers_set)
    __swig_setmethods__["id1InSave"] = _pythia8.LHAup_id1InSave_set
    __swig_getmethods__["id1InSave"] = _pythia8.LHAup_id1InSave_get
    if _newclass:
        id1InSave = _swig_property(_pythia8.LHAup_id1InSave_get, _pythia8.LHAup_id1InSave_set)
    __swig_setmethods__["id2InSave"] = _pythia8.LHAup_id2InSave_set
    __swig_getmethods__["id2InSave"] = _pythia8.LHAup_id2InSave_get
    if _newclass:
        id2InSave = _swig_property(_pythia8.LHAup_id2InSave_get, _pythia8.LHAup_id2InSave_set)
    __swig_setmethods__["id1pdfInSave"] = _pythia8.LHAup_id1pdfInSave_set
    __swig_getmethods__["id1pdfInSave"] = _pythia8.LHAup_id1pdfInSave_get
    if _newclass:
        id1pdfInSave = _swig_property(_pythia8.LHAup_id1pdfInSave_get, _pythia8.LHAup_id1pdfInSave_set)
    __swig_setmethods__["id2pdfInSave"] = _pythia8.LHAup_id2pdfInSave_set
    __swig_getmethods__["id2pdfInSave"] = _pythia8.LHAup_id2pdfInSave_get
    if _newclass:
        id2pdfInSave = _swig_property(_pythia8.LHAup_id2pdfInSave_get, _pythia8.LHAup_id2pdfInSave_set)
    __swig_setmethods__["x1InSave"] = _pythia8.LHAup_x1InSave_set
    __swig_getmethods__["x1InSave"] = _pythia8.LHAup_x1InSave_get
    if _newclass:
        x1InSave = _swig_property(_pythia8.LHAup_x1InSave_get, _pythia8.LHAup_x1InSave_set)
    __swig_setmethods__["x2InSave"] = _pythia8.LHAup_x2InSave_set
    __swig_getmethods__["x2InSave"] = _pythia8.LHAup_x2InSave_get
    if _newclass:
        x2InSave = _swig_property(_pythia8.LHAup_x2InSave_get, _pythia8.LHAup_x2InSave_set)
    __swig_setmethods__["x1pdfInSave"] = _pythia8.LHAup_x1pdfInSave_set
    __swig_getmethods__["x1pdfInSave"] = _pythia8.LHAup_x1pdfInSave_get
    if _newclass:
        x1pdfInSave = _swig_property(_pythia8.LHAup_x1pdfInSave_get, _pythia8.LHAup_x1pdfInSave_set)
    __swig_setmethods__["x2pdfInSave"] = _pythia8.LHAup_x2pdfInSave_set
    __swig_getmethods__["x2pdfInSave"] = _pythia8.LHAup_x2pdfInSave_get
    if _newclass:
        x2pdfInSave = _swig_property(_pythia8.LHAup_x2pdfInSave_get, _pythia8.LHAup_x2pdfInSave_set)
    __swig_setmethods__["scalePDFInSave"] = _pythia8.LHAup_scalePDFInSave_set
    __swig_getmethods__["scalePDFInSave"] = _pythia8.LHAup_scalePDFInSave_get
    if _newclass:
        scalePDFInSave = _swig_property(_pythia8.LHAup_scalePDFInSave_get, _pythia8.LHAup_scalePDFInSave_set)
    __swig_setmethods__["pdf1InSave"] = _pythia8.LHAup_pdf1InSave_set
    __swig_getmethods__["pdf1InSave"] = _pythia8.LHAup_pdf1InSave_get
    if _newclass:
        pdf1InSave = _swig_property(_pythia8.LHAup_pdf1InSave_get, _pythia8.LHAup_pdf1InSave_set)
    __swig_setmethods__["pdf2InSave"] = _pythia8.LHAup_pdf2InSave_set
    __swig_getmethods__["pdf2InSave"] = _pythia8.LHAup_pdf2InSave_get
    if _newclass:
        pdf2InSave = _swig_property(_pythia8.LHAup_pdf2InSave_get, _pythia8.LHAup_pdf2InSave_set)
    __swig_setmethods__["scaleShowersInSave"] = _pythia8.LHAup_scaleShowersInSave_set
    __swig_getmethods__["scaleShowersInSave"] = _pythia8.LHAup_scaleShowersInSave_get
    if _newclass:
        scaleShowersInSave = _swig_property(_pythia8.LHAup_scaleShowersInSave_get, _pythia8.LHAup_scaleShowersInSave_set)
    __swig_setmethods__["fileName"] = _pythia8.LHAup_fileName_set
    __swig_getmethods__["fileName"] = _pythia8.LHAup_fileName_get
    if _newclass:
        fileName = _swig_property(_pythia8.LHAup_fileName_get, _pythia8.LHAup_fileName_set)
    __swig_setmethods__["dateNow"] = _pythia8.LHAup_dateNow_set
    __swig_getmethods__["dateNow"] = _pythia8.LHAup_dateNow_get
    if _newclass:
        dateNow = _swig_property(_pythia8.LHAup_dateNow_get, _pythia8.LHAup_dateNow_set)
    __swig_setmethods__["timeNow"] = _pythia8.LHAup_timeNow_set
    __swig_getmethods__["timeNow"] = _pythia8.LHAup_timeNow_get
    if _newclass:
        timeNow = _swig_property(_pythia8.LHAup_timeNow_get, _pythia8.LHAup_timeNow_set)
    def __disown__(self):
        self.this.disown()
        _pythia8.disown_LHAup(self)
        return weakref_proxy(self)
LHAup_swigregister = _pythia8.LHAup_swigregister
LHAup_swigregister(LHAup)
LHAup.CONVERTMB2PB = _pythia8.cvar.LHAup_CONVERTMB2PB

class LHAupLHEF(LHAup):
    """
A derived class with information read from a Les Houches Event File.
"""
    __swig_setmethods__ = {}
    for _s in [LHAup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHAupLHEF, name, value)
    __swig_getmethods__ = {}
    for _s in [LHAup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LHAupLHEF, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_LHAupLHEF(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_LHAupLHEF
    __del__ = lambda self: None

    def closeAllFiles(self):
        """
Close files and then open new file.
"""
        return _pythia8.LHAupLHEF_closeAllFiles(self)

    def newEventFile(self, filenameIn):
        """
Want to use new file with events, but without reinitialization.
"""
        return _pythia8.LHAupLHEF_newEventFile(self, filenameIn)

    def fileFound(self):
        """
Set isHead to is to keep expected behaviour in
fileFound() and closeAllFiles().
Confirm that file was found and opened as expected.
"""
        return _pythia8.LHAupLHEF_fileFound(self)

    def useExternal(self):
        """
"""
        return _pythia8.LHAupLHEF_useExternal(self)

    def setInit(self):
        """
Routine for doing the job of reading and setting initialization info.
"""
        return _pythia8.LHAupLHEF_setInit(self)

    def setInitLHEF(self, isIn, readHead):
        """
Routine for doing the job of reading and setting initialization info.
"""
        return _pythia8.LHAupLHEF_setInitLHEF(self, isIn, readHead)

    def setEvent(self, arg2=0):
        """
Routine for doing the job of reading and setting info on next event.
"""
        return _pythia8.LHAupLHEF_setEvent(self, arg2)

    def skipEvent(self, nSkip):
        """
Skip ahead a number of events, which are not considered further.
"""
        return _pythia8.LHAupLHEF_skipEvent(self, nSkip)

    def setNewEventLHEF(self):
        """
Routine for doing the job of reading and setting info on next event.
"""
        return _pythia8.LHAupLHEF_setNewEventLHEF(self)

    def updateSigma(self):
        """
Update cross-section information at the end of the run.
"""
        return _pythia8.LHAupLHEF_updateSigma(self)
LHAupLHEF_swigregister = _pythia8.LHAupLHEF_swigregister
LHAupLHEF_swigregister(LHAupLHEF)

class LHAupFromPYTHIA8(LHAup):
    """
A derived class with information read from PYTHIA 8 itself, for output.
"""
    __swig_setmethods__ = {}
    for _s in [LHAup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHAupFromPYTHIA8, name, value)
    __swig_getmethods__ = {}
    for _s in [LHAup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LHAupFromPYTHIA8, name)
    __repr__ = _swig_repr

    def __init__(self, processPtrIn, infoPtrIn):
        """
Constructor.
"""
        this = _pythia8.new_LHAupFromPYTHIA8(processPtrIn, infoPtrIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_LHAupFromPYTHIA8
    __del__ = lambda self: None

    def setInit(self):
        """
Routine for doing the job of reading and setting initialization info.
"""
        return _pythia8.LHAupFromPYTHIA8_setInit(self)

    def setEvent(self, arg2=0):
        """
Routine for doing the job of reading and setting info on next event.
"""
        return _pythia8.LHAupFromPYTHIA8_setEvent(self, arg2)

    def updateSigma(self):
        """
Update cross-section information at the end of the run.
"""
        return _pythia8.LHAupFromPYTHIA8_updateSigma(self)
LHAupFromPYTHIA8_swigregister = _pythia8.LHAupFromPYTHIA8_swigregister
LHAupFromPYTHIA8_swigregister(LHAupFromPYTHIA8)

class LHEF3FromPythia8(LHAup):
    """
A derived class with LHEF 3.0 information read from PYTHIA 8 itself, for
output.
"""
    __swig_setmethods__ = {}
    for _s in [LHAup]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, LHEF3FromPythia8, name, value)
    __swig_getmethods__ = {}
    for _s in [LHAup]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, LHEF3FromPythia8, name)
    __repr__ = _swig_repr

    def __init__(self, eventPtrIn, settingsPtrIn, infoPtrIn, particleDataPtrIn, pDigitsIn=15, writeToFileIn=True):
        """
Constructor.
"""
        this = _pythia8.new_LHEF3FromPythia8(eventPtrIn, settingsPtrIn, infoPtrIn, particleDataPtrIn, pDigitsIn, writeToFileIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def setInit(self):
        """
Routine for reading, setting and printing the initialisation info.
"""
        return _pythia8.LHEF3FromPythia8_setInit(self)

    def setEventPtr(self, evPtr):
        """
Routine for reading, setting and printing the next event.
"""
        return _pythia8.LHEF3FromPythia8_setEventPtr(self, evPtr)

    def setEvent(self, arg2=0):
        """
"""
        return _pythia8.LHEF3FromPythia8_setEvent(self, arg2)

    def getEventString(self):
        """
"""
        return _pythia8.LHEF3FromPythia8_getEventString(self)

    def openLHEF(self, fileNameIn):
        """
Function to open the output file.
"""
        return _pythia8.LHEF3FromPythia8_openLHEF(self, fileNameIn)

    def closeLHEF(self, updateInit=False):
        """
Function to close (and possibly update) the output file.
"""
        return _pythia8.LHEF3FromPythia8_closeLHEF(self, updateInit)
    __swig_destroy__ = _pythia8.delete_LHEF3FromPythia8
    __del__ = lambda self: None
LHEF3FromPythia8_swigregister = _pythia8.LHEF3FromPythia8_swigregister
LHEF3FromPythia8_swigregister(LHEF3FromPythia8)

class MiniStringFragmentation(_object):
    """
The MiniStringFragmentation class contains the routines to fragment
occasional low-mass colour singlet partonic systems, where the string
approach is not directly applicable (for technical reasons).
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MiniStringFragmentation, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MiniStringFragmentation, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_MiniStringFragmentation()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, infoPtrIn, settings, particleDataPtrIn, rndmPtrIn, flavSelPtrIn, pTSelPtrIn, zSelPtrIn):
        """
Initialize and save pointers.
"""
        return _pythia8.MiniStringFragmentation_init(self, infoPtrIn, settings, particleDataPtrIn, rndmPtrIn, flavSelPtrIn, pTSelPtrIn, zSelPtrIn)

    def fragment(self, iSub, colConfig, event, isDiff=False):
        """
Do the fragmentation: driver routine.
"""
        return _pythia8.MiniStringFragmentation_fragment(self, iSub, colConfig, event, isDiff)
    __swig_destroy__ = _pythia8.delete_MiniStringFragmentation
    __del__ = lambda self: None
MiniStringFragmentation_swigregister = _pythia8.MiniStringFragmentation_swigregister
MiniStringFragmentation_swigregister(MiniStringFragmentation)

class PartonVertex(_object):
    """
List of all separate partonic subsystems.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PartonVertex, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PartonVertex, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_PartonVertex()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_PartonVertex
    __del__ = lambda self: None

    def initPtr(self, infoPtrIn, settingsPtrIn, rndmPtrIn):
        """
Initialize various pointers.
(Separated from rest of init since not virtual.)
"""
        return _pythia8.PartonVertex_initPtr(self, infoPtrIn, settingsPtrIn, rndmPtrIn)

    def init(self):
        """
Initialize a few parameters from Settings.
"""
        return _pythia8.PartonVertex_init(self)

    def vertexBeam(self, iNow, iBeam, event):
        """
Select vertex for a Beam Remnant particle.
"""
        return _pythia8.PartonVertex_vertexBeam(self, iNow, iBeam, event)

    def vertexMPI(self, iBeg, nAdd, bNowIn, event):
        """
Select vertex for an MPI.
"""
        return _pythia8.PartonVertex_vertexMPI(self, iBeg, nAdd, bNowIn, event)

    def vertexFSR(self, iNow, event):
        """
Select vertex for an FSR branching.
"""
        return _pythia8.PartonVertex_vertexFSR(self, iNow, event)

    def vertexISR(self, iNow, event):
        """
Select vertex for an ISR branching.
"""
        return _pythia8.PartonVertex_vertexISR(self, iNow, event)
PartonVertex_swigregister = _pythia8.PartonVertex_swigregister
PartonVertex_swigregister(PartonVertex)

class ResonanceDecays(_object):
    """
The ResonanceDecays class handles the sequential decay of resonances
that are part of the hard process (t, W, Z, H, SUSY,...).
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceDecays, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceDecays, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceDecays()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, infoPtrIn, particleDataPtrIn, rndmPtrIn):
        """
Store pointers to Info and Rndm for error messages and random numbers.
"""
        return _pythia8.ResonanceDecays_init(self, infoPtrIn, particleDataPtrIn, rndmPtrIn)

    def next(self, process, iDecNow=0):
        """
Generate the next decay sequence.
"""
        return _pythia8.ResonanceDecays_next(self, process, iDecNow)
    __swig_destroy__ = _pythia8.delete_ResonanceDecays
    __del__ = lambda self: None
ResonanceDecays_swigregister = _pythia8.ResonanceDecays_swigregister
ResonanceDecays_swigregister(ResonanceDecays)

class ResonanceS(ResonanceWidths):
    """
The ResonanceS class. (S a.k.a. DMmed(s=0), PDG id 54.)
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceS, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceS, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor and destructor.
"""
        this = _pythia8.new_ResonanceS(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceS
    __del__ = lambda self: None
ResonanceS_swigregister = _pythia8.ResonanceS_swigregister
ResonanceS_swigregister(ResonanceS)

class ResonanceZp(ResonanceWidths):
    """
The ResonanceZp class. (Zp a.k.a. DMmed(s=1), PDG id 55.)
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceZp, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceZp, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceZp(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceZp
    __del__ = lambda self: None
ResonanceZp_swigregister = _pythia8.ResonanceZp_swigregister
ResonanceZp_swigregister(ResonanceZp)

class ResonanceSl(ResonanceWidths):
    """
Charged scalar partner of DM (PDG id 56.)
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceSl, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceSl, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceSl(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceSl
    __del__ = lambda self: None
ResonanceSl_swigregister = _pythia8.ResonanceSl_swigregister
ResonanceSl_swigregister(ResonanceSl)

class ResonanceCha(ResonanceWidths):
    """
Charged partner of DM (PDG id 57.)
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceCha, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceCha, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceCha(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceCha
    __del__ = lambda self: None
ResonanceCha_swigregister = _pythia8.ResonanceCha_swigregister
ResonanceCha_swigregister(ResonanceCha)

class ResonanceDM2(ResonanceCha):
    """
Neutral Charged partner of DM (PDG id 58.)
Not yet implemented.
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceCha]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceDM2, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceCha]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceDM2, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceDM2(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceDM2
    __del__ = lambda self: None
ResonanceDM2_swigregister = _pythia8.ResonanceDM2_swigregister
ResonanceDM2_swigregister(ResonanceDM2)

class ResonanceChaD(ResonanceCha):
    """
Doubly Charged partner of DM (PDG id 59.)
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceCha]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceChaD, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceCha]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceChaD, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceChaD(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceChaD
    __del__ = lambda self: None
ResonanceChaD_swigregister = _pythia8.ResonanceChaD_swigregister
ResonanceChaD_swigregister(ResonanceChaD)

class RHadrons(_object):
    """
The RHadrons class contains the routines for the production and decay
of long-lived heavy coloured particles.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, RHadrons, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, RHadrons, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_RHadrons()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, infoPtrIn, settings, particleDataPtrIn, rndmPtrIn):
        """
Initialization of R-hadron handling.
"""
        return _pythia8.RHadrons_init(self, infoPtrIn, settings, particleDataPtrIn, rndmPtrIn)

    def fragPtrs(self, flavSelPtrIn, zSelPtrIn):
        """
Pointers to flavours and z sent from HadronLevel.
"""
        return _pythia8.RHadrons_fragPtrs(self, flavSelPtrIn, zSelPtrIn)

    def produce(self, colConfig, event):
        """
Produce R-hadrons.
"""
        return _pythia8.RHadrons_produce(self, colConfig, event)

    def decay(self, event):
        """
Decay R-hadrons.
"""
        return _pythia8.RHadrons_decay(self, event)

    def givesRHadron(self, id):
        """
Tell whether a given particle is supposed to form R-hadrons.
"""
        return _pythia8.RHadrons_givesRHadron(self, id)

    def exist(self):
        """
Tell whether any R-hadrons have been formed.
"""
        return _pythia8.RHadrons_exist(self)

    def trace(self, i):
        """
Tell whether a R-hadron production+decay happened, and trace down.
"""
        return _pythia8.RHadrons_trace(self, i)
    __swig_destroy__ = _pythia8.delete_RHadrons
    __del__ = lambda self: None
RHadrons_swigregister = _pythia8.RHadrons_swigregister
RHadrons_swigregister(RHadrons)

class RopeDipoleEnd(_object):
    """
Define the end of a dipole, containing a pointer to the particle,
and its index in the event record.
Includes some methods for kinematics output.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, RopeDipoleEnd, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, RopeDipoleEnd, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_RopeDipoleEnd(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def getParticlePtr(self):
        """
Get a pointer to the particle.
"""
        return _pythia8.RopeDipoleEnd_getParticlePtr(self)

    def getNe(self):
        """
Get the particle index in event record.
"""
        return _pythia8.RopeDipoleEnd_getNe(self)

    def labrap(self):
        """
Output methods for (modified) rapidity.
"""
        return _pythia8.RopeDipoleEnd_labrap(self)

    def rap(self, *args):
        """
"""
        return _pythia8.RopeDipoleEnd_rap(self, *args)
    __swig_destroy__ = _pythia8.delete_RopeDipoleEnd
    __del__ = lambda self: None
RopeDipoleEnd_swigregister = _pythia8.RopeDipoleEnd_swigregister
RopeDipoleEnd_swigregister(RopeDipoleEnd)

class OverlappingRopeDipole(_object):
    """
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, OverlappingRopeDipole, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, OverlappingRopeDipole, name)
    __repr__ = _swig_repr

    def __init__(self, d, m0, r):
        """
Constructor sets up coordinates in the rest frame of other dipole.
"""
        this = _pythia8.new_OverlappingRopeDipole(d, m0, r)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def overlap(self, y, ba, r0):
        """
Calculate the overlap at given y and b.
"""
        return _pythia8.OverlappingRopeDipole_overlap(self, y, ba, r0)

    def hadronized(self):
        """
Has the dipole been hadronized?
"""
        return _pythia8.OverlappingRopeDipole_hadronized(self)
    __swig_setmethods__["dir"] = _pythia8.OverlappingRopeDipole_dir_set
    __swig_getmethods__["dir"] = _pythia8.OverlappingRopeDipole_dir_get
    if _newclass:
        dir = _swig_property(_pythia8.OverlappingRopeDipole_dir_get, _pythia8.OverlappingRopeDipole_dir_set)
    __swig_setmethods__["y1"] = _pythia8.OverlappingRopeDipole_y1_set
    __swig_getmethods__["y1"] = _pythia8.OverlappingRopeDipole_y1_get
    if _newclass:
        y1 = _swig_property(_pythia8.OverlappingRopeDipole_y1_get, _pythia8.OverlappingRopeDipole_y1_set)
    __swig_setmethods__["y2"] = _pythia8.OverlappingRopeDipole_y2_set
    __swig_getmethods__["y2"] = _pythia8.OverlappingRopeDipole_y2_get
    if _newclass:
        y2 = _swig_property(_pythia8.OverlappingRopeDipole_y2_get, _pythia8.OverlappingRopeDipole_y2_set)
    __swig_setmethods__["b1"] = _pythia8.OverlappingRopeDipole_b1_set
    __swig_getmethods__["b1"] = _pythia8.OverlappingRopeDipole_b1_get
    if _newclass:
        b1 = _swig_property(_pythia8.OverlappingRopeDipole_b1_get, _pythia8.OverlappingRopeDipole_b1_set)
    __swig_setmethods__["b2"] = _pythia8.OverlappingRopeDipole_b2_set
    __swig_getmethods__["b2"] = _pythia8.OverlappingRopeDipole_b2_get
    if _newclass:
        b2 = _swig_property(_pythia8.OverlappingRopeDipole_b2_get, _pythia8.OverlappingRopeDipole_b2_set)
    __swig_destroy__ = _pythia8.delete_OverlappingRopeDipole
    __del__ = lambda self: None
OverlappingRopeDipole_swigregister = _pythia8.OverlappingRopeDipole_swigregister
OverlappingRopeDipole_swigregister(OverlappingRopeDipole)

class RopeDipole(_object):
    """
The RopeDipole class holds information about a colour dipole, as well as
functionality to do shoving and to calculate effective string tension.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, RopeDipole, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, RopeDipole, name)
    __repr__ = _swig_repr

    def __init__(self, d1In, d2In, iSubIn, infoPtrIn):
        """
The RopeDipole constructor makes sure that d1 is always the colored
end and d2 the anti-colored.
"""
        this = _pythia8.new_RopeDipole(d1In, d2In, iSubIn, infoPtrIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def addExcitation(self, ylab, ex):
        """
Insert an excitation on dipole, if not already there.
"""
        return _pythia8.RopeDipole_addExcitation(self, ylab, ex)

    def d1Ptr(self):
        """
Deep access to the RopeDipoleEnds (needed by OverlappingRopeDipole).
"""
        return _pythia8.RopeDipole_d1Ptr(self)

    def d2Ptr(self):
        """
"""
        return _pythia8.RopeDipole_d2Ptr(self)

    def getDipoleRestFrame(self):
        """
Get the rotation matrix to go to dipole rest frame.
"""
        return _pythia8.RopeDipole_getDipoleRestFrame(self)

    def getDipoleLabFrame(self):
        """
"""
        return _pythia8.RopeDipole_getDipoleLabFrame(self)

    def dipoleMomentum(self):
        """
Get the dipole momentum four-vector.
"""
        return _pythia8.RopeDipole_dipoleMomentum(self)

    def bInterpolateDip(self, y, m0):
        """
Get the spatial point interpolated to given rapidity.
In the dipole rest frame.
"""
        return _pythia8.RopeDipole_bInterpolateDip(self, y, m0)

    def bInterpolateLab(self, y, m0):
        """
In the lab frame.
"""
        return _pythia8.RopeDipole_bInterpolateLab(self, y, m0)

    def bInterpolate(self, y, rb, m0):
        """
Given a Lorentz matrix.
"""
        return _pythia8.RopeDipole_bInterpolate(self, y, rb, m0)

    def getOverlaps(self, yfrac, m0, r0):
        """
Get the quantum numbers m,n characterizing all dipole overlaps
at a given rapidity value.
"""
        return _pythia8.RopeDipole_getOverlaps(self, yfrac, m0, r0)

    def addOverlappingDipole(self, d):
        """
Add an overlapping dipole.
"""
        return _pythia8.RopeDipole_addOverlappingDipole(self, d)

    def maxRapidity(self, *args):
        """
Get the maximal and minimal boosted rapidity of the dipole.
"""
        return _pythia8.RopeDipole_maxRapidity(self, *args)

    def minRapidity(self, *args):
        """
"""
        return _pythia8.RopeDipole_minRapidity(self, *args)

    def propagateInit(self, deltat):
        """
Propagate the dipole itself.
"""
        return _pythia8.RopeDipole_propagateInit(self, deltat)

    def propagate(self, deltat, m0):
        """
Propagate both dipole ends as well as all excitations.
"""
        return _pythia8.RopeDipole_propagate(self, deltat, m0)

    def splitMomentum(self, mom, p1, p2, frac=0.5):
        """
Redistribute momentum to two particles.
"""
        return _pythia8.RopeDipole_splitMomentum(self, mom, p1, p2, frac)

    def excitationsToString(self, m0, event):
        """
Put gluon excitations on the dipole.
"""
        return _pythia8.RopeDipole_excitationsToString(self, m0, event)

    def index(self):
        """
Get the (event colconfig) index.
"""
        return _pythia8.RopeDipole_index(self)

    def recoil(self, pg, dummy=False):
        """
Recoil the dipole from adding a gluon. If the "dummy" option is set,
the recoil will not be added, but only checked.
Note: the gluon will not actually be added, only the recoil (if possible).
"""
        return _pythia8.RopeDipole_recoil(self, pg, dummy)

    def hadronized(self, *args):
        """
Set dipole hadronized flag.
"""
        return _pythia8.RopeDipole_hadronized(self, *args)

    def nExcitations(self):
        """
The number of excitations on the dipole.
"""
        return _pythia8.RopeDipole_nExcitations(self)
    __swig_destroy__ = _pythia8.delete_RopeDipole
    __del__ = lambda self: None
RopeDipole_swigregister = _pythia8.RopeDipole_swigregister
RopeDipole_swigregister(RopeDipole)

class Ropewalk(_object):
    """
The Ropewalk class keeps track of all the strings making up ropes
for shoving as well as flavour enhancement.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Ropewalk, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Ropewalk, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Ropewalk()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, infoPtrIn, settings, rndmPtrIn):
        """
The Ropewalk init function sets parameters and pointers.
"""
        return _pythia8.Ropewalk_init(self, infoPtrIn, settings, rndmPtrIn)

    def extractDipoles(self, event, colConfig):
        """
Extract all dipoles from an event.
"""
        return _pythia8.Ropewalk_extractDipoles(self, event, colConfig)

    def calculateOverlaps(self):
        """
Calculate all overlaps of all dipoles and store as OverlappingRopeDipoles.
"""
        return _pythia8.Ropewalk_calculateOverlaps(self)

    def getKappaHere(self, e1, e2, yfrac):
        """
Calculate the effective string tension a fraction yfrac in on the dipole
given by indices e1 and e2.
"""
        return _pythia8.Ropewalk_getKappaHere(self, e1, e2, yfrac)

    def multiplicity(self, p, q):
        """
The multiplicity of a colour state given its quantum numbers.
"""
        return _pythia8.Ropewalk_multiplicity(self, p, q)

    def averageKappa(self):
        """
Calculate the average string tension of the event, in units of the default
string tension (ie. 1 GeV/fm), using random walk in colour space.
"""
        return _pythia8.Ropewalk_averageKappa(self)

    def select(self, m, n, rndm):
        """
Invoke the random walk and select a state.
"""
        return _pythia8.Ropewalk_select(self, m, n, rndm)

    def shoveTheDipoles(self, event):
        """
Shove all dipoles in the event.
"""
        return _pythia8.Ropewalk_shoveTheDipoles(self, event)
    __swig_destroy__ = _pythia8.delete_Ropewalk
    __del__ = lambda self: None
Ropewalk_swigregister = _pythia8.Ropewalk_swigregister
Ropewalk_swigregister(Ropewalk)

class RopeFragPars(_object):
    """
RopeFragPars recalculates fragmentation parameters according to a
changed string tension. Helper class to FlavourRope.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, RopeFragPars, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, RopeFragPars, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_RopeFragPars()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, infoPtrIn, settings):
        """
The init function sets up initial parameters from settings.
"""
        return _pythia8.RopeFragPars_init(self, infoPtrIn, settings)

    def getEffectiveParameters(self, h):
        """
Return parameters at given string tension, ordered by their
name for easy insertion in settings.
"""
        return _pythia8.RopeFragPars_getEffectiveParameters(self, h)
    __swig_destroy__ = _pythia8.delete_RopeFragPars
    __del__ = lambda self: None
RopeFragPars_swigregister = _pythia8.RopeFragPars_swigregister
RopeFragPars_swigregister(RopeFragPars)

class FlavourRope(_object):
    """
The FlavourRope class takes care of placing a string breakup in
the event, and assigning the string breakup effective parameters.
It is a UserHooks derived class, and one must make sure to add it
to the UserHooksVector in the main program or somewhere else.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, FlavourRope, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, FlavourRope, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_FlavourRope()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, settingsPtrIn, rndmPtrIn, particleDataPtrIn, infoPtrIn, rwPtrIn):
        """
Initialize. Set pointers.
"""
        return _pythia8.FlavourRope_init(self, settingsPtrIn, rndmPtrIn, particleDataPtrIn, infoPtrIn, rwPtrIn)

    def doChangeFragPar(self, flavPtr, zPtr, pTPtr, m2Had, iParton, endId):
        """
Change the fragmentation parameters.
"""
        return _pythia8.FlavourRope_doChangeFragPar(self, flavPtr, zPtr, pTPtr, m2Had, iParton, endId)

    def setEnhancement(self, hIn):
        """
Set enhancement manually.
"""
        return _pythia8.FlavourRope_setEnhancement(self, hIn)

    def setEventPtr(self, event):
        """
Set pointer to the event.
"""
        return _pythia8.FlavourRope_setEventPtr(self, event)
    __swig_destroy__ = _pythia8.delete_FlavourRope
    __del__ = lambda self: None
FlavourRope_swigregister = _pythia8.FlavourRope_swigregister
FlavourRope_swigregister(FlavourRope)

class SUSYResonanceWidths(ResonanceWidths):
    """
"""
    __swig_setmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SUSYResonanceWidths, name, value)
    __swig_getmethods__ = {}
    for _s in [ResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SUSYResonanceWidths, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor
"""
        this = _pythia8.new_SUSYResonanceWidths()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_SUSYResonanceWidths
    __del__ = lambda self: None
SUSYResonanceWidths_swigregister = _pythia8.SUSYResonanceWidths_swigregister
SUSYResonanceWidths_swigregister(SUSYResonanceWidths)

class ResonanceSquark(SUSYResonanceWidths):
    """
The ResonanceSquark class handles the Squark resonances.
"""
    __swig_setmethods__ = {}
    for _s in [SUSYResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceSquark, name, value)
    __swig_getmethods__ = {}
    for _s in [SUSYResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceSquark, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceSquark(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceSquark
    __del__ = lambda self: None
ResonanceSquark_swigregister = _pythia8.ResonanceSquark_swigregister
ResonanceSquark_swigregister(ResonanceSquark)

class ResonanceGluino(SUSYResonanceWidths):
    """
The ResonanceGluino class handles the Gluino resonances.
"""
    __swig_setmethods__ = {}
    for _s in [SUSYResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceGluino, name, value)
    __swig_getmethods__ = {}
    for _s in [SUSYResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceGluino, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceGluino(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceGluino
    __del__ = lambda self: None
ResonanceGluino_swigregister = _pythia8.ResonanceGluino_swigregister
ResonanceGluino_swigregister(ResonanceGluino)

class ResonanceNeut(SUSYResonanceWidths):
    """
The ResonanceNeut class handles the Neutralino resonances.
"""
    __swig_setmethods__ = {}
    for _s in [SUSYResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceNeut, name, value)
    __swig_getmethods__ = {}
    for _s in [SUSYResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceNeut, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceNeut(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceNeut
    __del__ = lambda self: None
ResonanceNeut_swigregister = _pythia8.ResonanceNeut_swigregister
ResonanceNeut_swigregister(ResonanceNeut)

class ResonanceChar(SUSYResonanceWidths):
    """
The ResonanceChar class handles the Chargino resonances.
"""
    __swig_setmethods__ = {}
    for _s in [SUSYResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceChar, name, value)
    __swig_getmethods__ = {}
    for _s in [SUSYResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceChar, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceChar(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceChar
    __del__ = lambda self: None
ResonanceChar_swigregister = _pythia8.ResonanceChar_swigregister
ResonanceChar_swigregister(ResonanceChar)

class ResonanceSlepton(SUSYResonanceWidths):
    """
The ResonanceSlepton class handles the Slepton/Sneutrino resonances.
"""
    __swig_setmethods__ = {}
    for _s in [SUSYResonanceWidths]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResonanceSlepton, name, value)
    __swig_getmethods__ = {}
    for _s in [SUSYResonanceWidths]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, ResonanceSlepton, name)
    __repr__ = _swig_repr

    def __init__(self, idResIn):
        """
Constructor.
"""
        this = _pythia8.new_ResonanceSlepton(idResIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_ResonanceSlepton
    __del__ = lambda self: None
ResonanceSlepton_swigregister = _pythia8.ResonanceSlepton_swigregister
ResonanceSlepton_swigregister(ResonanceSlepton)

class TauDecays(_object):
    """
TauDecays class.
This class decays tau leptons, with helicity information.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, TauDecays, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, TauDecays, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor and destructor.
"""
        this = _pythia8.new_TauDecays()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_TauDecays
    __del__ = lambda self: None

    def init(self, infoPtrIn, settingsPtrIn, particleDataPtrIn, rndmPtrIn, couplingsPtrIn):
        """
Initializer.
"""
        return _pythia8.TauDecays_init(self, infoPtrIn, settingsPtrIn, particleDataPtrIn, rndmPtrIn, couplingsPtrIn)

    def decay(self, iDec, event):
        """
Decay a tau or correlated tau pair.
"""
        return _pythia8.TauDecays_decay(self, iDec, event)

    def internalMechanism(self, event):
        """
Determine internal or external polarization and correlation mechanism.
"""
        return _pythia8.TauDecays_internalMechanism(self, event)

    def externalMechanism(self, event):
        """
"""
        return _pythia8.TauDecays_externalMechanism(self, event)

    def createChildren(self, parent):
        """
Choose a decay channel for a particle.
"""
        return _pythia8.TauDecays_createChildren(self, parent)

    def isotropicDecay(self, p):
        """
Perform an N-body isotropic decay.
"""
        return _pythia8.TauDecays_isotropicDecay(self, p)

    def writeDecay(self, event, p):
        """
Write the decay to event record.
"""
        return _pythia8.TauDecays_writeDecay(self, event, p)
TauDecays_swigregister = _pythia8.TauDecays_swigregister
TauDecays_swigregister(TauDecays)

class Sphericity(_object):
    """
Sphericity class.
This class performs (optionally modified) sphericity analysis on an event.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sphericity, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Sphericity, name)
    __repr__ = _swig_repr

    def __init__(self, powerIn=2., selectIn=2):
        """
Constructor.
"""
        this = _pythia8.new_Sphericity(powerIn, selectIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def analyze(self, event):
        """
Analyze event.
"""
        return _pythia8.Sphericity_analyze(self, event)

    def sphericity(self):
        """
Return info on results of analysis.
"""
        return _pythia8.Sphericity_sphericity(self)

    def aplanarity(self):
        """
"""
        return _pythia8.Sphericity_aplanarity(self)

    def eigenValue(self, i):
        """
"""
        return _pythia8.Sphericity_eigenValue(self, i)

    def eventAxis(self, i):
        """
"""
        return _pythia8.Sphericity_eventAxis(self, i)

    def nError(self):
        """
Tell how many events could not be analyzed.
"""
        return _pythia8.Sphericity_nError(self)

    def __str__(self):
        return _pythia8.Sphericity___str__(self)
    __swig_destroy__ = _pythia8.delete_Sphericity
    __del__ = lambda self: None
Sphericity_swigregister = _pythia8.Sphericity_swigregister
Sphericity_swigregister(Sphericity)

class Thrust(_object):
    """
Thrust class.
This class performs thrust analysis on an event.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, Thrust, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, Thrust, name)
    __repr__ = _swig_repr

    def __init__(self, selectIn=2):
        """
Constructor.
"""
        this = _pythia8.new_Thrust(selectIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def analyze(self, event):
        """
Analyze event.
"""
        return _pythia8.Thrust_analyze(self, event)

    def thrust(self):
        """
Return info on results of analysis.
"""
        return _pythia8.Thrust_thrust(self)

    def tMajor(self):
        """
"""
        return _pythia8.Thrust_tMajor(self)

    def tMinor(self):
        """
"""
        return _pythia8.Thrust_tMinor(self)

    def oblateness(self):
        """
"""
        return _pythia8.Thrust_oblateness(self)

    def eventAxis(self, i):
        """
"""
        return _pythia8.Thrust_eventAxis(self, i)

    def nError(self):
        """
Tell how many events could not be analyzed.
"""
        return _pythia8.Thrust_nError(self)

    def __str__(self):
        return _pythia8.Thrust___str__(self)
    __swig_destroy__ = _pythia8.delete_Thrust
    __del__ = lambda self: None
Thrust_swigregister = _pythia8.Thrust_swigregister
Thrust_swigregister(Thrust)

class SingleClusterJet(_object):
    """
SingleClusterJet class.
Simple helper class to ClusterJet for a jet and its contents.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SingleClusterJet, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SingleClusterJet, name)
    __repr__ = _swig_repr

    def __init__(self, pJetIn=0., motherIn=0):
        """
Constructors.
"""
        this = _pythia8.new_SingleClusterJet(pJetIn, motherIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["pJet"] = _pythia8.SingleClusterJet_pJet_set
    __swig_getmethods__["pJet"] = _pythia8.SingleClusterJet_pJet_get
    if _newclass:
        pJet = _swig_property(_pythia8.SingleClusterJet_pJet_get, _pythia8.SingleClusterJet_pJet_set)
    __swig_setmethods__["mother"] = _pythia8.SingleClusterJet_mother_set
    __swig_getmethods__["mother"] = _pythia8.SingleClusterJet_mother_get
    if _newclass:
        mother = _swig_property(_pythia8.SingleClusterJet_mother_get, _pythia8.SingleClusterJet_mother_set)
    __swig_setmethods__["daughter"] = _pythia8.SingleClusterJet_daughter_set
    __swig_getmethods__["daughter"] = _pythia8.SingleClusterJet_daughter_get
    if _newclass:
        daughter = _swig_property(_pythia8.SingleClusterJet_daughter_get, _pythia8.SingleClusterJet_daughter_set)
    __swig_setmethods__["multiplicity"] = _pythia8.SingleClusterJet_multiplicity_set
    __swig_getmethods__["multiplicity"] = _pythia8.SingleClusterJet_multiplicity_get
    if _newclass:
        multiplicity = _swig_property(_pythia8.SingleClusterJet_multiplicity_get, _pythia8.SingleClusterJet_multiplicity_set)
    __swig_setmethods__["isAssigned"] = _pythia8.SingleClusterJet_isAssigned_set
    __swig_getmethods__["isAssigned"] = _pythia8.SingleClusterJet_isAssigned_get
    if _newclass:
        isAssigned = _swig_property(_pythia8.SingleClusterJet_isAssigned_get, _pythia8.SingleClusterJet_isAssigned_set)
    __swig_setmethods__["pAbs"] = _pythia8.SingleClusterJet_pAbs_set
    __swig_getmethods__["pAbs"] = _pythia8.SingleClusterJet_pAbs_get
    if _newclass:
        pAbs = _swig_property(_pythia8.SingleClusterJet_pAbs_get, _pythia8.SingleClusterJet_pAbs_set)
    __swig_setmethods__["pTemp"] = _pythia8.SingleClusterJet_pTemp_set
    __swig_getmethods__["pTemp"] = _pythia8.SingleClusterJet_pTemp_get
    if _newclass:
        pTemp = _swig_property(_pythia8.SingleClusterJet_pTemp_get, _pythia8.SingleClusterJet_pTemp_set)
    __swig_destroy__ = _pythia8.delete_SingleClusterJet
    __del__ = lambda self: None
SingleClusterJet_swigregister = _pythia8.SingleClusterJet_swigregister
SingleClusterJet_swigregister(SingleClusterJet)


def dist2Fun(measure, j1, j2):
    """
Namespace function declarations; friend of SingleClusterJet.
Distance measures (Lund, JADE, Durham) with friend.
"""
    return _pythia8.dist2Fun(measure, j1, j2)
dist2Fun = _pythia8.dist2Fun
class ClusterJet(_object):
    """
ClusterJet class.
This class performs a jet clustering according to different
distance measures: Lund, JADE or Durham.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ClusterJet, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ClusterJet, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor.
"""
        this = _pythia8.new_ClusterJet(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def analyze(self, event, yScaleIn, pTscaleIn, nJetMinIn=1, nJetMaxIn=0):
        """
Analyze event.
"""
        return _pythia8.ClusterJet_analyze(self, event, yScaleIn, pTscaleIn, nJetMinIn, nJetMaxIn)

    def size(self):
        """
Return info on jets produced.
"""
        return _pythia8.ClusterJet_size(self)

    def p(self, i):
        """
"""
        return _pythia8.ClusterJet_p(self, i)

    def mult(self, i):
        """
"""
        return _pythia8.ClusterJet_mult(self, i)

    def jetAssignment(self, i):
        """
Return belonging of particle to one of the jets (-1 if none).
"""
        return _pythia8.ClusterJet_jetAssignment(self, i)

    def distanceSize(self):
        """
Return info on clustering values.
"""
        return _pythia8.ClusterJet_distanceSize(self)

    def distance(self, i):
        """
"""
        return _pythia8.ClusterJet_distance(self, i)

    def nError(self):
        """
Tell how many events could not be analyzed.
"""
        return _pythia8.ClusterJet_nError(self)

    def __str__(self):
        return _pythia8.ClusterJet___str__(self)
    __swig_destroy__ = _pythia8.delete_ClusterJet
    __del__ = lambda self: None
ClusterJet_swigregister = _pythia8.ClusterJet_swigregister
ClusterJet_swigregister(ClusterJet)

class SingleCell(_object):
    """
SingleCell class.
Simple helper class to CellJet for a cell and its contents.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SingleCell, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SingleCell, name)
    __repr__ = _swig_repr

    def __init__(self, iCellIn=0, etaCellIn=0., phiCellIn=0., eTcellIn=0., multiplicityIn=0):
        """
Constructor.
"""
        this = _pythia8.new_SingleCell(iCellIn, etaCellIn, phiCellIn, eTcellIn, multiplicityIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["iCell"] = _pythia8.SingleCell_iCell_set
    __swig_getmethods__["iCell"] = _pythia8.SingleCell_iCell_get
    if _newclass:
        iCell = _swig_property(_pythia8.SingleCell_iCell_get, _pythia8.SingleCell_iCell_set)
    __swig_setmethods__["etaCell"] = _pythia8.SingleCell_etaCell_set
    __swig_getmethods__["etaCell"] = _pythia8.SingleCell_etaCell_get
    if _newclass:
        etaCell = _swig_property(_pythia8.SingleCell_etaCell_get, _pythia8.SingleCell_etaCell_set)
    __swig_setmethods__["phiCell"] = _pythia8.SingleCell_phiCell_set
    __swig_getmethods__["phiCell"] = _pythia8.SingleCell_phiCell_get
    if _newclass:
        phiCell = _swig_property(_pythia8.SingleCell_phiCell_get, _pythia8.SingleCell_phiCell_set)
    __swig_setmethods__["eTcell"] = _pythia8.SingleCell_eTcell_set
    __swig_getmethods__["eTcell"] = _pythia8.SingleCell_eTcell_get
    if _newclass:
        eTcell = _swig_property(_pythia8.SingleCell_eTcell_get, _pythia8.SingleCell_eTcell_set)
    __swig_setmethods__["multiplicity"] = _pythia8.SingleCell_multiplicity_set
    __swig_getmethods__["multiplicity"] = _pythia8.SingleCell_multiplicity_get
    if _newclass:
        multiplicity = _swig_property(_pythia8.SingleCell_multiplicity_get, _pythia8.SingleCell_multiplicity_set)
    __swig_setmethods__["canBeSeed"] = _pythia8.SingleCell_canBeSeed_set
    __swig_getmethods__["canBeSeed"] = _pythia8.SingleCell_canBeSeed_get
    if _newclass:
        canBeSeed = _swig_property(_pythia8.SingleCell_canBeSeed_get, _pythia8.SingleCell_canBeSeed_set)
    __swig_setmethods__["isUsed"] = _pythia8.SingleCell_isUsed_set
    __swig_getmethods__["isUsed"] = _pythia8.SingleCell_isUsed_get
    if _newclass:
        isUsed = _swig_property(_pythia8.SingleCell_isUsed_get, _pythia8.SingleCell_isUsed_set)
    __swig_setmethods__["isAssigned"] = _pythia8.SingleCell_isAssigned_set
    __swig_getmethods__["isAssigned"] = _pythia8.SingleCell_isAssigned_get
    if _newclass:
        isAssigned = _swig_property(_pythia8.SingleCell_isAssigned_get, _pythia8.SingleCell_isAssigned_set)
    __swig_destroy__ = _pythia8.delete_SingleCell
    __del__ = lambda self: None
SingleCell_swigregister = _pythia8.SingleCell_swigregister
SingleCell_swigregister(SingleCell)

class SingleCellJet(_object):
    """
SingleCellJet class.
Simple helper class to CellJet for a jet and its contents.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SingleCellJet, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SingleCellJet, name)
    __repr__ = _swig_repr

    def __init__(self, eTjetIn=0., etaCenterIn=0., phiCenterIn=0., etaWeightedIn=0., phiWeightedIn=0., multiplicityIn=0, pMassiveIn=0.):
        """
Constructor.
"""
        this = _pythia8.new_SingleCellJet(eTjetIn, etaCenterIn, phiCenterIn, etaWeightedIn, phiWeightedIn, multiplicityIn, pMassiveIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["eTjet"] = _pythia8.SingleCellJet_eTjet_set
    __swig_getmethods__["eTjet"] = _pythia8.SingleCellJet_eTjet_get
    if _newclass:
        eTjet = _swig_property(_pythia8.SingleCellJet_eTjet_get, _pythia8.SingleCellJet_eTjet_set)
    __swig_setmethods__["etaCenter"] = _pythia8.SingleCellJet_etaCenter_set
    __swig_getmethods__["etaCenter"] = _pythia8.SingleCellJet_etaCenter_get
    if _newclass:
        etaCenter = _swig_property(_pythia8.SingleCellJet_etaCenter_get, _pythia8.SingleCellJet_etaCenter_set)
    __swig_setmethods__["phiCenter"] = _pythia8.SingleCellJet_phiCenter_set
    __swig_getmethods__["phiCenter"] = _pythia8.SingleCellJet_phiCenter_get
    if _newclass:
        phiCenter = _swig_property(_pythia8.SingleCellJet_phiCenter_get, _pythia8.SingleCellJet_phiCenter_set)
    __swig_setmethods__["etaWeighted"] = _pythia8.SingleCellJet_etaWeighted_set
    __swig_getmethods__["etaWeighted"] = _pythia8.SingleCellJet_etaWeighted_get
    if _newclass:
        etaWeighted = _swig_property(_pythia8.SingleCellJet_etaWeighted_get, _pythia8.SingleCellJet_etaWeighted_set)
    __swig_setmethods__["phiWeighted"] = _pythia8.SingleCellJet_phiWeighted_set
    __swig_getmethods__["phiWeighted"] = _pythia8.SingleCellJet_phiWeighted_get
    if _newclass:
        phiWeighted = _swig_property(_pythia8.SingleCellJet_phiWeighted_get, _pythia8.SingleCellJet_phiWeighted_set)
    __swig_setmethods__["multiplicity"] = _pythia8.SingleCellJet_multiplicity_set
    __swig_getmethods__["multiplicity"] = _pythia8.SingleCellJet_multiplicity_get
    if _newclass:
        multiplicity = _swig_property(_pythia8.SingleCellJet_multiplicity_get, _pythia8.SingleCellJet_multiplicity_set)
    __swig_setmethods__["pMassive"] = _pythia8.SingleCellJet_pMassive_set
    __swig_getmethods__["pMassive"] = _pythia8.SingleCellJet_pMassive_get
    if _newclass:
        pMassive = _swig_property(_pythia8.SingleCellJet_pMassive_get, _pythia8.SingleCellJet_pMassive_set)
    __swig_destroy__ = _pythia8.delete_SingleCellJet
    __del__ = lambda self: None
SingleCellJet_swigregister = _pythia8.SingleCellJet_swigregister
SingleCellJet_swigregister(SingleCellJet)

class CellJet(_object):
    """
CellJet class.
This class performs a cone jet search in (eta, phi, E_T) space.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, CellJet, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, CellJet, name)
    __repr__ = _swig_repr

    def __init__(self, etaMaxIn=5., nEtaIn=50, nPhiIn=32, selectIn=2, smearIn=0, resolutionIn=0.5, upperCutIn=2., thresholdIn=0., rndmPtrIn=None):
        """
Constructor.
"""
        this = _pythia8.new_CellJet(etaMaxIn, nEtaIn, nPhiIn, selectIn, smearIn, resolutionIn, upperCutIn, thresholdIn, rndmPtrIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def analyze(self, event, eTjetMinIn=20., coneRadiusIn=0.7, eTseedIn=1.5):
        """
Analyze event.
"""
        return _pythia8.CellJet_analyze(self, event, eTjetMinIn, coneRadiusIn, eTseedIn)

    def size(self):
        """
Return info on results of analysis.
"""
        return _pythia8.CellJet_size(self)

    def eT(self, i):
        """
"""
        return _pythia8.CellJet_eT(self, i)

    def etaCenter(self, i):
        """
"""
        return _pythia8.CellJet_etaCenter(self, i)

    def phiCenter(self, i):
        """
"""
        return _pythia8.CellJet_phiCenter(self, i)

    def etaWeighted(self, i):
        """
"""
        return _pythia8.CellJet_etaWeighted(self, i)

    def phiWeighted(self, i):
        """
"""
        return _pythia8.CellJet_phiWeighted(self, i)

    def multiplicity(self, i):
        """
"""
        return _pythia8.CellJet_multiplicity(self, i)

    def pMassless(self, i):
        """
"""
        return _pythia8.CellJet_pMassless(self, i)

    def pMassive(self, i):
        """
"""
        return _pythia8.CellJet_pMassive(self, i)

    def m(self, i):
        """
"""
        return _pythia8.CellJet_m(self, i)

    def nError(self):
        """
Tell how many events could not be analyzed: so far never.
"""
        return _pythia8.CellJet_nError(self)

    def __str__(self):
        return _pythia8.CellJet___str__(self)
    __swig_destroy__ = _pythia8.delete_CellJet
    __del__ = lambda self: None
CellJet_swigregister = _pythia8.CellJet_swigregister
CellJet_swigregister(CellJet)

class SlowJetHook(_object):
    """
SlowJetHook class.
Base class, used to derive your own class with your selection criteria.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SlowJetHook, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SlowJetHook, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _pythia8.delete_SlowJetHook
    __del__ = lambda self: None

    def include(self, iSel, event, pSel, mSel):
        """
Method to be overloaded.
It will be called for all final-state particles, one at a time, and
should return true if the particle should be analyzed, false if not.
The particle is in location iSel of the event record.
If you wish you can also modify the four-momentum and mass that will
 be used in the analysis, without affecting the event record itself,
by changing pSel and mSel. Remember to respect E^2 - p^2 = m^2.
"""
        return _pythia8.SlowJetHook_include(self, iSel, event, pSel, mSel)
SlowJetHook_swigregister = _pythia8.SlowJetHook_swigregister
SlowJetHook_swigregister(SlowJetHook)

class SingleSlowJet(_object):
    """
SingleSlowJet class.
Simple helper class to SlowJet for a jet and its contents.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SingleSlowJet, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SingleSlowJet, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_SingleSlowJet(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["p"] = _pythia8.SingleSlowJet_p_set
    __swig_getmethods__["p"] = _pythia8.SingleSlowJet_p_get
    if _newclass:
        p = _swig_property(_pythia8.SingleSlowJet_p_get, _pythia8.SingleSlowJet_p_set)
    __swig_setmethods__["pT2"] = _pythia8.SingleSlowJet_pT2_set
    __swig_getmethods__["pT2"] = _pythia8.SingleSlowJet_pT2_get
    if _newclass:
        pT2 = _swig_property(_pythia8.SingleSlowJet_pT2_get, _pythia8.SingleSlowJet_pT2_set)
    __swig_setmethods__["y"] = _pythia8.SingleSlowJet_y_set
    __swig_getmethods__["y"] = _pythia8.SingleSlowJet_y_get
    if _newclass:
        y = _swig_property(_pythia8.SingleSlowJet_y_get, _pythia8.SingleSlowJet_y_set)
    __swig_setmethods__["phi"] = _pythia8.SingleSlowJet_phi_set
    __swig_getmethods__["phi"] = _pythia8.SingleSlowJet_phi_get
    if _newclass:
        phi = _swig_property(_pythia8.SingleSlowJet_phi_get, _pythia8.SingleSlowJet_phi_set)
    __swig_setmethods__["mult"] = _pythia8.SingleSlowJet_mult_set
    __swig_getmethods__["mult"] = _pythia8.SingleSlowJet_mult_get
    if _newclass:
        mult = _swig_property(_pythia8.SingleSlowJet_mult_get, _pythia8.SingleSlowJet_mult_set)
    __swig_setmethods__["idx"] = _pythia8.SingleSlowJet_idx_set
    __swig_getmethods__["idx"] = _pythia8.SingleSlowJet_idx_get
    if _newclass:
        idx = _swig_property(_pythia8.SingleSlowJet_idx_get, _pythia8.SingleSlowJet_idx_set)
    __swig_destroy__ = _pythia8.delete_SingleSlowJet
    __del__ = lambda self: None
SingleSlowJet_swigregister = _pythia8.SingleSlowJet_swigregister
SingleSlowJet_swigregister(SingleSlowJet)

class SlowJet(_object):
    """
SlowJet class.
This class performs a recombination jet search in (y, phi, pT) space.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SlowJet, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SlowJet, name)
    __repr__ = _swig_repr

    def __init__(self, powerIn, Rin, pTjetMinIn=0., etaMaxIn=25., selectIn=2, massSetIn=2, sjHookPtrIn=None, useFJcoreIn=True, useStandardRin=True):
        """
Constructor.
"""
        this = _pythia8.new_SlowJet(powerIn, Rin, pTjetMinIn, etaMaxIn, selectIn, massSetIn, sjHookPtrIn, useFJcoreIn, useStandardRin)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_SlowJet
    __del__ = lambda self: None

    def analyze(self, event):
        """
Analyze event, all in one go.
"""
        return _pythia8.SlowJet_analyze(self, event)

    def setup(self, event):
        """
Set up list of particles to analyze, and initial distances.
"""
        return _pythia8.SlowJet_setup(self, event)

    def doStep(self):
        """
Do one recombination step, possibly giving a jet.
"""
        return _pythia8.SlowJet_doStep(self)

    def doNSteps(self, nStep):
        """
Do several recombinations steps, if possible.
"""
        return _pythia8.SlowJet_doNSteps(self, nStep)

    def stopAtN(self, nStop):
        """
Do recombinations until fixed numbers of clusters and jets remain.
"""
        return _pythia8.SlowJet_stopAtN(self, nStop)

    def sizeOrig(self):
        """
Return info on jet (+cluster) results of analysis.
"""
        return _pythia8.SlowJet_sizeOrig(self)

    def sizeJet(self):
        """
"""
        return _pythia8.SlowJet_sizeJet(self)

    def sizeAll(self):
        """
"""
        return _pythia8.SlowJet_sizeAll(self)

    def pT(self, i):
        """
"""
        return _pythia8.SlowJet_pT(self, i)

    def y(self, i):
        """
"""
        return _pythia8.SlowJet_y(self, i)

    def phi(self, i):
        """
"""
        return _pythia8.SlowJet_phi(self, i)

    def p(self, i):
        """
"""
        return _pythia8.SlowJet_p(self, i)

    def m(self, i):
        """
"""
        return _pythia8.SlowJet_m(self, i)

    def multiplicity(self, i):
        """
"""
        return _pythia8.SlowJet_multiplicity(self, i)

    def iNext(self):
        """
Return info on next step to be taken.
"""
        return _pythia8.SlowJet_iNext(self)

    def jNext(self):
        """
"""
        return _pythia8.SlowJet_jNext(self)

    def dNext(self):
        """
"""
        return _pythia8.SlowJet_dNext(self)

    def constituents(self, j):
        """
Give a list of all particles in the jet.
"""
        return _pythia8.SlowJet_constituents(self, j)

    def clusConstituents(self, j):
        """
Give a list of all particles in the cluster.
"""
        return _pythia8.SlowJet_clusConstituents(self, j)

    def jetAssignment(self, i):
        """
Give the index of the jet that the particle i of the event record
belongs to. Returns -1 if particle i is not found in a jet.
"""
        return _pythia8.SlowJet_jetAssignment(self, i)

    def removeJet(self, i):
        """
Remove a jet.
"""
        return _pythia8.SlowJet_removeJet(self, i)

    def __str__(self):
        return _pythia8.SlowJet___str__(self)
SlowJet_swigregister = _pythia8.SlowJet_swigregister
SlowJet_swigregister(SlowJet)

class ResolvedParton(_object):
    """
This class holds info on a parton resolved inside the incoming beam,
i.e. either an initiator (part of a hard or a multiparton interaction)
or a remnant (part of the beam remnant treatment).
The companion code is -1 from onset and for g, is -2 for an unmatched
sea quark, is >= 0 for a matched sea quark, with the number giving the
companion position, and is -3 for a valence quark.
Rescattering partons properly do not belong here, but bookkeeping is
simpler with them, so they are stored with companion code -10.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ResolvedParton, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ResolvedParton, name)
    __repr__ = _swig_repr

    def __init__(self, iPosIn=0, idIn=0, xIn=0., companionIn=-1):
        """
Constructor.
"""
        this = _pythia8.new_ResolvedParton(iPosIn, idIn, xIn, companionIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def update(self, iPosIn, idIn, xIn):
        """
"""
        return _pythia8.ResolvedParton_update(self, iPosIn, idIn, xIn)

    def cols(self, colIn=0, acolIn=0):
        """
"""
        return _pythia8.ResolvedParton_cols(self, colIn, acolIn)

    def scalePT(self, factorIn):
        """
"""
        return _pythia8.ResolvedParton_scalePT(self, factorIn)

    def scaleX(self, factorIn):
        """
"""
        return _pythia8.ResolvedParton_scaleX(self, factorIn)

    def iPos(self, *args):
        """
Get info on initiator or remnant parton.
"""
        return _pythia8.ResolvedParton_iPos(self, *args)

    def id(self, *args):
        """
"""
        return _pythia8.ResolvedParton_id(self, *args)

    def x(self, *args):
        """
"""
        return _pythia8.ResolvedParton_x(self, *args)

    def companion(self, *args):
        """
"""
        return _pythia8.ResolvedParton_companion(self, *args)

    def isValence(self):
        """
"""
        return _pythia8.ResolvedParton_isValence(self)

    def isUnmatched(self):
        """
"""
        return _pythia8.ResolvedParton_isUnmatched(self)

    def isCompanion(self):
        """
"""
        return _pythia8.ResolvedParton_isCompanion(self)

    def isFromBeam(self):
        """
"""
        return _pythia8.ResolvedParton_isFromBeam(self)

    def xqCompanion(self, *args):
        """
"""
        return _pythia8.ResolvedParton_xqCompanion(self, *args)

    def p(self, *args):
        """
"""
        return _pythia8.ResolvedParton_p(self, *args)

    def px(self, *args):
        """
"""
        return _pythia8.ResolvedParton_px(self, *args)

    def py(self, *args):
        """
"""
        return _pythia8.ResolvedParton_py(self, *args)

    def pz(self, *args):
        """
"""
        return _pythia8.ResolvedParton_pz(self, *args)

    def e(self, *args):
        """
"""
        return _pythia8.ResolvedParton_e(self, *args)

    def m(self, *args):
        """
"""
        return _pythia8.ResolvedParton_m(self, *args)

    def pT(self):
        """
"""
        return _pythia8.ResolvedParton_pT(self)

    def mT2(self):
        """
"""
        return _pythia8.ResolvedParton_mT2(self)

    def pPos(self):
        """
"""
        return _pythia8.ResolvedParton_pPos(self)

    def pNeg(self):
        """
"""
        return _pythia8.ResolvedParton_pNeg(self)

    def col(self, *args):
        """
"""
        return _pythia8.ResolvedParton_col(self, *args)

    def acol(self, *args):
        """
"""
        return _pythia8.ResolvedParton_acol(self, *args)

    def pTfactor(self):
        """
"""
        return _pythia8.ResolvedParton_pTfactor(self)

    def hasCol(self):
        """
"""
        return _pythia8.ResolvedParton_hasCol(self)

    def hasAcol(self):
        """
"""
        return _pythia8.ResolvedParton_hasAcol(self)
    __swig_destroy__ = _pythia8.delete_ResolvedParton
    __del__ = lambda self: None
ResolvedParton_swigregister = _pythia8.ResolvedParton_swigregister
ResolvedParton_swigregister(ResolvedParton)

class BeamParticle(_object):
    """
This class holds info on a beam particle in the evolution of
initial-state radiation and multiparton interactions.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BeamParticle, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BeamParticle, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_BeamParticle()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, idIn, pzIn, eIn, mIn, infoPtrIn, settings, particleDataPtrIn, rndmPtrIn, pdfInPtr, pdfHardInPtr, isUnresolvedIn, flavSelPtrIn):
        """
Initialize data on a beam particle and save pointers.
"""
        return _pythia8.BeamParticle_init(self, idIn, pzIn, eIn, mIn, infoPtrIn, settings, particleDataPtrIn, rndmPtrIn, pdfInPtr, pdfHardInPtr, isUnresolvedIn, flavSelPtrIn)

    def initPDFPtr(self, pdfInPtr, pdfHardInPtr):
        """
Initialize only the two pdf pointers.
"""
        return _pythia8.BeamParticle_initPDFPtr(self, pdfInPtr, pdfHardInPtr)

    def initUnres(self, pdfUnresInPtr):
        """
Initialize additional PDF pointer for unresolved beam.
"""
        return _pythia8.BeamParticle_initUnres(self, pdfUnresInPtr)

    def newValenceContent(self):
        """
For mesons like pi0 valence content varies from event to event.
"""
        return _pythia8.BeamParticle_newValenceContent(self)

    def newPzE(self, pzIn, eIn):
        """
Set new pZ and E, but keep the rest the same.
"""
        return _pythia8.BeamParticle_newPzE(self, pzIn, eIn)

    def newM(self, mIn):
        """
Set new mass. Used with photons when virtuality is sampled.
"""
        return _pythia8.BeamParticle_newM(self, mIn)

    def id(self):
        """
Member functions for output.
"""
        return _pythia8.BeamParticle_id(self)

    def idVMD(self):
        """
"""
        return _pythia8.BeamParticle_idVMD(self)

    def p(self):
        """
"""
        return _pythia8.BeamParticle_p(self)

    def px(self):
        """
"""
        return _pythia8.BeamParticle_px(self)

    def py(self):
        """
"""
        return _pythia8.BeamParticle_py(self)

    def pz(self):
        """
"""
        return _pythia8.BeamParticle_pz(self)

    def e(self):
        """
"""
        return _pythia8.BeamParticle_e(self)

    def m(self):
        """
"""
        return _pythia8.BeamParticle_m(self)

    def mVMD(self):
        """
"""
        return _pythia8.BeamParticle_mVMD(self)

    def scaleVMD(self):
        """
"""
        return _pythia8.BeamParticle_scaleVMD(self)

    def isLepton(self):
        """
"""
        return _pythia8.BeamParticle_isLepton(self)

    def isUnresolved(self):
        """
"""
        return _pythia8.BeamParticle_isUnresolved(self)

    def isHadron(self):
        """
As hadrons here we only count those we know how to handle remnants for.
"""
        return _pythia8.BeamParticle_isHadron(self)

    def isMeson(self):
        """
"""
        return _pythia8.BeamParticle_isMeson(self)

    def isBaryon(self):
        """
"""
        return _pythia8.BeamParticle_isBaryon(self)

    def isGamma(self):
        """
"""
        return _pythia8.BeamParticle_isGamma(self)

    def hasResGamma(self):
        """
"""
        return _pythia8.BeamParticle_hasResGamma(self)

    def hasVMDstate(self):
        """
"""
        return _pythia8.BeamParticle_hasVMDstate(self)

    def xMax(self, iSkip=-1):
        """
Maximum x remaining after previous MPI and ISR, plus safety margin.
"""
        return _pythia8.BeamParticle_xMax(self, iSkip)

    def xfHard(self, idIn, x, Q2):
        """
Special hard-process parton distributions (can agree with standard ones).
"""
        return _pythia8.BeamParticle_xfHard(self, idIn, x, Q2)

    def xfMax(self, idIn, x, Q2):
        """
Overestimate for PDFs. Same as normal except photons inside leptons.
"""
        return _pythia8.BeamParticle_xfMax(self, idIn, x, Q2)

    def xfFlux(self, idIn, x, Q2):
        """
Accurate and approximated photon flux and PDFs.
"""
        return _pythia8.BeamParticle_xfFlux(self, idIn, x, Q2)

    def xfApprox(self, idIn, x, Q2):
        """
"""
        return _pythia8.BeamParticle_xfApprox(self, idIn, x, Q2)

    def xfGamma(self, idIn, x, Q2):
        """
"""
        return _pythia8.BeamParticle_xfGamma(self, idIn, x, Q2)

    def xfSame(self, idIn, x, Q2):
        """
Do not sample the x_gamma value to get correct cross section with
possible second call.
"""
        return _pythia8.BeamParticle_xfSame(self, idIn, x, Q2)

    def xf(self, idIn, x, Q2):
        """
Standard parton distributions.
"""
        return _pythia8.BeamParticle_xf(self, idIn, x, Q2)

    def xfVal(self, idIn, x, Q2):
        """
Ditto, split into valence and sea parts (where gluon counts as sea).
"""
        return _pythia8.BeamParticle_xfVal(self, idIn, x, Q2)

    def xfSea(self, idIn, x, Q2):
        """
"""
        return _pythia8.BeamParticle_xfSea(self, idIn, x, Q2)

    def xfMPI(self, idIn, x, Q2):
        """
Rescaled parton distributions, as needed for MPI and ISR.
For ISR also allow split valence/sea, and only return relevant part.
"""
        return _pythia8.BeamParticle_xfMPI(self, idIn, x, Q2)

    def xfISR(self, indexMPI, idIn, x, Q2):
        """
"""
        return _pythia8.BeamParticle_xfISR(self, indexMPI, idIn, x, Q2)

    def insideBounds(self, x, Q2):
        """
Check whether x and Q2 values fall inside the fit bounds (LHAPDF6 only).
"""
        return _pythia8.BeamParticle_insideBounds(self, x, Q2)

    def alphaS(self, Q2):
        """
Access the running alpha_s of a PDF set (LHAPDF6 only).
"""
        return _pythia8.BeamParticle_alphaS(self, Q2)

    def mQuarkPDF(self, idIn):
        """
Return quark masses used in the PDF fit (LHAPDF6 only).
"""
        return _pythia8.BeamParticle_mQuarkPDF(self, idIn)

    def nMembers(self):
        """
Return number of members in PDF family (LHAPDF6 only).
"""
        return _pythia8.BeamParticle_nMembers(self)

    def calcPDFEnvelope(self, *args):
        """
"""
        return _pythia8.BeamParticle_calcPDFEnvelope(self, *args)

    def getPDFEnvelope(self):
        """
"""
        return _pythia8.BeamParticle_getPDFEnvelope(self)

    def pickValSeaComp(self):
        """
Decide whether chosen quark is valence, sea or companion.
"""
        return _pythia8.BeamParticle_pickValSeaComp(self)

    def initBeamKind(self):
        """
Initialize kind of incoming beam particle.
"""
        return _pythia8.BeamParticle_initBeamKind(self)

    def size(self):
        """
Total number of partons extracted from beam, and initiators only.
"""
        return _pythia8.BeamParticle_size(self)

    def sizeInit(self):
        """
"""
        return _pythia8.BeamParticle_sizeInit(self)

    def clear(self):
        """
Clear list of resolved partons.
"""
        return _pythia8.BeamParticle_clear(self)

    def resetGamma(self):
        """
Reset variables related to photon beam.
"""
        return _pythia8.BeamParticle_resetGamma(self)

    def resetGammaInLepton(self):
        """
Reset variables related to photon beam inside a lepton.
"""
        return _pythia8.BeamParticle_resetGammaInLepton(self)

    def append(self, iPos, idIn, x, companion=-1):
        """
Add a resolved parton to list.
"""
        return _pythia8.BeamParticle_append(self, iPos, idIn, x, companion)

    def popBack(self):
        """
Remove the last particle from the beam. Reset companion code if needed.
"""
        return _pythia8.BeamParticle_popBack(self)

    def nValenceKinds(self):
        """
How many different flavours, and how many quarks of given flavour.
"""
        return _pythia8.BeamParticle_nValenceKinds(self)

    def nValence(self, idIn):
        """
"""
        return _pythia8.BeamParticle_nValence(self, idIn)

    def isUnresolvedLepton(self):
        """
Test whether a lepton is to be considered as unresolved.
"""
        return _pythia8.BeamParticle_isUnresolvedLepton(self)

    def remnantFlavours(self, event, isDIS=False):
        """
Add extra remnant flavours to make valence and sea come out right.
"""
        return _pythia8.BeamParticle_remnantFlavours(self, event, isDIS)

    def remnantColours(self, event, colFrom, colTo):
        """
Correlate all initiators and remnants to make a colour singlet.
"""
        return _pythia8.BeamParticle_remnantColours(self, event, colFrom, colTo)

    def xRemnant(self, i):
        """
Pick unrescaled x of remnant parton (valence or sea).
"""
        return _pythia8.BeamParticle_xRemnant(self, i)

    def hasJunction(self):
        """
Tell whether a junction has been resolved, and its junction colours.
"""
        return _pythia8.BeamParticle_hasJunction(self)

    def junctionCol(self, *args):
        """
"""
        return _pythia8.BeamParticle_junctionCol(self, *args)

    def pickGluon(self, mDiff):
        """
For a diffractive system, decide whether to kick out gluon or quark.
"""
        return _pythia8.BeamParticle_pickGluon(self, mDiff)

    def pickValence(self):
        """
Pick a valence quark at random, and provide the remaining flavour.
"""
        return _pythia8.BeamParticle_pickValence(self)

    def pickRemnant(self):
        """
"""
        return _pythia8.BeamParticle_pickRemnant(self)

    def zShare(self, mDiff, m1, m2):
        """
Share lightcone momentum between two remnants in a diffractive system.
At the same time generate a relative pT for the two.
"""
        return _pythia8.BeamParticle_zShare(self, mDiff, m1, m2)

    def pxShare(self):
        """
"""
        return _pythia8.BeamParticle_pxShare(self)

    def pyShare(self):
        """
"""
        return _pythia8.BeamParticle_pyShare(self)

    def remnantFlavoursNew(self, event):
        """
Add extra remnant flavours to make valence and sea come out right.
"""
        return _pythia8.BeamParticle_remnantFlavoursNew(self, event)

    def findColSetup(self, event):
        """
Find the colour setup of the removed partons from the scatterings.
"""
        return _pythia8.BeamParticle_findColSetup(self, event)

    def setInitialCol(self, event):
        """
Set initial colours.
"""
        return _pythia8.BeamParticle_setInitialCol(self, event)

    def updateCol(self, colourChanges):
        """
Update colours.
"""
        return _pythia8.BeamParticle_updateCol(self, colourChanges)

    def getColUpdates(self):
        """
"""
        return _pythia8.BeamParticle_getColUpdates(self)

    def gammaInitiatorIsVal(self, *args):
        """
"""
        return _pythia8.BeamParticle_gammaInitiatorIsVal(self, *args)

    def getGammaValFlavour(self):
        """
"""
        return _pythia8.BeamParticle_getGammaValFlavour(self)

    def gammaValSeaComp(self, iResolved):
        """
"""
        return _pythia8.BeamParticle_gammaValSeaComp(self, iResolved)

    def posVal(self, iPosValIn):
        """
"""
        return _pythia8.BeamParticle_posVal(self, iPosValIn)

    def gamVal(self, *args):
        """
"""
        return _pythia8.BeamParticle_gamVal(self, *args)

    def resolvedGamma(self, *args):
        """
"""
        return _pythia8.BeamParticle_resolvedGamma(self, *args)

    def setGammaMode(self, gammaModeIn):
        """
"""
        return _pythia8.BeamParticle_setGammaMode(self, gammaModeIn)

    def getGammaMode(self):
        """
"""
        return _pythia8.BeamParticle_getGammaMode(self)

    def isResolvedUnresolved(self):
        """
"""
        return _pythia8.BeamParticle_isResolvedUnresolved(self)

    def setVMDstate(self, isVMDIn, idIn, mIn, scaleIn, reassignState=False):
        """
Set state of VMD inside gamma.
"""
        return _pythia8.BeamParticle_setVMDstate(self, isVMDIn, idIn, mIn, scaleIn, reassignState)

    def pT2gamma2qqbar(self, *args):
        """
"""
        return _pythia8.BeamParticle_pT2gamma2qqbar(self, *args)

    def pTMPI(self, pTminMPIin):
        """
Store the pT value for the latest MPI.
"""
        return _pythia8.BeamParticle_pTMPI(self, pTminMPIin)

    def roomFor1Remnant(self, *args):
        """
"""
        return _pythia8.BeamParticle_roomFor1Remnant(self, *args)

    def roomFor2Remnants(self, id1, x1, eCM):
        """
"""
        return _pythia8.BeamParticle_roomFor2Remnants(self, id1, x1, eCM)

    def roomForRemnants(self, beamOther):
        """
"""
        return _pythia8.BeamParticle_roomForRemnants(self, beamOther)

    def remnantMass(self, idIn):
        """
Evaluate the remnant mass with initiator idIn.
"""
        return _pythia8.BeamParticle_remnantMass(self, idIn)

    def gammaPDFxDependence(self, flavour, x):
        """
Functions to approximate pdfs for ISR.
"""
        return _pythia8.BeamParticle_gammaPDFxDependence(self, flavour, x)

    def gammaPDFRefScale(self, flavour):
        """
"""
        return _pythia8.BeamParticle_gammaPDFRefScale(self, flavour)

    def xIntegratedPDFs(self, Q2):
        """
"""
        return _pythia8.BeamParticle_xIntegratedPDFs(self, Q2)

    def xGammaPDF(self):
        """
Save the x_gamma value after latest PDF call or set it later if ND.
"""
        return _pythia8.BeamParticle_xGammaPDF(self)

    def newGammaKTPhi(self, kTIn, phiIn):
        """
"""
        return _pythia8.BeamParticle_newGammaKTPhi(self, kTIn, phiIn)

    def xGammaMin(self):
        """
Get the kinematic limits for photons emitted by the beam.
"""
        return _pythia8.BeamParticle_xGammaMin(self)

    def xGammaHadr(self):
        """
"""
        return _pythia8.BeamParticle_xGammaHadr(self)

    def gammaFluxIntApprox(self):
        """
"""
        return _pythia8.BeamParticle_gammaFluxIntApprox(self)

    def xGamma(self, *args):
        """
Get the kinematics related photons form lepton beams.
"""
        return _pythia8.BeamParticle_xGamma(self, *args)

    def Q2Gamma(self, *args):
        """
"""
        return _pythia8.BeamParticle_Q2Gamma(self, *args)

    def gammaKTx(self):
        """
"""
        return _pythia8.BeamParticle_gammaKTx(self)

    def gammaKTy(self):
        """
"""
        return _pythia8.BeamParticle_gammaKTy(self)

    def gammaKT(self):
        """
"""
        return _pythia8.BeamParticle_gammaKT(self)

    def gammaPhi(self):
        """
"""
        return _pythia8.BeamParticle_gammaPhi(self)

    def xPom(self, xpom=-1.0):
        """
Keep track of pomeron momentum fraction.
"""
        return _pythia8.BeamParticle_xPom(self, xpom)

    def sampleXgamma(self, xMinIn):
        """
Sample x and Q2 for emitted photons according to flux.
"""
        return _pythia8.BeamParticle_sampleXgamma(self, xMinIn)

    def sampleQ2gamma(self, Q2min):
        """
"""
        return _pythia8.BeamParticle_sampleQ2gamma(self, Q2min)

    def __str__(self):
        return _pythia8.BeamParticle___str__(self)

    def __getitem__(self, i):
        return _pythia8.BeamParticle___getitem__(self, i)
    __swig_destroy__ = _pythia8.delete_BeamParticle
    __del__ = lambda self: None
BeamParticle_swigregister = _pythia8.BeamParticle_swigregister
BeamParticle_swigregister(BeamParticle)

class BoseEinsteinHadron(_object):
    """
The BoseEinsteinHadron class is a simple container for studied hadrons.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BoseEinsteinHadron, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BoseEinsteinHadron, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
"""
        this = _pythia8.new_BoseEinsteinHadron(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["id"] = _pythia8.BoseEinsteinHadron_id_set
    __swig_getmethods__["id"] = _pythia8.BoseEinsteinHadron_id_get
    if _newclass:
        id = _swig_property(_pythia8.BoseEinsteinHadron_id_get, _pythia8.BoseEinsteinHadron_id_set)
    __swig_setmethods__["iPos"] = _pythia8.BoseEinsteinHadron_iPos_set
    __swig_getmethods__["iPos"] = _pythia8.BoseEinsteinHadron_iPos_get
    if _newclass:
        iPos = _swig_property(_pythia8.BoseEinsteinHadron_iPos_get, _pythia8.BoseEinsteinHadron_iPos_set)
    __swig_setmethods__["p"] = _pythia8.BoseEinsteinHadron_p_set
    __swig_getmethods__["p"] = _pythia8.BoseEinsteinHadron_p_get
    if _newclass:
        p = _swig_property(_pythia8.BoseEinsteinHadron_p_get, _pythia8.BoseEinsteinHadron_p_set)
    __swig_setmethods__["pShift"] = _pythia8.BoseEinsteinHadron_pShift_set
    __swig_getmethods__["pShift"] = _pythia8.BoseEinsteinHadron_pShift_get
    if _newclass:
        pShift = _swig_property(_pythia8.BoseEinsteinHadron_pShift_get, _pythia8.BoseEinsteinHadron_pShift_set)
    __swig_setmethods__["pComp"] = _pythia8.BoseEinsteinHadron_pComp_set
    __swig_getmethods__["pComp"] = _pythia8.BoseEinsteinHadron_pComp_get
    if _newclass:
        pComp = _swig_property(_pythia8.BoseEinsteinHadron_pComp_get, _pythia8.BoseEinsteinHadron_pComp_set)
    __swig_setmethods__["m2"] = _pythia8.BoseEinsteinHadron_m2_set
    __swig_getmethods__["m2"] = _pythia8.BoseEinsteinHadron_m2_get
    if _newclass:
        m2 = _swig_property(_pythia8.BoseEinsteinHadron_m2_get, _pythia8.BoseEinsteinHadron_m2_set)
    __swig_destroy__ = _pythia8.delete_BoseEinsteinHadron
    __del__ = lambda self: None
BoseEinsteinHadron_swigregister = _pythia8.BoseEinsteinHadron_swigregister
BoseEinsteinHadron_swigregister(BoseEinsteinHadron)

class BoseEinstein(_object):
    """
The BoseEinstein class shifts the momenta of identical particles relative
to each other, to simulate Bose-Einstein effects to some approximation.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, BoseEinstein, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, BoseEinstein, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_BoseEinstein()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, infoPtrIn, settings, particleData):
        """
Find settings. Precalculate table used to find momentum shifts.
"""
        return _pythia8.BoseEinstein_init(self, infoPtrIn, settings, particleData)

    def shiftEvent(self, event):
        """
Perform Bose-Einstein corrections on an event.
"""
        return _pythia8.BoseEinstein_shiftEvent(self, event)
    __swig_destroy__ = _pythia8.delete_BoseEinstein
    __del__ = lambda self: None
BoseEinstein_swigregister = _pythia8.BoseEinstein_swigregister
BoseEinstein_swigregister(BoseEinstein)

class ColourTracing(_object):
    """
ColourTracing class. It is used to trace colours within the event record.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, ColourTracing, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, ColourTracing, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_ColourTracing()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, infoPtrIn):
        """
"""
        return _pythia8.ColourTracing_init(self, infoPtrIn)

    def setupColList(self, event):
        """
Setup the colour lists.
"""
        return _pythia8.ColourTracing_setupColList(self, event)

    def traceFromAcol(self, indxCol, event, iJun, iCol, iParton):
        """
Trace a colour line, from a colour, from an anticolour, or in loop.
"""
        return _pythia8.ColourTracing_traceFromAcol(self, indxCol, event, iJun, iCol, iParton)

    def traceFromCol(self, indxCol, event, iJun, iCol, iParton):
        """
"""
        return _pythia8.ColourTracing_traceFromCol(self, indxCol, event, iJun, iCol, iParton)

    def traceInLoop(self, event, iParton):
        """
"""
        return _pythia8.ColourTracing_traceInLoop(self, event, iParton)

    def finished(self):
        """
"""
        return _pythia8.ColourTracing_finished(self)

    def colFinished(self):
        """
"""
        return _pythia8.ColourTracing_colFinished(self)

    def getJunChains(self, event):
        """
Get junction chains where the junctions are directly connected.
"""
        return _pythia8.ColourTracing_getJunChains(self, event)
    __swig_destroy__ = _pythia8.delete_ColourTracing
    __del__ = lambda self: None
ColourTracing_swigregister = _pythia8.ColourTracing_swigregister
ColourTracing_swigregister(ColourTracing)

class DeuteronProduction(_object):
    """
The DeuteronProduction class.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, DeuteronProduction, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, DeuteronProduction, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_DeuteronProduction()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, infoPtrIn, settings, pdbPtrIn, rndmPtrIn):
        """
Find settings. Precalculate table used to find momentum shifts.
"""
        return _pythia8.DeuteronProduction_init(self, infoPtrIn, settings, pdbPtrIn, rndmPtrIn)

    def combine(self, event):
        """
Form deuterons in an event.
"""
        return _pythia8.DeuteronProduction_combine(self, event)
    __swig_destroy__ = _pythia8.delete_DeuteronProduction
    __del__ = lambda self: None
DeuteronProduction_swigregister = _pythia8.DeuteronProduction_swigregister
DeuteronProduction_swigregister(DeuteronProduction)

class GammaKinematics(_object):
    """
Class to sample the virtuality and transverse momentum of emitted photons.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, GammaKinematics, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, GammaKinematics, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_GammaKinematics()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, infoPtrIn, settingsPtrIn, rndmPtrIn, beamAPtrIn, beamBPtrIn, couplingsPtrIn):
        """
Sample the trial or final event kinematics.
"""
        return _pythia8.GammaKinematics_init(self, infoPtrIn, settingsPtrIn, rndmPtrIn, beamAPtrIn, beamBPtrIn, couplingsPtrIn)

    def sampleKTgamma(self, nonDiff=False):
        """
Sampling of the kinematics of the intermediate photon.
"""
        return _pythia8.GammaKinematics_sampleKTgamma(self, nonDiff)

    def deriveKin(self, xGamma, Q2gamma, m2beam, eCM2):
        """
"""
        return _pythia8.GammaKinematics_deriveKin(self, xGamma, Q2gamma, m2beam, eCM2)

    def finalize(self):
        """
"""
        return _pythia8.GammaKinematics_finalize(self)

    def trialKinSoftPhaseSpaceSampling(self):
        """
"""
        return _pythia8.GammaKinematics_trialKinSoftPhaseSpaceSampling(self)

    def fluxWeight(self):
        """
"""
        return _pythia8.GammaKinematics_fluxWeight(self)

    def setupSoftPhaseSpaceSampling(self, sigmaMax):
        """
"""
        return _pythia8.GammaKinematics_setupSoftPhaseSpaceSampling(self, sigmaMax)

    def calcNewSHat(self, sHatOld):
        """
Calculate and return rescaled sHat according to the process.
"""
        return _pythia8.GammaKinematics_calcNewSHat(self, sHatOld)

    def getQ2gamma1(self):
        """
Methods to pass along the sampled values.
"""
        return _pythia8.GammaKinematics_getQ2gamma1(self)

    def getQ2gamma2(self):
        """
"""
        return _pythia8.GammaKinematics_getQ2gamma2(self)

    def getPhi1(self):
        """
"""
        return _pythia8.GammaKinematics_getPhi1(self)

    def getPhi2(self):
        """
"""
        return _pythia8.GammaKinematics_getPhi2(self)

    def getKT1(self):
        """
"""
        return _pythia8.GammaKinematics_getKT1(self)

    def getKT2(self):
        """
"""
        return _pythia8.GammaKinematics_getKT2(self)

    def eCMsub(self):
        """
"""
        return _pythia8.GammaKinematics_eCMsub(self)

    def weight(self):
        """
"""
        return _pythia8.GammaKinematics_weight(self)

    def idInA(self):
        """
"""
        return _pythia8.GammaKinematics_idInA(self)

    def idInB(self):
        """
"""
        return _pythia8.GammaKinematics_idInB(self)
    __swig_destroy__ = _pythia8.delete_GammaKinematics
    __del__ = lambda self: None
GammaKinematics_swigregister = _pythia8.GammaKinematics_swigregister
GammaKinematics_swigregister(GammaKinematics)

class HardProcess(_object):
    """
Declaration of hard process class
This class holds information on the desired hard 2->2 process
for the merging.
This class is a container class for History class use.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, HardProcess, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, HardProcess, name)
    __repr__ = _swig_repr
    __swig_setmethods__["hardIncoming1"] = _pythia8.HardProcess_hardIncoming1_set
    __swig_getmethods__["hardIncoming1"] = _pythia8.HardProcess_hardIncoming1_get
    if _newclass:
        hardIncoming1 = _swig_property(_pythia8.HardProcess_hardIncoming1_get, _pythia8.HardProcess_hardIncoming1_set)
    __swig_setmethods__["hardIncoming2"] = _pythia8.HardProcess_hardIncoming2_set
    __swig_getmethods__["hardIncoming2"] = _pythia8.HardProcess_hardIncoming2_get
    if _newclass:
        hardIncoming2 = _swig_property(_pythia8.HardProcess_hardIncoming2_get, _pythia8.HardProcess_hardIncoming2_set)
    __swig_setmethods__["hardOutgoing1"] = _pythia8.HardProcess_hardOutgoing1_set
    __swig_getmethods__["hardOutgoing1"] = _pythia8.HardProcess_hardOutgoing1_get
    if _newclass:
        hardOutgoing1 = _swig_property(_pythia8.HardProcess_hardOutgoing1_get, _pythia8.HardProcess_hardOutgoing1_set)
    __swig_setmethods__["hardOutgoing2"] = _pythia8.HardProcess_hardOutgoing2_set
    __swig_getmethods__["hardOutgoing2"] = _pythia8.HardProcess_hardOutgoing2_get
    if _newclass:
        hardOutgoing2 = _swig_property(_pythia8.HardProcess_hardOutgoing2_get, _pythia8.HardProcess_hardOutgoing2_set)
    __swig_setmethods__["hardIntermediate"] = _pythia8.HardProcess_hardIntermediate_set
    __swig_getmethods__["hardIntermediate"] = _pythia8.HardProcess_hardIntermediate_get
    if _newclass:
        hardIntermediate = _swig_property(_pythia8.HardProcess_hardIntermediate_get, _pythia8.HardProcess_hardIntermediate_set)
    __swig_setmethods__["state"] = _pythia8.HardProcess_state_set
    __swig_getmethods__["state"] = _pythia8.HardProcess_state_get
    if _newclass:
        state = _swig_property(_pythia8.HardProcess_state_get, _pythia8.HardProcess_state_set)
    __swig_setmethods__["PosOutgoing1"] = _pythia8.HardProcess_PosOutgoing1_set
    __swig_getmethods__["PosOutgoing1"] = _pythia8.HardProcess_PosOutgoing1_get
    if _newclass:
        PosOutgoing1 = _swig_property(_pythia8.HardProcess_PosOutgoing1_get, _pythia8.HardProcess_PosOutgoing1_set)
    __swig_setmethods__["PosOutgoing2"] = _pythia8.HardProcess_PosOutgoing2_set
    __swig_getmethods__["PosOutgoing2"] = _pythia8.HardProcess_PosOutgoing2_get
    if _newclass:
        PosOutgoing2 = _swig_property(_pythia8.HardProcess_PosOutgoing2_get, _pythia8.HardProcess_PosOutgoing2_set)
    __swig_setmethods__["PosIntermediate"] = _pythia8.HardProcess_PosIntermediate_set
    __swig_getmethods__["PosIntermediate"] = _pythia8.HardProcess_PosIntermediate_get
    if _newclass:
        PosIntermediate = _swig_property(_pythia8.HardProcess_PosIntermediate_get, _pythia8.HardProcess_PosIntermediate_set)
    __swig_setmethods__["tms"] = _pythia8.HardProcess_tms_set
    __swig_getmethods__["tms"] = _pythia8.HardProcess_tms_get
    if _newclass:
        tms = _swig_property(_pythia8.HardProcess_tms_get, _pythia8.HardProcess_tms_set)
    __swig_destroy__ = _pythia8.delete_HardProcess
    __del__ = lambda self: None

    def __init__(self, *args):
        """
Constructor with path to LHE file
"""
        this = _pythia8.new_HardProcess(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initOnProcess(self, process, particleData):
        """
Constructor with core process input
"""
        return _pythia8.HardProcess_initOnProcess(self, process, particleData)

    def initOnLHEF(self, LHEfile, particleData):
        """
Constructor with path to LHE file input
"""
        return _pythia8.HardProcess_initOnLHEF(self, LHEfile, particleData)

    def translateLHEFString(self, LHEpath):
        """
Function to access the LHE file and read relevant information
"""
        return _pythia8.HardProcess_translateLHEFString(self, LHEpath)

    def translateProcessString(self, process):
        """
Function to translate the process string (in MG/ME notation)
"""
        return _pythia8.HardProcess_translateProcessString(self, process)

    def clear(self):
        """
Function to clear hard process information
"""
        return _pythia8.HardProcess_clear(self)

    def allowCandidates(self, iPos, Pos1, Pos2, event):
        """
Function to check whether the sets of candidates Pos1, Pos2, together
with the proposed candidate iPos give an allowed hard process state
"""
        return _pythia8.HardProcess_allowCandidates(self, iPos, Pos1, Pos2, event)

    def storeCandidates(self, event, process):
        """
Function to identify the hard subprocess in the current event
"""
        return _pythia8.HardProcess_storeCandidates(self, event, process)

    def matchesAnyOutgoing(self, iPos, event):
        """
Function to check if the particle event[iPos] matches any of
the stored outgoing particles of the hard subprocess
"""
        return _pythia8.HardProcess_matchesAnyOutgoing(self, iPos, event)

    def findOtherCandidates(self, iPos, event, doReplace):
        """
Function to check if instead of the particle event[iCandidate], another
particle could serve as part of the hard process. Assumes that iCandidate
is already stored as part of the hard process.
"""
        return _pythia8.HardProcess_findOtherCandidates(self, iPos, event, doReplace)

    def exchangeCandidates(self, candidates1, candidates2, further1, further2):
        """
Function to exchange a stored hard process candidate with another choice.
"""
        return _pythia8.HardProcess_exchangeCandidates(self, candidates1, candidates2, further1, further2)

    def nQuarksOut(self):
        """
Function to get the number of coloured final state partons in the
hard process
"""
        return _pythia8.HardProcess_nQuarksOut(self)

    def nLeptonOut(self):
        """
Function to get the number of uncoloured final state particles in the
hard process
"""
        return _pythia8.HardProcess_nLeptonOut(self)

    def nBosonsOut(self):
        """
Function to get the number of electroweak final state bosons in the
hard process
"""
        return _pythia8.HardProcess_nBosonsOut(self)

    def nQuarksIn(self):
        """
Function to get the number of coloured initial state partons in the
hard process
"""
        return _pythia8.HardProcess_nQuarksIn(self)

    def nLeptonIn(self):
        """
Function to get the number of uncoloured initial state particles in the
hard process
"""
        return _pythia8.HardProcess_nLeptonIn(self)

    def hasResInCurrent(self):
        """
Function to report if a resonace decay was found in the 2->2 sub-process
of the  current state
"""
        return _pythia8.HardProcess_hasResInCurrent(self)

    def nResInCurrent(self):
        """
Function to report the number of resonace decays in the 2->2 sub-process
of the  current state
"""
        return _pythia8.HardProcess_nResInCurrent(self)

    def hasResInProc(self):
        """
Function to report if a resonace decay was found in the 2->2 hard process
"""
        return _pythia8.HardProcess_hasResInProc(self)

    def listCandidates(self):
        """
Function to print the hard process candidates in the
Matrix element state (for debug)
"""
        return _pythia8.HardProcess_listCandidates(self)

    def __str__(self):
        return _pythia8.HardProcess___str__(self)
HardProcess_swigregister = _pythia8.HardProcess_swigregister
HardProcess_swigregister(HardProcess)

class MergingHooks(_object):
    """
MergingHooks is base class for user input to the merging procedure.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MergingHooks, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MergingHooks, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        if self.__class__ == MergingHooks:
            _self = None
        else:
            _self = self
        this = _pythia8.new_MergingHooks(_self, )
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_MergingHooks
    __del__ = lambda self: None

    def tmsDefinition(self, event):
        return _pythia8.MergingHooks_tmsDefinition(self, event)

    def dampenIfFailCuts(self, inEvent):
        return _pythia8.MergingHooks_dampenIfFailCuts(self, inEvent)

    def canCutOnRecState(self):
        return _pythia8.MergingHooks_canCutOnRecState(self)

    def doCutOnRecState(self, event):
        return _pythia8.MergingHooks_doCutOnRecState(self, event)

    def canVetoTrialEmission(self):
        return _pythia8.MergingHooks_canVetoTrialEmission(self)

    def doVetoTrialEmission(self, arg0, arg1):
        return _pythia8.MergingHooks_doVetoTrialEmission(self, arg0, arg1)

    def hardProcessME(self, inEvent):
        return _pythia8.MergingHooks_hardProcessME(self, inEvent)

    def init(self):
        return _pythia8.MergingHooks_init(self)

    def initPtr(self, settingsPtrIn, infoPtrIn, particleDataPtrIn, partonSystemsPtrIn):
        return _pythia8.MergingHooks_initPtr(self, settingsPtrIn, infoPtrIn, particleDataPtrIn, partonSystemsPtrIn)

    def tmsCut(self):
        return _pythia8.MergingHooks_tmsCut(self)

    def tms(self, *args):
        return _pythia8.MergingHooks_tms(self, *args)

    def dRijMS(self):
        return _pythia8.MergingHooks_dRijMS(self)

    def pTiMS(self):
        return _pythia8.MergingHooks_pTiMS(self)

    def QijMS(self):
        return _pythia8.MergingHooks_QijMS(self)

    def nMaxJets(self):
        return _pythia8.MergingHooks_nMaxJets(self)

    def nMaxJetsNLO(self):
        return _pythia8.MergingHooks_nMaxJetsNLO(self)

    def nMinJetWTA(self):
        return _pythia8.MergingHooks_nMinJetWTA(self)

    def getProcessString(self):
        return _pythia8.MergingHooks_getProcessString(self)

    def nHardOutPartons(self):
        return _pythia8.MergingHooks_nHardOutPartons(self)

    def nHardOutLeptons(self):
        return _pythia8.MergingHooks_nHardOutLeptons(self)

    def nHardOutBosons(self):
        return _pythia8.MergingHooks_nHardOutBosons(self)

    def nHardInPartons(self):
        return _pythia8.MergingHooks_nHardInPartons(self)

    def nHardInLeptons(self):
        return _pythia8.MergingHooks_nHardInLeptons(self)

    def nResInCurrent(self):
        return _pythia8.MergingHooks_nResInCurrent(self)

    def doUserMerging(self):
        return _pythia8.MergingHooks_doUserMerging(self)

    def doMGMerging(self):
        return _pythia8.MergingHooks_doMGMerging(self)

    def doKTMerging(self):
        return _pythia8.MergingHooks_doKTMerging(self)

    def doPTLundMerging(self):
        return _pythia8.MergingHooks_doPTLundMerging(self)

    def doCutBasedMerging(self):
        return _pythia8.MergingHooks_doCutBasedMerging(self)

    def doCKKWLMerging(self):
        return _pythia8.MergingHooks_doCKKWLMerging(self)

    def doUMEPSTree(self):
        return _pythia8.MergingHooks_doUMEPSTree(self)

    def doUMEPSSubt(self):
        return _pythia8.MergingHooks_doUMEPSSubt(self)

    def doUMEPSMerging(self):
        return _pythia8.MergingHooks_doUMEPSMerging(self)

    def doNL3Tree(self):
        return _pythia8.MergingHooks_doNL3Tree(self)

    def doNL3Loop(self):
        return _pythia8.MergingHooks_doNL3Loop(self)

    def doNL3Subt(self):
        return _pythia8.MergingHooks_doNL3Subt(self)

    def doNL3Merging(self):
        return _pythia8.MergingHooks_doNL3Merging(self)

    def doUNLOPSTree(self):
        return _pythia8.MergingHooks_doUNLOPSTree(self)

    def doUNLOPSLoop(self):
        return _pythia8.MergingHooks_doUNLOPSLoop(self)

    def doUNLOPSSubt(self):
        return _pythia8.MergingHooks_doUNLOPSSubt(self)

    def doUNLOPSSubtNLO(self):
        return _pythia8.MergingHooks_doUNLOPSSubtNLO(self)

    def doUNLOPSMerging(self):
        return _pythia8.MergingHooks_doUNLOPSMerging(self)

    def nRecluster(self):
        return _pythia8.MergingHooks_nRecluster(self)

    def nRequested(self):
        return _pythia8.MergingHooks_nRequested(self)

    def isFirstEmission(self, event):
        return _pythia8.MergingHooks_isFirstEmission(self, event)

    def hasEffectiveG2EW(self):
        return _pythia8.MergingHooks_hasEffectiveG2EW(self)

    def allowEffectiveVertex(self, arg2, out):
        return _pythia8.MergingHooks_allowEffectiveVertex(self, arg2, out)

    def bareEvent(self, inputEventIn, storeInputEvent):
        return _pythia8.MergingHooks_bareEvent(self, inputEventIn, storeInputEvent)

    def reattachResonanceDecays(self, process):
        return _pythia8.MergingHooks_reattachResonanceDecays(self, process)

    def isInHard(self, iPos, event):
        return _pythia8.MergingHooks_isInHard(self, iPos, event)

    def getNumberOfClusteringSteps(self, event, resetNjetMax=False):
        return _pythia8.MergingHooks_getNumberOfClusteringSteps(self, event, resetNjetMax)

    def orderHistories(self, doOrderHistoriesIn):
        return _pythia8.MergingHooks_orderHistories(self, doOrderHistoriesIn)

    def allowCutOnRecState(self, doCutOnRecStateIn):
        return _pythia8.MergingHooks_allowCutOnRecState(self, doCutOnRecStateIn)

    def doWeakClustering(self, doWeakClusteringIn):
        return _pythia8.MergingHooks_doWeakClustering(self, doWeakClusteringIn)

    def checkAgainstCut(self, particle):
        return _pythia8.MergingHooks_checkAgainstCut(self, particle)

    def rhoms(self, event, withColour):
        return _pythia8.MergingHooks_rhoms(self, event, withColour)

    def kTms(self, event):
        return _pythia8.MergingHooks_kTms(self, event)

    def cutbasedms(self, event):
        return _pythia8.MergingHooks_cutbasedms(self, event)

    def doIgnoreEmissions(self, doIgnoreIn):
        return _pythia8.MergingHooks_doIgnoreEmissions(self, doIgnoreIn)

    def canVetoEmission(self):
        return _pythia8.MergingHooks_canVetoEmission(self)

    def doVetoEmission(self, arg0):
        return _pythia8.MergingHooks_doVetoEmission(self, arg0)
    __swig_setmethods__["useShowerPluginSave"] = _pythia8.MergingHooks_useShowerPluginSave_set
    __swig_getmethods__["useShowerPluginSave"] = _pythia8.MergingHooks_useShowerPluginSave_get
    if _newclass:
        useShowerPluginSave = _swig_property(_pythia8.MergingHooks_useShowerPluginSave_get, _pythia8.MergingHooks_useShowerPluginSave_set)

    def useShowerPlugin(self):
        return _pythia8.MergingHooks_useShowerPlugin(self)

    def includeWGTinXSEC(self):
        return _pythia8.MergingHooks_includeWGTinXSEC(self)

    def nHardNow(self):
        return _pythia8.MergingHooks_nHardNow(self)

    def tmsHardNow(self):
        return _pythia8.MergingHooks_tmsHardNow(self)

    def nJetsNow(self):
        return _pythia8.MergingHooks_nJetsNow(self)

    def tmsNow(self, *args):
        return _pythia8.MergingHooks_tmsNow(self, *args)

    def setHardProcessPtr(self, hardProcIn):
        return _pythia8.MergingHooks_setHardProcessPtr(self, hardProcIn)
    __swig_setmethods__["useOwnHardProcess"] = _pythia8.MergingHooks_useOwnHardProcess_set
    __swig_getmethods__["useOwnHardProcess"] = _pythia8.MergingHooks_useOwnHardProcess_get
    if _newclass:
        useOwnHardProcess = _swig_property(_pythia8.MergingHooks_useOwnHardProcess_get, _pythia8.MergingHooks_useOwnHardProcess_set)
    __swig_setmethods__["hardProcess"] = _pythia8.MergingHooks_hardProcess_set
    __swig_getmethods__["hardProcess"] = _pythia8.MergingHooks_hardProcess_get
    if _newclass:
        hardProcess = _swig_property(_pythia8.MergingHooks_hardProcess_get, _pythia8.MergingHooks_hardProcess_set)
    __swig_setmethods__["infoPtr"] = _pythia8.MergingHooks_infoPtr_set
    __swig_getmethods__["infoPtr"] = _pythia8.MergingHooks_infoPtr_get
    if _newclass:
        infoPtr = _swig_property(_pythia8.MergingHooks_infoPtr_get, _pythia8.MergingHooks_infoPtr_set)
    __swig_setmethods__["settingsPtr"] = _pythia8.MergingHooks_settingsPtr_set
    __swig_getmethods__["settingsPtr"] = _pythia8.MergingHooks_settingsPtr_get
    if _newclass:
        settingsPtr = _swig_property(_pythia8.MergingHooks_settingsPtr_get, _pythia8.MergingHooks_settingsPtr_set)
    __swig_setmethods__["particleDataPtr"] = _pythia8.MergingHooks_particleDataPtr_set
    __swig_getmethods__["particleDataPtr"] = _pythia8.MergingHooks_particleDataPtr_get
    if _newclass:
        particleDataPtr = _swig_property(_pythia8.MergingHooks_particleDataPtr_get, _pythia8.MergingHooks_particleDataPtr_set)
    __swig_setmethods__["partonSystemsPtr"] = _pythia8.MergingHooks_partonSystemsPtr_set
    __swig_getmethods__["partonSystemsPtr"] = _pythia8.MergingHooks_partonSystemsPtr_get
    if _newclass:
        partonSystemsPtr = _swig_property(_pythia8.MergingHooks_partonSystemsPtr_get, _pythia8.MergingHooks_partonSystemsPtr_set)
    __swig_setmethods__["showers"] = _pythia8.MergingHooks_showers_set
    __swig_getmethods__["showers"] = _pythia8.MergingHooks_showers_get
    if _newclass:
        showers = _swig_property(_pythia8.MergingHooks_showers_get, _pythia8.MergingHooks_showers_set)

    def setShowerPointer(self, psIn):
        return _pythia8.MergingHooks_setShowerPointer(self, psIn)
    __swig_setmethods__["AlphaS_FSRSave"] = _pythia8.MergingHooks_AlphaS_FSRSave_set
    __swig_getmethods__["AlphaS_FSRSave"] = _pythia8.MergingHooks_AlphaS_FSRSave_get
    if _newclass:
        AlphaS_FSRSave = _swig_property(_pythia8.MergingHooks_AlphaS_FSRSave_get, _pythia8.MergingHooks_AlphaS_FSRSave_set)
    __swig_setmethods__["AlphaS_ISRSave"] = _pythia8.MergingHooks_AlphaS_ISRSave_set
    __swig_getmethods__["AlphaS_ISRSave"] = _pythia8.MergingHooks_AlphaS_ISRSave_get
    if _newclass:
        AlphaS_ISRSave = _swig_property(_pythia8.MergingHooks_AlphaS_ISRSave_get, _pythia8.MergingHooks_AlphaS_ISRSave_set)
    __swig_setmethods__["AlphaEM_FSRSave"] = _pythia8.MergingHooks_AlphaEM_FSRSave_set
    __swig_getmethods__["AlphaEM_FSRSave"] = _pythia8.MergingHooks_AlphaEM_FSRSave_get
    if _newclass:
        AlphaEM_FSRSave = _swig_property(_pythia8.MergingHooks_AlphaEM_FSRSave_get, _pythia8.MergingHooks_AlphaEM_FSRSave_set)
    __swig_setmethods__["AlphaEM_ISRSave"] = _pythia8.MergingHooks_AlphaEM_ISRSave_set
    __swig_getmethods__["AlphaEM_ISRSave"] = _pythia8.MergingHooks_AlphaEM_ISRSave_get
    if _newclass:
        AlphaEM_ISRSave = _swig_property(_pythia8.MergingHooks_AlphaEM_ISRSave_get, _pythia8.MergingHooks_AlphaEM_ISRSave_set)
    __swig_setmethods__["lheInputFile"] = _pythia8.MergingHooks_lheInputFile_set
    __swig_getmethods__["lheInputFile"] = _pythia8.MergingHooks_lheInputFile_get
    if _newclass:
        lheInputFile = _swig_property(_pythia8.MergingHooks_lheInputFile_get, _pythia8.MergingHooks_lheInputFile_set)
    __swig_setmethods__["doUserMergingSave"] = _pythia8.MergingHooks_doUserMergingSave_set
    __swig_getmethods__["doUserMergingSave"] = _pythia8.MergingHooks_doUserMergingSave_get
    if _newclass:
        doUserMergingSave = _swig_property(_pythia8.MergingHooks_doUserMergingSave_get, _pythia8.MergingHooks_doUserMergingSave_set)
    __swig_setmethods__["doMGMergingSave"] = _pythia8.MergingHooks_doMGMergingSave_set
    __swig_getmethods__["doMGMergingSave"] = _pythia8.MergingHooks_doMGMergingSave_get
    if _newclass:
        doMGMergingSave = _swig_property(_pythia8.MergingHooks_doMGMergingSave_get, _pythia8.MergingHooks_doMGMergingSave_set)
    __swig_setmethods__["doKTMergingSave"] = _pythia8.MergingHooks_doKTMergingSave_set
    __swig_getmethods__["doKTMergingSave"] = _pythia8.MergingHooks_doKTMergingSave_get
    if _newclass:
        doKTMergingSave = _swig_property(_pythia8.MergingHooks_doKTMergingSave_get, _pythia8.MergingHooks_doKTMergingSave_set)
    __swig_setmethods__["doPTLundMergingSave"] = _pythia8.MergingHooks_doPTLundMergingSave_set
    __swig_getmethods__["doPTLundMergingSave"] = _pythia8.MergingHooks_doPTLundMergingSave_get
    if _newclass:
        doPTLundMergingSave = _swig_property(_pythia8.MergingHooks_doPTLundMergingSave_get, _pythia8.MergingHooks_doPTLundMergingSave_set)
    __swig_setmethods__["doCutBasedMergingSave"] = _pythia8.MergingHooks_doCutBasedMergingSave_set
    __swig_getmethods__["doCutBasedMergingSave"] = _pythia8.MergingHooks_doCutBasedMergingSave_get
    if _newclass:
        doCutBasedMergingSave = _swig_property(_pythia8.MergingHooks_doCutBasedMergingSave_get, _pythia8.MergingHooks_doCutBasedMergingSave_set)
    __swig_setmethods__["includeMassiveSave"] = _pythia8.MergingHooks_includeMassiveSave_set
    __swig_getmethods__["includeMassiveSave"] = _pythia8.MergingHooks_includeMassiveSave_get
    if _newclass:
        includeMassiveSave = _swig_property(_pythia8.MergingHooks_includeMassiveSave_get, _pythia8.MergingHooks_includeMassiveSave_set)
    __swig_setmethods__["enforceStrongOrderingSave"] = _pythia8.MergingHooks_enforceStrongOrderingSave_set
    __swig_getmethods__["enforceStrongOrderingSave"] = _pythia8.MergingHooks_enforceStrongOrderingSave_get
    if _newclass:
        enforceStrongOrderingSave = _swig_property(_pythia8.MergingHooks_enforceStrongOrderingSave_get, _pythia8.MergingHooks_enforceStrongOrderingSave_set)
    __swig_setmethods__["orderInRapiditySave"] = _pythia8.MergingHooks_orderInRapiditySave_set
    __swig_getmethods__["orderInRapiditySave"] = _pythia8.MergingHooks_orderInRapiditySave_get
    if _newclass:
        orderInRapiditySave = _swig_property(_pythia8.MergingHooks_orderInRapiditySave_get, _pythia8.MergingHooks_orderInRapiditySave_set)
    __swig_setmethods__["pickByFullPSave"] = _pythia8.MergingHooks_pickByFullPSave_set
    __swig_getmethods__["pickByFullPSave"] = _pythia8.MergingHooks_pickByFullPSave_get
    if _newclass:
        pickByFullPSave = _swig_property(_pythia8.MergingHooks_pickByFullPSave_get, _pythia8.MergingHooks_pickByFullPSave_set)
    __swig_setmethods__["pickByPoPT2Save"] = _pythia8.MergingHooks_pickByPoPT2Save_set
    __swig_getmethods__["pickByPoPT2Save"] = _pythia8.MergingHooks_pickByPoPT2Save_get
    if _newclass:
        pickByPoPT2Save = _swig_property(_pythia8.MergingHooks_pickByPoPT2Save_get, _pythia8.MergingHooks_pickByPoPT2Save_set)
    __swig_setmethods__["includeRedundantSave"] = _pythia8.MergingHooks_includeRedundantSave_set
    __swig_getmethods__["includeRedundantSave"] = _pythia8.MergingHooks_includeRedundantSave_get
    if _newclass:
        includeRedundantSave = _swig_property(_pythia8.MergingHooks_includeRedundantSave_get, _pythia8.MergingHooks_includeRedundantSave_set)
    __swig_setmethods__["pickBySumPTSave"] = _pythia8.MergingHooks_pickBySumPTSave_set
    __swig_getmethods__["pickBySumPTSave"] = _pythia8.MergingHooks_pickBySumPTSave_get
    if _newclass:
        pickBySumPTSave = _swig_property(_pythia8.MergingHooks_pickBySumPTSave_get, _pythia8.MergingHooks_pickBySumPTSave_set)
    __swig_setmethods__["allowColourShufflingSave"] = _pythia8.MergingHooks_allowColourShufflingSave_set
    __swig_getmethods__["allowColourShufflingSave"] = _pythia8.MergingHooks_allowColourShufflingSave_get
    if _newclass:
        allowColourShufflingSave = _swig_property(_pythia8.MergingHooks_allowColourShufflingSave_get, _pythia8.MergingHooks_allowColourShufflingSave_set)
    __swig_setmethods__["resetHardQRenSave"] = _pythia8.MergingHooks_resetHardQRenSave_set
    __swig_getmethods__["resetHardQRenSave"] = _pythia8.MergingHooks_resetHardQRenSave_get
    if _newclass:
        resetHardQRenSave = _swig_property(_pythia8.MergingHooks_resetHardQRenSave_get, _pythia8.MergingHooks_resetHardQRenSave_set)
    __swig_setmethods__["resetHardQFacSave"] = _pythia8.MergingHooks_resetHardQFacSave_set
    __swig_getmethods__["resetHardQFacSave"] = _pythia8.MergingHooks_resetHardQFacSave_get
    if _newclass:
        resetHardQFacSave = _swig_property(_pythia8.MergingHooks_resetHardQFacSave_get, _pythia8.MergingHooks_resetHardQFacSave_set)
    __swig_setmethods__["unorderedScalePrescipSave"] = _pythia8.MergingHooks_unorderedScalePrescipSave_set
    __swig_getmethods__["unorderedScalePrescipSave"] = _pythia8.MergingHooks_unorderedScalePrescipSave_get
    if _newclass:
        unorderedScalePrescipSave = _swig_property(_pythia8.MergingHooks_unorderedScalePrescipSave_get, _pythia8.MergingHooks_unorderedScalePrescipSave_set)
    __swig_setmethods__["unorderedASscalePrescipSave"] = _pythia8.MergingHooks_unorderedASscalePrescipSave_set
    __swig_getmethods__["unorderedASscalePrescipSave"] = _pythia8.MergingHooks_unorderedASscalePrescipSave_get
    if _newclass:
        unorderedASscalePrescipSave = _swig_property(_pythia8.MergingHooks_unorderedASscalePrescipSave_get, _pythia8.MergingHooks_unorderedASscalePrescipSave_set)
    __swig_setmethods__["unorderedPDFscalePrescipSave"] = _pythia8.MergingHooks_unorderedPDFscalePrescipSave_set
    __swig_getmethods__["unorderedPDFscalePrescipSave"] = _pythia8.MergingHooks_unorderedPDFscalePrescipSave_get
    if _newclass:
        unorderedPDFscalePrescipSave = _swig_property(_pythia8.MergingHooks_unorderedPDFscalePrescipSave_get, _pythia8.MergingHooks_unorderedPDFscalePrescipSave_set)
    __swig_setmethods__["incompleteScalePrescipSave"] = _pythia8.MergingHooks_incompleteScalePrescipSave_set
    __swig_getmethods__["incompleteScalePrescipSave"] = _pythia8.MergingHooks_incompleteScalePrescipSave_get
    if _newclass:
        incompleteScalePrescipSave = _swig_property(_pythia8.MergingHooks_incompleteScalePrescipSave_get, _pythia8.MergingHooks_incompleteScalePrescipSave_set)
    __swig_setmethods__["ktTypeSave"] = _pythia8.MergingHooks_ktTypeSave_set
    __swig_getmethods__["ktTypeSave"] = _pythia8.MergingHooks_ktTypeSave_get
    if _newclass:
        ktTypeSave = _swig_property(_pythia8.MergingHooks_ktTypeSave_get, _pythia8.MergingHooks_ktTypeSave_set)
    __swig_setmethods__["nReclusterSave"] = _pythia8.MergingHooks_nReclusterSave_set
    __swig_getmethods__["nReclusterSave"] = _pythia8.MergingHooks_nReclusterSave_get
    if _newclass:
        nReclusterSave = _swig_property(_pythia8.MergingHooks_nReclusterSave_get, _pythia8.MergingHooks_nReclusterSave_set)
    __swig_setmethods__["nQuarksMergeSave"] = _pythia8.MergingHooks_nQuarksMergeSave_set
    __swig_getmethods__["nQuarksMergeSave"] = _pythia8.MergingHooks_nQuarksMergeSave_get
    if _newclass:
        nQuarksMergeSave = _swig_property(_pythia8.MergingHooks_nQuarksMergeSave_get, _pythia8.MergingHooks_nQuarksMergeSave_set)
    __swig_setmethods__["nRequestedSave"] = _pythia8.MergingHooks_nRequestedSave_set
    __swig_getmethods__["nRequestedSave"] = _pythia8.MergingHooks_nRequestedSave_get
    if _newclass:
        nRequestedSave = _swig_property(_pythia8.MergingHooks_nRequestedSave_get, _pythia8.MergingHooks_nRequestedSave_set)
    __swig_setmethods__["scaleSeparationFactorSave"] = _pythia8.MergingHooks_scaleSeparationFactorSave_set
    __swig_getmethods__["scaleSeparationFactorSave"] = _pythia8.MergingHooks_scaleSeparationFactorSave_get
    if _newclass:
        scaleSeparationFactorSave = _swig_property(_pythia8.MergingHooks_scaleSeparationFactorSave_get, _pythia8.MergingHooks_scaleSeparationFactorSave_set)
    __swig_setmethods__["nonJoinedNormSave"] = _pythia8.MergingHooks_nonJoinedNormSave_set
    __swig_getmethods__["nonJoinedNormSave"] = _pythia8.MergingHooks_nonJoinedNormSave_get
    if _newclass:
        nonJoinedNormSave = _swig_property(_pythia8.MergingHooks_nonJoinedNormSave_get, _pythia8.MergingHooks_nonJoinedNormSave_set)
    __swig_setmethods__["fsrInRecNormSave"] = _pythia8.MergingHooks_fsrInRecNormSave_set
    __swig_getmethods__["fsrInRecNormSave"] = _pythia8.MergingHooks_fsrInRecNormSave_get
    if _newclass:
        fsrInRecNormSave = _swig_property(_pythia8.MergingHooks_fsrInRecNormSave_get, _pythia8.MergingHooks_fsrInRecNormSave_set)
    __swig_setmethods__["herwigAcollFSRSave"] = _pythia8.MergingHooks_herwigAcollFSRSave_set
    __swig_getmethods__["herwigAcollFSRSave"] = _pythia8.MergingHooks_herwigAcollFSRSave_get
    if _newclass:
        herwigAcollFSRSave = _swig_property(_pythia8.MergingHooks_herwigAcollFSRSave_get, _pythia8.MergingHooks_herwigAcollFSRSave_set)
    __swig_setmethods__["herwigAcollISRSave"] = _pythia8.MergingHooks_herwigAcollISRSave_set
    __swig_getmethods__["herwigAcollISRSave"] = _pythia8.MergingHooks_herwigAcollISRSave_get
    if _newclass:
        herwigAcollISRSave = _swig_property(_pythia8.MergingHooks_herwigAcollISRSave_get, _pythia8.MergingHooks_herwigAcollISRSave_set)
    __swig_setmethods__["pT0ISRSave"] = _pythia8.MergingHooks_pT0ISRSave_set
    __swig_getmethods__["pT0ISRSave"] = _pythia8.MergingHooks_pT0ISRSave_get
    if _newclass:
        pT0ISRSave = _swig_property(_pythia8.MergingHooks_pT0ISRSave_get, _pythia8.MergingHooks_pT0ISRSave_set)
    __swig_setmethods__["pTcutSave"] = _pythia8.MergingHooks_pTcutSave_set
    __swig_getmethods__["pTcutSave"] = _pythia8.MergingHooks_pTcutSave_get
    if _newclass:
        pTcutSave = _swig_property(_pythia8.MergingHooks_pTcutSave_get, _pythia8.MergingHooks_pTcutSave_set)
    __swig_setmethods__["doNL3TreeSave"] = _pythia8.MergingHooks_doNL3TreeSave_set
    __swig_getmethods__["doNL3TreeSave"] = _pythia8.MergingHooks_doNL3TreeSave_get
    if _newclass:
        doNL3TreeSave = _swig_property(_pythia8.MergingHooks_doNL3TreeSave_get, _pythia8.MergingHooks_doNL3TreeSave_set)
    __swig_setmethods__["doNL3LoopSave"] = _pythia8.MergingHooks_doNL3LoopSave_set
    __swig_getmethods__["doNL3LoopSave"] = _pythia8.MergingHooks_doNL3LoopSave_get
    if _newclass:
        doNL3LoopSave = _swig_property(_pythia8.MergingHooks_doNL3LoopSave_get, _pythia8.MergingHooks_doNL3LoopSave_set)
    __swig_setmethods__["doNL3SubtSave"] = _pythia8.MergingHooks_doNL3SubtSave_set
    __swig_getmethods__["doNL3SubtSave"] = _pythia8.MergingHooks_doNL3SubtSave_get
    if _newclass:
        doNL3SubtSave = _swig_property(_pythia8.MergingHooks_doNL3SubtSave_get, _pythia8.MergingHooks_doNL3SubtSave_set)
    __swig_setmethods__["doUNLOPSTreeSave"] = _pythia8.MergingHooks_doUNLOPSTreeSave_set
    __swig_getmethods__["doUNLOPSTreeSave"] = _pythia8.MergingHooks_doUNLOPSTreeSave_get
    if _newclass:
        doUNLOPSTreeSave = _swig_property(_pythia8.MergingHooks_doUNLOPSTreeSave_get, _pythia8.MergingHooks_doUNLOPSTreeSave_set)
    __swig_setmethods__["doUNLOPSLoopSave"] = _pythia8.MergingHooks_doUNLOPSLoopSave_set
    __swig_getmethods__["doUNLOPSLoopSave"] = _pythia8.MergingHooks_doUNLOPSLoopSave_get
    if _newclass:
        doUNLOPSLoopSave = _swig_property(_pythia8.MergingHooks_doUNLOPSLoopSave_get, _pythia8.MergingHooks_doUNLOPSLoopSave_set)
    __swig_setmethods__["doUNLOPSSubtSave"] = _pythia8.MergingHooks_doUNLOPSSubtSave_set
    __swig_getmethods__["doUNLOPSSubtSave"] = _pythia8.MergingHooks_doUNLOPSSubtSave_get
    if _newclass:
        doUNLOPSSubtSave = _swig_property(_pythia8.MergingHooks_doUNLOPSSubtSave_get, _pythia8.MergingHooks_doUNLOPSSubtSave_set)
    __swig_setmethods__["doUNLOPSSubtNLOSave"] = _pythia8.MergingHooks_doUNLOPSSubtNLOSave_set
    __swig_getmethods__["doUNLOPSSubtNLOSave"] = _pythia8.MergingHooks_doUNLOPSSubtNLOSave_get
    if _newclass:
        doUNLOPSSubtNLOSave = _swig_property(_pythia8.MergingHooks_doUNLOPSSubtNLOSave_get, _pythia8.MergingHooks_doUNLOPSSubtNLOSave_set)
    __swig_setmethods__["doUMEPSTreeSave"] = _pythia8.MergingHooks_doUMEPSTreeSave_set
    __swig_getmethods__["doUMEPSTreeSave"] = _pythia8.MergingHooks_doUMEPSTreeSave_get
    if _newclass:
        doUMEPSTreeSave = _swig_property(_pythia8.MergingHooks_doUMEPSTreeSave_get, _pythia8.MergingHooks_doUMEPSTreeSave_set)
    __swig_setmethods__["doUMEPSSubtSave"] = _pythia8.MergingHooks_doUMEPSSubtSave_set
    __swig_getmethods__["doUMEPSSubtSave"] = _pythia8.MergingHooks_doUMEPSSubtSave_get
    if _newclass:
        doUMEPSSubtSave = _swig_property(_pythia8.MergingHooks_doUMEPSSubtSave_get, _pythia8.MergingHooks_doUMEPSSubtSave_set)
    __swig_setmethods__["doEstimateXSection"] = _pythia8.MergingHooks_doEstimateXSection_set
    __swig_getmethods__["doEstimateXSection"] = _pythia8.MergingHooks_doEstimateXSection_get
    if _newclass:
        doEstimateXSection = _swig_property(_pythia8.MergingHooks_doEstimateXSection_get, _pythia8.MergingHooks_doEstimateXSection_set)
    __swig_setmethods__["applyVeto"] = _pythia8.MergingHooks_applyVeto_set
    __swig_getmethods__["applyVeto"] = _pythia8.MergingHooks_applyVeto_get
    if _newclass:
        applyVeto = _swig_property(_pythia8.MergingHooks_applyVeto_get, _pythia8.MergingHooks_applyVeto_set)
    __swig_setmethods__["inputEvent"] = _pythia8.MergingHooks_inputEvent_set
    __swig_getmethods__["inputEvent"] = _pythia8.MergingHooks_inputEvent_get
    if _newclass:
        inputEvent = _swig_property(_pythia8.MergingHooks_inputEvent_get, _pythia8.MergingHooks_inputEvent_set)
    __swig_setmethods__["resonances"] = _pythia8.MergingHooks_resonances_set
    __swig_getmethods__["resonances"] = _pythia8.MergingHooks_resonances_get
    if _newclass:
        resonances = _swig_property(_pythia8.MergingHooks_resonances_get, _pythia8.MergingHooks_resonances_set)
    __swig_setmethods__["doRemoveDecayProducts"] = _pythia8.MergingHooks_doRemoveDecayProducts_set
    __swig_getmethods__["doRemoveDecayProducts"] = _pythia8.MergingHooks_doRemoveDecayProducts_get
    if _newclass:
        doRemoveDecayProducts = _swig_property(_pythia8.MergingHooks_doRemoveDecayProducts_get, _pythia8.MergingHooks_doRemoveDecayProducts_set)
    __swig_setmethods__["nInProcessNow"] = _pythia8.MergingHooks_nInProcessNow_set
    __swig_getmethods__["nInProcessNow"] = _pythia8.MergingHooks_nInProcessNow_get
    if _newclass:
        nInProcessNow = _swig_property(_pythia8.MergingHooks_nInProcessNow_get, _pythia8.MergingHooks_nInProcessNow_set)
    __swig_setmethods__["muMISave"] = _pythia8.MergingHooks_muMISave_set
    __swig_getmethods__["muMISave"] = _pythia8.MergingHooks_muMISave_get
    if _newclass:
        muMISave = _swig_property(_pythia8.MergingHooks_muMISave_get, _pythia8.MergingHooks_muMISave_set)
    __swig_setmethods__["kFactor0jSave"] = _pythia8.MergingHooks_kFactor0jSave_set
    __swig_getmethods__["kFactor0jSave"] = _pythia8.MergingHooks_kFactor0jSave_get
    if _newclass:
        kFactor0jSave = _swig_property(_pythia8.MergingHooks_kFactor0jSave_get, _pythia8.MergingHooks_kFactor0jSave_set)
    __swig_setmethods__["kFactor1jSave"] = _pythia8.MergingHooks_kFactor1jSave_set
    __swig_getmethods__["kFactor1jSave"] = _pythia8.MergingHooks_kFactor1jSave_get
    if _newclass:
        kFactor1jSave = _swig_property(_pythia8.MergingHooks_kFactor1jSave_get, _pythia8.MergingHooks_kFactor1jSave_set)
    __swig_setmethods__["kFactor2jSave"] = _pythia8.MergingHooks_kFactor2jSave_set
    __swig_getmethods__["kFactor2jSave"] = _pythia8.MergingHooks_kFactor2jSave_get
    if _newclass:
        kFactor2jSave = _swig_property(_pythia8.MergingHooks_kFactor2jSave_get, _pythia8.MergingHooks_kFactor2jSave_set)
    __swig_setmethods__["tmsValueSave"] = _pythia8.MergingHooks_tmsValueSave_set
    __swig_getmethods__["tmsValueSave"] = _pythia8.MergingHooks_tmsValueSave_get
    if _newclass:
        tmsValueSave = _swig_property(_pythia8.MergingHooks_tmsValueSave_get, _pythia8.MergingHooks_tmsValueSave_set)
    __swig_setmethods__["tmsValueNow"] = _pythia8.MergingHooks_tmsValueNow_set
    __swig_getmethods__["tmsValueNow"] = _pythia8.MergingHooks_tmsValueNow_get
    if _newclass:
        tmsValueNow = _swig_property(_pythia8.MergingHooks_tmsValueNow_get, _pythia8.MergingHooks_tmsValueNow_set)
    __swig_setmethods__["DparameterSave"] = _pythia8.MergingHooks_DparameterSave_set
    __swig_getmethods__["DparameterSave"] = _pythia8.MergingHooks_DparameterSave_get
    if _newclass:
        DparameterSave = _swig_property(_pythia8.MergingHooks_DparameterSave_get, _pythia8.MergingHooks_DparameterSave_set)
    __swig_setmethods__["nJetMaxSave"] = _pythia8.MergingHooks_nJetMaxSave_set
    __swig_getmethods__["nJetMaxSave"] = _pythia8.MergingHooks_nJetMaxSave_get
    if _newclass:
        nJetMaxSave = _swig_property(_pythia8.MergingHooks_nJetMaxSave_get, _pythia8.MergingHooks_nJetMaxSave_set)
    __swig_setmethods__["nJetMaxNLOSave"] = _pythia8.MergingHooks_nJetMaxNLOSave_set
    __swig_getmethods__["nJetMaxNLOSave"] = _pythia8.MergingHooks_nJetMaxNLOSave_get
    if _newclass:
        nJetMaxNLOSave = _swig_property(_pythia8.MergingHooks_nJetMaxNLOSave_get, _pythia8.MergingHooks_nJetMaxNLOSave_set)
    __swig_setmethods__["nJetMinWTASave"] = _pythia8.MergingHooks_nJetMinWTASave_set
    __swig_getmethods__["nJetMinWTASave"] = _pythia8.MergingHooks_nJetMinWTASave_get
    if _newclass:
        nJetMinWTASave = _swig_property(_pythia8.MergingHooks_nJetMinWTASave_get, _pythia8.MergingHooks_nJetMinWTASave_set)
    __swig_setmethods__["processSave"] = _pythia8.MergingHooks_processSave_set
    __swig_getmethods__["processSave"] = _pythia8.MergingHooks_processSave_get
    if _newclass:
        processSave = _swig_property(_pythia8.MergingHooks_processSave_get, _pythia8.MergingHooks_processSave_set)
    __swig_setmethods__["processNow"] = _pythia8.MergingHooks_processNow_set
    __swig_getmethods__["processNow"] = _pythia8.MergingHooks_processNow_get
    if _newclass:
        processNow = _swig_property(_pythia8.MergingHooks_processNow_get, _pythia8.MergingHooks_processNow_set)
    __swig_setmethods__["tmsListSave"] = _pythia8.MergingHooks_tmsListSave_set
    __swig_getmethods__["tmsListSave"] = _pythia8.MergingHooks_tmsListSave_get
    if _newclass:
        tmsListSave = _swig_property(_pythia8.MergingHooks_tmsListSave_get, _pythia8.MergingHooks_tmsListSave_set)
    __swig_setmethods__["doOrderHistoriesSave"] = _pythia8.MergingHooks_doOrderHistoriesSave_set
    __swig_getmethods__["doOrderHistoriesSave"] = _pythia8.MergingHooks_doOrderHistoriesSave_get
    if _newclass:
        doOrderHistoriesSave = _swig_property(_pythia8.MergingHooks_doOrderHistoriesSave_get, _pythia8.MergingHooks_doOrderHistoriesSave_set)
    __swig_setmethods__["doCutOnRecStateSave"] = _pythia8.MergingHooks_doCutOnRecStateSave_set
    __swig_getmethods__["doCutOnRecStateSave"] = _pythia8.MergingHooks_doCutOnRecStateSave_get
    if _newclass:
        doCutOnRecStateSave = _swig_property(_pythia8.MergingHooks_doCutOnRecStateSave_get, _pythia8.MergingHooks_doCutOnRecStateSave_set)
    __swig_setmethods__["doWeakClusteringSave"] = _pythia8.MergingHooks_doWeakClusteringSave_set
    __swig_getmethods__["doWeakClusteringSave"] = _pythia8.MergingHooks_doWeakClusteringSave_get
    if _newclass:
        doWeakClusteringSave = _swig_property(_pythia8.MergingHooks_doWeakClusteringSave_get, _pythia8.MergingHooks_doWeakClusteringSave_set)
    __swig_setmethods__["doSQCDClusteringSave"] = _pythia8.MergingHooks_doSQCDClusteringSave_set
    __swig_getmethods__["doSQCDClusteringSave"] = _pythia8.MergingHooks_doSQCDClusteringSave_get
    if _newclass:
        doSQCDClusteringSave = _swig_property(_pythia8.MergingHooks_doSQCDClusteringSave_get, _pythia8.MergingHooks_doSQCDClusteringSave_set)
    __swig_setmethods__["muFSave"] = _pythia8.MergingHooks_muFSave_set
    __swig_getmethods__["muFSave"] = _pythia8.MergingHooks_muFSave_get
    if _newclass:
        muFSave = _swig_property(_pythia8.MergingHooks_muFSave_get, _pythia8.MergingHooks_muFSave_set)
    __swig_setmethods__["muRSave"] = _pythia8.MergingHooks_muRSave_set
    __swig_getmethods__["muRSave"] = _pythia8.MergingHooks_muRSave_get
    if _newclass:
        muRSave = _swig_property(_pythia8.MergingHooks_muRSave_get, _pythia8.MergingHooks_muRSave_set)
    __swig_setmethods__["muFinMESave"] = _pythia8.MergingHooks_muFinMESave_set
    __swig_getmethods__["muFinMESave"] = _pythia8.MergingHooks_muFinMESave_get
    if _newclass:
        muFinMESave = _swig_property(_pythia8.MergingHooks_muFinMESave_get, _pythia8.MergingHooks_muFinMESave_set)
    __swig_setmethods__["muRinMESave"] = _pythia8.MergingHooks_muRinMESave_set
    __swig_getmethods__["muRinMESave"] = _pythia8.MergingHooks_muRinMESave_get
    if _newclass:
        muRinMESave = _swig_property(_pythia8.MergingHooks_muRinMESave_get, _pythia8.MergingHooks_muRinMESave_set)
    __swig_setmethods__["doIgnoreEmissionsSave"] = _pythia8.MergingHooks_doIgnoreEmissionsSave_set
    __swig_getmethods__["doIgnoreEmissionsSave"] = _pythia8.MergingHooks_doIgnoreEmissionsSave_get
    if _newclass:
        doIgnoreEmissionsSave = _swig_property(_pythia8.MergingHooks_doIgnoreEmissionsSave_get, _pythia8.MergingHooks_doIgnoreEmissionsSave_set)
    __swig_setmethods__["doIgnoreStepSave"] = _pythia8.MergingHooks_doIgnoreStepSave_set
    __swig_getmethods__["doIgnoreStepSave"] = _pythia8.MergingHooks_doIgnoreStepSave_get
    if _newclass:
        doIgnoreStepSave = _swig_property(_pythia8.MergingHooks_doIgnoreStepSave_get, _pythia8.MergingHooks_doIgnoreStepSave_set)
    __swig_setmethods__["pTsave"] = _pythia8.MergingHooks_pTsave_set
    __swig_getmethods__["pTsave"] = _pythia8.MergingHooks_pTsave_get
    if _newclass:
        pTsave = _swig_property(_pythia8.MergingHooks_pTsave_get, _pythia8.MergingHooks_pTsave_set)
    __swig_setmethods__["weightCKKWL1Save"] = _pythia8.MergingHooks_weightCKKWL1Save_set
    __swig_getmethods__["weightCKKWL1Save"] = _pythia8.MergingHooks_weightCKKWL1Save_get
    if _newclass:
        weightCKKWL1Save = _swig_property(_pythia8.MergingHooks_weightCKKWL1Save_get, _pythia8.MergingHooks_weightCKKWL1Save_set)
    __swig_setmethods__["weightCKKWL2Save"] = _pythia8.MergingHooks_weightCKKWL2Save_set
    __swig_getmethods__["weightCKKWL2Save"] = _pythia8.MergingHooks_weightCKKWL2Save_get
    if _newclass:
        weightCKKWL2Save = _swig_property(_pythia8.MergingHooks_weightCKKWL2Save_get, _pythia8.MergingHooks_weightCKKWL2Save_set)
    __swig_setmethods__["nMinMPISave"] = _pythia8.MergingHooks_nMinMPISave_set
    __swig_getmethods__["nMinMPISave"] = _pythia8.MergingHooks_nMinMPISave_get
    if _newclass:
        nMinMPISave = _swig_property(_pythia8.MergingHooks_nMinMPISave_get, _pythia8.MergingHooks_nMinMPISave_set)
    __swig_setmethods__["weightCKKWLSave"] = _pythia8.MergingHooks_weightCKKWLSave_set
    __swig_getmethods__["weightCKKWLSave"] = _pythia8.MergingHooks_weightCKKWLSave_get
    if _newclass:
        weightCKKWLSave = _swig_property(_pythia8.MergingHooks_weightCKKWLSave_get, _pythia8.MergingHooks_weightCKKWLSave_set)
    __swig_setmethods__["weightFIRSTSave"] = _pythia8.MergingHooks_weightFIRSTSave_set
    __swig_getmethods__["weightFIRSTSave"] = _pythia8.MergingHooks_weightFIRSTSave_get
    if _newclass:
        weightFIRSTSave = _swig_property(_pythia8.MergingHooks_weightFIRSTSave_get, _pythia8.MergingHooks_weightFIRSTSave_set)
    __swig_setmethods__["nJetMaxLocal"] = _pythia8.MergingHooks_nJetMaxLocal_set
    __swig_getmethods__["nJetMaxLocal"] = _pythia8.MergingHooks_nJetMaxLocal_get
    if _newclass:
        nJetMaxLocal = _swig_property(_pythia8.MergingHooks_nJetMaxLocal_get, _pythia8.MergingHooks_nJetMaxLocal_set)
    __swig_setmethods__["nJetMaxNLOLocal"] = _pythia8.MergingHooks_nJetMaxNLOLocal_set
    __swig_getmethods__["nJetMaxNLOLocal"] = _pythia8.MergingHooks_nJetMaxNLOLocal_get
    if _newclass:
        nJetMaxNLOLocal = _swig_property(_pythia8.MergingHooks_nJetMaxNLOLocal_get, _pythia8.MergingHooks_nJetMaxNLOLocal_set)
    __swig_setmethods__["hasJetMaxLocal"] = _pythia8.MergingHooks_hasJetMaxLocal_set
    __swig_getmethods__["hasJetMaxLocal"] = _pythia8.MergingHooks_hasJetMaxLocal_get
    if _newclass:
        hasJetMaxLocal = _swig_property(_pythia8.MergingHooks_hasJetMaxLocal_get, _pythia8.MergingHooks_hasJetMaxLocal_set)
    __swig_setmethods__["includeWGTinXSECSave"] = _pythia8.MergingHooks_includeWGTinXSECSave_set
    __swig_getmethods__["includeWGTinXSECSave"] = _pythia8.MergingHooks_includeWGTinXSECSave_get
    if _newclass:
        includeWGTinXSECSave = _swig_property(_pythia8.MergingHooks_includeWGTinXSECSave_get, _pythia8.MergingHooks_includeWGTinXSECSave_set)
    __swig_setmethods__["nHardNowSave"] = _pythia8.MergingHooks_nHardNowSave_set
    __swig_getmethods__["nHardNowSave"] = _pythia8.MergingHooks_nHardNowSave_get
    if _newclass:
        nHardNowSave = _swig_property(_pythia8.MergingHooks_nHardNowSave_get, _pythia8.MergingHooks_nHardNowSave_set)
    __swig_setmethods__["nJetNowSave"] = _pythia8.MergingHooks_nJetNowSave_set
    __swig_getmethods__["nJetNowSave"] = _pythia8.MergingHooks_nJetNowSave_get
    if _newclass:
        nJetNowSave = _swig_property(_pythia8.MergingHooks_nJetNowSave_get, _pythia8.MergingHooks_nJetNowSave_set)
    __swig_setmethods__["tmsHardNowSave"] = _pythia8.MergingHooks_tmsHardNowSave_set
    __swig_getmethods__["tmsHardNowSave"] = _pythia8.MergingHooks_tmsHardNowSave_get
    if _newclass:
        tmsHardNowSave = _swig_property(_pythia8.MergingHooks_tmsHardNowSave_get, _pythia8.MergingHooks_tmsHardNowSave_set)
    __swig_setmethods__["tmsNowSave"] = _pythia8.MergingHooks_tmsNowSave_set
    __swig_getmethods__["tmsNowSave"] = _pythia8.MergingHooks_tmsNowSave_get
    if _newclass:
        tmsNowSave = _swig_property(_pythia8.MergingHooks_tmsNowSave_get, _pythia8.MergingHooks_tmsNowSave_set)

    def storeHardProcessCandidates(self, event):
        return _pythia8.MergingHooks_storeHardProcessCandidates(self, event)

    def setLHEInputFile(self, lheFile):
        return _pythia8.MergingHooks_setLHEInputFile(self, lheFile)

    def AlphaS_FSR(self):
        return _pythia8.MergingHooks_AlphaS_FSR(self)

    def AlphaS_ISR(self):
        return _pythia8.MergingHooks_AlphaS_ISR(self)

    def AlphaEM_FSR(self):
        return _pythia8.MergingHooks_AlphaEM_FSR(self)

    def AlphaEM_ISR(self):
        return _pythia8.MergingHooks_AlphaEM_ISR(self)

    def includeMassive(self):
        return _pythia8.MergingHooks_includeMassive(self)

    def enforceStrongOrdering(self):
        return _pythia8.MergingHooks_enforceStrongOrdering(self)

    def orderInRapidity(self):
        return _pythia8.MergingHooks_orderInRapidity(self)

    def pickByFull(self):
        return _pythia8.MergingHooks_pickByFull(self)

    def pickByPoPT2(self):
        return _pythia8.MergingHooks_pickByPoPT2(self)

    def includeRedundant(self):
        return _pythia8.MergingHooks_includeRedundant(self)

    def pickBySumPT(self):
        return _pythia8.MergingHooks_pickBySumPT(self)

    def unorderedScalePrescip(self):
        return _pythia8.MergingHooks_unorderedScalePrescip(self)

    def unorderedASscalePrescip(self):
        return _pythia8.MergingHooks_unorderedASscalePrescip(self)

    def unorderedPDFscalePrescip(self):
        return _pythia8.MergingHooks_unorderedPDFscalePrescip(self)

    def incompleteScalePrescip(self):
        return _pythia8.MergingHooks_incompleteScalePrescip(self)

    def allowColourShuffling(self):
        return _pythia8.MergingHooks_allowColourShuffling(self)

    def resetHardQRen(self):
        return _pythia8.MergingHooks_resetHardQRen(self)

    def resetHardQFac(self):
        return _pythia8.MergingHooks_resetHardQFac(self)

    def scaleSeparationFactor(self):
        return _pythia8.MergingHooks_scaleSeparationFactor(self)

    def nonJoinedNorm(self):
        return _pythia8.MergingHooks_nonJoinedNorm(self)

    def fsrInRecNorm(self):
        return _pythia8.MergingHooks_fsrInRecNorm(self)

    def herwigAcollFSR(self):
        return _pythia8.MergingHooks_herwigAcollFSR(self)

    def herwigAcollISR(self):
        return _pythia8.MergingHooks_herwigAcollISR(self)

    def pT0ISR(self):
        return _pythia8.MergingHooks_pT0ISR(self)

    def pTcut(self):
        return _pythia8.MergingHooks_pTcut(self)

    def muMI(self, *args):
        return _pythia8.MergingHooks_muMI(self, *args)

    def kFactor(self, njet=0):
        return _pythia8.MergingHooks_kFactor(self, njet)

    def k1Factor(self, njet=0):
        return _pythia8.MergingHooks_k1Factor(self, njet)

    def getOrderHistories(self):
        return _pythia8.MergingHooks_getOrderHistories(self)

    def getAllowCutOnRecState(self):
        return _pythia8.MergingHooks_getAllowCutOnRecState(self)

    def getDoWeakClustering(self):
        return _pythia8.MergingHooks_getDoWeakClustering(self)

    def doSQCDClustering(self):
        return _pythia8.MergingHooks_doSQCDClustering(self)

    def muF(self):
        return _pythia8.MergingHooks_muF(self)

    def muR(self):
        return _pythia8.MergingHooks_muR(self)

    def muFinME(self):
        return _pythia8.MergingHooks_muFinME(self)

    def muRinME(self):
        return _pythia8.MergingHooks_muRinME(self)

    def doIgnoreStep(self, doIgnoreIn):
        return _pythia8.MergingHooks_doIgnoreStep(self, doIgnoreIn)

    def canVetoStep(self):
        return _pythia8.MergingHooks_canVetoStep(self)

    def storeWeights(self, weight):
        return _pythia8.MergingHooks_storeWeights(self, weight)

    def doVetoStep(self, process, event, doResonance=False):
        return _pythia8.MergingHooks_doVetoStep(self, process, event, doResonance)

    def setShowerStartingScales(self, isTrial, doMergeFirstEmm, pTscaleIn, event, pTmaxFSRIn, limitPTmaxFSRin, pTmaxISRIn, limitPTmaxISRin, pTmaxMPIIn, limitPTmaxMPIin):
        return _pythia8.MergingHooks_setShowerStartingScales(self, isTrial, doMergeFirstEmm, pTscaleIn, event, pTmaxFSRIn, limitPTmaxFSRin, pTmaxISRIn, limitPTmaxISRin, pTmaxMPIIn, limitPTmaxMPIin)
    __swig_setmethods__["stopScaleSave"] = _pythia8.MergingHooks_stopScaleSave_set
    __swig_getmethods__["stopScaleSave"] = _pythia8.MergingHooks_stopScaleSave_get
    if _newclass:
        stopScaleSave = _swig_property(_pythia8.MergingHooks_stopScaleSave_get, _pythia8.MergingHooks_stopScaleSave_set)

    def setShowerStoppingScale(self, scale=0.):
        return _pythia8.MergingHooks_setShowerStoppingScale(self, scale)

    def getShowerStoppingScale(self):
        return _pythia8.MergingHooks_getShowerStoppingScale(self)

    def nMinMPI(self, *args):
        return _pythia8.MergingHooks_nMinMPI(self, *args)

    def kTdurham(self, RadAfterBranch, EmtAfterBranch, Type, D):
        return _pythia8.MergingHooks_kTdurham(self, RadAfterBranch, EmtAfterBranch, Type, D)

    def rhoPythia(self, event, rad, emt, rec, ShowerType):
        return _pythia8.MergingHooks_rhoPythia(self, event, rad, emt, rec, ShowerType)

    def findColour(self, col, iExclude1, iExclude2, event, type, isHardIn):
        return _pythia8.MergingHooks_findColour(self, col, iExclude1, iExclude2, event, type, isHardIn)

    def deltaRij(self, jet1, jet2):
        return _pythia8.MergingHooks_deltaRij(self, jet1, jet2)

    def getWeightNLO(self):
        return _pythia8.MergingHooks_getWeightNLO(self)

    def getWeightCKKWL(self):
        return _pythia8.MergingHooks_getWeightCKKWL(self)

    def getWeightFIRST(self):
        return _pythia8.MergingHooks_getWeightFIRST(self)

    def setWeightCKKWL(self, weightIn):
        return _pythia8.MergingHooks_setWeightCKKWL(self, weightIn)

    def setWeightFIRST(self, weightIn):
        return _pythia8.MergingHooks_setWeightFIRST(self, weightIn)

    def setEventVetoInfo(self, nJetNowIn, tmsNowIn):
        return _pythia8.MergingHooks_setEventVetoInfo(self, nJetNowIn, tmsNowIn)

    def setHardProcessInfo(self, nHardNowIn, tmsHardNowIn):
        return _pythia8.MergingHooks_setHardProcessInfo(self, nHardNowIn, tmsHardNowIn)
    def __disown__(self):
        self.this.disown()
        _pythia8.disown_MergingHooks(self)
        return weakref_proxy(self)
MergingHooks_swigregister = _pythia8.MergingHooks_swigregister
MergingHooks_swigregister(MergingHooks)

class InBeam(_object):
    """
InBeam is a simple helper class for partons and their flux in a beam.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, InBeam, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, InBeam, name)
    __repr__ = _swig_repr

    def __init__(self, idIn=0):
        """
Constructor.
"""
        this = _pythia8.new_InBeam(idIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["id"] = _pythia8.InBeam_id_set
    __swig_getmethods__["id"] = _pythia8.InBeam_id_get
    if _newclass:
        id = _swig_property(_pythia8.InBeam_id_get, _pythia8.InBeam_id_set)
    __swig_setmethods__["pdf"] = _pythia8.InBeam_pdf_set
    __swig_getmethods__["pdf"] = _pythia8.InBeam_pdf_get
    if _newclass:
        pdf = _swig_property(_pythia8.InBeam_pdf_get, _pythia8.InBeam_pdf_set)
    __swig_destroy__ = _pythia8.delete_InBeam
    __del__ = lambda self: None
InBeam_swigregister = _pythia8.InBeam_swigregister
InBeam_swigregister(InBeam)

class InPair(_object):
    """
InPair is a simple helper class for colliding parton pairs and their flux.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, InPair, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, InPair, name)
    __repr__ = _swig_repr

    def __init__(self, idAIn=0, idBIn=0):
        """
Constructor.
"""
        this = _pythia8.new_InPair(idAIn, idBIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["idA"] = _pythia8.InPair_idA_set
    __swig_getmethods__["idA"] = _pythia8.InPair_idA_get
    if _newclass:
        idA = _swig_property(_pythia8.InPair_idA_get, _pythia8.InPair_idA_set)
    __swig_setmethods__["idB"] = _pythia8.InPair_idB_set
    __swig_getmethods__["idB"] = _pythia8.InPair_idB_get
    if _newclass:
        idB = _swig_property(_pythia8.InPair_idB_get, _pythia8.InPair_idB_set)
    __swig_setmethods__["pdfA"] = _pythia8.InPair_pdfA_set
    __swig_getmethods__["pdfA"] = _pythia8.InPair_pdfA_get
    if _newclass:
        pdfA = _swig_property(_pythia8.InPair_pdfA_get, _pythia8.InPair_pdfA_set)
    __swig_setmethods__["pdfB"] = _pythia8.InPair_pdfB_set
    __swig_getmethods__["pdfB"] = _pythia8.InPair_pdfB_get
    if _newclass:
        pdfB = _swig_property(_pythia8.InPair_pdfB_get, _pythia8.InPair_pdfB_set)
    __swig_setmethods__["pdfSigma"] = _pythia8.InPair_pdfSigma_set
    __swig_getmethods__["pdfSigma"] = _pythia8.InPair_pdfSigma_get
    if _newclass:
        pdfSigma = _swig_property(_pythia8.InPair_pdfSigma_get, _pythia8.InPair_pdfSigma_set)
    __swig_destroy__ = _pythia8.delete_InPair
    __del__ = lambda self: None
InPair_swigregister = _pythia8.InPair_swigregister
InPair_swigregister(InPair)

class SigmaProcess(_object):
    """
SigmaProcess is the base class for cross section calculations.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SigmaProcess, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SigmaProcess, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _pythia8.delete_SigmaProcess
    __del__ = lambda self: None

    def init(self, infoPtrIn, settingsPtrIn, particleDataPtrIn, rndmPtrIn, beamAPtrIn, beamBPtrIn, couplings, sigmaTotPtrIn=None, slhaInterfacePtrIn=None):
        """
Perform simple initialization and store pointers.
"""
        return _pythia8.SigmaProcess_init(self, infoPtrIn, settingsPtrIn, particleDataPtrIn, rndmPtrIn, beamAPtrIn, beamBPtrIn, couplings, sigmaTotPtrIn, slhaInterfacePtrIn)

    def setLHAPtr(self, lhaUpPtrIn):
        """
Store or replace Les Houches pointer.
"""
        return _pythia8.SigmaProcess_setLHAPtr(self, lhaUpPtrIn)

    def initProc(self):
        """
Initialize process. Only used for some processes.
"""
        return _pythia8.SigmaProcess_initProc(self)

    def initFlux(self):
        """
Set up allowed flux of incoming partons. Default is no flux.
"""
        return _pythia8.SigmaProcess_initFlux(self)

    def set1Kin(self, arg0, arg1, arg2):
        """
Input and complement kinematics for resolved 2 -> 1 process.
Usage: set1Kin( x1in, x2in, sHin).
"""
        return _pythia8.SigmaProcess_set1Kin(self, arg0, arg1, arg2)

    def set2Kin(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7):
        """
Input and complement kinematics for resolved 2 -> 2 process.
Usage: set2Kin( x1in, x2in, sHin, tHin, m3in, m4in, runBW3in, runBW4in).
"""
        return _pythia8.SigmaProcess_set2Kin(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7)

    def set2KinMPI(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9):
        """
Ditto, but for Multiparton Interactions applications, so different input.
Usage: set2KinMPI( x1in, x2in, sHin, tHin, uHin,
                  alpSin, alpEMin, needMasses, m3in, m4in)
"""
        return _pythia8.SigmaProcess_set2KinMPI(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9)

    def set3Kin(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11):
        """
Input and complement kinematics for resolved 2 -> 3 process.
Usage: set3Kin( x1in, x2in, sHin, p3prel, p4prel, p5prel,
                m3in, m4in, m5in, runBW3in, runBW4in, runBW5in);
"""
        return _pythia8.SigmaProcess_set3Kin(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.SigmaProcess_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigma for unresolved, sigmaHat(sHat) for 2 -> 1 processes,
d(sigmaHat)/d(tHat) for (resolved) 2 -> 2 processes, and |M|^2 for
2 -> 3 processes. Answer in "native" units, either mb or GeV^-2.
"""
        return _pythia8.SigmaProcess_sigmaHat(self)

    def sigmaHatWrap(self, id1in=0, id2in=0):
        """
Wrapper to sigmaHat, to (a) store current incoming flavours and
(b) convert from GeV^-2 to mb where required.
For 2 -> 1/2 also (c) convert from from |M|^2 to d(sigmaHat)/d(tHat).
"""
        return _pythia8.SigmaProcess_sigmaHatWrap(self, id1in, id2in)

    def sigmaPDF(self, initPS=False, samexGamma=False, useNewXvalues=False, x1New=0., x2New=0.):
        """
Convolute above with parton flux and K factor. Sum over open channels.
Possibly different PDF in initialization phase or no sampling for x_gamma
(photons in leptons).
"""
        return _pythia8.SigmaProcess_sigmaPDF(self, initPS, samexGamma, useNewXvalues, x1New, x2New)

    def pickInState(self, id1in=0, id2in=0):
        """
Select incoming parton channel and extract parton densities (resolved).
"""
        return _pythia8.SigmaProcess_pickInState(self, id1in, id2in)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.SigmaProcess_setIdColAcol(self)

    def final2KinMPI(self, arg0=0, arg1=0, arg2=0., arg3=0., arg4=0., arg5=0.):
        """
Perform kinematics for a Multiparton Interaction, in its rest frame.
"""
        return _pythia8.SigmaProcess_final2KinMPI(self, arg0, arg1, arg2, arg3, arg4, arg5)

    def weightDecayFlav(self, arg0):
        """
Evaluate weight for simultaneous flavours (only gamma*/Z0 gamma*/Z0).
Usage: weightDecayFlav( process).
"""
        return _pythia8.SigmaProcess_weightDecayFlav(self, arg0)

    def weightDecay(self, arg0, arg1, arg2):
        """
Evaluate weight for decay angular configuration.
Usage: weightDecay( process, iResBeg, iResEnd), where
iResBeg <= i < iResEnd is range of sister partons to test decays of.
"""
        return _pythia8.SigmaProcess_weightDecay(self, arg0, arg1, arg2)

    def setScale(self):
        """
Set scale, when that is missing for an external LHA process.
"""
        return _pythia8.SigmaProcess_setScale(self)

    def name(self):
        """
Process name and code, and the number of final-state particles.
"""
        return _pythia8.SigmaProcess_name(self)

    def code(self):
        """
"""
        return _pythia8.SigmaProcess_code(self)

    def nFinal(self):
        """
"""
        return _pythia8.SigmaProcess_nFinal(self)

    def inFlux(self):
        """
Need to know which incoming partons to set up interaction for.
"""
        return _pythia8.SigmaProcess_inFlux(self)

    def convert2mb(self):
        """
Need to know whether to convert cross section answer from GeV^-2 to mb.
"""
        return _pythia8.SigmaProcess_convert2mb(self)

    def convertM2(self):
        """
For 2 -> 2 process optional conversion from |M|^2 to d(sigmaHat)/d(tHat).
"""
        return _pythia8.SigmaProcess_convertM2(self)

    def isLHA(self):
        """
Special treatment needed for Les Houches processes.
"""
        return _pythia8.SigmaProcess_isLHA(self)

    def isNonDiff(self):
        """
Special treatment needed for elastic and diffractive processes.
"""
        return _pythia8.SigmaProcess_isNonDiff(self)

    def isResolved(self):
        """
"""
        return _pythia8.SigmaProcess_isResolved(self)

    def isDiffA(self):
        """
"""
        return _pythia8.SigmaProcess_isDiffA(self)

    def isDiffB(self):
        """
"""
        return _pythia8.SigmaProcess_isDiffB(self)

    def isDiffC(self):
        """
"""
        return _pythia8.SigmaProcess_isDiffC(self)

    def isSUSY(self):
        """
Special treatment needed for SUSY processes.
"""
        return _pythia8.SigmaProcess_isSUSY(self)

    def allowNegativeSigma(self):
        """
Special treatment needed if negative cross sections allowed.
"""
        return _pythia8.SigmaProcess_allowNegativeSigma(self)

    def id3Mass(self):
        """
Flavours in 2 -> 2/3 processes where masses needed from beginning.
(For a light quark masses will be used in the final kinematics,
but not at the matrix-element level. For a gluon no masses at all.)
"""
        return _pythia8.SigmaProcess_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.SigmaProcess_id4Mass(self)

    def id5Mass(self):
        """
"""
        return _pythia8.SigmaProcess_id5Mass(self)

    def resonanceA(self):
        """
Special treatment needed if process contains an s-channel resonance.
"""
        return _pythia8.SigmaProcess_resonanceA(self)

    def resonanceB(self):
        """
"""
        return _pythia8.SigmaProcess_resonanceB(self)

    def isSChannel(self):
        """
2 -> 2 and 2 -> 3 processes only through s-channel exchange.
"""
        return _pythia8.SigmaProcess_isSChannel(self)

    def idSChannel(self):
        """
NOAM: Insert an intermediate resonance in 2 -> 1 -> 2 (or 3) listings.
"""
        return _pythia8.SigmaProcess_idSChannel(self)

    def isQCD3body(self):
        """
QCD 2 -> 3 processes need special phase space selection machinery.
"""
        return _pythia8.SigmaProcess_isQCD3body(self)

    def idTchan1(self):
        """
Special treatment in 2 -> 3 with two massive propagators.
"""
        return _pythia8.SigmaProcess_idTchan1(self)

    def idTchan2(self):
        """
"""
        return _pythia8.SigmaProcess_idTchan2(self)

    def tChanFracPow1(self):
        """
"""
        return _pythia8.SigmaProcess_tChanFracPow1(self)

    def tChanFracPow2(self):
        """
"""
        return _pythia8.SigmaProcess_tChanFracPow2(self)

    def useMirrorWeight(self):
        """
"""
        return _pythia8.SigmaProcess_useMirrorWeight(self)

    def gmZmode(self):
        """
Special process-specific gamma*/Z0 choice if >=0 (e.g. f fbar -> H0 Z0).
"""
        return _pythia8.SigmaProcess_gmZmode(self)

    def swappedTU(self):
        """
Tell whether tHat and uHat are swapped (= same as swap 3 and 4).
"""
        return _pythia8.SigmaProcess_swappedTU(self)

    def id(self, i):
        """
Give back particle properties: flavours, colours, masses, or all.
"""
        return _pythia8.SigmaProcess_id(self, i)

    def col(self, i):
        """
"""
        return _pythia8.SigmaProcess_col(self, i)

    def acol(self, i):
        """
"""
        return _pythia8.SigmaProcess_acol(self, i)

    def m(self, i):
        """
"""
        return _pythia8.SigmaProcess_m(self, i)

    def getParton(self, i):
        """
"""
        return _pythia8.SigmaProcess_getParton(self, i)

    def Q2Ren(self):
        """
Give back couplings and parton densities.
Not all known for nondiffractive.
"""
        return _pythia8.SigmaProcess_Q2Ren(self)

    def alphaEMRen(self):
        """
"""
        return _pythia8.SigmaProcess_alphaEMRen(self)

    def alphaSRen(self):
        """
"""
        return _pythia8.SigmaProcess_alphaSRen(self)

    def Q2Fac(self):
        """
"""
        return _pythia8.SigmaProcess_Q2Fac(self)

    def pdf1(self):
        """
"""
        return _pythia8.SigmaProcess_pdf1(self)

    def pdf2(self):
        """
"""
        return _pythia8.SigmaProcess_pdf2(self)

    def thetaMPI(self):
        """
Give back angles; relevant only for multipe-interactions processes.
"""
        return _pythia8.SigmaProcess_thetaMPI(self)

    def phiMPI(self):
        """
"""
        return _pythia8.SigmaProcess_phiMPI(self)

    def sHBetaMPI(self):
        """
"""
        return _pythia8.SigmaProcess_sHBetaMPI(self)

    def pT2MPI(self):
        """
"""
        return _pythia8.SigmaProcess_pT2MPI(self)

    def pTMPIFin(self):
        """
"""
        return _pythia8.SigmaProcess_pTMPIFin(self)

    def saveKin(self):
        """
Save and load kinematics for trial interactions
"""
        return _pythia8.SigmaProcess_saveKin(self)

    def loadKin(self):
        """
"""
        return _pythia8.SigmaProcess_loadKin(self)

    def swapKin(self):
        """
"""
        return _pythia8.SigmaProcess_swapKin(self)

    def setIdInDiff(self, arg0, arg1):
        """
Set the incoming ids for diffraction.
"""
        return _pythia8.SigmaProcess_setIdInDiff(self, arg0, arg1)

    def __init__(self):
        """
Constructor.
"""
        if self.__class__ == SigmaProcess:
            _self = None
        else:
            _self = self
        this = _pythia8.new_SigmaProcess(_self, )
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["infoPtr"] = _pythia8.SigmaProcess_infoPtr_set
    __swig_getmethods__["infoPtr"] = _pythia8.SigmaProcess_infoPtr_get
    if _newclass:
        infoPtr = _swig_property(_pythia8.SigmaProcess_infoPtr_get, _pythia8.SigmaProcess_infoPtr_set)
    __swig_setmethods__["settingsPtr"] = _pythia8.SigmaProcess_settingsPtr_set
    __swig_getmethods__["settingsPtr"] = _pythia8.SigmaProcess_settingsPtr_get
    if _newclass:
        settingsPtr = _swig_property(_pythia8.SigmaProcess_settingsPtr_get, _pythia8.SigmaProcess_settingsPtr_set)
    __swig_setmethods__["particleDataPtr"] = _pythia8.SigmaProcess_particleDataPtr_set
    __swig_getmethods__["particleDataPtr"] = _pythia8.SigmaProcess_particleDataPtr_get
    if _newclass:
        particleDataPtr = _swig_property(_pythia8.SigmaProcess_particleDataPtr_get, _pythia8.SigmaProcess_particleDataPtr_set)
    __swig_setmethods__["rndmPtr"] = _pythia8.SigmaProcess_rndmPtr_set
    __swig_getmethods__["rndmPtr"] = _pythia8.SigmaProcess_rndmPtr_get
    if _newclass:
        rndmPtr = _swig_property(_pythia8.SigmaProcess_rndmPtr_get, _pythia8.SigmaProcess_rndmPtr_set)
    __swig_setmethods__["beamAPtr"] = _pythia8.SigmaProcess_beamAPtr_set
    __swig_getmethods__["beamAPtr"] = _pythia8.SigmaProcess_beamAPtr_get
    if _newclass:
        beamAPtr = _swig_property(_pythia8.SigmaProcess_beamAPtr_get, _pythia8.SigmaProcess_beamAPtr_set)
    __swig_setmethods__["beamBPtr"] = _pythia8.SigmaProcess_beamBPtr_set
    __swig_getmethods__["beamBPtr"] = _pythia8.SigmaProcess_beamBPtr_get
    if _newclass:
        beamBPtr = _swig_property(_pythia8.SigmaProcess_beamBPtr_get, _pythia8.SigmaProcess_beamBPtr_set)
    __swig_setmethods__["couplingsPtr"] = _pythia8.SigmaProcess_couplingsPtr_set
    __swig_getmethods__["couplingsPtr"] = _pythia8.SigmaProcess_couplingsPtr_get
    if _newclass:
        couplingsPtr = _swig_property(_pythia8.SigmaProcess_couplingsPtr_get, _pythia8.SigmaProcess_couplingsPtr_set)
    __swig_setmethods__["sigmaTotPtr"] = _pythia8.SigmaProcess_sigmaTotPtr_set
    __swig_getmethods__["sigmaTotPtr"] = _pythia8.SigmaProcess_sigmaTotPtr_get
    if _newclass:
        sigmaTotPtr = _swig_property(_pythia8.SigmaProcess_sigmaTotPtr_get, _pythia8.SigmaProcess_sigmaTotPtr_set)
    __swig_setmethods__["slhaPtr"] = _pythia8.SigmaProcess_slhaPtr_set
    __swig_getmethods__["slhaPtr"] = _pythia8.SigmaProcess_slhaPtr_get
    if _newclass:
        slhaPtr = _swig_property(_pythia8.SigmaProcess_slhaPtr_get, _pythia8.SigmaProcess_slhaPtr_set)
    __swig_setmethods__["lhaUpPtr"] = _pythia8.SigmaProcess_lhaUpPtr_set
    __swig_getmethods__["lhaUpPtr"] = _pythia8.SigmaProcess_lhaUpPtr_get
    if _newclass:
        lhaUpPtr = _swig_property(_pythia8.SigmaProcess_lhaUpPtr_get, _pythia8.SigmaProcess_lhaUpPtr_set)
    __swig_setmethods__["nQuarkIn"] = _pythia8.SigmaProcess_nQuarkIn_set
    __swig_getmethods__["nQuarkIn"] = _pythia8.SigmaProcess_nQuarkIn_get
    if _newclass:
        nQuarkIn = _swig_property(_pythia8.SigmaProcess_nQuarkIn_get, _pythia8.SigmaProcess_nQuarkIn_set)
    __swig_setmethods__["renormScale1"] = _pythia8.SigmaProcess_renormScale1_set
    __swig_getmethods__["renormScale1"] = _pythia8.SigmaProcess_renormScale1_get
    if _newclass:
        renormScale1 = _swig_property(_pythia8.SigmaProcess_renormScale1_get, _pythia8.SigmaProcess_renormScale1_set)
    __swig_setmethods__["renormScale2"] = _pythia8.SigmaProcess_renormScale2_set
    __swig_getmethods__["renormScale2"] = _pythia8.SigmaProcess_renormScale2_get
    if _newclass:
        renormScale2 = _swig_property(_pythia8.SigmaProcess_renormScale2_get, _pythia8.SigmaProcess_renormScale2_set)
    __swig_setmethods__["renormScale3"] = _pythia8.SigmaProcess_renormScale3_set
    __swig_getmethods__["renormScale3"] = _pythia8.SigmaProcess_renormScale3_get
    if _newclass:
        renormScale3 = _swig_property(_pythia8.SigmaProcess_renormScale3_get, _pythia8.SigmaProcess_renormScale3_set)
    __swig_setmethods__["renormScale3VV"] = _pythia8.SigmaProcess_renormScale3VV_set
    __swig_getmethods__["renormScale3VV"] = _pythia8.SigmaProcess_renormScale3VV_get
    if _newclass:
        renormScale3VV = _swig_property(_pythia8.SigmaProcess_renormScale3VV_get, _pythia8.SigmaProcess_renormScale3VV_set)
    __swig_setmethods__["factorScale1"] = _pythia8.SigmaProcess_factorScale1_set
    __swig_getmethods__["factorScale1"] = _pythia8.SigmaProcess_factorScale1_get
    if _newclass:
        factorScale1 = _swig_property(_pythia8.SigmaProcess_factorScale1_get, _pythia8.SigmaProcess_factorScale1_set)
    __swig_setmethods__["factorScale2"] = _pythia8.SigmaProcess_factorScale2_set
    __swig_getmethods__["factorScale2"] = _pythia8.SigmaProcess_factorScale2_get
    if _newclass:
        factorScale2 = _swig_property(_pythia8.SigmaProcess_factorScale2_get, _pythia8.SigmaProcess_factorScale2_set)
    __swig_setmethods__["factorScale3"] = _pythia8.SigmaProcess_factorScale3_set
    __swig_getmethods__["factorScale3"] = _pythia8.SigmaProcess_factorScale3_get
    if _newclass:
        factorScale3 = _swig_property(_pythia8.SigmaProcess_factorScale3_get, _pythia8.SigmaProcess_factorScale3_set)
    __swig_setmethods__["factorScale3VV"] = _pythia8.SigmaProcess_factorScale3VV_set
    __swig_getmethods__["factorScale3VV"] = _pythia8.SigmaProcess_factorScale3VV_get
    if _newclass:
        factorScale3VV = _swig_property(_pythia8.SigmaProcess_factorScale3VV_get, _pythia8.SigmaProcess_factorScale3VV_set)
    __swig_setmethods__["Kfactor"] = _pythia8.SigmaProcess_Kfactor_set
    __swig_getmethods__["Kfactor"] = _pythia8.SigmaProcess_Kfactor_get
    if _newclass:
        Kfactor = _swig_property(_pythia8.SigmaProcess_Kfactor_get, _pythia8.SigmaProcess_Kfactor_set)
    __swig_setmethods__["mcME"] = _pythia8.SigmaProcess_mcME_set
    __swig_getmethods__["mcME"] = _pythia8.SigmaProcess_mcME_get
    if _newclass:
        mcME = _swig_property(_pythia8.SigmaProcess_mcME_get, _pythia8.SigmaProcess_mcME_set)
    __swig_setmethods__["mbME"] = _pythia8.SigmaProcess_mbME_set
    __swig_getmethods__["mbME"] = _pythia8.SigmaProcess_mbME_get
    if _newclass:
        mbME = _swig_property(_pythia8.SigmaProcess_mbME_get, _pythia8.SigmaProcess_mbME_set)
    __swig_setmethods__["mmuME"] = _pythia8.SigmaProcess_mmuME_set
    __swig_getmethods__["mmuME"] = _pythia8.SigmaProcess_mmuME_get
    if _newclass:
        mmuME = _swig_property(_pythia8.SigmaProcess_mmuME_get, _pythia8.SigmaProcess_mmuME_set)
    __swig_setmethods__["mtauME"] = _pythia8.SigmaProcess_mtauME_set
    __swig_getmethods__["mtauME"] = _pythia8.SigmaProcess_mtauME_get
    if _newclass:
        mtauME = _swig_property(_pythia8.SigmaProcess_mtauME_get, _pythia8.SigmaProcess_mtauME_set)
    __swig_setmethods__["renormMultFac"] = _pythia8.SigmaProcess_renormMultFac_set
    __swig_getmethods__["renormMultFac"] = _pythia8.SigmaProcess_renormMultFac_get
    if _newclass:
        renormMultFac = _swig_property(_pythia8.SigmaProcess_renormMultFac_get, _pythia8.SigmaProcess_renormMultFac_set)
    __swig_setmethods__["renormFixScale"] = _pythia8.SigmaProcess_renormFixScale_set
    __swig_getmethods__["renormFixScale"] = _pythia8.SigmaProcess_renormFixScale_get
    if _newclass:
        renormFixScale = _swig_property(_pythia8.SigmaProcess_renormFixScale_get, _pythia8.SigmaProcess_renormFixScale_set)
    __swig_setmethods__["factorMultFac"] = _pythia8.SigmaProcess_factorMultFac_set
    __swig_getmethods__["factorMultFac"] = _pythia8.SigmaProcess_factorMultFac_get
    if _newclass:
        factorMultFac = _swig_property(_pythia8.SigmaProcess_factorMultFac_get, _pythia8.SigmaProcess_factorMultFac_set)
    __swig_setmethods__["factorFixScale"] = _pythia8.SigmaProcess_factorFixScale_set
    __swig_getmethods__["factorFixScale"] = _pythia8.SigmaProcess_factorFixScale_get
    if _newclass:
        factorFixScale = _swig_property(_pythia8.SigmaProcess_factorFixScale_get, _pythia8.SigmaProcess_factorFixScale_set)
    __swig_setmethods__["higgsH1parity"] = _pythia8.SigmaProcess_higgsH1parity_set
    __swig_getmethods__["higgsH1parity"] = _pythia8.SigmaProcess_higgsH1parity_get
    if _newclass:
        higgsH1parity = _swig_property(_pythia8.SigmaProcess_higgsH1parity_get, _pythia8.SigmaProcess_higgsH1parity_set)
    __swig_setmethods__["higgsH2parity"] = _pythia8.SigmaProcess_higgsH2parity_set
    __swig_getmethods__["higgsH2parity"] = _pythia8.SigmaProcess_higgsH2parity_get
    if _newclass:
        higgsH2parity = _swig_property(_pythia8.SigmaProcess_higgsH2parity_get, _pythia8.SigmaProcess_higgsH2parity_set)
    __swig_setmethods__["higgsA3parity"] = _pythia8.SigmaProcess_higgsA3parity_set
    __swig_getmethods__["higgsA3parity"] = _pythia8.SigmaProcess_higgsA3parity_get
    if _newclass:
        higgsA3parity = _swig_property(_pythia8.SigmaProcess_higgsA3parity_get, _pythia8.SigmaProcess_higgsA3parity_set)
    __swig_setmethods__["higgsH1eta"] = _pythia8.SigmaProcess_higgsH1eta_set
    __swig_getmethods__["higgsH1eta"] = _pythia8.SigmaProcess_higgsH1eta_get
    if _newclass:
        higgsH1eta = _swig_property(_pythia8.SigmaProcess_higgsH1eta_get, _pythia8.SigmaProcess_higgsH1eta_set)
    __swig_setmethods__["higgsH2eta"] = _pythia8.SigmaProcess_higgsH2eta_set
    __swig_getmethods__["higgsH2eta"] = _pythia8.SigmaProcess_higgsH2eta_get
    if _newclass:
        higgsH2eta = _swig_property(_pythia8.SigmaProcess_higgsH2eta_get, _pythia8.SigmaProcess_higgsH2eta_set)
    __swig_setmethods__["higgsA3eta"] = _pythia8.SigmaProcess_higgsA3eta_set
    __swig_getmethods__["higgsA3eta"] = _pythia8.SigmaProcess_higgsA3eta_get
    if _newclass:
        higgsA3eta = _swig_property(_pythia8.SigmaProcess_higgsA3eta_get, _pythia8.SigmaProcess_higgsA3eta_set)
    __swig_setmethods__["higgsH1phi"] = _pythia8.SigmaProcess_higgsH1phi_set
    __swig_getmethods__["higgsH1phi"] = _pythia8.SigmaProcess_higgsH1phi_get
    if _newclass:
        higgsH1phi = _swig_property(_pythia8.SigmaProcess_higgsH1phi_get, _pythia8.SigmaProcess_higgsH1phi_set)
    __swig_setmethods__["higgsH2phi"] = _pythia8.SigmaProcess_higgsH2phi_set
    __swig_getmethods__["higgsH2phi"] = _pythia8.SigmaProcess_higgsH2phi_get
    if _newclass:
        higgsH2phi = _swig_property(_pythia8.SigmaProcess_higgsH2phi_get, _pythia8.SigmaProcess_higgsH2phi_set)
    __swig_setmethods__["higgsA3phi"] = _pythia8.SigmaProcess_higgsA3phi_set
    __swig_getmethods__["higgsA3phi"] = _pythia8.SigmaProcess_higgsA3phi_get
    if _newclass:
        higgsA3phi = _swig_property(_pythia8.SigmaProcess_higgsA3phi_get, _pythia8.SigmaProcess_higgsA3phi_set)
    __swig_setmethods__["idA"] = _pythia8.SigmaProcess_idA_set
    __swig_getmethods__["idA"] = _pythia8.SigmaProcess_idA_get
    if _newclass:
        idA = _swig_property(_pythia8.SigmaProcess_idA_get, _pythia8.SigmaProcess_idA_set)
    __swig_setmethods__["idB"] = _pythia8.SigmaProcess_idB_set
    __swig_getmethods__["idB"] = _pythia8.SigmaProcess_idB_get
    if _newclass:
        idB = _swig_property(_pythia8.SigmaProcess_idB_get, _pythia8.SigmaProcess_idB_set)
    __swig_setmethods__["mA"] = _pythia8.SigmaProcess_mA_set
    __swig_getmethods__["mA"] = _pythia8.SigmaProcess_mA_get
    if _newclass:
        mA = _swig_property(_pythia8.SigmaProcess_mA_get, _pythia8.SigmaProcess_mA_set)
    __swig_setmethods__["mB"] = _pythia8.SigmaProcess_mB_set
    __swig_getmethods__["mB"] = _pythia8.SigmaProcess_mB_get
    if _newclass:
        mB = _swig_property(_pythia8.SigmaProcess_mB_get, _pythia8.SigmaProcess_mB_set)
    __swig_setmethods__["isLeptonA"] = _pythia8.SigmaProcess_isLeptonA_set
    __swig_getmethods__["isLeptonA"] = _pythia8.SigmaProcess_isLeptonA_get
    if _newclass:
        isLeptonA = _swig_property(_pythia8.SigmaProcess_isLeptonA_get, _pythia8.SigmaProcess_isLeptonA_set)
    __swig_setmethods__["isLeptonB"] = _pythia8.SigmaProcess_isLeptonB_set
    __swig_getmethods__["isLeptonB"] = _pythia8.SigmaProcess_isLeptonB_get
    if _newclass:
        isLeptonB = _swig_property(_pythia8.SigmaProcess_isLeptonB_get, _pythia8.SigmaProcess_isLeptonB_set)
    __swig_setmethods__["hasLeptonBeams"] = _pythia8.SigmaProcess_hasLeptonBeams_set
    __swig_getmethods__["hasLeptonBeams"] = _pythia8.SigmaProcess_hasLeptonBeams_get
    if _newclass:
        hasLeptonBeams = _swig_property(_pythia8.SigmaProcess_hasLeptonBeams_get, _pythia8.SigmaProcess_hasLeptonBeams_set)
    __swig_setmethods__["lepton2gammaA"] = _pythia8.SigmaProcess_lepton2gammaA_set
    __swig_getmethods__["lepton2gammaA"] = _pythia8.SigmaProcess_lepton2gammaA_get
    if _newclass:
        lepton2gammaA = _swig_property(_pythia8.SigmaProcess_lepton2gammaA_get, _pythia8.SigmaProcess_lepton2gammaA_set)
    __swig_setmethods__["lepton2gammaB"] = _pythia8.SigmaProcess_lepton2gammaB_set
    __swig_getmethods__["lepton2gammaB"] = _pythia8.SigmaProcess_lepton2gammaB_get
    if _newclass:
        lepton2gammaB = _swig_property(_pythia8.SigmaProcess_lepton2gammaB_get, _pythia8.SigmaProcess_lepton2gammaB_set)
    __swig_setmethods__["inBeamA"] = _pythia8.SigmaProcess_inBeamA_set
    __swig_getmethods__["inBeamA"] = _pythia8.SigmaProcess_inBeamA_get
    if _newclass:
        inBeamA = _swig_property(_pythia8.SigmaProcess_inBeamA_get, _pythia8.SigmaProcess_inBeamA_set)
    __swig_setmethods__["inBeamB"] = _pythia8.SigmaProcess_inBeamB_set
    __swig_getmethods__["inBeamB"] = _pythia8.SigmaProcess_inBeamB_get
    if _newclass:
        inBeamB = _swig_property(_pythia8.SigmaProcess_inBeamB_get, _pythia8.SigmaProcess_inBeamB_set)

    def addBeamA(self, idIn):
        """
Constants: could only be changed in the code itself.
Pointer to various information on the generation.
Pointer to the settings database.
Pointer to the particle data table.
Pointer to the random number generator.
Pointers to incoming beams.
Pointer to Standard Model couplings, including alphaS and alphaEM.
Pointer to the total/elastic/diffractive cross section object.
Pointer to an SLHA object.
Pointer to LHAup for generating external events.
Initialization data, normally only set once.
CP violation parameters for Higgs sector, normally only set once.
Information on incoming beams.
Partons in beams, with PDF's.
"""
        return _pythia8.SigmaProcess_addBeamA(self, idIn)

    def addBeamB(self, idIn):
        """
"""
        return _pythia8.SigmaProcess_addBeamB(self, idIn)

    def sizeBeamA(self):
        """
"""
        return _pythia8.SigmaProcess_sizeBeamA(self)

    def sizeBeamB(self):
        """
"""
        return _pythia8.SigmaProcess_sizeBeamB(self)
    __swig_setmethods__["inPair"] = _pythia8.SigmaProcess_inPair_set
    __swig_getmethods__["inPair"] = _pythia8.SigmaProcess_inPair_get
    if _newclass:
        inPair = _swig_property(_pythia8.SigmaProcess_inPair_get, _pythia8.SigmaProcess_inPair_set)

    def addPair(self, idAIn, idBIn):
        """
Allowed colliding parton pairs, with pdf's.
"""
        return _pythia8.SigmaProcess_addPair(self, idAIn, idBIn)

    def sizePair(self):
        """
"""
        return _pythia8.SigmaProcess_sizePair(self)
    __swig_setmethods__["mH"] = _pythia8.SigmaProcess_mH_set
    __swig_getmethods__["mH"] = _pythia8.SigmaProcess_mH_get
    if _newclass:
        mH = _swig_property(_pythia8.SigmaProcess_mH_get, _pythia8.SigmaProcess_mH_set)
    __swig_setmethods__["sH"] = _pythia8.SigmaProcess_sH_set
    __swig_getmethods__["sH"] = _pythia8.SigmaProcess_sH_get
    if _newclass:
        sH = _swig_property(_pythia8.SigmaProcess_sH_get, _pythia8.SigmaProcess_sH_set)
    __swig_setmethods__["sH2"] = _pythia8.SigmaProcess_sH2_set
    __swig_getmethods__["sH2"] = _pythia8.SigmaProcess_sH2_get
    if _newclass:
        sH2 = _swig_property(_pythia8.SigmaProcess_sH2_get, _pythia8.SigmaProcess_sH2_set)
    __swig_setmethods__["Q2RenSave"] = _pythia8.SigmaProcess_Q2RenSave_set
    __swig_getmethods__["Q2RenSave"] = _pythia8.SigmaProcess_Q2RenSave_get
    if _newclass:
        Q2RenSave = _swig_property(_pythia8.SigmaProcess_Q2RenSave_get, _pythia8.SigmaProcess_Q2RenSave_set)
    __swig_setmethods__["alpEM"] = _pythia8.SigmaProcess_alpEM_set
    __swig_getmethods__["alpEM"] = _pythia8.SigmaProcess_alpEM_get
    if _newclass:
        alpEM = _swig_property(_pythia8.SigmaProcess_alpEM_get, _pythia8.SigmaProcess_alpEM_set)
    __swig_setmethods__["alpS"] = _pythia8.SigmaProcess_alpS_set
    __swig_getmethods__["alpS"] = _pythia8.SigmaProcess_alpS_get
    if _newclass:
        alpS = _swig_property(_pythia8.SigmaProcess_alpS_get, _pythia8.SigmaProcess_alpS_set)
    __swig_setmethods__["Q2FacSave"] = _pythia8.SigmaProcess_Q2FacSave_set
    __swig_getmethods__["Q2FacSave"] = _pythia8.SigmaProcess_Q2FacSave_get
    if _newclass:
        Q2FacSave = _swig_property(_pythia8.SigmaProcess_Q2FacSave_get, _pythia8.SigmaProcess_Q2FacSave_set)
    __swig_setmethods__["x1Save"] = _pythia8.SigmaProcess_x1Save_set
    __swig_getmethods__["x1Save"] = _pythia8.SigmaProcess_x1Save_get
    if _newclass:
        x1Save = _swig_property(_pythia8.SigmaProcess_x1Save_get, _pythia8.SigmaProcess_x1Save_set)
    __swig_setmethods__["x2Save"] = _pythia8.SigmaProcess_x2Save_set
    __swig_getmethods__["x2Save"] = _pythia8.SigmaProcess_x2Save_get
    if _newclass:
        x2Save = _swig_property(_pythia8.SigmaProcess_x2Save_get, _pythia8.SigmaProcess_x2Save_set)
    __swig_setmethods__["pdf1Save"] = _pythia8.SigmaProcess_pdf1Save_set
    __swig_getmethods__["pdf1Save"] = _pythia8.SigmaProcess_pdf1Save_get
    if _newclass:
        pdf1Save = _swig_property(_pythia8.SigmaProcess_pdf1Save_get, _pythia8.SigmaProcess_pdf1Save_set)
    __swig_setmethods__["pdf2Save"] = _pythia8.SigmaProcess_pdf2Save_set
    __swig_getmethods__["pdf2Save"] = _pythia8.SigmaProcess_pdf2Save_get
    if _newclass:
        pdf2Save = _swig_property(_pythia8.SigmaProcess_pdf2Save_get, _pythia8.SigmaProcess_pdf2Save_set)
    __swig_setmethods__["sigmaSumSave"] = _pythia8.SigmaProcess_sigmaSumSave_set
    __swig_getmethods__["sigmaSumSave"] = _pythia8.SigmaProcess_sigmaSumSave_get
    if _newclass:
        sigmaSumSave = _swig_property(_pythia8.SigmaProcess_sigmaSumSave_get, _pythia8.SigmaProcess_sigmaSumSave_set)
    __swig_setmethods__["id1"] = _pythia8.SigmaProcess_id1_set
    __swig_getmethods__["id1"] = _pythia8.SigmaProcess_id1_get
    if _newclass:
        id1 = _swig_property(_pythia8.SigmaProcess_id1_get, _pythia8.SigmaProcess_id1_set)
    __swig_setmethods__["id2"] = _pythia8.SigmaProcess_id2_set
    __swig_getmethods__["id2"] = _pythia8.SigmaProcess_id2_get
    if _newclass:
        id2 = _swig_property(_pythia8.SigmaProcess_id2_get, _pythia8.SigmaProcess_id2_set)
    __swig_setmethods__["id3"] = _pythia8.SigmaProcess_id3_set
    __swig_getmethods__["id3"] = _pythia8.SigmaProcess_id3_get
    if _newclass:
        id3 = _swig_property(_pythia8.SigmaProcess_id3_get, _pythia8.SigmaProcess_id3_set)
    __swig_setmethods__["id4"] = _pythia8.SigmaProcess_id4_set
    __swig_getmethods__["id4"] = _pythia8.SigmaProcess_id4_get
    if _newclass:
        id4 = _swig_property(_pythia8.SigmaProcess_id4_get, _pythia8.SigmaProcess_id4_set)
    __swig_setmethods__["id5"] = _pythia8.SigmaProcess_id5_set
    __swig_getmethods__["id5"] = _pythia8.SigmaProcess_id5_get
    if _newclass:
        id5 = _swig_property(_pythia8.SigmaProcess_id5_get, _pythia8.SigmaProcess_id5_set)
    __swig_setmethods__["idSave"] = _pythia8.SigmaProcess_idSave_set
    __swig_getmethods__["idSave"] = _pythia8.SigmaProcess_idSave_get
    if _newclass:
        idSave = _swig_property(_pythia8.SigmaProcess_idSave_get, _pythia8.SigmaProcess_idSave_set)
    __swig_setmethods__["colSave"] = _pythia8.SigmaProcess_colSave_set
    __swig_getmethods__["colSave"] = _pythia8.SigmaProcess_colSave_get
    if _newclass:
        colSave = _swig_property(_pythia8.SigmaProcess_colSave_get, _pythia8.SigmaProcess_colSave_set)
    __swig_setmethods__["acolSave"] = _pythia8.SigmaProcess_acolSave_set
    __swig_getmethods__["acolSave"] = _pythia8.SigmaProcess_acolSave_get
    if _newclass:
        acolSave = _swig_property(_pythia8.SigmaProcess_acolSave_get, _pythia8.SigmaProcess_acolSave_set)
    __swig_setmethods__["mSave"] = _pythia8.SigmaProcess_mSave_set
    __swig_getmethods__["mSave"] = _pythia8.SigmaProcess_mSave_get
    if _newclass:
        mSave = _swig_property(_pythia8.SigmaProcess_mSave_get, _pythia8.SigmaProcess_mSave_set)
    __swig_setmethods__["cosTheta"] = _pythia8.SigmaProcess_cosTheta_set
    __swig_getmethods__["cosTheta"] = _pythia8.SigmaProcess_cosTheta_get
    if _newclass:
        cosTheta = _swig_property(_pythia8.SigmaProcess_cosTheta_get, _pythia8.SigmaProcess_cosTheta_set)
    __swig_setmethods__["sinTheta"] = _pythia8.SigmaProcess_sinTheta_set
    __swig_getmethods__["sinTheta"] = _pythia8.SigmaProcess_sinTheta_get
    if _newclass:
        sinTheta = _swig_property(_pythia8.SigmaProcess_sinTheta_get, _pythia8.SigmaProcess_sinTheta_set)
    __swig_setmethods__["phi"] = _pythia8.SigmaProcess_phi_set
    __swig_getmethods__["phi"] = _pythia8.SigmaProcess_phi_get
    if _newclass:
        phi = _swig_property(_pythia8.SigmaProcess_phi_get, _pythia8.SigmaProcess_phi_set)
    __swig_setmethods__["sHMass"] = _pythia8.SigmaProcess_sHMass_set
    __swig_getmethods__["sHMass"] = _pythia8.SigmaProcess_sHMass_get
    if _newclass:
        sHMass = _swig_property(_pythia8.SigmaProcess_sHMass_get, _pythia8.SigmaProcess_sHMass_set)
    __swig_setmethods__["sHBeta"] = _pythia8.SigmaProcess_sHBeta_set
    __swig_getmethods__["sHBeta"] = _pythia8.SigmaProcess_sHBeta_get
    if _newclass:
        sHBeta = _swig_property(_pythia8.SigmaProcess_sHBeta_get, _pythia8.SigmaProcess_sHBeta_set)
    __swig_setmethods__["pT2Mass"] = _pythia8.SigmaProcess_pT2Mass_set
    __swig_getmethods__["pT2Mass"] = _pythia8.SigmaProcess_pT2Mass_get
    if _newclass:
        pT2Mass = _swig_property(_pythia8.SigmaProcess_pT2Mass_get, _pythia8.SigmaProcess_pT2Mass_set)
    __swig_setmethods__["pTFin"] = _pythia8.SigmaProcess_pTFin_set
    __swig_getmethods__["pTFin"] = _pythia8.SigmaProcess_pTFin_get
    if _newclass:
        pTFin = _swig_property(_pythia8.SigmaProcess_pTFin_get, _pythia8.SigmaProcess_pTFin_set)
    __swig_setmethods__["parton"] = _pythia8.SigmaProcess_parton_set
    __swig_getmethods__["parton"] = _pythia8.SigmaProcess_parton_get
    if _newclass:
        parton = _swig_property(_pythia8.SigmaProcess_parton_get, _pythia8.SigmaProcess_parton_set)
    __swig_setmethods__["partonT"] = _pythia8.SigmaProcess_partonT_set
    __swig_getmethods__["partonT"] = _pythia8.SigmaProcess_partonT_get
    if _newclass:
        partonT = _swig_property(_pythia8.SigmaProcess_partonT_get, _pythia8.SigmaProcess_partonT_set)
    __swig_setmethods__["mSaveT"] = _pythia8.SigmaProcess_mSaveT_set
    __swig_getmethods__["mSaveT"] = _pythia8.SigmaProcess_mSaveT_get
    if _newclass:
        mSaveT = _swig_property(_pythia8.SigmaProcess_mSaveT_get, _pythia8.SigmaProcess_mSaveT_set)
    __swig_setmethods__["pTFinT"] = _pythia8.SigmaProcess_pTFinT_set
    __swig_getmethods__["pTFinT"] = _pythia8.SigmaProcess_pTFinT_get
    if _newclass:
        pTFinT = _swig_property(_pythia8.SigmaProcess_pTFinT_get, _pythia8.SigmaProcess_pTFinT_set)
    __swig_setmethods__["cosThetaT"] = _pythia8.SigmaProcess_cosThetaT_set
    __swig_getmethods__["cosThetaT"] = _pythia8.SigmaProcess_cosThetaT_get
    if _newclass:
        cosThetaT = _swig_property(_pythia8.SigmaProcess_cosThetaT_get, _pythia8.SigmaProcess_cosThetaT_set)
    __swig_setmethods__["sinThetaT"] = _pythia8.SigmaProcess_sinThetaT_set
    __swig_getmethods__["sinThetaT"] = _pythia8.SigmaProcess_sinThetaT_get
    if _newclass:
        sinThetaT = _swig_property(_pythia8.SigmaProcess_sinThetaT_get, _pythia8.SigmaProcess_sinThetaT_set)
    __swig_setmethods__["phiT"] = _pythia8.SigmaProcess_phiT_set
    __swig_getmethods__["phiT"] = _pythia8.SigmaProcess_phiT_get
    if _newclass:
        phiT = _swig_property(_pythia8.SigmaProcess_phiT_get, _pythia8.SigmaProcess_phiT_set)

    def setupForME(self):
        """
Store common subprocess kinematics quantities.
Store Q2 renormalization and factorization scales, and related values.
Store flavour, colour, anticolour, mass, angles and the whole particle.
Minimal set of saved kinematics for trial interactions when
using the x-dependent matter profile of multiparton interactions.
Calculate and store all modified masses and four-vectors
intended for matrix elements. Return false if failed.
"""
        return _pythia8.SigmaProcess_setupForME(self)

    def setupForMEin(self):
        """
"""
        return _pythia8.SigmaProcess_setupForMEin(self)
    __swig_setmethods__["mME"] = _pythia8.SigmaProcess_mME_set
    __swig_getmethods__["mME"] = _pythia8.SigmaProcess_mME_get
    if _newclass:
        mME = _swig_property(_pythia8.SigmaProcess_mME_get, _pythia8.SigmaProcess_mME_set)
    __swig_setmethods__["pME"] = _pythia8.SigmaProcess_pME_set
    __swig_getmethods__["pME"] = _pythia8.SigmaProcess_pME_get
    if _newclass:
        pME = _swig_property(_pythia8.SigmaProcess_pME_get, _pythia8.SigmaProcess_pME_set)
    __swig_setmethods__["swapTU"] = _pythia8.SigmaProcess_swapTU_set
    __swig_getmethods__["swapTU"] = _pythia8.SigmaProcess_swapTU_get
    if _newclass:
        swapTU = _swig_property(_pythia8.SigmaProcess_swapTU_get, _pythia8.SigmaProcess_swapTU_set)

    def setId(self, id1in=0, id2in=0, id3in=0, id4in=0, id5in=0):
        """
Store whether tHat and uHat are swapped (= same as swap 3 and 4).
Set flavour, colour and anticolour.
"""
        return _pythia8.SigmaProcess_setId(self, id1in, id2in, id3in, id4in, id5in)

    def setColAcol(self, col1=0, acol1=0, col2=0, acol2=0, col3=0, acol3=0, col4=0, acol4=0, col5=0, acol5=0):
        """
"""
        return _pythia8.SigmaProcess_setColAcol(self, col1, acol1, col2, acol2, col3, acol3, col4, acol4, col5, acol5)

    def swapColAcol(self):
        """
"""
        return _pythia8.SigmaProcess_swapColAcol(self)

    def swapCol1234(self):
        """
"""
        return _pythia8.SigmaProcess_swapCol1234(self)

    def swapCol12(self):
        """
"""
        return _pythia8.SigmaProcess_swapCol12(self)

    def swapCol34(self):
        """
"""
        return _pythia8.SigmaProcess_swapCol34(self)

    def weightTopDecay(self, process, iResBeg, iResEnd):
        """
Common code for top and Higgs secondary decay angular weights.
"""
        return _pythia8.SigmaProcess_weightTopDecay(self, process, iResBeg, iResEnd)

    def weightHiggsDecay(self, process, iResBeg, iResEnd):
        """
"""
        return _pythia8.SigmaProcess_weightHiggsDecay(self, process, iResBeg, iResEnd)
    def __disown__(self):
        self.this.disown()
        _pythia8.disown_SigmaProcess(self)
        return weakref_proxy(self)
SigmaProcess_swigregister = _pythia8.SigmaProcess_swigregister
SigmaProcess_swigregister(SigmaProcess)
SigmaProcess.CONVERT2MB = _pythia8.cvar.SigmaProcess_CONVERT2MB
SigmaProcess.MASSMARGIN = _pythia8.cvar.SigmaProcess_MASSMARGIN
SigmaProcess.COMPRELERR = _pythia8.cvar.SigmaProcess_COMPRELERR
SigmaProcess.NCOMPSTEP = _pythia8.cvar.SigmaProcess_NCOMPSTEP

class Sigma0Process(SigmaProcess):
    """
Sigma0Process is the base class for unresolved and minimum-bias processes.
It is derived from SigmaProcess.
"""
    __swig_setmethods__ = {}
    for _s in [SigmaProcess]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma0Process, name, value)
    __swig_getmethods__ = {}
    for _s in [SigmaProcess]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma0Process, name)

    def __init__(self, *args, **kwargs):
        """
Constructor.
"""
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _pythia8.delete_Sigma0Process
    __del__ = lambda self: None

    def nFinal(self):
        """
Number of final-state particles.
"""
        return _pythia8.Sigma0Process_nFinal(self)

    def initFlux(self):
        """
No partonic flux to be set up.
"""
        return _pythia8.Sigma0Process_initFlux(self)

    def sigmaHat(self):
        """
"""
        return _pythia8.Sigma0Process_sigmaHat(self)

    def sigmaPDF(self, arg2, arg3, arg4, arg5, arg6):
        """
Since no PDF's there is no difference from above.
"""
        return _pythia8.Sigma0Process_sigmaPDF(self, arg2, arg3, arg4, arg5, arg6)

    def convert2mb(self):
        """
Answer for these processes already in mb, so do not convert.
"""
        return _pythia8.Sigma0Process_convert2mb(self)

    def setIdInDiff(self, idAin, idBin):
        """
Set the incoming ids for diffraction.
"""
        return _pythia8.Sigma0Process_setIdInDiff(self, idAin, idBin)
Sigma0Process_swigregister = _pythia8.Sigma0Process_swigregister
Sigma0Process_swigregister(Sigma0Process)

class Sigma1Process(SigmaProcess):
    """
Sigma1Process is the base class for 2 -> 1 processes.
It is derived from SigmaProcess.
"""
    __swig_setmethods__ = {}
    for _s in [SigmaProcess]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma1Process, name, value)
    __swig_getmethods__ = {}
    for _s in [SigmaProcess]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma1Process, name)

    def __init__(self, *args, **kwargs):
        """
Constructor.
"""
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _pythia8.delete_Sigma1Process
    __del__ = lambda self: None

    def nFinal(self):
        """
Number of final-state particles.
"""
        return _pythia8.Sigma1Process_nFinal(self)

    def set1Kin(self, x1in, x2in, sHin):
        """
Input and complement kinematics for resolved 2 -> 1 process.
"""
        return _pythia8.Sigma1Process_set1Kin(self, x1in, x2in, sHin)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat) for resolved 2 -> 1 processes.
"""
        return _pythia8.Sigma1Process_sigmaHat(self)

    def sigmaHatWrap(self, id1in=0, id2in=0):
        """
Wrapper to sigmaHat, to (a) store current incoming flavours,
(b) convert from GeV^-2 to mb where required, and
(c) convert from |M|^2 to d(sigmaHat)/d(tHat) where required.
"""
        return _pythia8.Sigma1Process_sigmaHatWrap(self, id1in, id2in)
Sigma1Process_swigregister = _pythia8.Sigma1Process_swigregister
Sigma1Process_swigregister(Sigma1Process)

class Sigma2Process(SigmaProcess):
    """
Sigma2Process is the base class for 2 -> 2 processes.
It is derived from SigmaProcess.
"""
    __swig_setmethods__ = {}
    for _s in [SigmaProcess]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2Process, name, value)
    __swig_getmethods__ = {}
    for _s in [SigmaProcess]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2Process, name)

    def __init__(self, *args, **kwargs):
        """
Constructor.
"""
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _pythia8.delete_Sigma2Process
    __del__ = lambda self: None

    def nFinal(self):
        """
Number of final-state particles.
"""
        return _pythia8.Sigma2Process_nFinal(self)

    def set2Kin(self, x1in, x2in, sHin, tHin, m3in, m4in, runBW3in, runBW4in):
        """
Input and complement kinematics for resolved 2 -> 2 process.
"""
        return _pythia8.Sigma2Process_set2Kin(self, x1in, x2in, sHin, tHin, m3in, m4in, runBW3in, runBW4in)

    def set2KinMPI(self, x1in, x2in, sHin, tHin, uHin, alpSin, alpEMin, needMasses, m3in, m4in):
        """
Ditto, but for Multiparton Interactions applications, so different input.
"""
        return _pythia8.Sigma2Process_set2KinMPI(self, x1in, x2in, sHin, tHin, uHin, alpSin, alpEMin, needMasses, m3in, m4in)

    def sigmaHat(self):
        """
"""
        return _pythia8.Sigma2Process_sigmaHat(self)

    def sigmaHatWrap(self, id1in=0, id2in=0):
        """
Wrapper to sigmaHat, to (a) store current incoming flavours,
(b) convert from GeV^-2 to mb where required, and
(c) convert from |M|^2 to d(sigmaHat)/d(tHat) where required.
"""
        return _pythia8.Sigma2Process_sigmaHatWrap(self, id1in, id2in)

    def final2KinMPI(self, i1Res=0, i2Res=0, p1Res=0., p2Res=0., m1Res=0., m2Res=0.):
        """
Perform kinematics for a Multiparton Interaction, in its rest frame.
"""
        return _pythia8.Sigma2Process_final2KinMPI(self, i1Res, i2Res, p1Res, p2Res, m1Res, m2Res)
Sigma2Process_swigregister = _pythia8.Sigma2Process_swigregister
Sigma2Process_swigregister(Sigma2Process)

class Sigma3Process(SigmaProcess):
    """
Sigma3Process is the base class for 2 -> 3 processes.
It is derived from SigmaProcess.
"""
    __swig_setmethods__ = {}
    for _s in [SigmaProcess]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma3Process, name, value)
    __swig_getmethods__ = {}
    for _s in [SigmaProcess]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma3Process, name)

    def __init__(self, *args, **kwargs):
        """
Constructor.
"""
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _pythia8.delete_Sigma3Process
    __del__ = lambda self: None

    def nFinal(self):
        """
Number of final-state particles.
"""
        return _pythia8.Sigma3Process_nFinal(self)

    def set3Kin(self, x1in, x2in, sHin, p3cmIn, p4cmIn, p5cmIn, m3in, m4in, m5in, runBW3in, runBW4in, runBW5in):
        """
Input and complement kinematics for resolved 2 -> 3 process.
"""
        return _pythia8.Sigma3Process_set3Kin(self, x1in, x2in, sHin, p3cmIn, p4cmIn, p5cmIn, m3in, m4in, m5in, runBW3in, runBW4in, runBW5in)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat) for resolved 2 -> 3 processes.
"""
        return _pythia8.Sigma3Process_sigmaHat(self)
Sigma3Process_swigregister = _pythia8.Sigma3Process_swigregister
Sigma3Process_swigregister(Sigma3Process)

class SigmaLHAProcess(SigmaProcess):
    """
SigmaLHAProcess is a wrapper class for Les Houches Accord external input.
It is derived from SigmaProcess.
"""
    __swig_setmethods__ = {}
    for _s in [SigmaProcess]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SigmaLHAProcess, name, value)
    __swig_getmethods__ = {}
    for _s in [SigmaProcess]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SigmaLHAProcess, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_SigmaLHAProcess()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_SigmaLHAProcess
    __del__ = lambda self: None

    def initFlux(self):
        """
No partonic flux to be set up.
"""
        return _pythia8.SigmaLHAProcess_initFlux(self)

    def sigmaPDF(self, arg2, arg3, arg4, arg5, arg6):
        """
Dummy function: action is put in PhaseSpaceLHA.
"""
        return _pythia8.SigmaLHAProcess_sigmaPDF(self, arg2, arg3, arg4, arg5, arg6)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for decay angular configuration, where relevant.
"""
        return _pythia8.SigmaLHAProcess_weightDecay(self, process, iResBeg, iResEnd)

    def setScale(self):
        """
Set scale, when that is missing for an external LHA process.
"""
        return _pythia8.SigmaLHAProcess_setScale(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.SigmaLHAProcess_name(self)

    def code(self):
        """
"""
        return _pythia8.SigmaLHAProcess_code(self)

    def nFinal(self):
        """
Number of final-state particles depends on current process choice.
"""
        return _pythia8.SigmaLHAProcess_nFinal(self)

    def convert2mb(self):
        """
Answer for these processes not in GeV^-2, so do not do this conversion.
"""
        return _pythia8.SigmaLHAProcess_convert2mb(self)

    def isLHA(self):
        """
Ensure special treatment of Les Houches processes.
"""
        return _pythia8.SigmaLHAProcess_isLHA(self)

    def allowNegativeSigma(self):
        """
Special treatment needed if negative cross sections allowed.
"""
        return _pythia8.SigmaLHAProcess_allowNegativeSigma(self)
SigmaLHAProcess_swigregister = _pythia8.SigmaLHAProcess_swigregister
SigmaLHAProcess_swigregister(SigmaLHAProcess)

class Sigma0nonDiffractive(Sigma0Process):
    """
A derived class for minimum-bias (inelastic, nondiffractive) events.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma0Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma0nonDiffractive, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma0Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma0nonDiffractive, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma0nonDiffractive()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaHat(self):
        """
Evaluate sigma.
"""
        return _pythia8.Sigma0nonDiffractive_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma0nonDiffractive_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma0nonDiffractive_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma0nonDiffractive_code(self)

    def isNonDiff(self):
        """
"""
        return _pythia8.Sigma0nonDiffractive_isNonDiff(self)
    __swig_destroy__ = _pythia8.delete_Sigma0nonDiffractive
    __del__ = lambda self: None
Sigma0nonDiffractive_swigregister = _pythia8.Sigma0nonDiffractive_swigregister
Sigma0nonDiffractive_swigregister(Sigma0nonDiffractive)

class Sigma0AB2AB(Sigma0Process):
    """
A derived class for elastic scattering A B -> A B.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma0Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma0AB2AB, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma0Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma0AB2AB, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma0AB2AB()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaHat(self):
        """
Evaluate sigma.
"""
        return _pythia8.Sigma0AB2AB_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma0AB2AB_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma0AB2AB_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma0AB2AB_code(self)

    def isResolved(self):
        """
"""
        return _pythia8.Sigma0AB2AB_isResolved(self)
    __swig_destroy__ = _pythia8.delete_Sigma0AB2AB
    __del__ = lambda self: None
Sigma0AB2AB_swigregister = _pythia8.Sigma0AB2AB_swigregister
Sigma0AB2AB_swigregister(Sigma0AB2AB)

class Sigma0AB2XB(Sigma0Process):
    """
A derived class for single diffractive scattering A B -> X B.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma0Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma0AB2XB, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma0Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma0AB2XB, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma0AB2XB()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaHat(self):
        """
Evaluate sigma.
"""
        return _pythia8.Sigma0AB2XB_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma0AB2XB_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma0AB2XB_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma0AB2XB_code(self)

    def isResolved(self):
        """
"""
        return _pythia8.Sigma0AB2XB_isResolved(self)

    def isDiffA(self):
        """
"""
        return _pythia8.Sigma0AB2XB_isDiffA(self)
    __swig_destroy__ = _pythia8.delete_Sigma0AB2XB
    __del__ = lambda self: None
Sigma0AB2XB_swigregister = _pythia8.Sigma0AB2XB_swigregister
Sigma0AB2XB_swigregister(Sigma0AB2XB)

class Sigma0AB2AX(Sigma0Process):
    """
A derived class for single diffractive scattering A B -> A X.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma0Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma0AB2AX, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma0Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma0AB2AX, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma0AB2AX()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaHat(self):
        """
Evaluate sigma.
"""
        return _pythia8.Sigma0AB2AX_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma0AB2AX_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma0AB2AX_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma0AB2AX_code(self)

    def isResolved(self):
        """
"""
        return _pythia8.Sigma0AB2AX_isResolved(self)

    def isDiffB(self):
        """
"""
        return _pythia8.Sigma0AB2AX_isDiffB(self)
    __swig_destroy__ = _pythia8.delete_Sigma0AB2AX
    __del__ = lambda self: None
Sigma0AB2AX_swigregister = _pythia8.Sigma0AB2AX_swigregister
Sigma0AB2AX_swigregister(Sigma0AB2AX)

class Sigma0AB2XX(Sigma0Process):
    """
A derived class for double diffractive scattering A B -> X X.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma0Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma0AB2XX, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma0Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma0AB2XX, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma0AB2XX()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaHat(self):
        """
Evaluate sigma.
"""
        return _pythia8.Sigma0AB2XX_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma0AB2XX_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma0AB2XX_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma0AB2XX_code(self)

    def isResolved(self):
        """
"""
        return _pythia8.Sigma0AB2XX_isResolved(self)

    def isDiffA(self):
        """
"""
        return _pythia8.Sigma0AB2XX_isDiffA(self)

    def isDiffB(self):
        """
"""
        return _pythia8.Sigma0AB2XX_isDiffB(self)
    __swig_destroy__ = _pythia8.delete_Sigma0AB2XX
    __del__ = lambda self: None
Sigma0AB2XX_swigregister = _pythia8.Sigma0AB2XX_swigregister
Sigma0AB2XX_swigregister(Sigma0AB2XX)

class Sigma0AB2AXB(Sigma0Process):
    """
A derived class for central diffractive scattering A B -> A X B.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma0Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma0AB2AXB, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma0Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma0AB2AXB, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma0AB2AXB()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaHat(self):
        """
Evaluate sigma.
"""
        return _pythia8.Sigma0AB2AXB_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma0AB2AXB_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma0AB2AXB_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma0AB2AXB_code(self)

    def nFinal(self):
        """
"""
        return _pythia8.Sigma0AB2AXB_nFinal(self)

    def isResolved(self):
        """
"""
        return _pythia8.Sigma0AB2AXB_isResolved(self)

    def isDiffC(self):
        """
"""
        return _pythia8.Sigma0AB2AXB_isDiffC(self)
    __swig_destroy__ = _pythia8.delete_Sigma0AB2AXB
    __del__ = lambda self: None
Sigma0AB2AXB_swigregister = _pythia8.Sigma0AB2AXB_swigregister
Sigma0AB2AXB_swigregister(Sigma0AB2AXB)

class Sigma2gg2gg(Sigma2Process):
    """
A derived class for g g -> g g.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2gg2gg, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2gg2gg, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2gg2gg()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2gg2gg_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2gg2gg_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2gg2gg_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2gg2gg_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2gg2gg_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2gg2gg_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2gg2gg
    __del__ = lambda self: None
Sigma2gg2gg_swigregister = _pythia8.Sigma2gg2gg_swigregister
Sigma2gg2gg_swigregister(Sigma2gg2gg)

class Sigma2gg2qqbar(Sigma2Process):
    """
A derived class for g g -> q qbar (q = u, d, s, i.e. almost massless).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2gg2qqbar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2gg2qqbar, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2gg2qqbar()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2gg2qqbar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2gg2qqbar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2gg2qqbar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2gg2qqbar_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2gg2qqbar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2gg2qqbar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2gg2qqbar_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2gg2qqbar
    __del__ = lambda self: None
Sigma2gg2qqbar_swigregister = _pythia8.Sigma2gg2qqbar_swigregister
Sigma2gg2qqbar_swigregister(Sigma2gg2qqbar)

class Sigma2qg2qg(Sigma2Process):
    """
A derived class for q g -> q g (q = u, d, s, c, b).
Use massless approximation also for Q since no alternative.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qg2qg, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qg2qg, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qg2qg()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qg2qg_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2qg2qg_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qg2qg_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qg2qg_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qg2qg_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qg2qg_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qg2qg
    __del__ = lambda self: None
Sigma2qg2qg_swigregister = _pythia8.Sigma2qg2qg_swigregister
Sigma2qg2qg_swigregister(Sigma2qg2qg)

class Sigma2qq2qq(Sigma2Process):
    """
A derived class for q qbar' -> q qbar' or q q' -> q q'
(qbar qbar' -> qbar qbar'), q' may be same as q.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qq2qq, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qq2qq, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qq2qq()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qq2qq_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2qq2qq_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qq2qq_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qq2qq_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qq2qq_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qq2qq_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qq2qq
    __del__ = lambda self: None
Sigma2qq2qq_swigregister = _pythia8.Sigma2qq2qq_swigregister
Sigma2qq2qq_swigregister(Sigma2qq2qq)

class Sigma2qqbar2gg(Sigma2Process):
    """
A derived class for q qbar -> g g.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qqbar2gg, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qqbar2gg, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qqbar2gg()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qqbar2gg_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2qqbar2gg_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qqbar2gg_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qqbar2gg_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qqbar2gg_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qqbar2gg_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qqbar2gg
    __del__ = lambda self: None
Sigma2qqbar2gg_swigregister = _pythia8.Sigma2qqbar2gg_swigregister
Sigma2qqbar2gg_swigregister(Sigma2qqbar2gg)

class Sigma2qqbar2qqbarNew(Sigma2Process):
    """
A derived class for q qbar -> q' qbar'.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qqbar2qqbarNew, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qqbar2qqbarNew, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qqbar2qqbarNew()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2qqbar2qqbarNew_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qqbar2qqbarNew_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2qqbar2qqbarNew_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qqbar2qqbarNew_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qqbar2qqbarNew_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qqbar2qqbarNew_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qqbar2qqbarNew_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qqbar2qqbarNew
    __del__ = lambda self: None
Sigma2qqbar2qqbarNew_swigregister = _pythia8.Sigma2qqbar2qqbarNew_swigregister
Sigma2qqbar2qqbarNew_swigregister(Sigma2qqbar2qqbarNew)

class Sigma2gg2QQbar(Sigma2Process):
    """
A derived class for g g -> Q Qbar (Q = c, b or t).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2gg2QQbar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2gg2QQbar, name)
    __repr__ = _swig_repr

    def __init__(self, idIn, codeIn):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2gg2QQbar(idIn, codeIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2gg2QQbar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2gg2QQbar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2gg2QQbar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2gg2QQbar_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for W decay angles in top decay (else inactive).
"""
        return _pythia8.Sigma2gg2QQbar_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2gg2QQbar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2gg2QQbar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2gg2QQbar_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2gg2QQbar_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2gg2QQbar_id4Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2gg2QQbar
    __del__ = lambda self: None
Sigma2gg2QQbar_swigregister = _pythia8.Sigma2gg2QQbar_swigregister
Sigma2gg2QQbar_swigregister(Sigma2gg2QQbar)

class Sigma2qqbar2QQbar(Sigma2Process):
    """
A derived class for q qbar -> Q Qbar (Q = c, b or t).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qqbar2QQbar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qqbar2QQbar, name)
    __repr__ = _swig_repr

    def __init__(self, idIn, codeIn):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qqbar2QQbar(idIn, codeIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2qqbar2QQbar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qqbar2QQbar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2qqbar2QQbar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qqbar2QQbar_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for W decay angles in top decay (else inactive).
"""
        return _pythia8.Sigma2qqbar2QQbar_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qqbar2QQbar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qqbar2QQbar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qqbar2QQbar_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2qqbar2QQbar_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2qqbar2QQbar_id4Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qqbar2QQbar
    __del__ = lambda self: None
Sigma2qqbar2QQbar_swigregister = _pythia8.Sigma2qqbar2QQbar_swigregister
Sigma2qqbar2QQbar_swigregister(Sigma2qqbar2QQbar)

class Sigma3gg2ggg(Sigma3Process):
    """
A derived class for g g -> g g g.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma3Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma3gg2ggg, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma3Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma3gg2ggg, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma3gg2ggg()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma3gg2ggg_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma3gg2ggg_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma3gg2ggg_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma3gg2ggg_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma3gg2ggg_code(self)

    def nFinal(self):
        """
"""
        return _pythia8.Sigma3gg2ggg_nFinal(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma3gg2ggg_inFlux(self)

    def isQCD3body(self):
        """
"""
        return _pythia8.Sigma3gg2ggg_isQCD3body(self)
    __swig_destroy__ = _pythia8.delete_Sigma3gg2ggg
    __del__ = lambda self: None
Sigma3gg2ggg_swigregister = _pythia8.Sigma3gg2ggg_swigregister
Sigma3gg2ggg_swigregister(Sigma3gg2ggg)

class Sigma3qqbar2ggg(Sigma3Process):
    """
A derived class for q qbar -> g g g.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma3Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma3qqbar2ggg, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma3Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma3qqbar2ggg, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma3qqbar2ggg()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma3qqbar2ggg_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma3qqbar2ggg_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma3qqbar2ggg_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma3qqbar2ggg_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma3qqbar2ggg_code(self)

    def nFinal(self):
        """
"""
        return _pythia8.Sigma3qqbar2ggg_nFinal(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma3qqbar2ggg_inFlux(self)

    def isQCD3body(self):
        """
"""
        return _pythia8.Sigma3qqbar2ggg_isQCD3body(self)
    __swig_destroy__ = _pythia8.delete_Sigma3qqbar2ggg
    __del__ = lambda self: None
Sigma3qqbar2ggg_swigregister = _pythia8.Sigma3qqbar2ggg_swigregister
Sigma3qqbar2ggg_swigregister(Sigma3qqbar2ggg)

class Sigma3qg2qgg(Sigma3qqbar2ggg):
    """
A derived class for q g -> q g g
Derived from Sigma3qqbar2ggg
"""
    __swig_setmethods__ = {}
    for _s in [Sigma3qqbar2ggg]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma3qg2qgg, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma3qqbar2ggg]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma3qg2qgg, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma3qg2qgg()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma3qg2qgg_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma3qg2qgg_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma3qg2qgg_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma3qg2qgg_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma3qg2qgg_code(self)

    def nFinal(self):
        """
"""
        return _pythia8.Sigma3qg2qgg_nFinal(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma3qg2qgg_inFlux(self)

    def isQCD3body(self):
        """
"""
        return _pythia8.Sigma3qg2qgg_isQCD3body(self)
    __swig_destroy__ = _pythia8.delete_Sigma3qg2qgg
    __del__ = lambda self: None
Sigma3qg2qgg_swigregister = _pythia8.Sigma3qg2qgg_swigregister
Sigma3qg2qgg_swigregister(Sigma3qg2qgg)

class Sigma3gg2qqbarg(Sigma3qqbar2ggg):
    """
A derived class for g g -> q qbar g
Derived from Sigma3qqbar2ggg
"""
    __swig_setmethods__ = {}
    for _s in [Sigma3qqbar2ggg]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma3gg2qqbarg, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma3qqbar2ggg]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma3gg2qqbarg, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma3gg2qqbarg()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma3gg2qqbarg_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma3gg2qqbarg_sigmaKin(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma3gg2qqbarg_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma3gg2qqbarg_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma3gg2qqbarg_code(self)

    def nFinal(self):
        """
"""
        return _pythia8.Sigma3gg2qqbarg_nFinal(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma3gg2qqbarg_inFlux(self)

    def isQCD3body(self):
        """
"""
        return _pythia8.Sigma3gg2qqbarg_isQCD3body(self)
    __swig_destroy__ = _pythia8.delete_Sigma3gg2qqbarg
    __del__ = lambda self: None
Sigma3gg2qqbarg_swigregister = _pythia8.Sigma3gg2qqbarg_swigregister
Sigma3gg2qqbarg_swigregister(Sigma3gg2qqbarg)

class Sigma3qq2qqgDiff(Sigma3Process):
    """
A derived class for q q' -> q q' g
"""
    __swig_setmethods__ = {}
    for _s in [Sigma3Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma3qq2qqgDiff, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma3Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma3qq2qqgDiff, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma3qq2qqgDiff()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma3qq2qqgDiff_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma3qq2qqgDiff_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma3qq2qqgDiff_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma3qq2qqgDiff_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma3qq2qqgDiff_code(self)

    def nFinal(self):
        """
"""
        return _pythia8.Sigma3qq2qqgDiff_nFinal(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma3qq2qqgDiff_inFlux(self)

    def isQCD3body(self):
        """
"""
        return _pythia8.Sigma3qq2qqgDiff_isQCD3body(self)
    __swig_destroy__ = _pythia8.delete_Sigma3qq2qqgDiff
    __del__ = lambda self: None
Sigma3qq2qqgDiff_swigregister = _pythia8.Sigma3qq2qqgDiff_swigregister
Sigma3qq2qqgDiff_swigregister(Sigma3qq2qqgDiff)

class Sigma3qqbar2qqbargDiff(Sigma3qq2qqgDiff):
    """
A derived class for q qbar -> q' qbar' g
Derived from Sigma3qq2qqgDiff
"""
    __swig_setmethods__ = {}
    for _s in [Sigma3qq2qqgDiff]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma3qqbar2qqbargDiff, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma3qq2qqgDiff]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma3qqbar2qqbargDiff, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma3qqbar2qqbargDiff()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma3qqbar2qqbargDiff_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma3qqbar2qqbargDiff_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma3qqbar2qqbargDiff_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma3qqbar2qqbargDiff_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma3qqbar2qqbargDiff_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma3qqbar2qqbargDiff_code(self)

    def nFinal(self):
        """
"""
        return _pythia8.Sigma3qqbar2qqbargDiff_nFinal(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma3qqbar2qqbargDiff_inFlux(self)

    def isQCD3body(self):
        """
"""
        return _pythia8.Sigma3qqbar2qqbargDiff_isQCD3body(self)
    __swig_destroy__ = _pythia8.delete_Sigma3qqbar2qqbargDiff
    __del__ = lambda self: None
Sigma3qqbar2qqbargDiff_swigregister = _pythia8.Sigma3qqbar2qqbargDiff_swigregister
Sigma3qqbar2qqbargDiff_swigregister(Sigma3qqbar2qqbargDiff)

class Sigma3qg2qqqbarDiff(Sigma3qq2qqgDiff):
    """
A derived class for q g -> q q' qbar'
Derived from Sigma3qq2qqgDiff
"""
    __swig_setmethods__ = {}
    for _s in [Sigma3qq2qqgDiff]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma3qg2qqqbarDiff, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma3qq2qqgDiff]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma3qg2qqqbarDiff, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma3qg2qqqbarDiff()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma3qg2qqqbarDiff_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma3qg2qqqbarDiff_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma3qg2qqqbarDiff_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma3qg2qqqbarDiff_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma3qg2qqqbarDiff_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma3qg2qqqbarDiff_code(self)

    def nFinal(self):
        """
"""
        return _pythia8.Sigma3qg2qqqbarDiff_nFinal(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma3qg2qqqbarDiff_inFlux(self)

    def isQCD3body(self):
        """
"""
        return _pythia8.Sigma3qg2qqqbarDiff_isQCD3body(self)
    __swig_destroy__ = _pythia8.delete_Sigma3qg2qqqbarDiff
    __del__ = lambda self: None
Sigma3qg2qqqbarDiff_swigregister = _pythia8.Sigma3qg2qqqbarDiff_swigregister
Sigma3qg2qqqbarDiff_swigregister(Sigma3qg2qqqbarDiff)

class Sigma3qq2qqgSame(Sigma3Process):
    """
A derived class for q q -> q q g
"""
    __swig_setmethods__ = {}
    for _s in [Sigma3Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma3qq2qqgSame, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma3Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma3qq2qqgSame, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma3qq2qqgSame()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma3qq2qqgSame_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma3qq2qqgSame_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma3qq2qqgSame_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma3qq2qqgSame_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma3qq2qqgSame_code(self)

    def nFinal(self):
        """
"""
        return _pythia8.Sigma3qq2qqgSame_nFinal(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma3qq2qqgSame_inFlux(self)

    def isQCD3body(self):
        """
"""
        return _pythia8.Sigma3qq2qqgSame_isQCD3body(self)
    __swig_destroy__ = _pythia8.delete_Sigma3qq2qqgSame
    __del__ = lambda self: None
Sigma3qq2qqgSame_swigregister = _pythia8.Sigma3qq2qqgSame_swigregister
Sigma3qq2qqgSame_swigregister(Sigma3qq2qqgSame)

class Sigma3qqbar2qqbargSame(Sigma3qq2qqgSame):
    """
A derived class for q q -> q q g
Derived from Sigma3qq2qqgSame
"""
    __swig_setmethods__ = {}
    for _s in [Sigma3qq2qqgSame]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma3qqbar2qqbargSame, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma3qq2qqgSame]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma3qqbar2qqbargSame, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma3qqbar2qqbargSame()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma3qqbar2qqbargSame_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma3qqbar2qqbargSame_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma3qqbar2qqbargSame_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma3qqbar2qqbargSame_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma3qqbar2qqbargSame_code(self)

    def nFinal(self):
        """
"""
        return _pythia8.Sigma3qqbar2qqbargSame_nFinal(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma3qqbar2qqbargSame_inFlux(self)

    def isQCD3body(self):
        """
"""
        return _pythia8.Sigma3qqbar2qqbargSame_isQCD3body(self)
    __swig_destroy__ = _pythia8.delete_Sigma3qqbar2qqbargSame
    __del__ = lambda self: None
Sigma3qqbar2qqbargSame_swigregister = _pythia8.Sigma3qqbar2qqbargSame_swigregister
Sigma3qqbar2qqbargSame_swigregister(Sigma3qqbar2qqbargSame)

class Sigma3qg2qqqbarSame(Sigma3qq2qqgSame):
    """
A derived class for q g -> q qbar q; same flavour.
Derived from Sigma3qq2qqgSame
"""
    __swig_setmethods__ = {}
    for _s in [Sigma3qq2qqgSame]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma3qg2qqqbarSame, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma3qq2qqgSame]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma3qg2qqqbarSame, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma3qg2qqqbarSame()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma3qg2qqqbarSame_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma3qg2qqqbarSame_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma3qg2qqqbarSame_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma3qg2qqqbarSame_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma3qg2qqqbarSame_code(self)

    def nFinal(self):
        """
"""
        return _pythia8.Sigma3qg2qqqbarSame_nFinal(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma3qg2qqqbarSame_inFlux(self)

    def isQCD3body(self):
        """
"""
        return _pythia8.Sigma3qg2qqqbarSame_isQCD3body(self)
    __swig_destroy__ = _pythia8.delete_Sigma3qg2qqqbarSame
    __del__ = lambda self: None
Sigma3qg2qqqbarSame_swigregister = _pythia8.Sigma3qg2qqqbarSame_swigregister
Sigma3qg2qqqbarSame_swigregister(Sigma3qg2qqqbarSame)

class UserHooks(_object):
    """
UserHooks is base class for user access to program execution.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, UserHooks, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, UserHooks, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _pythia8.delete_UserHooks
    __del__ = lambda self: None

    def initPtr(self, infoPtrIn, settingsPtrIn, particleDataPtrIn, rndmPtrIn, beamAPtrIn, beamBPtrIn, beamPomAPtrIn, beamPomBPtrIn, coupSMPtrIn, partonSystemsPtrIn, sigmaTotPtrIn):
        """
Initialize pointers and workEvent. Note: not virtual.
"""
        return _pythia8.UserHooks_initPtr(self, infoPtrIn, settingsPtrIn, particleDataPtrIn, rndmPtrIn, beamAPtrIn, beamBPtrIn, beamPomAPtrIn, beamPomBPtrIn, coupSMPtrIn, partonSystemsPtrIn, sigmaTotPtrIn)

    def initAfterBeams(self):
        """
Initialisation after beams have been set by Pythia::init().
"""
        return _pythia8.UserHooks_initAfterBeams(self)

    def canModifySigma(self):
        """
Possibility to modify cross section of process.
"""
        return _pythia8.UserHooks_canModifySigma(self)

    def multiplySigmaBy(self, sigmaProcessPtr, phaseSpacePtr, inEvent):
        """
Multiplicative factor modifying the cross section of a hard process.
"""
        return _pythia8.UserHooks_multiplySigmaBy(self, sigmaProcessPtr, phaseSpacePtr, inEvent)

    def canBiasSelection(self):
        """
Possibility to bias selection of events, compensated by a weight.
"""
        return _pythia8.UserHooks_canBiasSelection(self)

    def biasSelectionBy(self, sigmaProcessPtr, phaseSpacePtr, inEvent):
        """
Multiplicative factor in the phase space selection of a hard process.
"""
        return _pythia8.UserHooks_biasSelectionBy(self, sigmaProcessPtr, phaseSpacePtr, inEvent)

    def biasedSelectionWeight(self):
        """
Event weight to compensate for selection weight above.
"""
        return _pythia8.UserHooks_biasedSelectionWeight(self)

    def canVetoProcessLevel(self):
        """
Possibility to veto event after process-level selection.
"""
        return _pythia8.UserHooks_canVetoProcessLevel(self)

    def doVetoProcessLevel(self, arg0):
        """
Decide whether to veto current process or not, based on process record.
Usage: doVetoProcessLevel( process).
"""
        return _pythia8.UserHooks_doVetoProcessLevel(self, arg0)

    def canVetoResonanceDecays(self):
        """
Possibility to veto resonance decay chain.
"""
        return _pythia8.UserHooks_canVetoResonanceDecays(self)

    def doVetoResonanceDecays(self, arg0):
        """
Decide whether to veto current resonance decay chain or not, based on
process record. Usage: doVetoProcessLevel( process).
"""
        return _pythia8.UserHooks_doVetoResonanceDecays(self, arg0)

    def canVetoPT(self):
        """
Possibility to veto MPI + ISR + FSR evolution and kill event,
making decision at a fixed pT scale. Useful for MLM-style matching.
"""
        return _pythia8.UserHooks_canVetoPT(self)

    def scaleVetoPT(self):
        """
Transverse-momentum scale for veto test.
"""
        return _pythia8.UserHooks_scaleVetoPT(self)

    def doVetoPT(self, arg0, arg1):
        """
Decide whether to veto current event or not, based on event record.
Usage: doVetoPT( iPos, event), where iPos = 0: no emissions so far;
iPos = 1/2/3 joint evolution, latest step was MPI/ISR/FSR;
iPos = 4: FSR only afterwards; iPos = 5: FSR in resonance decay.
"""
        return _pythia8.UserHooks_doVetoPT(self, arg0, arg1)

    def canVetoStep(self):
        """
Possibility to veto MPI + ISR + FSR evolution and kill event,
making decision after fixed number of ISR or FSR steps.
"""
        return _pythia8.UserHooks_canVetoStep(self)

    def numberVetoStep(self):
        """
Up to how many ISR + FSR steps of hardest interaction should be checked.
"""
        return _pythia8.UserHooks_numberVetoStep(self)

    def doVetoStep(self, arg0, arg1, arg2, arg3):
        """
Decide whether to veto current event or not, based on event record.
Usage: doVetoStep( iPos, nISR, nFSR, event), where iPos as above,
nISR and nFSR number of emissions so far for hard interaction only.
"""
        return _pythia8.UserHooks_doVetoStep(self, arg0, arg1, arg2, arg3)

    def canVetoMPIStep(self):
        """
Possibility to veto MPI + ISR + FSR evolution and kill event,
making decision after fixed number of MPI steps.
"""
        return _pythia8.UserHooks_canVetoMPIStep(self)

    def numberVetoMPIStep(self):
        """
Up to how many MPI steps should be checked.
"""
        return _pythia8.UserHooks_numberVetoMPIStep(self)

    def doVetoMPIStep(self, arg0, arg1):
        """
Decide whether to veto current event or not, based on event record.
Usage: doVetoMPIStep( nMPI, event), where nMPI is number of MPI's so far.
"""
        return _pythia8.UserHooks_doVetoMPIStep(self, arg0, arg1)

    def canVetoPartonLevelEarly(self):
        """
Possibility to veto event after ISR + FSR + MPI in parton level,
but before beam remnants and resonance decays.
"""
        return _pythia8.UserHooks_canVetoPartonLevelEarly(self)

    def doVetoPartonLevelEarly(self, arg0):
        """
Decide whether to veto current partons or not, based on event record.
Usage: doVetoPartonLevelEarly( event).
"""
        return _pythia8.UserHooks_doVetoPartonLevelEarly(self, arg0)

    def retryPartonLevel(self):
        """
Retry same ProcessLevel with a new PartonLevel after a veto in
doVetoPT, doVetoStep, doVetoMPIStep or doVetoPartonLevelEarly
if you overload this method to return true.
"""
        return _pythia8.UserHooks_retryPartonLevel(self)

    def canVetoPartonLevel(self):
        """
Possibility to veto event after parton-level selection.
"""
        return _pythia8.UserHooks_canVetoPartonLevel(self)

    def doVetoPartonLevel(self, arg0):
        """
Decide whether to veto current partons or not, based on event record.
Usage: doVetoPartonLevel( event).
"""
        return _pythia8.UserHooks_doVetoPartonLevel(self, arg0)

    def canSetResonanceScale(self):
        """
Possibility to set initial scale in TimeShower for resonance decay.
"""
        return _pythia8.UserHooks_canSetResonanceScale(self)

    def scaleResonance(self, arg0, arg1):
        """
Initial scale for TimeShower evolution.
Usage: scaleResonance( iRes, event), where iRes is location
of decaying resonance in the event record.
"""
        return _pythia8.UserHooks_scaleResonance(self, arg0, arg1)

    def canVetoISREmission(self):
        """
Possibility to veto an emission in the ISR machinery.
"""
        return _pythia8.UserHooks_canVetoISREmission(self)

    def doVetoISREmission(self, arg0, arg1, arg2):
        """
Decide whether to veto current emission or not, based on event record.
Usage: doVetoISREmission( sizeOld, event, iSys) where sizeOld is size
of event record before current emission-to-be-scrutinized was added,
and iSys is the system of the radiation (according to PartonSystems).
"""
        return _pythia8.UserHooks_doVetoISREmission(self, arg0, arg1, arg2)

    def canVetoFSREmission(self):
        """
Possibility to veto an emission in the FSR machinery.
"""
        return _pythia8.UserHooks_canVetoFSREmission(self)

    def doVetoFSREmission(self, arg0, arg1, arg2, arg3=False):
        """
Decide whether to veto current emission or not, based on event record.
Usage: doVetoFSREmission( sizeOld, event, iSys, inResonance) where
sizeOld is size of event record before current emission-to-be-scrutinized
was added, iSys is the system of the radiation (according to
PartonSystems), and inResonance is true if the emission takes place in a
resonance decay.
"""
        return _pythia8.UserHooks_doVetoFSREmission(self, arg0, arg1, arg2, arg3)

    def canVetoMPIEmission(self):
        """
Possibility to veto an MPI.
"""
        return _pythia8.UserHooks_canVetoMPIEmission(self)

    def doVetoMPIEmission(self, arg0, arg1):
        """
Decide whether to veto an MPI based on event record.
Usage: doVetoMPIEmission( sizeOld, event) where sizeOld
is size of event record before the current MPI.
"""
        return _pythia8.UserHooks_doVetoMPIEmission(self, arg0, arg1)

    def canReconnectResonanceSystems(self):
        """
Possibility to reconnect colours from resonance decay systems.
"""
        return _pythia8.UserHooks_canReconnectResonanceSystems(self)

    def doReconnectResonanceSystems(self, arg0, arg1):
        """
Do reconnect colours from resonance decay systems.
Usage: doVetoFSREmission( oldSizeEvt, event)
where oldSizeEvent is the event size before resonance decays.
Should normally return true, while false means serious failure.
Value of PartonLevel:earlyResDec determines where method is called.
"""
        return _pythia8.UserHooks_doReconnectResonanceSystems(self, arg0, arg1)

    def canEnhanceEmission(self):
        """
Enhance emission rates (sec. 4 in EPJC (2013) 73).
"""
        return _pythia8.UserHooks_canEnhanceEmission(self)

    def enhanceFactor(self, arg0):
        """
"""
        return _pythia8.UserHooks_enhanceFactor(self, arg0)

    def vetoProbability(self, arg0):
        """
"""
        return _pythia8.UserHooks_vetoProbability(self, arg0)

    def setEnhancedEventWeight(self, wt):
        """
"""
        return _pythia8.UserHooks_setEnhancedEventWeight(self, wt)

    def getEnhancedEventWeight(self):
        """
"""
        return _pythia8.UserHooks_getEnhancedEventWeight(self)

    def canEnhanceTrial(self):
        """
Bookkeeping of weights for enhanced actual or trial emissions
(sec. 3 in EPJC (2013) 73).
"""
        return _pythia8.UserHooks_canEnhanceTrial(self)

    def setEnhancedTrial(self, pTIn, wtIn):
        """
"""
        return _pythia8.UserHooks_setEnhancedTrial(self, pTIn, wtIn)

    def getEnhancedTrialPT(self):
        """
"""
        return _pythia8.UserHooks_getEnhancedTrialPT(self)

    def getEnhancedTrialWeight(self):
        """
"""
        return _pythia8.UserHooks_getEnhancedTrialWeight(self)

    def canChangeFragPar(self):
        """
Can change fragmentation parameters.
"""
        return _pythia8.UserHooks_canChangeFragPar(self)

    def setStringEnds(self, arg0, arg1, arg2):
        """
Set initial ends of a string to be fragmented. This is done once
for each string. Note that the second string end may be zero in case
we are hadronising a string piece leading to a junction.
"""
        return _pythia8.UserHooks_setStringEnds(self, arg0, arg1, arg2)

    def doChangeFragPar(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6):
        """
Do change fragmentation parameters.
Input: flavPtr, zPtr, pTPtr, idEnd, m2Had, iParton and posEnd (or
negEnd).
"""
        return _pythia8.UserHooks_doChangeFragPar(self, arg0, arg1, arg2, arg3, arg4, arg5, arg6)

    def doVetoFragmentation(self, *args):
        """
Do a veto on a hadron just before it is added to the final state
(final two hadron case).
"""
        return _pythia8.UserHooks_doVetoFragmentation(self, *args)

    def canSetImpactParameter(self):
        """
Can set the overall impact parameter for the MPI treatment.
"""
        return _pythia8.UserHooks_canSetImpactParameter(self)

    def doSetImpactParameter(self):
        """
Set the overall impact parameter for the MPI treatment.
"""
        return _pythia8.UserHooks_doSetImpactParameter(self)

    def __init__(self):
        """
Constructor.
"""
        if self.__class__ == UserHooks:
            _self = None
        else:
            _self = self
        this = _pythia8.new_UserHooks(_self, )
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["infoPtr"] = _pythia8.UserHooks_infoPtr_set
    __swig_getmethods__["infoPtr"] = _pythia8.UserHooks_infoPtr_get
    if _newclass:
        infoPtr = _swig_property(_pythia8.UserHooks_infoPtr_get, _pythia8.UserHooks_infoPtr_set)
    __swig_setmethods__["settingsPtr"] = _pythia8.UserHooks_settingsPtr_set
    __swig_getmethods__["settingsPtr"] = _pythia8.UserHooks_settingsPtr_get
    if _newclass:
        settingsPtr = _swig_property(_pythia8.UserHooks_settingsPtr_get, _pythia8.UserHooks_settingsPtr_set)
    __swig_setmethods__["particleDataPtr"] = _pythia8.UserHooks_particleDataPtr_set
    __swig_getmethods__["particleDataPtr"] = _pythia8.UserHooks_particleDataPtr_get
    if _newclass:
        particleDataPtr = _swig_property(_pythia8.UserHooks_particleDataPtr_get, _pythia8.UserHooks_particleDataPtr_set)
    __swig_setmethods__["rndmPtr"] = _pythia8.UserHooks_rndmPtr_set
    __swig_getmethods__["rndmPtr"] = _pythia8.UserHooks_rndmPtr_get
    if _newclass:
        rndmPtr = _swig_property(_pythia8.UserHooks_rndmPtr_get, _pythia8.UserHooks_rndmPtr_set)
    __swig_setmethods__["beamAPtr"] = _pythia8.UserHooks_beamAPtr_set
    __swig_getmethods__["beamAPtr"] = _pythia8.UserHooks_beamAPtr_get
    if _newclass:
        beamAPtr = _swig_property(_pythia8.UserHooks_beamAPtr_get, _pythia8.UserHooks_beamAPtr_set)
    __swig_setmethods__["beamBPtr"] = _pythia8.UserHooks_beamBPtr_set
    __swig_getmethods__["beamBPtr"] = _pythia8.UserHooks_beamBPtr_get
    if _newclass:
        beamBPtr = _swig_property(_pythia8.UserHooks_beamBPtr_get, _pythia8.UserHooks_beamBPtr_set)
    __swig_setmethods__["beamPomAPtr"] = _pythia8.UserHooks_beamPomAPtr_set
    __swig_getmethods__["beamPomAPtr"] = _pythia8.UserHooks_beamPomAPtr_get
    if _newclass:
        beamPomAPtr = _swig_property(_pythia8.UserHooks_beamPomAPtr_get, _pythia8.UserHooks_beamPomAPtr_set)
    __swig_setmethods__["beamPomBPtr"] = _pythia8.UserHooks_beamPomBPtr_set
    __swig_getmethods__["beamPomBPtr"] = _pythia8.UserHooks_beamPomBPtr_get
    if _newclass:
        beamPomBPtr = _swig_property(_pythia8.UserHooks_beamPomBPtr_get, _pythia8.UserHooks_beamPomBPtr_set)
    __swig_setmethods__["coupSMPtr"] = _pythia8.UserHooks_coupSMPtr_set
    __swig_getmethods__["coupSMPtr"] = _pythia8.UserHooks_coupSMPtr_get
    if _newclass:
        coupSMPtr = _swig_property(_pythia8.UserHooks_coupSMPtr_get, _pythia8.UserHooks_coupSMPtr_set)
    __swig_setmethods__["partonSystemsPtr"] = _pythia8.UserHooks_partonSystemsPtr_set
    __swig_getmethods__["partonSystemsPtr"] = _pythia8.UserHooks_partonSystemsPtr_get
    if _newclass:
        partonSystemsPtr = _swig_property(_pythia8.UserHooks_partonSystemsPtr_get, _pythia8.UserHooks_partonSystemsPtr_set)
    __swig_setmethods__["sigmaTotPtr"] = _pythia8.UserHooks_sigmaTotPtr_set
    __swig_getmethods__["sigmaTotPtr"] = _pythia8.UserHooks_sigmaTotPtr_get
    if _newclass:
        sigmaTotPtr = _swig_property(_pythia8.UserHooks_sigmaTotPtr_get, _pythia8.UserHooks_sigmaTotPtr_set)

    def omitResonanceDecays(self, process, finalOnly=False):
        """
Pointer to various information on the generation.
Pointer to the settings database.
Pointer to the particle data table.
Pointer to the random number generator.
Pointers to the two incoming beams and to Pomeron beam-inside-beam.
Pointers to Standard Model couplings.
Pointer to information on subcollision parton locations.
Pointer to the total/elastic/diffractive cross sections.
omitResonanceDecays omits resonance decay chains from process record.
"""
        return _pythia8.UserHooks_omitResonanceDecays(self, process, finalOnly)

    def subEvent(self, event, isHardest=True):
        """
subEvent extracts currently resolved partons in the hard process.
"""
        return _pythia8.UserHooks_subEvent(self, event, isHardest)
    __swig_setmethods__["workEvent"] = _pythia8.UserHooks_workEvent_set
    __swig_getmethods__["workEvent"] = _pythia8.UserHooks_workEvent_get
    if _newclass:
        workEvent = _swig_property(_pythia8.UserHooks_workEvent_get, _pythia8.UserHooks_workEvent_set)
    __swig_setmethods__["selBias"] = _pythia8.UserHooks_selBias_set
    __swig_getmethods__["selBias"] = _pythia8.UserHooks_selBias_get
    if _newclass:
        selBias = _swig_property(_pythia8.UserHooks_selBias_get, _pythia8.UserHooks_selBias_set)
    __swig_setmethods__["enhancedEventWeight"] = _pythia8.UserHooks_enhancedEventWeight_set
    __swig_getmethods__["enhancedEventWeight"] = _pythia8.UserHooks_enhancedEventWeight_get
    if _newclass:
        enhancedEventWeight = _swig_property(_pythia8.UserHooks_enhancedEventWeight_get, _pythia8.UserHooks_enhancedEventWeight_set)
    __swig_setmethods__["pTEnhanced"] = _pythia8.UserHooks_pTEnhanced_set
    __swig_getmethods__["pTEnhanced"] = _pythia8.UserHooks_pTEnhanced_get
    if _newclass:
        pTEnhanced = _swig_property(_pythia8.UserHooks_pTEnhanced_get, _pythia8.UserHooks_pTEnhanced_set)
    __swig_setmethods__["wtEnhanced"] = _pythia8.UserHooks_wtEnhanced_set
    __swig_getmethods__["wtEnhanced"] = _pythia8.UserHooks_wtEnhanced_get
    if _newclass:
        wtEnhanced = _swig_property(_pythia8.UserHooks_wtEnhanced_get, _pythia8.UserHooks_wtEnhanced_set)
    def __disown__(self):
        self.this.disown()
        _pythia8.disown_UserHooks(self)
        return weakref_proxy(self)
UserHooks_swigregister = _pythia8.UserHooks_swigregister
UserHooks_swigregister(UserHooks)

class SuppressSmallPT(UserHooks):
    """
SuppressSmallPT is a derived class for user access to program execution.
It is a simple example, illustrating how to suppress the cross section
of 2 -> 2 processes by a factor pT^4 / (pT0^2 + pT^2)^2, with pT0 input,
and also modify alpha_strong scale similarly.
"""
    __swig_setmethods__ = {}
    for _s in [UserHooks]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, SuppressSmallPT, name, value)
    __swig_getmethods__ = {}
    for _s in [UserHooks]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, SuppressSmallPT, name)
    __repr__ = _swig_repr

    def __init__(self, pT0timesMPIIn=1., numberAlphaSIn=0, useSameAlphaSasMPIIn=True):
        """
Constructor.
"""
        this = _pythia8.new_SuppressSmallPT(pT0timesMPIIn, numberAlphaSIn, useSameAlphaSasMPIIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def canModifySigma(self):
        """
Possibility to modify cross section of process.
"""
        return _pythia8.SuppressSmallPT_canModifySigma(self)

    def multiplySigmaBy(self, sigmaProcessPtr, phaseSpacePtr, arg4):
        """
Multiplicative factor modifying the cross section of a hard process.
Usage: inEvent is true for event generation, false for initialization.
"""
        return _pythia8.SuppressSmallPT_multiplySigmaBy(self, sigmaProcessPtr, phaseSpacePtr, arg4)
    __swig_destroy__ = _pythia8.delete_SuppressSmallPT
    __del__ = lambda self: None
SuppressSmallPT_swigregister = _pythia8.SuppressSmallPT_swigregister
SuppressSmallPT_swigregister(SuppressSmallPT)

class UserHooksVector(UserHooks):
    __swig_setmethods__ = {}
    for _s in [UserHooks]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, UserHooksVector, name, value)
    __swig_getmethods__ = {}
    for _s in [UserHooks]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, UserHooksVector, name)

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _pythia8.delete_UserHooksVector
    __del__ = lambda self: None

    def initAfterBeams(self):
        return _pythia8.UserHooksVector_initAfterBeams(self)

    def canModifySigma(self):
        return _pythia8.UserHooksVector_canModifySigma(self)

    def multiplySigmaBy(self, sigmaProcessPtr, phaseSpacePtr, inEvent):
        return _pythia8.UserHooksVector_multiplySigmaBy(self, sigmaProcessPtr, phaseSpacePtr, inEvent)

    def canBiasSelection(self):
        return _pythia8.UserHooksVector_canBiasSelection(self)

    def biasSelectionBy(self, sigmaProcessPtr, phaseSpacePtr, inEvent):
        return _pythia8.UserHooksVector_biasSelectionBy(self, sigmaProcessPtr, phaseSpacePtr, inEvent)

    def biasedSelectionWeight(self):
        return _pythia8.UserHooksVector_biasedSelectionWeight(self)

    def canVetoProcessLevel(self):
        return _pythia8.UserHooksVector_canVetoProcessLevel(self)

    def doVetoProcessLevel(self, e):
        return _pythia8.UserHooksVector_doVetoProcessLevel(self, e)

    def canVetoResonanceDecays(self):
        return _pythia8.UserHooksVector_canVetoResonanceDecays(self)

    def doVetoResonanceDecays(self, e):
        return _pythia8.UserHooksVector_doVetoResonanceDecays(self, e)

    def canVetoPT(self):
        return _pythia8.UserHooksVector_canVetoPT(self)

    def scaleVetoPT(self):
        return _pythia8.UserHooksVector_scaleVetoPT(self)

    def doVetoPT(self, iPos, e):
        return _pythia8.UserHooksVector_doVetoPT(self, iPos, e)

    def canVetoStep(self):
        return _pythia8.UserHooksVector_canVetoStep(self)

    def numberVetoStep(self):
        return _pythia8.UserHooksVector_numberVetoStep(self)

    def doVetoStep(self, iPos, nISR, nFSR, e):
        return _pythia8.UserHooksVector_doVetoStep(self, iPos, nISR, nFSR, e)

    def canVetoMPIStep(self):
        return _pythia8.UserHooksVector_canVetoMPIStep(self)

    def numberVetoMPIStep(self):
        return _pythia8.UserHooksVector_numberVetoMPIStep(self)

    def doVetoMPIStep(self, nMPI, e):
        return _pythia8.UserHooksVector_doVetoMPIStep(self, nMPI, e)

    def canVetoPartonLevelEarly(self):
        return _pythia8.UserHooksVector_canVetoPartonLevelEarly(self)

    def doVetoPartonLevelEarly(self, e):
        return _pythia8.UserHooksVector_doVetoPartonLevelEarly(self, e)

    def retryPartonLevel(self):
        return _pythia8.UserHooksVector_retryPartonLevel(self)

    def canVetoPartonLevel(self):
        return _pythia8.UserHooksVector_canVetoPartonLevel(self)

    def doVetoPartonLevel(self, e):
        return _pythia8.UserHooksVector_doVetoPartonLevel(self, e)

    def canSetResonanceScale(self):
        return _pythia8.UserHooksVector_canSetResonanceScale(self)

    def scaleResonance(self, iRes, e):
        return _pythia8.UserHooksVector_scaleResonance(self, iRes, e)

    def canVetoISREmission(self):
        return _pythia8.UserHooksVector_canVetoISREmission(self)

    def doVetoISREmission(self, sizeOld, e, iSys):
        return _pythia8.UserHooksVector_doVetoISREmission(self, sizeOld, e, iSys)

    def canVetoFSREmission(self):
        return _pythia8.UserHooksVector_canVetoFSREmission(self)

    def doVetoFSREmission(self, sizeOld, e, iSys, inResonance=False):
        return _pythia8.UserHooksVector_doVetoFSREmission(self, sizeOld, e, iSys, inResonance)

    def canVetoMPIEmission(self):
        return _pythia8.UserHooksVector_canVetoMPIEmission(self)

    def doVetoMPIEmission(self, sizeOld, e):
        return _pythia8.UserHooksVector_doVetoMPIEmission(self, sizeOld, e)

    def canReconnectResonanceSystems(self):
        return _pythia8.UserHooksVector_canReconnectResonanceSystems(self)

    def doReconnectResonanceSystems(self, j, e):
        return _pythia8.UserHooksVector_doReconnectResonanceSystems(self, j, e)

    def canEnhanceEmission(self):
        return _pythia8.UserHooksVector_canEnhanceEmission(self)

    def enhanceFactor(self, s):
        return _pythia8.UserHooksVector_enhanceFactor(self, s)

    def vetoProbability(self, s):
        return _pythia8.UserHooksVector_vetoProbability(self, s)

    def canEnhanceTrial(self):
        return _pythia8.UserHooksVector_canEnhanceTrial(self)

    def canChangeFragPar(self):
        return _pythia8.UserHooksVector_canChangeFragPar(self)

    def doVetoFragmentation(self, *args):
        return _pythia8.UserHooksVector_doVetoFragmentation(self, *args)

    def canSetImpactParameter(self):
        return _pythia8.UserHooksVector_canSetImpactParameter(self)

    def doSetImpactParameter(self):
        return _pythia8.UserHooksVector_doSetImpactParameter(self)
    __swig_setmethods__["hooks"] = _pythia8.UserHooksVector_hooks_set
    __swig_getmethods__["hooks"] = _pythia8.UserHooksVector_hooks_get
    if _newclass:
        hooks = _swig_property(_pythia8.UserHooksVector_hooks_get, _pythia8.UserHooksVector_hooks_set)
UserHooksVector_swigregister = _pythia8.UserHooksVector_swigregister
UserHooksVector_swigregister(UserHooksVector)

class SigmaMultiparton(_object):
    """
SigmaMultiparton is a helper class to MultipartonInteractions.
It packs pointers to the allowed processes for different
flavour combinations and levels of ambition.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, SigmaMultiparton, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, SigmaMultiparton, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_SigmaMultiparton()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_SigmaMultiparton
    __del__ = lambda self: None

    def init(self, inState, processLevel, infoPtr, settingsPtr, particleDataPtr, rndmPtrIn, beamAPtr, beamBPtr, couplingsPtr):
        """
Initialize list of processes.
"""
        return _pythia8.SigmaMultiparton_init(self, inState, processLevel, infoPtr, settingsPtr, particleDataPtr, rndmPtrIn, beamAPtr, beamBPtr, couplingsPtr)

    def sigma(self, id1, id2, x1, x2, sHat, tHat, uHat, alpS, alpEM, restore=False, pickOtherIn=False):
        """
Calculate cross section summed over possibilities.
"""
        return _pythia8.SigmaMultiparton_sigma(self, id1, id2, x1, x2, sHat, tHat, uHat, alpS, alpEM, restore, pickOtherIn)

    def pickedOther(self):
        """
Return whether the other, rare processes were selected.
"""
        return _pythia8.SigmaMultiparton_pickedOther(self)

    def sigmaSel(self):
        """
Return one subprocess, picked according to relative cross sections.
"""
        return _pythia8.SigmaMultiparton_sigmaSel(self)

    def swapTU(self):
        """
"""
        return _pythia8.SigmaMultiparton_swapTU(self)

    def nProc(self):
        """
Return code or name of a specified process, for statistics table.
"""
        return _pythia8.SigmaMultiparton_nProc(self)

    def codeProc(self, iProc):
        """
"""
        return _pythia8.SigmaMultiparton_codeProc(self, iProc)

    def nameProc(self, iProc):
        """
"""
        return _pythia8.SigmaMultiparton_nameProc(self, iProc)
SigmaMultiparton_swigregister = _pythia8.SigmaMultiparton_swigregister
SigmaMultiparton_swigregister(SigmaMultiparton)

class MultipartonInteractions(_object):
    """
The MultipartonInteractions class contains the main methods for the
generation of multiparton parton-parton interactions in hadronic collisions.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, MultipartonInteractions, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, MultipartonInteractions, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_MultipartonInteractions()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def init(self, doMPIinit, iDiffSysIn, infoPtrIn, settings, particleDataPtr, rndmPtrIn, beamAPtrIn, beamBPtrIn, couplingsPtrIn, partonSystemsPtrIn, sigmaTotPtrIn, userHooksPtrIn, partonVertexPtrIn, hasGammaIn=False):
        """
Initialize the generation process for given beams.
"""
        return _pythia8.MultipartonInteractions_init(self, doMPIinit, iDiffSysIn, infoPtrIn, settings, particleDataPtr, rndmPtrIn, beamAPtrIn, beamBPtrIn, couplingsPtrIn, partonSystemsPtrIn, sigmaTotPtrIn, userHooksPtrIn, partonVertexPtrIn, hasGammaIn)

    def reset(self):
        """
Reset impact parameter choice and update the CM energy.
"""
        return _pythia8.MultipartonInteractions_reset(self)

    def pTfirst(self):
        """
Select first = hardest pT in nondiffractive process.
"""
        return _pythia8.MultipartonInteractions_pTfirst(self)

    def setupFirstSys(self, process):
        """
Set up kinematics for first = hardest pT in nondiffractive process.
"""
        return _pythia8.MultipartonInteractions_setupFirstSys(self, process)

    def limitPTmax(self, event):
        """
Find whether to limit maximum scale of emissions.
Provide sum pT / 2 as potential limit where relevant.
"""
        return _pythia8.MultipartonInteractions_limitPTmax(self, event)

    def scaleLimitPT(self):
        """
"""
        return _pythia8.MultipartonInteractions_scaleLimitPT(self)

    def prepare(self, event, pTscale=1000., rehashB=False):
        """
Prepare system for evolution.
"""
        return _pythia8.MultipartonInteractions_prepare(self, event, pTscale, rehashB)

    def pTnext(self, pTbegAll, pTendAll, event):
        """
Select next pT in downwards evolution.
"""
        return _pythia8.MultipartonInteractions_pTnext(self, pTbegAll, pTendAll, event)

    def scatter(self, event):
        """
Set up kinematics of acceptable interaction.
"""
        return _pythia8.MultipartonInteractions_scatter(self, event)

    def setEmpty(self):
        """
Set "empty" values to avoid query of undefined quantities.
"""
        return _pythia8.MultipartonInteractions_setEmpty(self)

    def Q2Ren(self):
        """
Get some information on current interaction.
"""
        return _pythia8.MultipartonInteractions_Q2Ren(self)

    def alphaSH(self):
        """
"""
        return _pythia8.MultipartonInteractions_alphaSH(self)

    def alphaEMH(self):
        """
"""
        return _pythia8.MultipartonInteractions_alphaEMH(self)

    def x1H(self):
        """
"""
        return _pythia8.MultipartonInteractions_x1H(self)

    def x2H(self):
        """
"""
        return _pythia8.MultipartonInteractions_x2H(self)

    def Q2Fac(self):
        """
"""
        return _pythia8.MultipartonInteractions_Q2Fac(self)

    def pdf1(self):
        """
"""
        return _pythia8.MultipartonInteractions_pdf1(self)

    def pdf2(self):
        """
"""
        return _pythia8.MultipartonInteractions_pdf2(self)

    def bMPI(self):
        """
"""
        return _pythia8.MultipartonInteractions_bMPI(self)

    def enhanceMPI(self):
        """
"""
        return _pythia8.MultipartonInteractions_enhanceMPI(self)

    def enhanceMPIavg(self):
        """
"""
        return _pythia8.MultipartonInteractions_enhanceMPIavg(self)

    def getVSC1(self):
        """
For x-dependent matter profile, return incoming valence/sea
decision from trial interactions.
"""
        return _pythia8.MultipartonInteractions_getVSC1(self)

    def getVSC2(self):
        """
"""
        return _pythia8.MultipartonInteractions_getVSC2(self)

    def getBeamOffset(self):
        """
Set the offset wrt. to normal beam particle positions for hard diffraction
and for photon beam from lepton.
"""
        return _pythia8.MultipartonInteractions_getBeamOffset(self)

    def setBeamOffset(self, offsetIn):
        """
"""
        return _pythia8.MultipartonInteractions_setBeamOffset(self, offsetIn)

    def accumulate(self):
        """
Update and print statistics on number of processes.
Note: currently only valid for nondiffractive systems, not diffraction??
"""
        return _pythia8.MultipartonInteractions_accumulate(self)

    def statistics(self, resetStat=False):
        """
"""
        return _pythia8.MultipartonInteractions_statistics(self, resetStat)

    def resetStatistics(self):
        """
"""
        return _pythia8.MultipartonInteractions_resetStatistics(self)
    __swig_destroy__ = _pythia8.delete_MultipartonInteractions
    __del__ = lambda self: None
MultipartonInteractions_swigregister = _pythia8.MultipartonInteractions_swigregister
MultipartonInteractions_swigregister(MultipartonInteractions)

class PhaseSpace(_object):
    """
Pointer to various information on the generation.
Pointer to the settings database.
Pointer to the random number generator.
Data related to currently implemented models.
Current values.
"""
    __swig_setmethods__ = {}
    __setattr__ = lambda self, name, value: _swig_setattr(self, PhaseSpace, name, value)
    __swig_getmethods__ = {}
    __getattr__ = lambda self, name: _swig_getattr(self, PhaseSpace, name)
    __repr__ = _swig_repr
    __swig_destroy__ = _pythia8.delete_PhaseSpace
    __del__ = lambda self: None

    def init(self, isFirst, sigmaProcessPtrIn, infoPtrIn, settingsPtrIn, particleDataPtrIn, rndmPtrIn, beamAPtrIn, beamBPtrIn, couplingsPtrIn, sigmaTotPtrIn, userHooksPtrIn):
        """
Perform simple initialization and store pointers.
"""
        return _pythia8.PhaseSpace_init(self, isFirst, sigmaProcessPtrIn, infoPtrIn, settingsPtrIn, particleDataPtrIn, rndmPtrIn, beamAPtrIn, beamBPtrIn, couplingsPtrIn, sigmaTotPtrIn, userHooksPtrIn)

    def newECM(self, eCMin):
        """
Update the CM energy of the event.
"""
        return _pythia8.PhaseSpace_newECM(self, eCMin)

    def setLHAPtr(self, lhaUpPtrIn):
        """
Store or replace Les Houches pointer.
"""
        return _pythia8.PhaseSpace_setLHAPtr(self, lhaUpPtrIn)

    def setupSampling(self):
        """
A pure virtual method, wherein an optimization procedure
is used to determine how phase space should be sampled.
"""
        return _pythia8.PhaseSpace_setupSampling(self)

    def trialKin(self, inEvent=True, repeatSame=False):
        """
A pure virtual method, wherein a trial event kinematics
is to be selected in the derived class.
"""
        return _pythia8.PhaseSpace_trialKin(self, inEvent, repeatSame)

    def finalKin(self):
        """
A pure virtual method, wherein the accepted event kinematics
is to be constructed in the derived class.
"""
        return _pythia8.PhaseSpace_finalKin(self)

    def decayKinematics(self, process):
        """
Allow for nonisotropic decays when ME's available.
"""
        return _pythia8.PhaseSpace_decayKinematics(self, process)

    def sigmaNow(self):
        """
Give back current or maximum cross section, or set latter.
"""
        return _pythia8.PhaseSpace_sigmaNow(self)

    def sigmaMax(self):
        """
"""
        return _pythia8.PhaseSpace_sigmaMax(self)

    def biasSelectionWeight(self):
        """
"""
        return _pythia8.PhaseSpace_biasSelectionWeight(self)

    def newSigmaMax(self):
        """
"""
        return _pythia8.PhaseSpace_newSigmaMax(self)

    def setSigmaMax(self, sigmaMaxIn):
        """
"""
        return _pythia8.PhaseSpace_setSigmaMax(self, sigmaMaxIn)

    def sigmaSumSigned(self):
        """
For Les Houches with negative event weight needs
"""
        return _pythia8.PhaseSpace_sigmaSumSigned(self)

    def p(self, i):
        """
Give back constructed four-vectors and known masses.
"""
        return _pythia8.PhaseSpace_p(self, i)

    def m(self, i):
        """
"""
        return _pythia8.PhaseSpace_m(self, i)

    def setP(self, i, pNew):
        """
Reset the four-momentum.
"""
        return _pythia8.PhaseSpace_setP(self, i, pNew)

    def ecm(self):
        """
Give back other event properties.
"""
        return _pythia8.PhaseSpace_ecm(self)

    def x1(self):
        """
"""
        return _pythia8.PhaseSpace_x1(self)

    def x2(self):
        """
"""
        return _pythia8.PhaseSpace_x2(self)

    def sHat(self):
        """
"""
        return _pythia8.PhaseSpace_sHat(self)

    def tHat(self):
        """
"""
        return _pythia8.PhaseSpace_tHat(self)

    def uHat(self):
        """
"""
        return _pythia8.PhaseSpace_uHat(self)

    def pTHat(self):
        """
"""
        return _pythia8.PhaseSpace_pTHat(self)

    def thetaHat(self):
        """
"""
        return _pythia8.PhaseSpace_thetaHat(self)

    def phiHat(self):
        """
"""
        return _pythia8.PhaseSpace_phiHat(self)

    def runBW3(self):
        """
"""
        return _pythia8.PhaseSpace_runBW3(self)

    def runBW4(self):
        """
"""
        return _pythia8.PhaseSpace_runBW4(self)

    def runBW5(self):
        """
"""
        return _pythia8.PhaseSpace_runBW5(self)

    def isResolved(self):
        """
Inform whether beam particles are resolved in partons or scatter directly.
"""
        return _pythia8.PhaseSpace_isResolved(self)

    def rescaleSigma(self, arg0):
        """
Functions to rescale momenta and cross section for new sHat
Currently implemented only for PhaseSpace2to2tauyz class.
"""
        return _pythia8.PhaseSpace_rescaleSigma(self, arg0)

    def rescaleMomenta(self, arg0):
        """
"""
        return _pythia8.PhaseSpace_rescaleMomenta(self, arg0)

    def weightGammaPDFApprox(self):
        """
Calculate the weight for over-estimated cross section.
"""
        return _pythia8.PhaseSpace_weightGammaPDFApprox(self)

    def setGammaKinPtr(self, gammaKinPtrIn):
        """
Set the GammaKinematics pointer needed for soft photoproduction.
"""
        return _pythia8.PhaseSpace_setGammaKinPtr(self, gammaKinPtrIn)

    def __init__(self):
        """
Constructor.
"""
        if self.__class__ == PhaseSpace:
            _self = None
        else:
            _self = self
        this = _pythia8.new_PhaseSpace(_self, )
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_setmethods__["sigmaProcessPtr"] = _pythia8.PhaseSpace_sigmaProcessPtr_set
    __swig_getmethods__["sigmaProcessPtr"] = _pythia8.PhaseSpace_sigmaProcessPtr_get
    if _newclass:
        sigmaProcessPtr = _swig_property(_pythia8.PhaseSpace_sigmaProcessPtr_get, _pythia8.PhaseSpace_sigmaProcessPtr_set)
    __swig_setmethods__["infoPtr"] = _pythia8.PhaseSpace_infoPtr_set
    __swig_getmethods__["infoPtr"] = _pythia8.PhaseSpace_infoPtr_get
    if _newclass:
        infoPtr = _swig_property(_pythia8.PhaseSpace_infoPtr_get, _pythia8.PhaseSpace_infoPtr_set)
    __swig_setmethods__["settingsPtr"] = _pythia8.PhaseSpace_settingsPtr_set
    __swig_getmethods__["settingsPtr"] = _pythia8.PhaseSpace_settingsPtr_get
    if _newclass:
        settingsPtr = _swig_property(_pythia8.PhaseSpace_settingsPtr_get, _pythia8.PhaseSpace_settingsPtr_set)
    __swig_setmethods__["particleDataPtr"] = _pythia8.PhaseSpace_particleDataPtr_set
    __swig_getmethods__["particleDataPtr"] = _pythia8.PhaseSpace_particleDataPtr_get
    if _newclass:
        particleDataPtr = _swig_property(_pythia8.PhaseSpace_particleDataPtr_get, _pythia8.PhaseSpace_particleDataPtr_set)
    __swig_setmethods__["rndmPtr"] = _pythia8.PhaseSpace_rndmPtr_set
    __swig_getmethods__["rndmPtr"] = _pythia8.PhaseSpace_rndmPtr_get
    if _newclass:
        rndmPtr = _swig_property(_pythia8.PhaseSpace_rndmPtr_get, _pythia8.PhaseSpace_rndmPtr_set)
    __swig_setmethods__["beamAPtr"] = _pythia8.PhaseSpace_beamAPtr_set
    __swig_getmethods__["beamAPtr"] = _pythia8.PhaseSpace_beamAPtr_get
    if _newclass:
        beamAPtr = _swig_property(_pythia8.PhaseSpace_beamAPtr_get, _pythia8.PhaseSpace_beamAPtr_set)
    __swig_setmethods__["beamBPtr"] = _pythia8.PhaseSpace_beamBPtr_set
    __swig_getmethods__["beamBPtr"] = _pythia8.PhaseSpace_beamBPtr_get
    if _newclass:
        beamBPtr = _swig_property(_pythia8.PhaseSpace_beamBPtr_get, _pythia8.PhaseSpace_beamBPtr_set)
    __swig_setmethods__["couplingsPtr"] = _pythia8.PhaseSpace_couplingsPtr_set
    __swig_getmethods__["couplingsPtr"] = _pythia8.PhaseSpace_couplingsPtr_get
    if _newclass:
        couplingsPtr = _swig_property(_pythia8.PhaseSpace_couplingsPtr_get, _pythia8.PhaseSpace_couplingsPtr_set)
    __swig_setmethods__["sigmaTotPtr"] = _pythia8.PhaseSpace_sigmaTotPtr_set
    __swig_getmethods__["sigmaTotPtr"] = _pythia8.PhaseSpace_sigmaTotPtr_get
    if _newclass:
        sigmaTotPtr = _swig_property(_pythia8.PhaseSpace_sigmaTotPtr_get, _pythia8.PhaseSpace_sigmaTotPtr_set)
    __swig_setmethods__["userHooksPtr"] = _pythia8.PhaseSpace_userHooksPtr_set
    __swig_getmethods__["userHooksPtr"] = _pythia8.PhaseSpace_userHooksPtr_get
    if _newclass:
        userHooksPtr = _swig_property(_pythia8.PhaseSpace_userHooksPtr_get, _pythia8.PhaseSpace_userHooksPtr_set)
    __swig_setmethods__["lhaUpPtr"] = _pythia8.PhaseSpace_lhaUpPtr_set
    __swig_getmethods__["lhaUpPtr"] = _pythia8.PhaseSpace_lhaUpPtr_get
    if _newclass:
        lhaUpPtr = _swig_property(_pythia8.PhaseSpace_lhaUpPtr_get, _pythia8.PhaseSpace_lhaUpPtr_set)
    __swig_setmethods__["gammaKinPtr"] = _pythia8.PhaseSpace_gammaKinPtr_set
    __swig_getmethods__["gammaKinPtr"] = _pythia8.PhaseSpace_gammaKinPtr_get
    if _newclass:
        gammaKinPtr = _swig_property(_pythia8.PhaseSpace_gammaKinPtr_get, _pythia8.PhaseSpace_gammaKinPtr_set)
    __swig_setmethods__["useBreitWigners"] = _pythia8.PhaseSpace_useBreitWigners_set
    __swig_getmethods__["useBreitWigners"] = _pythia8.PhaseSpace_useBreitWigners_get
    if _newclass:
        useBreitWigners = _swig_property(_pythia8.PhaseSpace_useBreitWigners_get, _pythia8.PhaseSpace_useBreitWigners_set)
    __swig_setmethods__["doEnergySpread"] = _pythia8.PhaseSpace_doEnergySpread_set
    __swig_getmethods__["doEnergySpread"] = _pythia8.PhaseSpace_doEnergySpread_get
    if _newclass:
        doEnergySpread = _swig_property(_pythia8.PhaseSpace_doEnergySpread_get, _pythia8.PhaseSpace_doEnergySpread_set)
    __swig_setmethods__["showSearch"] = _pythia8.PhaseSpace_showSearch_set
    __swig_getmethods__["showSearch"] = _pythia8.PhaseSpace_showSearch_get
    if _newclass:
        showSearch = _swig_property(_pythia8.PhaseSpace_showSearch_get, _pythia8.PhaseSpace_showSearch_set)
    __swig_setmethods__["showViolation"] = _pythia8.PhaseSpace_showViolation_set
    __swig_getmethods__["showViolation"] = _pythia8.PhaseSpace_showViolation_get
    if _newclass:
        showViolation = _swig_property(_pythia8.PhaseSpace_showViolation_get, _pythia8.PhaseSpace_showViolation_set)
    __swig_setmethods__["increaseMaximum"] = _pythia8.PhaseSpace_increaseMaximum_set
    __swig_getmethods__["increaseMaximum"] = _pythia8.PhaseSpace_increaseMaximum_get
    if _newclass:
        increaseMaximum = _swig_property(_pythia8.PhaseSpace_increaseMaximum_get, _pythia8.PhaseSpace_increaseMaximum_set)
    __swig_setmethods__["hasQ2Min"] = _pythia8.PhaseSpace_hasQ2Min_set
    __swig_getmethods__["hasQ2Min"] = _pythia8.PhaseSpace_hasQ2Min_get
    if _newclass:
        hasQ2Min = _swig_property(_pythia8.PhaseSpace_hasQ2Min_get, _pythia8.PhaseSpace_hasQ2Min_set)
    __swig_setmethods__["gmZmodeGlobal"] = _pythia8.PhaseSpace_gmZmodeGlobal_set
    __swig_getmethods__["gmZmodeGlobal"] = _pythia8.PhaseSpace_gmZmodeGlobal_get
    if _newclass:
        gmZmodeGlobal = _swig_property(_pythia8.PhaseSpace_gmZmodeGlobal_get, _pythia8.PhaseSpace_gmZmodeGlobal_set)
    __swig_setmethods__["mHatGlobalMin"] = _pythia8.PhaseSpace_mHatGlobalMin_set
    __swig_getmethods__["mHatGlobalMin"] = _pythia8.PhaseSpace_mHatGlobalMin_get
    if _newclass:
        mHatGlobalMin = _swig_property(_pythia8.PhaseSpace_mHatGlobalMin_get, _pythia8.PhaseSpace_mHatGlobalMin_set)
    __swig_setmethods__["mHatGlobalMax"] = _pythia8.PhaseSpace_mHatGlobalMax_set
    __swig_getmethods__["mHatGlobalMax"] = _pythia8.PhaseSpace_mHatGlobalMax_get
    if _newclass:
        mHatGlobalMax = _swig_property(_pythia8.PhaseSpace_mHatGlobalMax_get, _pythia8.PhaseSpace_mHatGlobalMax_set)
    __swig_setmethods__["pTHatGlobalMin"] = _pythia8.PhaseSpace_pTHatGlobalMin_set
    __swig_getmethods__["pTHatGlobalMin"] = _pythia8.PhaseSpace_pTHatGlobalMin_get
    if _newclass:
        pTHatGlobalMin = _swig_property(_pythia8.PhaseSpace_pTHatGlobalMin_get, _pythia8.PhaseSpace_pTHatGlobalMin_set)
    __swig_setmethods__["pTHatGlobalMax"] = _pythia8.PhaseSpace_pTHatGlobalMax_set
    __swig_getmethods__["pTHatGlobalMax"] = _pythia8.PhaseSpace_pTHatGlobalMax_get
    if _newclass:
        pTHatGlobalMax = _swig_property(_pythia8.PhaseSpace_pTHatGlobalMax_get, _pythia8.PhaseSpace_pTHatGlobalMax_set)
    __swig_setmethods__["Q2GlobalMin"] = _pythia8.PhaseSpace_Q2GlobalMin_set
    __swig_getmethods__["Q2GlobalMin"] = _pythia8.PhaseSpace_Q2GlobalMin_get
    if _newclass:
        Q2GlobalMin = _swig_property(_pythia8.PhaseSpace_Q2GlobalMin_get, _pythia8.PhaseSpace_Q2GlobalMin_set)
    __swig_setmethods__["pTHatMinDiverge"] = _pythia8.PhaseSpace_pTHatMinDiverge_set
    __swig_getmethods__["pTHatMinDiverge"] = _pythia8.PhaseSpace_pTHatMinDiverge_get
    if _newclass:
        pTHatMinDiverge = _swig_property(_pythia8.PhaseSpace_pTHatMinDiverge_get, _pythia8.PhaseSpace_pTHatMinDiverge_set)
    __swig_setmethods__["minWidthBreitWigners"] = _pythia8.PhaseSpace_minWidthBreitWigners_set
    __swig_getmethods__["minWidthBreitWigners"] = _pythia8.PhaseSpace_minWidthBreitWigners_get
    if _newclass:
        minWidthBreitWigners = _swig_property(_pythia8.PhaseSpace_minWidthBreitWigners_get, _pythia8.PhaseSpace_minWidthBreitWigners_set)
    __swig_setmethods__["minWidthNarrowBW"] = _pythia8.PhaseSpace_minWidthNarrowBW_set
    __swig_getmethods__["minWidthNarrowBW"] = _pythia8.PhaseSpace_minWidthNarrowBW_get
    if _newclass:
        minWidthNarrowBW = _swig_property(_pythia8.PhaseSpace_minWidthNarrowBW_get, _pythia8.PhaseSpace_minWidthNarrowBW_set)
    __swig_setmethods__["idA"] = _pythia8.PhaseSpace_idA_set
    __swig_getmethods__["idA"] = _pythia8.PhaseSpace_idA_get
    if _newclass:
        idA = _swig_property(_pythia8.PhaseSpace_idA_get, _pythia8.PhaseSpace_idA_set)
    __swig_setmethods__["idB"] = _pythia8.PhaseSpace_idB_set
    __swig_getmethods__["idB"] = _pythia8.PhaseSpace_idB_get
    if _newclass:
        idB = _swig_property(_pythia8.PhaseSpace_idB_get, _pythia8.PhaseSpace_idB_set)
    __swig_setmethods__["idAgm"] = _pythia8.PhaseSpace_idAgm_set
    __swig_getmethods__["idAgm"] = _pythia8.PhaseSpace_idAgm_get
    if _newclass:
        idAgm = _swig_property(_pythia8.PhaseSpace_idAgm_get, _pythia8.PhaseSpace_idAgm_set)
    __swig_setmethods__["idBgm"] = _pythia8.PhaseSpace_idBgm_set
    __swig_getmethods__["idBgm"] = _pythia8.PhaseSpace_idBgm_get
    if _newclass:
        idBgm = _swig_property(_pythia8.PhaseSpace_idBgm_get, _pythia8.PhaseSpace_idBgm_set)
    __swig_setmethods__["mA"] = _pythia8.PhaseSpace_mA_set
    __swig_getmethods__["mA"] = _pythia8.PhaseSpace_mA_get
    if _newclass:
        mA = _swig_property(_pythia8.PhaseSpace_mA_get, _pythia8.PhaseSpace_mA_set)
    __swig_setmethods__["mB"] = _pythia8.PhaseSpace_mB_set
    __swig_getmethods__["mB"] = _pythia8.PhaseSpace_mB_get
    if _newclass:
        mB = _swig_property(_pythia8.PhaseSpace_mB_get, _pythia8.PhaseSpace_mB_set)
    __swig_setmethods__["eCM"] = _pythia8.PhaseSpace_eCM_set
    __swig_getmethods__["eCM"] = _pythia8.PhaseSpace_eCM_get
    if _newclass:
        eCM = _swig_property(_pythia8.PhaseSpace_eCM_get, _pythia8.PhaseSpace_eCM_set)
    __swig_setmethods__["s"] = _pythia8.PhaseSpace_s_set
    __swig_getmethods__["s"] = _pythia8.PhaseSpace_s_get
    if _newclass:
        s = _swig_property(_pythia8.PhaseSpace_s_get, _pythia8.PhaseSpace_s_set)
    __swig_setmethods__["sigmaMxGm"] = _pythia8.PhaseSpace_sigmaMxGm_set
    __swig_getmethods__["sigmaMxGm"] = _pythia8.PhaseSpace_sigmaMxGm_get
    if _newclass:
        sigmaMxGm = _swig_property(_pythia8.PhaseSpace_sigmaMxGm_get, _pythia8.PhaseSpace_sigmaMxGm_set)
    __swig_setmethods__["hasLeptonBeamA"] = _pythia8.PhaseSpace_hasLeptonBeamA_set
    __swig_getmethods__["hasLeptonBeamA"] = _pythia8.PhaseSpace_hasLeptonBeamA_get
    if _newclass:
        hasLeptonBeamA = _swig_property(_pythia8.PhaseSpace_hasLeptonBeamA_get, _pythia8.PhaseSpace_hasLeptonBeamA_set)
    __swig_setmethods__["hasLeptonBeamB"] = _pythia8.PhaseSpace_hasLeptonBeamB_set
    __swig_getmethods__["hasLeptonBeamB"] = _pythia8.PhaseSpace_hasLeptonBeamB_get
    if _newclass:
        hasLeptonBeamB = _swig_property(_pythia8.PhaseSpace_hasLeptonBeamB_get, _pythia8.PhaseSpace_hasLeptonBeamB_set)
    __swig_setmethods__["hasOneLeptonBeam"] = _pythia8.PhaseSpace_hasOneLeptonBeam_set
    __swig_getmethods__["hasOneLeptonBeam"] = _pythia8.PhaseSpace_hasOneLeptonBeam_get
    if _newclass:
        hasOneLeptonBeam = _swig_property(_pythia8.PhaseSpace_hasOneLeptonBeam_get, _pythia8.PhaseSpace_hasOneLeptonBeam_set)
    __swig_setmethods__["hasTwoLeptonBeams"] = _pythia8.PhaseSpace_hasTwoLeptonBeams_set
    __swig_getmethods__["hasTwoLeptonBeams"] = _pythia8.PhaseSpace_hasTwoLeptonBeams_get
    if _newclass:
        hasTwoLeptonBeams = _swig_property(_pythia8.PhaseSpace_hasTwoLeptonBeams_get, _pythia8.PhaseSpace_hasTwoLeptonBeams_set)
    __swig_setmethods__["hasPointGammaA"] = _pythia8.PhaseSpace_hasPointGammaA_set
    __swig_getmethods__["hasPointGammaA"] = _pythia8.PhaseSpace_hasPointGammaA_get
    if _newclass:
        hasPointGammaA = _swig_property(_pythia8.PhaseSpace_hasPointGammaA_get, _pythia8.PhaseSpace_hasPointGammaA_set)
    __swig_setmethods__["hasPointGammaB"] = _pythia8.PhaseSpace_hasPointGammaB_set
    __swig_getmethods__["hasPointGammaB"] = _pythia8.PhaseSpace_hasPointGammaB_get
    if _newclass:
        hasPointGammaB = _swig_property(_pythia8.PhaseSpace_hasPointGammaB_get, _pythia8.PhaseSpace_hasPointGammaB_set)
    __swig_setmethods__["hasOnePointParticle"] = _pythia8.PhaseSpace_hasOnePointParticle_set
    __swig_getmethods__["hasOnePointParticle"] = _pythia8.PhaseSpace_hasOnePointParticle_get
    if _newclass:
        hasOnePointParticle = _swig_property(_pythia8.PhaseSpace_hasOnePointParticle_get, _pythia8.PhaseSpace_hasOnePointParticle_set)
    __swig_setmethods__["hasTwoPointParticles"] = _pythia8.PhaseSpace_hasTwoPointParticles_set
    __swig_getmethods__["hasTwoPointParticles"] = _pythia8.PhaseSpace_hasTwoPointParticles_get
    if _newclass:
        hasTwoPointParticles = _swig_property(_pythia8.PhaseSpace_hasTwoPointParticles_get, _pythia8.PhaseSpace_hasTwoPointParticles_set)
    __swig_setmethods__["hasGamma"] = _pythia8.PhaseSpace_hasGamma_set
    __swig_getmethods__["hasGamma"] = _pythia8.PhaseSpace_hasGamma_get
    if _newclass:
        hasGamma = _swig_property(_pythia8.PhaseSpace_hasGamma_get, _pythia8.PhaseSpace_hasGamma_set)
    __swig_setmethods__["hasVMD"] = _pythia8.PhaseSpace_hasVMD_set
    __swig_getmethods__["hasVMD"] = _pythia8.PhaseSpace_hasVMD_get
    if _newclass:
        hasVMD = _swig_property(_pythia8.PhaseSpace_hasVMD_get, _pythia8.PhaseSpace_hasVMD_set)
    __swig_setmethods__["newSigmaMx"] = _pythia8.PhaseSpace_newSigmaMx_set
    __swig_getmethods__["newSigmaMx"] = _pythia8.PhaseSpace_newSigmaMx_get
    if _newclass:
        newSigmaMx = _swig_property(_pythia8.PhaseSpace_newSigmaMx_get, _pythia8.PhaseSpace_newSigmaMx_set)
    __swig_setmethods__["canModifySigma"] = _pythia8.PhaseSpace_canModifySigma_set
    __swig_getmethods__["canModifySigma"] = _pythia8.PhaseSpace_canModifySigma_get
    if _newclass:
        canModifySigma = _swig_property(_pythia8.PhaseSpace_canModifySigma_get, _pythia8.PhaseSpace_canModifySigma_set)
    __swig_setmethods__["canBiasSelection"] = _pythia8.PhaseSpace_canBiasSelection_set
    __swig_getmethods__["canBiasSelection"] = _pythia8.PhaseSpace_canBiasSelection_get
    if _newclass:
        canBiasSelection = _swig_property(_pythia8.PhaseSpace_canBiasSelection_get, _pythia8.PhaseSpace_canBiasSelection_set)
    __swig_setmethods__["canBias2Sel"] = _pythia8.PhaseSpace_canBias2Sel_set
    __swig_getmethods__["canBias2Sel"] = _pythia8.PhaseSpace_canBias2Sel_get
    if _newclass:
        canBias2Sel = _swig_property(_pythia8.PhaseSpace_canBias2Sel_get, _pythia8.PhaseSpace_canBias2Sel_set)
    __swig_setmethods__["gmZmode"] = _pythia8.PhaseSpace_gmZmode_set
    __swig_getmethods__["gmZmode"] = _pythia8.PhaseSpace_gmZmode_get
    if _newclass:
        gmZmode = _swig_property(_pythia8.PhaseSpace_gmZmode_get, _pythia8.PhaseSpace_gmZmode_set)
    __swig_setmethods__["bias2SelPow"] = _pythia8.PhaseSpace_bias2SelPow_set
    __swig_getmethods__["bias2SelPow"] = _pythia8.PhaseSpace_bias2SelPow_get
    if _newclass:
        bias2SelPow = _swig_property(_pythia8.PhaseSpace_bias2SelPow_get, _pythia8.PhaseSpace_bias2SelPow_set)
    __swig_setmethods__["bias2SelRef"] = _pythia8.PhaseSpace_bias2SelRef_set
    __swig_getmethods__["bias2SelRef"] = _pythia8.PhaseSpace_bias2SelRef_get
    if _newclass:
        bias2SelRef = _swig_property(_pythia8.PhaseSpace_bias2SelRef_get, _pythia8.PhaseSpace_bias2SelRef_set)
    __swig_setmethods__["wtBW"] = _pythia8.PhaseSpace_wtBW_set
    __swig_getmethods__["wtBW"] = _pythia8.PhaseSpace_wtBW_get
    if _newclass:
        wtBW = _swig_property(_pythia8.PhaseSpace_wtBW_get, _pythia8.PhaseSpace_wtBW_set)
    __swig_setmethods__["sigmaNw"] = _pythia8.PhaseSpace_sigmaNw_set
    __swig_getmethods__["sigmaNw"] = _pythia8.PhaseSpace_sigmaNw_get
    if _newclass:
        sigmaNw = _swig_property(_pythia8.PhaseSpace_sigmaNw_get, _pythia8.PhaseSpace_sigmaNw_set)
    __swig_setmethods__["sigmaMx"] = _pythia8.PhaseSpace_sigmaMx_set
    __swig_getmethods__["sigmaMx"] = _pythia8.PhaseSpace_sigmaMx_get
    if _newclass:
        sigmaMx = _swig_property(_pythia8.PhaseSpace_sigmaMx_get, _pythia8.PhaseSpace_sigmaMx_set)
    __swig_setmethods__["sigmaPos"] = _pythia8.PhaseSpace_sigmaPos_set
    __swig_getmethods__["sigmaPos"] = _pythia8.PhaseSpace_sigmaPos_get
    if _newclass:
        sigmaPos = _swig_property(_pythia8.PhaseSpace_sigmaPos_get, _pythia8.PhaseSpace_sigmaPos_set)
    __swig_setmethods__["sigmaNeg"] = _pythia8.PhaseSpace_sigmaNeg_set
    __swig_getmethods__["sigmaNeg"] = _pythia8.PhaseSpace_sigmaNeg_get
    if _newclass:
        sigmaNeg = _swig_property(_pythia8.PhaseSpace_sigmaNeg_get, _pythia8.PhaseSpace_sigmaNeg_set)
    __swig_setmethods__["biasWt"] = _pythia8.PhaseSpace_biasWt_set
    __swig_getmethods__["biasWt"] = _pythia8.PhaseSpace_biasWt_get
    if _newclass:
        biasWt = _swig_property(_pythia8.PhaseSpace_biasWt_get, _pythia8.PhaseSpace_biasWt_set)
    __swig_setmethods__["mHatMin"] = _pythia8.PhaseSpace_mHatMin_set
    __swig_getmethods__["mHatMin"] = _pythia8.PhaseSpace_mHatMin_get
    if _newclass:
        mHatMin = _swig_property(_pythia8.PhaseSpace_mHatMin_get, _pythia8.PhaseSpace_mHatMin_set)
    __swig_setmethods__["mHatMax"] = _pythia8.PhaseSpace_mHatMax_set
    __swig_getmethods__["mHatMax"] = _pythia8.PhaseSpace_mHatMax_get
    if _newclass:
        mHatMax = _swig_property(_pythia8.PhaseSpace_mHatMax_get, _pythia8.PhaseSpace_mHatMax_set)
    __swig_setmethods__["sHatMin"] = _pythia8.PhaseSpace_sHatMin_set
    __swig_getmethods__["sHatMin"] = _pythia8.PhaseSpace_sHatMin_get
    if _newclass:
        sHatMin = _swig_property(_pythia8.PhaseSpace_sHatMin_get, _pythia8.PhaseSpace_sHatMin_set)
    __swig_setmethods__["sHatMax"] = _pythia8.PhaseSpace_sHatMax_set
    __swig_getmethods__["sHatMax"] = _pythia8.PhaseSpace_sHatMax_get
    if _newclass:
        sHatMax = _swig_property(_pythia8.PhaseSpace_sHatMax_get, _pythia8.PhaseSpace_sHatMax_set)
    __swig_setmethods__["pTHatMin"] = _pythia8.PhaseSpace_pTHatMin_set
    __swig_getmethods__["pTHatMin"] = _pythia8.PhaseSpace_pTHatMin_get
    if _newclass:
        pTHatMin = _swig_property(_pythia8.PhaseSpace_pTHatMin_get, _pythia8.PhaseSpace_pTHatMin_set)
    __swig_setmethods__["pTHatMax"] = _pythia8.PhaseSpace_pTHatMax_set
    __swig_getmethods__["pTHatMax"] = _pythia8.PhaseSpace_pTHatMax_get
    if _newclass:
        pTHatMax = _swig_property(_pythia8.PhaseSpace_pTHatMax_get, _pythia8.PhaseSpace_pTHatMax_set)
    __swig_setmethods__["pT2HatMin"] = _pythia8.PhaseSpace_pT2HatMin_set
    __swig_getmethods__["pT2HatMin"] = _pythia8.PhaseSpace_pT2HatMin_get
    if _newclass:
        pT2HatMin = _swig_property(_pythia8.PhaseSpace_pT2HatMin_get, _pythia8.PhaseSpace_pT2HatMin_set)
    __swig_setmethods__["pT2HatMax"] = _pythia8.PhaseSpace_pT2HatMax_set
    __swig_getmethods__["pT2HatMax"] = _pythia8.PhaseSpace_pT2HatMax_get
    if _newclass:
        pT2HatMax = _swig_property(_pythia8.PhaseSpace_pT2HatMax_get, _pythia8.PhaseSpace_pT2HatMax_set)
    __swig_setmethods__["x1H"] = _pythia8.PhaseSpace_x1H_set
    __swig_getmethods__["x1H"] = _pythia8.PhaseSpace_x1H_get
    if _newclass:
        x1H = _swig_property(_pythia8.PhaseSpace_x1H_get, _pythia8.PhaseSpace_x1H_set)
    __swig_setmethods__["x2H"] = _pythia8.PhaseSpace_x2H_set
    __swig_getmethods__["x2H"] = _pythia8.PhaseSpace_x2H_get
    if _newclass:
        x2H = _swig_property(_pythia8.PhaseSpace_x2H_get, _pythia8.PhaseSpace_x2H_set)
    __swig_setmethods__["m3"] = _pythia8.PhaseSpace_m3_set
    __swig_getmethods__["m3"] = _pythia8.PhaseSpace_m3_get
    if _newclass:
        m3 = _swig_property(_pythia8.PhaseSpace_m3_get, _pythia8.PhaseSpace_m3_set)
    __swig_setmethods__["m4"] = _pythia8.PhaseSpace_m4_set
    __swig_getmethods__["m4"] = _pythia8.PhaseSpace_m4_get
    if _newclass:
        m4 = _swig_property(_pythia8.PhaseSpace_m4_get, _pythia8.PhaseSpace_m4_set)
    __swig_setmethods__["m5"] = _pythia8.PhaseSpace_m5_set
    __swig_getmethods__["m5"] = _pythia8.PhaseSpace_m5_get
    if _newclass:
        m5 = _swig_property(_pythia8.PhaseSpace_m5_get, _pythia8.PhaseSpace_m5_set)
    __swig_setmethods__["s3"] = _pythia8.PhaseSpace_s3_set
    __swig_getmethods__["s3"] = _pythia8.PhaseSpace_s3_get
    if _newclass:
        s3 = _swig_property(_pythia8.PhaseSpace_s3_get, _pythia8.PhaseSpace_s3_set)
    __swig_setmethods__["s4"] = _pythia8.PhaseSpace_s4_set
    __swig_getmethods__["s4"] = _pythia8.PhaseSpace_s4_get
    if _newclass:
        s4 = _swig_property(_pythia8.PhaseSpace_s4_get, _pythia8.PhaseSpace_s4_set)
    __swig_setmethods__["s5"] = _pythia8.PhaseSpace_s5_set
    __swig_getmethods__["s5"] = _pythia8.PhaseSpace_s5_get
    if _newclass:
        s5 = _swig_property(_pythia8.PhaseSpace_s5_get, _pythia8.PhaseSpace_s5_set)
    __swig_setmethods__["mHat"] = _pythia8.PhaseSpace_mHat_set
    __swig_getmethods__["mHat"] = _pythia8.PhaseSpace_mHat_get
    if _newclass:
        mHat = _swig_property(_pythia8.PhaseSpace_mHat_get, _pythia8.PhaseSpace_mHat_set)
    __swig_setmethods__["sH"] = _pythia8.PhaseSpace_sH_set
    __swig_getmethods__["sH"] = _pythia8.PhaseSpace_sH_get
    if _newclass:
        sH = _swig_property(_pythia8.PhaseSpace_sH_get, _pythia8.PhaseSpace_sH_set)
    __swig_setmethods__["tH"] = _pythia8.PhaseSpace_tH_set
    __swig_getmethods__["tH"] = _pythia8.PhaseSpace_tH_get
    if _newclass:
        tH = _swig_property(_pythia8.PhaseSpace_tH_get, _pythia8.PhaseSpace_tH_set)
    __swig_setmethods__["uH"] = _pythia8.PhaseSpace_uH_set
    __swig_getmethods__["uH"] = _pythia8.PhaseSpace_uH_get
    if _newclass:
        uH = _swig_property(_pythia8.PhaseSpace_uH_get, _pythia8.PhaseSpace_uH_set)
    __swig_setmethods__["pAbs"] = _pythia8.PhaseSpace_pAbs_set
    __swig_getmethods__["pAbs"] = _pythia8.PhaseSpace_pAbs_get
    if _newclass:
        pAbs = _swig_property(_pythia8.PhaseSpace_pAbs_get, _pythia8.PhaseSpace_pAbs_set)
    __swig_setmethods__["p2Abs"] = _pythia8.PhaseSpace_p2Abs_set
    __swig_getmethods__["p2Abs"] = _pythia8.PhaseSpace_p2Abs_get
    if _newclass:
        p2Abs = _swig_property(_pythia8.PhaseSpace_p2Abs_get, _pythia8.PhaseSpace_p2Abs_set)
    __swig_setmethods__["pTH"] = _pythia8.PhaseSpace_pTH_set
    __swig_getmethods__["pTH"] = _pythia8.PhaseSpace_pTH_get
    if _newclass:
        pTH = _swig_property(_pythia8.PhaseSpace_pTH_get, _pythia8.PhaseSpace_pTH_set)
    __swig_setmethods__["theta"] = _pythia8.PhaseSpace_theta_set
    __swig_getmethods__["theta"] = _pythia8.PhaseSpace_theta_get
    if _newclass:
        theta = _swig_property(_pythia8.PhaseSpace_theta_get, _pythia8.PhaseSpace_theta_set)
    __swig_setmethods__["phi"] = _pythia8.PhaseSpace_phi_set
    __swig_getmethods__["phi"] = _pythia8.PhaseSpace_phi_get
    if _newclass:
        phi = _swig_property(_pythia8.PhaseSpace_phi_get, _pythia8.PhaseSpace_phi_set)
    __swig_setmethods__["betaZ"] = _pythia8.PhaseSpace_betaZ_set
    __swig_getmethods__["betaZ"] = _pythia8.PhaseSpace_betaZ_get
    if _newclass:
        betaZ = _swig_property(_pythia8.PhaseSpace_betaZ_get, _pythia8.PhaseSpace_betaZ_set)
    __swig_setmethods__["pH"] = _pythia8.PhaseSpace_pH_set
    __swig_getmethods__["pH"] = _pythia8.PhaseSpace_pH_get
    if _newclass:
        pH = _swig_property(_pythia8.PhaseSpace_pH_get, _pythia8.PhaseSpace_pH_set)
    __swig_setmethods__["mH"] = _pythia8.PhaseSpace_mH_set
    __swig_getmethods__["mH"] = _pythia8.PhaseSpace_mH_get
    if _newclass:
        mH = _swig_property(_pythia8.PhaseSpace_mH_get, _pythia8.PhaseSpace_mH_set)

    def decayKinematicsStep(self, process, iRes):
        """
Constants: could only be changed in the code itself.
Pointer to cross section.
Pointer to various information on the generation.
Pointer to the settings database.
Pointer to the particle data table.
Pointer to the random number generator.
Pointers to incoming beams.
Pointer to Standard Model couplings.
Pointer to the total/elastic/diffractive cross section object.
Pointer to userHooks object for user interaction with program.
Pointer to LHAup for generating external events.
Pointer to object that samples photon kinematics from leptons.
Initialization data, normally only set once.
Information on incoming beams.
Cross section information.
Process-specific kinematics properties, almost always available.
Event-specific kinematics properties, almost always available.
Reselect decay products momenta isotropically in phase space.
"""
        return _pythia8.PhaseSpace_decayKinematicsStep(self, process, iRes)

    def setup3Body(self):
        """
Much common code for normal 2 -> 1, 2 -> 2 and 2 -> 3 cases:
Determine how phase space should be sampled.
"""
        return _pythia8.PhaseSpace_setup3Body(self)

    def setupSampling123(self, is2, is3):
        """
"""
        return _pythia8.PhaseSpace_setupSampling123(self, is2, is3)

    def trialKin123(self, is2, is3, inEvent=True):
        """
Select a trial kinematics phase space point.
"""
        return _pythia8.PhaseSpace_trialKin123(self, is2, is3, inEvent)
    __swig_setmethods__["idResA"] = _pythia8.PhaseSpace_idResA_set
    __swig_getmethods__["idResA"] = _pythia8.PhaseSpace_idResA_get
    if _newclass:
        idResA = _swig_property(_pythia8.PhaseSpace_idResA_get, _pythia8.PhaseSpace_idResA_set)
    __swig_setmethods__["idResB"] = _pythia8.PhaseSpace_idResB_set
    __swig_getmethods__["idResB"] = _pythia8.PhaseSpace_idResB_get
    if _newclass:
        idResB = _swig_property(_pythia8.PhaseSpace_idResB_get, _pythia8.PhaseSpace_idResB_set)
    __swig_setmethods__["mResA"] = _pythia8.PhaseSpace_mResA_set
    __swig_getmethods__["mResA"] = _pythia8.PhaseSpace_mResA_get
    if _newclass:
        mResA = _swig_property(_pythia8.PhaseSpace_mResA_get, _pythia8.PhaseSpace_mResA_set)
    __swig_setmethods__["mResB"] = _pythia8.PhaseSpace_mResB_set
    __swig_getmethods__["mResB"] = _pythia8.PhaseSpace_mResB_get
    if _newclass:
        mResB = _swig_property(_pythia8.PhaseSpace_mResB_get, _pythia8.PhaseSpace_mResB_set)
    __swig_setmethods__["GammaResA"] = _pythia8.PhaseSpace_GammaResA_set
    __swig_getmethods__["GammaResA"] = _pythia8.PhaseSpace_GammaResA_get
    if _newclass:
        GammaResA = _swig_property(_pythia8.PhaseSpace_GammaResA_get, _pythia8.PhaseSpace_GammaResA_set)
    __swig_setmethods__["GammaResB"] = _pythia8.PhaseSpace_GammaResB_set
    __swig_getmethods__["GammaResB"] = _pythia8.PhaseSpace_GammaResB_get
    if _newclass:
        GammaResB = _swig_property(_pythia8.PhaseSpace_GammaResB_get, _pythia8.PhaseSpace_GammaResB_set)
    __swig_setmethods__["tauResA"] = _pythia8.PhaseSpace_tauResA_set
    __swig_getmethods__["tauResA"] = _pythia8.PhaseSpace_tauResA_get
    if _newclass:
        tauResA = _swig_property(_pythia8.PhaseSpace_tauResA_get, _pythia8.PhaseSpace_tauResA_set)
    __swig_setmethods__["tauResB"] = _pythia8.PhaseSpace_tauResB_set
    __swig_getmethods__["tauResB"] = _pythia8.PhaseSpace_tauResB_get
    if _newclass:
        tauResB = _swig_property(_pythia8.PhaseSpace_tauResB_get, _pythia8.PhaseSpace_tauResB_set)
    __swig_setmethods__["widResA"] = _pythia8.PhaseSpace_widResA_set
    __swig_getmethods__["widResA"] = _pythia8.PhaseSpace_widResA_get
    if _newclass:
        widResA = _swig_property(_pythia8.PhaseSpace_widResA_get, _pythia8.PhaseSpace_widResA_set)
    __swig_setmethods__["widResB"] = _pythia8.PhaseSpace_widResB_set
    __swig_getmethods__["widResB"] = _pythia8.PhaseSpace_widResB_get
    if _newclass:
        widResB = _swig_property(_pythia8.PhaseSpace_widResB_get, _pythia8.PhaseSpace_widResB_set)
    __swig_setmethods__["sameResMass"] = _pythia8.PhaseSpace_sameResMass_set
    __swig_getmethods__["sameResMass"] = _pythia8.PhaseSpace_sameResMass_get
    if _newclass:
        sameResMass = _swig_property(_pythia8.PhaseSpace_sameResMass_get, _pythia8.PhaseSpace_sameResMass_set)
    __swig_setmethods__["useMirrorWeight"] = _pythia8.PhaseSpace_useMirrorWeight_set
    __swig_getmethods__["useMirrorWeight"] = _pythia8.PhaseSpace_useMirrorWeight_get
    if _newclass:
        useMirrorWeight = _swig_property(_pythia8.PhaseSpace_useMirrorWeight_get, _pythia8.PhaseSpace_useMirrorWeight_set)
    __swig_setmethods__["hasNegZ"] = _pythia8.PhaseSpace_hasNegZ_set
    __swig_getmethods__["hasNegZ"] = _pythia8.PhaseSpace_hasNegZ_get
    if _newclass:
        hasNegZ = _swig_property(_pythia8.PhaseSpace_hasNegZ_get, _pythia8.PhaseSpace_hasNegZ_set)
    __swig_setmethods__["hasPosZ"] = _pythia8.PhaseSpace_hasPosZ_set
    __swig_getmethods__["hasPosZ"] = _pythia8.PhaseSpace_hasPosZ_get
    if _newclass:
        hasPosZ = _swig_property(_pythia8.PhaseSpace_hasPosZ_get, _pythia8.PhaseSpace_hasPosZ_set)
    __swig_setmethods__["tau"] = _pythia8.PhaseSpace_tau_set
    __swig_getmethods__["tau"] = _pythia8.PhaseSpace_tau_get
    if _newclass:
        tau = _swig_property(_pythia8.PhaseSpace_tau_get, _pythia8.PhaseSpace_tau_set)
    __swig_setmethods__["y"] = _pythia8.PhaseSpace_y_set
    __swig_getmethods__["y"] = _pythia8.PhaseSpace_y_get
    if _newclass:
        y = _swig_property(_pythia8.PhaseSpace_y_get, _pythia8.PhaseSpace_y_set)
    __swig_setmethods__["z"] = _pythia8.PhaseSpace_z_set
    __swig_getmethods__["z"] = _pythia8.PhaseSpace_z_get
    if _newclass:
        z = _swig_property(_pythia8.PhaseSpace_z_get, _pythia8.PhaseSpace_z_set)
    __swig_setmethods__["tauMin"] = _pythia8.PhaseSpace_tauMin_set
    __swig_getmethods__["tauMin"] = _pythia8.PhaseSpace_tauMin_get
    if _newclass:
        tauMin = _swig_property(_pythia8.PhaseSpace_tauMin_get, _pythia8.PhaseSpace_tauMin_set)
    __swig_setmethods__["tauMax"] = _pythia8.PhaseSpace_tauMax_set
    __swig_getmethods__["tauMax"] = _pythia8.PhaseSpace_tauMax_get
    if _newclass:
        tauMax = _swig_property(_pythia8.PhaseSpace_tauMax_get, _pythia8.PhaseSpace_tauMax_set)
    __swig_setmethods__["yMax"] = _pythia8.PhaseSpace_yMax_set
    __swig_getmethods__["yMax"] = _pythia8.PhaseSpace_yMax_get
    if _newclass:
        yMax = _swig_property(_pythia8.PhaseSpace_yMax_get, _pythia8.PhaseSpace_yMax_set)
    __swig_setmethods__["zMin"] = _pythia8.PhaseSpace_zMin_set
    __swig_getmethods__["zMin"] = _pythia8.PhaseSpace_zMin_get
    if _newclass:
        zMin = _swig_property(_pythia8.PhaseSpace_zMin_get, _pythia8.PhaseSpace_zMin_set)
    __swig_setmethods__["zMax"] = _pythia8.PhaseSpace_zMax_set
    __swig_getmethods__["zMax"] = _pythia8.PhaseSpace_zMax_get
    if _newclass:
        zMax = _swig_property(_pythia8.PhaseSpace_zMax_get, _pythia8.PhaseSpace_zMax_set)
    __swig_setmethods__["ratio34"] = _pythia8.PhaseSpace_ratio34_set
    __swig_getmethods__["ratio34"] = _pythia8.PhaseSpace_ratio34_get
    if _newclass:
        ratio34 = _swig_property(_pythia8.PhaseSpace_ratio34_get, _pythia8.PhaseSpace_ratio34_set)
    __swig_setmethods__["unity34"] = _pythia8.PhaseSpace_unity34_set
    __swig_getmethods__["unity34"] = _pythia8.PhaseSpace_unity34_get
    if _newclass:
        unity34 = _swig_property(_pythia8.PhaseSpace_unity34_get, _pythia8.PhaseSpace_unity34_set)
    __swig_setmethods__["zNeg"] = _pythia8.PhaseSpace_zNeg_set
    __swig_getmethods__["zNeg"] = _pythia8.PhaseSpace_zNeg_get
    if _newclass:
        zNeg = _swig_property(_pythia8.PhaseSpace_zNeg_get, _pythia8.PhaseSpace_zNeg_set)
    __swig_setmethods__["zPos"] = _pythia8.PhaseSpace_zPos_set
    __swig_getmethods__["zPos"] = _pythia8.PhaseSpace_zPos_get
    if _newclass:
        zPos = _swig_property(_pythia8.PhaseSpace_zPos_get, _pythia8.PhaseSpace_zPos_set)
    __swig_setmethods__["wtTau"] = _pythia8.PhaseSpace_wtTau_set
    __swig_getmethods__["wtTau"] = _pythia8.PhaseSpace_wtTau_get
    if _newclass:
        wtTau = _swig_property(_pythia8.PhaseSpace_wtTau_get, _pythia8.PhaseSpace_wtTau_set)
    __swig_setmethods__["wtY"] = _pythia8.PhaseSpace_wtY_set
    __swig_getmethods__["wtY"] = _pythia8.PhaseSpace_wtY_get
    if _newclass:
        wtY = _swig_property(_pythia8.PhaseSpace_wtY_get, _pythia8.PhaseSpace_wtY_set)
    __swig_setmethods__["wtZ"] = _pythia8.PhaseSpace_wtZ_set
    __swig_getmethods__["wtZ"] = _pythia8.PhaseSpace_wtZ_get
    if _newclass:
        wtZ = _swig_property(_pythia8.PhaseSpace_wtZ_get, _pythia8.PhaseSpace_wtZ_set)
    __swig_setmethods__["wt3Body"] = _pythia8.PhaseSpace_wt3Body_set
    __swig_getmethods__["wt3Body"] = _pythia8.PhaseSpace_wt3Body_get
    if _newclass:
        wt3Body = _swig_property(_pythia8.PhaseSpace_wt3Body_get, _pythia8.PhaseSpace_wt3Body_set)
    __swig_setmethods__["runBW3H"] = _pythia8.PhaseSpace_runBW3H_set
    __swig_getmethods__["runBW3H"] = _pythia8.PhaseSpace_runBW3H_get
    if _newclass:
        runBW3H = _swig_property(_pythia8.PhaseSpace_runBW3H_get, _pythia8.PhaseSpace_runBW3H_set)
    __swig_setmethods__["runBW4H"] = _pythia8.PhaseSpace_runBW4H_set
    __swig_getmethods__["runBW4H"] = _pythia8.PhaseSpace_runBW4H_get
    if _newclass:
        runBW4H = _swig_property(_pythia8.PhaseSpace_runBW4H_get, _pythia8.PhaseSpace_runBW4H_set)
    __swig_setmethods__["runBW5H"] = _pythia8.PhaseSpace_runBW5H_set
    __swig_getmethods__["runBW5H"] = _pythia8.PhaseSpace_runBW5H_get
    if _newclass:
        runBW5H = _swig_property(_pythia8.PhaseSpace_runBW5H_get, _pythia8.PhaseSpace_runBW5H_set)
    __swig_setmethods__["intTau0"] = _pythia8.PhaseSpace_intTau0_set
    __swig_getmethods__["intTau0"] = _pythia8.PhaseSpace_intTau0_get
    if _newclass:
        intTau0 = _swig_property(_pythia8.PhaseSpace_intTau0_get, _pythia8.PhaseSpace_intTau0_set)
    __swig_setmethods__["intTau1"] = _pythia8.PhaseSpace_intTau1_set
    __swig_getmethods__["intTau1"] = _pythia8.PhaseSpace_intTau1_get
    if _newclass:
        intTau1 = _swig_property(_pythia8.PhaseSpace_intTau1_get, _pythia8.PhaseSpace_intTau1_set)
    __swig_setmethods__["intTau2"] = _pythia8.PhaseSpace_intTau2_set
    __swig_getmethods__["intTau2"] = _pythia8.PhaseSpace_intTau2_get
    if _newclass:
        intTau2 = _swig_property(_pythia8.PhaseSpace_intTau2_get, _pythia8.PhaseSpace_intTau2_set)
    __swig_setmethods__["intTau3"] = _pythia8.PhaseSpace_intTau3_set
    __swig_getmethods__["intTau3"] = _pythia8.PhaseSpace_intTau3_get
    if _newclass:
        intTau3 = _swig_property(_pythia8.PhaseSpace_intTau3_get, _pythia8.PhaseSpace_intTau3_set)
    __swig_setmethods__["intTau4"] = _pythia8.PhaseSpace_intTau4_set
    __swig_getmethods__["intTau4"] = _pythia8.PhaseSpace_intTau4_get
    if _newclass:
        intTau4 = _swig_property(_pythia8.PhaseSpace_intTau4_get, _pythia8.PhaseSpace_intTau4_set)
    __swig_setmethods__["intTau5"] = _pythia8.PhaseSpace_intTau5_set
    __swig_getmethods__["intTau5"] = _pythia8.PhaseSpace_intTau5_get
    if _newclass:
        intTau5 = _swig_property(_pythia8.PhaseSpace_intTau5_get, _pythia8.PhaseSpace_intTau5_set)
    __swig_setmethods__["intTau6"] = _pythia8.PhaseSpace_intTau6_set
    __swig_getmethods__["intTau6"] = _pythia8.PhaseSpace_intTau6_get
    if _newclass:
        intTau6 = _swig_property(_pythia8.PhaseSpace_intTau6_get, _pythia8.PhaseSpace_intTau6_set)
    __swig_setmethods__["intY0"] = _pythia8.PhaseSpace_intY0_set
    __swig_getmethods__["intY0"] = _pythia8.PhaseSpace_intY0_get
    if _newclass:
        intY0 = _swig_property(_pythia8.PhaseSpace_intY0_get, _pythia8.PhaseSpace_intY0_set)
    __swig_setmethods__["intY12"] = _pythia8.PhaseSpace_intY12_set
    __swig_getmethods__["intY12"] = _pythia8.PhaseSpace_intY12_get
    if _newclass:
        intY12 = _swig_property(_pythia8.PhaseSpace_intY12_get, _pythia8.PhaseSpace_intY12_set)
    __swig_setmethods__["intY34"] = _pythia8.PhaseSpace_intY34_set
    __swig_getmethods__["intY34"] = _pythia8.PhaseSpace_intY34_get
    if _newclass:
        intY34 = _swig_property(_pythia8.PhaseSpace_intY34_get, _pythia8.PhaseSpace_intY34_set)
    __swig_setmethods__["intY56"] = _pythia8.PhaseSpace_intY56_set
    __swig_getmethods__["intY56"] = _pythia8.PhaseSpace_intY56_get
    if _newclass:
        intY56 = _swig_property(_pythia8.PhaseSpace_intY56_get, _pythia8.PhaseSpace_intY56_set)
    __swig_setmethods__["mTchan1"] = _pythia8.PhaseSpace_mTchan1_set
    __swig_getmethods__["mTchan1"] = _pythia8.PhaseSpace_mTchan1_get
    if _newclass:
        mTchan1 = _swig_property(_pythia8.PhaseSpace_mTchan1_get, _pythia8.PhaseSpace_mTchan1_set)
    __swig_setmethods__["sTchan1"] = _pythia8.PhaseSpace_sTchan1_set
    __swig_getmethods__["sTchan1"] = _pythia8.PhaseSpace_sTchan1_get
    if _newclass:
        sTchan1 = _swig_property(_pythia8.PhaseSpace_sTchan1_get, _pythia8.PhaseSpace_sTchan1_set)
    __swig_setmethods__["mTchan2"] = _pythia8.PhaseSpace_mTchan2_set
    __swig_getmethods__["mTchan2"] = _pythia8.PhaseSpace_mTchan2_get
    if _newclass:
        mTchan2 = _swig_property(_pythia8.PhaseSpace_mTchan2_get, _pythia8.PhaseSpace_mTchan2_set)
    __swig_setmethods__["sTchan2"] = _pythia8.PhaseSpace_sTchan2_set
    __swig_getmethods__["sTchan2"] = _pythia8.PhaseSpace_sTchan2_get
    if _newclass:
        sTchan2 = _swig_property(_pythia8.PhaseSpace_sTchan2_get, _pythia8.PhaseSpace_sTchan2_set)
    __swig_setmethods__["frac3Flat"] = _pythia8.PhaseSpace_frac3Flat_set
    __swig_getmethods__["frac3Flat"] = _pythia8.PhaseSpace_frac3Flat_get
    if _newclass:
        frac3Flat = _swig_property(_pythia8.PhaseSpace_frac3Flat_get, _pythia8.PhaseSpace_frac3Flat_set)
    __swig_setmethods__["frac3Pow1"] = _pythia8.PhaseSpace_frac3Pow1_set
    __swig_getmethods__["frac3Pow1"] = _pythia8.PhaseSpace_frac3Pow1_get
    if _newclass:
        frac3Pow1 = _swig_property(_pythia8.PhaseSpace_frac3Pow1_get, _pythia8.PhaseSpace_frac3Pow1_set)
    __swig_setmethods__["frac3Pow2"] = _pythia8.PhaseSpace_frac3Pow2_set
    __swig_getmethods__["frac3Pow2"] = _pythia8.PhaseSpace_frac3Pow2_get
    if _newclass:
        frac3Pow2 = _swig_property(_pythia8.PhaseSpace_frac3Pow2_get, _pythia8.PhaseSpace_frac3Pow2_set)
    __swig_setmethods__["zNegMin"] = _pythia8.PhaseSpace_zNegMin_set
    __swig_getmethods__["zNegMin"] = _pythia8.PhaseSpace_zNegMin_get
    if _newclass:
        zNegMin = _swig_property(_pythia8.PhaseSpace_zNegMin_get, _pythia8.PhaseSpace_zNegMin_set)
    __swig_setmethods__["zNegMax"] = _pythia8.PhaseSpace_zNegMax_set
    __swig_getmethods__["zNegMax"] = _pythia8.PhaseSpace_zNegMax_get
    if _newclass:
        zNegMax = _swig_property(_pythia8.PhaseSpace_zNegMax_get, _pythia8.PhaseSpace_zNegMax_set)
    __swig_setmethods__["zPosMin"] = _pythia8.PhaseSpace_zPosMin_set
    __swig_getmethods__["zPosMin"] = _pythia8.PhaseSpace_zPosMin_get
    if _newclass:
        zPosMin = _swig_property(_pythia8.PhaseSpace_zPosMin_get, _pythia8.PhaseSpace_zPosMin_set)
    __swig_setmethods__["zPosMax"] = _pythia8.PhaseSpace_zPosMax_set
    __swig_getmethods__["zPosMax"] = _pythia8.PhaseSpace_zPosMax_get
    if _newclass:
        zPosMax = _swig_property(_pythia8.PhaseSpace_zPosMax_get, _pythia8.PhaseSpace_zPosMax_set)
    __swig_setmethods__["p3cm"] = _pythia8.PhaseSpace_p3cm_set
    __swig_getmethods__["p3cm"] = _pythia8.PhaseSpace_p3cm_get
    if _newclass:
        p3cm = _swig_property(_pythia8.PhaseSpace_p3cm_get, _pythia8.PhaseSpace_p3cm_set)
    __swig_setmethods__["p4cm"] = _pythia8.PhaseSpace_p4cm_set
    __swig_getmethods__["p4cm"] = _pythia8.PhaseSpace_p4cm_get
    if _newclass:
        p4cm = _swig_property(_pythia8.PhaseSpace_p4cm_get, _pythia8.PhaseSpace_p4cm_set)
    __swig_setmethods__["p5cm"] = _pythia8.PhaseSpace_p5cm_set
    __swig_getmethods__["p5cm"] = _pythia8.PhaseSpace_p5cm_get
    if _newclass:
        p5cm = _swig_property(_pythia8.PhaseSpace_p5cm_get, _pythia8.PhaseSpace_p5cm_set)
    __swig_setmethods__["nTau"] = _pythia8.PhaseSpace_nTau_set
    __swig_getmethods__["nTau"] = _pythia8.PhaseSpace_nTau_get
    if _newclass:
        nTau = _swig_property(_pythia8.PhaseSpace_nTau_get, _pythia8.PhaseSpace_nTau_set)
    __swig_setmethods__["nY"] = _pythia8.PhaseSpace_nY_set
    __swig_getmethods__["nY"] = _pythia8.PhaseSpace_nY_get
    if _newclass:
        nY = _swig_property(_pythia8.PhaseSpace_nY_get, _pythia8.PhaseSpace_nY_set)
    __swig_setmethods__["nZ"] = _pythia8.PhaseSpace_nZ_set
    __swig_getmethods__["nZ"] = _pythia8.PhaseSpace_nZ_get
    if _newclass:
        nZ = _swig_property(_pythia8.PhaseSpace_nZ_get, _pythia8.PhaseSpace_nZ_set)
    __swig_setmethods__["tauCoef"] = _pythia8.PhaseSpace_tauCoef_set
    __swig_getmethods__["tauCoef"] = _pythia8.PhaseSpace_tauCoef_get
    if _newclass:
        tauCoef = _swig_property(_pythia8.PhaseSpace_tauCoef_get, _pythia8.PhaseSpace_tauCoef_set)
    __swig_setmethods__["yCoef"] = _pythia8.PhaseSpace_yCoef_set
    __swig_getmethods__["yCoef"] = _pythia8.PhaseSpace_yCoef_get
    if _newclass:
        yCoef = _swig_property(_pythia8.PhaseSpace_yCoef_get, _pythia8.PhaseSpace_yCoef_set)
    __swig_setmethods__["zCoef"] = _pythia8.PhaseSpace_zCoef_set
    __swig_getmethods__["zCoef"] = _pythia8.PhaseSpace_zCoef_get
    if _newclass:
        zCoef = _swig_property(_pythia8.PhaseSpace_zCoef_get, _pythia8.PhaseSpace_zCoef_set)
    __swig_setmethods__["tauCoefSum"] = _pythia8.PhaseSpace_tauCoefSum_set
    __swig_getmethods__["tauCoefSum"] = _pythia8.PhaseSpace_tauCoefSum_get
    if _newclass:
        tauCoefSum = _swig_property(_pythia8.PhaseSpace_tauCoefSum_get, _pythia8.PhaseSpace_tauCoefSum_set)
    __swig_setmethods__["yCoefSum"] = _pythia8.PhaseSpace_yCoefSum_set
    __swig_getmethods__["yCoefSum"] = _pythia8.PhaseSpace_yCoefSum_get
    if _newclass:
        yCoefSum = _swig_property(_pythia8.PhaseSpace_yCoefSum_get, _pythia8.PhaseSpace_yCoefSum_set)
    __swig_setmethods__["zCoefSum"] = _pythia8.PhaseSpace_zCoefSum_set
    __swig_getmethods__["zCoefSum"] = _pythia8.PhaseSpace_zCoefSum_get
    if _newclass:
        zCoefSum = _swig_property(_pythia8.PhaseSpace_zCoefSum_get, _pythia8.PhaseSpace_zCoefSum_set)

    def limitTau(self, is2, is3):
        """
Presence and properties of any s-channel resonances.
Kinematics properties specific to 2 -> 1/2/3.
Coefficients for optimized selection in 2 -> 1/2/3.
Calculate kinematical limits for 2 -> 1/2/3.
"""
        return _pythia8.PhaseSpace_limitTau(self, is2, is3)

    def limitY(self):
        """
"""
        return _pythia8.PhaseSpace_limitY(self)

    def limitZ(self):
        """
"""
        return _pythia8.PhaseSpace_limitZ(self)

    def selectTau(self, iTau, tauVal, is2):
        """
Select kinematical variable between defined limits for 2 -> 1/2/3.
"""
        return _pythia8.PhaseSpace_selectTau(self, iTau, tauVal, is2)

    def selectY(self, iY, yVal):
        """
"""
        return _pythia8.PhaseSpace_selectY(self, iY, yVal)

    def selectZ(self, iZ, zVal):
        """
"""
        return _pythia8.PhaseSpace_selectZ(self, iZ, zVal)

    def select3Body(self):
        """
"""
        return _pythia8.PhaseSpace_select3Body(self)

    def solveSys(self, n, bin, vec, mat, coef):
        """
Solve equation system for better phase space coefficients in 2 -> 1/2/3.
"""
        return _pythia8.PhaseSpace_solveSys(self, n, bin, vec, mat, coef)
    __swig_setmethods__["useBW"] = _pythia8.PhaseSpace_useBW_set
    __swig_getmethods__["useBW"] = _pythia8.PhaseSpace_useBW_get
    if _newclass:
        useBW = _swig_property(_pythia8.PhaseSpace_useBW_get, _pythia8.PhaseSpace_useBW_set)
    __swig_setmethods__["useNarrowBW"] = _pythia8.PhaseSpace_useNarrowBW_set
    __swig_getmethods__["useNarrowBW"] = _pythia8.PhaseSpace_useNarrowBW_get
    if _newclass:
        useNarrowBW = _swig_property(_pythia8.PhaseSpace_useNarrowBW_get, _pythia8.PhaseSpace_useNarrowBW_set)
    __swig_setmethods__["idMass"] = _pythia8.PhaseSpace_idMass_set
    __swig_getmethods__["idMass"] = _pythia8.PhaseSpace_idMass_get
    if _newclass:
        idMass = _swig_property(_pythia8.PhaseSpace_idMass_get, _pythia8.PhaseSpace_idMass_set)
    __swig_setmethods__["mPeak"] = _pythia8.PhaseSpace_mPeak_set
    __swig_getmethods__["mPeak"] = _pythia8.PhaseSpace_mPeak_get
    if _newclass:
        mPeak = _swig_property(_pythia8.PhaseSpace_mPeak_get, _pythia8.PhaseSpace_mPeak_set)
    __swig_setmethods__["sPeak"] = _pythia8.PhaseSpace_sPeak_set
    __swig_getmethods__["sPeak"] = _pythia8.PhaseSpace_sPeak_get
    if _newclass:
        sPeak = _swig_property(_pythia8.PhaseSpace_sPeak_get, _pythia8.PhaseSpace_sPeak_set)
    __swig_setmethods__["mWidth"] = _pythia8.PhaseSpace_mWidth_set
    __swig_getmethods__["mWidth"] = _pythia8.PhaseSpace_mWidth_get
    if _newclass:
        mWidth = _swig_property(_pythia8.PhaseSpace_mWidth_get, _pythia8.PhaseSpace_mWidth_set)
    __swig_setmethods__["mMin"] = _pythia8.PhaseSpace_mMin_set
    __swig_getmethods__["mMin"] = _pythia8.PhaseSpace_mMin_get
    if _newclass:
        mMin = _swig_property(_pythia8.PhaseSpace_mMin_get, _pythia8.PhaseSpace_mMin_set)
    __swig_setmethods__["mMax"] = _pythia8.PhaseSpace_mMax_set
    __swig_getmethods__["mMax"] = _pythia8.PhaseSpace_mMax_get
    if _newclass:
        mMax = _swig_property(_pythia8.PhaseSpace_mMax_get, _pythia8.PhaseSpace_mMax_set)
    __swig_setmethods__["mw"] = _pythia8.PhaseSpace_mw_set
    __swig_getmethods__["mw"] = _pythia8.PhaseSpace_mw_get
    if _newclass:
        mw = _swig_property(_pythia8.PhaseSpace_mw_get, _pythia8.PhaseSpace_mw_set)
    __swig_setmethods__["wmRat"] = _pythia8.PhaseSpace_wmRat_set
    __swig_getmethods__["wmRat"] = _pythia8.PhaseSpace_wmRat_get
    if _newclass:
        wmRat = _swig_property(_pythia8.PhaseSpace_wmRat_get, _pythia8.PhaseSpace_wmRat_set)
    __swig_setmethods__["mLower"] = _pythia8.PhaseSpace_mLower_set
    __swig_getmethods__["mLower"] = _pythia8.PhaseSpace_mLower_get
    if _newclass:
        mLower = _swig_property(_pythia8.PhaseSpace_mLower_get, _pythia8.PhaseSpace_mLower_set)
    __swig_setmethods__["mUpper"] = _pythia8.PhaseSpace_mUpper_set
    __swig_getmethods__["mUpper"] = _pythia8.PhaseSpace_mUpper_get
    if _newclass:
        mUpper = _swig_property(_pythia8.PhaseSpace_mUpper_get, _pythia8.PhaseSpace_mUpper_set)
    __swig_setmethods__["sLower"] = _pythia8.PhaseSpace_sLower_set
    __swig_getmethods__["sLower"] = _pythia8.PhaseSpace_sLower_get
    if _newclass:
        sLower = _swig_property(_pythia8.PhaseSpace_sLower_get, _pythia8.PhaseSpace_sLower_set)
    __swig_setmethods__["sUpper"] = _pythia8.PhaseSpace_sUpper_set
    __swig_getmethods__["sUpper"] = _pythia8.PhaseSpace_sUpper_get
    if _newclass:
        sUpper = _swig_property(_pythia8.PhaseSpace_sUpper_get, _pythia8.PhaseSpace_sUpper_set)
    __swig_setmethods__["fracFlatS"] = _pythia8.PhaseSpace_fracFlatS_set
    __swig_getmethods__["fracFlatS"] = _pythia8.PhaseSpace_fracFlatS_get
    if _newclass:
        fracFlatS = _swig_property(_pythia8.PhaseSpace_fracFlatS_get, _pythia8.PhaseSpace_fracFlatS_set)
    __swig_setmethods__["fracFlatM"] = _pythia8.PhaseSpace_fracFlatM_set
    __swig_getmethods__["fracFlatM"] = _pythia8.PhaseSpace_fracFlatM_get
    if _newclass:
        fracFlatM = _swig_property(_pythia8.PhaseSpace_fracFlatM_get, _pythia8.PhaseSpace_fracFlatM_set)
    __swig_setmethods__["fracInv"] = _pythia8.PhaseSpace_fracInv_set
    __swig_getmethods__["fracInv"] = _pythia8.PhaseSpace_fracInv_get
    if _newclass:
        fracInv = _swig_property(_pythia8.PhaseSpace_fracInv_get, _pythia8.PhaseSpace_fracInv_set)
    __swig_setmethods__["fracInv2"] = _pythia8.PhaseSpace_fracInv2_set
    __swig_getmethods__["fracInv2"] = _pythia8.PhaseSpace_fracInv2_get
    if _newclass:
        fracInv2 = _swig_property(_pythia8.PhaseSpace_fracInv2_get, _pythia8.PhaseSpace_fracInv2_set)
    __swig_setmethods__["atanLower"] = _pythia8.PhaseSpace_atanLower_set
    __swig_getmethods__["atanLower"] = _pythia8.PhaseSpace_atanLower_get
    if _newclass:
        atanLower = _swig_property(_pythia8.PhaseSpace_atanLower_get, _pythia8.PhaseSpace_atanLower_set)
    __swig_setmethods__["atanUpper"] = _pythia8.PhaseSpace_atanUpper_set
    __swig_getmethods__["atanUpper"] = _pythia8.PhaseSpace_atanUpper_get
    if _newclass:
        atanUpper = _swig_property(_pythia8.PhaseSpace_atanUpper_get, _pythia8.PhaseSpace_atanUpper_set)
    __swig_setmethods__["intBW"] = _pythia8.PhaseSpace_intBW_set
    __swig_getmethods__["intBW"] = _pythia8.PhaseSpace_intBW_get
    if _newclass:
        intBW = _swig_property(_pythia8.PhaseSpace_intBW_get, _pythia8.PhaseSpace_intBW_set)
    __swig_setmethods__["intFlatS"] = _pythia8.PhaseSpace_intFlatS_set
    __swig_getmethods__["intFlatS"] = _pythia8.PhaseSpace_intFlatS_get
    if _newclass:
        intFlatS = _swig_property(_pythia8.PhaseSpace_intFlatS_get, _pythia8.PhaseSpace_intFlatS_set)
    __swig_setmethods__["intFlatM"] = _pythia8.PhaseSpace_intFlatM_set
    __swig_getmethods__["intFlatM"] = _pythia8.PhaseSpace_intFlatM_get
    if _newclass:
        intFlatM = _swig_property(_pythia8.PhaseSpace_intFlatM_get, _pythia8.PhaseSpace_intFlatM_set)
    __swig_setmethods__["intInv"] = _pythia8.PhaseSpace_intInv_set
    __swig_getmethods__["intInv"] = _pythia8.PhaseSpace_intInv_get
    if _newclass:
        intInv = _swig_property(_pythia8.PhaseSpace_intInv_get, _pythia8.PhaseSpace_intInv_set)
    __swig_setmethods__["intInv2"] = _pythia8.PhaseSpace_intInv2_set
    __swig_getmethods__["intInv2"] = _pythia8.PhaseSpace_intInv2_get
    if _newclass:
        intInv2 = _swig_property(_pythia8.PhaseSpace_intInv2_get, _pythia8.PhaseSpace_intInv2_set)

    def setupMass1(self, iM):
        """
Properties specific to resonance mass selection in 2 -> 2 and 2 -> 3.
Setup mass selection for one resonance at a time. Split in two parts.
"""
        return _pythia8.PhaseSpace_setupMass1(self, iM)

    def setupMass2(self, iM, distToThresh):
        """
"""
        return _pythia8.PhaseSpace_setupMass2(self, iM, distToThresh)

    def trialMass(self, iM):
        """
Do mass selection and find the associated weight.
"""
        return _pythia8.PhaseSpace_trialMass(self, iM)

    def weightMass(self, iM):
        """
"""
        return _pythia8.PhaseSpace_weightMass(self, iM)

    def tRange(self, sIn, s1In, s2In, s3In, s4In):
        """
"""
        return _pythia8.PhaseSpace_tRange(self, sIn, s1In, s2In, s3In, s4In)

    def tInRange(self, tIn, sIn, s1In, s2In, s3In, s4In):
        """
"""
        return _pythia8.PhaseSpace_tInRange(self, tIn, sIn, s1In, s2In, s3In, s4In)
    def __disown__(self):
        self.this.disown()
        _pythia8.disown_PhaseSpace(self)
        return weakref_proxy(self)
PhaseSpace_swigregister = _pythia8.PhaseSpace_swigregister
PhaseSpace_swigregister(PhaseSpace)
PhaseSpace.NMAXTRY = _pythia8.cvar.PhaseSpace_NMAXTRY
PhaseSpace.NTRY3BODY = _pythia8.cvar.PhaseSpace_NTRY3BODY
PhaseSpace.SAFETYMARGIN = _pythia8.cvar.PhaseSpace_SAFETYMARGIN
PhaseSpace.TINY = _pythia8.cvar.PhaseSpace_TINY
PhaseSpace.EVENFRAC = _pythia8.cvar.PhaseSpace_EVENFRAC
PhaseSpace.SAMESIGMA = _pythia8.cvar.PhaseSpace_SAMESIGMA
PhaseSpace.MRESMINABS = _pythia8.cvar.PhaseSpace_MRESMINABS
PhaseSpace.WIDTHMARGIN = _pythia8.cvar.PhaseSpace_WIDTHMARGIN
PhaseSpace.SAMEMASS = _pythia8.cvar.PhaseSpace_SAMEMASS
PhaseSpace.MASSMARGIN = _pythia8.cvar.PhaseSpace_MASSMARGIN
PhaseSpace.EXTRABWWTMAX = _pythia8.cvar.PhaseSpace_EXTRABWWTMAX
PhaseSpace.THRESHOLDSIZE = _pythia8.cvar.PhaseSpace_THRESHOLDSIZE
PhaseSpace.THRESHOLDSTEP = _pythia8.cvar.PhaseSpace_THRESHOLDSTEP
PhaseSpace.YRANGEMARGIN = _pythia8.cvar.PhaseSpace_YRANGEMARGIN
PhaseSpace.LEPTONXMIN = _pythia8.cvar.PhaseSpace_LEPTONXMIN
PhaseSpace.LEPTONXMAX = _pythia8.cvar.PhaseSpace_LEPTONXMAX
PhaseSpace.LEPTONXLOGMIN = _pythia8.cvar.PhaseSpace_LEPTONXLOGMIN
PhaseSpace.LEPTONXLOGMAX = _pythia8.cvar.PhaseSpace_LEPTONXLOGMAX
PhaseSpace.LEPTONTAUMIN = _pythia8.cvar.PhaseSpace_LEPTONTAUMIN
PhaseSpace.SHATMINZ = _pythia8.cvar.PhaseSpace_SHATMINZ
PhaseSpace.PT2RATMINZ = _pythia8.cvar.PhaseSpace_PT2RATMINZ
PhaseSpace.WTCORRECTION = _pythia8.cvar.PhaseSpace_WTCORRECTION

class PhaseSpace2to1tauy(PhaseSpace):
    """
 double tmp = sqrt(1. - exp(-x2 * (4./M_PI + kx2) / (1. + kx2)));
 return ((x >= 0.) ? tmp : -tmp); }
"""
    __swig_setmethods__ = {}
    for _s in [PhaseSpace]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PhaseSpace2to1tauy, name, value)
    __swig_getmethods__ = {}
    for _s in [PhaseSpace]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PhaseSpace2to1tauy, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_PhaseSpace2to1tauy()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def setupSampling(self):
        """
Optimize subsequent kinematics selection.
"""
        return _pythia8.PhaseSpace2to1tauy_setupSampling(self)

    def trialKin(self, inEvent=True, arg3=False):
        """
Construct the trial kinematics.
"""
        return _pythia8.PhaseSpace2to1tauy_trialKin(self, inEvent, arg3)

    def finalKin(self):
        """
Construct the final event kinematics.
"""
        return _pythia8.PhaseSpace2to1tauy_finalKin(self)
    __swig_destroy__ = _pythia8.delete_PhaseSpace2to1tauy
    __del__ = lambda self: None
PhaseSpace2to1tauy_swigregister = _pythia8.PhaseSpace2to1tauy_swigregister
PhaseSpace2to1tauy_swigregister(PhaseSpace2to1tauy)

class PhaseSpace2to2tauyz(PhaseSpace):
    """
"""
    __swig_setmethods__ = {}
    for _s in [PhaseSpace]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PhaseSpace2to2tauyz, name, value)
    __swig_getmethods__ = {}
    for _s in [PhaseSpace]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PhaseSpace2to2tauyz, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_PhaseSpace2to2tauyz()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def setupSampling(self):
        """
Optimize subsequent kinematics selection.
"""
        return _pythia8.PhaseSpace2to2tauyz_setupSampling(self)

    def trialKin(self, inEvent=True, arg3=False):
        """
Construct the trial kinematics.
"""
        return _pythia8.PhaseSpace2to2tauyz_trialKin(self, inEvent, arg3)

    def finalKin(self):
        """
Construct the final event kinematics.
"""
        return _pythia8.PhaseSpace2to2tauyz_finalKin(self)

    def rescaleMomenta(self, sHatNew):
        """
Rescales the momenta of incoming and outgoing partons according to
new sHat.
"""
        return _pythia8.PhaseSpace2to2tauyz_rescaleMomenta(self, sHatNew)

    def rescaleSigma(self, sHatNew):
        """
Recalculates cross section with rescaled sHat.
"""
        return _pythia8.PhaseSpace2to2tauyz_rescaleSigma(self, sHatNew)

    def weightGammaPDFApprox(self):
        """
Calculate the weight for over-estimated cross section.
"""
        return _pythia8.PhaseSpace2to2tauyz_weightGammaPDFApprox(self)
    __swig_destroy__ = _pythia8.delete_PhaseSpace2to2tauyz
    __del__ = lambda self: None
PhaseSpace2to2tauyz_swigregister = _pythia8.PhaseSpace2to2tauyz_swigregister
PhaseSpace2to2tauyz_swigregister(PhaseSpace2to2tauyz)

class PhaseSpace2to2elastic(PhaseSpace):
    """
"""
    __swig_setmethods__ = {}
    for _s in [PhaseSpace]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PhaseSpace2to2elastic, name, value)
    __swig_getmethods__ = {}
    for _s in [PhaseSpace]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PhaseSpace2to2elastic, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_PhaseSpace2to2elastic()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def setupSampling(self):
        """
Construct the trial or final event kinematics.
"""
        return _pythia8.PhaseSpace2to2elastic_setupSampling(self)

    def trialKin(self, inEvent=True, arg3=False):
        """
"""
        return _pythia8.PhaseSpace2to2elastic_trialKin(self, inEvent, arg3)

    def finalKin(self):
        """
"""
        return _pythia8.PhaseSpace2to2elastic_finalKin(self)

    def isResolved(self):
        """
Are beam particles resolved in partons or scatter directly?
"""
        return _pythia8.PhaseSpace2to2elastic_isResolved(self)
    __swig_destroy__ = _pythia8.delete_PhaseSpace2to2elastic
    __del__ = lambda self: None
PhaseSpace2to2elastic_swigregister = _pythia8.PhaseSpace2to2elastic_swigregister
PhaseSpace2to2elastic_swigregister(PhaseSpace2to2elastic)

class PhaseSpace2to2diffractive(PhaseSpace):
    """
Constants: could only be changed in the code itself.
Kinematics properties specific to 2 -> 2 elastic.
"""
    __swig_setmethods__ = {}
    for _s in [PhaseSpace]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PhaseSpace2to2diffractive, name, value)
    __swig_getmethods__ = {}
    for _s in [PhaseSpace]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PhaseSpace2to2diffractive, name)
    __repr__ = _swig_repr

    def __init__(self, isDiffAin=False, isDiffBin=False):
        """
Constructor.
"""
        this = _pythia8.new_PhaseSpace2to2diffractive(isDiffAin, isDiffBin)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def setupSampling(self):
        """
Construct the trial or final event kinematics.
"""
        return _pythia8.PhaseSpace2to2diffractive_setupSampling(self)

    def trialKin(self, inEvent=True, arg3=False):
        """
"""
        return _pythia8.PhaseSpace2to2diffractive_trialKin(self, inEvent, arg3)

    def finalKin(self):
        """
"""
        return _pythia8.PhaseSpace2to2diffractive_finalKin(self)

    def isResolved(self):
        """
Are beam particles resolved in partons or scatter directly?
"""
        return _pythia8.PhaseSpace2to2diffractive_isResolved(self)
    __swig_destroy__ = _pythia8.delete_PhaseSpace2to2diffractive
    __del__ = lambda self: None
PhaseSpace2to2diffractive_swigregister = _pythia8.PhaseSpace2to2diffractive_swigregister
PhaseSpace2to2diffractive_swigregister(PhaseSpace2to2diffractive)

class PhaseSpace2to3diffractive(PhaseSpace):
    """
Constants: could only be changed in the code itself.
Initialization data.
Kinematics properties specific to 2 -> 2 diffraction.
"""
    __swig_setmethods__ = {}
    for _s in [PhaseSpace]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PhaseSpace2to3diffractive, name, value)
    __swig_getmethods__ = {}
    for _s in [PhaseSpace]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PhaseSpace2to3diffractive, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_PhaseSpace2to3diffractive()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def setupSampling(self):
        """
Construct the trial or final event kinematics.
"""
        return _pythia8.PhaseSpace2to3diffractive_setupSampling(self)

    def trialKin(self, inEvent=True, arg3=False):
        """
"""
        return _pythia8.PhaseSpace2to3diffractive_trialKin(self, inEvent, arg3)

    def finalKin(self):
        """
"""
        return _pythia8.PhaseSpace2to3diffractive_finalKin(self)

    def isResolved(self):
        """
Are beam particles resolved in partons or scatter directly?
"""
        return _pythia8.PhaseSpace2to3diffractive_isResolved(self)
    __swig_destroy__ = _pythia8.delete_PhaseSpace2to3diffractive
    __del__ = lambda self: None
PhaseSpace2to3diffractive_swigregister = _pythia8.PhaseSpace2to3diffractive_swigregister
PhaseSpace2to3diffractive_swigregister(PhaseSpace2to3diffractive)

class PhaseSpace2to2nondiffractive(PhaseSpace):
    """
Constants: could only be changed in the code itself.
Initialization data.
Local variables to calculate DPE kinematics.
"""
    __swig_setmethods__ = {}
    for _s in [PhaseSpace]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PhaseSpace2to2nondiffractive, name, value)
    __swig_getmethods__ = {}
    for _s in [PhaseSpace]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PhaseSpace2to2nondiffractive, name)

    def __init__(self, *args, **kwargs):
        """
A derived class for nondiffractive events. Hardly does anything, since
the real action is taken care of by the MultipartonInteractions class.
Constructor.
"""
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def setupSampling(self):
        """
Construct the trial or final event kinematics.
"""
        return _pythia8.PhaseSpace2to2nondiffractive_setupSampling(self)

    def trialKin(self, arg2, arg3=False):
        """
"""
        return _pythia8.PhaseSpace2to2nondiffractive_trialKin(self, arg2, arg3)

    def finalKin(self):
        """
"""
        return _pythia8.PhaseSpace2to2nondiffractive_finalKin(self)
    __swig_destroy__ = _pythia8.delete_PhaseSpace2to2nondiffractive
    __del__ = lambda self: None
PhaseSpace2to2nondiffractive_swigregister = _pythia8.PhaseSpace2to2nondiffractive_swigregister
PhaseSpace2to2nondiffractive_swigregister(PhaseSpace2to2nondiffractive)

class PhaseSpace2to3tauycyl(PhaseSpace):
    """
"""
    __swig_setmethods__ = {}
    for _s in [PhaseSpace]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PhaseSpace2to3tauycyl, name, value)
    __swig_getmethods__ = {}
    for _s in [PhaseSpace]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PhaseSpace2to3tauycyl, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_PhaseSpace2to3tauycyl()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def setupSampling(self):
        """
Optimize subsequent kinematics selection.
"""
        return _pythia8.PhaseSpace2to3tauycyl_setupSampling(self)

    def trialKin(self, inEvent=True, arg3=False):
        """
Construct the trial kinematics.
"""
        return _pythia8.PhaseSpace2to3tauycyl_trialKin(self, inEvent, arg3)

    def finalKin(self):
        """
Construct the final event kinematics.
"""
        return _pythia8.PhaseSpace2to3tauycyl_finalKin(self)
    __swig_destroy__ = _pythia8.delete_PhaseSpace2to3tauycyl
    __del__ = lambda self: None
PhaseSpace2to3tauycyl_swigregister = _pythia8.PhaseSpace2to3tauycyl_swigregister
PhaseSpace2to3tauycyl_swigregister(PhaseSpace2to3tauycyl)

class PhaseSpace2to3yyycyl(PhaseSpace):
    """
"""
    __swig_setmethods__ = {}
    for _s in [PhaseSpace]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PhaseSpace2to3yyycyl, name, value)
    __swig_getmethods__ = {}
    for _s in [PhaseSpace]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PhaseSpace2to3yyycyl, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_PhaseSpace2to3yyycyl()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def setupSampling(self):
        """
Optimize subsequent kinematics selection.
"""
        return _pythia8.PhaseSpace2to3yyycyl_setupSampling(self)

    def trialKin(self, inEvent=True, arg3=False):
        """
Construct the trial kinematics.
"""
        return _pythia8.PhaseSpace2to3yyycyl_trialKin(self, inEvent, arg3)

    def finalKin(self):
        """
Construct the final event kinematics.
"""
        return _pythia8.PhaseSpace2to3yyycyl_finalKin(self)
    __swig_destroy__ = _pythia8.delete_PhaseSpace2to3yyycyl
    __del__ = lambda self: None
PhaseSpace2to3yyycyl_swigregister = _pythia8.PhaseSpace2to3yyycyl_swigregister
PhaseSpace2to3yyycyl_swigregister(PhaseSpace2to3yyycyl)

class PhaseSpaceLHA(PhaseSpace):
    """
Phase space cuts specifically for 2 -> 3 QCD processes.
Event kinematics choices.
"""
    __swig_setmethods__ = {}
    for _s in [PhaseSpace]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, PhaseSpaceLHA, name, value)
    __swig_getmethods__ = {}
    for _s in [PhaseSpace]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, PhaseSpaceLHA, name)

    def __init__(self, *args, **kwargs):
        """
Constructor.
"""
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr

    def setupSampling(self):
        """
Find maximal cross section for comparison with internal processes.
"""
        return _pythia8.PhaseSpaceLHA_setupSampling(self)

    def trialKin(self, arg2, repeatSame=False):
        """
Construct the next process, by interface to Les Houches class.
"""
        return _pythia8.PhaseSpaceLHA_trialKin(self, arg2, repeatSame)

    def finalKin(self):
        """
Set scale, alpha_s and alpha_em if not done.
"""
        return _pythia8.PhaseSpaceLHA_finalKin(self)

    def sigmaSumSigned(self):
        """
For Les Houches with negative event weight needs
"""
        return _pythia8.PhaseSpaceLHA_sigmaSumSigned(self)
    __swig_destroy__ = _pythia8.delete_PhaseSpaceLHA
    __del__ = lambda self: None
PhaseSpaceLHA_swigregister = _pythia8.PhaseSpaceLHA_swigregister
PhaseSpaceLHA_swigregister(PhaseSpaceLHA)

class Sigma1qg2qStar(Sigma1Process):
    """
A derived class for q g -> q^* (excited quark state).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma1qg2qStar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma1qg2qStar, name)
    __repr__ = _swig_repr

    def __init__(self, idqIn):
        """
Constructor.
"""
        this = _pythia8.new_Sigma1qg2qStar(idqIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma1qg2qStar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma1qg2qStar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma1qg2qStar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma1qg2qStar_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for q* decay angles (else inactive).
"""
        return _pythia8.Sigma1qg2qStar_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma1qg2qStar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma1qg2qStar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma1qg2qStar_inFlux(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma1qg2qStar_resonanceA(self)
    __swig_destroy__ = _pythia8.delete_Sigma1qg2qStar
    __del__ = lambda self: None
Sigma1qg2qStar_swigregister = _pythia8.Sigma1qg2qStar_swigregister
Sigma1qg2qStar_swigregister(Sigma1qg2qStar)

class Sigma1lgm2lStar(Sigma1Process):
    """
A derived class for l gamma -> l^* (excited lepton state).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma1lgm2lStar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma1lgm2lStar, name)
    __repr__ = _swig_repr

    def __init__(self, idlIn):
        """
Constructor.
"""
        this = _pythia8.new_Sigma1lgm2lStar(idlIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma1lgm2lStar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma1lgm2lStar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma1lgm2lStar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma1lgm2lStar_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for l* decay angles (else inactive).
"""
        return _pythia8.Sigma1lgm2lStar_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma1lgm2lStar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma1lgm2lStar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma1lgm2lStar_inFlux(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma1lgm2lStar_resonanceA(self)
    __swig_destroy__ = _pythia8.delete_Sigma1lgm2lStar
    __del__ = lambda self: None
Sigma1lgm2lStar_swigregister = _pythia8.Sigma1lgm2lStar_swigregister
Sigma1lgm2lStar_swigregister(Sigma1lgm2lStar)

class Sigma2qq2qStarq(Sigma2Process):
    """
A derived class for q q' -> q^* q' (excited quark state).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qq2qStarq, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qq2qStarq, name)
    __repr__ = _swig_repr

    def __init__(self, idqIn):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qq2qStarq(idqIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2qq2qStarq_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qq2qStarq_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2qq2qStarq_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qq2qStarq_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for q* decay angles (else inactive).
"""
        return _pythia8.Sigma2qq2qStarq_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qq2qStarq_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qq2qStarq_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qq2qStarq_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2qq2qStarq_id3Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qq2qStarq
    __del__ = lambda self: None
Sigma2qq2qStarq_swigregister = _pythia8.Sigma2qq2qStarq_swigregister
Sigma2qq2qStarq_swigregister(Sigma2qq2qStarq)

class Sigma2qqbar2lStarlbar(Sigma2Process):
    """
A derived class for q qbar -> l^* lbar (excited lepton state).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qqbar2lStarlbar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qqbar2lStarlbar, name)
    __repr__ = _swig_repr

    def __init__(self, idlIn):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qqbar2lStarlbar(idlIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2qqbar2lStarlbar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qqbar2lStarlbar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2qqbar2lStarlbar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qqbar2lStarlbar_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for l* decay angles (else inactive).
"""
        return _pythia8.Sigma2qqbar2lStarlbar_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qqbar2lStarlbar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qqbar2lStarlbar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qqbar2lStarlbar_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2qqbar2lStarlbar_id3Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qqbar2lStarlbar
    __del__ = lambda self: None
Sigma2qqbar2lStarlbar_swigregister = _pythia8.Sigma2qqbar2lStarlbar_swigregister
Sigma2qqbar2lStarlbar_swigregister(Sigma2qqbar2lStarlbar)

class Sigma2qqbar2lStarlStarBar(Sigma2Process):
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qqbar2lStarlStarBar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qqbar2lStarlStarBar, name)
    __repr__ = _swig_repr

    def __init__(self, idlIn):
        this = _pythia8.new_Sigma2qqbar2lStarlStarBar(idlIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        return _pythia8.Sigma2qqbar2lStarlStarBar_initProc(self)

    def sigmaKin(self):
        return _pythia8.Sigma2qqbar2lStarlStarBar_sigmaKin(self)

    def sigmaHat(self):
        return _pythia8.Sigma2qqbar2lStarlStarBar_sigmaHat(self)

    def setIdColAcol(self):
        return _pythia8.Sigma2qqbar2lStarlStarBar_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        return _pythia8.Sigma2qqbar2lStarlStarBar_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        return _pythia8.Sigma2qqbar2lStarlStarBar_name(self)

    def code(self):
        return _pythia8.Sigma2qqbar2lStarlStarBar_code(self)

    def inFlux(self):
        return _pythia8.Sigma2qqbar2lStarlStarBar_inFlux(self)

    def id3Mass(self):
        return _pythia8.Sigma2qqbar2lStarlStarBar_id3Mass(self)

    def id4Mass(self):
        return _pythia8.Sigma2qqbar2lStarlStarBar_id4Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qqbar2lStarlStarBar
    __del__ = lambda self: None
Sigma2qqbar2lStarlStarBar_swigregister = _pythia8.Sigma2qqbar2lStarlStarBar_swigregister
Sigma2qqbar2lStarlStarBar_swigregister(Sigma2qqbar2lStarlStarBar)

class Sigma2QCqq2qq(Sigma2Process):
    """
A derived class for q q -> q q (quark contact interactions).
Based on, Sigma2qq2qq (QCD).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2QCqq2qq, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2QCqq2qq, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2QCqq2qq()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2QCqq2qq_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2QCqq2qq_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2QCqq2qq_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2QCqq2qq_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2QCqq2qq_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2QCqq2qq_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2QCqq2qq_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2QCqq2qq
    __del__ = lambda self: None
Sigma2QCqq2qq_swigregister = _pythia8.Sigma2QCqq2qq_swigregister
Sigma2QCqq2qq_swigregister(Sigma2QCqq2qq)

class Sigma2QCqqbar2qqbar(Sigma2Process):
    """
A derived class for q qbar -> q' qbar' (quark contact interactions).
Based on, Sigma2qqbar2qqbarNew(QCD).
Note: This process give the same contributions for q == q' and q != q'.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2QCqqbar2qqbar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2QCqqbar2qqbar, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2QCqqbar2qqbar()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2QCqqbar2qqbar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2QCqqbar2qqbar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2QCqqbar2qqbar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2QCqqbar2qqbar_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2QCqqbar2qqbar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2QCqqbar2qqbar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2QCqqbar2qqbar_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2QCqqbar2qqbar
    __del__ = lambda self: None
Sigma2QCqqbar2qqbar_swigregister = _pythia8.Sigma2QCqqbar2qqbar_swigregister
Sigma2QCqqbar2qqbar_swigregister(Sigma2QCqqbar2qqbar)

class Sigma2QCffbar2llbar(Sigma2Process):
    """
A derived class for f fbar -> l lbar
(contact interactions).
Does not include t-channel contributions relevant for e^+e^- to e^+e^-
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2QCffbar2llbar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2QCffbar2llbar, name)
    __repr__ = _swig_repr

    def __init__(self, idIn, codeIn):
        """
Constructor: bool Graviton  = true, to use LED graviton settings.
"""
        this = _pythia8.new_Sigma2QCffbar2llbar(idIn, codeIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2QCffbar2llbar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section;
first step when inflavours unknown.
"""
        return _pythia8.Sigma2QCffbar2llbar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat); second step for given inflavours.
"""
        return _pythia8.Sigma2QCffbar2llbar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2QCffbar2llbar_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2QCffbar2llbar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2QCffbar2llbar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2QCffbar2llbar_inFlux(self)

    def isSChannel(self):
        """
"""
        return _pythia8.Sigma2QCffbar2llbar_isSChannel(self)
    __swig_destroy__ = _pythia8.delete_Sigma2QCffbar2llbar
    __del__ = lambda self: None
Sigma2QCffbar2llbar_swigregister = _pythia8.Sigma2QCffbar2llbar_swigregister
Sigma2QCffbar2llbar_swigregister(Sigma2QCffbar2llbar)

class Sigma1ffbar2Zp2XX(Sigma1Process):
    """
A derived class for f fbar' -> Zprime -> X X. (Zprime a.k.a. DMmed(s=1).)
"""
    __swig_setmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma1ffbar2Zp2XX, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma1ffbar2Zp2XX, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma1ffbar2Zp2XX()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma1ffbar2Zp2XX_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma1ffbar2Zp2XX_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma1ffbar2Zp2XX_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma1ffbar2Zp2XX_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma1ffbar2Zp2XX_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma1ffbar2Zp2XX_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma1ffbar2Zp2XX_inFlux(self)

    def resonanceA(self):
        return _pythia8.Sigma1ffbar2Zp2XX_resonanceA(self)

    def isSChannel(self):
        """
Zprime
"""
        return _pythia8.Sigma1ffbar2Zp2XX_isSChannel(self)

    def gmZmode(self):
        """
"""
        return _pythia8.Sigma1ffbar2Zp2XX_gmZmode(self)
    __swig_destroy__ = _pythia8.delete_Sigma1ffbar2Zp2XX
    __del__ = lambda self: None
Sigma1ffbar2Zp2XX_swigregister = _pythia8.Sigma1ffbar2Zp2XX_swigregister
Sigma1ffbar2Zp2XX_swigregister(Sigma1ffbar2Zp2XX)

class Sigma2qqbar2Zpg2XXj(Sigma2Process):
    """
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qqbar2Zpg2XXj, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qqbar2Zpg2XXj, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qqbar2Zpg2XXj()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2qqbar2Zpg2XXj_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qqbar2Zpg2XXj_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2qqbar2Zpg2XXj_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qqbar2Zpg2XXj_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qqbar2Zpg2XXj_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qqbar2Zpg2XXj_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qqbar2Zpg2XXj_inFlux(self)

    def resonanceA(self):
        return _pythia8.Sigma2qqbar2Zpg2XXj_resonanceA(self)

    def id3Mass(self):
        """
Zprime
"""
        return _pythia8.Sigma2qqbar2Zpg2XXj_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2qqbar2Zpg2XXj_id4Mass(self)

    def isSChannel(self):
        """
"""
        return _pythia8.Sigma2qqbar2Zpg2XXj_isSChannel(self)

    def gmZmode(self):
        """
"""
        return _pythia8.Sigma2qqbar2Zpg2XXj_gmZmode(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qqbar2Zpg2XXj
    __del__ = lambda self: None
Sigma2qqbar2Zpg2XXj_swigregister = _pythia8.Sigma2qqbar2Zpg2XXj_swigregister
Sigma2qqbar2Zpg2XXj_swigregister(Sigma2qqbar2Zpg2XXj)

class Sigma2qg2Zpq2XXj(Sigma2qqbar2Zpg2XXj):
    """
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2qqbar2Zpg2XXj]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qg2Zpq2XXj, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2qqbar2Zpg2XXj]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qg2Zpq2XXj, name)

    def __init__(self, *args, **kwargs):
        """
Constructor.
"""
        raise AttributeError("No constructor defined")
    __repr__ = _swig_repr
    __swig_destroy__ = _pythia8.delete_Sigma2qg2Zpq2XXj
    __del__ = lambda self: None
Sigma2qg2Zpq2XXj_swigregister = _pythia8.Sigma2qg2Zpq2XXj_swigregister
Sigma2qg2Zpq2XXj_swigregister(Sigma2qg2Zpq2XXj)

class Sigma2ffbar2ZpH(Sigma2Process):
    """
A derived class for f fbar' -> Zprime H, Zprime -> X X.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2ZpH, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2ZpH, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ffbar2ZpH()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ffbar2ZpH_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2ffbar2ZpH_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2ffbar2ZpH_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2ZpH_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2ZpH_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2ZpH_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2ZpH_inFlux(self)

    def isSChannel(self):
        """
"""
        return _pythia8.Sigma2ffbar2ZpH_isSChannel(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2ZpH_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2ZpH_id4Mass(self)

    def resonanceA(self):
        return _pythia8.Sigma2ffbar2ZpH_resonanceA(self)

    def gmZmode(self):
        """
Zprime
"""
        return _pythia8.Sigma2ffbar2ZpH_gmZmode(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2ZpH
    __del__ = lambda self: None
Sigma2ffbar2ZpH_swigregister = _pythia8.Sigma2ffbar2ZpH_swigregister
Sigma2ffbar2ZpH_swigregister(Sigma2ffbar2ZpH)

class Sigma1gg2S2XX(Sigma1Process):
    """
"""
    __swig_setmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma1gg2S2XX, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma1gg2S2XX, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma1gg2S2XX()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma1gg2S2XX_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma1gg2S2XX_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma1gg2S2XX_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma1gg2S2XX_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma1gg2S2XX_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma1gg2S2XX_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma1gg2S2XX_inFlux(self)

    def resonanceA(self):
        return _pythia8.Sigma1gg2S2XX_resonanceA(self)

    def isSChannel(self):
        """
scalar mediator
"""
        return _pythia8.Sigma1gg2S2XX_isSChannel(self)
    __swig_destroy__ = _pythia8.delete_Sigma1gg2S2XX
    __del__ = lambda self: None
Sigma1gg2S2XX_swigregister = _pythia8.Sigma1gg2S2XX_swigregister
Sigma1gg2S2XX_swigregister(Sigma1gg2S2XX)

class Sigma2gg2Sg2XXj(Sigma2Process):
    """
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2gg2Sg2XXj, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2gg2Sg2XXj, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2gg2Sg2XXj()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2gg2Sg2XXj_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2gg2Sg2XXj_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2gg2Sg2XXj_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2gg2Sg2XXj_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2gg2Sg2XXj_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2gg2Sg2XXj_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2gg2Sg2XXj_inFlux(self)

    def resonanceA(self):
        return _pythia8.Sigma2gg2Sg2XXj_resonanceA(self)

    def isSChannel(self):
        """
scalar mediator
"""
        return _pythia8.Sigma2gg2Sg2XXj_isSChannel(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2gg2Sg2XXj_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2gg2Sg2XXj_id4Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2gg2Sg2XXj
    __del__ = lambda self: None
Sigma2gg2Sg2XXj_swigregister = _pythia8.Sigma2gg2Sg2XXj_swigregister
Sigma2gg2Sg2XXj_swigregister(Sigma2gg2Sg2XXj)

class Sigma2qg2Sq2XXj(Sigma2gg2Sg2XXj):
    """
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2gg2Sg2XXj]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qg2Sq2XXj, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2gg2Sg2XXj]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qg2Sq2XXj, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qg2Sq2XXj()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qg2Sq2XXj_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qg2Sq2XXj_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qg2Sq2XXj_inFlux(self)

    def isSChannel(self):
        """
"""
        return _pythia8.Sigma2qg2Sq2XXj_isSChannel(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qg2Sq2XXj
    __del__ = lambda self: None
Sigma2qg2Sq2XXj_swigregister = _pythia8.Sigma2qg2Sq2XXj_swigregister
Sigma2qg2Sq2XXj_swigregister(Sigma2qg2Sq2XXj)

class Sigma2qqbar2DY(Sigma2Process):
    """
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qqbar2DY, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qqbar2DY, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor,
"""
        this = _pythia8.new_Sigma2qqbar2DY()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2qqbar2DY_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qqbar2DY_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2qqbar2DY_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qqbar2DY_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qqbar2DY_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qqbar2DY_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qqbar2DY_inFlux(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma2qqbar2DY_resonanceA(self)

    def isSChannel(self):
        """
"""
        return _pythia8.Sigma2qqbar2DY_isSChannel(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2qqbar2DY_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2qqbar2DY_id4Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qqbar2DY
    __del__ = lambda self: None
Sigma2qqbar2DY_swigregister = _pythia8.Sigma2qqbar2DY_swigregister
Sigma2qqbar2DY_swigregister(Sigma2qqbar2DY)

class Sigma2qg2qgamma(Sigma2Process):
    """
A derived class for q g -> q gamma (q = u, d, s, c, b).
Use massless approximation also for Q since no alternative.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qg2qgamma, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qg2qgamma, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qg2qgamma()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qg2qgamma_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2qg2qgamma_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qg2qgamma_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qg2qgamma_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qg2qgamma_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qg2qgamma_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qg2qgamma
    __del__ = lambda self: None
Sigma2qg2qgamma_swigregister = _pythia8.Sigma2qg2qgamma_swigregister
Sigma2qg2qgamma_swigregister(Sigma2qg2qgamma)

class Sigma2qqbar2ggamma(Sigma2Process):
    """
A derived class for q qbar -> g gamma.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qqbar2ggamma, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qqbar2ggamma, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qqbar2ggamma()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qqbar2ggamma_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2qqbar2ggamma_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qqbar2ggamma_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qqbar2ggamma_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qqbar2ggamma_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qqbar2ggamma_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qqbar2ggamma
    __del__ = lambda self: None
Sigma2qqbar2ggamma_swigregister = _pythia8.Sigma2qqbar2ggamma_swigregister
Sigma2qqbar2ggamma_swigregister(Sigma2qqbar2ggamma)

class Sigma2gg2ggamma(Sigma2Process):
    """
A derived class for g g -> g gamma.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2gg2ggamma, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2gg2ggamma, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2gg2ggamma()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2gg2ggamma_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2gg2ggamma_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2gg2ggamma_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2gg2ggamma_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2gg2ggamma_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2gg2ggamma_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2gg2ggamma_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2gg2ggamma
    __del__ = lambda self: None
Sigma2gg2ggamma_swigregister = _pythia8.Sigma2gg2ggamma_swigregister
Sigma2gg2ggamma_swigregister(Sigma2gg2ggamma)

class Sigma2ffbar2gammagamma(Sigma2Process):
    """
A derived class for f fbar -> gamma gamma.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2gammagamma, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2gammagamma, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ffbar2gammagamma()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2ffbar2gammagamma_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2ffbar2gammagamma_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2gammagamma_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2gammagamma_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2gammagamma_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2gammagamma_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2gammagamma
    __del__ = lambda self: None
Sigma2ffbar2gammagamma_swigregister = _pythia8.Sigma2ffbar2gammagamma_swigregister
Sigma2ffbar2gammagamma_swigregister(Sigma2ffbar2gammagamma)

class Sigma2gg2gammagamma(Sigma2Process):
    """
A derived class for g g -> gamma gamma.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2gg2gammagamma, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2gg2gammagamma, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2gg2gammagamma()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2gg2gammagamma_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2gg2gammagamma_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2gg2gammagamma_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2gg2gammagamma_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2gg2gammagamma_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2gg2gammagamma_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2gg2gammagamma_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2gg2gammagamma
    __del__ = lambda self: None
Sigma2gg2gammagamma_swigregister = _pythia8.Sigma2gg2gammagamma_swigregister
Sigma2gg2gammagamma_swigregister(Sigma2gg2gammagamma)

class Sigma2ff2fftgmZ(Sigma2Process):
    """
A derived class for f f' -> f f' via t-channel gamma*/Z0 exchange.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ff2fftgmZ, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ff2fftgmZ, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ff2fftgmZ()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ff2fftgmZ_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2ff2fftgmZ_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2ff2fftgmZ_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ff2fftgmZ_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ff2fftgmZ_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ff2fftgmZ_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ff2fftgmZ_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ff2fftgmZ
    __del__ = lambda self: None
Sigma2ff2fftgmZ_swigregister = _pythia8.Sigma2ff2fftgmZ_swigregister
Sigma2ff2fftgmZ_swigregister(Sigma2ff2fftgmZ)

class Sigma2ff2fftW(Sigma2Process):
    """
A derived class for f_1 f_2 -> f_3 f_4 via t-channel W+- exchange.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ff2fftW, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ff2fftW, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ff2fftW()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ff2fftW_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2ff2fftW_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2ff2fftW_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ff2fftW_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ff2fftW_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ff2fftW_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ff2fftW_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ff2fftW
    __del__ = lambda self: None
Sigma2ff2fftW_swigregister = _pythia8.Sigma2ff2fftW_swigregister
Sigma2ff2fftW_swigregister(Sigma2ff2fftW)

class Sigma2qq2QqtW(Sigma2Process):
    """
A derived class for q q' -> Q q" via t-channel W+- exchange.
Related to Sigma2ff2fftW class, but with massive matrix elements.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qq2QqtW, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qq2QqtW, name)
    __repr__ = _swig_repr

    def __init__(self, idIn, codeIn):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qq2QqtW(idIn, codeIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2qq2QqtW_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qq2QqtW_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2qq2QqtW_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qq2QqtW_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for W decay angles in top decay (else inactive).
"""
        return _pythia8.Sigma2qq2QqtW_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qq2QqtW_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qq2QqtW_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qq2QqtW_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2qq2QqtW_id3Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qq2QqtW
    __del__ = lambda self: None
Sigma2qq2QqtW_swigregister = _pythia8.Sigma2qq2QqtW_swigregister
Sigma2qq2QqtW_swigregister(Sigma2qq2QqtW)

class Sigma1ffbar2gmZ(Sigma1Process):
    """
A derived class for f fbar -> gamma*/Z0.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma1ffbar2gmZ, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma1ffbar2gmZ, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma1ffbar2gmZ()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma1ffbar2gmZ_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma1ffbar2gmZ_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma1ffbar2gmZ_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma1ffbar2gmZ_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for Z decay angle.
"""
        return _pythia8.Sigma1ffbar2gmZ_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma1ffbar2gmZ_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma1ffbar2gmZ_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma1ffbar2gmZ_inFlux(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma1ffbar2gmZ_resonanceA(self)
    __swig_destroy__ = _pythia8.delete_Sigma1ffbar2gmZ
    __del__ = lambda self: None
Sigma1ffbar2gmZ_swigregister = _pythia8.Sigma1ffbar2gmZ_swigregister
Sigma1ffbar2gmZ_swigregister(Sigma1ffbar2gmZ)

class Sigma1ffbar2W(Sigma1Process):
    """
A derived class for f fbar' -> W+-.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma1ffbar2W, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma1ffbar2W, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma1ffbar2W()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma1ffbar2W_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma1ffbar2W_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma1ffbar2W_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma1ffbar2W_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for W decay angle.
"""
        return _pythia8.Sigma1ffbar2W_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma1ffbar2W_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma1ffbar2W_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma1ffbar2W_inFlux(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma1ffbar2W_resonanceA(self)
    __swig_destroy__ = _pythia8.delete_Sigma1ffbar2W
    __del__ = lambda self: None
Sigma1ffbar2W_swigregister = _pythia8.Sigma1ffbar2W_swigregister
Sigma1ffbar2W_swigregister(Sigma1ffbar2W)

class Sigma2ffbar2ffbarsgm(Sigma2Process):
    """
A derived class for f fbar -> gamma* -> f' fbar', summed over light f'.
Allows pT-ordered evolution for multiparton interactions.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2ffbarsgm, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2ffbarsgm, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ffbar2ffbarsgm()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2ffbar2ffbarsgm_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2ffbar2ffbarsgm_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2ffbarsgm_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2ffbarsgm_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2ffbarsgm_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2ffbarsgm_inFlux(self)

    def isSChannel(self):
        """
"""
        return _pythia8.Sigma2ffbar2ffbarsgm_isSChannel(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2ffbarsgm
    __del__ = lambda self: None
Sigma2ffbar2ffbarsgm_swigregister = _pythia8.Sigma2ffbar2ffbarsgm_swigregister
Sigma2ffbar2ffbarsgm_swigregister(Sigma2ffbar2ffbarsgm)

class Sigma2ffbar2ffbarsgmZ(Sigma2Process):
    """
A derived class for f fbar -> gamma*/Z0 -> f' fbar', summed over light f.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2ffbarsgmZ, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2ffbarsgmZ, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ffbar2ffbarsgmZ()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ffbar2ffbarsgmZ_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2ffbar2ffbarsgmZ_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2ffbar2ffbarsgmZ_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2ffbarsgmZ_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2ffbarsgmZ_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2ffbarsgmZ_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2ffbarsgmZ_inFlux(self)

    def isSChannel(self):
        """
"""
        return _pythia8.Sigma2ffbar2ffbarsgmZ_isSChannel(self)

    def idSChannel(self):
        """
"""
        return _pythia8.Sigma2ffbar2ffbarsgmZ_idSChannel(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma2ffbar2ffbarsgmZ_resonanceA(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2ffbarsgmZ
    __del__ = lambda self: None
Sigma2ffbar2ffbarsgmZ_swigregister = _pythia8.Sigma2ffbar2ffbarsgmZ_swigregister
Sigma2ffbar2ffbarsgmZ_swigregister(Sigma2ffbar2ffbarsgmZ)

class Sigma2ffbar2ffbarsW(Sigma2Process):
    """
A derived class for f_1 fbar_2 -> W+- -> f_3 fbar_4, summed over light f.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2ffbarsW, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2ffbarsW, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ffbar2ffbarsW()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ffbar2ffbarsW_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2ffbar2ffbarsW_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2ffbar2ffbarsW_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2ffbarsW_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2ffbarsW_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2ffbarsW_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2ffbarsW_inFlux(self)

    def isSChannel(self):
        """
"""
        return _pythia8.Sigma2ffbar2ffbarsW_isSChannel(self)

    def idSChannel(self):
        """
"""
        return _pythia8.Sigma2ffbar2ffbarsW_idSChannel(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma2ffbar2ffbarsW_resonanceA(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2ffbarsW
    __del__ = lambda self: None
Sigma2ffbar2ffbarsW_swigregister = _pythia8.Sigma2ffbar2ffbarsW_swigregister
Sigma2ffbar2ffbarsW_swigregister(Sigma2ffbar2ffbarsW)

class Sigma2ffbar2FFbarsgmZ(Sigma2Process):
    """
A derived class for f fbar -> gamma*/Z0 -> F Fbar, for one heavy F.
Allows pT cuts as for other 2 -> 2 processes.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2FFbarsgmZ, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2FFbarsgmZ, name)
    __repr__ = _swig_repr

    def __init__(self, idIn, codeIn):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ffbar2FFbarsgmZ(idIn, codeIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ffbar2FFbarsgmZ_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2ffbar2FFbarsgmZ_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2ffbar2FFbarsgmZ_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2FFbarsgmZ_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for W decay angles in top decay (else inactive).
"""
        return _pythia8.Sigma2ffbar2FFbarsgmZ_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2FFbarsgmZ_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2FFbarsgmZ_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2FFbarsgmZ_inFlux(self)

    def isSChannel(self):
        """
"""
        return _pythia8.Sigma2ffbar2FFbarsgmZ_isSChannel(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2FFbarsgmZ_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2FFbarsgmZ_id4Mass(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma2ffbar2FFbarsgmZ_resonanceA(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2FFbarsgmZ
    __del__ = lambda self: None
Sigma2ffbar2FFbarsgmZ_swigregister = _pythia8.Sigma2ffbar2FFbarsgmZ_swigregister
Sigma2ffbar2FFbarsgmZ_swigregister(Sigma2ffbar2FFbarsgmZ)

class Sigma2ffbar2FfbarsW(Sigma2Process):
    """
A derived class for f fbar' -> W+- -> F fbar", for one or two heavy F.
Allows pT cuts as for other 2 -> 2 processes.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2FfbarsW, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2FfbarsW, name)
    __repr__ = _swig_repr

    def __init__(self, idIn, idIn2, codeIn):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ffbar2FfbarsW(idIn, idIn2, codeIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ffbar2FfbarsW_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2ffbar2FfbarsW_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2ffbar2FfbarsW_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2FfbarsW_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for W decay angles in top decay (else inactive).
"""
        return _pythia8.Sigma2ffbar2FfbarsW_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2FfbarsW_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2FfbarsW_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2FfbarsW_inFlux(self)

    def isSChannel(self):
        """
"""
        return _pythia8.Sigma2ffbar2FfbarsW_isSChannel(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2FfbarsW_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2FfbarsW_id4Mass(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma2ffbar2FfbarsW_resonanceA(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2FfbarsW
    __del__ = lambda self: None
Sigma2ffbar2FfbarsW_swigregister = _pythia8.Sigma2ffbar2FfbarsW_swigregister
Sigma2ffbar2FfbarsW_swigregister(Sigma2ffbar2FfbarsW)

class Sigma2ffbargmZWgmZW(Sigma2Process):
    """
An intermediate class for f fbar -> gamma*/Z0/W+- gamma*/Z0/W-+.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbargmZWgmZW, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbargmZWgmZW, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ffbargmZWgmZW()
        try:
            self.this.append(this)
        except Exception:
            self.this = this
    __swig_destroy__ = _pythia8.delete_Sigma2ffbargmZWgmZW
    __del__ = lambda self: None
Sigma2ffbargmZWgmZW_swigregister = _pythia8.Sigma2ffbargmZWgmZW_swigregister
Sigma2ffbargmZWgmZW_swigregister(Sigma2ffbargmZWgmZW)

class Sigma2ffbar2gmZgmZ(Sigma2ffbargmZWgmZW):
    """
A derived class for f fbar -> gamma*/Z0 gamma*/Z0.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2ffbargmZWgmZW]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2gmZgmZ, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2ffbargmZWgmZW]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2gmZgmZ, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ffbar2gmZgmZ()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ffbar2gmZgmZ_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2ffbar2gmZgmZ_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2ffbar2gmZgmZ_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2gmZgmZ_setIdColAcol(self)

    def weightDecayFlav(self, process):
        """
Evaluate weight for simultaneous flavour choices.
"""
        return _pythia8.Sigma2ffbar2gmZgmZ_weightDecayFlav(self, process)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for decay angles of the two gamma*/Z0.
"""
        return _pythia8.Sigma2ffbar2gmZgmZ_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2gmZgmZ_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2gmZgmZ_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2gmZgmZ_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2gmZgmZ_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2gmZgmZ_id4Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2gmZgmZ
    __del__ = lambda self: None
Sigma2ffbar2gmZgmZ_swigregister = _pythia8.Sigma2ffbar2gmZgmZ_swigregister
Sigma2ffbar2gmZgmZ_swigregister(Sigma2ffbar2gmZgmZ)

class Sigma2ffbar2ZW(Sigma2ffbargmZWgmZW):
    """
A derived class for f fbar' -> Z0 W+-. (Here pure Z0, unfortunately.)
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2ffbargmZWgmZW]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2ZW, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2ffbargmZWgmZW]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2ZW, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ffbar2ZW()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ffbar2ZW_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2ffbar2ZW_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2ffbar2ZW_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2ZW_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for Z0 and W+- decay angles.
"""
        return _pythia8.Sigma2ffbar2ZW_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2ZW_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2ZW_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2ZW_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2ZW_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2ZW_id4Mass(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma2ffbar2ZW_resonanceA(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2ZW
    __del__ = lambda self: None
Sigma2ffbar2ZW_swigregister = _pythia8.Sigma2ffbar2ZW_swigregister
Sigma2ffbar2ZW_swigregister(Sigma2ffbar2ZW)

class Sigma2ffbar2WW(Sigma2ffbargmZWgmZW):
    """
A derived class for f fbar -> W+ W-.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2ffbargmZWgmZW]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2WW, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2ffbargmZWgmZW]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2WW, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ffbar2WW()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ffbar2WW_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2ffbar2WW_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2ffbar2WW_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2WW_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for W+ and W- decay angles.
"""
        return _pythia8.Sigma2ffbar2WW_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2WW_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2WW_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2WW_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2WW_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2WW_id4Mass(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma2ffbar2WW_resonanceA(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2WW
    __del__ = lambda self: None
Sigma2ffbar2WW_swigregister = _pythia8.Sigma2ffbar2WW_swigregister
Sigma2ffbar2WW_swigregister(Sigma2ffbar2WW)

class Sigma2ffbargmZggm(Sigma2Process):
    """
An intermediate class for f fbar -> gamma*/Z0 g/gamma and permutations.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbargmZggm, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbargmZggm, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ffbargmZggm()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ffbargmZggm_initProc(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for gamma&/Z0 decay angle.
"""
        return _pythia8.Sigma2ffbargmZggm_weightDecay(self, process, iResBeg, iResEnd)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbargmZggm
    __del__ = lambda self: None
Sigma2ffbargmZggm_swigregister = _pythia8.Sigma2ffbargmZggm_swigregister
Sigma2ffbargmZggm_swigregister(Sigma2ffbargmZggm)

class Sigma2qqbar2gmZg(Sigma2ffbargmZggm):
    """
A derived class for q qbar -> gamma*/Z0 g.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2ffbargmZggm]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qqbar2gmZg, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2ffbargmZggm]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qqbar2gmZg, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qqbar2gmZg()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qqbar2gmZg_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2qqbar2gmZg_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qqbar2gmZg_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qqbar2gmZg_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qqbar2gmZg_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qqbar2gmZg_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2qqbar2gmZg_id3Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qqbar2gmZg
    __del__ = lambda self: None
Sigma2qqbar2gmZg_swigregister = _pythia8.Sigma2qqbar2gmZg_swigregister
Sigma2qqbar2gmZg_swigregister(Sigma2qqbar2gmZg)

class Sigma2qg2gmZq(Sigma2ffbargmZggm):
    """
A derived class for q g -> gamma*/Z0 q.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2ffbargmZggm]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qg2gmZq, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2ffbargmZggm]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qg2gmZq, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qg2gmZq()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qg2gmZq_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2qg2gmZq_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qg2gmZq_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qg2gmZq_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qg2gmZq_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qg2gmZq_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2qg2gmZq_id3Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qg2gmZq
    __del__ = lambda self: None
Sigma2qg2gmZq_swigregister = _pythia8.Sigma2qg2gmZq_swigregister
Sigma2qg2gmZq_swigregister(Sigma2qg2gmZq)

class Sigma2ffbar2gmZgm(Sigma2ffbargmZggm):
    """
A derived class for f fbar' -> gamma*/Z0 gamma.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2ffbargmZggm]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2gmZgm, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2ffbargmZggm]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2gmZgm, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ffbar2gmZgm()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2ffbar2gmZgm_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2ffbar2gmZgm_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2gmZgm_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2gmZgm_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2gmZgm_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2gmZgm_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2gmZgm_id3Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2gmZgm
    __del__ = lambda self: None
Sigma2ffbar2gmZgm_swigregister = _pythia8.Sigma2ffbar2gmZgm_swigregister
Sigma2ffbar2gmZgm_swigregister(Sigma2ffbar2gmZgm)

class Sigma2fgm2gmZf(Sigma2ffbargmZggm):
    """
A derived class for f gamma -> gamma*/Z0 f.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2ffbargmZggm]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2fgm2gmZf, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2ffbargmZggm]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2fgm2gmZf, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2fgm2gmZf()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2fgm2gmZf_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2fgm2gmZf_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2fgm2gmZf_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2fgm2gmZf_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2fgm2gmZf_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2fgm2gmZf_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2fgm2gmZf_id3Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2fgm2gmZf
    __del__ = lambda self: None
Sigma2fgm2gmZf_swigregister = _pythia8.Sigma2fgm2gmZf_swigregister
Sigma2fgm2gmZf_swigregister(Sigma2fgm2gmZf)

class Sigma2ffbarWggm(Sigma2Process):
    """
An intermediate class for f fbar -> W+- g/gamma and permutations.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbarWggm, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbarWggm, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ffbarWggm()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for gamma&/Z0 decay angle.
"""
        return _pythia8.Sigma2ffbarWggm_weightDecay(self, process, iResBeg, iResEnd)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbarWggm
    __del__ = lambda self: None
Sigma2ffbarWggm_swigregister = _pythia8.Sigma2ffbarWggm_swigregister
Sigma2ffbarWggm_swigregister(Sigma2ffbarWggm)

class Sigma2qqbar2Wg(Sigma2ffbarWggm):
    """
A derived class for q qbar' -> W+- g.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2ffbarWggm]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qqbar2Wg, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2ffbarWggm]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qqbar2Wg, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qqbar2Wg()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2qqbar2Wg_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qqbar2Wg_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2qqbar2Wg_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qqbar2Wg_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qqbar2Wg_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qqbar2Wg_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qqbar2Wg_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2qqbar2Wg_id3Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qqbar2Wg
    __del__ = lambda self: None
Sigma2qqbar2Wg_swigregister = _pythia8.Sigma2qqbar2Wg_swigregister
Sigma2qqbar2Wg_swigregister(Sigma2qqbar2Wg)

class Sigma2qg2Wq(Sigma2ffbarWggm):
    """
A derived class for q g -> W+- q'.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2ffbarWggm]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qg2Wq, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2ffbarWggm]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qg2Wq, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qg2Wq()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2qg2Wq_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qg2Wq_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2qg2Wq_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qg2Wq_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qg2Wq_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qg2Wq_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qg2Wq_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2qg2Wq_id3Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qg2Wq
    __del__ = lambda self: None
Sigma2qg2Wq_swigregister = _pythia8.Sigma2qg2Wq_swigregister
Sigma2qg2Wq_swigregister(Sigma2qg2Wq)

class Sigma2ffbar2Wgm(Sigma2ffbarWggm):
    """
A derived class for f fbar' -> W+- gamma.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2ffbarWggm]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2Wgm, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2ffbarWggm]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2Wgm, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ffbar2Wgm()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ffbar2Wgm_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2ffbar2Wgm_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2ffbar2Wgm_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2Wgm_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2Wgm_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2Wgm_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2Wgm_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2Wgm_id3Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2Wgm
    __del__ = lambda self: None
Sigma2ffbar2Wgm_swigregister = _pythia8.Sigma2ffbar2Wgm_swigregister
Sigma2ffbar2Wgm_swigregister(Sigma2ffbar2Wgm)

class Sigma2fgm2Wf(Sigma2ffbarWggm):
    """
A derived class for f gamma -> W+- f'.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2ffbarWggm]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2fgm2Wf, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2ffbarWggm]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2fgm2Wf, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2fgm2Wf()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2fgm2Wf_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2fgm2Wf_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2fgm2Wf_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2fgm2Wf_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2fgm2Wf_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2fgm2Wf_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2fgm2Wf_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2fgm2Wf_id3Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2fgm2Wf
    __del__ = lambda self: None
Sigma2fgm2Wf_swigregister = _pythia8.Sigma2fgm2Wf_swigregister
Sigma2fgm2Wf_swigregister(Sigma2fgm2Wf)

class Sigma2gmgm2ffbar(Sigma2Process):
    """
A derived class for gamma gamma -> f fbar.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2gmgm2ffbar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2gmgm2ffbar, name)
    __repr__ = _swig_repr

    def __init__(self, idIn, codeIn):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2gmgm2ffbar(idIn, codeIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2gmgm2ffbar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2gmgm2ffbar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2gmgm2ffbar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2gmgm2ffbar_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2gmgm2ffbar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2gmgm2ffbar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2gmgm2ffbar_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2gmgm2ffbar_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2gmgm2ffbar_id4Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2gmgm2ffbar
    __del__ = lambda self: None
Sigma2gmgm2ffbar_swigregister = _pythia8.Sigma2gmgm2ffbar_swigregister
Sigma2gmgm2ffbar_swigregister(Sigma2gmgm2ffbar)

class Sigma2ggm2qqbar(Sigma2Process):
    """
A derived class for g gamma -> q qbar (q = u, d, s, c, b).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ggm2qqbar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ggm2qqbar, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ggm2qqbar(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ggm2qqbar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2ggm2qqbar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2ggm2qqbar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ggm2qqbar_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ggm2qqbar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ggm2qqbar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ggm2qqbar_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2ggm2qqbar_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2ggm2qqbar_id4Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ggm2qqbar
    __del__ = lambda self: None
Sigma2ggm2qqbar_swigregister = _pythia8.Sigma2ggm2qqbar_swigregister
Sigma2ggm2qqbar_swigregister(Sigma2ggm2qqbar)

class Sigma2qgm2qg(Sigma2Process):
    """
A derived class for q gamma -> q g (q = u, d, s, c, b).
Use massless approximation also for Q since no alternative.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qgm2qg, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qgm2qg, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qgm2qg(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process according to in flux.
"""
        return _pythia8.Sigma2qgm2qg_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qgm2qg_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2qgm2qg_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qgm2qg_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qgm2qg_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qgm2qg_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qgm2qg_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qgm2qg
    __del__ = lambda self: None
Sigma2qgm2qg_swigregister = _pythia8.Sigma2qgm2qg_swigregister
Sigma2qgm2qg_swigregister(Sigma2qgm2qg)

class Sigma2qgm2qgm(Sigma2Process):
    """
A derived class for q gamma -> q gamma (q = u, d, s, c, b).
Use massless approximation also for Q since no alternative.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qgm2qgm, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qgm2qgm, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qgm2qgm(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2qgm2qgm_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qgm2qgm_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2qgm2qgm_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qgm2qgm_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qgm2qgm_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qgm2qgm_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qgm2qgm_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qgm2qgm
    __del__ = lambda self: None
Sigma2qgm2qgm_swigregister = _pythia8.Sigma2qgm2qgm_swigregister
Sigma2qgm2qgm_swigregister(Sigma2qgm2qgm)

class Sigma1gg2GravitonStar(Sigma1Process):
    """
A derived class for g g -> G^* (excited graviton state).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma1gg2GravitonStar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma1gg2GravitonStar, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma1gg2GravitonStar()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma1gg2GravitonStar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma1gg2GravitonStar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma1gg2GravitonStar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma1gg2GravitonStar_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for G* decay angle.
"""
        return _pythia8.Sigma1gg2GravitonStar_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma1gg2GravitonStar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma1gg2GravitonStar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma1gg2GravitonStar_inFlux(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma1gg2GravitonStar_resonanceA(self)
    __swig_destroy__ = _pythia8.delete_Sigma1gg2GravitonStar
    __del__ = lambda self: None
Sigma1gg2GravitonStar_swigregister = _pythia8.Sigma1gg2GravitonStar_swigregister
Sigma1gg2GravitonStar_swigregister(Sigma1gg2GravitonStar)

class Sigma1ffbar2GravitonStar(Sigma1Process):
    """
A derived class for f fbar -> G^* (excited graviton state).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma1ffbar2GravitonStar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma1ffbar2GravitonStar, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma1ffbar2GravitonStar()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma1ffbar2GravitonStar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma1ffbar2GravitonStar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma1ffbar2GravitonStar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma1ffbar2GravitonStar_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for G* decay angle.
"""
        return _pythia8.Sigma1ffbar2GravitonStar_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma1ffbar2GravitonStar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma1ffbar2GravitonStar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma1ffbar2GravitonStar_inFlux(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma1ffbar2GravitonStar_resonanceA(self)
    __swig_destroy__ = _pythia8.delete_Sigma1ffbar2GravitonStar
    __del__ = lambda self: None
Sigma1ffbar2GravitonStar_swigregister = _pythia8.Sigma1ffbar2GravitonStar_swigregister
Sigma1ffbar2GravitonStar_swigregister(Sigma1ffbar2GravitonStar)

class Sigma1qqbar2KKgluonStar(Sigma1Process):
    """
A derived class for q qbar -> g^*/KK-gluon^* (excited kk-gluon state).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma1qqbar2KKgluonStar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma1qqbar2KKgluonStar, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma1qqbar2KKgluonStar()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma1qqbar2KKgluonStar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma1qqbar2KKgluonStar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma1qqbar2KKgluonStar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma1qqbar2KKgluonStar_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for g* decay angle.
"""
        return _pythia8.Sigma1qqbar2KKgluonStar_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma1qqbar2KKgluonStar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma1qqbar2KKgluonStar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma1qqbar2KKgluonStar_inFlux(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma1qqbar2KKgluonStar_resonanceA(self)
    __swig_destroy__ = _pythia8.delete_Sigma1qqbar2KKgluonStar
    __del__ = lambda self: None
Sigma1qqbar2KKgluonStar_swigregister = _pythia8.Sigma1qqbar2KKgluonStar_swigregister
Sigma1qqbar2KKgluonStar_swigregister(Sigma1qqbar2KKgluonStar)

class Sigma2gg2GravitonStarg(Sigma2Process):
    """
A derived class for g g -> G^* g (excited graviton state).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2gg2GravitonStarg, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2gg2GravitonStarg, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2gg2GravitonStarg()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2gg2GravitonStarg_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2gg2GravitonStarg_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2gg2GravitonStarg_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2gg2GravitonStarg_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight: currently isotropic (except secondary top decay)..
"""
        return _pythia8.Sigma2gg2GravitonStarg_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2gg2GravitonStarg_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2gg2GravitonStarg_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2gg2GravitonStarg_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2gg2GravitonStarg_id3Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2gg2GravitonStarg
    __del__ = lambda self: None
Sigma2gg2GravitonStarg_swigregister = _pythia8.Sigma2gg2GravitonStarg_swigregister
Sigma2gg2GravitonStarg_swigregister(Sigma2gg2GravitonStarg)

class Sigma2qg2GravitonStarq(Sigma2Process):
    """
A derived class for q g -> G^* q (excited graviton state).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qg2GravitonStarq, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qg2GravitonStarq, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qg2GravitonStarq()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2qg2GravitonStarq_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qg2GravitonStarq_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2qg2GravitonStarq_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qg2GravitonStarq_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight: currently isotropic (except secondary top decay).
"""
        return _pythia8.Sigma2qg2GravitonStarq_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qg2GravitonStarq_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qg2GravitonStarq_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qg2GravitonStarq_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2qg2GravitonStarq_id3Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qg2GravitonStarq
    __del__ = lambda self: None
Sigma2qg2GravitonStarq_swigregister = _pythia8.Sigma2qg2GravitonStarq_swigregister
Sigma2qg2GravitonStarq_swigregister(Sigma2qg2GravitonStarq)

class Sigma2qqbar2GravitonStarg(Sigma2Process):
    """
A derived class for q qbar -> G^* g (excited graviton state).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qqbar2GravitonStarg, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qqbar2GravitonStarg, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qqbar2GravitonStarg()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2qqbar2GravitonStarg_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qqbar2GravitonStarg_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2qqbar2GravitonStarg_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qqbar2GravitonStarg_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight: currently isotropic (except secondary top decay).
"""
        return _pythia8.Sigma2qqbar2GravitonStarg_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qqbar2GravitonStarg_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qqbar2GravitonStarg_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qqbar2GravitonStarg_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2qqbar2GravitonStarg_id3Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qqbar2GravitonStarg
    __del__ = lambda self: None
Sigma2qqbar2GravitonStarg_swigregister = _pythia8.Sigma2qqbar2GravitonStarg_swigregister
Sigma2qqbar2GravitonStarg_swigregister(Sigma2qqbar2GravitonStarg)

class Sigma2ffbar2TEVffbar(Sigma2Process):
    """
NOAM: A derived class for, f fbar -> (gamma/Z)_KKTower -> F Fbar,
for one heavy F.
Process provided by N. Hod et al. and is described in arXiv:XXXX.YYYY
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2TEVffbar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2TEVffbar, name)
    __repr__ = _swig_repr

    def __init__(self, idIn, codeIn):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ffbar2TEVffbar(idIn, codeIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ffbar2TEVffbar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2ffbar2TEVffbar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2ffbar2TEVffbar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2TEVffbar_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for W decay angles in top decay (else inactive).
"""
        return _pythia8.Sigma2ffbar2TEVffbar_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2TEVffbar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2TEVffbar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2TEVffbar_inFlux(self)

    def isSChannel(self):
        """
"""
        return _pythia8.Sigma2ffbar2TEVffbar_isSChannel(self)

    def idSChannel(self):
        """
"""
        return _pythia8.Sigma2ffbar2TEVffbar_idSChannel(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2TEVffbar_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2TEVffbar_id4Mass(self)

    def resonanceA(self, *args):
        """
Add phase-space sampling also around the Z_KK resonance.
"""
        return _pythia8.Sigma2ffbar2TEVffbar_resonanceA(self, *args)

    def resonanceB(self, *args):
        """
"""
        return _pythia8.Sigma2ffbar2TEVffbar_resonanceB(self, *args)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2TEVffbar
    __del__ = lambda self: None
Sigma2ffbar2TEVffbar_swigregister = _pythia8.Sigma2ffbar2TEVffbar_swigregister
Sigma2ffbar2TEVffbar_swigregister(Sigma2ffbar2TEVffbar)

class Sigma2gg2LEDUnparticleg(Sigma2Process):
    """
A derived class for g g -> U/G g (real graviton emission in
large extra dimensions or unparticle emission).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2gg2LEDUnparticleg, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2gg2LEDUnparticleg, name)
    __repr__ = _swig_repr

    def __init__(self, Graviton):
        """
Constructor: bool Graviton  = true, to use LED graviton settings.
"""
        this = _pythia8.new_Sigma2gg2LEDUnparticleg(Graviton)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2gg2LEDUnparticleg_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section;
first step when inflavours unknown.
"""
        return _pythia8.Sigma2gg2LEDUnparticleg_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat); second step for given inflavours.
"""
        return _pythia8.Sigma2gg2LEDUnparticleg_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2gg2LEDUnparticleg_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2gg2LEDUnparticleg_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2gg2LEDUnparticleg_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2gg2LEDUnparticleg_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2gg2LEDUnparticleg_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2gg2LEDUnparticleg_id4Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2gg2LEDUnparticleg
    __del__ = lambda self: None
Sigma2gg2LEDUnparticleg_swigregister = _pythia8.Sigma2gg2LEDUnparticleg_swigregister
Sigma2gg2LEDUnparticleg_swigregister(Sigma2gg2LEDUnparticleg)

class Sigma2qg2LEDUnparticleq(Sigma2Process):
    """
A derived class for q g -> U/G q (real graviton emission in
large extra dimensions or unparticle emission).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qg2LEDUnparticleq, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qg2LEDUnparticleq, name)
    __repr__ = _swig_repr

    def __init__(self, Graviton):
        """
Constructor: bool Graviton  = true, to use LED graviton settings.
"""
        this = _pythia8.new_Sigma2qg2LEDUnparticleq(Graviton)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2qg2LEDUnparticleq_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section;
first step when inflavours unknown.
"""
        return _pythia8.Sigma2qg2LEDUnparticleq_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat); second step for given inflavours.
"""
        return _pythia8.Sigma2qg2LEDUnparticleq_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qg2LEDUnparticleq_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qg2LEDUnparticleq_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qg2LEDUnparticleq_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qg2LEDUnparticleq_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2qg2LEDUnparticleq_id3Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qg2LEDUnparticleq
    __del__ = lambda self: None
Sigma2qg2LEDUnparticleq_swigregister = _pythia8.Sigma2qg2LEDUnparticleq_swigregister
Sigma2qg2LEDUnparticleq_swigregister(Sigma2qg2LEDUnparticleq)

class Sigma2qqbar2LEDUnparticleg(Sigma2Process):
    """
A derived class for q qbar -> U/G g (real graviton emission in
large extra dimensions or unparticle emission).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qqbar2LEDUnparticleg, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qqbar2LEDUnparticleg, name)
    __repr__ = _swig_repr

    def __init__(self, Graviton):
        """
Constructor: bool Graviton  = true, to use LED graviton settings.
"""
        this = _pythia8.new_Sigma2qqbar2LEDUnparticleg(Graviton)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2qqbar2LEDUnparticleg_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section;
first step when inflavours unknown.
"""
        return _pythia8.Sigma2qqbar2LEDUnparticleg_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat); second step for given inflavours.
"""
        return _pythia8.Sigma2qqbar2LEDUnparticleg_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qqbar2LEDUnparticleg_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qqbar2LEDUnparticleg_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qqbar2LEDUnparticleg_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qqbar2LEDUnparticleg_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2qqbar2LEDUnparticleg_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2qqbar2LEDUnparticleg_id4Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qqbar2LEDUnparticleg
    __del__ = lambda self: None
Sigma2qqbar2LEDUnparticleg_swigregister = _pythia8.Sigma2qqbar2LEDUnparticleg_swigregister
Sigma2qqbar2LEDUnparticleg_swigregister(Sigma2qqbar2LEDUnparticleg)

class Sigma2ffbar2LEDUnparticleZ(Sigma2Process):
    """
A derived class for f fbar -> U/G Z (real graviton emission in
large extra dimensions or unparticle emission).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2LEDUnparticleZ, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2LEDUnparticleZ, name)
    __repr__ = _swig_repr

    def __init__(self, Graviton):
        """
Constructor: bool Graviton  = true, to use LED graviton settings.
"""
        this = _pythia8.new_Sigma2ffbar2LEDUnparticleZ(Graviton)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ffbar2LEDUnparticleZ_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section;
first step when inflavours unknown.
"""
        return _pythia8.Sigma2ffbar2LEDUnparticleZ_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat); second step for given inflavours.
"""
        return _pythia8.Sigma2ffbar2LEDUnparticleZ_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2LEDUnparticleZ_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2LEDUnparticleZ_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2LEDUnparticleZ_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2LEDUnparticleZ_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2LEDUnparticleZ_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2LEDUnparticleZ_id4Mass(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma2ffbar2LEDUnparticleZ_resonanceA(self)

    def gmZmode(self):
        """
"""
        return _pythia8.Sigma2ffbar2LEDUnparticleZ_gmZmode(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2LEDUnparticleZ
    __del__ = lambda self: None
Sigma2ffbar2LEDUnparticleZ_swigregister = _pythia8.Sigma2ffbar2LEDUnparticleZ_swigregister
Sigma2ffbar2LEDUnparticleZ_swigregister(Sigma2ffbar2LEDUnparticleZ)

class Sigma2ffbar2LEDUnparticlegamma(Sigma2Process):
    """
A derived class for f fbar -> U/G gamma (real graviton emission in
large extra dimensions or unparticle emission).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2LEDUnparticlegamma, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2LEDUnparticlegamma, name)
    __repr__ = _swig_repr

    def __init__(self, Graviton):
        """
Constructor: bool Graviton  = true, to use LED graviton settings.
"""
        this = _pythia8.new_Sigma2ffbar2LEDUnparticlegamma(Graviton)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ffbar2LEDUnparticlegamma_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section;
first step when inflavours unknown.
"""
        return _pythia8.Sigma2ffbar2LEDUnparticlegamma_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat); second step for given inflavours.
"""
        return _pythia8.Sigma2ffbar2LEDUnparticlegamma_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2LEDUnparticlegamma_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2LEDUnparticlegamma_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2LEDUnparticlegamma_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2LEDUnparticlegamma_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2LEDUnparticlegamma_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2LEDUnparticlegamma_id4Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2LEDUnparticlegamma
    __del__ = lambda self: None
Sigma2ffbar2LEDUnparticlegamma_swigregister = _pythia8.Sigma2ffbar2LEDUnparticlegamma_swigregister
Sigma2ffbar2LEDUnparticlegamma_swigregister(Sigma2ffbar2LEDUnparticlegamma)

class Sigma2ffbar2LEDgammagamma(Sigma2Process):
    """
A derived class for f fbar -> (LED G*/U*) -> gamma gamma
(virtual graviton/unparticle exchange).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2LEDgammagamma, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2LEDgammagamma, name)
    __repr__ = _swig_repr

    def __init__(self, Graviton):
        """
Constructor: bool Graviton  = true, to use LED graviton settings.
"""
        this = _pythia8.new_Sigma2ffbar2LEDgammagamma(Graviton)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ffbar2LEDgammagamma_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section;
first step when inflavours unknown.
"""
        return _pythia8.Sigma2ffbar2LEDgammagamma_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat); second step for given inflavours.
"""
        return _pythia8.Sigma2ffbar2LEDgammagamma_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2LEDgammagamma_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2LEDgammagamma_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2LEDgammagamma_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2LEDgammagamma_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2LEDgammagamma
    __del__ = lambda self: None
Sigma2ffbar2LEDgammagamma_swigregister = _pythia8.Sigma2ffbar2LEDgammagamma_swigregister
Sigma2ffbar2LEDgammagamma_swigregister(Sigma2ffbar2LEDgammagamma)

class Sigma2gg2LEDgammagamma(Sigma2Process):
    """
A derived class for g g -> (LED G*/U*) -> gamma gamma
(virtual graviton/unparticle exchange).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2gg2LEDgammagamma, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2gg2LEDgammagamma, name)
    __repr__ = _swig_repr

    def __init__(self, Graviton):
        """
Constructor: bool Graviton  = true, to use LED graviton settings.
"""
        this = _pythia8.new_Sigma2gg2LEDgammagamma(Graviton)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2gg2LEDgammagamma_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section;
first step when inflavours unknown.
"""
        return _pythia8.Sigma2gg2LEDgammagamma_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat); second step for given inflavours.
"""
        return _pythia8.Sigma2gg2LEDgammagamma_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2gg2LEDgammagamma_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2gg2LEDgammagamma_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2gg2LEDgammagamma_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2gg2LEDgammagamma_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2gg2LEDgammagamma
    __del__ = lambda self: None
Sigma2gg2LEDgammagamma_swigregister = _pythia8.Sigma2gg2LEDgammagamma_swigregister
Sigma2gg2LEDgammagamma_swigregister(Sigma2gg2LEDgammagamma)

class Sigma2ffbar2LEDllbar(Sigma2Process):
    """
A derived class for f fbar -> (LED G*/U*) -> l lbar
(virtual graviton/unparticle exchange).
Does not include t-channel contributions relevant for e^+e^- to e^+e^-
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2LEDllbar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2LEDllbar, name)
    __repr__ = _swig_repr

    def __init__(self, Graviton):
        """
Constructor: bool Graviton  = true, to use LED graviton settings.
"""
        this = _pythia8.new_Sigma2ffbar2LEDllbar(Graviton)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ffbar2LEDllbar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section;
first step when inflavours unknown.
"""
        return _pythia8.Sigma2ffbar2LEDllbar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat); second step for given inflavours.
"""
        return _pythia8.Sigma2ffbar2LEDllbar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2LEDllbar_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2LEDllbar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2LEDllbar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2LEDllbar_inFlux(self)

    def isSChannel(self):
        """
"""
        return _pythia8.Sigma2ffbar2LEDllbar_isSChannel(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2LEDllbar
    __del__ = lambda self: None
Sigma2ffbar2LEDllbar_swigregister = _pythia8.Sigma2ffbar2LEDllbar_swigregister
Sigma2ffbar2LEDllbar_swigregister(Sigma2ffbar2LEDllbar)

class Sigma2gg2LEDllbar(Sigma2Process):
    """
A derived class for g g -> (LED G*/U*) -> l lbar
(virtual graviton/unparticle exchange).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2gg2LEDllbar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2gg2LEDllbar, name)
    __repr__ = _swig_repr

    def __init__(self, Graviton):
        """
Constructor: bool Graviton  = true, to use LED graviton settings.
"""
        this = _pythia8.new_Sigma2gg2LEDllbar(Graviton)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2gg2LEDllbar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section;
first step when inflavours unknown.
"""
        return _pythia8.Sigma2gg2LEDllbar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat); second step for given inflavours.
"""
        return _pythia8.Sigma2gg2LEDllbar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2gg2LEDllbar_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2gg2LEDllbar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2gg2LEDllbar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2gg2LEDllbar_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2gg2LEDllbar
    __del__ = lambda self: None
Sigma2gg2LEDllbar_swigregister = _pythia8.Sigma2gg2LEDllbar_swigregister
Sigma2gg2LEDllbar_swigregister(Sigma2gg2LEDllbar)

class Sigma2gg2LEDgg(Sigma2Process):
    """
A derived class for g g -> (LED G*) -> g g.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2gg2LEDgg, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2gg2LEDgg, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2gg2LEDgg()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2gg2LEDgg_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2gg2LEDgg_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2gg2LEDgg_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2gg2LEDgg_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2gg2LEDgg_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2gg2LEDgg_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2gg2LEDgg_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2gg2LEDgg
    __del__ = lambda self: None
Sigma2gg2LEDgg_swigregister = _pythia8.Sigma2gg2LEDgg_swigregister
Sigma2gg2LEDgg_swigregister(Sigma2gg2LEDgg)

class Sigma2gg2LEDqqbar(Sigma2Process):
    """
A derived class for g g -> (LED G*) -> q qbar.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2gg2LEDqqbar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2gg2LEDqqbar, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2gg2LEDqqbar()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2gg2LEDqqbar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2gg2LEDqqbar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2gg2LEDqqbar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2gg2LEDqqbar_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2gg2LEDqqbar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2gg2LEDqqbar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2gg2LEDqqbar_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2gg2LEDqqbar
    __del__ = lambda self: None
Sigma2gg2LEDqqbar_swigregister = _pythia8.Sigma2gg2LEDqqbar_swigregister
Sigma2gg2LEDqqbar_swigregister(Sigma2gg2LEDqqbar)

class Sigma2qg2LEDqg(Sigma2Process):
    """
A derived class for q g -> (LED G*) -> q g.
Use massless approximation also for Q since no alternative.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qg2LEDqg, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qg2LEDqg, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qg2LEDqg()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2qg2LEDqg_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qg2LEDqg_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2qg2LEDqg_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qg2LEDqg_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qg2LEDqg_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qg2LEDqg_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qg2LEDqg_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qg2LEDqg
    __del__ = lambda self: None
Sigma2qg2LEDqg_swigregister = _pythia8.Sigma2qg2LEDqg_swigregister
Sigma2qg2LEDqg_swigregister(Sigma2qg2LEDqg)

class Sigma2qq2LEDqq(Sigma2Process):
    """
A derived class for q q(bar)' -> (LED G*) -> q q(bar)'.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qq2LEDqq, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qq2LEDqq, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qq2LEDqq()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2qq2LEDqq_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qq2LEDqq_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2qq2LEDqq_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qq2LEDqq_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qq2LEDqq_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qq2LEDqq_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qq2LEDqq_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qq2LEDqq
    __del__ = lambda self: None
Sigma2qq2LEDqq_swigregister = _pythia8.Sigma2qq2LEDqq_swigregister
Sigma2qq2LEDqq_swigregister(Sigma2qq2LEDqq)

class Sigma2qqbar2LEDgg(Sigma2Process):
    """
A derived class for q qbar -> (LED G*) -> g g.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qqbar2LEDgg, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qqbar2LEDgg, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qqbar2LEDgg()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2qqbar2LEDgg_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qqbar2LEDgg_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2qqbar2LEDgg_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qqbar2LEDgg_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qqbar2LEDgg_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qqbar2LEDgg_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qqbar2LEDgg_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qqbar2LEDgg
    __del__ = lambda self: None
Sigma2qqbar2LEDgg_swigregister = _pythia8.Sigma2qqbar2LEDgg_swigregister
Sigma2qqbar2LEDgg_swigregister(Sigma2qqbar2LEDgg)

class Sigma2qqbar2LEDqqbarNew(Sigma2Process):
    """
A derived class for q qbar -> (LED G*) -> q' qbar'.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qqbar2LEDqqbarNew, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qqbar2LEDqqbarNew, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qqbar2LEDqqbarNew()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2qqbar2LEDqqbarNew_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qqbar2LEDqqbarNew_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2qqbar2LEDqqbarNew_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qqbar2LEDqqbarNew_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qqbar2LEDqqbarNew_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qqbar2LEDqqbarNew_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qqbar2LEDqqbarNew_inFlux(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qqbar2LEDqqbarNew
    __del__ = lambda self: None
Sigma2qqbar2LEDqqbarNew_swigregister = _pythia8.Sigma2qqbar2LEDqqbarNew_swigregister
Sigma2qqbar2LEDqqbarNew_swigregister(Sigma2qqbar2LEDqqbarNew)

class Sigma2gg2qGqGbar(Sigma2Process):
    """
A derived class for g g -> qG qGbar (generic quark of spin 0, 1/2 or 1).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2gg2qGqGbar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2gg2qGqGbar, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2gg2qGqGbar(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2gg2qGqGbar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2gg2qGqGbar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2gg2qGqGbar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2gg2qGqGbar_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2gg2qGqGbar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2gg2qGqGbar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2gg2qGqGbar_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2gg2qGqGbar_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2gg2qGqGbar_id4Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2gg2qGqGbar
    __del__ = lambda self: None
Sigma2gg2qGqGbar_swigregister = _pythia8.Sigma2gg2qGqGbar_swigregister
Sigma2gg2qGqGbar_swigregister(Sigma2gg2qGqGbar)

class Sigma2qqbar2qGqGbar(Sigma2Process):
    """
A derived class for q qbar -> qG qGbar (generic quark of spin 0, 1/2 or 1).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2qqbar2qGqGbar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2qqbar2qGqGbar, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2qqbar2qGqGbar(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2qqbar2qGqGbar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2qqbar2qGqGbar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2qqbar2qGqGbar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2qqbar2qGqGbar_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2qqbar2qGqGbar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2qqbar2qGqGbar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2qqbar2qGqGbar_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2qqbar2qGqGbar_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2qqbar2qGqGbar_id4Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2qqbar2qGqGbar
    __del__ = lambda self: None
Sigma2qqbar2qGqGbar_swigregister = _pythia8.Sigma2qqbar2qGqGbar_swigregister
Sigma2qqbar2qGqGbar_swigregister(Sigma2qqbar2qGqGbar)

class Sigma2ffbar2fGfGbar(Sigma2Process):
    """
A derived class for f fbar -> fG fGbar (generic spin 0, 1/2 or 1 particle)
via gamma^*/Z^* s-channel exchange. Still under development!! ??
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2fGfGbar, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2fGfGbar, name)
    __repr__ = _swig_repr

    def __init__(self, *args):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ffbar2fGfGbar(*args)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ffbar2fGfGbar_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2ffbar2fGfGbar_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma2ffbar2fGfGbar_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2fGfGbar_setIdColAcol(self)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2fGfGbar_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2fGfGbar_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2fGfGbar_inFlux(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2fGfGbar_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2fGfGbar_id4Mass(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2fGfGbar
    __del__ = lambda self: None
Sigma2ffbar2fGfGbar_swigregister = _pythia8.Sigma2ffbar2fGfGbar_swigregister
Sigma2ffbar2fGfGbar_swigregister(Sigma2ffbar2fGfGbar)

class Sigma1ffbar2Zv(Sigma1Process):
    """
A derived class for f fbar -> Zv, where Zv couples both to the SM and
to a hidden sector. Primitive coupling structure.
"""
    __swig_setmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma1ffbar2Zv, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma1ffbar2Zv, name)
    __repr__ = _swig_repr

    def __init__(self):
        """
Constructor.
"""
        this = _pythia8.new_Sigma1ffbar2Zv()
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma1ffbar2Zv_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma1ffbar2Zv_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat) for given inflavours.
"""
        return _pythia8.Sigma1ffbar2Zv_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma1ffbar2Zv_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for decay angles.
"""
        return _pythia8.Sigma1ffbar2Zv_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma1ffbar2Zv_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma1ffbar2Zv_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma1ffbar2Zv_inFlux(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma1ffbar2Zv_resonanceA(self)
    __swig_destroy__ = _pythia8.delete_Sigma1ffbar2Zv
    __del__ = lambda self: None
Sigma1ffbar2Zv_swigregister = _pythia8.Sigma1ffbar2Zv_swigregister
Sigma1ffbar2Zv_swigregister(Sigma1ffbar2Zv)

class Sigma1ffbar2H(Sigma1Process):
    """
A derived class for f fbar -> H0 (SM), H1, H2 or A3 (BSM).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma1ffbar2H, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma1ffbar2H, name)
    __repr__ = _swig_repr

    def __init__(self, higgsTypeIn):
        """
Constructor.
"""
        this = _pythia8.new_Sigma1ffbar2H(higgsTypeIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma1ffbar2H_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma1ffbar2H_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma1ffbar2H_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma1ffbar2H_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for decay angles.
"""
        return _pythia8.Sigma1ffbar2H_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma1ffbar2H_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma1ffbar2H_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma1ffbar2H_inFlux(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma1ffbar2H_resonanceA(self)
    __swig_destroy__ = _pythia8.delete_Sigma1ffbar2H
    __del__ = lambda self: None
Sigma1ffbar2H_swigregister = _pythia8.Sigma1ffbar2H_swigregister
Sigma1ffbar2H_swigregister(Sigma1ffbar2H)

class Sigma1gg2H(Sigma1Process):
    """
A derived class for g g -> H0 (SM), H1, H2 or A3 (BSM).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma1gg2H, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma1gg2H, name)
    __repr__ = _swig_repr

    def __init__(self, higgsTypeIn):
        """
Constructor.
"""
        this = _pythia8.new_Sigma1gg2H(higgsTypeIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma1gg2H_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma1gg2H_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma1gg2H_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma1gg2H_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for decay angles.
"""
        return _pythia8.Sigma1gg2H_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma1gg2H_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma1gg2H_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma1gg2H_inFlux(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma1gg2H_resonanceA(self)
    __swig_destroy__ = _pythia8.delete_Sigma1gg2H
    __del__ = lambda self: None
Sigma1gg2H_swigregister = _pythia8.Sigma1gg2H_swigregister
Sigma1gg2H_swigregister(Sigma1gg2H)

class Sigma1gmgm2H(Sigma1Process):
    """
A derived class for gamma gamma -> H0 (SM Higgs), H1, H2 or A3 (BSM Higgs).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma1gmgm2H, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma1Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma1gmgm2H, name)
    __repr__ = _swig_repr

    def __init__(self, higgsTypeIn):
        """
Constructor.
"""
        this = _pythia8.new_Sigma1gmgm2H(higgsTypeIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma1gmgm2H_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma1gmgm2H_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate sigmaHat(sHat).
"""
        return _pythia8.Sigma1gmgm2H_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma1gmgm2H_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for decay angles.
"""
        return _pythia8.Sigma1gmgm2H_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma1gmgm2H_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma1gmgm2H_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma1gmgm2H_inFlux(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma1gmgm2H_resonanceA(self)
    __swig_destroy__ = _pythia8.delete_Sigma1gmgm2H
    __del__ = lambda self: None
Sigma1gmgm2H_swigregister = _pythia8.Sigma1gmgm2H_swigregister
Sigma1gmgm2H_swigregister(Sigma1gmgm2H)

class Sigma2ffbar2HZ(Sigma2Process):
    """
A derived class for f fbar -> H Z0.
(H can be H0 SM or H1, H2, A3 from BSM).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2HZ, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2HZ, name)
    __repr__ = _swig_repr

    def __init__(self, higgsTypeIn):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ffbar2HZ(higgsTypeIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ffbar2HZ_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2ffbar2HZ_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2ffbar2HZ_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2HZ_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for decay angles.
"""
        return _pythia8.Sigma2ffbar2HZ_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2HZ_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2HZ_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2HZ_inFlux(self)

    def isSChannel(self):
        """
"""
        return _pythia8.Sigma2ffbar2HZ_isSChannel(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2HZ_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2HZ_id4Mass(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma2ffbar2HZ_resonanceA(self)

    def gmZmode(self):
        """
"""
        return _pythia8.Sigma2ffbar2HZ_gmZmode(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2HZ
    __del__ = lambda self: None
Sigma2ffbar2HZ_swigregister = _pythia8.Sigma2ffbar2HZ_swigregister
Sigma2ffbar2HZ_swigregister(Sigma2ffbar2HZ)

class Sigma2ffbar2HW(Sigma2Process):
    """
A derived class for f fbar -> H W+- (Standard Model Higgs).
(H can be H0 SM or H1, H2, A3 from BSM).
"""
    __swig_setmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_setmethods__.update(getattr(_s, '__swig_setmethods__', {}))
    __setattr__ = lambda self, name, value: _swig_setattr(self, Sigma2ffbar2HW, name, value)
    __swig_getmethods__ = {}
    for _s in [Sigma2Process]:
        __swig_getmethods__.update(getattr(_s, '__swig_getmethods__', {}))
    __getattr__ = lambda self, name: _swig_getattr(self, Sigma2ffbar2HW, name)
    __repr__ = _swig_repr

    def __init__(self, higgsTypeIn):
        """
Constructor.
"""
        this = _pythia8.new_Sigma2ffbar2HW(higgsTypeIn)
        try:
            self.this.append(this)
        except Exception:
            self.this = this

    def initProc(self):
        """
Initialize process.
"""
        return _pythia8.Sigma2ffbar2HW_initProc(self)

    def sigmaKin(self):
        """
Calculate flavour-independent parts of cross section.
"""
        return _pythia8.Sigma2ffbar2HW_sigmaKin(self)

    def sigmaHat(self):
        """
Evaluate d(sigmaHat)/d(tHat).
"""
        return _pythia8.Sigma2ffbar2HW_sigmaHat(self)

    def setIdColAcol(self):
        """
Select flavour, colour and anticolour.
"""
        return _pythia8.Sigma2ffbar2HW_setIdColAcol(self)

    def weightDecay(self, process, iResBeg, iResEnd):
        """
Evaluate weight for decay angles.
"""
        return _pythia8.Sigma2ffbar2HW_weightDecay(self, process, iResBeg, iResEnd)

    def name(self):
        """
Info on the subprocess.
"""
        return _pythia8.Sigma2ffbar2HW_name(self)

    def code(self):
        """
"""
        return _pythia8.Sigma2ffbar2HW_code(self)

    def inFlux(self):
        """
"""
        return _pythia8.Sigma2ffbar2HW_inFlux(self)

    def isSChannel(self):
        """
"""
        return _pythia8.Sigma2ffbar2HW_isSChannel(self)

    def id3Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2HW_id3Mass(self)

    def id4Mass(self):
        """
"""
        return _pythia8.Sigma2ffbar2HW_id4Mass(self)

    def resonanceA(self):
        """
"""
        return _pythia8.Sigma2ffbar2HW_resonanceA(self)
    __swig_destroy__ = _pythia8.delete_Sigma2ffbar2HW
    __del__ = lambda self: None
Sigma2ffbar2HW_swigregister = _pythia8.Sigma2ffbar2HW_swigregister
Sigma2ffbar2HW_swigregister(Sigma2ffbar2HW)

class Sigma3ff2HfftZZ(Sigma3Process):
    """
A d