/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import org.snmp4j.CertifiedIdentity;
import org.snmp4j.TransportMapping;
import org.snmp4j.security.SecurityLevel;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;

public class TransportStateReference {
    private TransportMapping transport;
    private Address address;
    private OctetString securityName;
    private SecurityLevel requestedSecurityLevel;
    private SecurityLevel transportSecurityLevel;
    private boolean sameSecurity;
    private Object sessionID;
    private CertifiedIdentity certifiedIdentity;

    public TransportStateReference(TransportMapping transport, Address address, OctetString securityName, SecurityLevel requestedSecurityLevel, SecurityLevel transportSecurityLevel, boolean sameSecurity, Object sessionID) {
        this.transport = transport;
        this.address = address;
        this.securityName = securityName;
        this.requestedSecurityLevel = requestedSecurityLevel;
        this.transportSecurityLevel = transportSecurityLevel;
        this.sameSecurity = sameSecurity;
        this.sessionID = sessionID;
    }

    public TransportStateReference(TransportMapping transport, Address address, OctetString securityName, SecurityLevel requestedSecurityLevel, SecurityLevel transportSecurityLevel, boolean sameSecurity, Object sessionID, CertifiedIdentity certifiedIdentity) {
        this(transport, address, securityName, requestedSecurityLevel, transportSecurityLevel, sameSecurity, sessionID);
        this.certifiedIdentity = certifiedIdentity;
    }

    public TransportMapping getTransport() {
        return this.transport;
    }

    public Address getAddress() {
        return this.address;
    }

    public OctetString getSecurityName() {
        return this.securityName;
    }

    public SecurityLevel getRequestedSecurityLevel() {
        return this.requestedSecurityLevel;
    }

    public SecurityLevel getTransportSecurityLevel() {
        return this.transportSecurityLevel;
    }

    public boolean isSameSecurity() {
        return this.sameSecurity;
    }

    public Object getSessionID() {
        return this.sessionID;
    }

    public void setSecurityName(OctetString securityName) {
        this.securityName = securityName;
    }

    public void setRequestedSecurityLevel(SecurityLevel requestedSecurityLevel) {
        this.requestedSecurityLevel = requestedSecurityLevel;
    }

    public void setTransportSecurityLevel(SecurityLevel transportSecurityLevel) {
        this.transportSecurityLevel = transportSecurityLevel;
    }

    public void setSameSecurity(boolean sameSecurity) {
        this.sameSecurity = sameSecurity;
    }

    public CertifiedIdentity getCertifiedIdentity() {
        return this.certifiedIdentity;
    }

    public boolean isTransportSecurityValid() {
        return this.transport != null && this.address != null && this.securityName != null && this.transportSecurityLevel != null;
    }

    public String toString() {
        return "TransportStateReference[transport=" + this.transport + ", address=" + this.address + ", securityName=" + this.securityName + ", requestedSecurityLevel=" + (Object)((Object)this.requestedSecurityLevel) + ", transportSecurityLevel=" + (Object)((Object)this.transportSecurityLevel) + ", sameSecurity=" + this.sameSecurity + ", sessionID=" + this.sessionID + ", certifiedIdentity=" + this.certifiedIdentity + ']';
    }
}

