/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.settings;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.IvyPatternHelper;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.settings.IvyVariableContainer;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.Message;

public class IvyVariableContainerImpl
implements IvyVariableContainer {
    private Map variables;
    private String envPrefix;

    public IvyVariableContainerImpl() {
        this.variables = new HashMap();
    }

    public IvyVariableContainerImpl(Map variables) {
        this.variables = variables;
    }

    @Override
    public void setVariable(String varName, String value, boolean overwrite) {
        if (overwrite || !this.variables.containsKey(varName)) {
            Message.debug("setting '" + varName + "' to '" + value + "'");
            this.variables.put(varName, this.substitute(value));
        } else {
            Message.debug("'" + varName + "' already set: discarding '" + value + "'");
        }
    }

    @Override
    public void setEnvironmentPrefix(String prefix) {
        this.envPrefix = prefix != null && !prefix.endsWith(".") ? prefix + "." : prefix;
    }

    protected String substitute(String value) {
        return IvyPatternHelper.substituteVariables(value, this);
    }

    protected Map getVariables() {
        return this.variables;
    }

    protected String getEnvironmentPrefix() {
        return this.envPrefix;
    }

    @Override
    public String getVariable(String name) {
        String val = null;
        val = this.envPrefix != null && name.startsWith(this.envPrefix) ? System.getenv(name.substring(this.envPrefix.length())) : (String)this.variables.get(name);
        return val;
    }

    @Override
    public Object clone() {
        IvyVariableContainerImpl clone;
        try {
            clone = (IvyVariableContainerImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("unable to clone a " + this.getClass());
        }
        clone.variables = new HashMap(this.variables);
        return clone;
    }
}

