/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import { uiModules } from 'ui/modules';
import { capabilities } from 'ui/capabilities';

uiModules.get('kibana')
  .provider('dashboardConfig', () => {
    let hideWriteControls = !capabilities.get().dashboard.showWriteControls;

    return {
      /**
       * Part of the exposed plugin API - do not remove without careful consideration.
       * @type {boolean}
       */
      turnHideWriteControlsOn() {
        hideWriteControls = true;
      },
      $get() {
        return {
          getHideWriteControls() {
            return hideWriteControls;
          }
        };
      }
    };
  });
