'use strict';
var arrayMethods = require('../internals/array-methods');
var sloppyArrayMethod = require('../internals/sloppy-array-method');

var internalForEach = arrayMethods(0);
var SLOPPY_METHOD = sloppyArrayMethod('forEach');

// `Array.prototype.forEach` method implementation
// https://tc39.github.io/ecma262/#sec-array.prototype.foreach
module.exports = SLOPPY_METHOD ? function forEach(callbackfn /* , thisArg */) {
  return internalForEach(this, callbackfn, arguments[1]);
} : [].forEach;
