'use strict';
var $ = require('../internals/export');
var arrayMethods = require('../internals/array-methods');
var arrayMethodHasSpeciesSupport = require('../internals/array-method-has-species-support');

var internalFilter = arrayMethods(2);
var SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('filter');

// `Array.prototype.filter` method
// https://tc39.github.io/ecma262/#sec-array.prototype.filter
// with adding support of @@species
$({ target: 'Array', proto: true, forced: !SPECIES_SUPPORT }, {
  filter: function filter(callbackfn /* , thisArg */) {
    return internalFilter(this, callbackfn, arguments[1]);
  }
});
