/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.options;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import joptsimple.OptionSet;
import org.springframework.boot.cli.util.ResourceUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class SourceOptions {
    private final List<String> sources;
    private final List<?> args;

    public SourceOptions(OptionSet options) {
        this(options, null);
    }

    public SourceOptions(List<?> arguments) {
        this(arguments, null);
    }

    public SourceOptions(OptionSet optionSet, ClassLoader classLoader) {
        this(optionSet.nonOptionArguments(), classLoader);
    }

    private SourceOptions(List<?> nonOptionArguments, ClassLoader classLoader) {
        ArrayList<String> sources = new ArrayList<String>();
        int sourceArgCount = 0;
        for (Object option : nonOptionArguments) {
            if (!(option instanceof String)) continue;
            String filename = (String)option;
            if ("--".equals(filename)) break;
            ArrayList<String> urls = new ArrayList<String>();
            File fileCandidate = new File(filename);
            if (fileCandidate.isFile()) {
                urls.add(fileCandidate.getAbsoluteFile().toURI().toString());
            } else if (!this.isAbsoluteWindowsFile(fileCandidate)) {
                urls.addAll(ResourceUtils.getUrls(filename, classLoader));
            }
            for (String url : urls) {
                if (!this.isSource(url)) continue;
                sources.add(url);
            }
            if (!this.isSource(filename)) continue;
            if (urls.isEmpty()) {
                throw new IllegalArgumentException("Can't find " + filename);
            }
            ++sourceArgCount;
        }
        this.args = Collections.unmodifiableList(nonOptionArguments.subList(sourceArgCount, nonOptionArguments.size()));
        Assert.isTrue((!sources.isEmpty() ? 1 : 0) != 0, (String)"Please specify at least one file");
        this.sources = Collections.unmodifiableList(sources);
    }

    private boolean isAbsoluteWindowsFile(File file) {
        return this.isWindows() && file.isAbsolute();
    }

    private boolean isWindows() {
        return File.separatorChar == '\\';
    }

    private boolean isSource(String name) {
        return name.endsWith(".java") || name.endsWith(".groovy");
    }

    public List<?> getArgs() {
        return this.args;
    }

    public String[] getArgsArray() {
        return (String[])this.args.stream().map(this::asString).toArray(String[]::new);
    }

    private String asString(Object arg) {
        return arg != null ? String.valueOf(arg) : null;
    }

    public List<String> getSources() {
        return this.sources;
    }

    public String[] getSourcesArray() {
        return StringUtils.toStringArray(this.sources);
    }
}

