/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateApplicability;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.FirCallArgumentsProcessor;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStage;
import org.jetbrains.kotlin.fir.symbols.ConeSymbol;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/MapArguments;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStage;", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "resolve"})
public final class MapArguments
extends ResolutionStage {
    public static final MapArguments INSTANCE;

    @Override
    public void check(@NotNull Candidate candidate2, @NotNull CheckerSink sink, @NotNull CallInfo callInfo) {
        Intrinsics.checkParameterIsNotNull((Object)candidate2, (String)"candidate");
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        Intrinsics.checkParameterIsNotNull((Object)callInfo, (String)"callInfo");
        ConeSymbol coneSymbol = candidate2.getSymbol();
        if (!(coneSymbol instanceof FirFunctionSymbol)) {
            coneSymbol = null;
        }
        FirFunctionSymbol firFunctionSymbol = (FirFunctionSymbol)coneSymbol;
        if (firFunctionSymbol == null) {
            sink.reportApplicability(CandidateApplicability.HIDDEN);
            return;
        }
        FirFunctionSymbol symbol2 = firFunctionSymbol;
        ConeSymbol $this$firUnsafe$iv = symbol2;
        boolean $i$f$firUnsafe = false;
        boolean bl = $this$firUnsafe$iv instanceof FirBasedSymbol;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Not a fir based symbol: " + $this$firUnsafe$iv;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Object fir$iv = ((FirBasedSymbol)$this$firUnsafe$iv).getFir();
        bl2 = fir$iv instanceof FirFunction;
        bl3 = false;
        boolean bl5 = false;
        if (!bl2) {
            boolean bl6 = false;
            String string = "Not an expected fir element type = " + Reflection.getOrCreateKotlinClass(FirFunction.class) + ", symbol = " + $this$firUnsafe$iv + ", fir = " + FirRendererKt.renderWithType(fir$iv);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        FirFunction function2 = (FirFunction)fir$iv;
        FirCallArgumentsProcessor processor2 = new FirCallArgumentsProcessor(function2, callInfo.getArguments());
        FirCallArgumentsProcessor.Result mappingResult = processor2.process();
        candidate2.setArgumentMapping(mappingResult.getArgumentMapping());
        if (!mappingResult.isSuccess()) {
            sink.reportApplicability(CandidateApplicability.PARAMETER_MAPPING_ERROR);
            return;
        }
    }

    private MapArguments() {
    }

    static {
        MapArguments mapArguments;
        INSTANCE = mapArguments = new MapArguments();
    }
}

