/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.tabs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.control.actions.AbstractTerminalAction;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionClearAll;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionCopy;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionPaste;
import org.eclipse.tm.internal.terminal.control.actions.TerminalActionSelectAll;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.terminal.view.ui.actions.SelectEncodingAction;
import org.eclipse.tm.terminal.view.ui.interfaces.ITerminalsView;
import org.eclipse.tm.terminal.view.ui.tabs.TabFolderManager;

public class TabFolderMenuHandler
extends PlatformObject {
    private final ITerminalsView parentView;
    private MenuManager contextMenuManager;
    private Menu contextMenu;
    private final List<AbstractTerminalAction> contextMenuActions = new ArrayList<AbstractTerminalAction>();
    static final String[] INVALID_CONTRIBUTIONS_STARTS_WITH = new String[]{"org.eclipse.cdt", "org.eclipse.ui.edit"};

    public TabFolderMenuHandler(ITerminalsView parentView) {
        Assert.isNotNull((Object)parentView);
        this.parentView = parentView;
    }

    protected final ITerminalsView getParentView() {
        return this.parentView;
    }

    protected final CTabFolder getTabFolder() {
        return (CTabFolder)this.getParentView().getAdapter(CTabFolder.class);
    }

    public void dispose() {
        if (this.contextMenu != null) {
            this.contextMenu.dispose();
            this.contextMenu = null;
        }
        if (this.contextMenuManager != null) {
            this.contextMenuManager.dispose();
            this.contextMenuManager = null;
        }
        this.contextMenuActions.clear();
    }

    public void initialize() {
        if (this.contextMenuManager != null && this.contextMenu != null) {
            return;
        }
        CTabFolder tabFolder = this.getTabFolder();
        if (tabFolder == null) {
            return;
        }
        this.contextMenuManager = new MenuManager("#PopupMenu");
        this.contextMenu = this.contextMenuManager.createContextMenu((Control)tabFolder);
        tabFolder.setMenu(this.contextMenu);
        this.doCreateContextMenuActions();
        this.doFillContextMenu(this.contextMenuManager);
        this.getParentView().getSite().registerContextMenu(this.contextMenuManager, this.getParentView().getSite().getSelectionProvider());
        this.contextMenuManager.addMenuListener((IMenuListener)new MenuListener());
    }

    protected final void add(AbstractTerminalAction action) {
        Assert.isNotNull((Object)action);
        this.contextMenuActions.add(action);
    }

    protected void doCreateContextMenuActions() {
        this.add((AbstractTerminalAction)new TerminalActionCopy(){

            protected ITerminalViewControl getTarget() {
                return TabFolderMenuHandler.this.getActiveTerminalViewControl();
            }
        });
        this.add((AbstractTerminalAction)new TerminalActionPaste(){

            public void run() {
                String text;
                ITerminalViewControl target;
                Map properties;
                CTabItem activeTabItem;
                boolean needsTranslation = false;
                TabFolderManager manager = (TabFolderManager)((Object)TabFolderMenuHandler.this.getParentView().getAdapter(TabFolderManager.class));
                if (manager != null && (activeTabItem = manager.getActiveTabItem()) != null && (properties = (Map)activeTabItem.getData("properties")) != null && properties.containsKey("translateBackslashesOnPaste")) {
                    Object value = properties.get("translateBackslashesOnPaste");
                    boolean bl = needsTranslation = value instanceof Boolean ? (Boolean)value : false;
                }
                if (needsTranslation && (target = this.getTarget()) != null && target.getClipboard() != null && !target.getClipboard().isDisposed() && (text = (String)target.getClipboard().getContents((Transfer)TextTransfer.getInstance())) != null) {
                    text = text.replace('\\', '/');
                    Object[] data = new Object[]{text};
                    Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
                    target.getClipboard().setContents(data, types, 1);
                }
                super.run();
            }

            protected ITerminalViewControl getTarget() {
                return TabFolderMenuHandler.this.getActiveTerminalViewControl();
            }
        });
        this.add((AbstractTerminalAction)new TerminalActionClearAll(){

            protected ITerminalViewControl getTarget() {
                return TabFolderMenuHandler.this.getActiveTerminalViewControl();
            }

            public void updateAction(boolean aboutToShow) {
                super.updateAction(aboutToShow);
                if (this.getTarget() != null && this.getTarget().getState() != TerminalState.CONNECTED) {
                    this.setEnabled(false);
                }
            }
        });
        this.add((AbstractTerminalAction)new TerminalActionSelectAll(){

            protected ITerminalViewControl getTarget() {
                return TabFolderMenuHandler.this.getActiveTerminalViewControl();
            }
        });
        this.add(new SelectEncodingAction((TabFolderManager)((Object)this.getParentView().getAdapter(TabFolderManager.class))){

            protected ITerminalViewControl getTarget() {
                return TabFolderMenuHandler.this.getActiveTerminalViewControl();
            }
        });
    }

    protected ITerminalViewControl getActiveTerminalViewControl() {
        CTabItem activeTabItem;
        ITerminalViewControl terminal = null;
        TabFolderManager manager = (TabFolderManager)((Object)this.getParentView().getAdapter(TabFolderManager.class));
        if (manager != null && (activeTabItem = manager.getActiveTabItem()) != null) {
            terminal = (ITerminalViewControl)activeTabItem.getData();
        }
        return terminal;
    }

    protected void doFillContextMenu(MenuManager manager) {
        Assert.isNotNull((Object)manager);
        for (AbstractTerminalAction action : this.contextMenuActions) {
            manager.add((IAction)action);
            if (action instanceof TerminalActionPaste) {
                manager.add((IContributionItem)new Separator());
            }
            if (!(action instanceof TerminalActionSelectAll)) continue;
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void updateMenuItems(boolean aboutToShow) {
        for (AbstractTerminalAction action : this.contextMenuActions) {
            action.updateAction(aboutToShow);
        }
    }

    public Object getAdapter(Class adapter) {
        if (MenuManager.class.isAssignableFrom(adapter)) {
            return this.contextMenuManager;
        }
        if (Menu.class.isAssignableFrom(adapter)) {
            if (this.contextMenu == null || this.contextMenu.isDisposed()) {
                this.contextMenu = this.contextMenuManager.createContextMenu((Control)this.getTabFolder());
            }
            this.getTabFolder().setMenu(null);
            return this.contextMenu;
        }
        Object adapted = this.getParentView().getAdapter(adapter);
        if (adapted != null) {
            return adapted;
        }
        return super.getAdapter(adapter);
    }

    protected class MenuListener
    implements IMenuListener2 {
        protected MenuListener() {
        }

        public void menuAboutToHide(IMenuManager manager) {
        }

        public void menuAboutToShow(IMenuManager manager) {
            this.removeInvalidContributions(manager);
            TabFolderMenuHandler.this.updateMenuItems(true);
        }

        private void removeInvalidContributions(IMenuManager manager) {
            IContributionItem[] items;
            if (manager == null) {
                return;
            }
            IContributionItem[] iContributionItemArray = items = manager.getItems();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                IContributionItem item = iContributionItemArray[n2];
                String id = item.getId();
                if (id != null) {
                    String[] stringArray = INVALID_CONTRIBUTIONS_STARTS_WITH;
                    int n3 = INVALID_CONTRIBUTIONS_STARTS_WITH.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String prefix = stringArray[n4];
                        if (id.startsWith(prefix)) {
                            manager.remove(item);
                            break;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
    }
}

