/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jpt.common.utility.internal.model.value.ElementPropertyValueModelAdapter;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.ui.JpaProjectModel;
import org.eclipse.jpt.jpa.ui.JpaProjectsModel;

public class ProjectAdapterFactory
implements IAdapterFactory {
    private static final Class<?>[] ADAPTER_LIST = new Class[]{JpaProjectModel.class};

    public Class<?>[] getAdapterList() {
        return ADAPTER_LIST;
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IProject) {
            return this.getAdapter((IProject)adaptableObject, adapterType);
        }
        return null;
    }

    private Object getAdapter(IProject project, Class<?> adapterType) {
        if (adapterType == JpaProjectModel.class) {
            return this.getJpaProjectModel(project);
        }
        return null;
    }

    private JpaProjectModel getJpaProjectModel(IProject project) {
        return new JpaProjectModelAdapter(this.getJpaProjectsModel(project.getWorkspace()), project);
    }

    private JpaProjectsModel getJpaProjectsModel(IWorkspace workspace) {
        return (JpaProjectsModel)workspace.getAdapter(JpaProjectsModel.class);
    }

    static class JpaProjectModelAdapter
    extends ElementPropertyValueModelAdapter<JpaProject>
    implements JpaProjectModel {
        JpaProjectModelAdapter(CollectionValueModel<JpaProject> jpaProjectsModel, IProject project) {
            super(jpaProjectsModel, (Predicate)new JpaProject.ProjectEquals(project));
        }

        @Override
        public IProject getProject() {
            return (IProject)((JpaProject.ProjectEquals)this.predicate).getCriterion();
        }
    }
}

