/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterContainer;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolManagerProvider;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.IRSEPersistableContainer;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.references.SystemReferencedObject;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.eclipse.rse.internal.core.filters.SystemFilterContainerCommonMethods;
import org.eclipse.rse.internal.core.filters.SystemFilterString;

public class SystemFilter
extends SystemReferencedObject
implements ISystemFilter,
IAdaptable {
    private SystemFilterContainerCommonMethods helpers = null;
    private ISystemFilterPool parentPool = null;
    private List filterStrings = new ArrayList(3);
    private String name = null;
    private String type = null;
    private boolean supportsNestedFilters = false;
    private int relativeOrder = 0;
    private boolean default_ = false;
    private boolean stringsCaseSensitive = false;
    private boolean promptable = false;
    private boolean supportsDuplicateFilterStrings = false;
    private boolean nonDeletable = false;
    private boolean nonRenamable = false;
    private boolean nonChangable = false;
    private boolean stringsNonChangable = false;
    private int release = 0;
    private boolean singleFilterStringOnly = false;
    private List nestedFilters = new ArrayList(3);
    private ISystemFilter _parentFilter;

    protected SystemFilter() {
        this.helpers = new SystemFilterContainerCommonMethods();
    }

    private List internalGetFilters() {
        return this.nestedFilters;
    }

    public String getType() {
        String type = this.getTypeGen();
        if (type == null) {
            return "default";
        }
        return type;
    }

    public String getTypeGen() {
        return this.type;
    }

    public ISystemFilter createSystemFilter(String aliasName, String[] filterStrings) {
        ISystemFilter newFilter = this.helpers.createSystemFilter(this.internalGetFilters(), this.getParentFilterPool(), aliasName, filterStrings);
        newFilter.setSupportsNestedFilters(true);
        newFilter.setSupportsDuplicateFilterStrings(this.supportsDuplicateFilterStrings());
        newFilter.setStringsCaseSensitive(this.areStringsCaseSensitive());
        return newFilter;
    }

    public void initializeFilterStrings() {
        Iterator i = this.filterStrings.iterator();
        while (i.hasNext()) {
            ((ISystemFilterString)i.next()).setParentSystemFilter(this);
        }
    }

    public void clone(ISystemFilter targetFilter) {
        ISystemFilter[] filters;
        ISystemFilterString[] strings;
        targetFilter.setDefault(this.isDefault());
        targetFilter.setType(this.getType());
        targetFilter.setPromptable(this.isPromptable());
        targetFilter.setRelativeOrder(this.getRelativeOrder());
        targetFilter.setSupportsNestedFilters(this.isSupportsNestedFilters());
        targetFilter.setSupportsDuplicateFilterStrings(this.isSupportsDuplicateFilterStrings());
        targetFilter.setStringsNonChangable(this.isStringsNonChangable());
        targetFilter.setNonChangable(this.isNonChangable());
        targetFilter.setNonDeletable(this.isNonDeletable());
        targetFilter.setNonRenamable(this.isNonRenamable());
        if (this.isSetSingleFilterStringOnly()) {
            targetFilter.setSingleFilterStringOnly(this.isSingleFilterStringOnly());
        }
        if (this.isSetStringsCaseSensitive()) {
            targetFilter.setStringsCaseSensitive(this.isStringsCaseSensitive());
        }
        if ((strings = this.getSystemFilterStrings()) != null) {
            int idx = 0;
            while (idx < strings.length) {
                this.copySystemFilterString(targetFilter, strings[idx]);
                ++idx;
            }
        }
        if ((filters = this.getSystemFilters()) != null) {
            int idx = 0;
            while (idx < filters.length) {
                ISystemFilter newFilter = targetFilter.createSystemFilter(filters[idx].getName(), null);
                filters[idx].clone(newFilter);
                ++idx;
            }
        }
    }

    public ISystemFilterString copySystemFilterString(ISystemFilter targetFilter, ISystemFilterString oldFilterString) {
        ISystemFilterString newString = targetFilter.addFilterString(null);
        oldFilterString.clone(newString);
        return newString;
    }

    public ISystemFilterPool getSystemFilterPool() {
        return this.getParentFilterPool();
    }

    public boolean isTransient() {
        return false;
    }

    public boolean supportsNestedFilters() {
        return this.isSupportsNestedFilters();
    }

    public boolean supportsDuplicateFilterStrings() {
        return this.isSupportsDuplicateFilterStrings();
    }

    public boolean isNested() {
        return this.getParentFilter() != null;
    }

    public boolean isStringsCaseSensitive() {
        if (!this.isSetStringsCaseSensitive()) {
            return this.getParentFilterPool().isStringsCaseSensitive();
        }
        return this.stringsCaseSensitive;
    }

    public boolean areStringsCaseSensitive() {
        return this.isStringsCaseSensitive();
    }

    public String[] getSystemFilterNames() {
        List filters = this.internalGetFilters();
        Vector names = this.helpers.getSystemFilterNames(filters);
        String[] result = new String[names.size()];
        names.toArray(result);
        return result;
    }

    public ISystemFilter[] getSystemFilters() {
        return this.helpers.getSystemFilters(this.internalGetFilters());
    }

    public int getSystemFilterCount() {
        return this.internalGetFilters().size();
    }

    public ISystemFilter getSystemFilter(String aliasName) {
        return this.helpers.getSystemFilter(this.internalGetFilters(), aliasName);
    }

    public boolean addSystemFilter(ISystemFilter filter) {
        return this.helpers.addSystemFilter(this.internalGetFilters(), filter);
    }

    public void deleteSystemFilter(ISystemFilter filter) {
        this.helpers.deleteSystemFilter(this.internalGetFilters(), filter);
    }

    public void renameSystemFilter(ISystemFilter filter, String newName) {
        this.helpers.renameSystemFilter(this.internalGetFilters(), filter, newName);
    }

    public void updateSystemFilter(ISystemFilter filter, String newName, String[] newStrings) {
        this.helpers.updateSystemFilter(this.internalGetFilters(), filter, newName, newStrings);
    }

    public ISystemFilter cloneSystemFilter(ISystemFilter filter, String aliasName) {
        return this.helpers.cloneSystemFilter(this.internalGetFilters(), filter, aliasName);
    }

    public int getSystemFilterPosition(ISystemFilter filter) {
        return this.helpers.getSystemFilterPosition(this.internalGetFilters(), filter);
    }

    public void moveSystemFilter(int pos, ISystemFilter filter) {
        this.helpers.moveSystemFilter(this.internalGetFilters(), pos, filter);
    }

    public ISystemFilterPool getParentFilterPool() {
        return this.parentPool;
    }

    public void setParentFilterPool(ISystemFilterPool parentPool) {
        this.parentPool = parentPool;
        ISystemFilter[] filters = this.getSystemFilters();
        if (filters != null) {
            int idx = 0;
            while (idx < filters.length) {
                filters[idx].setParentFilterPool(parentPool);
                ++idx;
            }
        }
    }

    public ISystemFilterContainer getParentFilterContainer() {
        ISystemFilter parentFilter = this.getParentFilter();
        return parentFilter != null ? parentFilter : this.getParentFilterPool();
    }

    public String[] getFilterStrings() {
        ISystemFilterString[] filterStrings = this.getSystemFilterStrings();
        String[] result = new String[filterStrings.length];
        int i = 0;
        while (i < filterStrings.length) {
            ISystemFilterString filterString = filterStrings[i];
            result[i] = filterString.getString();
            ++i;
        }
        return result;
    }

    public int getFilterStringCount() {
        return this.filterStrings.size();
    }

    public ISystemFilterString getSystemFilterString(String string) {
        ISystemFilterString[] strings = this.getSystemFilterStrings();
        ISystemFilterString match = null;
        boolean cs = this.areStringsCaseSensitive();
        if (strings != null) {
            int idx = 0;
            while (match == null && idx < strings.length) {
                if (cs) {
                    if (string.equals(strings[idx].getString())) {
                        match = strings[idx];
                    }
                } else if (string.equalsIgnoreCase(strings[idx].getString())) {
                    match = strings[idx];
                }
                ++idx;
            }
        }
        return match;
    }

    public void setFilterStrings(Vector newStrings) {
        this.filterStrings.clear();
        Iterator z = newStrings.iterator();
        while (z.hasNext()) {
            String newString = (String)z.next();
            ISystemFilterString filterString = this.createFilterString(newString);
            this.filterStrings.add(filterString);
        }
        this.setDirty(true);
    }

    public ISystemFilterString[] getSystemFilterStrings() {
        ISystemFilterString[] result = new ISystemFilterString[this.filterStrings.size()];
        this.filterStrings.toArray(result);
        return result;
    }

    public void setFilterStrings(String[] newStrings) {
        this.filterStrings.clear();
        int idx = 0;
        while (idx < newStrings.length) {
            ISystemFilterString filterString = this.createFilterString(newStrings[idx]);
            this.filterStrings.add(filterString);
            ++idx;
        }
        this.setDirty(true);
    }

    private ISystemFilterString createFilterString(String string) {
        SystemFilterString filterstring = new SystemFilterString();
        filterstring.setString(string);
        filterstring.setParentSystemFilter(this);
        return filterstring;
    }

    public ISystemFilterString addFilterString(String newString) {
        ISystemFilterString newFilterString = this.createFilterString(newString);
        this.filterStrings.add(newFilterString);
        this.setDirty(true);
        return newFilterString;
    }

    public ISystemFilterString addFilterString(String newString, int position) {
        ISystemFilterString newFilterString = this.createFilterString(newString);
        this.filterStrings.add(position, newFilterString);
        this.setDirty(true);
        return newFilterString;
    }

    public void updateFilterString(ISystemFilterString filterString, String newValue) {
        filterString.setString(newValue);
    }

    public ISystemFilterString removeFilterString(String oldString) {
        ISystemFilterString match = null;
        Iterator i = this.filterStrings.iterator();
        while (match == null && i.hasNext()) {
            ISystemFilterString currstring = (ISystemFilterString)i.next();
            if (!currstring.getString().equals(oldString)) continue;
            match = currstring;
        }
        if (match != null) {
            this.filterStrings.remove(match);
            this.setDirty(true);
        }
        return match;
    }

    public ISystemFilterString removeFilterString(int position) {
        ISystemFilterString filterString = null;
        if (position < this.filterStrings.size()) {
            filterString = (ISystemFilterString)this.filterStrings.remove(position);
            this.setDirty(true);
        }
        return filterString;
    }

    public boolean removeFilterString(ISystemFilterString filterString) {
        boolean removed = this.filterStrings.remove(filterString);
        if (removed) {
            this.setDirty(true);
        }
        return removed;
    }

    public void moveSystemFilterString(int pos, ISystemFilterString filterString) {
        boolean removed = this.filterStrings.remove(filterString);
        if (removed) {
            this.filterStrings.add(pos, filterString);
            this.setDirty(true);
        }
    }

    public Object getAdapter(Class adapterType) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapterType);
    }

    public Object[] getChildren() {
        String[] strings = this.getFilterStrings();
        ISystemFilter[] filters = this.getSystemFilters();
        Vector<Object> vChildren = new Vector<Object>();
        int idx = 0;
        while (idx < filters.length) {
            vChildren.addElement(filters[idx]);
            ++idx;
        }
        idx = 0;
        while (idx < strings.length) {
            String filterString = strings[idx];
            vChildren.addElement(filterString);
            ++idx;
        }
        Object[] children = new Object[vChildren.size()];
        int idx2 = 0;
        while (idx2 < vChildren.size()) {
            children[idx2] = vChildren.elementAt(idx2);
            ++idx2;
        }
        return children;
    }

    public boolean hasChildren() {
        if (this.filterStrings.size() > 0) {
            return true;
        }
        return this.helpers.hasSystemFilters(this.internalGetFilters());
    }

    public ISystemFilterPoolManagerProvider getProvider() {
        ISystemFilterPoolManager mgr = this.getSystemFilterPoolManager();
        if (mgr != null) {
            return mgr.getProvider();
        }
        return null;
    }

    public ISystemFilterPoolManager getSystemFilterPoolManager() {
        ISystemFilterPool pool = this.getParentFilterPool();
        if (pool != null) {
            return pool.getSystemFilterPoolManager();
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return RSECoreMessages.RESID_MODELOBJECTS_FILTER_DESCRIPTION;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setType(String newType) {
        this.type = newType;
        this.setDirty(true);
    }

    public boolean isSupportsNestedFilters() {
        return this.supportsNestedFilters;
    }

    public void setSupportsNestedFilters(boolean newSupportsNestedFilters) {
        boolean oldSupportsNestedFilters = this.supportsNestedFilters;
        if (oldSupportsNestedFilters != newSupportsNestedFilters) {
            this.supportsNestedFilters = newSupportsNestedFilters;
            this.setDirty(true);
        }
    }

    public int getRelativeOrder() {
        return this.relativeOrder;
    }

    public void setRelativeOrder(int newRelativeOrder) {
        this.relativeOrder = newRelativeOrder;
    }

    public boolean isDefault() {
        return this.default_;
    }

    public void setDefault(boolean newDefault) {
        this.default_ = newDefault;
    }

    public void setStringsCaseSensitive(boolean newStringsCaseSensitive) {
        boolean oldStringsCaseSensitive = this.stringsCaseSensitive;
        if (oldStringsCaseSensitive != newStringsCaseSensitive) {
            this.stringsCaseSensitive = newStringsCaseSensitive;
            this.setDirty(true);
        }
    }

    public void unsetStringsCaseSensitive() {
        if (this.stringsCaseSensitive) {
            this.stringsCaseSensitive = false;
            this.setDirty(true);
        }
    }

    public boolean isSetStringsCaseSensitive() {
        return this.stringsCaseSensitive;
    }

    public boolean isPromptable() {
        return this.promptable;
    }

    public void setPromptable(boolean newPromptable) {
        this.promptable = newPromptable;
    }

    public ISystemFilter getParentFilter() {
        return this._parentFilter;
    }

    public void setParentFilter(ISystemFilter newParentFilter) {
        this._parentFilter = newParentFilter;
    }

    public ISystemFilter[] getNestedFilters() {
        if (this.nestedFilters == null) {
            this.nestedFilters = new ArrayList();
        }
        ISystemFilter[] result = new ISystemFilter[this.nestedFilters.size()];
        this.nestedFilters.toArray(result);
        return result;
    }

    public ISystemFilterString[] getStrings() {
        ISystemFilterString[] result = new ISystemFilterString[this.filterStrings.size()];
        this.filterStrings.toArray(result);
        return result;
    }

    public boolean isSupportsDuplicateFilterStrings() {
        return this.supportsDuplicateFilterStrings;
    }

    public void setSupportsDuplicateFilterStrings(boolean newSupportsDuplicateFilterStrings) {
        boolean oldSupportsDuplicateFilterStrings = this.supportsDuplicateFilterStrings;
        if (oldSupportsDuplicateFilterStrings != newSupportsDuplicateFilterStrings) {
            this.supportsDuplicateFilterStrings = newSupportsDuplicateFilterStrings;
            this.setDirty(true);
        }
    }

    public boolean isNonDeletable() {
        return this.nonDeletable;
    }

    public void setNonDeletable(boolean newNonDeletable) {
        this.nonDeletable = newNonDeletable;
    }

    public boolean isNonRenamable() {
        return this.nonRenamable;
    }

    public void setNonRenamable(boolean newNonRenamable) {
        this.nonRenamable = newNonRenamable;
    }

    public boolean isNonChangable() {
        return this.nonChangable;
    }

    public void setNonChangable(boolean newNonChangable) {
        this.nonChangable = newNonChangable;
    }

    public boolean isStringsNonChangable() {
        return this.stringsNonChangable;
    }

    public void setStringsNonChangable(boolean newStringsNonChangable) {
        boolean oldStringsNonChangable = this.stringsNonChangable;
        if (oldStringsNonChangable != newStringsNonChangable) {
            this.stringsNonChangable = newStringsNonChangable;
            this.setDirty(true);
        }
    }

    public int getRelease() {
        return this.release;
    }

    public void setRelease(int newRelease) {
        this.release = newRelease;
    }

    public boolean isSingleFilterStringOnly() {
        if (this.isSetSingleFilterStringOnly()) {
            return this.singleFilterStringOnly;
        }
        return this.getSystemFilterPool().isSingleFilterStringOnly();
    }

    public boolean isSingleFilterStringOnlyGen() {
        return this.singleFilterStringOnly;
    }

    public void setSingleFilterStringOnly(boolean newSingleFilterStringOnly) {
        boolean oldSingleFilterStringOnly = this.singleFilterStringOnly;
        if (oldSingleFilterStringOnly != newSingleFilterStringOnly) {
            this.singleFilterStringOnly = newSingleFilterStringOnly;
            this.setDirty(true);
        }
    }

    public void unsetSingleFilterStringOnly() {
        if (this.singleFilterStringOnly) {
            this.singleFilterStringOnly = false;
            this.setDirty(true);
        }
    }

    public boolean isSetSingleFilterStringOnly() {
        return this.singleFilterStringOnly;
    }

    public void setSubSystem(ISubSystem subsystem) {
    }

    public Object getSubSystem() {
        return null;
    }

    public boolean commit() {
        ISystemProfile profile = this.getSystemFilterPoolManager().getSystemProfile();
        boolean result = profile.commit();
        return result;
    }

    public IRSEPersistableContainer getPersistableParent() {
        ISystemFilterContainer result = this.getParentFilterContainer();
        return result;
    }

    public IRSEPersistableContainer[] getPersistableChildren() {
        ArrayList<IPropertySet> children = new ArrayList<IPropertySet>(20);
        children.addAll(this.nestedFilters);
        children.addAll(this.filterStrings);
        children.addAll(Arrays.asList(this.getPropertySets()));
        IRSEPersistableContainer[] result = new IRSEPersistableContainer[children.size()];
        children.toArray(result);
        return result;
    }
}

