/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.tm4e.core.TMException;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.internal.grammar.reader.GrammarReader;
import org.eclipse.tm4e.core.internal.grammars.SyncRegistry;
import org.eclipse.tm4e.core.internal.types.IRawGrammar;
import org.eclipse.tm4e.core.logger.ILogger;
import org.eclipse.tm4e.core.registry.IRegistryOptions;
import org.eclipse.tm4e.core.theme.IRawTheme;
import org.eclipse.tm4e.core.theme.Theme;

public class Registry {
    private final IRegistryOptions _locator;
    private final SyncRegistry _syncRegistry;

    public Registry() {
        this(IRegistryOptions.DEFAULT_LOCATOR);
    }

    public Registry(IRegistryOptions locator) {
        this(locator, ILogger.DEFAULT_LOGGER);
    }

    public Registry(IRegistryOptions locator, ILogger logger) {
        this._locator = locator;
        this._syncRegistry = new SyncRegistry(Theme.createFromRawTheme(locator.getTheme()), logger);
    }

    public void setTheme(IRawTheme theme) {
        this._syncRegistry.setTheme(Theme.createFromRawTheme(theme));
    }

    public Set<String> getColorMap() {
        return this._syncRegistry.getColorMap();
    }

    public IGrammar loadGrammarWithEmbeddedLanguages(String initialScopeName, int initialLanguage, Map<String, Integer> embeddedLanguages) {
        return this._loadGrammar(initialScopeName, initialLanguage, embeddedLanguages);
    }

    public IGrammar loadGrammar(String initialScopeName) {
        return this._loadGrammar(initialScopeName, 0, null);
    }

    private IGrammar _loadGrammar(String initialScopeName, int initialLanguage, Map<String, Integer> embeddedLanguages) {
        ArrayList<String> remainingScopeNames = new ArrayList<String>();
        remainingScopeNames.add(initialScopeName);
        ArrayList<String> seenScopeNames = new ArrayList<String>();
        seenScopeNames.add(initialScopeName);
        while (!remainingScopeNames.isEmpty()) {
            String scopeName = (String)remainingScopeNames.remove(0);
            if (this._syncRegistry.lookup(scopeName) != null) continue;
            String filePath = this._locator.getFilePath(scopeName);
            if (filePath == null) {
                if (!scopeName.equals(initialScopeName)) continue;
                throw new TMException("Unknown location for grammar <" + initialScopeName + ">");
            }
            try {
                InputStream in = this._locator.getInputStream(scopeName);
                IRawGrammar grammar = GrammarReader.readGrammarSync(filePath, in);
                Collection<String> injections = this._locator.getInjections(scopeName);
                Collection<String> deps = this._syncRegistry.addGrammar(grammar, injections);
                for (String dep : deps) {
                    if (seenScopeNames.contains(dep)) continue;
                    seenScopeNames.add(dep);
                    remainingScopeNames.add(dep);
                }
            }
            catch (Throwable throwable) {
                if (!scopeName.equals(initialScopeName)) continue;
                throw new TMException("Unknown location for grammar <" + initialScopeName + ">");
            }
        }
        return this.grammarForScopeName(initialScopeName);
    }

    public IGrammar loadGrammarFromPathSync(File file) throws Exception {
        return this.loadGrammarFromPathSync(file.getPath(), new FileInputStream(file));
    }

    public IGrammar loadGrammarFromPathSync(String path, InputStream in) throws Exception {
        return this.loadGrammarFromPathSync(path, in, 0, null);
    }

    public IGrammar loadGrammarFromPathSync(String path, InputStream in, int initialLanguage, Map<String, Integer> embeddedLanguages) throws Exception {
        IRawGrammar rawGrammar = GrammarReader.readGrammarSync(path, in);
        Collection<String> injections = this._locator.getInjections(rawGrammar.getScopeName());
        this._syncRegistry.addGrammar(rawGrammar, injections);
        return this.grammarForScopeName(rawGrammar.getScopeName(), initialLanguage, embeddedLanguages);
    }

    public IGrammar grammarForScopeName(String scopeName) {
        return this.grammarForScopeName(scopeName, 0, null);
    }

    public IGrammar grammarForScopeName(String scopeName, int initialLanguage, Map<String, Integer> embeddedLanguages) {
        return this._syncRegistry.grammarForScopeName(scopeName, initialLanguage, embeddedLanguages);
    }

    public IRegistryOptions getLocator() {
        return this._locator;
    }
}

