/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.history;

import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.compare.IModificationDate;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.history.AbstractHistoryCategory;
import org.eclipse.team.internal.ui.history.DateHistoryCategory;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

public class LocalHistoryTableProvider {
    static final int COL_DATE = 0;
    TreeViewer viewer;
    private Image localRevImage;
    private DateFormat dateFormat;

    private void createColumns(Tree tree, TableLayout layout) {
        SelectionAdapter headerListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int column = LocalHistoryTableProvider.this.viewer.getTree().indexOf((TreeColumn)e.widget);
                HistoryComparator oldSorter = (HistoryComparator)LocalHistoryTableProvider.this.viewer.getComparator();
                if (oldSorter != null && column == oldSorter.getColumnNumber()) {
                    oldSorter.setReversed(!oldSorter.isReversed());
                    LocalHistoryTableProvider.this.viewer.refresh();
                } else {
                    LocalHistoryTableProvider.this.viewer.setComparator((ViewerComparator)new HistoryComparator(column));
                }
            }
        };
        TreeColumn col = new TreeColumn(tree, 0);
        col.setResizable(true);
        col.setText(TeamUIMessages.GenericHistoryTableProvider_RevisionTime);
        col.addSelectionListener((SelectionListener)headerListener);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
    }

    public TreeViewer createTree(Composite parent) {
        Tree tree = new Tree(parent, 66306);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(false);
        GridData data = new GridData(1808);
        tree.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        tree.setLayout((Layout)layout);
        this.viewer = new TreeViewer(tree);
        this.createColumns(tree, layout);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LocalHistoryLabelProvider());
        HistoryComparator sorter = new HistoryComparator(0);
        sorter.setReversed(false);
        this.viewer.setComparator((ViewerComparator)sorter);
        return this.viewer;
    }

    protected long getModificationDate(Object element) {
        IModificationDate md = (IModificationDate)Adapters.adapt((Object)element, IModificationDate.class);
        if (md != null) {
            return md.getModificationDate();
        }
        if (element instanceof IFileState) {
            IFileState fs = (IFileState)element;
            return fs.getModificationTime();
        }
        if (element instanceof IFile) {
            IFile f = (IFile)element;
            return f.getLocalTimeStamp();
        }
        return -1L;
    }

    protected boolean isCurrentEdition(Object element) {
        if (element instanceof IFile) {
            return true;
        }
        if (element instanceof IFileState) {
            return false;
        }
        return false;
    }

    protected boolean isDeletedEdition(Object element) {
        if (element instanceof IFile) {
            IFile f = (IFile)element;
            return !f.exists();
        }
        return false;
    }

    public Image getRevisionImage() {
        if (this.localRevImage == null) {
            ImageDescriptor localRevDesc = TeamUIPlugin.getImageDescriptor("obj/local_entry_tbl.png");
            this.localRevImage = localRevDesc.createImage();
        }
        return this.localRevImage;
    }

    public synchronized DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = DateFormat.getInstance();
        }
        return this.dateFormat;
    }

    private class HistoryComparator
    extends ViewerComparator {
        private boolean reversed = false;
        private int columnNumber;
        private int[][] SORT_ORDERS_BY_COLUMN = new int[][]{new int[1]};

        public HistoryComparator(int columnNumber) {
            this.columnNumber = columnNumber;
        }

        public int compare(Viewer compareViewer, Object o1, Object o2) {
            long date1 = LocalHistoryTableProvider.this.getModificationDate(o1);
            long date2 = LocalHistoryTableProvider.this.getModificationDate(o2);
            int result = 0;
            if (date1 == -1L || date2 == -1L) {
                result = super.compare(compareViewer, o1, o2);
            } else {
                int[] columnSortOrder = this.SORT_ORDERS_BY_COLUMN[this.columnNumber];
                int i = 0;
                while (i < columnSortOrder.length) {
                    result = this.compareColumnValue(columnSortOrder[i], date1, date2);
                    if (result != 0) break;
                    ++i;
                }
            }
            if (this.reversed) {
                result = -result;
            }
            return result;
        }

        int compareColumnValue(int columnNumber, long date1, long date2) {
            switch (columnNumber) {
                case 0: {
                    if (date1 == date2) {
                        return 0;
                    }
                    return date1 > date2 ? -1 : 1;
                }
            }
            return 0;
        }

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public boolean isReversed() {
            return this.reversed;
        }

        public void setReversed(boolean newReversed) {
            this.reversed = newReversed;
        }
    }

    private class LocalHistoryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IColorProvider,
    IFontProvider {
        private Image dateImage;
        private Font currentRevisionFont;
        private IPropertyChangeListener themeListener = event -> LocalHistoryTableProvider.this.viewer.refresh();

        public LocalHistoryLabelProvider() {
            PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.themeListener);
        }

        public void dispose() {
            if (this.dateImage != null) {
                this.dateImage.dispose();
                this.dateImage = null;
            }
            if (LocalHistoryTableProvider.this.localRevImage != null) {
                LocalHistoryTableProvider.this.localRevImage.dispose();
                LocalHistoryTableProvider.this.localRevImage = null;
            }
            if (this.themeListener != null) {
                PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.themeListener);
            }
            if (this.currentRevisionFont != null) {
                this.currentRevisionFont.dispose();
            }
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof DateHistoryCategory) {
                    if (this.dateImage == null) {
                        ImageDescriptor dateDesc = TeamUIPlugin.getImageDescriptor("obj/dates.png");
                        this.dateImage = dateDesc.createImage();
                    }
                    return this.dateImage;
                }
                if (LocalHistoryTableProvider.this.getModificationDate(element) != -1L) {
                    return LocalHistoryTableProvider.this.getRevisionImage();
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof AbstractHistoryCategory) {
                    return ((AbstractHistoryCategory)element).getName();
                }
                long date = LocalHistoryTableProvider.this.getModificationDate(element);
                if (date != -1L) {
                    Date dateFromLong = new Date(date);
                    return LocalHistoryTableProvider.this.getDateFormat().format(dateFromLong);
                }
            }
            return "";
        }

        public Color getForeground(Object element) {
            if (element instanceof AbstractHistoryCategory) {
                ITheme current = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
                return current.getColorRegistry().get("org.eclipse.team.cvs.ui.fontsandcolors.cvshistorypagecategories");
            }
            if (LocalHistoryTableProvider.this.isDeletedEdition(element)) {
                return Display.getCurrent().getSystemColor(18);
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Font getFont(Object element) {
            if (element instanceof AbstractHistoryCategory) {
                return this.getCurrentRevisionFont();
            }
            if (LocalHistoryTableProvider.this.isCurrentEdition(element)) {
                return this.getCurrentRevisionFont();
            }
            return null;
        }

        private Font getCurrentRevisionFont() {
            if (this.currentRevisionFont == null) {
                FontData[] data;
                Font defaultFont = JFaceResources.getDefaultFont();
                FontData[] fontDataArray = data = defaultFont.getFontData();
                int n = data.length;
                int n2 = 0;
                while (n2 < n) {
                    FontData d = fontDataArray[n2];
                    d.setStyle(1);
                    ++n2;
                }
                this.currentRevisionFont = new Font((Device)LocalHistoryTableProvider.this.viewer.getTree().getDisplay(), data);
            }
            return this.currentRevisionFont;
        }
    }
}

