/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.task;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskRun;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.actions.datasource.DataSourceMenuContributor;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.task.TaskHandlerRun;

public class RecentTasksMenuContributor
extends DataSourceMenuContributor {
    private static final Log log = Log.getLog(RecentTasksMenuContributor.class);
    private static final int MAX_ITEMS = 5;

    @Override
    protected void fillContributionItems(List<IContributionItem> menuItems) {
        DBPProject project = NavigatorUtils.getSelectedProject();
        if (project == null) {
            return;
        }
        DBTTask[] tasks = project.getTaskManager().getTaskConfigurations();
        Arrays.sort(tasks, (o1, o2) -> {
            DBTTaskRun lr2;
            DBTTaskRun lr1 = o1.getLastRun();
            if (lr1 == (lr2 = o1.getLastRun())) {
                return o1.getCreateTime().compareTo(o2.getCreateTime());
            }
            if (lr1 == null) {
                return -1;
            }
            if (lr2 == null) {
                return 1;
            }
            return lr1.getStartTime().compareTo(lr2.getStartTime());
        });
        int i = 0;
        while (i < tasks.length && i <= 5) {
            final DBTTask task = tasks[i];
            DBPImage taskIcon = task.getType().getIcon();
            if (taskIcon == null) {
                taskIcon = DBIcon.TREE_TASK;
            }
            menuItems.add((IContributionItem)ActionUtils.makeActionContribution((IAction)new Action(task.getName(), DBeaverIcons.getImageDescriptor((DBPImage)taskIcon)){

                public void run() {
                    TaskHandlerRun.runTask(task);
                }
            }, (boolean)false));
            ++i;
        }
    }
}

