/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm.meta;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCParameterizedStatement;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSavepoint;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.utils.CommonUtils;

public class QMMSessionInfo
extends QMMObject {
    private final String containerId;
    private final String containerName;
    private final String driverId;
    @Nullable
    private final DBPConnectionConfiguration connectionConfiguration;
    private final String instanceId;
    private final String contextName;
    @Nullable
    private SQLDialect sqlDialect;
    private boolean transactional;
    private QMMStatementInfo statementStack;
    private QMMStatementExecuteInfo executionStack;
    private QMMTransactionInfo transaction;

    public QMMSessionInfo(DBCExecutionContext context, boolean transactional) {
        this.containerId = context.getDataSource().getContainer().getId();
        this.containerName = context.getDataSource().getContainer().getName();
        this.driverId = context.getDataSource().getContainer().getDriver().getId();
        this.connectionConfiguration = context.getDataSource().getContainer().getConnectionConfiguration();
        this.instanceId = context.getOwnerInstance().getName();
        this.contextName = context.getContextName();
        if (context.getDataSource() instanceof SQLDataSource) {
            this.sqlDialect = ((SQLDataSource)context.getDataSource()).getSQLDialect();
        }
        this.transactional = transactional;
        if (transactional) {
            this.transaction = new QMMTransactionInfo(this, null);
        }
    }

    public QMMSessionInfo(long openTime, long closeTime, String containerId, String containerName, String driverId, DBPConnectionConfiguration connectionConfiguration, String instanceID, String contextName, boolean transactional) {
        super(openTime, closeTime);
        this.containerId = containerId;
        this.containerName = containerName;
        this.driverId = driverId;
        this.connectionConfiguration = connectionConfiguration;
        this.instanceId = instanceID;
        this.contextName = contextName;
        this.transactional = transactional;
    }

    @Override
    public void close() {
        if (this.transaction != null) {
            this.transaction.rollback(null);
        }
        QMMStatementInfo stat = this.statementStack;
        while (stat != null) {
            if (!stat.isClosed()) {
                DBCStatement statRef = stat.getReference();
                String query = statRef == null ? "?" : statRef.getQueryString();
                log.warn("Statement " + stat.getObjectId() + " (" + query + ") is not closed");
                stat.close();
            }
            stat = stat.getPrevious();
        }
        super.close();
    }

    @Override
    public void reopen() {
        super.reopen();
    }

    @Override
    public String getText() {
        return String.valueOf(this.containerName) + " - " + this.contextName;
    }

    public QMMTransactionInfo changeTransactional(boolean transactional) {
        if (this.transactional == transactional) {
            return null;
        }
        this.transactional = transactional;
        if (this.transaction != null) {
            this.transaction.commit();
        }
        this.transaction = new QMMTransactionInfo(this, this.transaction);
        return this.transaction.getPrevious();
    }

    public QMMTransactionInfo commit() {
        if (this.transactional) {
            if (this.transaction != null) {
                this.transaction.commit();
            }
            this.transaction = new QMMTransactionInfo(this, this.transaction);
            return this.transaction.getPrevious();
        }
        return null;
    }

    public QMMObject rollback(DBCSavepoint savepoint) {
        if (this.transactional) {
            if (this.transaction != null) {
                this.transaction.rollback(savepoint);
            }
            if (savepoint == null) {
                this.transaction = new QMMTransactionInfo(this, this.transaction);
                return this.transaction.getPrevious();
            }
            if (this.transaction != null) {
                return this.transaction.getSavepoint(savepoint);
            }
        }
        return null;
    }

    public QMMStatementInfo openStatement(DBCStatement statement) {
        this.statementStack = new QMMStatementInfo(this, statement, this.statementStack);
        return this.statementStack;
    }

    public QMMStatementInfo closeStatement(DBCStatement statement, long rows) {
        QMMStatementExecuteInfo execution = this.getExecution(statement);
        if (execution != null && execution.getUpdateRowCount() < 0L) {
            execution.close(rows, null);
        }
        QMMStatementInfo stat = this.statementStack;
        while (stat != null) {
            if (stat.getReference() == statement) {
                stat.close();
                return stat;
            }
            stat = stat.getPrevious();
        }
        log.warn("Statement " + statement + " meta info not found");
        return null;
    }

    public QMMStatementInfo getStatement(DBCStatement statement) {
        QMMStatementInfo stat = this.statementStack;
        while (stat != null) {
            if (stat.getReference() == statement) {
                return stat;
            }
            stat = stat.getPrevious();
        }
        log.warn("Statement " + statement + " meta info not found");
        return null;
    }

    public QMMStatementExecuteInfo getExecution(DBCStatement statement) {
        QMMStatementExecuteInfo exec = this.executionStack;
        while (exec != null) {
            if (exec.getStatement().getReference() == statement) {
                return exec;
            }
            exec = exec.getPrevious();
        }
        return null;
    }

    public QMMStatementExecuteInfo beginExecution(DBCStatement statement) {
        QMMStatementInfo stat = this.getStatement(statement);
        if (stat != null) {
            String queryString = statement instanceof DBCParameterizedStatement ? ((DBCParameterizedStatement)statement).getFormattedQuery() : statement.getQueryString();
            QMMTransactionSavepointInfo savepoint = this.isTransactional() && this.getTransaction() != null ? this.getTransaction().getCurrentSavepoint() : null;
            this.executionStack = new QMMStatementExecuteInfo(stat, savepoint, queryString, this.executionStack);
            return this.executionStack;
        }
        return null;
    }

    public QMMStatementExecuteInfo endExecution(DBCStatement statement, long rowCount, Throwable error) {
        QMMStatementExecuteInfo exec = this.getExecution(statement);
        if (exec != null) {
            exec.close(rowCount, error);
        }
        return exec;
    }

    public QMMStatementExecuteInfo beginFetch(DBCResultSet resultSet) {
        QMMStatementExecuteInfo exec = this.getExecution(resultSet.getSourceStatement());
        if (exec == null) {
            exec = this.beginExecution(resultSet.getSourceStatement());
        }
        if (exec != null) {
            exec.beginFetch();
        }
        return exec;
    }

    public QMMStatementExecuteInfo endFetch(DBCResultSet resultSet, long rowCount) {
        QMMStatementExecuteInfo exec = this.getExecution(resultSet.getSourceStatement());
        if (exec != null) {
            exec.endFetch(rowCount);
        }
        return exec;
    }

    public String getContainerId() {
        return this.containerId;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getDriverId() {
        return this.driverId;
    }

    public DBPConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getContextName() {
        return this.contextName;
    }

    public QMMStatementInfo getStatementStack() {
        return this.statementStack;
    }

    public QMMTransactionInfo getTransaction() {
        return this.transaction;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public SQLDialect getSQLDialect() {
        return this.sqlDialect;
    }

    public String toString() {
        return "SESSION " + this.containerName + " [" + this.contextName + "]";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QMMSessionInfo)) {
            return false;
        }
        QMMSessionInfo si = (QMMSessionInfo)obj;
        return CommonUtils.equalObjects((Object)this.containerId, (Object)si.containerId) && CommonUtils.equalObjects((Object)this.contextName, (Object)si.contextName);
    }
}

