/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.impl.DataSourceContextProvider;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryParameter;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.ui.UIServiceSQL;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.ui.controls.TableColumnSortListener;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.ui.editors.sql.registry.SQLQueryParameterRegistry;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class SQLQueryParameterBindDialog
extends StatusDialog {
    private static final String DIALOG_ID = "DBeaver.SQLQueryParameterBindDialog";
    private static final String PARAM_HIDE_IF_SET = "PARAM_HIDE_IF_SET";
    private static final Log log = Log.getLog(SQLQueryParameterBindDialog.class);
    private IWorkbenchPartSite site;
    private SQLQuery query;
    private List<SQLQueryParameter> parameters;
    private final Map<String, List<SQLQueryParameter>> dupParameters = new HashMap<String, List<SQLQueryParameter>>();
    private static Map<String, SQLQueryParameterRegistry.ParameterInfo> savedParamValues = new HashMap<String, SQLQueryParameterRegistry.ParameterInfo>();
    private Button hideIfSetCheck;
    private Table paramTable;

    public SQLQueryParameterBindDialog(IWorkbenchPartSite site, SQLQuery query, List<SQLQueryParameter> parameters) {
        super(site.getShell());
        this.site = site;
        this.query = query;
        this.parameters = parameters;
        SQLQueryParameterRegistry registry = SQLQueryParameterRegistry.getInstance();
        for (SQLQueryParameter param : this.parameters) {
            SQLQueryParameterRegistry.ParameterInfo paramInfo;
            if (!param.isNamed() || param.getValue() != null || (paramInfo = registry.getParameter(param.getName())) == null) continue;
            param.setValue(paramInfo.value);
        }
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected boolean isResizable() {
        return true;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(SQLEditorMessages.dialog_sql_param_title);
        Composite composite = (Composite)super.createDialogArea(parent);
        SashForm sash = new SashForm(composite, 512);
        sash.setLayoutData((Object)new GridData(1808));
        Composite paramsComposite = UIUtils.createComposite((Composite)sash, (int)1);
        this.paramTable = new Table(paramsComposite, 68356);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 200;
        this.paramTable.setLayoutData((Object)gd);
        this.paramTable.setHeaderVisible(true);
        this.paramTable.setLinesVisible(true);
        TableColumn indexColumn = UIUtils.createTableColumn((Table)this.paramTable, (int)16384, (String)"#");
        indexColumn.addListener(13, (Listener)new TableColumnSortListener(this.paramTable, 0));
        indexColumn.setWidth(40);
        TableColumn nameColumn = UIUtils.createTableColumn((Table)this.paramTable, (int)16384, (String)SQLEditorMessages.dialog_sql_param_column_name);
        nameColumn.addListener(13, (Listener)new TableColumnSortListener(this.paramTable, 1));
        nameColumn.setWidth(100);
        TableColumn valueColumn = UIUtils.createTableColumn((Table)this.paramTable, (int)16384, (String)SQLEditorMessages.dialog_sql_param_column_value);
        valueColumn.setWidth(200);
        this.fillParameterList(SQLQueryParameterBindDialog.isHideIfSet());
        CustomTableEditor tableEditor = new CustomTableEditor(this.paramTable){
            {
                this.firstTraverseIndex = 2;
                this.lastTraverseIndex = 2;
                this.editOnEnter = false;
            }

            protected Control createEditor(Table table, int index, TableItem item) {
                if (index != 2) {
                    return null;
                }
                SQLQueryParameter param = (SQLQueryParameter)item.getData();
                Text editor = new Text((Composite)table, 2048);
                editor.setText(CommonUtils.notEmpty((String)param.getValue()));
                editor.selectAll();
                editor.addTraverseListener(e -> {
                    if (e.detail == 4 && (e.stateMask & 0x40000) == 262144) {
                        UIUtils.asyncExec(SQLQueryParameterBindDialog.this::okPressed);
                    }
                });
                return editor;
            }

            protected void saveEditorValue(Control control, int index, TableItem item) {
                List dups;
                SQLQueryParameter param = (SQLQueryParameter)item.getData();
                String newValue = ((Text)control).getText();
                item.setText(2, newValue);
                param.setValue(newValue);
                if (param.isNamed() && (dups = (List)SQLQueryParameterBindDialog.this.dupParameters.get(param.getName())) != null) {
                    for (SQLQueryParameter dup : dups) {
                        dup.setValue(newValue);
                    }
                }
                savedParamValues.put(param.getName().toUpperCase(Locale.ENGLISH), new SQLQueryParameterRegistry.ParameterInfo(param.getName(), newValue));
            }
        };
        if (!this.parameters.isEmpty()) {
            UIUtils.asyncExec(() -> {
                this.paramTable.select(0);
                tableEditor.showEditor(this.paramTable.getItem(0), 2);
            });
        }
        Composite queryComposite = new Composite((Composite)sash, 2048);
        queryComposite.setLayout((Layout)new FillLayout());
        try {
            ((UIServiceSQL)DBWorkbench.getService(UIServiceSQL.class)).createSQLPanel((Object)this.site, (Object)queryComposite, (DBPContextProvider)new DataSourceContextProvider((DBSObject)this.query.getDataSource()), "Query preview", false, this.query.getText());
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        sash.setWeights(new int[]{600, 400});
        this.hideIfSetCheck = UIUtils.createCheckbox((Composite)composite, (String)SQLEditorMessages.dialog_sql_param_hide_checkbox, (String)SQLEditorMessages.dialog_sql_param_hide_checkbox_tip, (boolean)SQLQueryParameterBindDialog.isHideIfSet(), (int)1);
        this.hideIfSetCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLQueryParameterBindDialog.this.fillParameterList(SQLQueryParameterBindDialog.this.hideIfSetCheck.getSelection());
            }
        });
        this.updateStatus(GeneralUtils.makeInfoStatus((String)SQLEditorMessages.dialog_sql_param_hint));
        return composite;
    }

    private void fillParameterList(boolean hideVariables) {
        this.paramTable.removeAll();
        for (SQLQueryParameter param : this.parameters) {
            if (hideVariables && param.isVariableSet()) continue;
            if (param.getPrevious() != null) {
                List dups = this.dupParameters.computeIfAbsent(param.getName(), k -> new ArrayList());
                dups.add(param);
                continue;
            }
            TableItem item = new TableItem(this.paramTable, 0);
            item.setData((Object)param);
            item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_ATTRIBUTE));
            item.setText(0, String.valueOf(param.getOrdinalPosition() + 1));
            item.setText(1, param.getVarName());
            item.setText(2, CommonUtils.notEmpty((String)param.getValue()));
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button skipButton = UIUtils.createDialogButton((Composite)parent, (String)IDialogConstants.IGNORE_LABEL, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLQueryParameterBindDialog.this.setReturnCode(9);
                SQLQueryParameterBindDialog.this.close();
            }
        });
        skipButton.setToolTipText("Ignore parameters and execute query/script as is");
        ++((GridLayout)parent.getLayout()).numColumns;
        super.createButtonsForButtonBar(parent);
    }

    protected void okPressed() {
        SQLQueryParameterRegistry registry = SQLQueryParameterRegistry.getInstance();
        for (SQLQueryParameterRegistry.ParameterInfo param : savedParamValues.values()) {
            registry.setParameter(param.name, param.value);
        }
        registry.save();
        if (this.hideIfSetCheck != null) {
            this.getDialogBoundsSettings().put(PARAM_HIDE_IF_SET, this.hideIfSetCheck.getSelection());
        }
        super.okPressed();
    }

    public static boolean isHideIfSet() {
        return UIUtils.getDialogSettings((String)DIALOG_ID).getBoolean(PARAM_HIDE_IF_SET);
    }
}

