#!/bin/bash
# vim: set tabstop=8 shiftwidth=4 softtabstop=4 expandtab smarttab colorcolumn=80:
#
# Copyright (c) 2016 Red Hat, Inc.
# Author: Nathaniel McCallum <npmccallum@redhat.com>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

depends() {
    echo crypt systemd network
    return 0
}

cmdline() {
    echo "rd.neednet=1"
}

install() {
    local ret=0

    cmdline > "${initdir}/etc/cmdline.d/99clevis.conf"

    inst_hook initqueue/online 60 "$moddir/clevis-hook.sh"
    inst_hook initqueue/settled 60 "$moddir/clevis-hook.sh"

    inst_multiple /etc/services \
        clevis-decrypt-tang \
        clevis-decrypt-sss \
        /usr/lib/clevis-luks-askpass \
        clevis-decrypt \
        cryptsetup \
        luksmeta \
        clevis \
        mktemp \
        curl \
        jose \
        ncat

    for cmd in clevis-decrypt-tpm2 \
	tpm2_createprimary \
	tpm2_unseal \
	tpm2_load; do

	if ! find_binary "$cmd" &>/dev/null; then
	    ((ret++))
	fi
    done
    if ! find_binary tpm2_pcrread &>/dev/null && ! find_binary tpm2_pcrread &>/dev/null; then
        ((ret++))
    fi

    if (($ret == 0)); then
	inst_multiple clevis-decrypt-tpm2 \
	    tpm2_createprimary \
	    tpm2_unseal \
	    tpm2_load
	inst_multiple -o tpm2_pcrread tpm2_pcrlist
	inst_libdir_file "libtss2-tcti-device.so*"
    fi

    dracut_need_initqueue
}

installkernel() {
    hostonly='' instmods =drivers/char/tpm
}
